/*
 * Copyright 2002-2017 Drew Noakes
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 *
 * More information about this project is available at:
 *
 *    https://drewnoakes.com/code/exif/
 *    https://github.com/drewnoakes/metadata-extractor
 */

package com.drew.metadata.adobe;

import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;

import static com.drew.metadata.adobe.AdobeJpegDirectory.*;

/**
 * Provides human-readable string versions of the tags stored in an AdobeJpegDirectory.
 */
@SuppressWarnings("WeakerAccess")
public class AdobeJpegDescriptor extends TagDescriptor<AdobeJpegDirectory>
{
    public AdobeJpegDescriptor(AdobeJpegDirectory directory)
    {
        super(directory);
    }

    @Override
    public String getDescription(int tagType)
    {
        switch (tagType) {
            case TAG_COLOR_TRANSFORM:
                return getColorTransformDescription();
            case TAG_DCT_ENCODE_VERSION:
                return getDctEncodeVersionDescription();
            default:
                return super.getDescription(tagType);
        }
    }

    @Nullable
    private String getDctEncodeVersionDescription()
    {
        Integer value = _directory.getInteger(TAG_DCT_ENCODE_VERSION);
        return value == null
                ? null
                : value == 0x64
                    ? "100"
                    : Integer.toString(value);
    }

    @Nullable
    private String getColorTransformDescription()
    {
        return getIndexedDescription(TAG_COLOR_TRANSFORM,
            "Unknown (RGB or CMYK)",
            "YCbCr",
            "YCCK");
    }
}
