package Locales::DB::Territory::th;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Territory::th::VERSION = '0.09';

$Locales::DB::Territory::th::cldr_version = '2.0';

%Locales::DB::Territory::th::code_to_name = (
    '001' => 'โลก',
    '002' => 'แอฟริกา',
    '003' => 'อเมริกาเหนือ',
    '005' => 'อเมริกาใต้',
    '009' => 'โอเชียเนีย',
    '011' => 'แอฟริกาตะวันตก',
    '013' => 'อเมริกากลาง',
    '014' => 'แอฟริกาตะวันออก',
    '015' => 'แอฟริกาเหนือ',
    '017' => 'แอฟริกากลาง',
    '018' => "แอฟริกาใต้\ \[018\]",
    '019' => 'อเมริกา',
    '021' => 'อเมริกาตอนเหนือ',
    '029' => 'แคริบเบียน',
    '030' => 'เอเชียตะวันออก',
    '034' => 'เอเชียใต้',
    '035' => 'เอเชียตะวันออกเฉียงใต้',
    '039' => 'ยุโรปใต้',
    '053' => 'ออสเตรเลียและนิวซีแลนด์',
    '054' => 'เมลานีเซีย',
    '057' => 'เขตไมโครนีเซีย',
    '061' => 'โปลินีเซีย',
    '062' => 'เอเชียกลางตอนใต้',
    142   => 'เอเชีย',
    143   => 'เอเชียกลาง',
    145   => 'เอเชียตะวันตก',
    150   => 'ยุโรป',
    151   => 'ยุโรปตะวันออก',
    154   => 'ยุโรปเหนือ',
    155   => 'ยุโรปตะวันตก',
    172   => 'เครือรัฐอิสระ',
    200   => 'Czechoslovakia',
    419   => 'ละตินอเมริกาและแคริบเบียน',
    830   => 'หมู่เกาะแชนเนล',
    'ac'  => 'เกาะแอสเซนชัน',
    'ad'  => 'อันดอร์รา',
    'ae'  => 'สหรัฐอาหรับเอมิเรตส์',
    'af'  => 'อัฟกานิสถาน',
    'ag'  => 'แอนติกาและบาร์บูดา',
    'ai'  => 'แองกวิลลา',
    'al'  => 'แอลเบเนีย',
    'am'  => 'อาร์เมเนีย',
    'an'  => 'เนเธอร์แลนด์แอนทิลลิส',
    'ao'  => 'แองโกลา',
    'aq'  => 'แอนตาร์กติกา',
    'ar'  => 'อาร์เจนตินา',
    'as'  => 'อเมริกันซามัว',
    'at'  => 'ออสเตรีย',
    'au'  => 'ออสเตรเลีย',
    'aw'  => 'อารูบา',
    'ax'  => 'หมู่เกาะโอลันด์',
    'az'  => 'อาเซอร์ไบจาน',
    'ba'  => 'บอสเนียและเฮอร์เซโกวีนา',
    'bb'  => 'บาร์เบโดส',
    'bd'  => 'บังกลาเทศ',
    'be'  => 'เบลเยียม',
    'bf'  => 'บูร์กินาฟาโซ',
    'bg'  => 'บัลแกเรีย',
    'bh'  => 'บาห์เรน',
    'bi'  => 'บุรุนดี',
    'bj'  => 'เบนิน',
    'bl'  => 'เซนต์บาร์เธเลมี',
    'bm'  => 'เบอร์มิวดา',
    'bn'  => 'บรูไน',
    'bo'  => 'โบลิเวีย',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'บราซิล',
    'bs'  => 'บาฮามาส',
    'bt'  => 'ภูฏาน',
    'bv'  => 'เกาะบูเวต',
    'bw'  => 'บอตสวานา',
    'by'  => 'เบลารุส',
    'bz'  => 'เบลีซ',
    'ca'  => 'แคนาดา',
    'cc'  => 'หมู่เกาะโคโคส',
    'cd'  => "คองโก\ \[สาธารณรัฐประชาธิปไตย\]",
    'cf'  => 'สาธารณรัฐแอฟริกากลาง',
    'cg'  => "คองโก\ \[สาธารณรัฐ\]",
    'ch'  => 'สวิตเซอร์แลนด์',
    'ci'  => 'ไอวอรี่โคสต์',
    'ck'  => 'หมู่เกาะคุก',
    'cl'  => 'ชิลี',
    'cm'  => 'แคเมอรูน',
    'cn'  => 'จีน',
    'co'  => 'โคลอมเบีย',
    'cp'  => 'เกาะคลิปเปอร์ตัน',
    'cr'  => 'คอสตาริกา',
    'cs'  => 'เซอร์เบียและมอนเตเนโกร',
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'คิวบา',
    'cv'  => 'เคปเวิร์ด',
    'cx'  => 'เกาะคริสต์มาส',
    'cy'  => 'ไซปรัส',
    'cz'  => 'สาธารณรัฐเช็ก',
    'dd'  => "East\ Germany",
    'de'  => 'เยอรมนี',
    'dg'  => 'ดิเอโกการ์เซีย',
    'dj'  => 'จิบูตี',
    'dk'  => 'เดนมาร์ก',
    'dm'  => 'โดมินิกา',
    'do'  => 'สาธารณรัฐโดมินิกัน',
    'dz'  => 'แอลจีเรีย',
    'ea'  => 'ซีโอตาและเมลิลลา',
    'ec'  => 'เอกวาดอร์',
    'ee'  => 'เอสโตเนีย',
    'eg'  => 'อียิปต์',
    'eh'  => 'ซาฮาราตะวันตก',
    'er'  => 'เอริเทรีย',
    'es'  => 'สเปน',
    'et'  => 'เอธิโอเปีย',
    'eu'  => 'สหภาพยุโรป',
    'fi'  => 'ฟินแลนด์',
    'fj'  => 'ฟิจิ',
    'fk'  => "หมู่เกาะฟอล์กแลนด์\ \[อิสลาส\ มาลวินาส\]",
    'fm'  => 'ไมโครนีเซีย',
    'fo'  => 'หมู่เกาะแฟโร',
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'ฝรั่งเศส',
    'fx'  => 'มหานครฝรั่งเศส',
    'ga'  => 'กาบอง',
    'gb'  => 'สหราชอาณาจักร',
    'gd'  => 'เกรเนดา',
    'ge'  => 'จอร์เจีย',
    'gf'  => 'เฟรนช์เกียนา',
    'gg'  => 'เกิร์นซีย์',
    'gh'  => 'กานา',
    'gi'  => 'ยิบรอลตาร์',
    'gl'  => 'กรีนแลนด์',
    'gm'  => 'แกมเบีย',
    'gn'  => 'กินี',
    'gp'  => 'กวาเดอลูป',
    'gq'  => 'อิเควทอเรียลกินี',
    'gr'  => 'กรีซ',
    'gs'  => 'เกาะเซาท์จอร์เจียและหมู่เกาะเซาท์แซนด์วิช',
    'gt'  => 'กัวเตมาลา',
    'gu'  => 'กวม',
    'gw'  => "กินี\-บิสเซา",
    'gy'  => 'กายอานา',
    'hk'  => 'ฮ่องกง',
    'hm'  => 'เกาะเฮิร์ดและหมู่เกาะแมกดอนัลด์',
    'hn'  => 'ฮอนดูรัส',
    'hr'  => 'โครเอเชีย',
    'ht'  => 'เฮติ',
    'hu'  => 'ฮังการี',
    'ic'  => 'หมู่เกาะคานารี',
    'id'  => 'อินโดนีเซีย',
    'ie'  => 'ไอร์แลนด์',
    'il'  => 'อิสราเอล',
    'im'  => 'เกาะแมน',
    'in'  => 'อินเดีย',
    'io'  => 'บริติชอินเดียนโอเชียนเทร์ริทอรี',
    'iq'  => 'อิรัก',
    'ir'  => 'อิหร่าน',
    'is'  => 'ไอซ์แลนด์',
    'it'  => 'อิตาลี',
    'je'  => 'เจอร์ซีย์',
    'jm'  => 'จาเมกา',
    'jo'  => 'จอร์แดน',
    'jp'  => 'ญี่ปุ่น',
    'jt'  => "Johnston\ Island",
    'ke'  => 'เคนยา',
    'kg'  => 'คีร์กีซสถาน',
    'kh'  => 'กัมพูชา',
    'ki'  => 'คิริบาส',
    'km'  => 'คอโมโรส',
    'kn'  => 'เซนต์คิตส์และเนวิส',
    'kp'  => 'เกาหลีเหนือ',
    'kr'  => 'เกาหลีใต้',
    'kw'  => 'คูเวต',
    'ky'  => 'หมู่เกาะเคย์แมน',
    'kz'  => 'คาซัคสถาน',
    'la'  => 'ลาว',
    'lb'  => 'เลบานอน',
    'lc'  => 'เซนต์ลูเซีย',
    'li'  => 'ลิกเตนสไตน์',
    'lk'  => 'ศรีลังกา',
    'lr'  => 'ไลบีเรีย',
    'ls'  => 'เลโซโท',
    'lt'  => 'ลิทัวเนีย',
    'lu'  => 'ลักเซมเบิร์ก',
    'lv'  => 'ลัตเวีย',
    'ly'  => 'ลิเบีย',
    'ma'  => 'โมร็อกโก',
    'mc'  => 'โมนาโก',
    'md'  => 'มอลโดวา',
    'me'  => 'มอนเตเนโกร',
    'mf'  => 'เซนต์มาติน',
    'mg'  => 'มาดากัสการ์',
    'mh'  => 'หมู่เกาะมาร์แชลล์',
    'mi'  => "Midway\ Islands",
    'mk'  => 'มาซิโดเนีย',
    'ml'  => 'มาลี',
    'mm'  => "เมียนม่าร์\ \[พม่า\]",
    'mn'  => 'มองโกเลีย',
    'mo'  => 'มาเก๊า',
    'mp'  => 'หมู่เกาะนอร์เทิร์นมาเรียนา',
    'mq'  => 'มาร์ตินีก',
    'mr'  => 'มอริเตเนีย',
    'ms'  => 'มอนต์เซอร์รัต',
    'mt'  => 'มอลตา',
    'mu'  => 'มอริเชียส',
    'mv'  => 'มัลดีฟส์',
    'mw'  => 'มาลาวี',
    'mx'  => 'เม็กซิโก',
    'my'  => 'มาเลเซีย',
    'mz'  => 'โมซัมบิก',
    'na'  => 'นามิเบีย',
    'nc'  => 'นิวแคลิโดเนีย',
    'ne'  => 'ไนเจอร์',
    'nf'  => 'เกาะนอร์ฟอล์ก',
    'ng'  => 'ไนจีเรีย',
    'ni'  => 'นิการากัว',
    'nl'  => 'เนเธอร์แลนด์',
    'no'  => 'นอร์เวย์',
    'np'  => 'เนปาล',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'นาอูรู',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'นีอูเอ',
    'nz'  => 'นิวซีแลนด์',
    'om'  => 'โอมาน',
    'pa'  => 'ปานามา',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'เปรู',
    'pf'  => 'เฟรนช์โปลินีเซีย',
    'pg'  => 'ปาปัวนิวกินี',
    'ph'  => 'ฟิลิปปินส์',
    'pk'  => 'ปากีสถาน',
    'pl'  => 'โปแลนด์',
    'pm'  => 'แซงปีแยร์และมีเกอลง',
    'pn'  => 'พิตแคร์น',
    'pr'  => 'เปอร์โตริโก',
    'ps'  => 'ปาเลสไตน์',
    'pt'  => 'โปรตุเกส',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'ปาเลา',
    'py'  => 'ปารากวัย',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'กาตาร์',
    'qo'  => 'เอาต์ไลอิงโอเชียเนีย',
    're'  => 'เรอูนียง',
    'ro'  => 'โรมาเนีย',
    'rs'  => 'เซอร์เบีย',
    'ru'  => 'รัสเซีย',
    'rw'  => 'รวันดา',
    'sa'  => 'ซาอุดีอาระเบีย',
    'sb'  => 'หมู่เกาะโซโลมอน',
    'sc'  => 'เซเชลส์',
    'sd'  => 'ซูดาน',
    'se'  => 'สวีเดน',
    'sg'  => 'สิงคโปร์',
    'sh'  => 'เซนต์เฮเลนา',
    'si'  => 'สโลวีเนีย',
    'sj'  => 'สฟาลบาร์และยานไมเอน',
    'sk'  => 'สโลวะเกีย',
    'sl'  => 'เซียร์ราลีโอน',
    'sm'  => 'ซานมารีโน',
    'sn'  => 'เซเนกัล',
    'so'  => 'โซมาเลีย',
    'sr'  => 'ซูรินาเม',
    'st'  => 'เซาตูเมและปรินซิปี',
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'เอลซัลวาดอร์',
    'sy'  => 'ซีเรีย',
    'sz'  => 'สวาซิแลนด์',
    'ta'  => "ทริสตัน\ เดอ\ คูนา",
    'tc'  => 'หมู่เกาะเติกส์และหมู่เกาะเคคอส',
    'td'  => 'ชาด',
    'tf'  => 'เฟรนช์เซาเทิร์นเทร์ริทอรีส์',
    'tg'  => 'โตโก',
    'th'  => 'ไทย',
    'tj'  => 'ทาจิกิสถาน',
    'tk'  => 'โตเกเลา',
    'tl'  => 'ติมอร์ตะวันออก',
    'tm'  => 'เติร์กเมนิสถาน',
    'tn'  => 'ตูนิเซีย',
    'to'  => 'ตองกา',
    'tr'  => 'ตุรกี',
    'tt'  => 'ตรินิแดดและโตเบโก',
    'tv'  => 'ตูวาลู',
    'tw'  => 'ไต้หวัน',
    'tz'  => 'แทนซาเนีย',
    'ua'  => 'ยูเครน',
    'ug'  => 'ยูกันดา',
    'um'  => 'หมู่เกาะสหรัฐไมเนอร์เอาต์ไลอิง',
    'us'  => 'สหรัฐอเมริกา',
    'uy'  => 'อุรุกวัย',
    'uz'  => 'อุซเบกิสถาน',
    'va'  => 'วาติกัน',
    'vc'  => 'เซนต์วินเซนต์และเกรนาดีนส์',
    'vd'  => "North\ Vietnam",
    've'  => 'เวเนซุเอลา',
    'vg'  => 'หมู่เกาะบริติชเวอร์จิน',
    'vi'  => 'หมู่เกาะยูเอสเวอร์จิน',
    'vn'  => 'เวียดนาม',
    'vu'  => 'วานูอาตู',
    'wf'  => 'วาลลิสและฟุตูนา',
    'wk'  => "Wake\ Island",
    'ws'  => 'ซามัว',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'เยเมน',
    'yt'  => 'มายอต',
    'za'  => 'แอฟริกาใต้',
    'zm'  => 'แซมเบีย',
    'zw'  => 'ซิมบับเว',
    'zz'  => 'ไม่ทราบ',
);

%Locales::DB::Territory::th::name_to_code = (
    'britishantarcticterritory'                                                                                                   => 'bq',
    'cantonandenderburyislands'                                                                                                   => 'ct',
    'czechoslovakia'                                                                                                              => 200,
    'dronningmaudland'                                                                                                            => 'nq',
    'eastgermany'                                                                                                                 => 'dd',
    'frenchsouthernandantarcticterritories'                                                                                       => 'fq',
    'johnstonisland'                                                                                                              => 'jt',
    'midwayislands'                                                                                                               => 'mi',
    'neutralzone'                                                                                                                 => 'nt',
    'northvietnam'                                                                                                                => 'vd',
    'pacificislandstrustterritory'                                                                                                => 'pc',
    'panamacanalzone'                                                                                                             => 'pz',
    "people\â\\sdemocraticrepublicofyemen"                                                                                   => 'yd',
    "u\.s\.miscellaneouspacificislands"                                                                                           => 'pu',
    'unionofsovietsocialistrepublics'                                                                                             => 'su',
    'wakeisland'                                                                                                                  => 'wk',
    'กรีซ'                                                                                                                => 'gr',
    'กรีนแลนด์'                                                                                                 => 'gl',
    'กวม'                                                                                                                   => 'gu',
    'กวาเดอลูป'                                                                                                 => 'gp',
    'กัมพูชา'                                                                                                       => 'kh',
    'กัวเตมาลา'                                                                                                 => 'gt',
    'กาตาร์'                                                                                                          => 'qa',
    'กานา'                                                                                                                => 'gh',
    'กาบอง'                                                                                                             => 'ga',
    'กายอานา'                                                                                                       => 'gy',
    'กินี'                                                                                                                => 'gn',
    'กินีบิสเซา'                                                                                              => 'gw',
    'คองโกสาธารณรัฐ'                                                                                  => 'cg',
    'คองโกสาธารณรัฐประชาธิปไตย'                                                 => 'cd',
    'คอสตาริกา'                                                                                                 => 'cr',
    'คอโมโรส'                                                                                                       => 'km',
    'คาซัคสถาน'                                                                                                 => 'kz',
    'คิริบาส'                                                                                                       => 'ki',
    'คิวบา'                                                                                                             => 'cu',
    'คีร์กีซสถาน'                                                                                           => 'kg',
    'คูเวต'                                                                                                             => 'kw',
    'จอร์เจีย'                                                                                                    => 'ge',
    'จอร์แดน'                                                                                                       => 'jo',
    'จาเมกา'                                                                                                          => 'jm',
    'จิบูตี'                                                                                                          => 'dj',
    'จีน'                                                                                                                   => 'cn',
    'ชาด'                                                                                                                   => 'td',
    'ชิลี'                                                                                                                => 'cl',
    'ซานมารีโน'                                                                                                 => 'sm',
    'ซามัว'                                                                                                             => 'ws',
    'ซาอุดีอาระเบีย'                                                                                  => 'sa',
    'ซาฮาราตะวันตก'                                                                                     => 'eh',
    'ซิมบับเว'                                                                                                    => 'zw',
    'ซีเรีย'                                                                                                          => 'sy',
    'ซีโอตาและเมลิลลา'                                                                            => 'ea',
    'ซูดาน'                                                                                                             => 'sd',
    'ซูรินาเม'                                                                                                    => 'sr',
    'ญี่ปุ่น'                                                                                                       => 'jp',
    'ดิเอโกการ์เซีย'                                                                                  => 'dg',
    'ตรินิแดดและโตเบโก'                                                                         => 'tt',
    'ตองกา'                                                                                                             => 'to',
    'ติมอร์ตะวันออก'                                                                                  => 'tl',
    'ตุรกี'                                                                                                             => 'tr',
    'ตูนิเซีย'                                                                                                    => 'tn',
    'ตูวาลู'                                                                                                          => 'tv',
    'ทริสตันเดอคูนา'                                                                                  => 'ta',
    'ทาจิกิสถาน'                                                                                              => 'tj',
    'นอร์เวย์'                                                                                                    => 'no',
    'นามิเบีย'                                                                                                    => 'na',
    'นาอูรู'                                                                                                          => 'nr',
    'นิการากัว'                                                                                                 => 'ni',
    'นิวซีแลนด์'                                                                                              => 'nz',
    'นิวแคลิโดเนีย'                                                                                     => 'nc',
    'นีอูเอ'                                                                                                          => 'nu',
    'บราซิล'                                                                                                          => 'br',
    'บริติชอินเดียนโอเชียนเทร์ริทอรี'                               => 'io',
    'บรูไน'                                                                                                             => 'bn',
    'บอตสวานา'                                                                                                    => 'bw',
    'บอสเนียและเฮอร์เซโกวีนา'                                                       => 'ba',
    'บังกลาเทศ'                                                                                                 => 'bd',
    'บัลแกเรีย'                                                                                                 => 'bg',
    'บาร์เบโดส'                                                                                                 => 'bb',
    'บาห์เรน'                                                                                                       => 'bh',
    'บาฮามาส'                                                                                                       => 'bs',
    'บุรุนดี'                                                                                                       => 'bi',
    'บูร์กินาฟาโซ'                                                                                        => 'bf',
    'ปากีสถาน'                                                                                                    => 'pk',
    'ปานามา'                                                                                                          => 'pa',
    'ปาปัวนิวกินี'                                                                                        => 'pg',
    'ปารากวัย'                                                                                                    => 'py',
    'ปาเลสไตน์'                                                                                                 => 'ps',
    'ปาเลา'                                                                                                             => 'pw',
    'ฝรั่งเศส'                                                                                                    => 'fr',
    'พิตแคร์น'                                                                                                    => 'pn',
    'ฟิจิ'                                                                                                                => 'fj',
    'ฟินแลนด์'                                                                                                    => 'fi',
    'ฟิลิปปินส์'                                                                                              => 'ph',
    'ภูฏาน'                                                                                                             => 'bt',
    'มหานครฝรั่งเศส'                                                                                  => 'fx',
    'มองโกเลีย'                                                                                                 => 'mn',
    'มอนต์เซอร์รัต'                                                                                     => 'ms',
    'มอนเตเนโกร'                                                                                              => 'me',
    'มอริเชียส'                                                                                                 => 'mu',
    'มอริเตเนีย'                                                                                              => 'mr',
    'มอลตา'                                                                                                             => 'mt',
    'มอลโดวา'                                                                                                       => 'md',
    'มัลดีฟส์'                                                                                                    => 'mv',
    'มาซิโดเนีย'                                                                                              => 'mk',
    'มาดากัสการ์'                                                                                           => 'mg',
    'มายอต'                                                                                                             => 'yt',
    'มาร์ตินีก'                                                                                                 => 'mq',
    'มาลาวี'                                                                                                          => 'mw',
    'มาลี'                                                                                                                => 'ml',
    'มาเก๊า'                                                                                                          => 'mo',
    'มาเลเซีย'                                                                                                    => 'my',
    'ยิบรอลตาร์'                                                                                              => 'gi',
    'ยุโรป'                                                                                                             => 150,
    'ยุโรปตะวันตก'                                                                                        => 155,
    'ยุโรปตะวันออก'                                                                                     => 151,
    'ยุโรปเหนือ'                                                                                              => 154,
    'ยุโรปใต้'                                                                                                    => '039',
    'ยูกันดา'                                                                                                       => 'ug',
    'ยูเครน'                                                                                                          => 'ua',
    'รวันดา'                                                                                                          => 'rw',
    'รัสเซีย'                                                                                                       => 'ru',
    'ละตินอเมริกาและแคริบเบียน'                                                 => 419,
    'ลักเซมเบิร์ก'                                                                                        => 'lu',
    'ลัตเวีย'                                                                                                       => 'lv',
    'ลาว'                                                                                                                   => 'la',
    'ลิกเตนสไตน์'                                                                                           => 'li',
    'ลิทัวเนีย'                                                                                                 => 'lt',
    'ลิเบีย'                                                                                                          => 'ly',
    'วาติกัน'                                                                                                       => 'va',
    'วานูอาตู'                                                                                                    => 'vu',
    'วาลลิสและฟุตูนา'                                                                               => 'wf',
    'ศรีลังกา'                                                                                                    => 'lk',
    'สฟาลบาร์และยานไมเอน'                                                                   => 'sj',
    'สวาซิแลนด์'                                                                                              => 'sz',
    'สวิตเซอร์แลนด์'                                                                                  => 'ch',
    'สวีเดน'                                                                                                          => 'se',
    'สหภาพยุโรป'                                                                                              => 'eu',
    'สหรัฐอาหรับเอมิเรตส์'                                                                => 'ae',
    'สหรัฐอเมริกา'                                                                                        => 'us',
    'สหราชอาณาจักร'                                                                                     => 'gb',
    'สาธารณรัฐเช็ก'                                                                                     => 'cz',
    'สาธารณรัฐแอฟริกากลาง'                                                                => 'cf',
    'สาธารณรัฐโดมินิกัน'                                                                      => 'do',
    'สิงคโปร์'                                                                                                    => 'sg',
    'สเปน'                                                                                                                => 'es',
    'สโลวะเกีย'                                                                                                 => 'sk',
    'สโลวีเนีย'                                                                                                 => 'si',
    'หมู่เกาะคานารี'                                                                                  => 'ic',
    'หมู่เกาะคุก'                                                                                           => 'ck',
    'หมู่เกาะนอร์เทิร์นมาเรียนา'                                              => 'mp',
    'หมู่เกาะบริติชเวอร์จิน'                                                          => 'vg',
    'หมู่เกาะฟอล์กแลนด์อิสลาสมาลวินาส'                            => 'fk',
    'หมู่เกาะมาร์แชลล์'                                                                         => 'mh',
    'หมู่เกาะยูเอสเวอร์จิน'                                                             => 'vi',
    'หมู่เกาะสหรัฐไมเนอร์เอาต์ไลอิง'                                  => 'um',
    'หมู่เกาะเคย์แมน'                                                                               => 'ky',
    'หมู่เกาะเติกส์และหมู่เกาะเคคอส'                                  => 'tc',
    'หมู่เกาะแชนเนล'                                                                                  => 830,
    'หมู่เกาะแฟโร'                                                                                        => 'fo',
    'หมู่เกาะโคโคส'                                                                                     => 'cc',
    'หมู่เกาะโซโลมอน'                                                                               => 'sb',
    'หมู่เกาะโอลันด์'                                                                               => 'ax',
    'ออสเตรีย'                                                                                                    => 'at',
    'ออสเตรเลีย'                                                                                              => 'au',
    'ออสเตรเลียและนิวซีแลนด์'                                                       => '053',
    'อันดอร์รา'                                                                                                 => 'ad',
    'อัฟกานิสถาน'                                                                                           => 'af',
    'อารูบา'                                                                                                          => 'aw',
    'อาร์เจนตินา'                                                                                           => 'ar',
    'อาร์เมเนีย'                                                                                              => 'am',
    'อาเซอร์ไบจาน'                                                                                        => 'az',
    'อิตาลี'                                                                                                          => 'it',
    'อินเดีย'                                                                                                       => 'in',
    'อินโดนีเซีย'                                                                                           => 'id',
    'อิรัก'                                                                                                             => 'iq',
    'อิสราเอล'                                                                                                    => 'il',
    'อิหร่าน'                                                                                                       => 'ir',
    'อิเควทอเรียลกินี'                                                                            => 'gq',
    'อียิปต์'                                                                                                       => 'eg',
    'อุซเบกิสถาน'                                                                                           => 'uz',
    'อุรุกวัย'                                                                                                    => 'uy',
    'อเมริกันซามัว'                                                                                     => 'as',
    'อเมริกา'                                                                                                       => '019',
    'อเมริกากลาง'                                                                                           => '013',
    'อเมริกาตอนเหนือ'                                                                               => '021',
    'อเมริกาเหนือ'                                                                                        => '003',
    'อเมริกาใต้'                                                                                              => '005',
    'ฮอนดูรัส'                                                                                                    => 'hn',
    'ฮังการี'                                                                                                       => 'hu',
    'ฮ่องกง'                                                                                                          => 'hk',
    'เกรเนดา'                                                                                                       => 'gd',
    'เกาหลีเหนือ'                                                                                           => 'kp',
    'เกาหลีใต้'                                                                                                 => 'kr',
    'เกาะคริสต์มาส'                                                                                     => 'cx',
    'เกาะคลิปเปอร์ตัน'                                                                            => 'cp',
    'เกาะนอร์ฟอล์ก'                                                                                     => 'nf',
    'เกาะบูเวต'                                                                                                 => 'bv',
    'เกาะเซาท์จอร์เจียและหมู่เกาะเซาท์แซนด์วิช' => 'gs',
    'เกาะเฮิร์ดและหมู่เกาะแมกดอนัลด์'                               => 'hm',
    'เกาะแมน'                                                                                                       => 'im',
    'เกาะแอสเซนชัน'                                                                                     => 'ac',
    'เกิร์นซีย์'                                                                                              => 'gg',
    'เขตไมโครนีเซีย'                                                                                  => '057',
    'เคนยา'                                                                                                             => 'ke',
    'เคปเวิร์ด'                                                                                                 => 'cv',
    'เครือรัฐอิสระ'                                                                                     => 172,
    'เจอร์ซีย์'                                                                                                 => 'je',
    'เซนต์คิตส์และเนวิส'                                                                      => 'kn',
    'เซนต์บาร์เธเลมี'                                                                               => 'bl',
    'เซนต์มาติน'                                                                                              => 'mf',
    'เซนต์ลูเซีย'                                                                                           => 'lc',
    'เซนต์วินเซนต์และเกรนาดีนส์'                                              => 'vc',
    'เซนต์เฮเลนา'                                                                                           => 'sh',
    'เซอร์เบีย'                                                                                                 => 'rs',
    'เซอร์เบียและมอนเตเนโกร'                                                          => 'cs',
    'เซาตูเมและปรินซิปี'                                                                      => 'st',
    'เซียร์ราลีโอน'                                                                                     => 'sl',
    'เซเชลส์'                                                                                                       => 'sc',
    'เซเนกัล'                                                                                                       => 'sn',
    'เดนมาร์ก'                                                                                                    => 'dk',
    'เติร์กเมนิสถาน'                                                                                  => 'tm',
    'เนปาล'                                                                                                             => 'np',
    'เนเธอร์แลนด์'                                                                                        => 'nl',
    'เนเธอร์แลนด์แอนทิลลิส'                                                             => 'an',
    'เบนิน'                                                                                                             => 'bj',
    'เบลารุส'                                                                                                       => 'by',
    'เบลีซ'                                                                                                             => 'bz',
    'เบลเยียม'                                                                                                    => 'be',
    'เบอร์มิวดา'                                                                                              => 'bm',
    'เปรู'                                                                                                                => 'pe',
    'เปอร์โตริโก'                                                                                           => 'pr',
    'เฟรนช์เกียนา'                                                                                        => 'gf',
    'เฟรนช์เซาเทิร์นเทร์ริทอรีส์'                                           => 'tf',
    'เฟรนช์โปลินีเซีย'                                                                            => 'pf',
    'เมลานีเซีย'                                                                                              => '054',
    'เมียนม่าร์พม่า'                                                                                  => 'mm',
    'เม็กซิโก'                                                                                                    => 'mx',
    'เยอรมนี'                                                                                                       => 'de',
    'เยเมน'                                                                                                             => 'ye',
    'เรอูนียง'                                                                                                    => 're',
    'เลบานอน'                                                                                                       => 'lb',
    'เลโซโท'                                                                                                          => 'ls',
    'เวียดนาม'                                                                                                    => 'vn',
    'เวเนซุเอลา'                                                                                              => 've',
    'เอกวาดอร์'                                                                                                 => 'ec',
    'เอธิโอเปีย'                                                                                              => 'et',
    'เอริเทรีย'                                                                                                 => 'er',
    'เอลซัลวาดอร์'                                                                                        => 'sv',
    'เอสโตเนีย'                                                                                                 => 'ee',
    'เอาต์ไลอิงโอเชียเนีย'                                                                => 'qo',
    'เอเชีย'                                                                                                          => 142,
    'เอเชียกลาง'                                                                                              => 143,
    'เอเชียกลางตอนใต้'                                                                            => '062',
    'เอเชียตะวันตก'                                                                                     => 145,
    'เอเชียตะวันออก'                                                                                  => '030',
    'เอเชียตะวันออกเฉียงใต้'                                                          => '035',
    'เอเชียใต้'                                                                                                 => '034',
    'เฮติ'                                                                                                                => 'ht',
    'แกมเบีย'                                                                                                       => 'gm',
    'แคนาดา'                                                                                                          => 'ca',
    'แคริบเบียน'                                                                                              => '029',
    'แคเมอรูน'                                                                                                    => 'cm',
    'แซงปีแยร์และมีเกอลง'                                                                   => 'pm',
    'แซมเบีย'                                                                                                       => 'zm',
    'แทนซาเนีย'                                                                                                 => 'tz',
    'แองกวิลลา'                                                                                                 => 'ai',
    'แองโกลา'                                                                                                       => 'ao',
    'แอนตาร์กติกา'                                                                                        => 'aq',
    'แอนติกาและบาร์บูดา'                                                                      => 'ag',
    'แอฟริกา'                                                                                                       => '002',
    'แอฟริกากลาง'                                                                                           => '017',
    'แอฟริกาตะวันตก'                                                                                  => '011',
    'แอฟริกาตะวันออก'                                                                               => '014',
    'แอฟริกาเหนือ'                                                                                        => '015',
    'แอฟริกาใต้'                                                                                              => 'za',
    'แอฟริกาใต้018'                                                                                           => '018',
    'แอลจีเรีย'                                                                                                 => 'dz',
    'แอลเบเนีย'                                                                                                 => 'al',
    'โครเอเชีย'                                                                                                 => 'hr',
    'โคลอมเบีย'                                                                                                 => 'co',
    'โซมาเลีย'                                                                                                    => 'so',
    'โดมินิกา'                                                                                                    => 'dm',
    'โตเกเลา'                                                                                                       => 'tk',
    'โตโก'                                                                                                                => 'tg',
    'โบลิเวีย'                                                                                                    => 'bo',
    'โปรตุเกส'                                                                                                    => 'pt',
    'โปลินีเซีย'                                                                                              => '061',
    'โปแลนด์'                                                                                                       => 'pl',
    'โมซัมบิก'                                                                                                    => 'mz',
    'โมนาโก'                                                                                                          => 'mc',
    'โมร็อกโก'                                                                                                    => 'ma',
    'โรมาเนีย'                                                                                                    => 'ro',
    'โลก'                                                                                                                   => '001',
    'โอมาน'                                                                                                             => 'om',
    'โอเชียเนีย'                                                                                              => '009',
    'ไซปรัส'                                                                                                          => 'cy',
    'ไต้หวัน'                                                                                                       => 'tw',
    'ไทย'                                                                                                                   => 'th',
    'ไนจีเรีย'                                                                                                    => 'ng',
    'ไนเจอร์'                                                                                                       => 'ne',
    'ไมโครนีเซีย'                                                                                           => 'fm',
    'ไม่ทราบ'                                                                                                       => 'zz',
    'ไลบีเรีย'                                                                                                    => 'lr',
    'ไอซ์แลนด์'                                                                                                 => 'is',
    'ไอร์แลนด์'                                                                                                 => 'ie',
    'ไอวอรี่โคสต์'                                                                                        => 'ci',
);

1;

