/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.FailoverInfo;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.HashMap;
import java.util.logging.Level;

final class FailoverMapSingleton {
    private static int INITIALHASHMAPSIZE = 5;
    private static HashMap failoverMap = new HashMap(INITIALHASHMAPSIZE);

    private FailoverMapSingleton() {
    }

    private static String concatPrimaryDatabase(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (null != string2) {
            stringBuffer.append("\\");
            stringBuffer.append(string2);
        }
        stringBuffer.append(";");
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FailoverInfo getFailoverInfo(SQLServerConnection sQLServerConnection, String string, String string2, String string3) {
        Class clazz = FailoverMapSingleton.class;
        synchronized (clazz) {
            FailoverInfo failoverInfo;
            if (failoverMap.isEmpty()) {
                return null;
            }
            String string4 = FailoverMapSingleton.concatPrimaryDatabase(string, string2, string3);
            if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
                sQLServerConnection.getConnectionLogger().fine(sQLServerConnection.toLogString() + " Looking up info in the map using key: " + string4);
            }
            if (null != (failoverInfo = (FailoverInfo)failoverMap.get(string4))) {
                failoverInfo.log(sQLServerConnection);
            }
            return failoverInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putFailoverInfo(SQLServerConnection sQLServerConnection, String string, String string2, String string3, FailoverInfo failoverInfo, boolean bl, String string4) throws SQLServerException {
        Class clazz = FailoverMapSingleton.class;
        synchronized (clazz) {
            FailoverInfo failoverInfo2 = FailoverMapSingleton.getFailoverInfo(sQLServerConnection, string, string2, string3);
            if (null == failoverInfo2) {
                if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
                    sQLServerConnection.getConnectionLogger().fine(sQLServerConnection.toLogString() + " Failover map add server: " + string + "; database:" + string3 + "; Mirror:" + string4);
                }
                failoverMap.put(FailoverMapSingleton.concatPrimaryDatabase(string, string2, string3), failoverInfo);
            } else {
                failoverInfo2.failoverAdd(sQLServerConnection, bl, string4);
            }
        }
    }
}

