/***************************************************************************
                     bz2-test.cpp  -  Test the bzip2 class
                             -------------------
    begin                : Mon Jul 06 2009
    copyright            : (C) 2009 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/core/cbytearray.h>
#include <dclib/core/cbz.h>

#include <stdio.h>
#include <string.h>

int main( int /* argc */, char* [] /* argv[] */ )
{
	CByteArray orig(2*1024*1024);
	CByteArray compressed;
	CByteArray decompressed;
	
	memset(orig.Data(), 'D', orig.Size());
	
	if ( CBZ::Compress(&orig, &compressed) == false )
	{
		fprintf(stderr,"bz2-test: CBZ::Compress failed\n");
		return 10;
	}
	
	/* 2MiB of a single repeated char should compress to very little */
	if ( compressed.Size() > orig.Size() )
	{
		fprintf(stderr,"bz2-test: failed, size increased\n");
		return 20;
	}
	
	if ( CBZ::Decompress(&compressed,&decompressed) == false )
	{
		fprintf(stderr,"bz2-test: CBZ::Decompress failed\n");
		return 30;
	}
	
	if ( decompressed.Size() != orig.Size() )
	{
		fprintf(stderr,"bz2-test: size mismatch\n");
		return 40;
	}
	
	if ( memcmp(orig.Data(), decompressed.Data(), orig.Size()) != 0 )
	{
		fprintf(stderr,"bz2-test: data mismatch\n");
		return 50;
	}
	
	return 0;
}
