# -*- cperl -*-

BEGIN {
    # dirty trick to create a Memoize cache so that test will use this instead
    # of getting values through the internet
    no warnings 'once';
    %Config::Model::Dpkg::Dependency::cache = (
        'libarchive-extract-perl' => 'squeeze 0.65-1 jessie 0.68-1 sid 0.68-1',
        'perl-modules' => 'lenny 5.10.0-19lenny3 squeeze 5.10.1-17 sid 5.10.1-17 experimental 5.12.0-2 experimental 5.12.2-2',
        'perl' => 'squeeze 5.10.1-17 wheezy 5.14.2-21 jessie 5.18.1-3 sid 5.18.1-4',
        'debhelper' => 'etch 5.0.42 backports/etch 7.0.15~bpo40+2 lenny 7.0.15 backports/lenny 8.0.0~bpo50+2 squeeze 8.0.0 wheezy 8.1.2 sid 8.1.2',
        'libcpan-meta-perl' => 'squeeze 2.101670-1 wheezy 2.110580-1 sid 2.110580-1',
        'libmodule-build-perl' => 'squeeze 0.360700-1 wheezy 0.380000-1 jessie 0.400700-1 sid 0.400700-1',
        'xserver-xorg-input-evdev' => 'etch 1:1.1.2-6 lenny 1:2.0.8-1 squeeze 1:2.3.2-6 wheezy 1:2.3.2-6 sid 1:2.6.0-2 experimental 1:2.6.0-3',
        'lcdproc' => 'etch 0.4.5-1.1 lenny 0.4.5-1.1 squeeze 0.5.2-3 wheezy 0.5.2-3.1 sid 0.5.2-3.1',
        'libsdl1.2' => '', # only source
        'libmodule-metadata-perl' => 'wheezy 1.000009-1+deb7u1 jessie 1.000024-1 jessie-kfreebsd 1.000024-1 stretch 1.000024-1 sid 1.000024-1',
        'libextutils-parsexs-perl' => 'squeeze 2.220600-1 wheezy 3.150000-1 jessie-kfreebsd 3.240000-1 jessie 3.240000-1 stretch 3.240000-1 sid 3.240000-1',
        'libtest-simple-perl' => 'etch 0.62-1 lenny 0.80-1 backports/lenny 0.94-1~bpo50+1 squeeze 0.94-1 wheezy 0.98-1 sid 0.98-1',
        'dpkg' => 'squeeze 1.15 wheezy 1.16 sid 1.16',
        'libclass-isa-perl' => 'oldoldstable 0.36-3 oldstable 0.36-5 stable 0.36-5 testing 0.36-5 unstable 0.36-5 oldstable-kfreebsd 0.36-5',
        makedev => 'squeeze 2.3.1-89 wheezy 2.3.1-92 jessie 2.3.1-92 sid 2.3.1-93',
        udev => 'squeeze 164-3 wheezy 175-7.2 jessie 175-7.2 sid 175-7.2',
        foobar => undef, # used to test that unknown package trigger a warning, real cache should not contain undef
    );
    my $t = time ;
    map { $_ = "$t $_"} grep {defined $_} values %Config::Model::Dpkg::Dependency::cache ;
}

use ExtUtils::testlib;
use Test::More ;
use Test::Memory::Cycle;
use Test::Differences;
use Config::Model ;
use Config::Model::Value ;
use Log::Log4perl qw(:easy) ;
use File::Path ;
use File::Copy ;
use Test::Warn ;
use 5.10.0;

eval { require AptPkg::Config ;} ;
if ( $@ ) {
    plan skip_all => "AptPkg::Config is not installed";
}
elsif ( not -r '/etc/debian_version' ) {
    plan skip_all => "Not a Debian system";
}

use warnings;

use strict;

$Config::Model::Dpkg::Dependency::use_test_cache = 1;

my $arg = shift || '';
my ($log,$show,$one) = (0) x 3 ;

my $trace = $arg =~ /t/ ? 1 : 0 ;
$log                = 1 if $arg =~ /l/;
Config::Model::Exception::Any->Trace(1) if $arg =~ /e/;

use Log::Log4perl qw(:easy) ;
my $home = $ENV{HOME} || "";
my $log4perl_user_conf_file = "$home/.log4config-model";

if ($log and -e $log4perl_user_conf_file ) {
    Log::Log4perl::init($log4perl_user_conf_file);
}
else {
    Log::Log4perl->easy_init($ERROR);
}
$show               = 1 if $arg =~ /s/;
$one                = 1 if $arg =~ /1/;

{
    no warnings qw/once/;
    $::RD_HINT  = 1 if $arg =~ /rdt?h/;
    $::RD_TRACE = 1 if $arg =~ /rdh?t/;
}

my $model = Config::Model -> new ( ) ;

{
    no warnings qw/once/ ;
    $Dpkg::Dependency::test_filter='lenny'; 
}

my $control_text = <<'EOD' ;
Source: libdist-zilla-plugins-cjm-perl
Section: perl
Priority: optional
Build-Depends: debhelper, libsdl1.2, dpkg
Build-Depends-Indep: libcpan-meta-perl, perl (>= 5.10) | libmodule-build-perl,
Maintainer: Debian Perl Group <pkg-perl-maintainers@lists.alioth.debian.org>
Uploaders: Dominique Dumont <dominique.dumont@hp.com>
Standards-Version: 4.1.3
Homepage: http://search.cpan.org/dist/Dist-Zilla-Plugins-CJM/

Package: libdist-zilla-plugins-cjm-perl
Architecture: all
Depends: ${misc:Depends}, ${perl:Depends}, libcpan-meta-perl ,
 perl (>= 5.10.1), dpkg (>= 0.01), perl-modules,  dpkg (<< ${source:Version}.1~)
Description: collection of CJM's plugins for Dist::Zilla
 Collection of Dist::Zilla plugins. This package features the 
 following [snip]  
EOD

ok(1,"compiled");

#die "test compat update";
# pseudo root where config files are written by config-model
my $wr_root = 'wr_root';

# cleanup before tests
rmtree($wr_root);
mkpath($wr_root, { mode => 0755 }) ;

my $wr_dir = $wr_root.'/test' ;
mkpath($wr_dir."/debian/", { mode => 0755 }) ;
my $control_file = "$wr_dir/debian/control" ;

open(my $control_h,"> $control_file" ) || die "can't open $control_file: $!";
print $control_h $control_text ;
close $control_h ;

{

# instance to check one dependency at a time
my $unit = $model->instance (
    root_class_name => 'Dpkg::Control',
    root_dir        => $wr_dir,
    instance_name   => "unittest",
);

warning_like {
    $unit->config_root->init ;
}
 [ qr/is unknown/, qr/unnecessary/, (qr/dual life/) , qr/unnecessary/,
   ( qr/dual life.*removed/), ( qr/dual life/) , (qr/unnecessary/) x 2 ] ,
  "test BDI warn on unittest instance";

my $c_unit = $unit->config_root ;
my $dep_value = $c_unit->grab("binary:dummy Depends:0");

my @struct_2_dep = (
    [{}] => undef,
    [{ name => 'foo' }] => 'foo',
    [{ name => 'foo' }, { name => 'bar'}] => 'foo | bar',
    [{ name =>  'foo', dep => [ '>=' , '2.15']}] => 'foo (>= 2.15)',
    [{ name =>  'foo', dep => [ '>=' , '2.15'], arch => ['linux-i386', 'hurd']}]
    => 'foo (>= 2.15) [linux-i386 hurd]',
    [{ name =>  'foo', arch => ['linux-i386', 'hurd']}] => 'foo [linux-i386 hurd]',
    [{ name =>  'udev', arch => [ 'linux-any']},{ name => 'makedev', arch => [ 'linux-any']}]
    => 'udev [linux-any] | makedev [linux-any]',
    [{name => 'foo', profile => [ ['stage1', 'cross'] ]}]
    => 'foo <stage1 cross>',
    [{name => 'foo', profile => [ ['stage1', 'cross'], ['stage1'] ]}]
    => 'foo <stage1 cross> <stage1>',
    [{name => 'foo', profile => [ ['stage1', 'cross'], ['pkg.foo-src.yada-yada'] ]}]
    => 'foo <stage1 cross> <pkg.foo-src.yada-yada>',
);

while (@struct_2_dep) {
    my $data = shift @struct_2_dep ;
    my $str = shift @struct_2_dep ;
    is(
        $dep_value->struct_to_dep(@$data),
        $str,
        'test struct_to_dep -> "'. ( $str // '<undef>' ) . '"'
    ) ;
}

my @deb_v_to_cpan_v = qw/
    1.21-1 1.21
    1:0.421000-2 0.421000
    5.20150120-2~1 5.20150120
    1.00+dfsg-3 1.00
/;

while (@deb_v_to_cpan_v) {
    my $deb_v = shift @deb_v_to_cpan_v ;
    my $cpan_v = shift @deb_v_to_cpan_v ;
    is(
        $dep_value->extract_cpan_version($deb_v),
        $cpan_v,
        "test extract_cpan_version $deb_v -> $cpan_v"
    ) ;
}

warning_like {
    $dep_value->store('perl') ;
}
 [ qr/better written/ ] ,
  "test warn on perl dep";

is($dep_value->fetch, 'perl', "check stored dependency value") ;

warning_like {
    $dep_value->store('perl (  >= 5.6.0)') ;
}
 [ qr/unnecessary/ ] ,
  "test warn on perl dep with old version";

my ($res) = $dep_value->check_versioned_dep( {name => 'perl', dep => ['>=','5.6.0']} );
is( $res, 0, "check perl (>= 5.6.0) dependency: no older version");

# test that obsolete break type dependencies are removed (#871422)
($res) = $dep_value->check_versioned_dep(  {name => 'lcdproc', dep => [qw/<< 0.4.2/] } );
is( $res, 0, "check lcdproc (<< 0.4.2) dependency: removed");


# $dep_value->store('libcpan-meta-perl') ;
# exit ;
my @chain_tests = (
    # tag name for display, test data, expected result: 1 (good dep) or expected fixed structure
    'libcpan-meta-perl'
    => [ { name => 'libcpan-meta-perl'}]
    => [ { name => 'perl', dep => [qw/>= 5.13.10/]} ,{ name => 'libcpan-meta-perl'}],

    'libcpan-meta-perl (>= 2.101550)'
        => [ { name => 'libcpan-meta-perl', dep => [qw/>= 2.101550/]}]
        => [ { name => 'perl', dep => [qw/>= 5.13.10/]} ,{ name => 'libcpan-meta-perl'}],

    'libmodule-build-perl perl 5.10'
    => [ { name => 'perl', dep => [qw/>= 5.10/]}, { name => 'libmodule-build-perl'}]
    => [ { name => 'libmodule-build-perl'} ],

   'libmodule-build-perl perl-modules 5.10'
    => [ { name => 'perl-modules', dep => [qw/>= 5.10/]}, { name => 'libmodule-build-perl'}]
    => [ { name => 'libmodule-build-perl'}, { name => 'perl', dep => [qw/<< 5.19.0/]} ],

    # test Debian #719225
    'libarchive-extract-perl >= 0.68'
    => [ { name => 'libarchive-extract-perl', dep => [qw/>= 0.68/]} ,
         { name => 'perl', dep => [qw/<< 5.17.9/]} ]
    => 1,

    'libarchive-extract-perl'
    => [ { name => 'perl', dep => [qw/>= 5.17.9/] }, { name => 'libarchive-extract-perl'} ]
    => 0, # Archive::Extract is now removed from core

    'libmodule-build-perl to fix'
    =>  [ { name => 'perl', dep => [qw/>= 5.11.3/]},
          { name => 'libmodule-build-perl', dep => [qw/>= 0.360000/ ]}]
    => [ { name => 'libmodule-build-perl'}, { name => 'perl', dep => [qw/<< 5.19.0/]} ] ,

    # test that cme does not restrict needlessly the alternate Perl version
    'libmodule-metadata-perl to fix'
    =>  [ { name => 'perl', dep => [qw/>= 5.13.9/]}, { name => 'libmodule-metadata-perl'} ]
    => 1 ,
    'libmodule-parsexs-perl to fix'
    =>  [ { name => 'perl', dep => [qw/>= 5.12/]}, { name => 'libextutils-parsexs-perl'}]
    => 1 ,

    # test for #682730
    'module removed from corelist - 1 '
        => [ { name => 'libclass-isa-perl'}, { name => 'perl', dep => [qw/<< 5.11.1-13/]} ]
        => [ { name => 'libclass-isa-perl'}, { name => 'perl', dep => [qw/<< 5.11.0/]} ],
    'module removed from corelist - 2'
        => [ { name => 'libclass-isa-perl'}, { name => 'perl', dep => [qw/<< 5.08.1-13/]} ]
        => [ { name => 'libclass-isa-perl'} ],

    'module part of core perl forever'
        => [ { name => 'libtest-simple-perl' } ]
        => [ { name => 'perl' }, { name => 'libtest-simple-perl' } ],

    );

while (@chain_tests) {
    my ($tag,$dep,$expect) = splice @chain_tests,0,3;
    my $ret = $dep_value->check_depend_chain (1, $dep);
    if (ref $expect) {
        # $dep was not correct
        is($ret, 0, "check dual life of $tag") ;
        eq_or_diff ($dep,$expect,"check fixed value of dual life $tag");
    }
    else {
        is($ret, $expect, "check dual life of $tag") ;
    }
}

}

my $inst = $model->instance (
    root_class_name => 'Dpkg::Control',
    root_dir        => $wr_dir,
    instance_name   => "deptest",
);

warning_like {
    $inst->config_root->init ;
}
 [ qr/is unknown/, qr/unnecessary/, (qr/dual life/) , qr/unnecessary/,
   ( qr/dual life/) x 2 , (qr/unnecessary/) x 2 ] ,
  "test BDI warn";

ok($inst,"Read $control_file and created instance") ;

my $control = $inst -> config_root ;

if ($trace) {
    my $dump =  $control->dump_tree ();
    print $dump ;
}

my $perl_dep = $control->grab("binary:libdist-zilla-plugins-cjm-perl Depends:3");
is($perl_dep->fetch,"perl (>= 5.10.1)","check dependency value from config tree");

my $res = $perl_dep->check_versioned_dep({name => 'perl', dep => ['>=','5.28.1']}) ;
is($res,1,"check perl (>= 5.28.1) dependency: has older version");

($res) = $perl_dep->check_versioned_dep({ name =>'perl', dep =>['>=','5.6.0']}) ;
is($res,0,"check perl (>= 5.6.0) dependency: no older version");

my $dpkg_dep = $control->grab("source Build-Depends:2");
is($dpkg_dep->fetch,"dpkg",'check dpkg value') ;
# test fixes
is($dpkg_dep->has_fixes,1, "test presence of fixes");
$dpkg_dep->apply_fixes;
is($dpkg_dep->has_fixes,0, "test that fixes are gone");

is($dpkg_dep->fetch,undef,'check fixed dpkg value') ;

$dpkg_dep = $control->grab("binary:libdist-zilla-plugins-cjm-perl Depends:4");
is($dpkg_dep->fetch,"dpkg (>= 0.01)",'check dpkg value with unnecessary versioned dep') ;
# test fixes
is($dpkg_dep->has_fixes,1, "test presence of fixes");
$dpkg_dep->apply_fixes;
is($dpkg_dep->has_fixes,0, "test that fixes are gone");
is($dpkg_dep->fetch,undef,'check fixed dpkg value') ;

warning_like {
    $perl_dep->store("perl ( >= 5.6.0 )") ;
}
qr/unnecessary greater-than versioned/,"check perl (>= 5.6.0) store: no older version warning" ;

my @msgs = $perl_dep->warning_msg ;
is(scalar @msgs,1,"check nb of warning with store with old version");
like($msgs[0],qr/unnecessary greater-than versioned dependency/,"check store with old version");

$control->load(q{binary:libdist-zilla-plugins-cjm-perl Depends:4="perl [!i386] | perl [amd64] "}) ;
ok( 1, "check_depend on arch stuff rule");

$control->load(
    "binary:libdist-zilla-plugins-cjm-perl ".
    q{Depends:5="xserver-xorg-input-evdev [alpha amd64 arm armeb armel hppa i386 ia64 lpia m32r m68k mips mipsel powerpc sparc]"}
);
ok( 1, "check_depend on xorg arch stuff rule");

$control->load(q{binary:libdist-zilla-plugins-cjm-perl Depends:6="lcdproc (= ${binary:Version})"});
ok( 1, "check_depend on lcdproc where version is a variable");

$control->load(q{binary:libdist-zilla-plugins-cjm-perl Depends:7="udev [linux-any] | makedev [linux-any]"});
ok( 1, "check_depend on lcdproc with 2 alternate deps with arch restriction");

# reset change tracker
$inst-> clear_changes ;

# test fixes
is($perl_dep->has_fixes,1, "test presence of fixes");
$perl_dep->apply_fixes;
is($perl_dep->fetch,'${perl:Depends}',"check fixed dependency value");
is(
    $control->grab_value("binary:libdist-zilla-plugins-cjm-perl Depends:7"),
    'udev [linux-any] | makedev [linux-any]',
    "test fixed alternate deps with arch restriction"
);
is($perl_dep->has_fixes,0, "test that fixes are gone");
is($perl_dep->has_warning,0,"check that warnings are gone");

is($inst->c_count, 2,"check that fixes are tracked with notify changes") ;
print scalar $inst->list_changes,"\n" if $trace ;

$control->load(q{binary:libdist-zilla-plugins-cjm-perl Depends:.push(mailx,foobar)});
is($control->grab('binary:libdist-zilla-plugins-cjm-perl Depends:8')->has_warning,
    0, "check that _known_ virtual package don't trigger a warning");
is($control->grab('binary:libdist-zilla-plugins-cjm-perl Depends:9')->has_warning,
    1, "check that _unknown_ package do trigger a warning");

my $perl_bdi = $control->grab("source Build-Depends-Indep:1");

my $bdi_val ;
# since warnings were already issued during config_root->init, we don;t
# get warnings here
warning_like { $bdi_val = $perl_bdi->fetch ; } [ ], "check that no BDI warn are shown";

is($bdi_val,"perl (>= 5.10) | libmodule-build-perl","check B-D-I dependency value from config tree");
my $msgs = $perl_bdi->warning_msg ;
print "bdi warning: $msgs" if $trace ;
like($msgs,qr/dual life/,"check store with old version: trap perl | libmodule");
like($msgs,qr/unnecessary greater-than versioned dependency/,"check store with old version: trap version");

$inst-> clear_changes ;

# test fixes
is($perl_bdi->has_fixes,2, "test presence of fixes");

{
    local $Config::Model::Value::nowarning = 1 ;
    $perl_bdi->apply_fixes;
    ok(1,"apply_fixes done");
}

is($perl_bdi->has_fixes,0, "test that fixes are gone");
is($perl_bdi->has_warning,0,"check that warnings are gone");

is($perl_bdi->fetch,"libmodule-build-perl | perl (<< 5.19.0)","check fixed B-D-I dependency value");

print scalar $inst->list_changes,"\n" if $trace ;
is($inst->c_count, 1,"check that fixes are tracked with notify changes") ;

# test that obsolete break type dependencies are removed (#871422)
my $bin_breaks = $control->grab("binary:lcdproc-breaker Breaks");
warning_like {
    $bin_breaks->fetch_with_id(0)->store('lcdproc (<< 0.4.2)');
} qr/unnecessary older-than versioned dependency/, "Breaks with obsolete version triggers a warning";

# test fixes
is($bin_breaks->fetch_with_id(0)->has_fixes,1, "test presence of fixes");

{
    local $Config::Model::Value::nowarning = 1 ;
    $control->grab("binary:lcdproc-breaker")->apply_fixes;
    ok(1,"apply_fixes on Breaks done");
}
is($bin_breaks->has_fixes,0, "test that fixes are gone");
is($bin_breaks->has_warning,0,"check that warnings are gone");

is($bin_breaks->fetch_with_id(0)->fetch,undef ,"check fixed Breaks dependency value");


my $expected_warn = qr/URL is not the canonical one for repositories hosted on Alioth/;
my @vcs_tests = (
    [ 'Vcs-Browser', 'http://git.debian.org/?p=debian-med/r-cran-stringr.git;a=summary',
      'https://anonscm.debian.org/cgit/debian-med/r-cran-stringr.git', $expected_warn ],
    [ 'Vcs-Browser', 'https://svn.debian.org/yadasvn/','http://anonscm.debian.org/viewvc/', $expected_warn ],
    [ 'Vcs-Browser', 'http://bzr.debian.org/loggerhead/','http://anonscm.debian.org/loggerhead/', $expected_warn ],
    [ 'Vcs-Arch',    'http://foo.debian.org/arch/arch/','http://anonscm.debian.org/arch/', $expected_warn ],
    [ 'Vcs-Bzr',     'http://baz.debian.org/','http://anonscm.debian.org/bzr/', $expected_warn ],
    [ 'Vcs-Cvs',     'svn@cvs.alioth.debian.org:/cvsroot/','svn@anonscm.debian.org:/cvs/', $expected_warn ],
    [ 'Vcs-Git',     'http://foo.debian.org/git/bar.git','https://anonscm.debian.org/git/bar.git', qr/unencrypted/, $expected_warn ],
    [ 'Vcs-Git',     'git://foo.debian.org/git/bar.git','https://anonscm.debian.org/git/bar.git', qr/unencrypted/, $expected_warn ],
    [ 'Vcs-Hg',      'http://foo.debian.org/hg/foo','http://anonscm.debian.org/hg/foo', $expected_warn ],
    [ 'Vcs-Svn',     'svn://foo.debian.org/svn/foo','svn://anonscm.debian.org/foo', $expected_warn ],
);

foreach my $vt (@vcs_tests) {
    my ($elt, $urla, $urlb, @expected_warn) = @$vt;
    my $vcs = $control->grab("source $elt") ;

    warning_like {
        $vcs->store($urla) ;
    } \@expected_warn ,"old URL triggers a warning on $elt";


    {
        local $Config::Model::Value::nowarning = 1 ;
        $vcs->apply_fixes;
        ok(1,"apply_fixes on $elt URL done");
    }
    is($vcs->fetch, $urlb,'fixed $elt URL') ;
}

# test debhelper compat interaction
{
    # instance to check one dependency at a time
    my $unit = $model->instance (
        root_class_name => 'Dpkg',
        root_dir        => $wr_dir,
        instance_name   => "compat-test",
    );

    my $root = $unit->config_root;
    my $compat_obj = $root->grab("compat");
    $compat_obj->store(8);

    # TODO: check warnings
    my $dh_obj;
    warning_like {
        $dh_obj = $root->grab("control source Build-Depends:0");
    }
        [ qr/debhelper/, (qr/control/) x 8 ] ,
              "check warnings on initial dep load";

    # apply fixes
    $dh_obj->apply_fixes;
    $dh_obj->check(silent => 1);
    is(scalar $dh_obj->warning_msg,'',"no warnings afer fix");

    # bump debhelper
    $compat_obj->store(9);

    # check for warnings
    warning_like {
        $dh_obj->check;
    }
        [ qr/debhelper/ ] , "check warnings after compat bump";

    # apply fixes again
    $dh_obj->apply_fixes;

    is($dh_obj->fetch,'debhelper (>= 9)',"test fixed debhelper value after compat change");
}


memory_cycle_ok($model, "memory cycles");

done_testing;
