

#include(FindPkgConfig)
#pkg_check_modules(PostgreSQL libpq-dev)

if(DMC_INCLUDEDIR AND DMC_LIBRARIES)
	set(DMC_LIBRARY -L${DMC_LIBRARY_DIRS} ${DMC_LIBRARIES})
else()
	set(DMC_INCLUDEDIR DMC_INCLUDEDIR-NOTFOUND CACHE STRING "" FORCE)

	FIND_PATH(PQ_DIR libpq-fe.h
		HINTS
		ENV PQ_DIR
		PATH_SUFFIXES include
		PATHS)
  FIND_PATH(PIO_DB PIODB.h
		HINTS
		ENV DMC_DIR
		PATH_SUFFIXES HL2_DMC include/HL2_DMC
		PATHS)
	FIND_PATH(PIO_ERR PIOErr.h
		HINTS
		ENV DMC_DIR
		PATH_SUFFIXES HL2_PIOLIB include/HL2_PIOLIB
		PATHS)
	if(PIO_DB AND PIO_ERR AND PQ_DIR)
		set(DMC_INCLUDEDIR ${PIO_DB}/..)
	endif()
	if(NOT PIO_DB STREQUAL PIO_ERR)
		set(DMC_INCLUDEDIR ${DMC_INCLUDEDIR} ${PIO_ERR}/..)
	endif()
	FIND_LIBRARY(DMC_LIBRARY piolib
		HINTS
		ENV DMC_DIR
		PATH_SUFFIXES lib lib/Linux-x86_64
		PATHS)
endif()

#message(STATUS "PIO_DB ${PIO_DB}")
#message(STATUS "PIO_ERR ${PIO_ERR}")
#message(STATUS "PQ_H ${PQ_H}")

IF(DMC_INCLUDEDIR AND DMC_LIBRARY AND PQ_DIR)
	MESSAGE(STATUS "DMC found at ${DMC_INCLUDEDIR}")
	SET(DMC_INCLUDE_DIR ${DMC_INCLUDEDIR} ${PQ_DIR})
	SET(DMC_LIBRARIES ${DMC_LIBRARY})
	SET(dmc 1)
ELSE()
	MESSAGE(STATUS "DMC not found.")
ENDIF()

#message(STATUS "DMC: ${DMC_INCLUDEDIR}")
#message(STATUS "DMC: ${DMC_LIBRARIES}")




