/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.codeInsight.postfix;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/codeInsight/postfix")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class PostfixTemplateProviderTestGenerated extends AbstractPostfixTemplateProviderTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInPostfix() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/postfix"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("assert.kt")
    public void testAssert() throws Exception {
        runTest("idea/testData/codeInsight/postfix/assert.kt");
    }

    @TestMetadata("assertNonTopLevel.kt")
    public void testAssertNonTopLevel() throws Exception {
        runTest("idea/testData/codeInsight/postfix/assertNonTopLevel.kt");
    }

    @TestMetadata("doNotProposeWrappingIncrement.kt")
    public void testDoNotProposeWrappingIncrement() throws Exception {
        runTest("idea/testData/codeInsight/postfix/doNotProposeWrappingIncrement.kt");
    }

    @TestMetadata("else.kt")
    public void testElse() throws Exception {
        runTest("idea/testData/codeInsight/postfix/else.kt");
    }

    @TestMetadata("for.kt")
    public void testFor() throws Exception {
        runTest("idea/testData/codeInsight/postfix/for.kt");
    }

    @TestMetadata("forOnMap.kt")
    public void testForOnMap() throws Exception {
        runTest("idea/testData/codeInsight/postfix/forOnMap.kt");
    }

    @TestMetadata("forOnString.kt")
    public void testForOnString() throws Exception {
        runTest("idea/testData/codeInsight/postfix/forOnString.kt");
    }

    @TestMetadata("if.kt")
    public void testIf() throws Exception {
        runTest("idea/testData/codeInsight/postfix/if.kt");
    }

    @TestMetadata("iter.kt")
    public void testIter() throws Exception {
        runTest("idea/testData/codeInsight/postfix/iter.kt");
    }

    @TestMetadata("noParOnLoop.kt")
    public void testNoParOnLoop() throws Exception {
        runTest("idea/testData/codeInsight/postfix/noParOnLoop.kt");
    }

    @TestMetadata("noReturnForNonStatement.kt")
    public void testNoReturnForNonStatement() throws Exception {
        runTest("idea/testData/codeInsight/postfix/noReturnForNonStatement.kt");
    }

    @TestMetadata("notBoolean.kt")
    public void testNotBoolean() throws Exception {
        runTest("idea/testData/codeInsight/postfix/notBoolean.kt");
    }

    @TestMetadata("notString.kt")
    public void testNotString() throws Exception {
        runTest("idea/testData/codeInsight/postfix/notString.kt");
    }

    @TestMetadata("notnull.kt")
    public void testNotnull() throws Exception {
        runTest("idea/testData/codeInsight/postfix/notnull.kt");
    }

    @TestMetadata("null.kt")
    public void testNull() throws Exception {
        runTest("idea/testData/codeInsight/postfix/null.kt");
    }

    @TestMetadata("par.kt")
    public void testPar() throws Exception {
        runTest("idea/testData/codeInsight/postfix/par.kt");
    }

    @TestMetadata("parAfterUserType.kt")
    public void testParAfterUserType() throws Exception {
        runTest("idea/testData/codeInsight/postfix/parAfterUserType.kt");
    }

    @TestMetadata("parAssignment.kt")
    public void testParAssignment() throws Exception {
        runTest("idea/testData/codeInsight/postfix/parAssignment.kt");
    }

    @TestMetadata("return.kt")
    public void testReturn() throws Exception {
        runTest("idea/testData/codeInsight/postfix/return.kt");
    }

    @TestMetadata("returnFromLoop.kt")
    public void testReturnFromLoop() throws Exception {
        runTest("idea/testData/codeInsight/postfix/returnFromLoop.kt");
    }

    @TestMetadata("sout.kt")
    public void testSout() throws Exception {
        runTest("idea/testData/codeInsight/postfix/sout.kt");
    }

    @TestMetadata("soutInIf.kt")
    public void testSoutInIf() throws Exception {
        runTest("idea/testData/codeInsight/postfix/soutInIf.kt");
    }

    @TestMetadata("soutInLoop.kt")
    public void testSoutInLoop() throws Exception {
        runTest("idea/testData/codeInsight/postfix/soutInLoop.kt");
    }

    @TestMetadata("spread.kt")
    public void testSpread() throws Exception {
        runTest("idea/testData/codeInsight/postfix/spread.kt");
    }

    @TestMetadata("spreadIntArray.kt")
    public void testSpreadIntArray() throws Exception {
        runTest("idea/testData/codeInsight/postfix/spreadIntArray.kt");
    }

    @TestMetadata("try.kt")
    public void testTry() throws Exception {
        runTest("idea/testData/codeInsight/postfix/try.kt");
    }

    @TestMetadata("tryInLocalClass.kt")
    public void testTryInLocalClass() throws Exception {
        runTest("idea/testData/codeInsight/postfix/tryInLocalClass.kt");
    }

    @TestMetadata("tryOnFor.kt")
    public void testTryOnFor() throws Exception {
        runTest("idea/testData/codeInsight/postfix/tryOnFor.kt");
    }

    @TestMetadata("tryOnImportStatement.kt")
    public void testTryOnImportStatement() throws Exception {
        runTest("idea/testData/codeInsight/postfix/tryOnImportStatement.kt");
    }

    @TestMetadata("tryOnStatement.kt")
    public void testTryOnStatement() throws Exception {
        runTest("idea/testData/codeInsight/postfix/tryOnStatement.kt");
    }

    @TestMetadata("val.kt")
    public void testVal() throws Exception {
        runTest("idea/testData/codeInsight/postfix/val.kt");
    }

    @TestMetadata("valAfterReceiver.kt")
    public void testValAfterReceiver() throws Exception {
        runTest("idea/testData/codeInsight/postfix/valAfterReceiver.kt");
    }

    @TestMetadata("valAfterSelector.kt")
    public void testValAfterSelector() throws Exception {
        runTest("idea/testData/codeInsight/postfix/valAfterSelector.kt");
    }

    @TestMetadata("valAtLamba.kt")
    public void testValAtLamba() throws Exception {
        runTest("idea/testData/codeInsight/postfix/valAtLamba.kt");
    }

    @TestMetadata("valAtLambaArgumentInCall.kt")
    public void testValAtLambaArgumentInCall() throws Exception {
        runTest("idea/testData/codeInsight/postfix/valAtLambaArgumentInCall.kt");
    }

    @TestMetadata("var.kt")
    public void testVar() throws Exception {
        runTest("idea/testData/codeInsight/postfix/var.kt");
    }

    @TestMetadata("when.kt")
    public void testWhen() throws Exception {
        runTest("idea/testData/codeInsight/postfix/when.kt");
    }

    @TestMetadata("whenExpression.kt")
    public void testWhenExpression() throws Exception {
        runTest("idea/testData/codeInsight/postfix/whenExpression.kt");
    }

    @TestMetadata("while.kt")
    public void testWhile() throws Exception {
        runTest("idea/testData/codeInsight/postfix/while.kt");
    }

    @TestMetadata("idea/testData/codeInsight/postfix/wrapWithCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WrapWithCall extends AbstractPostfixTemplateProviderTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWrapWithCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/postfix/wrapWithCall"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayOfStatement.kt")
        public void testArrayOfStatement() throws Exception {
            runTest("idea/testData/codeInsight/postfix/wrapWithCall/arrayOfStatement.kt");
        }

        @TestMetadata("listOf.kt")
        public void testListOf() throws Exception {
            runTest("idea/testData/codeInsight/postfix/wrapWithCall/listOf.kt");
        }

        @TestMetadata("returnSequenceOf.kt")
        public void testReturnSequenceOf() throws Exception {
            runTest("idea/testData/codeInsight/postfix/wrapWithCall/returnSequenceOf.kt");
        }

        @TestMetadata("setOf.kt")
        public void testSetOf() throws Exception {
            runTest("idea/testData/codeInsight/postfix/wrapWithCall/setOf.kt");
        }
    }
}
