/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QtGui/QInputDialog>
#include <QtGui/QStringListModel>

#include "itemview.h"

#include "networksfield.h"

using namespace Form;

class NetworkModel : public QStringListModel
{
  public:
    NetworkModel( QObject *parent = 0 )
      : QStringListModel( parent )
    {
    }

    virtual Qt::ItemFlags flags( const QModelIndex& ) const
    {
      return ( Qt::ItemIsSelectable | Qt::ItemIsEnabled );
    }
};

class NetworkItemView : public ItemView
{
  public:
    NetworkItemView( QWidget *parent )
      : ItemView( parent )
    {
    }

  protected:
    virtual void doAdd()
    {
      bool ok = true;

      QString network = QInputDialog::getText( this, tr( "New Network" ), tr( "Network:" ),
                                            QLineEdit::Normal, QString(), &ok );

      if ( ok && !network.isEmpty() ) {
        QAbstractItemModel *model = mListView->model();

        bool found = false;
        for ( int i = 0; i < model->rowCount(); ++i ) {
          if ( network == model->data( model->index( i, 0 ), Qt::DisplayRole ).toString() ) {
            found = true;
            break;
          }
        }

        if ( !found ) {
          int pos = model->rowCount();
          model->insertRow( pos );
          model->setData( model->index( pos, 0 ), network );
        }
      }
    }
};

NetworksField::NetworksField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mView = new NetworkItemView( this );

  mModel = new NetworkModel( this );
  mView->setModel( mModel );

  fieldLayout()->addWidget( mView, 0, 0 );
}

void NetworksField::loadEntry( const Entry &entry )
{
  mModel->setStringList( entry.values( "postfix-mynetworks" ) );
}

void NetworksField::saveEntry( Entry &entry ) const
{
  entry.clearValue( "postfix-mynetworks" );

  const QStringList networks = mModel->stringList();
  for ( int i = 0; i < networks.count(); ++i ) {
    entry.addValue( "postfix-mynetworks", networks[ i ] );
  }
}

bool NetworksField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void NetworksField::setEditable( bool editable )
{
  mView->setEnabled( editable );
}

