/*
 * Created on Jan 3, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.prolixtech.jaminid_examples;

import java.io.File;
import java.io.IOException;

import com.prolixtech.jaminid.ContentOracle;
import com.prolixtech.jaminid.Daemon;
import com.prolixtech.jaminid.Protocol;
import com.prolixtech.jaminid.Request;
import com.prolixtech.jaminid.Response;

/**
 * @author Constantinos Michael
 *
 */
public class SimpleServer extends ContentOracle {

    private static Daemon daemon;
    private final static int PORT = 8080; 
    
    private static final String ROOT_PATH = "doc/";
    private static final String DEFAULT = "index.html";
    
    private String root_canonical;
    public SimpleServer(){
        
        File root_p = new File(ROOT_PATH);
        if(!root_p.exists()) {
            throw new IllegalArgumentException("ROOT PATH CAN'T BE FOUND: " + ROOT_PATH);
        }
        try{
            root_canonical = root_p.getCanonicalPath();
        } catch (Exception e) {
            throw new IllegalArgumentException("IO ERROR WITH: " + ROOT_PATH);
        }
    }
    
    public String demultiplex(Request connRequest, Response connResponse) {
        String loc = connRequest.getLocation();
        if(loc.equals("/")) loc = DEFAULT;
        File x = new File(ROOT_PATH + loc);
        
        
        try {
            x = x.getCanonicalFile();
            if(! (x.getAbsolutePath().startsWith(root_canonical))) throw new IOException("Not within filesystem limits");
            connResponse.sendFile(x);
        } catch (IOException e) {
            connResponse.setStatus(Protocol.NOT_FOUND);
        } catch (Exception e){
            connResponse.setStatus(Protocol.INTERNAL_SERVER_ERROR);
        }
        return "";
        
    }
    
    public static void main(String[] args) {

        SimpleServer s = new SimpleServer();
        daemon = new Daemon(PORT, s);
        System.out.println("The webserver is now running! Visit http://localhost:" + PORT + " through your favorite web browser.");
        
    }
}
