/*========================== begin_copyright_notice ============================

Copyright (C) 2017-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

/*
 * !!! DO NOT EDIT THIS FILE !!!
 *
 * This file was automagically crafted by GED's model parser.
 */


#ifndef GED_H
#define GED_H


#ifndef GED_VALIDATION_API
#define GED_VALIDATION_API 0
#endif // GED_VALIDATION_API

#ifndef GED_EXPERIMENTAL
#define GED_EXPERIMENTAL 0
#endif // GED_EXPERIMENTAL

#ifndef GED_CALLCONV
#define GED_CALLCONV
#endif // GED_CALLCONV
#include "ged_basic_types.h"
#include "ged_enum_types.h"
#include "ged_ins_field.h"
#include "ged_enumerations.h"

/*!
 * This is an opaque type for holding a GED instruction. The data should be accessed using the APIs supplied in this header. Before
 * using a ged_ins_t object, one of @ref GED_DecodeIns or @ref GED_InitEmptyIns must be called. Calling any other function will result
 * in undefined behavior.
 */
typedef struct
{
    char _dummy[32]; // dummy, do not access directly
} ged_ins_t;

/*!
 * Enable tracing of GED calls
 */
extern int GED_TraceAPICalls;
#define GED_TraceAPI(msg) (GED_TraceAPICalls ? (std::cout << (msg) << std::endl),false : false)

/*!
 * This enumeration holds the models supported by GED.
 */
typedef enum
{

    /*!
     * GED Model Version: none
     * Supported CPUs: none
     */
    GED_MODEL_NONE,

    /*!
     * GED Model Version: 7
     * Supported CPUs: ivb
     */
    GED_MODEL_7,

    /*!
     * GED Model Version: 7.5
     * Supported CPUs: hsw
     */
    GED_MODEL_7_5,

    /*!
     * GED Model Version: 8
     * Supported CPUs: bdw
     */
    GED_MODEL_8,

    /*!
     * GED Model Version: 8.1
     * Supported CPUs: chv
     */
    GED_MODEL_8_1,

    /*!
     * GED Model Version: 9
     * Supported CPUs: skl
     */
    GED_MODEL_9,

    /*!
     * GED Model Version: 10
     * Supported CPUs: cnl
     */
    GED_MODEL_10,

    /*!
     * GED Model Version: 11
     * Supported CPUs: icl
     */
    GED_MODEL_11,

    /*!
     * GED Model Version: tgl
     * Supported CPUs: DashG
     */
    GED_MODEL_TGL,

    /*!
     * GED Model Version: xe.hp
     * Supported CPUs: XeHP
     */
    GED_MODEL_XE_HP,

    /*!
     * GED Model Version: xe.hpg
     * Supported CPUs: XeHPG
     */
    GED_MODEL_XE_HPG,

    /*!
     * GED Model Version: xe.hpc.a
     * Supported CPUs: XeHpcA
     */
    GED_MODEL_XE_HPC_A,

    /*!
     * GED Model Version: xe.hpc
     * Supported CPUs: XeHpc
     */
    GED_MODEL_XE_HPC,

    /*!
     * GED Model Version: xe.lpg.md
     * Supported CPUs: Xe_LPG_MD
     */
    GED_MODEL_XE_LPG_MD,
    GED_MODEL_INVALID
} GED_MODEL;

/*!
 * Get the GED model version (in string form) for the given GED_MODEL Id.
 * If the Id is not valid, return an empty string
 *
 * @param[in]       model  The GED model.
 *
 * @return      The requested string, otherwise an empty string.
 */
extern const char* GED_CALLCONV _GED_GetModelVersionString(GED_MODEL model);
#define GED_GetModelVersionString(model) ( \
    GED_TraceAPI("GED_GetModelVersionString(" #model ")"), \
    _GED_GetModelVersionString(model))

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

/*!
 * Get the string representation for the given GED_RETURN_VALUE enumerator.
 * If the value is not valid, return an empty string
 *
 * @param[in]       returnValue    The given GED_RETURN_VALUE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetReturnValueString(GED_RETURN_VALUE returnValue);
#define GED_GetReturnValueString(returnValue) ( \
    GED_TraceAPI("GED_GetReturnValueString(" #returnValue ")"), \
    _GED_GetReturnValueString(returnValue))

/*!
 * Get the padding of the GED_RETURN_VALUE enum's string representation in order for it to be aligned column-wise.
 * If the value is not valid, return an empty string
 *
 * @param[in]       returnValue    The given GED_RETURN_VALUE enumerator.
 *
 * @return      The requested pad.
 */
extern const char* GED_CALLCONV _GED_GetReturnValuePad(GED_RETURN_VALUE returnValue);
#define GED_GetReturnValuePad(returnValue) ( \
    GED_TraceAPI("GED_GetReturnValuePad(" #returnValue ")"), \
    _GED_GetReturnValuePad(returnValue))

/*!
 * Initialize an empty ged_ins_t object and set its opcode. Can be called to initialize a newly allocated object or to clear an
 * existing one. Typically, this function is used for encoding instructions from scratch. For decoding, one may call @ref
 * GED_DecodeIns directly without calling this function first.
 *
 * @param[in]       modelId    The GED model for the instruction.
 * @param[in,out]   ins        Pointer to the ged_ins_t object to be initialized.
 * @param[in]       opcode     The new opcode.
 *
 * @return      GED_RETURN_VALUE indicating success or invalid opcode.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_InitEmptyIns(const GED_MODEL modelId, ged_ins_t* ins, GED_OPCODE opcode);
#define GED_InitEmptyIns(modelId, ins, opcode) ( \
    GED_TraceAPI("GED_InitEmptyIns(" #modelId ", " #ins ", " #opcode ")"), \
    _GED_InitEmptyIns(modelId, ins, opcode))

/*!
 * Decode a single instruction. If the array of raw bytes includes several instructions, only one instruction will be decoded and the
 * remaining bytes will be ignored.
 *
 * @param[in]       modelId    The GED model for the instruction.
 * @param[in]       rawBytes   An array of size "size" with the raw bytes of the instruction to decode.
 * @param[in]       size       The number of bytes in the "rawBytes" array.
 * @param[out]      ins        Pointer in which to store the decoded instruction (must be preallocated by the calling function).
 *
 * @return      GED_RETURN_VALUE indicating success or decoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_DecodeIns(const GED_MODEL modelId, const unsigned char* rawBytes, const uint32_t size,
                                                    ged_ins_t* ins);
#define GED_DecodeIns(modelId, rawBytes, size, ins) ( \
    GED_TraceAPI("GED_DecodeIns(" #modelId ", " #rawBytes ", " #size ", " #ins ")"), \
    _GED_DecodeIns(modelId, rawBytes, size, ins))

/*!
 * Encode the given instruction and store the raw bytes in the given array. If the instruction cannot be encoded as requested, the
 * array will remain unchanged. The array is expected to be preallocated and large enough to hold the requested instruction bytes. One
 * may provide a NULL pointer instead, in which case the encoding operation will occur, validating the instruction, but the encoded
 * bytes will not be stored.
 *
 * @param[in]       ins        Pointer to the instruction object.
 * @param[in]       insType    Determine if instruction should be compacted or not. If the instruction does not have a valid compact
 *                             form, the rawBytes buffer will remain unchanged and error will be returned.
 * @param[out]      rawBytes   A preallocated buffer in which to store the instruction bytes. The buffer is expected to be large
 *                             enough to hold the requested instruction bytes. One may pass a NULL pointer, in which case the encoded
 *                             instruction bytes will not be stored.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_EncodeIns(ged_ins_t* ins, const GED_INS_TYPE insType, unsigned char* rawBytes);
#define GED_EncodeIns(ins, insType, rawBytes) ( \
    GED_TraceAPI("GED_EncodeIns(" #ins ", " #insType ", " #rawBytes ")"), \
    _GED_EncodeIns(ins, insType, rawBytes))

/*!
 * Get the size (in bytes) of the given instruction. See @ref GED_IsCompact for details.
 *
 * @param[in]       ins    Pointer to the instruction object.
 *
 * @return      The size (in bytes) of the given instruction.
 */
extern uint32_t GED_CALLCONV _GED_InsSize(const ged_ins_t* ins);
#define GED_InsSize(ins) ( \
    GED_TraceAPI("GED_InsSize(" #ins ")"), \
    _GED_InsSize(ins))

/*!
 * Check if the given instruction was modified (i.e. on of the instruction field setter APIs was called) since it was last
 * decoded/encoded (i.e. since the last call to @ref GED_DecodeIns or @ref GED_EncodeIns).
 *
 * @param[in]       ins    Pointer to the instruction object.
 *
 * @return      TRUE if the instruction was modified since the last decode/encode operation.
 */
extern bool GED_CALLCONV _GED_InsModified(const ged_ins_t* ins);
#define GED_InsModified(ins) ( \
    GED_TraceAPI("GED_InsModified(" #ins ")"), \
    _GED_InsModified(ins))

#if GED_VALIDATION_API

/*!
 * Count the amount of valid compact encodings the instruction has.
 *
 * @param[in]       ins    Pointer to the instruction object.
 * @param[out]      count  The number of valid compact encodings the instruction has. If an instruction does not have a valid compact
 *                         encoding, result is undefined.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_CountCompactEncodings(ged_ins_t* ins, unsigned int& count);
#define GED_CountCompactEncodings(ins, count) ( \
    GED_TraceAPI("GED_CountCompactEncodings(" #ins ", " #count ")"), \
    _GED_CountCompactEncodings(ins, count))

/*!
 * Generate all valid compact encodings of the instruction. The buffer is expected to be preallocated and large enough to hold the
 * requested instructions' bytes. Use @ref GED_CountCompactEncodings get the amount of expected compact encodings.
 *
 * @param[in]       ins                Pointer to the instruction object.
 * @param[in]       size               The size of the preallocated buffer compactBytesArray, in bytes.
 * @param[out]      compactBytesArray  A preallocated buffer in which to store the instruction bytes. The buffer is expected to be
 *                                     large enough to hold the requested instructions' bytes.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_GetCompactEncodings(ged_ins_t* ins, const unsigned int size, unsigned char*
                                                              compactBytesArray);
#define GED_GetCompactEncodings(ins, size, compactBytesArray) ( \
    GED_TraceAPI("GED_GetCompactEncodings(" #ins ", " #size ", " #compactBytesArray ")"), \
    _GED_GetCompactEncodings(ins, size, compactBytesArray))

/*!
 * Print all bit positions and their mapping of given field in the instruction.If a field is invalid, print accordingly. If a fragment
 * of the field has a fixed value("padded"), print its fixed value
 *
 * @param[in]       ins    Pointer to the instruction object containing the field in question.
 * @param[in]       field  The requested field.
 *
 * @return      GED_RETURN_VALUE indicating success or decoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_PrintFieldBitLocation(const ged_ins_t* ins, const GED_INS_FIELD field);
#define GED_PrintFieldBitLocation(ins, field) ( \
    GED_TraceAPI("GED_PrintFieldBitLocation(" #ins ", " #field ")"), \
    _GED_PrintFieldBitLocation(ins, field))
#endif // GED_VALIDATION_API

/*!
 * Return encoding of field within instruction bytes
 *
 * @param[in]       ins        Pointer to the instruction object containing the field in question.
 * @param[in]       field      The requested field.
 * @param[in]       fragments  Array of fragments.
 * @param[in]       length     Length of fragments array.
 *
 * @return      GED_RETURN_VALUE indicating success or decoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_QueryFieldBitLocation(const ged_ins_t* ins, const GED_INS_FIELD field, uint32_t * fragments,
                                                                uint32_t * length);
#define GED_QueryFieldBitLocation(ins, field, fragments, length) ( \
    GED_TraceAPI("GED_QueryFieldBitLocation(" #ins ", " #field ", " #fragments ", " #length ")"), \
    _GED_QueryFieldBitLocation(ins, field, fragments, length))

/*!
 * Get the size (in bits) of the given field within the given instruction. If the field is invalid for the given instruction, the
 * function returns 0.
 *
 * @param[in]       ins    Pointer to the instruction object containing the field in question.
 * @param[in]       field  The requested field.
 *
 * @return      The field's size (in bits) if it is valid, 0 otherwise.
 */
extern uint32_t GED_CALLCONV _GED_FieldSize(const ged_ins_t* ins, const GED_INS_FIELD field);
#define GED_FieldSize(ins, field) ( \
    GED_TraceAPI("GED_FieldSize(" #ins ", " #field ")"), \
    _GED_FieldSize(ins, field))

/*!
 * Get the given instruction's opcode. The function returns an enumeration value, use @ref GED_GetMnemonic to obtain the instruction's
 * string mnemonic.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 *
 * @return      Opcode enumeration value as defined in ged_enumerations.h.
 */
extern GED_OPCODE GED_CALLCONV _GED_GetOpcode(const ged_ins_t* ins);
#define GED_GetOpcode(ins) ( \
    GED_TraceAPI("GED_GetOpcode(" #ins ")"), \
    _GED_GetOpcode(ins))

/*!
 * Get the given instruction's mnemonic.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 *
 * @return      String representation of the instruction's mnemonic.
 */
extern const char* GED_CALLCONV _GED_GetMnemonic(const ged_ins_t* ins);
#define GED_GetMnemonic(ins) ( \
    GED_TraceAPI("GED_GetMnemonic(" #ins ")"), \
    _GED_GetMnemonic(ins))

/*!
 * Set a new opcode in the given instruction. If the instruction layout changes due to the new opcode, all other bits will be cleared
 * (effectively invalidating all the instruction fields). If the layout does not change, all the other instruction fields' values will
 * remain unchanged.
 *
 * @param[in,out]   ins    Pointer to the decoded instruction object.
 * @param[in]       opcode The new opcode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetOpcode(ged_ins_t* ins, const GED_OPCODE opcode);
#define GED_SetOpcode(ins, opcode) ( \
    GED_TraceAPI("GED_SetOpcode(" #ins ", " #opcode ")"), \
    _GED_SetOpcode(ins, opcode))

/*!
 * Check if the given instruction is compacted. For decoded instructions it reflects the state of the CmptCtrl bit. For Encoded
 * instructions, it reflects the encoded status. If @ref GED_EncodeIns was successfully called with compact=TRUE then the function
 * will return TRUE. If @ref GED_EncodeIns was successfully called with compact=FALSE, then the function will return FALSE regardless
 * of the validity of the instruction's compact form. This means that even if the instruction can be encoded as compact the function
 * will still return FALSE. If the instruction was modified since it was last decoded/encoded i.e. @ref GED_InsModified returns TRUE,
 * the behavior of this function is undefined and one must call @ref GED_EncodeIns in order to get a the correct result.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 *
 * @return      TRUE if the instruction is compacted i.e. in its compact form, FALSE, otherwise.
 */
extern bool GED_CALLCONV _GED_IsCompact(const ged_ins_t* ins);
#define GED_IsCompact(ins) ( \
    GED_TraceAPI("GED_IsCompact(" #ins ")"), \
    _GED_IsCompact(ins))

/*!
 * The function returns GED model of the specified instruction.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 *
 * @return      Model ID
 */
extern GED_MODEL GED_CALLCONV _GED_GetModel(const ged_ins_t* ins);
#define GED_GetModel(ins) ( \
    GED_TraceAPI("GED_GetModel(" #ins ")"), \
    _GED_GetModel(ins))

/*!
 * Get the value of the ___SrcImm field in the given instruction. See @ref GED_INS_FIELD____SrcImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_Get___SrcImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_Get___SrcImm(ins, result) ( \
    GED_TraceAPI("GED_Get___SrcImm(" #ins ", " #result ")"), \
    _GED_Get___SrcImm(ins, result))

/*!
 * Set the value of the ___SrcImm field in the given instruction. See @ref GED_INS_FIELD____SrcImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_Set___SrcImm(ged_ins_t* ins, const uint32_t value);
#define GED_Set___SrcImm(ins, value) ( \
    GED_TraceAPI("GED_Set___SrcImm(" #ins ", " #value ")"), \
    _GED_Set___SrcImm(ins, value))

/*!
 * Get the value of the NumOfSourceOperands field in the given instruction. See @ref GED_INS_FIELD_NumOfSourceOperands for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetNumOfSourceOperands(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetNumOfSourceOperands(ins, result) ( \
    GED_TraceAPI("GED_GetNumOfSourceOperands(" #ins ", " #result ")"), \
    _GED_GetNumOfSourceOperands(ins, result))

/*!
 * Get the value of the HasDestinationOperand field in the given instruction. See @ref GED_INS_FIELD_HasDestinationOperand for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetHasDestinationOperand(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetHasDestinationOperand(ins, result) ( \
    GED_TraceAPI("GED_GetHasDestinationOperand(" #ins ", " #result ")"), \
    _GED_GetHasDestinationOperand(ins, result))

/*!
 * Get the value of the AccessMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAccessModeString. See @ref GED_INS_FIELD_AccessMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      AccessMode's enumeration if the field is valid, GED_ACCESS_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ACCESS_MODE GED_CALLCONV _GED_GetAccessMode(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetAccessMode(ins, result) ( \
    GED_TraceAPI("GED_GetAccessMode(" #ins ", " #result ")"), \
    _GED_GetAccessMode(ins, result))

/*!
 * Set the value of the AccessMode field in the given instruction. See @ref GED_INS_FIELD_AccessMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetAccessMode(ged_ins_t* ins, const GED_ACCESS_MODE value);
#define GED_SetAccessMode(ins, value) ( \
    GED_TraceAPI("GED_SetAccessMode(" #ins ", " #value ")"), \
    _GED_SetAccessMode(ins, value))

/*!
 * Get the value of the MaskCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetMaskCtrlString. See @ref GED_INS_FIELD_MaskCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MaskCtrl's enumeration if the field is valid, GED_MASK_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MASK_CTRL GED_CALLCONV _GED_GetMaskCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMaskCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetMaskCtrl(" #ins ", " #result ")"), \
    _GED_GetMaskCtrl(ins, result))

/*!
 * Set the value of the MaskCtrl field in the given instruction. See @ref GED_INS_FIELD_MaskCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMaskCtrl(ged_ins_t* ins, const GED_MASK_CTRL value);
#define GED_SetMaskCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetMaskCtrl(" #ins ", " #value ")"), \
    _GED_SetMaskCtrl(ins, value))

/*!
 * Get the value of the DepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetDepCtrlString. See @ref GED_INS_FIELD_DepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DepCtrl's enumeration if the field is valid, GED_DEP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DEP_CTRL GED_CALLCONV _GED_GetDepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDepCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetDepCtrl(" #ins ", " #result ")"), \
    _GED_GetDepCtrl(ins, result))

/*!
 * Set the value of the DepCtrl field in the given instruction. See @ref GED_INS_FIELD_DepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDepCtrl(ged_ins_t* ins, const GED_DEP_CTRL value);
#define GED_SetDepCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetDepCtrl(" #ins ", " #value ")"), \
    _GED_SetDepCtrl(ins, value))

/*!
 * Get the value of the ExecMaskOffsetCtrl field in the given instruction. The function returns an enumeration value. To obtain the
 * enum entry's string representation, use @ref GED_GetExecMaskOffsetCtrlString. See @ref GED_INS_FIELD_ExecMaskOffsetCtrl for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ExecMaskOffsetCtrl's enumeration if the field is valid, GED_EXEC_MASK_OFFSET_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_EXEC_MASK_OFFSET_CTRL GED_CALLCONV _GED_GetExecMaskOffsetCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExecMaskOffsetCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetExecMaskOffsetCtrl(" #ins ", " #result ")"), \
    _GED_GetExecMaskOffsetCtrl(ins, result))

/*!
 * Set the value of the ExecMaskOffsetCtrl field in the given instruction. See @ref GED_INS_FIELD_ExecMaskOffsetCtrl for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExecMaskOffsetCtrl(ged_ins_t* ins, const GED_EXEC_MASK_OFFSET_CTRL value);
#define GED_SetExecMaskOffsetCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetExecMaskOffsetCtrl(" #ins ", " #value ")"), \
    _GED_SetExecMaskOffsetCtrl(ins, value))

/*!
 * Get the value of the ChannelOffset field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetChannelOffsetString. See @ref GED_INS_FIELD_ChannelOffset for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ChannelOffset's enumeration if the field is valid, GED_CHANNEL_OFFSET_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_CHANNEL_OFFSET GED_CALLCONV _GED_GetChannelOffset(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetChannelOffset(ins, result) ( \
    GED_TraceAPI("GED_GetChannelOffset(" #ins ", " #result ")"), \
    _GED_GetChannelOffset(ins, result))

/*!
 * Set the value of the ChannelOffset field in the given instruction. See @ref GED_INS_FIELD_ChannelOffset for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetChannelOffset(ged_ins_t* ins, const GED_CHANNEL_OFFSET value);
#define GED_SetChannelOffset(ins, value) ( \
    GED_TraceAPI("GED_SetChannelOffset(" #ins ", " #value ")"), \
    _GED_SetChannelOffset(ins, value))

/*!
 * Get the value of the ThreadCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetThreadCtrlString. See @ref GED_INS_FIELD_ThreadCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ThreadCtrl's enumeration if the field is valid, GED_THREAD_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_THREAD_CTRL GED_CALLCONV _GED_GetThreadCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetThreadCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetThreadCtrl(" #ins ", " #result ")"), \
    _GED_GetThreadCtrl(ins, result))

/*!
 * Set the value of the ThreadCtrl field in the given instruction. See @ref GED_INS_FIELD_ThreadCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetThreadCtrl(ged_ins_t* ins, const GED_THREAD_CTRL value);
#define GED_SetThreadCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetThreadCtrl(" #ins ", " #value ")"), \
    _GED_SetThreadCtrl(ins, value))

/*!
 * Get the value of the PredCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetPredCtrlString. See @ref GED_INS_FIELD_PredCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      PredCtrl's enumeration if the field is valid, GED_PRED_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_PRED_CTRL GED_CALLCONV _GED_GetPredCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetPredCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetPredCtrl(" #ins ", " #result ")"), \
    _GED_GetPredCtrl(ins, result))

/*!
 * Set the value of the PredCtrl field in the given instruction. See @ref GED_INS_FIELD_PredCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetPredCtrl(ged_ins_t* ins, const GED_PRED_CTRL value);
#define GED_SetPredCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetPredCtrl(" #ins ", " #value ")"), \
    _GED_SetPredCtrl(ins, value))

/*!
 * Get the value of the PredInv field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetPredInvString. See @ref GED_INS_FIELD_PredInv for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      PredInv's enumeration if the field is valid, GED_PRED_INV_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_PRED_INV GED_CALLCONV _GED_GetPredInv(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetPredInv(ins, result) ( \
    GED_TraceAPI("GED_GetPredInv(" #ins ", " #result ")"), \
    _GED_GetPredInv(ins, result))

/*!
 * Set the value of the PredInv field in the given instruction. See @ref GED_INS_FIELD_PredInv for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetPredInv(ged_ins_t* ins, const GED_PRED_INV value);
#define GED_SetPredInv(ins, value) ( \
    GED_TraceAPI("GED_SetPredInv(" #ins ", " #value ")"), \
    _GED_SetPredInv(ins, value))

/*!
 * Get the value of the ExecSize field in the given instruction. See @ref GED_INS_FIELD_ExecSize for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetExecSize(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExecSize(ins, result) ( \
    GED_TraceAPI("GED_GetExecSize(" #ins ", " #result ")"), \
    _GED_GetExecSize(ins, result))

/*!
 * Set the value of the ExecSize field in the given instruction. See @ref GED_INS_FIELD_ExecSize for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExecSize(ged_ins_t* ins, const uint32_t value);
#define GED_SetExecSize(ins, value) ( \
    GED_TraceAPI("GED_SetExecSize(" #ins ", " #value ")"), \
    _GED_SetExecSize(ins, value))

/*!
 * Get the value of the CondModifier field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetCondModifierString. See @ref GED_INS_FIELD_CondModifier for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      CondModifier's enumeration if the field is valid, GED_COND_MODIFIER_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_COND_MODIFIER GED_CALLCONV _GED_GetCondModifier(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetCondModifier(ins, result) ( \
    GED_TraceAPI("GED_GetCondModifier(" #ins ", " #result ")"), \
    _GED_GetCondModifier(ins, result))

/*!
 * Set the value of the CondModifier field in the given instruction. See @ref GED_INS_FIELD_CondModifier for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetCondModifier(ged_ins_t* ins, const GED_COND_MODIFIER value);
#define GED_SetCondModifier(ins, value) ( \
    GED_TraceAPI("GED_SetCondModifier(" #ins ", " #value ")"), \
    _GED_SetCondModifier(ins, value))

/*!
 * Get the value of the AccWrCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAccWrCtrlString. See @ref GED_INS_FIELD_AccWrCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      AccWrCtrl's enumeration if the field is valid, GED_ACC_WR_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ACC_WR_CTRL GED_CALLCONV _GED_GetAccWrCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetAccWrCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetAccWrCtrl(" #ins ", " #result ")"), \
    _GED_GetAccWrCtrl(ins, result))

/*!
 * Set the value of the AccWrCtrl field in the given instruction. See @ref GED_INS_FIELD_AccWrCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetAccWrCtrl(ged_ins_t* ins, const GED_ACC_WR_CTRL value);
#define GED_SetAccWrCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetAccWrCtrl(" #ins ", " #value ")"), \
    _GED_SetAccWrCtrl(ins, value))

/*!
 * Get the value of the DebugCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDebugCtrlString. See @ref GED_INS_FIELD_DebugCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DebugCtrl's enumeration if the field is valid, GED_DEBUG_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DEBUG_CTRL GED_CALLCONV _GED_GetDebugCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDebugCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetDebugCtrl(" #ins ", " #result ")"), \
    _GED_GetDebugCtrl(ins, result))

/*!
 * Set the value of the DebugCtrl field in the given instruction. See @ref GED_INS_FIELD_DebugCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDebugCtrl(ged_ins_t* ins, const GED_DEBUG_CTRL value);
#define GED_SetDebugCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetDebugCtrl(" #ins ", " #value ")"), \
    _GED_SetDebugCtrl(ins, value))

/*!
 * Get the value of the Saturate field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetSaturateString. See @ref GED_INS_FIELD_Saturate for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Saturate's enumeration if the field is valid, GED_SATURATE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SATURATE GED_CALLCONV _GED_GetSaturate(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSaturate(ins, result) ( \
    GED_TraceAPI("GED_GetSaturate(" #ins ", " #result ")"), \
    _GED_GetSaturate(ins, result))

/*!
 * Set the value of the Saturate field in the given instruction. See @ref GED_INS_FIELD_Saturate for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSaturate(ged_ins_t* ins, const GED_SATURATE value);
#define GED_SetSaturate(ins, value) ( \
    GED_TraceAPI("GED_SetSaturate(" #ins ", " #value ")"), \
    _GED_SetSaturate(ins, value))

/*!
 * Get the value of the DstRegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_DstRegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstRegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV _GED_GetDstRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstRegFile(ins, result) ( \
    GED_TraceAPI("GED_GetDstRegFile(" #ins ", " #result ")"), \
    _GED_GetDstRegFile(ins, result))

/*!
 * Set the value of the DstRegFile field in the given instruction. See @ref GED_INS_FIELD_DstRegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstRegFile(ged_ins_t* ins, const GED_REG_FILE value);
#define GED_SetDstRegFile(ins, value) ( \
    GED_TraceAPI("GED_SetDstRegFile(" #ins ", " #value ")"), \
    _GED_SetDstRegFile(ins, value))

/*!
 * Get the value of the DstDataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_DstDataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstDataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV _GED_GetDstDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstDataType(ins, result) ( \
    GED_TraceAPI("GED_GetDstDataType(" #ins ", " #result ")"), \
    _GED_GetDstDataType(ins, result))

/*!
 * Set the value of the DstDataType field in the given instruction. See @ref GED_INS_FIELD_DstDataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstDataType(ged_ins_t* ins, const GED_DATA_TYPE value);
#define GED_SetDstDataType(ins, value) ( \
    GED_TraceAPI("GED_SetDstDataType(" #ins ", " #value ")"), \
    _GED_SetDstDataType(ins, value))

/*!
 * Get the value of the Src0RegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_Src0RegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0RegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV _GED_GetSrc0RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0RegFile(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0RegFile(" #ins ", " #result ")"), \
    _GED_GetSrc0RegFile(ins, result))

/*!
 * Set the value of the Src0RegFile field in the given instruction. See @ref GED_INS_FIELD_Src0RegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0RegFile(ged_ins_t* ins, const GED_REG_FILE value);
#define GED_SetSrc0RegFile(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0RegFile(" #ins ", " #value ")"), \
    _GED_SetSrc0RegFile(ins, value))

/*!
 * Get the value of the Src0DataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_Src0DataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0DataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV _GED_GetSrc0DataType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0DataType(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0DataType(" #ins ", " #result ")"), \
    _GED_GetSrc0DataType(ins, result))

/*!
 * Set the value of the Src0DataType field in the given instruction. See @ref GED_INS_FIELD_Src0DataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0DataType(ged_ins_t* ins, const GED_DATA_TYPE value);
#define GED_SetSrc0DataType(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0DataType(" #ins ", " #value ")"), \
    _GED_SetSrc0DataType(ins, value))

/*!
 * Get the value of the Src1RegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_Src1RegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1RegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV _GED_GetSrc1RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1RegFile(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1RegFile(" #ins ", " #result ")"), \
    _GED_GetSrc1RegFile(ins, result))

/*!
 * Set the value of the Src1RegFile field in the given instruction. See @ref GED_INS_FIELD_Src1RegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1RegFile(ged_ins_t* ins, const GED_REG_FILE value);
#define GED_SetSrc1RegFile(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1RegFile(" #ins ", " #value ")"), \
    _GED_SetSrc1RegFile(ins, value))

/*!
 * Get the value of the Src1DataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_Src1DataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1DataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV _GED_GetSrc1DataType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1DataType(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1DataType(" #ins ", " #result ")"), \
    _GED_GetSrc1DataType(ins, result))

/*!
 * Set the value of the Src1DataType field in the given instruction. See @ref GED_INS_FIELD_Src1DataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1DataType(ged_ins_t* ins, const GED_DATA_TYPE value);
#define GED_SetSrc1DataType(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1DataType(" #ins ", " #value ")"), \
    _GED_SetSrc1DataType(ins, value))

/*!
 * Get the value of the DstChanEn field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDstChanEnString. See @ref GED_INS_FIELD_DstChanEn for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstChanEn's enumeration if the field is valid, GED_DST_CHAN_EN_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DST_CHAN_EN GED_CALLCONV _GED_GetDstChanEn(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstChanEn(ins, result) ( \
    GED_TraceAPI("GED_GetDstChanEn(" #ins ", " #result ")"), \
    _GED_GetDstChanEn(ins, result))

/*!
 * Set the value of the DstChanEn field in the given instruction. See @ref GED_INS_FIELD_DstChanEn for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstChanEn(ged_ins_t* ins, const GED_DST_CHAN_EN value);
#define GED_SetDstChanEn(ins, value) ( \
    GED_TraceAPI("GED_SetDstChanEn(" #ins ", " #value ")"), \
    _GED_SetDstChanEn(ins, value))

/*!
 * Get the value of the DstSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstSubRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDstSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstSubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetDstSubRegNum(" #ins ", " #result ")"), \
    _GED_GetDstSubRegNum(ins, result))

/*!
 * Set the value of the DstSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstSubRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstSubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetDstSubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetDstSubRegNum(" #ins ", " #value ")"), \
    _GED_SetDstSubRegNum(ins, value))

/*!
 * Get the value of the DstAddrImm field in the given instruction. See @ref GED_INS_FIELD_DstAddrImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV _GED_GetDstAddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstAddrImm(ins, result) ( \
    GED_TraceAPI("GED_GetDstAddrImm(" #ins ", " #result ")"), \
    _GED_GetDstAddrImm(ins, result))

/*!
 * Set the value of the DstAddrImm field in the given instruction. See @ref GED_INS_FIELD_DstAddrImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstAddrImm(ged_ins_t* ins, const int32_t value);
#define GED_SetDstAddrImm(ins, value) ( \
    GED_TraceAPI("GED_SetDstAddrImm(" #ins ", " #value ")"), \
    _GED_SetDstAddrImm(ins, value))

/*!
 * Get the value of the DstRegNum field in the given instruction. See @ref GED_INS_FIELD_DstRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDstRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetDstRegNum(" #ins ", " #result ")"), \
    _GED_GetDstRegNum(ins, result))

/*!
 * Set the value of the DstRegNum field in the given instruction. See @ref GED_INS_FIELD_DstRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetDstRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetDstRegNum(" #ins ", " #value ")"), \
    _GED_SetDstRegNum(ins, value))

/*!
 * Get the value of the DstAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstAddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDstAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstAddrSubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetDstAddrSubRegNum(" #ins ", " #result ")"), \
    _GED_GetDstAddrSubRegNum(ins, result))

/*!
 * Set the value of the DstAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DstAddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstAddrSubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetDstAddrSubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetDstAddrSubRegNum(" #ins ", " #value ")"), \
    _GED_SetDstAddrSubRegNum(ins, value))

/*!
 * Get the value of the DstHorzStride field in the given instruction. See @ref GED_INS_FIELD_DstHorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDstHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstHorzStride(ins, result) ( \
    GED_TraceAPI("GED_GetDstHorzStride(" #ins ", " #result ")"), \
    _GED_GetDstHorzStride(ins, result))

/*!
 * Set the value of the DstHorzStride field in the given instruction. See @ref GED_INS_FIELD_DstHorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstHorzStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetDstHorzStride(ins, value) ( \
    GED_TraceAPI("GED_SetDstHorzStride(" #ins ", " #value ")"), \
    _GED_SetDstHorzStride(ins, value))

/*!
 * Get the value of the DstAddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_DstAddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstAddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV _GED_GetDstAddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstAddrMode(ins, result) ( \
    GED_TraceAPI("GED_GetDstAddrMode(" #ins ", " #result ")"), \
    _GED_GetDstAddrMode(ins, result))

/*!
 * Set the value of the DstAddrMode field in the given instruction. See @ref GED_INS_FIELD_DstAddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstAddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);
#define GED_SetDstAddrMode(ins, value) ( \
    GED_TraceAPI("GED_SetDstAddrMode(" #ins ", " #value ")"), \
    _GED_SetDstAddrMode(ins, value))

/*!
 * Get the value of the Src0ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src0ChanSel for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0ChanSel(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0ChanSel(" #ins ", " #result ")"), \
    _GED_GetSrc0ChanSel(ins, result))

/*!
 * Set the value of the Src0ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src0ChanSel for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0ChanSel(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0ChanSel(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0ChanSel(" #ins ", " #value ")"), \
    _GED_SetSrc0ChanSel(ins, value))

/*!
 * Get the value of the Src0SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0SubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0SubRegNum(" #ins ", " #result ")"), \
    _GED_GetSrc0SubRegNum(ins, result))

/*!
 * Set the value of the Src0SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0SubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0SubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0SubRegNum(" #ins ", " #value ")"), \
    _GED_SetSrc0SubRegNum(ins, value))

/*!
 * Get the value of the Src0AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src0AddrImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV _GED_GetSrc0AddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0AddrImm(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0AddrImm(" #ins ", " #result ")"), \
    _GED_GetSrc0AddrImm(ins, result))

/*!
 * Set the value of the Src0AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src0AddrImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0AddrImm(ged_ins_t* ins, const int32_t value);
#define GED_SetSrc0AddrImm(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0AddrImm(" #ins ", " #value ")"), \
    _GED_SetSrc0AddrImm(ins, value))

/*!
 * Get the value of the Src0RegNum field in the given instruction. See @ref GED_INS_FIELD_Src0RegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0RegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0RegNum(" #ins ", " #result ")"), \
    _GED_GetSrc0RegNum(ins, result))

/*!
 * Set the value of the Src0RegNum field in the given instruction. See @ref GED_INS_FIELD_Src0RegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0RegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0RegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0RegNum(" #ins ", " #value ")"), \
    _GED_SetSrc0RegNum(ins, value))

/*!
 * Get the value of the Src0AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0AddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0AddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0AddrSubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0AddrSubRegNum(" #ins ", " #result ")"), \
    _GED_GetSrc0AddrSubRegNum(ins, result))

/*!
 * Set the value of the Src0AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src0AddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0AddrSubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0AddrSubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0AddrSubRegNum(" #ins ", " #value ")"), \
    _GED_SetSrc0AddrSubRegNum(ins, value))

/*!
 * Get the value of the Src0SrcMod field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetSrcModString. See @ref GED_INS_FIELD_Src0SrcMod for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0SrcMod's enumeration if the field is valid, GED_SRC_MOD_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV _GED_GetSrc0SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0SrcMod(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0SrcMod(" #ins ", " #result ")"), \
    _GED_GetSrc0SrcMod(ins, result))

/*!
 * Set the value of the Src0SrcMod field in the given instruction. See @ref GED_INS_FIELD_Src0SrcMod for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0SrcMod(ged_ins_t* ins, const GED_SRC_MOD value);
#define GED_SetSrc0SrcMod(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0SrcMod(" #ins ", " #value ")"), \
    _GED_SetSrc0SrcMod(ins, value))

/*!
 * Get the value of the Src0AddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_Src0AddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0AddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV _GED_GetSrc0AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0AddrMode(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0AddrMode(" #ins ", " #result ")"), \
    _GED_GetSrc0AddrMode(ins, result))

/*!
 * Set the value of the Src0AddrMode field in the given instruction. See @ref GED_INS_FIELD_Src0AddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);
#define GED_SetSrc0AddrMode(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0AddrMode(" #ins ", " #value ")"), \
    _GED_SetSrc0AddrMode(ins, value))

/*!
 * Get the value of the Src0HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src0HorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0HorzStride(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0HorzStride(" #ins ", " #result ")"), \
    _GED_GetSrc0HorzStride(ins, result))

/*!
 * Set the value of the Src0HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src0HorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0HorzStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0HorzStride(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0HorzStride(" #ins ", " #value ")"), \
    _GED_SetSrc0HorzStride(ins, value))

/*!
 * Get the value of the Src0Width field in the given instruction. See @ref GED_INS_FIELD_Src0Width for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0Width(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0Width(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0Width(" #ins ", " #result ")"), \
    _GED_GetSrc0Width(ins, result))

/*!
 * Set the value of the Src0Width field in the given instruction. See @ref GED_INS_FIELD_Src0Width for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0Width(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0Width(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0Width(" #ins ", " #value ")"), \
    _GED_SetSrc0Width(ins, value))

/*!
 * Get the value of the Src0VertStride field in the given instruction. See @ref GED_INS_FIELD_Src0VertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0VertStride(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0VertStride(" #ins ", " #result ")"), \
    _GED_GetSrc0VertStride(ins, result))

/*!
 * Set the value of the Src0VertStride field in the given instruction. See @ref GED_INS_FIELD_Src0VertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0VertStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0VertStride(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0VertStride(" #ins ", " #value ")"), \
    _GED_SetSrc0VertStride(ins, value))

/*!
 * Get the value of the FlagSubRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetFlagSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetFlagSubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetFlagSubRegNum(" #ins ", " #result ")"), \
    _GED_GetFlagSubRegNum(ins, result))

/*!
 * Set the value of the FlagSubRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetFlagSubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetFlagSubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetFlagSubRegNum(" #ins ", " #value ")"), \
    _GED_SetFlagSubRegNum(ins, value))

/*!
 * Get the value of the FlagRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetFlagRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetFlagRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetFlagRegNum(" #ins ", " #result ")"), \
    _GED_GetFlagRegNum(ins, result))

/*!
 * Set the value of the FlagRegNum field in the given instruction. See @ref GED_INS_FIELD_FlagRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetFlagRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetFlagRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetFlagRegNum(" #ins ", " #value ")"), \
    _GED_SetFlagRegNum(ins, value))

/*!
 * Get the value of the Src1ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src1ChanSel for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1ChanSel(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1ChanSel(" #ins ", " #result ")"), \
    _GED_GetSrc1ChanSel(ins, result))

/*!
 * Set the value of the Src1ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src1ChanSel for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1ChanSel(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1ChanSel(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1ChanSel(" #ins ", " #value ")"), \
    _GED_SetSrc1ChanSel(ins, value))

/*!
 * Get the value of the Src1SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1SubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1SubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1SubRegNum(" #ins ", " #result ")"), \
    _GED_GetSrc1SubRegNum(ins, result))

/*!
 * Set the value of the Src1SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1SubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1SubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1SubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1SubRegNum(" #ins ", " #value ")"), \
    _GED_SetSrc1SubRegNum(ins, value))

/*!
 * Get the value of the Src1AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src1AddrImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV _GED_GetSrc1AddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1AddrImm(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1AddrImm(" #ins ", " #result ")"), \
    _GED_GetSrc1AddrImm(ins, result))

/*!
 * Set the value of the Src1AddrImm field in the given instruction. See @ref GED_INS_FIELD_Src1AddrImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1AddrImm(ged_ins_t* ins, const int32_t value);
#define GED_SetSrc1AddrImm(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1AddrImm(" #ins ", " #value ")"), \
    _GED_SetSrc1AddrImm(ins, value))

/*!
 * Get the value of the Src1RegNum field in the given instruction. See @ref GED_INS_FIELD_Src1RegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1RegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1RegNum(" #ins ", " #result ")"), \
    _GED_GetSrc1RegNum(ins, result))

/*!
 * Set the value of the Src1RegNum field in the given instruction. See @ref GED_INS_FIELD_Src1RegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1RegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1RegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1RegNum(" #ins ", " #value ")"), \
    _GED_SetSrc1RegNum(ins, value))

/*!
 * Get the value of the Src1AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1AddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1AddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1AddrSubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1AddrSubRegNum(" #ins ", " #result ")"), \
    _GED_GetSrc1AddrSubRegNum(ins, result))

/*!
 * Set the value of the Src1AddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src1AddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1AddrSubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1AddrSubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1AddrSubRegNum(" #ins ", " #value ")"), \
    _GED_SetSrc1AddrSubRegNum(ins, value))

/*!
 * Get the value of the Src1SrcMod field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetSrcModString. See @ref GED_INS_FIELD_Src1SrcMod for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1SrcMod's enumeration if the field is valid, GED_SRC_MOD_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV _GED_GetSrc1SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1SrcMod(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1SrcMod(" #ins ", " #result ")"), \
    _GED_GetSrc1SrcMod(ins, result))

/*!
 * Set the value of the Src1SrcMod field in the given instruction. See @ref GED_INS_FIELD_Src1SrcMod for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1SrcMod(ged_ins_t* ins, const GED_SRC_MOD value);
#define GED_SetSrc1SrcMod(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1SrcMod(" #ins ", " #value ")"), \
    _GED_SetSrc1SrcMod(ins, value))

/*!
 * Get the value of the Src1AddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_Src1AddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1AddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV _GED_GetSrc1AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1AddrMode(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1AddrMode(" #ins ", " #result ")"), \
    _GED_GetSrc1AddrMode(ins, result))

/*!
 * Set the value of the Src1AddrMode field in the given instruction. See @ref GED_INS_FIELD_Src1AddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);
#define GED_SetSrc1AddrMode(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1AddrMode(" #ins ", " #value ")"), \
    _GED_SetSrc1AddrMode(ins, value))

/*!
 * Get the value of the Src1HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src1HorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1HorzStride(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1HorzStride(" #ins ", " #result ")"), \
    _GED_GetSrc1HorzStride(ins, result))

/*!
 * Set the value of the Src1HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src1HorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1HorzStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1HorzStride(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1HorzStride(" #ins ", " #value ")"), \
    _GED_SetSrc1HorzStride(ins, value))

/*!
 * Get the value of the Src1Width field in the given instruction. See @ref GED_INS_FIELD_Src1Width for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1Width(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1Width(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1Width(" #ins ", " #result ")"), \
    _GED_GetSrc1Width(ins, result))

/*!
 * Set the value of the Src1Width field in the given instruction. See @ref GED_INS_FIELD_Src1Width for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1Width(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1Width(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1Width(" #ins ", " #value ")"), \
    _GED_SetSrc1Width(ins, value))

/*!
 * Get the value of the Src1VertStride field in the given instruction. See @ref GED_INS_FIELD_Src1VertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1VertStride(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1VertStride(" #ins ", " #result ")"), \
    _GED_GetSrc1VertStride(ins, result))

/*!
 * Set the value of the Src1VertStride field in the given instruction. See @ref GED_INS_FIELD_Src1VertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1VertStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1VertStride(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1VertStride(" #ins ", " #value ")"), \
    _GED_SetSrc1VertStride(ins, value))

/*!
 * Get the value of the Imm field in the given instruction. See @ref GED_INS_FIELD_Imm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint64_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint64_t GED_CALLCONV _GED_GetImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetImm(ins, result) ( \
    GED_TraceAPI("GED_GetImm(" #ins ", " #result ")"), \
    _GED_GetImm(ins, result))

/*!
 * Set the value of the Imm field in the given instruction. See @ref GED_INS_FIELD_Imm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetImm(ged_ins_t* ins, const uint64_t value);
#define GED_SetImm(ins, value) ( \
    GED_TraceAPI("GED_SetImm(" #ins ", " #value ")"), \
    _GED_SetImm(ins, value))

/*!
 * Get the value of the Src2SrcMod field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetSrcModString. See @ref GED_INS_FIELD_Src2SrcMod for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2SrcMod's enumeration if the field is valid, GED_SRC_MOD_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV _GED_GetSrc2SrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2SrcMod(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2SrcMod(" #ins ", " #result ")"), \
    _GED_GetSrc2SrcMod(ins, result))

/*!
 * Set the value of the Src2SrcMod field in the given instruction. See @ref GED_INS_FIELD_Src2SrcMod for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2SrcMod(ged_ins_t* ins, const GED_SRC_MOD value);
#define GED_SetSrc2SrcMod(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2SrcMod(" #ins ", " #value ")"), \
    _GED_SetSrc2SrcMod(ins, value))

/*!
 * Get the value of the SrcDataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_SrcDataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      SrcDataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV _GED_GetSrcDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrcDataType(ins, result) ( \
    GED_TraceAPI("GED_GetSrcDataType(" #ins ", " #result ")"), \
    _GED_GetSrcDataType(ins, result))

/*!
 * Set the value of the SrcDataType field in the given instruction. See @ref GED_INS_FIELD_SrcDataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrcDataType(ged_ins_t* ins, const GED_DATA_TYPE value);
#define GED_SetSrcDataType(ins, value) ( \
    GED_TraceAPI("GED_SetSrcDataType(" #ins ", " #value ")"), \
    _GED_SetSrcDataType(ins, value))

/*!
 * Get the value of the Src0RepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRepCtrlString. See @ref GED_INS_FIELD_Src0RepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0RepCtrl's enumeration if the field is valid, GED_REP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV _GED_GetSrc0RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0RepCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0RepCtrl(" #ins ", " #result ")"), \
    _GED_GetSrc0RepCtrl(ins, result))

/*!
 * Set the value of the Src0RepCtrl field in the given instruction. See @ref GED_INS_FIELD_Src0RepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value);
#define GED_SetSrc0RepCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0RepCtrl(" #ins ", " #value ")"), \
    _GED_SetSrc0RepCtrl(ins, value))

/*!
 * Get the value of the Src1RepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRepCtrlString. See @ref GED_INS_FIELD_Src1RepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1RepCtrl's enumeration if the field is valid, GED_REP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV _GED_GetSrc1RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1RepCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1RepCtrl(" #ins ", " #result ")"), \
    _GED_GetSrc1RepCtrl(ins, result))

/*!
 * Set the value of the Src1RepCtrl field in the given instruction. See @ref GED_INS_FIELD_Src1RepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value);
#define GED_SetSrc1RepCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1RepCtrl(" #ins ", " #value ")"), \
    _GED_SetSrc1RepCtrl(ins, value))

/*!
 * Get the value of the Src2RepCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRepCtrlString. See @ref GED_INS_FIELD_Src2RepCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2RepCtrl's enumeration if the field is valid, GED_REP_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV _GED_GetSrc2RepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2RepCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2RepCtrl(" #ins ", " #result ")"), \
    _GED_GetSrc2RepCtrl(ins, result))

/*!
 * Set the value of the Src2RepCtrl field in the given instruction. See @ref GED_INS_FIELD_Src2RepCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2RepCtrl(ged_ins_t* ins, const GED_REP_CTRL value);
#define GED_SetSrc2RepCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2RepCtrl(" #ins ", " #value ")"), \
    _GED_SetSrc2RepCtrl(ins, value))

/*!
 * Get the value of the Src2ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src2ChanSel for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc2ChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2ChanSel(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2ChanSel(" #ins ", " #result ")"), \
    _GED_GetSrc2ChanSel(ins, result))

/*!
 * Set the value of the Src2ChanSel field in the given instruction. See @ref GED_INS_FIELD_Src2ChanSel for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2ChanSel(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc2ChanSel(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2ChanSel(" #ins ", " #value ")"), \
    _GED_SetSrc2ChanSel(ins, value))

/*!
 * Get the value of the Src2SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src2SubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc2SubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2SubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2SubRegNum(" #ins ", " #result ")"), \
    _GED_GetSrc2SubRegNum(ins, result))

/*!
 * Set the value of the Src2SubRegNum field in the given instruction. See @ref GED_INS_FIELD_Src2SubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2SubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc2SubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2SubRegNum(" #ins ", " #value ")"), \
    _GED_SetSrc2SubRegNum(ins, value))

/*!
 * Get the value of the Src2RegNum field in the given instruction. See @ref GED_INS_FIELD_Src2RegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc2RegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2RegNum(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2RegNum(" #ins ", " #result ")"), \
    _GED_GetSrc2RegNum(ins, result))

/*!
 * Set the value of the Src2RegNum field in the given instruction. See @ref GED_INS_FIELD_Src2RegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2RegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc2RegNum(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2RegNum(" #ins ", " #value ")"), \
    _GED_SetSrc2RegNum(ins, value))

/*!
 * Get the value of the Src2RegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_Src2RegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2RegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV _GED_GetSrc2RegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2RegFile(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2RegFile(" #ins ", " #result ")"), \
    _GED_GetSrc2RegFile(ins, result))

/*!
 * Set the value of the Src2RegFile field in the given instruction. See @ref GED_INS_FIELD_Src2RegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2RegFile(ged_ins_t* ins, const GED_REG_FILE value);
#define GED_SetSrc2RegFile(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2RegFile(" #ins ", " #value ")"), \
    _GED_SetSrc2RegFile(ins, value))

/*!
 * Get the value of the Src2AddrMode field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetAddrModeString. See @ref GED_INS_FIELD_Src2AddrMode for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2AddrMode's enumeration if the field is valid, GED_ADDR_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV _GED_GetSrc2AddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2AddrMode(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2AddrMode(" #ins ", " #result ")"), \
    _GED_GetSrc2AddrMode(ins, result))

/*!
 * Set the value of the Src2AddrMode field in the given instruction. See @ref GED_INS_FIELD_Src2AddrMode for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2AddrMode(ged_ins_t* ins, const GED_ADDR_MODE value);
#define GED_SetSrc2AddrMode(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2AddrMode(" #ins ", " #value ")"), \
    _GED_SetSrc2AddrMode(ins, value))

/*!
 * Get the value of the Src2VertStride field in the given instruction. See @ref GED_INS_FIELD_Src2VertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc2VertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2VertStride(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2VertStride(" #ins ", " #result ")"), \
    _GED_GetSrc2VertStride(ins, result))

/*!
 * Set the value of the Src2VertStride field in the given instruction. See @ref GED_INS_FIELD_Src2VertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2VertStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc2VertStride(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2VertStride(" #ins ", " #value ")"), \
    _GED_SetSrc2VertStride(ins, value))

/*!
 * Get the value of the SFID field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetSFIDString. See @ref GED_INS_FIELD_SFID for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      SFID's enumeration if the field is valid, GED_SFID_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SFID GED_CALLCONV _GED_GetSFID(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSFID(ins, result) ( \
    GED_TraceAPI("GED_GetSFID(" #ins ", " #result ")"), \
    _GED_GetSFID(ins, result))

/*!
 * Set the value of the SFID field in the given instruction. See @ref GED_INS_FIELD_SFID for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSFID(ged_ins_t* ins, const GED_SFID value);
#define GED_SetSFID(ins, value) ( \
    GED_TraceAPI("GED_SetSFID(" #ins ", " #value ")"), \
    _GED_SetSFID(ins, value))

/*!
 * Get the value of the DescRegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_DescRegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DescRegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV _GED_GetDescRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescRegFile(ins, result) ( \
    GED_TraceAPI("GED_GetDescRegFile(" #ins ", " #result ")"), \
    _GED_GetDescRegFile(ins, result))

/*!
 * Set the value of the DescRegFile field in the given instruction. See @ref GED_INS_FIELD_DescRegFile for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescRegFile(ged_ins_t* ins, const GED_REG_FILE value);
#define GED_SetDescRegFile(ins, value) ( \
    GED_TraceAPI("GED_SetDescRegFile(" #ins ", " #value ")"), \
    _GED_SetDescRegFile(ins, value))

/*!
 * Get the value of the DescDataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_DescDataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DescDataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV _GED_GetDescDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescDataType(ins, result) ( \
    GED_TraceAPI("GED_GetDescDataType(" #ins ", " #result ")"), \
    _GED_GetDescDataType(ins, result))

/*!
 * Set the value of the DescDataType field in the given instruction. See @ref GED_INS_FIELD_DescDataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescDataType(ged_ins_t* ins, const GED_DATA_TYPE value);
#define GED_SetDescDataType(ins, value) ( \
    GED_TraceAPI("GED_SetDescDataType(" #ins ", " #value ")"), \
    _GED_SetDescDataType(ins, value))

/*!
 * Get the value of the DescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DescAddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDescAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescAddrSubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetDescAddrSubRegNum(" #ins ", " #result ")"), \
    _GED_GetDescAddrSubRegNum(ins, result))

/*!
 * Set the value of the DescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_DescAddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescAddrSubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetDescAddrSubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetDescAddrSubRegNum(" #ins ", " #value ")"), \
    _GED_SetDescAddrSubRegNum(ins, value))

/*!
 * Get the value of the DescRegNum field in the given instruction. See @ref GED_INS_FIELD_DescRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDescRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetDescRegNum(" #ins ", " #result ")"), \
    _GED_GetDescRegNum(ins, result))

/*!
 * Set the value of the DescRegNum field in the given instruction. See @ref GED_INS_FIELD_DescRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetDescRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetDescRegNum(" #ins ", " #value ")"), \
    _GED_SetDescRegNum(ins, value))

/*!
 * Get the value of the DescHorzStride field in the given instruction. See @ref GED_INS_FIELD_DescHorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDescHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescHorzStride(ins, result) ( \
    GED_TraceAPI("GED_GetDescHorzStride(" #ins ", " #result ")"), \
    _GED_GetDescHorzStride(ins, result))

/*!
 * Set the value of the DescHorzStride field in the given instruction. See @ref GED_INS_FIELD_DescHorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescHorzStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetDescHorzStride(ins, value) ( \
    GED_TraceAPI("GED_SetDescHorzStride(" #ins ", " #value ")"), \
    _GED_SetDescHorzStride(ins, value))

/*!
 * Get the value of the DescWidth field in the given instruction. See @ref GED_INS_FIELD_DescWidth for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDescWidth(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescWidth(ins, result) ( \
    GED_TraceAPI("GED_GetDescWidth(" #ins ", " #result ")"), \
    _GED_GetDescWidth(ins, result))

/*!
 * Set the value of the DescWidth field in the given instruction. See @ref GED_INS_FIELD_DescWidth for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescWidth(ged_ins_t* ins, const uint32_t value);
#define GED_SetDescWidth(ins, value) ( \
    GED_TraceAPI("GED_SetDescWidth(" #ins ", " #value ")"), \
    _GED_SetDescWidth(ins, value))

/*!
 * Get the value of the DescVertStride field in the given instruction. See @ref GED_INS_FIELD_DescVertStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDescVertStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescVertStride(ins, result) ( \
    GED_TraceAPI("GED_GetDescVertStride(" #ins ", " #result ")"), \
    _GED_GetDescVertStride(ins, result))

/*!
 * Set the value of the DescVertStride field in the given instruction. See @ref GED_INS_FIELD_DescVertStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescVertStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetDescVertStride(ins, value) ( \
    GED_TraceAPI("GED_SetDescVertStride(" #ins ", " #value ")"), \
    _GED_SetDescVertStride(ins, value))

/*!
 * Get the value of the MsgDesc field in the given instruction. See @ref GED_INS_FIELD_MsgDesc for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetMsgDesc(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMsgDesc(ins, result) ( \
    GED_TraceAPI("GED_GetMsgDesc(" #ins ", " #result ")"), \
    _GED_GetMsgDesc(ins, result))

/*!
 * Set the value of the MsgDesc field in the given instruction. See @ref GED_INS_FIELD_MsgDesc for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMsgDesc(ged_ins_t* ins, const uint32_t value);
#define GED_SetMsgDesc(ins, value) ( \
    GED_TraceAPI("GED_SetMsgDesc(" #ins ", " #value ")"), \
    _GED_SetMsgDesc(ins, value))

/*!
 * Get the value of the ExMsgDescImm field in the given instruction. See @ref GED_INS_FIELD_ExMsgDescImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetExMsgDescImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExMsgDescImm(ins, result) ( \
    GED_TraceAPI("GED_GetExMsgDescImm(" #ins ", " #result ")"), \
    _GED_GetExMsgDescImm(ins, result))

/*!
 * Set the value of the ExMsgDescImm field in the given instruction. See @ref GED_INS_FIELD_ExMsgDescImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExMsgDescImm(ged_ins_t* ins, const uint32_t value);
#define GED_SetExMsgDescImm(ins, value) ( \
    GED_TraceAPI("GED_SetExMsgDescImm(" #ins ", " #value ")"), \
    _GED_SetExMsgDescImm(ins, value))

/*!
 * Get the value of the EOT field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetEOTString. See @ref GED_INS_FIELD_EOT for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      EOT's enumeration if the field is valid, GED_EOT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_EOT GED_CALLCONV _GED_GetEOT(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetEOT(ins, result) ( \
    GED_TraceAPI("GED_GetEOT(" #ins ", " #result ")"), \
    _GED_GetEOT(ins, result))

/*!
 * Set the value of the EOT field in the given instruction. See @ref GED_INS_FIELD_EOT for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetEOT(ged_ins_t* ins, const GED_EOT value);
#define GED_SetEOT(ins, value) ( \
    GED_TraceAPI("GED_SetEOT(" #ins ", " #value ")"), \
    _GED_SetEOT(ins, value))

/*!
 * Get the value of the MathFC field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetMathFCString. See @ref GED_INS_FIELD_MathFC for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MathFC's enumeration if the field is valid, GED_MATH_FC_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_FC GED_CALLCONV _GED_GetMathFC(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMathFC(ins, result) ( \
    GED_TraceAPI("GED_GetMathFC(" #ins ", " #result ")"), \
    _GED_GetMathFC(ins, result))

/*!
 * Set the value of the MathFC field in the given instruction. See @ref GED_INS_FIELD_MathFC for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMathFC(ged_ins_t* ins, const GED_MATH_FC value);
#define GED_SetMathFC(ins, value) ( \
    GED_TraceAPI("GED_SetMathFC(" #ins ", " #value ")"), \
    _GED_SetMathFC(ins, value))

/*!
 * Get the value of the JIP field in the given instruction. See @ref GED_INS_FIELD_JIP for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV _GED_GetJIP(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetJIP(ins, result) ( \
    GED_TraceAPI("GED_GetJIP(" #ins ", " #result ")"), \
    _GED_GetJIP(ins, result))

/*!
 * Set the value of the JIP field in the given instruction. See @ref GED_INS_FIELD_JIP for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetJIP(ged_ins_t* ins, const int32_t value);
#define GED_SetJIP(ins, value) ( \
    GED_TraceAPI("GED_SetJIP(" #ins ", " #value ")"), \
    _GED_SetJIP(ins, value))

/*!
 * Get the value of the UIP field in the given instruction. See @ref GED_INS_FIELD_UIP for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV _GED_GetUIP(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetUIP(ins, result) ( \
    GED_TraceAPI("GED_GetUIP(" #ins ", " #result ")"), \
    _GED_GetUIP(ins, result))

/*!
 * Set the value of the UIP field in the given instruction. See @ref GED_INS_FIELD_UIP for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetUIP(ged_ins_t* ins, const int32_t value);
#define GED_SetUIP(ins, value) ( \
    GED_TraceAPI("GED_SetUIP(" #ins ", " #value ")"), \
    _GED_SetUIP(ins, value))

/*!
 * Get the value of the ControlIndex field in the given instruction. See @ref GED_INS_FIELD_ControlIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetControlIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetControlIndex(ins, result) ( \
    GED_TraceAPI("GED_GetControlIndex(" #ins ", " #result ")"), \
    _GED_GetControlIndex(ins, result))

/*!
 * Set the value of the ControlIndex field in the given instruction. See @ref GED_INS_FIELD_ControlIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetControlIndex(ged_ins_t* ins, const uint32_t value);
#define GED_SetControlIndex(ins, value) ( \
    GED_TraceAPI("GED_SetControlIndex(" #ins ", " #value ")"), \
    _GED_SetControlIndex(ins, value))

/*!
 * Get the value of the DataTypeIndex field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndex for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDataTypeIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDataTypeIndex(ins, result) ( \
    GED_TraceAPI("GED_GetDataTypeIndex(" #ins ", " #result ")"), \
    _GED_GetDataTypeIndex(ins, result))

/*!
 * Set the value of the DataTypeIndex field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndex for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDataTypeIndex(ged_ins_t* ins, const uint32_t value);
#define GED_SetDataTypeIndex(ins, value) ( \
    GED_TraceAPI("GED_SetDataTypeIndex(" #ins ", " #value ")"), \
    _GED_SetDataTypeIndex(ins, value))

/*!
 * Get the value of the SubRegIndex field in the given instruction. See @ref GED_INS_FIELD_SubRegIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSubRegIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSubRegIndex(ins, result) ( \
    GED_TraceAPI("GED_GetSubRegIndex(" #ins ", " #result ")"), \
    _GED_GetSubRegIndex(ins, result))

/*!
 * Set the value of the SubRegIndex field in the given instruction. See @ref GED_INS_FIELD_SubRegIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSubRegIndex(ged_ins_t* ins, const uint32_t value);
#define GED_SetSubRegIndex(ins, value) ( \
    GED_TraceAPI("GED_SetSubRegIndex(" #ins ", " #value ")"), \
    _GED_SetSubRegIndex(ins, value))

/*!
 * Get the value of the Src0Index field in the given instruction. See @ref GED_INS_FIELD_Src0Index for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0Index(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0Index(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0Index(" #ins ", " #result ")"), \
    _GED_GetSrc0Index(ins, result))

/*!
 * Set the value of the Src0Index field in the given instruction. See @ref GED_INS_FIELD_Src0Index for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0Index(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0Index(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0Index(" #ins ", " #value ")"), \
    _GED_SetSrc0Index(ins, value))

/*!
 * Get the value of the Src1Index field in the given instruction. See @ref GED_INS_FIELD_Src1Index for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1Index(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1Index(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1Index(" #ins ", " #result ")"), \
    _GED_GetSrc1Index(ins, result))

/*!
 * Set the value of the Src1Index field in the given instruction. See @ref GED_INS_FIELD_Src1Index for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1Index(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1Index(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1Index(" #ins ", " #value ")"), \
    _GED_SetSrc1Index(ins, value))

/*!
 * Get the value of the DescIndex field in the given instruction. See @ref GED_INS_FIELD_DescIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDescIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDescIndex(ins, result) ( \
    GED_TraceAPI("GED_GetDescIndex(" #ins ", " #result ")"), \
    _GED_GetDescIndex(ins, result))

/*!
 * Set the value of the DescIndex field in the given instruction. See @ref GED_INS_FIELD_DescIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDescIndex(ged_ins_t* ins, const uint32_t value);
#define GED_SetDescIndex(ins, value) ( \
    GED_TraceAPI("GED_SetDescIndex(" #ins ", " #value ")"), \
    _GED_SetDescIndex(ins, value))

/*!
 * Get the value of the ExDescRegFile field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetRegFileString. See @ref GED_INS_FIELD_ExDescRegFile for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ExDescRegFile's enumeration if the field is valid, GED_REG_FILE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV _GED_GetExDescRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExDescRegFile(ins, result) ( \
    GED_TraceAPI("GED_GetExDescRegFile(" #ins ", " #result ")"), \
    _GED_GetExDescRegFile(ins, result))

/*!
 * Set the value of the ExDescRegFile field in the given instruction. See @ref GED_INS_FIELD_ExDescRegFile for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExDescRegFile(ged_ins_t* ins, const GED_REG_FILE value);
#define GED_SetExDescRegFile(ins, value) ( \
    GED_TraceAPI("GED_SetExDescRegFile(" #ins ", " #value ")"), \
    _GED_SetExDescRegFile(ins, value))

/*!
 * Get the value of the DstMathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_DstMathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      DstMathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV _GED_GetDstMathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDstMathMacroExt(ins, result) ( \
    GED_TraceAPI("GED_GetDstMathMacroExt(" #ins ", " #result ")"), \
    _GED_GetDstMathMacroExt(ins, result))

/*!
 * Set the value of the DstMathMacroExt field in the given instruction. See @ref GED_INS_FIELD_DstMathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDstMathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);
#define GED_SetDstMathMacroExt(ins, value) ( \
    GED_TraceAPI("GED_SetDstMathMacroExt(" #ins ", " #value ")"), \
    _GED_SetDstMathMacroExt(ins, value))

/*!
 * Get the value of the Src0MathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_Src0MathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src0MathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV _GED_GetSrc0MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0MathMacroExt(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0MathMacroExt(" #ins ", " #result ")"), \
    _GED_GetSrc0MathMacroExt(ins, result))

/*!
 * Set the value of the Src0MathMacroExt field in the given instruction. See @ref GED_INS_FIELD_Src0MathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);
#define GED_SetSrc0MathMacroExt(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0MathMacroExt(" #ins ", " #value ")"), \
    _GED_SetSrc0MathMacroExt(ins, value))

/*!
 * Get the value of the Src1MathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_Src1MathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1MathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV _GED_GetSrc1MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1MathMacroExt(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1MathMacroExt(" #ins ", " #result ")"), \
    _GED_GetSrc1MathMacroExt(ins, result))

/*!
 * Set the value of the Src1MathMacroExt field in the given instruction. See @ref GED_INS_FIELD_Src1MathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);
#define GED_SetSrc1MathMacroExt(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1MathMacroExt(" #ins ", " #value ")"), \
    _GED_SetSrc1MathMacroExt(ins, value))

/*!
 * Get the value of the Src2MathMacroExt field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetMathMacroExtString. See @ref GED_INS_FIELD_Src2MathMacroExt for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2MathMacroExt's enumeration if the field is valid, GED_MATH_MACRO_EXT_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV _GED_GetSrc2MathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2MathMacroExt(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2MathMacroExt(" #ins ", " #result ")"), \
    _GED_GetSrc2MathMacroExt(ins, result))

/*!
 * Set the value of the Src2MathMacroExt field in the given instruction. See @ref GED_INS_FIELD_Src2MathMacroExt for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2MathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value);
#define GED_SetSrc2MathMacroExt(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2MathMacroExt(" #ins ", " #value ")"), \
    _GED_SetSrc2MathMacroExt(ins, value))

/*!
 * Get the value of the BranchCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetBranchCtrlString. See @ref GED_INS_FIELD_BranchCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      BranchCtrl's enumeration if the field is valid, GED_BRANCH_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_BRANCH_CTRL GED_CALLCONV _GED_GetBranchCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetBranchCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetBranchCtrl(" #ins ", " #result ")"), \
    _GED_GetBranchCtrl(ins, result))

/*!
 * Set the value of the BranchCtrl field in the given instruction. See @ref GED_INS_FIELD_BranchCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetBranchCtrl(ged_ins_t* ins, const GED_BRANCH_CTRL value);
#define GED_SetBranchCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetBranchCtrl(" #ins ", " #value ")"), \
    _GED_SetBranchCtrl(ins, value))

/*!
 * Get the value of the SourceIndex field in the given instruction. See @ref GED_INS_FIELD_SourceIndex for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSourceIndex(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSourceIndex(ins, result) ( \
    GED_TraceAPI("GED_GetSourceIndex(" #ins ", " #result ")"), \
    _GED_GetSourceIndex(ins, result))

/*!
 * Set the value of the SourceIndex field in the given instruction. See @ref GED_INS_FIELD_SourceIndex for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSourceIndex(ged_ins_t* ins, const uint32_t value);
#define GED_SetSourceIndex(ins, value) ( \
    GED_TraceAPI("GED_SetSourceIndex(" #ins ", " #value ")"), \
    _GED_SetSourceIndex(ins, value))

/*!
 * Get the value of the Src2DataType field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetDataTypeString. See @ref GED_INS_FIELD_Src2DataType for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2DataType's enumeration if the field is valid, GED_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV _GED_GetSrc2DataType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2DataType(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2DataType(" #ins ", " #result ")"), \
    _GED_GetSrc2DataType(ins, result))

/*!
 * Set the value of the Src2DataType field in the given instruction. See @ref GED_INS_FIELD_Src2DataType for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2DataType(ged_ins_t* ins, const GED_DATA_TYPE value);
#define GED_SetSrc2DataType(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2DataType(" #ins ", " #value ")"), \
    _GED_SetSrc2DataType(ins, value))

/*!
 * Get the value of the NoSrcDepSet field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetNoSrcDepSetString. See @ref GED_INS_FIELD_NoSrcDepSet for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      NoSrcDepSet's enumeration if the field is valid, GED_NO_SRC_DEP_SET_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_NO_SRC_DEP_SET GED_CALLCONV _GED_GetNoSrcDepSet(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetNoSrcDepSet(ins, result) ( \
    GED_TraceAPI("GED_GetNoSrcDepSet(" #ins ", " #result ")"), \
    _GED_GetNoSrcDepSet(ins, result))

/*!
 * Set the value of the NoSrcDepSet field in the given instruction. See @ref GED_INS_FIELD_NoSrcDepSet for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetNoSrcDepSet(ged_ins_t* ins, const GED_NO_SRC_DEP_SET value);
#define GED_SetNoSrcDepSet(ins, value) ( \
    GED_TraceAPI("GED_SetNoSrcDepSet(" #ins ", " #value ")"), \
    _GED_SetNoSrcDepSet(ins, value))

/*!
 * Get the value of the ExFuncCtrl field in the given instruction. See @ref GED_INS_FIELD_ExFuncCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetExFuncCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExFuncCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetExFuncCtrl(" #ins ", " #result ")"), \
    _GED_GetExFuncCtrl(ins, result))

/*!
 * Set the value of the ExFuncCtrl field in the given instruction. See @ref GED_INS_FIELD_ExFuncCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExFuncCtrl(ged_ins_t* ins, const uint32_t value);
#define GED_SetExFuncCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetExFuncCtrl(" #ins ", " #value ")"), \
    _GED_SetExFuncCtrl(ins, value))

/*!
 * Get the value of the ExMsgLength field in the given instruction. See @ref GED_INS_FIELD_ExMsgLength for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetExMsgLength(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExMsgLength(ins, result) ( \
    GED_TraceAPI("GED_GetExMsgLength(" #ins ", " #result ")"), \
    _GED_GetExMsgLength(ins, result))

/*!
 * Set the value of the ExMsgLength field in the given instruction. See @ref GED_INS_FIELD_ExMsgLength for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExMsgLength(ged_ins_t* ins, const uint32_t value);
#define GED_SetExMsgLength(ins, value) ( \
    GED_TraceAPI("GED_SetExMsgLength(" #ins ", " #value ")"), \
    _GED_SetExMsgLength(ins, value))

/*!
 * Get the value of the ExDescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescAddrSubRegNum for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetExDescAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExDescAddrSubRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetExDescAddrSubRegNum(" #ins ", " #result ")"), \
    _GED_GetExDescAddrSubRegNum(ins, result))

/*!
 * Set the value of the ExDescAddrSubRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescAddrSubRegNum for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExDescAddrSubRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetExDescAddrSubRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetExDescAddrSubRegNum(" #ins ", " #value ")"), \
    _GED_SetExDescAddrSubRegNum(ins, value))

/*!
 * Get the value of the ExDescRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescRegNum for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetExDescRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExDescRegNum(ins, result) ( \
    GED_TraceAPI("GED_GetExDescRegNum(" #ins ", " #result ")"), \
    _GED_GetExDescRegNum(ins, result))

/*!
 * Set the value of the ExDescRegNum field in the given instruction. See @ref GED_INS_FIELD_ExDescRegNum for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExDescRegNum(ged_ins_t* ins, const uint32_t value);
#define GED_SetExDescRegNum(ins, value) ( \
    GED_TraceAPI("GED_SetExDescRegNum(" #ins ", " #value ")"), \
    _GED_SetExDescRegNum(ins, value))

/*!
 * Get the value of the MsgDescCategory field in the given instruction. See @ref GED_INS_FIELD_MsgDescCategory for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetMsgDescCategory(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMsgDescCategory(ins, result) ( \
    GED_TraceAPI("GED_GetMsgDescCategory(" #ins ", " #result ")"), \
    _GED_GetMsgDescCategory(ins, result))

/*!
 * Set the value of the MsgDescCategory field in the given instruction. See @ref GED_INS_FIELD_MsgDescCategory for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMsgDescCategory(ged_ins_t* ins, const uint32_t value);
#define GED_SetMsgDescCategory(ins, value) ( \
    GED_TraceAPI("GED_SetMsgDescCategory(" #ins ", " #value ")"), \
    _GED_SetMsgDescCategory(ins, value))

/*!
 * Get the value of the MsgDescScratchAddrOffset field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchAddrOffset for
 * the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetMsgDescScratchAddrOffset(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMsgDescScratchAddrOffset(ins, result) ( \
    GED_TraceAPI("GED_GetMsgDescScratchAddrOffset(" #ins ", " #result ")"), \
    _GED_GetMsgDescScratchAddrOffset(ins, result))

/*!
 * Set the value of the MsgDescScratchAddrOffset field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchAddrOffset for
 * the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMsgDescScratchAddrOffset(ged_ins_t* ins, const uint32_t value);
#define GED_SetMsgDescScratchAddrOffset(ins, value) ( \
    GED_TraceAPI("GED_SetMsgDescScratchAddrOffset(" #ins ", " #value ")"), \
    _GED_SetMsgDescScratchAddrOffset(ins, value))

/*!
 * Get the value of the MsgDescScratchBlockSize field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchBlockSize for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetMsgDescScratchBlockSize(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMsgDescScratchBlockSize(ins, result) ( \
    GED_TraceAPI("GED_GetMsgDescScratchBlockSize(" #ins ", " #result ")"), \
    _GED_GetMsgDescScratchBlockSize(ins, result))

/*!
 * Set the value of the MsgDescScratchBlockSize field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchBlockSize for the
 * field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMsgDescScratchBlockSize(ged_ins_t* ins, const uint32_t value);
#define GED_SetMsgDescScratchBlockSize(ins, value) ( \
    GED_TraceAPI("GED_SetMsgDescScratchBlockSize(" #ins ", " #value ")"), \
    _GED_SetMsgDescScratchBlockSize(ins, value))

/*!
 * Get the value of the MsgDescScratchInvalidateAfterRead field in the given instruction. See @ref
 * GED_INS_FIELD_MsgDescScratchInvalidateAfterRead for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetMsgDescScratchInvalidateAfterRead(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMsgDescScratchInvalidateAfterRead(ins, result) ( \
    GED_TraceAPI("GED_GetMsgDescScratchInvalidateAfterRead(" #ins ", " #result ")"), \
    _GED_GetMsgDescScratchInvalidateAfterRead(ins, result))

/*!
 * Set the value of the MsgDescScratchInvalidateAfterRead field in the given instruction. See @ref
 * GED_INS_FIELD_MsgDescScratchInvalidateAfterRead for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMsgDescScratchInvalidateAfterRead(ged_ins_t* ins, const uint32_t value);
#define GED_SetMsgDescScratchInvalidateAfterRead(ins, value) ( \
    GED_TraceAPI("GED_SetMsgDescScratchInvalidateAfterRead(" #ins ", " #value ")"), \
    _GED_SetMsgDescScratchInvalidateAfterRead(ins, value))

/*!
 * Get the value of the MsgDescScratchChannelMode field in the given instruction. The function returns an enumeration value. To obtain
 * the enum entry's string representation, use @ref GED_GetChannelModeString. See @ref GED_INS_FIELD_MsgDescScratchChannelMode for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MsgDescScratchChannelMode's enumeration if the field is valid, GED_CHANNEL_MODE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_CHANNEL_MODE GED_CALLCONV _GED_GetMsgDescScratchChannelMode(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMsgDescScratchChannelMode(ins, result) ( \
    GED_TraceAPI("GED_GetMsgDescScratchChannelMode(" #ins ", " #result ")"), \
    _GED_GetMsgDescScratchChannelMode(ins, result))

/*!
 * Set the value of the MsgDescScratchChannelMode field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchChannelMode for
 * the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMsgDescScratchChannelMode(ged_ins_t* ins, const GED_CHANNEL_MODE value);
#define GED_SetMsgDescScratchChannelMode(ins, value) ( \
    GED_TraceAPI("GED_SetMsgDescScratchChannelMode(" #ins ", " #value ")"), \
    _GED_SetMsgDescScratchChannelMode(ins, value))

/*!
 * Get the value of the MsgDescScratchMessageType field in the given instruction. The function returns an enumeration value. To obtain
 * the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref GED_INS_FIELD_MsgDescScratchMessageType for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      MsgDescScratchMessageType's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMsgDescScratchMessageType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetMsgDescScratchMessageType(ins, result) ( \
    GED_TraceAPI("GED_GetMsgDescScratchMessageType(" #ins ", " #result ")"), \
    _GED_GetMsgDescScratchMessageType(ins, result))

/*!
 * Set the value of the MsgDescScratchMessageType field in the given instruction. See @ref GED_INS_FIELD_MsgDescScratchMessageType for
 * the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMsgDescScratchMessageType(ged_ins_t* ins, const GED_MESSAGE_TYPE value);
#define GED_SetMsgDescScratchMessageType(ins, value) ( \
    GED_TraceAPI("GED_SetMsgDescScratchMessageType(" #ins ", " #value ")"), \
    _GED_SetMsgDescScratchMessageType(ins, value))

/*!
 * Get the value of the ExecutionDataType field in the given instruction. The function returns an enumeration value. To obtain the
 * enum entry's string representation, use @ref GED_GetExecutionDataTypeString. See @ref GED_INS_FIELD_ExecutionDataType for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      ExecutionDataType's enumeration if the field is valid, GED_EXECUTION_DATA_TYPE_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_EXECUTION_DATA_TYPE GED_CALLCONV _GED_GetExecutionDataType(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExecutionDataType(ins, result) ( \
    GED_TraceAPI("GED_GetExecutionDataType(" #ins ", " #result ")"), \
    _GED_GetExecutionDataType(ins, result))

/*!
 * Set the value of the ExecutionDataType field in the given instruction. See @ref GED_INS_FIELD_ExecutionDataType for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExecutionDataType(ged_ins_t* ins, const GED_EXECUTION_DATA_TYPE value);
#define GED_SetExecutionDataType(ins, value) ( \
    GED_TraceAPI("GED_SetExecutionDataType(" #ins ", " #value ")"), \
    _GED_SetExecutionDataType(ins, value))

/*!
 * Get the value of the Src0TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src0TernaryImm for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint64_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint64_t GED_CALLCONV _GED_GetSrc0TernaryImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0TernaryImm(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0TernaryImm(" #ins ", " #result ")"), \
    _GED_GetSrc0TernaryImm(ins, result))

/*!
 * Set the value of the Src0TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src0TernaryImm for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0TernaryImm(ged_ins_t* ins, const uint64_t value);
#define GED_SetSrc0TernaryImm(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0TernaryImm(" #ins ", " #value ")"), \
    _GED_SetSrc0TernaryImm(ins, value))

/*!
 * Get the value of the Src2TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src2TernaryImm for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint64_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint64_t GED_CALLCONV _GED_GetSrc2TernaryImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2TernaryImm(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2TernaryImm(" #ins ", " #result ")"), \
    _GED_GetSrc2TernaryImm(ins, result))

/*!
 * Set the value of the Src2TernaryImm field in the given instruction. See @ref GED_INS_FIELD_Src2TernaryImm for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2TernaryImm(ged_ins_t* ins, const uint64_t value);
#define GED_SetSrc2TernaryImm(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2TernaryImm(" #ins ", " #value ")"), \
    _GED_SetSrc2TernaryImm(ins, value))

/*!
 * Get the value of the Src2HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src2HorzStride for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc2HorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2HorzStride(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2HorzStride(" #ins ", " #result ")"), \
    _GED_GetSrc2HorzStride(ins, result))

/*!
 * Set the value of the Src2HorzStride field in the given instruction. See @ref GED_INS_FIELD_Src2HorzStride for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2HorzStride(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc2HorzStride(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2HorzStride(" #ins ", " #value ")"), \
    _GED_SetSrc2HorzStride(ins, value))

/*!
 * Get the value of the SWSB field in the given instruction. See @ref GED_INS_FIELD_SWSB for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSWSB(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSWSB(ins, result) ( \
    GED_TraceAPI("GED_GetSWSB(" #ins ", " #result ")"), \
    _GED_GetSWSB(ins, result))

/*!
 * Set the value of the SWSB field in the given instruction. See @ref GED_INS_FIELD_SWSB for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSWSB(ged_ins_t* ins, const uint32_t value);
#define GED_SetSWSB(ins, value) ( \
    GED_TraceAPI("GED_SetSWSB(" #ins ", " #value ")"), \
    _GED_SetSWSB(ins, value))

/*!
 * Get the value of the Src1IsImm field in the given instruction. See @ref GED_INS_FIELD_Src1IsImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1IsImm(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1IsImm(" #ins ", " #result ")"), \
    _GED_GetSrc1IsImm(ins, result))

/*!
 * Set the value of the Src1IsImm field in the given instruction. See @ref GED_INS_FIELD_Src1IsImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1IsImm(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1IsImm(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1IsImm(" #ins ", " #value ")"), \
    _GED_SetSrc1IsImm(ins, value))

/*!
 * Get the value of the Src0IsImm field in the given instruction. See @ref GED_INS_FIELD_Src0IsImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0IsImm(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0IsImm(" #ins ", " #result ")"), \
    _GED_GetSrc0IsImm(ins, result))

/*!
 * Set the value of the Src0IsImm field in the given instruction. See @ref GED_INS_FIELD_Src0IsImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0IsImm(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0IsImm(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0IsImm(" #ins ", " #value ")"), \
    _GED_SetSrc0IsImm(ins, value))

/*!
 * Get the value of the Src0SubRegNumByte field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNumByte for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc0SubRegNumByte(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc0SubRegNumByte(ins, result) ( \
    GED_TraceAPI("GED_GetSrc0SubRegNumByte(" #ins ", " #result ")"), \
    _GED_GetSrc0SubRegNumByte(ins, result))

/*!
 * Set the value of the Src0SubRegNumByte field in the given instruction. See @ref GED_INS_FIELD_Src0SubRegNumByte for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc0SubRegNumByte(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc0SubRegNumByte(ins, value) ( \
    GED_TraceAPI("GED_SetSrc0SubRegNumByte(" #ins ", " #value ")"), \
    _GED_SetSrc0SubRegNumByte(ins, value))

/*!
 * Get the value of the SyncFC field in the given instruction. The function returns an enumeration value. To obtain the enum entry's
 * string representation, use @ref GED_GetSyncFCString. See @ref GED_INS_FIELD_SyncFC for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      SyncFC's enumeration if the field is valid, GED_SYNC_FC_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SYNC_FC GED_CALLCONV _GED_GetSyncFC(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSyncFC(ins, result) ( \
    GED_TraceAPI("GED_GetSyncFC(" #ins ", " #result ")"), \
    _GED_GetSyncFC(ins, result))

/*!
 * Set the value of the SyncFC field in the given instruction. See @ref GED_INS_FIELD_SyncFC for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSyncFC(ged_ins_t* ins, const GED_SYNC_FC value);
#define GED_SetSyncFC(ins, value) ( \
    GED_TraceAPI("GED_SetSyncFC(" #ins ", " #value ")"), \
    _GED_SetSyncFC(ins, value))

/*!
 * Get the value of the FusionCtrl field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetFusionCtrlString. See @ref GED_INS_FIELD_FusionCtrl for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      FusionCtrl's enumeration if the field is valid, GED_FUSION_CTRL_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_FUSION_CTRL GED_CALLCONV _GED_GetFusionCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetFusionCtrl(ins, result) ( \
    GED_TraceAPI("GED_GetFusionCtrl(" #ins ", " #result ")"), \
    _GED_GetFusionCtrl(ins, result))

/*!
 * Set the value of the FusionCtrl field in the given instruction. See @ref GED_INS_FIELD_FusionCtrl for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetFusionCtrl(ged_ins_t* ins, const GED_FUSION_CTRL value);
#define GED_SetFusionCtrl(ins, value) ( \
    GED_TraceAPI("GED_SetFusionCtrl(" #ins ", " #value ")"), \
    _GED_SetFusionCtrl(ins, value))

/*!
 * Get the value of the DataTypeIndexNoDep field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndexNoDep for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetDataTypeIndexNoDep(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetDataTypeIndexNoDep(ins, result) ( \
    GED_TraceAPI("GED_GetDataTypeIndexNoDep(" #ins ", " #result ")"), \
    _GED_GetDataTypeIndexNoDep(ins, result))

/*!
 * Set the value of the DataTypeIndexNoDep field in the given instruction. See @ref GED_INS_FIELD_DataTypeIndexNoDep for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDataTypeIndexNoDep(ged_ins_t* ins, const uint32_t value);
#define GED_SetDataTypeIndexNoDep(ins, value) ( \
    GED_TraceAPI("GED_SetDataTypeIndexNoDep(" #ins ", " #value ")"), \
    _GED_SetDataTypeIndexNoDep(ins, value))

/*!
 * Get the value of the CompactedImm field in the given instruction. See @ref GED_INS_FIELD_CompactedImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetCompactedImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetCompactedImm(ins, result) ( \
    GED_TraceAPI("GED_GetCompactedImm(" #ins ", " #result ")"), \
    _GED_GetCompactedImm(ins, result))

/*!
 * Set the value of the CompactedImm field in the given instruction. See @ref GED_INS_FIELD_CompactedImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetCompactedImm(ged_ins_t* ins, const uint32_t value);
#define GED_SetCompactedImm(ins, value) ( \
    GED_TraceAPI("GED_SetCompactedImm(" #ins ", " #value ")"), \
    _GED_SetCompactedImm(ins, value))

/*!
 * Get the value of the RepeatCount field in the given instruction. See @ref GED_INS_FIELD_RepeatCount for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetRepeatCount(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetRepeatCount(ins, result) ( \
    GED_TraceAPI("GED_GetRepeatCount(" #ins ", " #result ")"), \
    _GED_GetRepeatCount(ins, result))

/*!
 * Set the value of the RepeatCount field in the given instruction. See @ref GED_INS_FIELD_RepeatCount for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetRepeatCount(ged_ins_t* ins, const uint32_t value);
#define GED_SetRepeatCount(ins, value) ( \
    GED_TraceAPI("GED_SetRepeatCount(" #ins ", " #value ")"), \
    _GED_SetRepeatCount(ins, value))

/*!
 * Get the value of the SystolicDepth field in the given instruction. See @ref GED_INS_FIELD_SystolicDepth for the field's
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSystolicDepth(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSystolicDepth(ins, result) ( \
    GED_TraceAPI("GED_GetSystolicDepth(" #ins ", " #result ")"), \
    _GED_GetSystolicDepth(ins, result))

/*!
 * Set the value of the SystolicDepth field in the given instruction. See @ref GED_INS_FIELD_SystolicDepth for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSystolicDepth(ged_ins_t* ins, const uint32_t value);
#define GED_SetSystolicDepth(ins, value) ( \
    GED_TraceAPI("GED_SetSystolicDepth(" #ins ", " #value ")"), \
    _GED_SetSystolicDepth(ins, value))

/*!
 * Get the value of the Src2Precision field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetPrecisionString. See @ref GED_INS_FIELD_Src2Precision for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2Precision's enumeration if the field is valid, GED_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_PRECISION GED_CALLCONV _GED_GetSrc2Precision(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2Precision(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2Precision(" #ins ", " #result ")"), \
    _GED_GetSrc2Precision(ins, result))

/*!
 * Set the value of the Src2Precision field in the given instruction. See @ref GED_INS_FIELD_Src2Precision for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2Precision(ged_ins_t* ins, const GED_PRECISION value);
#define GED_SetSrc2Precision(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2Precision(" #ins ", " #value ")"), \
    _GED_SetSrc2Precision(ins, value))

/*!
 * Get the value of the Src2SubBytePrecision field in the given instruction. The function returns an enumeration value. To obtain the
 * enum entry's string representation, use @ref GED_GetSubBytePrecisionString. See @ref GED_INS_FIELD_Src2SubBytePrecision for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src2SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SUB_BYTE_PRECISION GED_CALLCONV _GED_GetSrc2SubBytePrecision(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2SubBytePrecision(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2SubBytePrecision(" #ins ", " #result ")"), \
    _GED_GetSrc2SubBytePrecision(ins, result))

/*!
 * Set the value of the Src2SubBytePrecision field in the given instruction. See @ref GED_INS_FIELD_Src2SubBytePrecision for the
 * field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2SubBytePrecision(ged_ins_t* ins, const GED_SUB_BYTE_PRECISION value);
#define GED_SetSrc2SubBytePrecision(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2SubBytePrecision(" #ins ", " #value ")"), \
    _GED_SetSrc2SubBytePrecision(ins, value))

/*!
 * Get the value of the Src1Precision field in the given instruction. The function returns an enumeration value. To obtain the enum
 * entry's string representation, use @ref GED_GetPrecisionString. See @ref GED_INS_FIELD_Src1Precision for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1Precision's enumeration if the field is valid, GED_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_PRECISION GED_CALLCONV _GED_GetSrc1Precision(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1Precision(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1Precision(" #ins ", " #result ")"), \
    _GED_GetSrc1Precision(ins, result))

/*!
 * Set the value of the Src1Precision field in the given instruction. See @ref GED_INS_FIELD_Src1Precision for the field's
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1Precision(ged_ins_t* ins, const GED_PRECISION value);
#define GED_SetSrc1Precision(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1Precision(" #ins ", " #value ")"), \
    _GED_SetSrc1Precision(ins, value))

/*!
 * Get the value of the Src1SubBytePrecision field in the given instruction. The function returns an enumeration value. To obtain the
 * enum entry's string representation, use @ref GED_GetSubBytePrecisionString. See @ref GED_INS_FIELD_Src1SubBytePrecision for the
 * field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      Src1SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SUB_BYTE_PRECISION GED_CALLCONV _GED_GetSrc1SubBytePrecision(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1SubBytePrecision(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1SubBytePrecision(" #ins ", " #result ")"), \
    _GED_GetSrc1SubBytePrecision(ins, result))

/*!
 * Set the value of the Src1SubBytePrecision field in the given instruction. See @ref GED_INS_FIELD_Src1SubBytePrecision for the
 * field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1SubBytePrecision(ged_ins_t* ins, const GED_SUB_BYTE_PRECISION value);
#define GED_SetSrc1SubBytePrecision(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1SubBytePrecision(" #ins ", " #value ")"), \
    _GED_SetSrc1SubBytePrecision(ins, value))

/*!
 * Get the value of the BfnFC field in the given instruction. See @ref GED_INS_FIELD_BfnFC for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetBfnFC(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetBfnFC(ins, result) ( \
    GED_TraceAPI("GED_GetBfnFC(" #ins ", " #result ")"), \
    _GED_GetBfnFC(ins, result))

/*!
 * Set the value of the BfnFC field in the given instruction. See @ref GED_INS_FIELD_BfnFC for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetBfnFC(ged_ins_t* ins, const uint32_t value);
#define GED_SetBfnFC(ins, value) ( \
    GED_TraceAPI("GED_SetBfnFC(" #ins ", " #value ")"), \
    _GED_SetBfnFC(ins, value))

/*!
 * Get the value of the ExBSO field in the given instruction. See @ref GED_INS_FIELD_ExBSO for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetExBSO(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetExBSO(ins, result) ( \
    GED_TraceAPI("GED_GetExBSO(" #ins ", " #result ")"), \
    _GED_GetExBSO(ins, result))

/*!
 * Set the value of the ExBSO field in the given instruction. See @ref GED_INS_FIELD_ExBSO for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExBSO(ged_ins_t* ins, const uint32_t value);
#define GED_SetExBSO(ins, value) ( \
    GED_TraceAPI("GED_SetExBSO(" #ins ", " #value ")"), \
    _GED_SetExBSO(ins, value))

/*!
 * Get the value of the CPS field in the given instruction. See @ref GED_INS_FIELD_CPS for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetCPS(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetCPS(ins, result) ( \
    GED_TraceAPI("GED_GetCPS(" #ins ", " #result ")"), \
    _GED_GetCPS(ins, result))

/*!
 * Set the value of the CPS field in the given instruction. See @ref GED_INS_FIELD_CPS for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetCPS(ged_ins_t* ins, const uint32_t value);
#define GED_SetCPS(ins, value) ( \
    GED_TraceAPI("GED_SetCPS(" #ins ", " #value ")"), \
    _GED_SetCPS(ins, value))

/*!
 * Get the value of the Src1Length field in the given instruction. See @ref GED_INS_FIELD_Src1Length for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc1Length(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc1Length(ins, result) ( \
    GED_TraceAPI("GED_GetSrc1Length(" #ins ", " #result ")"), \
    _GED_GetSrc1Length(ins, result))

/*!
 * Set the value of the Src1Length field in the given instruction. See @ref GED_INS_FIELD_Src1Length for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc1Length(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc1Length(ins, value) ( \
    GED_TraceAPI("GED_SetSrc1Length(" #ins ", " #value ")"), \
    _GED_SetSrc1Length(ins, value))

/*!
 * Get the value of the Src2IsImm field in the given instruction. See @ref GED_INS_FIELD_Src2IsImm for the field's description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetSrc2IsImm(ged_ins_t* ins, GED_RETURN_VALUE* result);
#define GED_GetSrc2IsImm(ins, result) ( \
    GED_TraceAPI("GED_GetSrc2IsImm(" #ins ", " #result ")"), \
    _GED_GetSrc2IsImm(ins, result))

/*!
 * Set the value of the Src2IsImm field in the given instruction. See @ref GED_INS_FIELD_Src2IsImm for the field's description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSrc2IsImm(ged_ins_t* ins, const uint32_t value);
#define GED_SetSrc2IsImm(ins, value) ( \
    GED_TraceAPI("GED_SetSrc2IsImm(" #ins ", " #value ")"), \
    _GED_SetSrc2IsImm(ins, value))

/*!
 * Get the value of the AddrImm field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrImm, @ref GED_INS_FIELD_Src1AddrImm for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, -1 otherwise. If -1 is a valid value for this field, it is important to
 *              check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern int32_t GED_CALLCONV _GED_GetIndexedSrcAddrImm(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcAddrImm(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcAddrImm(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcAddrImm(ins, result, index))

/*!
 * Set the value of the AddrImm field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrImm, @ref GED_INS_FIELD_Src1AddrImm for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcAddrImm(ged_ins_t* ins, const int32_t value, const uint8_t index);
#define GED_SetIndexedSrcAddrImm(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcAddrImm(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcAddrImm(ins, value, index))

/*!
 * Get the value of the AddrMode field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrMode, @ref GED_INS_FIELD_Src1AddrMode, @ref GED_INS_FIELD_Src2AddrMode for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      Src1SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_ADDR_MODE GED_CALLCONV _GED_GetIndexedSrcAddrMode(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcAddrMode(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcAddrMode(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcAddrMode(ins, result, index))

/*!
 * Set the value of the AddrMode field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrMode, @ref GED_INS_FIELD_Src1AddrMode, @ref GED_INS_FIELD_Src2AddrMode for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcAddrMode(ged_ins_t* ins, const GED_ADDR_MODE value, const uint8_t index);
#define GED_SetIndexedSrcAddrMode(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcAddrMode(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcAddrMode(ins, value, index))

/*!
 * Get the value of the AddrSubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrSubRegNum, @ref GED_INS_FIELD_Src1AddrSubRegNum for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcAddrSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcAddrSubRegNum(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcAddrSubRegNum(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcAddrSubRegNum(ins, result, index))

/*!
 * Set the value of the AddrSubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0AddrSubRegNum, @ref GED_INS_FIELD_Src1AddrSubRegNum for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcAddrSubRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcAddrSubRegNum(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcAddrSubRegNum(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcAddrSubRegNum(ins, value, index))

/*!
 * Get the value of the ChanSel field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0ChanSel, @ref GED_INS_FIELD_Src1ChanSel, @ref GED_INS_FIELD_Src2ChanSel for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcChanSel(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcChanSel(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcChanSel(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcChanSel(ins, result, index))

/*!
 * Set the value of the ChanSel field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0ChanSel, @ref GED_INS_FIELD_Src1ChanSel, @ref GED_INS_FIELD_Src2ChanSel for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcChanSel(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcChanSel(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcChanSel(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcChanSel(ins, value, index))

/*!
 * Get the value of the DataType field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0DataType, @ref GED_INS_FIELD_Src1DataType, @ref GED_INS_FIELD_Src2DataType for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      Src1SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_DATA_TYPE GED_CALLCONV _GED_GetIndexedSrcDataType(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcDataType(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcDataType(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcDataType(ins, result, index))

/*!
 * Set the value of the DataType field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0DataType, @ref GED_INS_FIELD_Src1DataType, @ref GED_INS_FIELD_Src2DataType for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcDataType(ged_ins_t* ins, const GED_DATA_TYPE value, const uint8_t index);
#define GED_SetIndexedSrcDataType(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcDataType(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcDataType(ins, value, index))

/*!
 * Get the value of the HorzStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0HorzStride, @ref GED_INS_FIELD_Src1HorzStride, @ref GED_INS_FIELD_Src2HorzStride for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcHorzStride(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcHorzStride(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcHorzStride(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcHorzStride(ins, result, index))

/*!
 * Set the value of the HorzStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0HorzStride, @ref GED_INS_FIELD_Src1HorzStride, @ref GED_INS_FIELD_Src2HorzStride for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcHorzStride(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcHorzStride(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcHorzStride(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcHorzStride(ins, value, index))

/*!
 * Get the value of the Index field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Index, @ref GED_INS_FIELD_Src1Index for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcIndex(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcIndex(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcIndex(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcIndex(ins, result, index))

/*!
 * Set the value of the Index field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Index, @ref GED_INS_FIELD_Src1Index for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcIndex(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcIndex(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcIndex(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcIndex(ins, value, index))

/*!
 * Get the value of the IsImm field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0IsImm, @ref GED_INS_FIELD_Src1IsImm, @ref GED_INS_FIELD_Src2IsImm for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcIsImm(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcIsImm(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcIsImm(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcIsImm(ins, result, index))

/*!
 * Set the value of the IsImm field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0IsImm, @ref GED_INS_FIELD_Src1IsImm, @ref GED_INS_FIELD_Src2IsImm for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcIsImm(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcIsImm(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcIsImm(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcIsImm(ins, value, index))

/*!
 * Get the value of the MathMacroExt field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0MathMacroExt, @ref GED_INS_FIELD_Src1MathMacroExt, @ref GED_INS_FIELD_Src2MathMacroExt for the fields'
 * description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      Src1SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_MATH_MACRO_EXT GED_CALLCONV _GED_GetIndexedSrcMathMacroExt(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcMathMacroExt(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcMathMacroExt(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcMathMacroExt(ins, result, index))

/*!
 * Set the value of the MathMacroExt field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0MathMacroExt, @ref GED_INS_FIELD_Src1MathMacroExt, @ref GED_INS_FIELD_Src2MathMacroExt for the fields'
 * description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcMathMacroExt(ged_ins_t* ins, const GED_MATH_MACRO_EXT value, const uint8_t
                                                                    index);
#define GED_SetIndexedSrcMathMacroExt(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcMathMacroExt(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcMathMacroExt(ins, value, index))

/*!
 * Get the value of the RegFile field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegFile, @ref GED_INS_FIELD_Src1RegFile, @ref GED_INS_FIELD_Src2RegFile for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      Src1SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REG_FILE GED_CALLCONV _GED_GetIndexedSrcRegFile(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcRegFile(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcRegFile(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcRegFile(ins, result, index))

/*!
 * Set the value of the RegFile field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegFile, @ref GED_INS_FIELD_Src1RegFile, @ref GED_INS_FIELD_Src2RegFile for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcRegFile(ged_ins_t* ins, const GED_REG_FILE value, const uint8_t index);
#define GED_SetIndexedSrcRegFile(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcRegFile(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcRegFile(ins, value, index))

/*!
 * Get the value of the RegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegNum, @ref GED_INS_FIELD_Src1RegNum, @ref GED_INS_FIELD_Src2RegNum for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcRegNum(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcRegNum(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcRegNum(ins, result, index))

/*!
 * Set the value of the RegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RegNum, @ref GED_INS_FIELD_Src1RegNum, @ref GED_INS_FIELD_Src2RegNum for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcRegNum(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcRegNum(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcRegNum(ins, value, index))

/*!
 * Get the value of the RepCtrl field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RepCtrl, @ref GED_INS_FIELD_Src1RepCtrl, @ref GED_INS_FIELD_Src2RepCtrl for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      Src1SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_REP_CTRL GED_CALLCONV _GED_GetIndexedSrcRepCtrl(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcRepCtrl(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcRepCtrl(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcRepCtrl(ins, result, index))

/*!
 * Set the value of the RepCtrl field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0RepCtrl, @ref GED_INS_FIELD_Src1RepCtrl, @ref GED_INS_FIELD_Src2RepCtrl for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcRepCtrl(ged_ins_t* ins, const GED_REP_CTRL value, const uint8_t index);
#define GED_SetIndexedSrcRepCtrl(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcRepCtrl(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcRepCtrl(ins, value, index))

/*!
 * Get the value of the SrcMod field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SrcMod, @ref GED_INS_FIELD_Src1SrcMod, @ref GED_INS_FIELD_Src2SrcMod for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      Src1SubBytePrecision's enumeration if the field is valid, GED_SUB_BYTE_PRECISION_INVALID otherwise.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern GED_SRC_MOD GED_CALLCONV _GED_GetIndexedSrcSrcMod(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcSrcMod(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcSrcMod(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcSrcMod(ins, result, index))

/*!
 * Set the value of the SrcMod field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SrcMod, @ref GED_INS_FIELD_Src1SrcMod, @ref GED_INS_FIELD_Src2SrcMod for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcSrcMod(ged_ins_t* ins, const GED_SRC_MOD value, const uint8_t index);
#define GED_SetIndexedSrcSrcMod(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcSrcMod(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcSrcMod(ins, value, index))

/*!
 * Get the value of the SubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNum, @ref GED_INS_FIELD_Src1SubRegNum, @ref GED_INS_FIELD_Src2SubRegNum for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcSubRegNum(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcSubRegNum(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcSubRegNum(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcSubRegNum(ins, result, index))

/*!
 * Set the value of the SubRegNum field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNum, @ref GED_INS_FIELD_Src1SubRegNum, @ref GED_INS_FIELD_Src2SubRegNum for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcSubRegNum(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcSubRegNum(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcSubRegNum(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcSubRegNum(ins, value, index))

/*!
 * Get the value of the SubRegNumByte field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNumByte for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value if the field is valid, uint32_t equivalent of -1 otherwise. If -1 is a valid value for this field,
 *              it is important to check the GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcSubRegNumByte(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcSubRegNumByte(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcSubRegNumByte(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcSubRegNumByte(ins, result, index))

/*!
 * Set the value of the SubRegNumByte field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0SubRegNumByte for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcSubRegNumByte(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcSubRegNumByte(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcSubRegNumByte(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcSubRegNumByte(ins, value, index))

/*!
 * Get the value of the VertStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0VertStride, @ref GED_INS_FIELD_Src1VertStride, @ref GED_INS_FIELD_Src2VertStride for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcVertStride(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcVertStride(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcVertStride(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcVertStride(ins, result, index))

/*!
 * Set the value of the VertStride field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0VertStride, @ref GED_INS_FIELD_Src1VertStride, @ref GED_INS_FIELD_Src2VertStride for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcVertStride(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcVertStride(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcVertStride(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcVertStride(ins, value, index))

/*!
 * Get the value of the Width field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Width, @ref GED_INS_FIELD_Src1Width for the fields' description.
 *
 * @param[in]       ins    Pointer to the decoded instruction object.
 * @param[out]      result If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific error
 *                         which caused the failure.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      The requested value upon success. If the encoded value is not valid, i.e. does not map to any valid enumerated value
 *              for this instruction, the (invalid) encoded value is returned. If the field is not valid for the instruction, the
 *              uint32_t equivalent of -1 is returned. If -1 is a valid value for this field, it is important to check the
 *              GED_RETURN_VALUE result.
 *
 * @note        @ref GED_DecodeIns must be called with the given instruction before calling this function.
 */
extern uint32_t GED_CALLCONV _GED_GetIndexedSrcWidth(ged_ins_t* ins, GED_RETURN_VALUE* result, const uint8_t index);
#define GED_GetIndexedSrcWidth(ins, result, index) ( \
    GED_TraceAPI("GED_GetIndexedSrcWidth(" #ins ", " #result ", " #index ")"), \
    _GED_GetIndexedSrcWidth(ins, result, index))

/*!
 * Set the value of the Width field which corresponds to an indexed Src operand in the given instruction. See @ref
 * GED_INS_FIELD_Src0Width, @ref GED_INS_FIELD_Src1Width for the fields' description.
 *
 * @param[in,out]   ins    Pointer to the instruction object for encoding.
 * @param[in]       value  The value to encode.
 * @param[in]       index  The index (number) of the source operand.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetIndexedSrcWidth(ged_ins_t* ins, const uint32_t value, const uint8_t index);
#define GED_SetIndexedSrcWidth(ins, value, index) ( \
    GED_TraceAPI("GED_SetIndexedSrcWidth(" #ins ", " #value ", " #index ")"), \
    _GED_SetIndexedSrcWidth(ins, value, index))

/*!
 * Get the value of the ArchReg field from the given register number (as obtained by @ref GED_GetDstRegNum, @ref GED_GetSrc0RegNum or
 * @ref GED_GetSrc1RegNum). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetArchRegString. See @ref GED_PSEUDO_FIELD_ArchReg for the field's description.
 *
 * @param[in]       regNum     The register number.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      ArchReg's enumeration if the field is valid, GED_ARCH_REG_INVALID otherwise.
 */
extern GED_ARCH_REG GED_CALLCONV _GED_GetArchReg(const uint32_t regNum, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetArchReg(regNum, modelId, result) ( \
    GED_TraceAPI("GED_GetArchReg(" #regNum ", " #modelId ", " #result ")"), \
    _GED_GetArchReg(regNum, modelId, result))

/*!
 * Set the value of the ArchReg field in the given register number. The latter can then be set to its appropriate fields (@ref
 * GED_SetDstRegNum, @ref GED_SetSrc0RegNum or @ref GED_SetSrc1RegNum). See @ref GED_PSEUDO_FIELD_ArchReg for the field's description.
 *
 * @param[in,out]   regNum     The register number.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       archReg    The architectural register.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetArchReg(uint32_t* regNum, const GED_MODEL modelId, const GED_ARCH_REG archReg);
#define GED_SetArchReg(regNum, modelId, archReg) ( \
    GED_TraceAPI("GED_SetArchReg(" #regNum ", " #modelId ", " #archReg ")"), \
    _GED_SetArchReg(regNum, modelId, archReg))

/*!
 * Get the value of the ArchRegNum field from the given register number (as obtained by @ref GED_GetDstRegNum, @ref GED_GetSrc0RegNum
 * or @ref GED_GetSrc1RegNum). See @ref GED_PSEUDO_FIELD_ArchRegNum for the field's description.
 *
 * @param[in]       regNum     The register number.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The architectural register number if the field is valid, the unchanged regNum value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetArchRegNum(const uint32_t regNum, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetArchRegNum(regNum, modelId, result) ( \
    GED_TraceAPI("GED_GetArchRegNum(" #regNum ", " #modelId ", " #result ")"), \
    _GED_GetArchRegNum(regNum, modelId, result))

/*!
 * Set the value of the ArchRegNum field in the given register number. The latter can then be set to its appropriate fields (@ref
 * GED_SetDstRegNum, @ref GED_SetSrc0RegNum or @ref GED_SetSrc1RegNum). See @ref GED_PSEUDO_FIELD_ArchRegNum for the field's
 * description.
 *
 * @param[in,out]   regNum     The register number.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       archRegNum The architectural register number.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetArchRegNum(uint32_t* regNum, const GED_MODEL modelId, const uint32_t archRegNum);
#define GED_SetArchRegNum(regNum, modelId, archRegNum) ( \
    GED_TraceAPI("GED_SetArchRegNum(" #regNum ", " #modelId ", " #archRegNum ")"), \
    _GED_SetArchRegNum(regNum, modelId, archRegNum))

/*!
 * Get the value of the SwizzleX field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleX for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleX's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV _GED_GetSwizzleX(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetSwizzleX(chanSel, modelId, result) ( \
    GED_TraceAPI("GED_GetSwizzleX(" #chanSel ", " #modelId ", " #result ")"), \
    _GED_GetSwizzleX(chanSel, modelId, result))

/*!
 * Set the value of the SwizzleX field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleX for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSwizzleX(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);
#define GED_SetSwizzleX(chanSel, modelId, swizzle) ( \
    GED_TraceAPI("GED_SetSwizzleX(" #chanSel ", " #modelId ", " #swizzle ")"), \
    _GED_SetSwizzleX(chanSel, modelId, swizzle))

/*!
 * Get the value of the SwizzleY field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleY for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleY's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV _GED_GetSwizzleY(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetSwizzleY(chanSel, modelId, result) ( \
    GED_TraceAPI("GED_GetSwizzleY(" #chanSel ", " #modelId ", " #result ")"), \
    _GED_GetSwizzleY(chanSel, modelId, result))

/*!
 * Set the value of the SwizzleY field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleY for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSwizzleY(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);
#define GED_SetSwizzleY(chanSel, modelId, swizzle) ( \
    GED_TraceAPI("GED_SetSwizzleY(" #chanSel ", " #modelId ", " #swizzle ")"), \
    _GED_SetSwizzleY(chanSel, modelId, swizzle))

/*!
 * Get the value of the SwizzleZ field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleZ for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleZ's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV _GED_GetSwizzleZ(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetSwizzleZ(chanSel, modelId, result) ( \
    GED_TraceAPI("GED_GetSwizzleZ(" #chanSel ", " #modelId ", " #result ")"), \
    _GED_GetSwizzleZ(chanSel, modelId, result))

/*!
 * Set the value of the SwizzleZ field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleZ for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSwizzleZ(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);
#define GED_SetSwizzleZ(chanSel, modelId, swizzle) ( \
    GED_TraceAPI("GED_SetSwizzleZ(" #chanSel ", " #modelId ", " #swizzle ")"), \
    _GED_SetSwizzleZ(chanSel, modelId, swizzle))

/*!
 * Get the value of the SwizzleW field from the given channel select (as obtained by @ref GED_GetSrc0ChanSel, @ref GED_GetSrc1ChanSel
 * or @ref GED_GetSrc2ChanSel). The function returns an enumeration value. To obtain the enum entry's string representation, use @ref
 * GED_GetSwizzleString. See @ref GED_PSEUDO_FIELD_SwizzleW for the field's description.
 *
 * @param[in]       chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SwizzleW's enumeration if the field is valid, GED_SWIZZLE_INVALID otherwise.
 */
extern GED_SWIZZLE GED_CALLCONV _GED_GetSwizzleW(const uint32_t chanSel, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetSwizzleW(chanSel, modelId, result) ( \
    GED_TraceAPI("GED_GetSwizzleW(" #chanSel ", " #modelId ", " #result ")"), \
    _GED_GetSwizzleW(chanSel, modelId, result))

/*!
 * Set the value of the SwizzleW field in the given channel select. The latter can then be set to its appropriate fields (@ref
 * GED_SetSrc0ChanSel, @ref GED_SetSrc1ChanSel or @ref GED_SetSrc2ChanSel). See @ref GED_PSEUDO_FIELD_SwizzleW for the field's
 * description.
 *
 * @param[in,out]   chanSel    The channel select.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       swizzle    The swizzle value.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSwizzleW(uint32_t* chanSel, const GED_MODEL modelId, const GED_SWIZZLE swizzle);
#define GED_SetSwizzleW(chanSel, modelId, swizzle) ( \
    GED_TraceAPI("GED_SetSwizzleW(" #chanSel ", " #modelId ", " #swizzle ")"), \
    _GED_SetSwizzleW(chanSel, modelId, swizzle))

/*!
 * Get the value of the MessageLength field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_MessageLength for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The message length if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetMessageLength(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetMessageLength(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageLength(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageLength(msgDesc, modelId, result))

/*!
 * Set the value of the MessageLength field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageLength for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       length     The message length.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageLength(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t length);
#define GED_SetMessageLength(msgDesc, modelId, length) ( \
    GED_TraceAPI("GED_SetMessageLength(" #msgDesc ", " #modelId ", " #length ")"), \
    _GED_SetMessageLength(msgDesc, modelId, length))

/*!
 * Get the value of the ResponseLength field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_ResponseLength for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The response length if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetResponseLength(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetResponseLength(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetResponseLength(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetResponseLength(msgDesc, modelId, result))

/*!
 * Set the value of the ResponseLength field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_ResponseLength for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       length     The response length.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetResponseLength(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t length);
#define GED_SetResponseLength(msgDesc, modelId, length) ( \
    GED_TraceAPI("GED_SetResponseLength(" #msgDesc ", " #modelId ", " #length ")"), \
    _GED_SetResponseLength(msgDesc, modelId, length))

/*!
 * Get the value of the HeaderPresent field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetHeaderPresentString. See @ref
 * GED_PSEUDO_FIELD_HeaderPresent for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      HeaderPresent's enumeration if the field is valid, GED_HEADER_PRESENT_INVALID otherwise.
 */
extern GED_HEADER_PRESENT GED_CALLCONV _GED_GetHeaderPresent(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                             result);
#define GED_GetHeaderPresent(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetHeaderPresent(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetHeaderPresent(msgDesc, modelId, result))

/*!
 * Set the value of the HeaderPresent field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_HeaderPresent for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       headerPresent  The header present.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetHeaderPresent(uint32_t* msgDesc, const GED_MODEL modelId, const GED_HEADER_PRESENT
                                                           headerPresent);
#define GED_SetHeaderPresent(msgDesc, modelId, headerPresent) ( \
    GED_TraceAPI("GED_SetHeaderPresent(" #msgDesc ", " #modelId ", " #headerPresent ")"), \
    _GED_SetHeaderPresent(msgDesc, modelId, headerPresent))

/*!
 * Get the value of the MessageTypeDP_SAMPLER field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See
 * @ref GED_PSEUDO_FIELD_MessageTypeDP_SAMPLER for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_SAMPLER's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_SAMPLER(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                   result);
#define GED_GetMessageTypeDP_SAMPLER(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_SAMPLER(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_SAMPLER(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_SAMPLER field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_SAMPLER for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port sampler message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_SAMPLER(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                                   messageType);
#define GED_SetMessageTypeDP_SAMPLER(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_SAMPLER(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_SAMPLER(msgDesc, modelId, messageType))

/*!
 * Get the value of the MessageTypeDP_RC field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_RC for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_RC's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_RC(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                              result);
#define GED_GetMessageTypeDP_RC(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_RC(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_RC(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_RC field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_RC for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port render cache message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_RC(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                              messageType);
#define GED_SetMessageTypeDP_RC(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_RC(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_RC(msgDesc, modelId, messageType))

/*!
 * Get the value of the MessageTypeDP_CC field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_CC for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_CC's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_CC(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                              result);
#define GED_GetMessageTypeDP_CC(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_CC(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_CC(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_CC field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_CC for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port constant cache message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_CC(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                              messageType);
#define GED_SetMessageTypeDP_CC(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_CC(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_CC(msgDesc, modelId, messageType))

/*!
 * Get the value of the MessageTypeDP_DC0 field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DC0 for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC0's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_DC0(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                               result);
#define GED_GetMessageTypeDP_DC0(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_DC0(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_DC0(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_DC0 field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0 for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port data cache 0 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_DC0(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                               messageType);
#define GED_SetMessageTypeDP_DC0(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_DC0(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_DC0(msgDesc, modelId, messageType))

/*!
 * Get the value of the TypedSurfaceSlotGroup field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSlotGroupString. See @ref
 * GED_PSEUDO_FIELD_TypedSurfaceSlotGroup for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      TypedSurfaceSlotGroup's enumeration if the field is valid, GED_SLOT_GROUP_INVALID otherwise.
 */
extern GED_SLOT_GROUP GED_CALLCONV _GED_GetTypedSurfaceSlotGroup(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                 result);
#define GED_GetTypedSurfaceSlotGroup(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetTypedSurfaceSlotGroup(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetTypedSurfaceSlotGroup(msgDesc, modelId, result))

/*!
 * Set the value of the TypedSurfaceSlotGroup field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_TypedSurfaceSlotGroup for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       slotGroup  The typed surface slot group.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetTypedSurfaceSlotGroup(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SLOT_GROUP
                                                                   slotGroup);
#define GED_SetTypedSurfaceSlotGroup(msgDesc, modelId, slotGroup) ( \
    GED_TraceAPI("GED_SetTypedSurfaceSlotGroup(" #msgDesc ", " #modelId ", " #slotGroup ")"), \
    _GED_SetTypedSurfaceSlotGroup(msgDesc, modelId, slotGroup))

/*!
 * Get the value of the TypedAtomicSlotGroup field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSlotGroupString. See @ref
 * GED_PSEUDO_FIELD_TypedAtomicSlotGroup for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      TypedAtomicSlotGroup's enumeration if the field is valid, GED_SLOT_GROUP_INVALID otherwise.
 */
extern GED_SLOT_GROUP GED_CALLCONV _GED_GetTypedAtomicSlotGroup(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                result);
#define GED_GetTypedAtomicSlotGroup(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetTypedAtomicSlotGroup(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetTypedAtomicSlotGroup(msgDesc, modelId, result))

/*!
 * Set the value of the TypedAtomicSlotGroup field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_TypedAtomicSlotGroup for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       slotGroup  The typed atomic slot group.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetTypedAtomicSlotGroup(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SLOT_GROUP
                                                                  slotGroup);
#define GED_SetTypedAtomicSlotGroup(msgDesc, modelId, slotGroup) ( \
    GED_TraceAPI("GED_SetTypedAtomicSlotGroup(" #msgDesc ", " #modelId ", " #slotGroup ")"), \
    _GED_SetTypedAtomicSlotGroup(msgDesc, modelId, slotGroup))

/*!
 * Get the value of the UntypedSurfaceSIMDMode field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSIMDModeString. See @ref
 * GED_PSEUDO_FIELD_UntypedSurfaceSIMDMode for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      UntypedSurfaceSIMDMode's enumeration if the field is valid, GED_SIMDMODE_INVALID otherwise.
 */
extern GED_SIMDMODE GED_CALLCONV _GED_GetUntypedSurfaceSIMDMode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                result);
#define GED_GetUntypedSurfaceSIMDMode(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetUntypedSurfaceSIMDMode(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetUntypedSurfaceSIMDMode(msgDesc, modelId, result))

/*!
 * Set the value of the UntypedSurfaceSIMDMode field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_UntypedSurfaceSIMDMode for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       simdMode   The untyped surface SIMD mode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetUntypedSurfaceSIMDMode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SIMDMODE
                                                                    simdMode);
#define GED_SetUntypedSurfaceSIMDMode(msgDesc, modelId, simdMode) ( \
    GED_TraceAPI("GED_SetUntypedSurfaceSIMDMode(" #msgDesc ", " #modelId ", " #simdMode ")"), \
    _GED_SetUntypedSurfaceSIMDMode(msgDesc, modelId, simdMode))

/*!
 * Get the value of the UntypedAtomicSIMDMode field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSIMDModeString. See @ref
 * GED_PSEUDO_FIELD_UntypedAtomicSIMDMode for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      UntypedAtomicSIMDMode's enumeration if the field is valid, GED_SIMDMODE_INVALID otherwise.
 */
extern GED_SIMDMODE GED_CALLCONV _GED_GetUntypedAtomicSIMDMode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                               result);
#define GED_GetUntypedAtomicSIMDMode(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetUntypedAtomicSIMDMode(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetUntypedAtomicSIMDMode(msgDesc, modelId, result))

/*!
 * Set the value of the UntypedAtomicSIMDMode field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_UntypedAtomicSIMDMode for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       simdMode   The untyped atomic SIMD mode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetUntypedAtomicSIMDMode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SIMDMODE
                                                                   simdMode);
#define GED_SetUntypedAtomicSIMDMode(msgDesc, modelId, simdMode) ( \
    GED_TraceAPI("GED_SetUntypedAtomicSIMDMode(" #msgDesc ", " #modelId ", " #simdMode ")"), \
    _GED_SetUntypedAtomicSIMDMode(msgDesc, modelId, simdMode))

/*!
 * Get the value of the InvalidateAfterRead field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_InvalidateAfterRead for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The invalidate after read enable if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetInvalidateAfterRead(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetInvalidateAfterRead(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetInvalidateAfterRead(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetInvalidateAfterRead(msgDesc, modelId, result))

/*!
 * Set the value of the InvalidateAfterRead field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_InvalidateAfterRead for the field's description.
 *
 * @param[in,out]   msgDesc                    The message descriptor.
 * @param[in]       modelId                    The GED model by which to interpret.
 * @param[in]       invalidateAfterReadEnable  The invalidate after read enable.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetInvalidateAfterRead(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t
                                                                 invalidateAfterReadEnable);
#define GED_SetInvalidateAfterRead(msgDesc, modelId, invalidateAfterReadEnable) ( \
    GED_TraceAPI("GED_SetInvalidateAfterRead(" #msgDesc ", " #modelId ", " #invalidateAfterReadEnable ")"), \
    _GED_SetInvalidateAfterRead(msgDesc, modelId, invalidateAfterReadEnable))

/*!
 * Get the value of the BlockSize field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetBlockSizeString. See @ref
 * GED_PSEUDO_FIELD_BlockSize for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      BlockSize's enumeration if the field is valid, GED_BLOCK_SIZE_INVALID otherwise.
 */
extern GED_BLOCK_SIZE GED_CALLCONV _GED_GetBlockSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetBlockSize(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetBlockSize(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetBlockSize(msgDesc, modelId, result))

/*!
 * Set the value of the BlockSize field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_BlockSize for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       blockSize  The block size.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetBlockSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_BLOCK_SIZE blockSize);
#define GED_SetBlockSize(msgDesc, modelId, blockSize) ( \
    GED_TraceAPI("GED_SetBlockSize(" #msgDesc ", " #modelId ", " #blockSize ")"), \
    _GED_SetBlockSize(msgDesc, modelId, blockSize))

/*!
 * Get the value of the RedChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_RedChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      RedChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV _GED_GetRedChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetRedChannel(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetRedChannel(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetRedChannel(msgDesc, modelId, result))

/*!
 * Set the value of the RedChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_RedChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       channel    The red channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetRedChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);
#define GED_SetRedChannel(msgDesc, modelId, channel) ( \
    GED_TraceAPI("GED_SetRedChannel(" #msgDesc ", " #modelId ", " #channel ")"), \
    _GED_SetRedChannel(msgDesc, modelId, channel))

/*!
 * Get the value of the GreenChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_GreenChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      GreenChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV _GED_GetGreenChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetGreenChannel(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetGreenChannel(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetGreenChannel(msgDesc, modelId, result))

/*!
 * Set the value of the GreenChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_GreenChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       channel    The green channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetGreenChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);
#define GED_SetGreenChannel(msgDesc, modelId, channel) ( \
    GED_TraceAPI("GED_SetGreenChannel(" #msgDesc ", " #modelId ", " #channel ")"), \
    _GED_SetGreenChannel(msgDesc, modelId, channel))

/*!
 * Get the value of the BlueChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_BlueChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      BlueChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV _GED_GetBlueChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetBlueChannel(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetBlueChannel(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetBlueChannel(msgDesc, modelId, result))

/*!
 * Set the value of the BlueChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_BlueChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       channel    The blue channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetBlueChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);
#define GED_SetBlueChannel(msgDesc, modelId, channel) ( \
    GED_TraceAPI("GED_SetBlueChannel(" #msgDesc ", " #modelId ", " #channel ")"), \
    _GED_SetBlueChannel(msgDesc, modelId, channel))

/*!
 * Get the value of the AlphaChannel field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetChannelMaskString. See @ref
 * GED_PSEUDO_FIELD_AlphaChannel for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      AlphaChannel's enumeration if the field is valid, GED_CHANNEL_MASK_INVALID otherwise.
 */
extern GED_CHANNEL_MASK GED_CALLCONV _GED_GetAlphaChannel(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetAlphaChannel(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetAlphaChannel(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetAlphaChannel(msgDesc, modelId, result))

/*!
 * Set the value of the AlphaChannel field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_AlphaChannel for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       channel    The alpha channel.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetAlphaChannel(uint32_t* msgDesc, const GED_MODEL modelId, const GED_CHANNEL_MASK channel);
#define GED_SetAlphaChannel(msgDesc, modelId, channel) ( \
    GED_TraceAPI("GED_SetAlphaChannel(" #msgDesc ", " #modelId ", " #channel ")"), \
    _GED_SetAlphaChannel(msgDesc, modelId, channel))

/*!
 * Get the value of the ReturnDataControl field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetReturnDataControlString. See @ref
 * GED_PSEUDO_FIELD_ReturnDataControl for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      ReturnDataControl's enumeration if the field is valid, GED_RETURN_DATA_CONTROL_INVALID otherwise.
 */
extern GED_RETURN_DATA_CONTROL GED_CALLCONV _GED_GetReturnDataControl(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                      GED_RETURN_VALUE* result);
#define GED_GetReturnDataControl(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetReturnDataControl(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetReturnDataControl(msgDesc, modelId, result))

/*!
 * Set the value of the ReturnDataControl field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_ReturnDataControl for the field's description.
 *
 * @param[in,out]   msgDesc            The message descriptor.
 * @param[in]       modelId            The GED model by which to interpret.
 * @param[in]       returnDataControl  The return data control.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetReturnDataControl(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                               GED_RETURN_DATA_CONTROL returnDataControl);
#define GED_SetReturnDataControl(msgDesc, modelId, returnDataControl) ( \
    GED_TraceAPI("GED_SetReturnDataControl(" #msgDesc ", " #modelId ", " #returnDataControl ")"), \
    _GED_SetReturnDataControl(msgDesc, modelId, returnDataControl))

/*!
 * Get the value of the AtomicOperationType field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetAtomicOperationTypeString. See @ref
 * GED_PSEUDO_FIELD_AtomicOperationType for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      AtomicOperationType's enumeration if the field is valid, GED_ATOMIC_OPERATION_TYPE_INVALID otherwise.
 */
extern GED_ATOMIC_OPERATION_TYPE GED_CALLCONV _GED_GetAtomicOperationType(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                          GED_RETURN_VALUE* result);
#define GED_GetAtomicOperationType(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetAtomicOperationType(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetAtomicOperationType(msgDesc, modelId, result))

/*!
 * Set the value of the AtomicOperationType field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_AtomicOperationType for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       operationType  The atomic operation type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetAtomicOperationType(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                                 GED_ATOMIC_OPERATION_TYPE operationType);
#define GED_SetAtomicOperationType(msgDesc, modelId, operationType) ( \
    GED_TraceAPI("GED_SetAtomicOperationType(" #msgDesc ", " #modelId ", " #operationType ")"), \
    _GED_SetAtomicOperationType(msgDesc, modelId, operationType))

/*!
 * Get the value of the AtomicCounterOperationType field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetAtomicOperationTypeString.
 * See @ref GED_PSEUDO_FIELD_AtomicCounterOperationType for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      AtomicCounterOperationType's enumeration if the field is valid, GED_ATOMIC_OPERATION_TYPE_INVALID otherwise.
 */
extern GED_ATOMIC_OPERATION_TYPE GED_CALLCONV _GED_GetAtomicCounterOperationType(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                                 GED_RETURN_VALUE* result);
#define GED_GetAtomicCounterOperationType(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetAtomicCounterOperationType(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetAtomicCounterOperationType(msgDesc, modelId, result))

/*!
 * Set the value of the AtomicCounterOperationType field in the given message descriptor. The latter can then be set to its
 * appropriate field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_AtomicCounterOperationType for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       operationType  The atomic counter operation type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetAtomicCounterOperationType(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                                        GED_ATOMIC_OPERATION_TYPE operationType);
#define GED_SetAtomicCounterOperationType(msgDesc, modelId, operationType) ( \
    GED_TraceAPI("GED_SetAtomicCounterOperationType(" #msgDesc ", " #modelId ", " #operationType ")"), \
    _GED_SetAtomicCounterOperationType(msgDesc, modelId, operationType))

/*!
 * Get the value of the SubFuncID field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetSubFuncIDString. See @ref
 * GED_PSEUDO_FIELD_SubFuncID for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      SubFuncID's enumeration if the field is valid, GED_SUB_FUNC_ID_INVALID otherwise.
 */
extern GED_SUB_FUNC_ID GED_CALLCONV _GED_GetSubFuncID(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetSubFuncID(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetSubFuncID(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetSubFuncID(msgDesc, modelId, result))

/*!
 * Set the value of the SubFuncID field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_SubFuncID for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       subFuncID  The sub function.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetSubFuncID(uint32_t* msgDesc, const GED_MODEL modelId, const GED_SUB_FUNC_ID subFuncID);
#define GED_SetSubFuncID(msgDesc, modelId, subFuncID) ( \
    GED_TraceAPI("GED_SetSubFuncID(" #msgDesc ", " #modelId ", " #subFuncID ")"), \
    _GED_SetSubFuncID(msgDesc, modelId, subFuncID))

/*!
 * Get the value of the BindingTableIndex field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_BindingTableIndex for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The binding table index if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetBindingTableIndex(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetBindingTableIndex(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetBindingTableIndex(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetBindingTableIndex(msgDesc, modelId, result))

/*!
 * Set the value of the BindingTableIndex field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_BindingTableIndex for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       bti        The binding table index.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetBindingTableIndex(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t bti);
#define GED_SetBindingTableIndex(msgDesc, modelId, bti) ( \
    GED_TraceAPI("GED_SetBindingTableIndex(" #msgDesc ", " #modelId ", " #bti ")"), \
    _GED_SetBindingTableIndex(msgDesc, modelId, bti))

/*!
 * Get the value of the FuncControl field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_FuncControl for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The function control if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetFuncControl(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetFuncControl(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetFuncControl(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetFuncControl(msgDesc, modelId, result))

/*!
 * Set the value of the FuncControl field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_FuncControl for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       fc         The function control.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetFuncControl(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t fc);
#define GED_SetFuncControl(msgDesc, modelId, fc) ( \
    GED_TraceAPI("GED_SetFuncControl(" #msgDesc ", " #modelId ", " #fc ")"), \
    _GED_SetFuncControl(msgDesc, modelId, fc))

/*!
 * Get the value of the MessageTypeDP_DC1 field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DC1 for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC1's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_DC1(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                               result);
#define GED_GetMessageTypeDP_DC1(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_DC1(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_DC1(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_DC1 field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC1 for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port data cache 1 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_DC1(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                               messageType);
#define GED_SetMessageTypeDP_DC1(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_DC1(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_DC1(msgDesc, modelId, messageType))

/*!
 * Get the value of the MessageTypeDP0Category field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP0Category for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The category of the data cache data port 0 message if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetMessageTypeDP0Category(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                            result);
#define GED_GetMessageTypeDP0Category(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP0Category(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP0Category(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP0Category field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP0Category for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       category   The category of the data cache data port 0 message.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP0Category(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t
                                                                    category);
#define GED_SetMessageTypeDP0Category(msgDesc, modelId, category) ( \
    GED_TraceAPI("GED_SetMessageTypeDP0Category(" #msgDesc ", " #modelId ", " #category ")"), \
    _GED_SetMessageTypeDP0Category(msgDesc, modelId, category))

/*!
 * Get the value of the MessageTypeDP_DC0Legacy field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The
 * function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See
 * @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0Legacy for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC0Legacy's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_DC0Legacy(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                     GED_RETURN_VALUE* result);
#define GED_GetMessageTypeDP_DC0Legacy(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_DC0Legacy(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_DC0Legacy(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_DC0Legacy field in the given message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0Legacy for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port data cache 0 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_DC0Legacy(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                                     GED_MESSAGE_TYPE messageType);
#define GED_SetMessageTypeDP_DC0Legacy(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_DC0Legacy(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_DC0Legacy(msgDesc, modelId, messageType))

/*!
 * Get the value of the MessageTypeDP_DC0ScratchBlock field from the given message descriptor (as obtained by @ref GED_GetMsgDesc).
 * The function returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See
 * @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0ScratchBlock for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC0ScratchBlock's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_DC0ScratchBlock(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                           GED_RETURN_VALUE* result);
#define GED_GetMessageTypeDP_DC0ScratchBlock(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_DC0ScratchBlock(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_DC0ScratchBlock(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_DC0ScratchBlock field in the given message descriptor. The latter can then be set to its
 * appropriate field (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC0ScratchBlock for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port data cache 0 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_DC0ScratchBlock(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                                           GED_MESSAGE_TYPE messageType);
#define GED_SetMessageTypeDP_DC0ScratchBlock(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_DC0ScratchBlock(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_DC0ScratchBlock(msgDesc, modelId, messageType))

/*!
 * Get the value of the MessageTypeDP_DC2 field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DC2 for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DC2's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_DC2(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                               result);
#define GED_GetMessageTypeDP_DC2(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_DC2(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_DC2(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_DC2 field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DC2 for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port data cache 2 message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_DC2(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                               messageType);
#define GED_SetMessageTypeDP_DC2(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_DC2(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_DC2(msgDesc, modelId, messageType))

/*!
 * Get the value of the MessageTypeDP_DCRO field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetMessageTypeString. See @ref
 * GED_PSEUDO_FIELD_MessageTypeDP_DCRO for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      MessageTypeDP_DCRO's enumeration if the field is valid, GED_MESSAGE_TYPE_INVALID otherwise.
 */
extern GED_MESSAGE_TYPE GED_CALLCONV _GED_GetMessageTypeDP_DCRO(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                                result);
#define GED_GetMessageTypeDP_DCRO(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetMessageTypeDP_DCRO(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetMessageTypeDP_DCRO(msgDesc, modelId, result))

/*!
 * Set the value of the MessageTypeDP_DCRO field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_MessageTypeDP_DCRO for the field's description.
 *
 * @param[in,out]   msgDesc        The message descriptor.
 * @param[in]       modelId        The GED model by which to interpret.
 * @param[in]       messageType    The data port read only message type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetMessageTypeDP_DCRO(uint32_t* msgDesc, const GED_MODEL modelId, const GED_MESSAGE_TYPE
                                                                messageType);
#define GED_SetMessageTypeDP_DCRO(msgDesc, modelId, messageType) ( \
    GED_TraceAPI("GED_SetMessageTypeDP_DCRO(" #msgDesc ", " #modelId ", " #messageType ")"), \
    _GED_SetMessageTypeDP_DCRO(msgDesc, modelId, messageType))

/*!
 * Get the value of the ExMessageLength field from the given extended message descriptor (as obtained by @ref GED_GetExMsgDescImm).
 * See @ref GED_PSEUDO_FIELD_ExMessageLength for the field's description.
 *
 * @param[in]       exMsgDesc  The extended message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The exmessage length if the field is valid, the unchanged exMsgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetExMessageLength(const uint32_t exMsgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetExMessageLength(exMsgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetExMessageLength(" #exMsgDesc ", " #modelId ", " #result ")"), \
    _GED_GetExMessageLength(exMsgDesc, modelId, result))

/*!
 * Set the value of the ExMessageLength field in the given extended message descriptor. The latter can then be set to its appropriate
 * field (@ref GED_SetExMsgDescImm). See @ref GED_PSEUDO_FIELD_ExMessageLength for the field's description.
 *
 * @param[in,out]   exMsgDesc  The extended message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       length     The exmessage length.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetExMessageLength(uint32_t* exMsgDesc, const GED_MODEL modelId, const uint32_t length);
#define GED_SetExMessageLength(exMsgDesc, modelId, length) ( \
    GED_TraceAPI("GED_SetExMessageLength(" #exMsgDesc ", " #modelId ", " #length ")"), \
    _GED_SetExMessageLength(exMsgDesc, modelId, length))

/*!
 * Get the value of the DPOpcode field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns an
 * enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpOpcodeString. See @ref
 * GED_PSEUDO_FIELD_DPOpcode for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPOpcode's enumeration if the field is valid, GED_DP_OPCODE_INVALID otherwise.
 */
extern GED_DP_OPCODE GED_CALLCONV _GED_GetDPOpcode(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetDPOpcode(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPOpcode(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPOpcode(msgDesc, modelId, result))

/*!
 * Set the value of the DPOpcode field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPOpcode for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       opcode     The DP operation.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPOpcode(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_OPCODE opcode);
#define GED_SetDPOpcode(msgDesc, modelId, opcode) ( \
    GED_TraceAPI("GED_SetDPOpcode(" #msgDesc ", " #modelId ", " #opcode ")"), \
    _GED_SetDPOpcode(msgDesc, modelId, opcode))

/*!
 * Get the value of the DPAddrSurfaceType field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpAddrSurfaceTypeString. See @ref
 * GED_PSEUDO_FIELD_DPAddrSurfaceType for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPAddrSurfaceType's enumeration if the field is valid, GED_DP_ADDR_SURFACE_TYPE_INVALID otherwise.
 */
extern GED_DP_ADDR_SURFACE_TYPE GED_CALLCONV _GED_GetDPAddrSurfaceType(const uint32_t msgDesc, const GED_MODEL modelId,
                                                                       GED_RETURN_VALUE* result);
#define GED_GetDPAddrSurfaceType(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPAddrSurfaceType(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPAddrSurfaceType(msgDesc, modelId, result))

/*!
 * Set the value of the DPAddrSurfaceType field in the given message descriptor. The latter can then be set to its appropriate field
 * (@ref GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPAddrSurfaceType for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       AddrType   The DP addr surface type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPAddrSurfaceType(uint32_t* msgDesc, const GED_MODEL modelId, const
                                                               GED_DP_ADDR_SURFACE_TYPE AddrType);
#define GED_SetDPAddrSurfaceType(msgDesc, modelId, AddrType) ( \
    GED_TraceAPI("GED_SetDPAddrSurfaceType(" #msgDesc ", " #modelId ", " #AddrType ")"), \
    _GED_SetDPAddrSurfaceType(msgDesc, modelId, AddrType))

/*!
 * Get the value of the DPVectSize field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpVectSizeString. See @ref
 * GED_PSEUDO_FIELD_DPVectSize for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPVectSize's enumeration if the field is valid, GED_DP_VECT_SIZE_INVALID otherwise.
 */
extern GED_DP_VECT_SIZE GED_CALLCONV _GED_GetDPVectSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetDPVectSize(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPVectSize(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPVectSize(msgDesc, modelId, result))

/*!
 * Set the value of the DPVectSize field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPVectSize for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       VectSize   The DP vector size.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPVectSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_VECT_SIZE VectSize);
#define GED_SetDPVectSize(msgDesc, modelId, VectSize) ( \
    GED_TraceAPI("GED_SetDPVectSize(" #msgDesc ", " #modelId ", " #VectSize ")"), \
    _GED_SetDPVectSize(msgDesc, modelId, VectSize))

/*!
 * Get the value of the DPFlushType field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpFlushTypeString. See @ref
 * GED_PSEUDO_FIELD_DPFlushType for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPFlushType's enumeration if the field is valid, GED_DP_FLUSH_TYPE_INVALID otherwise.
 */
extern GED_DP_FLUSH_TYPE GED_CALLCONV _GED_GetDPFlushType(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetDPFlushType(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPFlushType(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPFlushType(msgDesc, modelId, result))

/*!
 * Set the value of the DPFlushType field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPFlushType for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       FlushType  The DP flush type.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPFlushType(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_FLUSH_TYPE
                                                         FlushType);
#define GED_SetDPFlushType(msgDesc, modelId, FlushType) ( \
    GED_TraceAPI("GED_SetDPFlushType(" #msgDesc ", " #modelId ", " #FlushType ")"), \
    _GED_SetDPFlushType(msgDesc, modelId, FlushType))

/*!
 * Get the value of the DPTranspose field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpTransposeString. See @ref
 * GED_PSEUDO_FIELD_DPTranspose for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPTranspose's enumeration if the field is valid, GED_DP_TRANSPOSE_INVALID otherwise.
 */
extern GED_DP_TRANSPOSE GED_CALLCONV _GED_GetDPTranspose(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetDPTranspose(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPTranspose(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPTranspose(msgDesc, modelId, result))

/*!
 * Set the value of the DPTranspose field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPTranspose for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       Transpose  The DP transpose.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPTranspose(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_TRANSPOSE
                                                         Transpose);
#define GED_SetDPTranspose(msgDesc, modelId, Transpose) ( \
    GED_TraceAPI("GED_SetDPTranspose(" #msgDesc ", " #modelId ", " #Transpose ")"), \
    _GED_SetDPTranspose(msgDesc, modelId, Transpose))

/*!
 * Get the value of the DPFlushRange field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). See @ref
 * GED_PSEUDO_FIELD_DPFlushRange for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The flush range if the field is valid, the unchanged msgDesc value otherwise.
 */
extern uint32_t GED_CALLCONV _GED_GetDPFlushRange(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetDPFlushRange(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPFlushRange(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPFlushRange(msgDesc, modelId, result))

/*!
 * Set the value of the DPFlushRange field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPFlushRange for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       range      The flush range.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPFlushRange(uint32_t* msgDesc, const GED_MODEL modelId, const uint32_t range);
#define GED_SetDPFlushRange(msgDesc, modelId, range) ( \
    GED_TraceAPI("GED_SetDPFlushRange(" #msgDesc ", " #modelId ", " #range ")"), \
    _GED_SetDPFlushRange(msgDesc, modelId, range))

/*!
 * Get the value of the DPDataSize field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpDataSizeString. See @ref
 * GED_PSEUDO_FIELD_DPDataSize for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPDataSize's enumeration if the field is valid, GED_DP_DATA_SIZE_INVALID otherwise.
 */
extern GED_DP_DATA_SIZE GED_CALLCONV _GED_GetDPDataSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetDPDataSize(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPDataSize(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPDataSize(msgDesc, modelId, result))

/*!
 * Set the value of the DPDataSize field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPDataSize for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       DataSize   The DP data size.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPDataSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_DATA_SIZE DataSize);
#define GED_SetDPDataSize(msgDesc, modelId, DataSize) ( \
    GED_TraceAPI("GED_SetDPDataSize(" #msgDesc ", " #modelId ", " #DataSize ")"), \
    _GED_SetDPDataSize(msgDesc, modelId, DataSize))

/*!
 * Get the value of the DPFenceScope field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function
 * returns an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpFenceScopeString. See @ref
 * GED_PSEUDO_FIELD_DPFenceScope for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPFenceScope's enumeration if the field is valid, GED_DP_FENCE_SCOPE_INVALID otherwise.
 */
extern GED_DP_FENCE_SCOPE GED_CALLCONV _GED_GetDPFenceScope(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                            result);
#define GED_GetDPFenceScope(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPFenceScope(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPFenceScope(msgDesc, modelId, result))

/*!
 * Set the value of the DPFenceScope field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPFenceScope for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       FenceScope The DP fence scope.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPFenceScope(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_FENCE_SCOPE
                                                          FenceScope);
#define GED_SetDPFenceScope(msgDesc, modelId, FenceScope) ( \
    GED_TraceAPI("GED_SetDPFenceScope(" #msgDesc ", " #modelId ", " #FenceScope ")"), \
    _GED_SetDPFenceScope(msgDesc, modelId, FenceScope))

/*!
 * Get the value of the DPAddrSize field from the given message descriptor (as obtained by @ref GED_GetMsgDesc). The function returns
 * an enumeration value. To obtain the enum entry's string representation, use @ref GED_GetDpAddrSizeString. See @ref
 * GED_PSEUDO_FIELD_DPAddrSize for the field's description.
 *
 * @param[in]       msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      DPAddrSize's enumeration if the field is valid, GED_DP_ADDR_SIZE_INVALID otherwise.
 */
extern GED_DP_ADDR_SIZE GED_CALLCONV _GED_GetDPAddrSize(const uint32_t msgDesc, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetDPAddrSize(msgDesc, modelId, result) ( \
    GED_TraceAPI("GED_GetDPAddrSize(" #msgDesc ", " #modelId ", " #result ")"), \
    _GED_GetDPAddrSize(msgDesc, modelId, result))

/*!
 * Set the value of the DPAddrSize field in the given message descriptor. The latter can then be set to its appropriate field (@ref
 * GED_SetMsgDesc). See @ref GED_PSEUDO_FIELD_DPAddrSize for the field's description.
 *
 * @param[in,out]   msgDesc    The message descriptor.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[in]       AddrSize   The DP address size.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetDPAddrSize(uint32_t* msgDesc, const GED_MODEL modelId, const GED_DP_ADDR_SIZE AddrSize);
#define GED_SetDPAddrSize(msgDesc, modelId, AddrSize) ( \
    GED_TraceAPI("GED_SetDPAddrSize(" #msgDesc ", " #modelId ", " #AddrSize ")"), \
    _GED_SetDPAddrSize(msgDesc, modelId, AddrSize))

#if GED_EXPERIMENTAL

/*!
 * Set specific raw bits in native instruction, ignoring value restrictions and encoding masks
 *
 * @param[in]       ins    Pointer to the instruction object containing the field in question.
 * @param[in]       low    First bit of the area in the instruction asked to modify.
 * @param[in]       high   Last bit of the area in the instruction asked to modify.
 * @param[in]       value  The value to encode.
 *
 * @return      GED_RETURN_VALUE indicating success or encoding error.
 *
 * @note        Calling this function prevents the application of encoding masks when calling @ref GED_EncodeIns
 */
extern GED_RETURN_VALUE GED_CALLCONV _GED_SetRawBits(ged_ins_t* ins, uint8_t low, uint8_t high, const uint64_t value);
#define GED_SetRawBits(ins, low, high, value) ( \
    GED_TraceAPI("GED_SetRawBits(" #ins ", " #low ", " #high ", " #value ")"), \
    _GED_SetRawBits(ins, low, high, value))
#endif // GED_EXPERIMENTAL

/*!
 * Get the string representation for the given GED_ACCESS_MODE enumerator. The function returns a NULL pointer for
 * GED_ACCESS_MODE_INVALID.
 *
 * @param[in]       AccessModeValue    The given GED_ACCESS_MODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetAccessModeString(GED_ACCESS_MODE AccessModeValue);
#define GED_GetAccessModeString(AccessModeValue) ( \
    GED_TraceAPI("GED_GetAccessModeString(" #AccessModeValue ")"), \
    _GED_GetAccessModeString(AccessModeValue))

/*!
 * Get the string representation for the given GED_ACC_WR_CTRL enumerator. The function returns a NULL pointer for
 * GED_ACC_WR_CTRL_INVALID.
 *
 * @param[in]       AccWrCtrlValue The given GED_ACC_WR_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetAccWrCtrlString(GED_ACC_WR_CTRL AccWrCtrlValue);
#define GED_GetAccWrCtrlString(AccWrCtrlValue) ( \
    GED_TraceAPI("GED_GetAccWrCtrlString(" #AccWrCtrlValue ")"), \
    _GED_GetAccWrCtrlString(AccWrCtrlValue))

/*!
 * Get the string representation for the given GED_ADDR_MODE enumerator. The function returns a NULL pointer for
 * GED_ADDR_MODE_INVALID.
 *
 * @param[in]       AddrModeValue  The given GED_ADDR_MODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetAddrModeString(GED_ADDR_MODE AddrModeValue);
#define GED_GetAddrModeString(AddrModeValue) ( \
    GED_TraceAPI("GED_GetAddrModeString(" #AddrModeValue ")"), \
    _GED_GetAddrModeString(AddrModeValue))

/*!
 * Get the string representation for the given GED_ARCH_REG enumerator. The function returns a NULL pointer for GED_ARCH_REG_INVALID.
 *
 * @param[in]       ArchRegValue   The given GED_ARCH_REG enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetArchRegString(GED_ARCH_REG ArchRegValue);
#define GED_GetArchRegString(ArchRegValue) ( \
    GED_TraceAPI("GED_GetArchRegString(" #ArchRegValue ")"), \
    _GED_GetArchRegString(ArchRegValue))

/*!
 * Get the string representation for the given GED_ATOMIC_OPERATION_TYPE enumerator. The function returns a NULL pointer for
 * GED_ATOMIC_OPERATION_TYPE_INVALID.
 *
 * @param[in]       AtomicOperationTypeValue   The given GED_ATOMIC_OPERATION_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetAtomicOperationTypeString(GED_ATOMIC_OPERATION_TYPE AtomicOperationTypeValue);
#define GED_GetAtomicOperationTypeString(AtomicOperationTypeValue) ( \
    GED_TraceAPI("GED_GetAtomicOperationTypeString(" #AtomicOperationTypeValue ")"), \
    _GED_GetAtomicOperationTypeString(AtomicOperationTypeValue))

/*!
 * Get the string representation for the given GED_BLOCK_SIZE enumerator. The function returns a NULL pointer for
 * GED_BLOCK_SIZE_INVALID.
 *
 * @param[in]       BlockSizeValue The given GED_BLOCK_SIZE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetBlockSizeString(GED_BLOCK_SIZE BlockSizeValue);
#define GED_GetBlockSizeString(BlockSizeValue) ( \
    GED_TraceAPI("GED_GetBlockSizeString(" #BlockSizeValue ")"), \
    _GED_GetBlockSizeString(BlockSizeValue))

/*!
 * Get the string representation for the given GED_BRANCH_CTRL enumerator. The function returns a NULL pointer for
 * GED_BRANCH_CTRL_INVALID.
 *
 * @param[in]       BranchCtrlValue    The given GED_BRANCH_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetBranchCtrlString(GED_BRANCH_CTRL BranchCtrlValue);
#define GED_GetBranchCtrlString(BranchCtrlValue) ( \
    GED_TraceAPI("GED_GetBranchCtrlString(" #BranchCtrlValue ")"), \
    _GED_GetBranchCtrlString(BranchCtrlValue))

/*!
 * Get the string representation for the given GED_CHANNEL_MASK enumerator. The function returns a NULL pointer for
 * GED_CHANNEL_MASK_INVALID.
 *
 * @param[in]       ChannelMaskValue   The given GED_CHANNEL_MASK enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetChannelMaskString(GED_CHANNEL_MASK ChannelMaskValue);
#define GED_GetChannelMaskString(ChannelMaskValue) ( \
    GED_TraceAPI("GED_GetChannelMaskString(" #ChannelMaskValue ")"), \
    _GED_GetChannelMaskString(ChannelMaskValue))

/*!
 * Get the string representation for the given GED_CHANNEL_MODE enumerator. The function returns a NULL pointer for
 * GED_CHANNEL_MODE_INVALID.
 *
 * @param[in]       ChannelModeValue   The given GED_CHANNEL_MODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetChannelModeString(GED_CHANNEL_MODE ChannelModeValue);
#define GED_GetChannelModeString(ChannelModeValue) ( \
    GED_TraceAPI("GED_GetChannelModeString(" #ChannelModeValue ")"), \
    _GED_GetChannelModeString(ChannelModeValue))

/*!
 * Get the string representation for the given GED_CHANNEL_OFFSET enumerator. The function returns a NULL pointer for
 * GED_CHANNEL_OFFSET_INVALID.
 *
 * @param[in]       ChannelOffsetValue The given GED_CHANNEL_OFFSET enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetChannelOffsetString(GED_CHANNEL_OFFSET ChannelOffsetValue);
#define GED_GetChannelOffsetString(ChannelOffsetValue) ( \
    GED_TraceAPI("GED_GetChannelOffsetString(" #ChannelOffsetValue ")"), \
    _GED_GetChannelOffsetString(ChannelOffsetValue))

/*!
 * Get the string representation for the given GED_COND_MODIFIER enumerator. The function returns a NULL pointer for
 * GED_COND_MODIFIER_INVALID.
 *
 * @param[in]       CondModifierValue  The given GED_COND_MODIFIER enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetCondModifierString(GED_COND_MODIFIER CondModifierValue);
#define GED_GetCondModifierString(CondModifierValue) ( \
    GED_TraceAPI("GED_GetCondModifierString(" #CondModifierValue ")"), \
    _GED_GetCondModifierString(CondModifierValue))

/*!
 * Get the string representation for the given GED_DATA_TYPE enumerator. The function returns a NULL pointer for
 * GED_DATA_TYPE_INVALID.
 *
 * @param[in]       DataTypeValue  The given GED_DATA_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDataTypeString(GED_DATA_TYPE DataTypeValue);
#define GED_GetDataTypeString(DataTypeValue) ( \
    GED_TraceAPI("GED_GetDataTypeString(" #DataTypeValue ")"), \
    _GED_GetDataTypeString(DataTypeValue))

/*!
 * Get the string representation for the given GED_DEBUG_CTRL enumerator. The function returns a NULL pointer for
 * GED_DEBUG_CTRL_INVALID.
 *
 * @param[in]       DebugCtrlValue The given GED_DEBUG_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDebugCtrlString(GED_DEBUG_CTRL DebugCtrlValue);
#define GED_GetDebugCtrlString(DebugCtrlValue) ( \
    GED_TraceAPI("GED_GetDebugCtrlString(" #DebugCtrlValue ")"), \
    _GED_GetDebugCtrlString(DebugCtrlValue))

/*!
 * Get the string representation for the given GED_DEP_CTRL enumerator. The function returns a NULL pointer for GED_DEP_CTRL_INVALID.
 *
 * @param[in]       DepCtrlValue   The given GED_DEP_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDepCtrlString(GED_DEP_CTRL DepCtrlValue);
#define GED_GetDepCtrlString(DepCtrlValue) ( \
    GED_TraceAPI("GED_GetDepCtrlString(" #DepCtrlValue ")"), \
    _GED_GetDepCtrlString(DepCtrlValue))

/*!
 * Get the string representation for the given GED_DP_ADDR_SIZE enumerator. The function returns a NULL pointer for
 * GED_DP_ADDR_SIZE_INVALID.
 *
 * @param[in]       DpAddrSizeValue    The given GED_DP_ADDR_SIZE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpAddrSizeString(GED_DP_ADDR_SIZE DpAddrSizeValue);
#define GED_GetDpAddrSizeString(DpAddrSizeValue) ( \
    GED_TraceAPI("GED_GetDpAddrSizeString(" #DpAddrSizeValue ")"), \
    _GED_GetDpAddrSizeString(DpAddrSizeValue))

/*!
 * Get the string representation for the given GED_DP_ADDR_SURFACE_TYPE enumerator. The function returns a NULL pointer for
 * GED_DP_ADDR_SURFACE_TYPE_INVALID.
 *
 * @param[in]       DpAddrSurfaceTypeValue The given GED_DP_ADDR_SURFACE_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpAddrSurfaceTypeString(GED_DP_ADDR_SURFACE_TYPE DpAddrSurfaceTypeValue);
#define GED_GetDpAddrSurfaceTypeString(DpAddrSurfaceTypeValue) ( \
    GED_TraceAPI("GED_GetDpAddrSurfaceTypeString(" #DpAddrSurfaceTypeValue ")"), \
    _GED_GetDpAddrSurfaceTypeString(DpAddrSurfaceTypeValue))

/*!
 * Get the string representation for the given GED_DP_DATA_SIZE enumerator. The function returns a NULL pointer for
 * GED_DP_DATA_SIZE_INVALID.
 *
 * @param[in]       DpDataSizeValue    The given GED_DP_DATA_SIZE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpDataSizeString(GED_DP_DATA_SIZE DpDataSizeValue);
#define GED_GetDpDataSizeString(DpDataSizeValue) ( \
    GED_TraceAPI("GED_GetDpDataSizeString(" #DpDataSizeValue ")"), \
    _GED_GetDpDataSizeString(DpDataSizeValue))

/*!
 * Get the string representation for the given GED_DP_FENCE_SCOPE enumerator. The function returns a NULL pointer for
 * GED_DP_FENCE_SCOPE_INVALID.
 *
 * @param[in]       DpFenceScopeValue  The given GED_DP_FENCE_SCOPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpFenceScopeString(GED_DP_FENCE_SCOPE DpFenceScopeValue);
#define GED_GetDpFenceScopeString(DpFenceScopeValue) ( \
    GED_TraceAPI("GED_GetDpFenceScopeString(" #DpFenceScopeValue ")"), \
    _GED_GetDpFenceScopeString(DpFenceScopeValue))

/*!
 * Get the string representation for the given GED_DP_FLUSH_TYPE enumerator. The function returns a NULL pointer for
 * GED_DP_FLUSH_TYPE_INVALID.
 *
 * @param[in]       DpFlushTypeValue   The given GED_DP_FLUSH_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpFlushTypeString(GED_DP_FLUSH_TYPE DpFlushTypeValue);
#define GED_GetDpFlushTypeString(DpFlushTypeValue) ( \
    GED_TraceAPI("GED_GetDpFlushTypeString(" #DpFlushTypeValue ")"), \
    _GED_GetDpFlushTypeString(DpFlushTypeValue))

/*!
 * Get the string representation for the given GED_DP_OPCODE enumerator. The function returns a NULL pointer for
 * GED_DP_OPCODE_INVALID.
 *
 * @param[in]       DpOpcodeValue  The given GED_DP_OPCODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpOpcodeString(GED_DP_OPCODE DpOpcodeValue);
#define GED_GetDpOpcodeString(DpOpcodeValue) ( \
    GED_TraceAPI("GED_GetDpOpcodeString(" #DpOpcodeValue ")"), \
    _GED_GetDpOpcodeString(DpOpcodeValue))

/*!
 * Get the string representation for the given GED_DP_TRANSPOSE enumerator. The function returns a NULL pointer for
 * GED_DP_TRANSPOSE_INVALID.
 *
 * @param[in]       DpTransposeValue   The given GED_DP_TRANSPOSE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpTransposeString(GED_DP_TRANSPOSE DpTransposeValue);
#define GED_GetDpTransposeString(DpTransposeValue) ( \
    GED_TraceAPI("GED_GetDpTransposeString(" #DpTransposeValue ")"), \
    _GED_GetDpTransposeString(DpTransposeValue))

/*!
 * Get the string representation for the given GED_DP_VECT_SIZE enumerator. The function returns a NULL pointer for
 * GED_DP_VECT_SIZE_INVALID.
 *
 * @param[in]       DpVectSizeValue    The given GED_DP_VECT_SIZE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDpVectSizeString(GED_DP_VECT_SIZE DpVectSizeValue);
#define GED_GetDpVectSizeString(DpVectSizeValue) ( \
    GED_TraceAPI("GED_GetDpVectSizeString(" #DpVectSizeValue ")"), \
    _GED_GetDpVectSizeString(DpVectSizeValue))

/*!
 * Get the string representation for the given GED_DST_CHAN_EN enumerator. The function returns a NULL pointer for
 * GED_DST_CHAN_EN_INVALID.
 *
 * @param[in]       DstChanEnValue The given GED_DST_CHAN_EN enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetDstChanEnString(GED_DST_CHAN_EN DstChanEnValue);
#define GED_GetDstChanEnString(DstChanEnValue) ( \
    GED_TraceAPI("GED_GetDstChanEnString(" #DstChanEnValue ")"), \
    _GED_GetDstChanEnString(DstChanEnValue))

/*!
 * Get the string representation for the given GED_EOT enumerator. The function returns a NULL pointer for GED_EOT_INVALID.
 *
 * @param[in]       EOTValue   The given GED_EOT enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetEOTString(GED_EOT EOTValue);
#define GED_GetEOTString(EOTValue) ( \
    GED_TraceAPI("GED_GetEOTString(" #EOTValue ")"), \
    _GED_GetEOTString(EOTValue))

/*!
 * Get the string representation for the given GED_EXEC_MASK_OFFSET_CTRL enumerator. The function returns a NULL pointer for
 * GED_EXEC_MASK_OFFSET_CTRL_INVALID.
 *
 * @param[in]       ExecMaskOffsetCtrlValue    The given GED_EXEC_MASK_OFFSET_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetExecMaskOffsetCtrlString(GED_EXEC_MASK_OFFSET_CTRL ExecMaskOffsetCtrlValue);
#define GED_GetExecMaskOffsetCtrlString(ExecMaskOffsetCtrlValue) ( \
    GED_TraceAPI("GED_GetExecMaskOffsetCtrlString(" #ExecMaskOffsetCtrlValue ")"), \
    _GED_GetExecMaskOffsetCtrlString(ExecMaskOffsetCtrlValue))

/*!
 * Get the string representation for the given GED_EXECUTION_DATA_TYPE enumerator. The function returns a NULL pointer for
 * GED_EXECUTION_DATA_TYPE_INVALID.
 *
 * @param[in]       ExecutionDataTypeValue The given GED_EXECUTION_DATA_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetExecutionDataTypeString(GED_EXECUTION_DATA_TYPE ExecutionDataTypeValue);
#define GED_GetExecutionDataTypeString(ExecutionDataTypeValue) ( \
    GED_TraceAPI("GED_GetExecutionDataTypeString(" #ExecutionDataTypeValue ")"), \
    _GED_GetExecutionDataTypeString(ExecutionDataTypeValue))

/*!
 * Get the string representation for the given GED_FUSION_CTRL enumerator. The function returns a NULL pointer for
 * GED_FUSION_CTRL_INVALID.
 *
 * @param[in]       FusionCtrlValue    The given GED_FUSION_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetFusionCtrlString(GED_FUSION_CTRL FusionCtrlValue);
#define GED_GetFusionCtrlString(FusionCtrlValue) ( \
    GED_TraceAPI("GED_GetFusionCtrlString(" #FusionCtrlValue ")"), \
    _GED_GetFusionCtrlString(FusionCtrlValue))

/*!
 * Get the string representation for the given GED_HEADER_PRESENT enumerator. The function returns a NULL pointer for
 * GED_HEADER_PRESENT_INVALID.
 *
 * @param[in]       HeaderPresentValue The given GED_HEADER_PRESENT enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetHeaderPresentString(GED_HEADER_PRESENT HeaderPresentValue);
#define GED_GetHeaderPresentString(HeaderPresentValue) ( \
    GED_TraceAPI("GED_GetHeaderPresentString(" #HeaderPresentValue ")"), \
    _GED_GetHeaderPresentString(HeaderPresentValue))

/*!
 * Get the string representation for the given GED_MASK_CTRL enumerator. The function returns a NULL pointer for
 * GED_MASK_CTRL_INVALID.
 *
 * @param[in]       MaskCtrlValue  The given GED_MASK_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetMaskCtrlString(GED_MASK_CTRL MaskCtrlValue);
#define GED_GetMaskCtrlString(MaskCtrlValue) ( \
    GED_TraceAPI("GED_GetMaskCtrlString(" #MaskCtrlValue ")"), \
    _GED_GetMaskCtrlString(MaskCtrlValue))

/*!
 * Get the string representation for the given GED_MATH_FC enumerator. The function returns a NULL pointer for GED_MATH_FC_INVALID.
 *
 * @param[in]       MathFCValue    The given GED_MATH_FC enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetMathFCString(GED_MATH_FC MathFCValue);
#define GED_GetMathFCString(MathFCValue) ( \
    GED_TraceAPI("GED_GetMathFCString(" #MathFCValue ")"), \
    _GED_GetMathFCString(MathFCValue))

/*!
 * Get the string representation for the given GED_MATH_MACRO_EXT enumerator. The function returns a NULL pointer for
 * GED_MATH_MACRO_EXT_INVALID.
 *
 * @param[in]       MathMacroExtValue  The given GED_MATH_MACRO_EXT enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetMathMacroExtString(GED_MATH_MACRO_EXT MathMacroExtValue);
#define GED_GetMathMacroExtString(MathMacroExtValue) ( \
    GED_TraceAPI("GED_GetMathMacroExtString(" #MathMacroExtValue ")"), \
    _GED_GetMathMacroExtString(MathMacroExtValue))

/*!
 * Get the string representation for the given GED_MESSAGE_TYPE enumerator. The function returns a NULL pointer for
 * GED_MESSAGE_TYPE_INVALID.
 *
 * @param[in]       MessageTypeValue   The given GED_MESSAGE_TYPE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetMessageTypeString(GED_MESSAGE_TYPE MessageTypeValue);
#define GED_GetMessageTypeString(MessageTypeValue) ( \
    GED_TraceAPI("GED_GetMessageTypeString(" #MessageTypeValue ")"), \
    _GED_GetMessageTypeString(MessageTypeValue))

/*!
 * Get the string representation for the given GED_NO_SRC_DEP_SET enumerator. The function returns a NULL pointer for
 * GED_NO_SRC_DEP_SET_INVALID.
 *
 * @param[in]       NoSrcDepSetValue   The given GED_NO_SRC_DEP_SET enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetNoSrcDepSetString(GED_NO_SRC_DEP_SET NoSrcDepSetValue);
#define GED_GetNoSrcDepSetString(NoSrcDepSetValue) ( \
    GED_TraceAPI("GED_GetNoSrcDepSetString(" #NoSrcDepSetValue ")"), \
    _GED_GetNoSrcDepSetString(NoSrcDepSetValue))

/*!
 * Get the string representation for the given GED_OPCODE enumerator. The function returns a NULL pointer for GED_OPCODE_INVALID.
 *
 * @param[in]       OpcodeValue    The given GED_OPCODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetOpcodeString(GED_OPCODE OpcodeValue);
#define GED_GetOpcodeString(OpcodeValue) ( \
    GED_TraceAPI("GED_GetOpcodeString(" #OpcodeValue ")"), \
    _GED_GetOpcodeString(OpcodeValue))

/*!
 * Get the string representation for the given GED_PRECISION enumerator. The function returns a NULL pointer for
 * GED_PRECISION_INVALID.
 *
 * @param[in]       PrecisionValue The given GED_PRECISION enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetPrecisionString(GED_PRECISION PrecisionValue);
#define GED_GetPrecisionString(PrecisionValue) ( \
    GED_TraceAPI("GED_GetPrecisionString(" #PrecisionValue ")"), \
    _GED_GetPrecisionString(PrecisionValue))

/*!
 * Get the string representation for the given GED_PRED_CTRL enumerator. The function returns a NULL pointer for
 * GED_PRED_CTRL_INVALID.
 *
 * @param[in]       PredCtrlValue  The given GED_PRED_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetPredCtrlString(GED_PRED_CTRL PredCtrlValue);
#define GED_GetPredCtrlString(PredCtrlValue) ( \
    GED_TraceAPI("GED_GetPredCtrlString(" #PredCtrlValue ")"), \
    _GED_GetPredCtrlString(PredCtrlValue))

/*!
 * Get the string representation for the given GED_PRED_INV enumerator. The function returns a NULL pointer for GED_PRED_INV_INVALID.
 *
 * @param[in]       PredInvValue   The given GED_PRED_INV enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetPredInvString(GED_PRED_INV PredInvValue);
#define GED_GetPredInvString(PredInvValue) ( \
    GED_TraceAPI("GED_GetPredInvString(" #PredInvValue ")"), \
    _GED_GetPredInvString(PredInvValue))

/*!
 * Get the string representation for the given GED_REG_FILE enumerator. The function returns a NULL pointer for GED_REG_FILE_INVALID.
 *
 * @param[in]       RegFileValue   The given GED_REG_FILE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetRegFileString(GED_REG_FILE RegFileValue);
#define GED_GetRegFileString(RegFileValue) ( \
    GED_TraceAPI("GED_GetRegFileString(" #RegFileValue ")"), \
    _GED_GetRegFileString(RegFileValue))

/*!
 * Get the string representation for the given GED_REP_CTRL enumerator. The function returns a NULL pointer for GED_REP_CTRL_INVALID.
 *
 * @param[in]       RepCtrlValue   The given GED_REP_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetRepCtrlString(GED_REP_CTRL RepCtrlValue);
#define GED_GetRepCtrlString(RepCtrlValue) ( \
    GED_TraceAPI("GED_GetRepCtrlString(" #RepCtrlValue ")"), \
    _GED_GetRepCtrlString(RepCtrlValue))

/*!
 * Get the string representation for the given GED_RETURN_DATA_CONTROL enumerator. The function returns a NULL pointer for
 * GED_RETURN_DATA_CONTROL_INVALID.
 *
 * @param[in]       ReturnDataControlValue The given GED_RETURN_DATA_CONTROL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetReturnDataControlString(GED_RETURN_DATA_CONTROL ReturnDataControlValue);
#define GED_GetReturnDataControlString(ReturnDataControlValue) ( \
    GED_TraceAPI("GED_GetReturnDataControlString(" #ReturnDataControlValue ")"), \
    _GED_GetReturnDataControlString(ReturnDataControlValue))

/*!
 * Get the string representation for the given GED_SATURATE enumerator. The function returns a NULL pointer for GED_SATURATE_INVALID.
 *
 * @param[in]       SaturateValue  The given GED_SATURATE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSaturateString(GED_SATURATE SaturateValue);
#define GED_GetSaturateString(SaturateValue) ( \
    GED_TraceAPI("GED_GetSaturateString(" #SaturateValue ")"), \
    _GED_GetSaturateString(SaturateValue))

/*!
 * Get the string representation for the given GED_SFID enumerator. The function returns a NULL pointer for GED_SFID_INVALID.
 *
 * @param[in]       SFIDValue  The given GED_SFID enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSFIDString(GED_SFID SFIDValue);
#define GED_GetSFIDString(SFIDValue) ( \
    GED_TraceAPI("GED_GetSFIDString(" #SFIDValue ")"), \
    _GED_GetSFIDString(SFIDValue))

/*!
 * Get the string representation for the given GED_SIMDMODE enumerator. The function returns a NULL pointer for GED_SIMDMODE_INVALID.
 *
 * @param[in]       SIMDModeValue  The given GED_SIMDMODE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSIMDModeString(GED_SIMDMODE SIMDModeValue);
#define GED_GetSIMDModeString(SIMDModeValue) ( \
    GED_TraceAPI("GED_GetSIMDModeString(" #SIMDModeValue ")"), \
    _GED_GetSIMDModeString(SIMDModeValue))

/*!
 * Get the string representation for the given GED_SLOT_GROUP enumerator. The function returns a NULL pointer for
 * GED_SLOT_GROUP_INVALID.
 *
 * @param[in]       SlotGroupValue The given GED_SLOT_GROUP enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSlotGroupString(GED_SLOT_GROUP SlotGroupValue);
#define GED_GetSlotGroupString(SlotGroupValue) ( \
    GED_TraceAPI("GED_GetSlotGroupString(" #SlotGroupValue ")"), \
    _GED_GetSlotGroupString(SlotGroupValue))

/*!
 * Get the string representation for the given GED_SRC_MOD enumerator. The function returns a NULL pointer for GED_SRC_MOD_INVALID.
 *
 * @param[in]       SrcModValue    The given GED_SRC_MOD enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSrcModString(GED_SRC_MOD SrcModValue);
#define GED_GetSrcModString(SrcModValue) ( \
    GED_TraceAPI("GED_GetSrcModString(" #SrcModValue ")"), \
    _GED_GetSrcModString(SrcModValue))

/*!
 * Get the string representation for the given GED_SUB_BYTE_PRECISION enumerator. The function returns a NULL pointer for
 * GED_SUB_BYTE_PRECISION_INVALID.
 *
 * @param[in]       SubBytePrecisionValue  The given GED_SUB_BYTE_PRECISION enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSubBytePrecisionString(GED_SUB_BYTE_PRECISION SubBytePrecisionValue);
#define GED_GetSubBytePrecisionString(SubBytePrecisionValue) ( \
    GED_TraceAPI("GED_GetSubBytePrecisionString(" #SubBytePrecisionValue ")"), \
    _GED_GetSubBytePrecisionString(SubBytePrecisionValue))

/*!
 * Get the string representation for the given GED_SUB_FUNC_ID enumerator. The function returns a NULL pointer for
 * GED_SUB_FUNC_ID_INVALID.
 *
 * @param[in]       SubFuncIDValue The given GED_SUB_FUNC_ID enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSubFuncIDString(GED_SUB_FUNC_ID SubFuncIDValue);
#define GED_GetSubFuncIDString(SubFuncIDValue) ( \
    GED_TraceAPI("GED_GetSubFuncIDString(" #SubFuncIDValue ")"), \
    _GED_GetSubFuncIDString(SubFuncIDValue))

/*!
 * Get the string representation for the given GED_SWIZZLE enumerator. The function returns a NULL pointer for GED_SWIZZLE_INVALID.
 *
 * @param[in]       SwizzleValue   The given GED_SWIZZLE enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSwizzleString(GED_SWIZZLE SwizzleValue);
#define GED_GetSwizzleString(SwizzleValue) ( \
    GED_TraceAPI("GED_GetSwizzleString(" #SwizzleValue ")"), \
    _GED_GetSwizzleString(SwizzleValue))

/*!
 * Get the string representation for the given GED_SYNC_FC enumerator. The function returns a NULL pointer for GED_SYNC_FC_INVALID.
 *
 * @param[in]       SyncFCValue    The given GED_SYNC_FC enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetSyncFCString(GED_SYNC_FC SyncFCValue);
#define GED_GetSyncFCString(SyncFCValue) ( \
    GED_TraceAPI("GED_GetSyncFCString(" #SyncFCValue ")"), \
    _GED_GetSyncFCString(SyncFCValue))

/*!
 * Get the string representation for the given GED_THREAD_CTRL enumerator. The function returns a NULL pointer for
 * GED_THREAD_CTRL_INVALID.
 *
 * @param[in]       ThreadCtrlValue    The given GED_THREAD_CTRL enumerator.
 *
 * @return      The requested string.
 */
extern const char* GED_CALLCONV _GED_GetThreadCtrlString(GED_THREAD_CTRL ThreadCtrlValue);
#define GED_GetThreadCtrlString(ThreadCtrlValue) ( \
    GED_TraceAPI("GED_GetThreadCtrlString(" #ThreadCtrlValue ")"), \
    _GED_GetThreadCtrlString(ThreadCtrlValue))

/*!
 * Determine whether the given vertical stride represents Vx1 or VxH.
 *
 * @param[in]       vertstride The vertical stride to check.
 *
 * @return      TRUE if the given vertical stride represents Vx1 or VxH, FALSE otherwise.
 */
GED_INLINE bool GED_CALLCONV GED_IsVx1VxH(uint32_t vertstride)
{
    return (3 == vertstride);
}

/*!
 * The operand width, based on its data type.
 *
 * @param[in]       datatype   The @ref GED_DATA_TYPE enumerator to interpret.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The requested value.
 */
extern uint32_t GED_CALLCONV _GED_GetOperandWidth(const GED_DATA_TYPE datatype, const GED_MODEL modelId, GED_RETURN_VALUE* result);
#define GED_GetOperandWidth(datatype, modelId, result) ( \
    GED_TraceAPI("GED_GetOperandWidth(" #datatype ", " #modelId ", " #result ")"), \
    _GED_GetOperandWidth(datatype, modelId, result))

/*!
 * The numeric type in which to display an operand, based on its data type. Relevant only for immediate operands.
 *
 * @param[in]       datatype   The @ref GED_DATA_TYPE enumerator to interpret.
 * @param[in]       modelId    The GED model by which to interpret.
 * @param[out]      result     If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the specific
 *                             error which caused the failure.
 *
 * @return      The requested value.
 */
extern uint32_t GED_CALLCONV _GED_GetOperandNumericType(const GED_DATA_TYPE datatype, const GED_MODEL modelId, GED_RETURN_VALUE*
                                                        result);
#define GED_GetOperandNumericType(datatype, modelId, result) ( \
    GED_TraceAPI("GED_GetOperandNumericType(" #datatype ", " #modelId ", " #result ")"), \
    _GED_GetOperandNumericType(datatype, modelId, result))

/*!
 *
 *                 Nibble Control. This field is used in some instructions along with QtrCtrl. See the description of
 * ExecMaskOffsetCtrl.
 *                 NibCtrl is only used for SIMD4 instructions.
 *
 *
 * @param[in]       execmaskoffsetctrl The @ref GED_EXEC_MASK_OFFSET_CTRL enumerator to interpret.
 * @param[in]       modelId            The GED model by which to interpret.
 * @param[out]      result             If non-null, the function stores the @ref GED_RETURN_VALUE result indicating success or the
 *                                     specific error which caused the failure.
 *
 * @return      The requested value.
 */
extern uint32_t GED_CALLCONV _GED_GetNibCtrl(const GED_EXEC_MASK_OFFSET_CTRL execmaskoffsetctrl, const GED_MODEL modelId,
                                             GED_RETURN_VALUE* result);
#define GED_GetNibCtrl(execmaskoffsetctrl, modelId, result) ( \
    GED_TraceAPI("GED_GetNibCtrl(" #execmaskoffsetctrl ", " #modelId ", " #result ")"), \
    _GED_GetNibCtrl(execmaskoffsetctrl, modelId, result))

#ifdef __cplusplus
}// extern "C"
#endif // __cplusplus
#endif // GED_H
