/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import java.util.LinkedHashMap;

import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl extends LinkedHashMap<String, Node> implements NamedNodeMap {

    private static final long serialVersionUID = 1L;

    public int getLength() {
        return size();
    }

    public Node getNamedItem(String name) {
        return get(name);
    }

    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return get(namespaceURI + ":" + localName);
    }

    public Node item(int index) {

        Node[] nodes = values().toArray(new Node[0]);
        
        if (nodes == null || index >= nodes.length || index < 0) {
            return null;
        }
        
        return nodes[index];
    }

    public Node removeNamedItem(String name) throws DOMException {
        return remove(name);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return remove(namespaceURI + ":" + localName);
    }

    public Node setNamedItem(Node node) throws DOMException {

        put(node.getLocalName(), node);
        return node;
    }

    public Node setNamedItemNS(Node node) throws DOMException {

        String namespace = node.getNamespaceURI();
        put(namespace + ":" + node.getLocalName(), node);

        return node;
    }

}
