;;; Copyright (C) 2011 Team GPS.
;;; 
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

(ns twitter_clj.common
  (:require [clojure.string :as str]
            [clojure.contrib.logging :as log]))

;; ==================================================
;; Global variables
;; ==================================================

(def options (atom {}))
(def pv (atom []))

;; ==================================================
;; Functions
;; ==================================================

(defn sort-pv
  "Sort PV lines that gpsusi produces"
  [coll]
  (letfn [(unique-first-move [coll]
           (loop [coll coll
                  ret {}]
             (if-let [line (first coll)]
               (recur (rest coll) (assoc ret (:first-move line) line))
               (vals ret))))
          (sort-by-cp [coll]
            (vals (apply sorted-map-by > (mapcat (fn [line]
                                                   [(:cp line) line])
                                                 coll))))]
    (if (seq coll)
      (sort-by-cp (unique-first-move coll))
      coll)))


