#line 2 "../gotwebd/pages.tmpl"
/*
* Copyright (c) 2022 Omar Polo <op@openbsd.org>
* Copyright (c) 2016, 2019, 2020-2022 Tracey Emery <tracey@traceyemery.net>
*
* Permission to use, copy, modify, and distribute this software for any
* purpose with or without fee is hereby granted, provided that the above
* copyright notice and this permission notice appear in all copies.
*
* THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
* WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
* ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
* ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
* OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/
#line 19 "../gotwebd/pages.tmpl"
#include "got_compat.h"
#line 21 "../gotwebd/pages.tmpl"
#include <sys/types.h>
#include <sys/queue.h>
#include <sys/stat.h>
#line 25 "../gotwebd/pages.tmpl"
#include <ctype.h>
#include <event.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <imsg.h>
#line 33 "../gotwebd/pages.tmpl"
#include "got_error.h"
#include "got_object.h"
#include "got_reference.h"
#line 37 "../gotwebd/pages.tmpl"
#include "gotwebd.h"
#include "tmpl.h"
#line 40 "../gotwebd/pages.tmpl"
enum gotweb_ref_tm {
TM_DIFF,
TM_LONG,
};
#line 45 "../gotwebd/pages.tmpl"
static int breadcumbs(struct template *);
static int datetime(struct template *, time_t, int);
static int gotweb_render_blob_line(struct template *, const char *, size_t);
static int gotweb_render_tree_item(struct template *, struct got_tree_entry *);
static int blame_line(struct template *, const char *, struct blame_line *,
int, int);
#line 52 "../gotwebd/pages.tmpl"
static inline int gotweb_render_more(struct template *, int);
#line 54 "../gotwebd/pages.tmpl"
static inline int tree_listing(struct template *);
static inline int diff_line(struct template *, char *);
static inline int tag_item(struct template *, struct repo_tag *);
static inline int branch(struct template *, struct got_reflist_entry *);
static inline int rss_tag_item(struct template *, struct repo_tag *);
static inline int rss_author(struct template *, char *);
#line 61 "../gotwebd/pages.tmpl"
static inline char *
nextsep(char *s, char **t)
{
char *q;
#line 66 "../gotwebd/pages.tmpl"
while (*s == '/')
s++;
*t = s;
if (*s == '\0')
return NULL;
#line 72 "../gotwebd/pages.tmpl"
q = strchr(s, '/');
if (q == NULL)
q = strchr(s, '\0');
return q;
}
#line 80 "../gotwebd/pages.tmpl"
int
datetime(struct template *tp, time_t t, int fmt)
{
int tp_ret = 0;
#line 82 "../gotwebd/pages.tmpl"
struct tm tm;
char rfc3339[64];
char datebuf[64];
#line 86 "../gotwebd/pages.tmpl"
if (gmtime_r(&t, &tm) == NULL)
return -1;
#line 89 "../gotwebd/pages.tmpl"
if (strftime(rfc3339, sizeof(rfc3339), "%FT%TZ", &tm) == 0)
return -1;
#line 92 "../gotwebd/pages.tmpl"
if (fmt != TM_DIFF && asctime_r(&tm, datebuf) == NULL)
return -1;
#line 95 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<time datetime=\"", 16)) == -1) goto err;
#line 95 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rfc3339)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 96 "../gotwebd/pages.tmpl"
if (fmt == TM_DIFF) {
if ((tp_ret = gotweb_render_age(tp, t)) == -1) goto err;
} else {
if ((tp_ret = tp_htmlescape(tp, datebuf)) == -1)
goto err;
#line 99 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " UTC")) == -1)
goto err;
}
#line 102 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</time>", 7)) == -1) goto err;
err:
return tp_ret;
}
#line 104 "../gotwebd/pages.tmpl"
int
breadcumbs(struct template *tp)
{
int tp_ret = 0;
#line 106 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct querystring *qs = c->t->qs;
struct gotweb_url url;
const char *folder = qs->folder;
const char *action = "tree";
char *t, *s = NULL, *dir = NULL;
char ch;
#line 114 "../gotwebd/pages.tmpl"
memset(&url, 0, sizeof(url));
url.index_page = -1;
url.page = -1;
url.action = TREE;
url.path = qs->path;
url.commit = qs->commit;
#line 121 "../gotwebd/pages.tmpl"
if (qs->action != TREE && qs->action != BLOB) {
action = gotweb_action_name(qs->action);
url.action = qs->action;
}
#line 126 "../gotwebd/pages.tmpl"
if (folder && *folder != '\0') {
while (*folder == '/')
folder++;
dir = strdup(folder);
if (dir == NULL)
return (-1);
s = dir;
}
#line 135 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 136 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 136 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 136 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, action)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 137 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
if (dir) {
while ((s = nextsep(s, &t)) != NULL) {
#line 141 "../gotwebd/pages.tmpl"
ch = *s;
*s = '\0';
url.folder = dir;
#line 146 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 146 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 147 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t)) == -1)
goto err;
#line 149 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 149 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
#line 151 "../gotwebd/pages.tmpl"
*s = ch; 
}
}
#line 155 "../gotwebd/pages.tmpl"
if (qs->file) {
if ((tp_ret = tp_htmlescape(tp, qs->file)) == -1)
goto err;
}
#line 159 "../gotwebd/pages.tmpl"
err:
free(dir); 
return tp_ret;
}
#line 164 "../gotwebd/pages.tmpl"
int
gotweb_render_page(struct template *tp, int (*body)(struct template *))
{
int tp_ret = 0;
#line 166 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct querystring *qs = c->t->qs;
struct gotweb_url u_path;
const char *prfx = c->document_uri;
const char *css = srv->custom_css;
#line 173 "../gotwebd/pages.tmpl"
memset(&u_path, 0, sizeof(u_path));
u_path.index_page = -1;
u_path.page = -1;
u_path.action = SUMMARY;
#line 182 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<!doctype html><html><head><meta charset=\"utf-8\" /><title>", 58)) == -1) goto err;
#line 182 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->site_name)) == -1)
goto err;
#line 186 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><meta name=\"viewport\" content=\"initial-scale=1.0\" /><meta name=\"msapplication-TileColor\" content=\"#da532c\" /><meta name=\"theme-color\" content=\"#ffffff\"/><link rel=\"apple-touch-icon\" sizes=\"180x180\" href=\"", 212)) == -1) goto err;
#line 186 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "apple-touch-icon.png\" /><link rel=\"icon\" type=\"image/png\" sizes=\"32x32\" href=\"", 78)) == -1) goto err;
#line 187 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "favicon-32x32.png\" /><link rel=\"icon\" type=\"image/png\" sizes=\"16x16\" href=\"", 75)) == -1) goto err;
#line 188 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "favicon-16x16.png\" /><link rel=\"manifest\" href=\"", 48)) == -1) goto err;
#line 189 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "site.webmanifest\"/><link rel=\"mask-icon\" href=\"", 47)) == -1) goto err;
#line 190 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "safari-pinned-tab.svg\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"", 70)) == -1) goto err;
#line 191 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
#line 191 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, css)) == -1)
goto err;
#line 196 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\" /></head><body><header id=\"header\"><div id=\"got_link\"><a href=\"", 65)) == -1) goto err;
#line 196 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->logo_url)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\" target=\"_blank\"><img src=\"", 28)) == -1) goto err;
#line 197 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
#line 197 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->logo)) == -1)
goto err;
#line 203 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\" /></a></div></header><nav id=\"site_path\"><div id=\"site_link\"><a href=\"?index_page=", 84)) == -1) goto err;
#line 203 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%d", qs->index_page) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 204 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->site_link)) == -1)
goto err;
#line 206 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 206 "../gotwebd/pages.tmpl"
if (qs->path) {
u_path.path = qs->path; 
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 209 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &u_path)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 210 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, qs->path)) == -1)
goto err;
#line 212 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
}
#line 214 "../gotwebd/pages.tmpl"
if (qs->action == SUMMARY ||qs->action == DIFF ||qs->action == TAG ||qs->action == TAGS) {
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
#line 215 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, gotweb_action_name(qs->action))) == -1)
goto err;
} else if (qs->action != INDEX) {
if ((tp_ret = breadcumbs(tp)) == -1) goto err;
}
#line 222 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></nav><main>", 18)) == -1) goto err;
#line 222 "../gotwebd/pages.tmpl"
if ((tp_ret = body(tp)) == -1) goto err;
#line 226 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</main><footer id=\"site_owner_wrapper\"><p id=\"site_owner\">", 58)) == -1) goto err;
#line 226 "../gotwebd/pages.tmpl"
if (srv->show_site_owner) {
if ((tp_ret = tp_htmlescape(tp, srv->site_owner)) == -1)
goto err;
}
#line 233 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</p></footer></body></html>", 27)) == -1) goto err;
err:
return tp_ret;
}
#line 235 "../gotwebd/pages.tmpl"
int
gotweb_render_error(struct template *tp)
{
int tp_ret = 0;
#line 237 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
#line 241 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"err_content\">", 22)) == -1) goto err;
#line 241 "../gotwebd/pages.tmpl"
if (t->error) {
if ((tp_ret = tp_htmlescape(tp, t->error->msg)) == -1)
goto err;
} else {
#line 245 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "See daemon logs for details", 27)) == -1) goto err;
}
#line 247 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 249 "../gotwebd/pages.tmpl"
int
gotweb_render_repo_table_hdr(struct template *tp)
{
int tp_ret = 0;
#line 251 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
#line 258 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"index_header\"><div class=\"index_project\">Project</div>", 63)) == -1) goto err;
#line 258 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 262 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_description\">Description</div>", 56)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 267 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_owner\">Owner</div>", 44)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 272 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_age\">Last Change</div>", 48)) == -1) goto err;
}
#line 274 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 276 "../gotwebd/pages.tmpl"
int
gotweb_render_repo_fragment(struct template *tp, struct repo_dir *repo_dir)
{
int tp_ret = 0;
#line 278 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct gotweb_url summary = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, briefs = {
.action = BRIEFS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, commits = {
.action = COMMITS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, tags = {
.action = TAGS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, tree = {
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, rss = {
.action = RSS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 314 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_wrapper\"><div class=\"index_project\"><a href=\"", 63)) == -1) goto err;
#line 314 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &summary)) == -1) goto err;
#line 314 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 314 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 316 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div>", 10)) == -1) goto err;
#line 316 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 318 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_description\">", 39)) == -1) goto err;
#line 318 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->description)) == -1)
goto err;
#line 320 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 323 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_owner\">", 33)) == -1) goto err;
#line 323 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->owner)) == -1)
goto err;
#line 325 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 328 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_age\">", 31)) == -1) goto err;
#line 328 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, repo_dir->age, TM_DIFF)) == -1) goto err;
#line 330 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
#line 333 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 53)) == -1) goto err;
#line 333 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &summary)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">summary</a>", 13)) == -1) goto err;
#line 334 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 335 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &briefs)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">briefs</a>", 12)) == -1) goto err;
#line 336 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 337 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &commits)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commits</a>", 13)) == -1) goto err;
#line 338 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 339 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tags)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tags</a>", 10)) == -1) goto err;
#line 340 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 341 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tree)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tree</a>", 10)) == -1) goto err;
#line 342 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 343 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &rss)) == -1) goto err;
#line 348 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">rss</a></div><hr /></div></div>", 33)) == -1) goto err;
err:
return tp_ret;
}
#line 350 "../gotwebd/pages.tmpl"
int
gotweb_render_briefs(struct template *tp)
{
int tp_ret = 0;
#line 352 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = c->t->qs;
struct repo_commit *rc;
struct repo_dir *repo_dir = t->repo_dir;
struct gotweb_url diff_url, patch_url, tree_url;
char *tmp, *body;
#line 360 "../gotwebd/pages.tmpl"
diff_url = (struct gotweb_url){
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.headref = qs->headref,
};
patch_url = (struct gotweb_url){
.action = PATCH,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.headref = qs->headref,
};
tree_url = (struct gotweb_url){
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.headref = qs->headref,
};
#line 386 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Commit Briefs</h2></header><div id=\"briefs_content\">", 81)) == -1) goto err;
TAILQ_FOREACH(rc, &t->repo_commits, entry) {
#line 388 "../gotwebd/pages.tmpl"
diff_url.commit = rc->commit_id;
patch_url.commit = rc->commit_id;
tree_url.commit = rc->commit_id;
#line 392 "../gotwebd/pages.tmpl"
tmp = strchr(rc->committer, '<');
if (tmp)
*tmp = '\0';
#line 396 "../gotwebd/pages.tmpl"
body = strchr(rc->commit_msg, '\n');
if (body) {
*body++ = '\0';
while (*body == '\n')
body++;
}
#line 406 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class='brief'><p class='brief_meta'><span class='briefs_age'>", 66)) == -1) goto err;
#line 406 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_DIFF)) == -1) goto err;
#line 408 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 408 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 410 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"briefs_author\">", 28)) == -1) goto err;
#line 410 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
#line 413 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></p>", 11)) == -1) goto err;
#line 413 "../gotwebd/pages.tmpl"
if (body && *body != '\0') {
#line 416 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<details class=\"briefs_log\"><summary><a href=\"", 46)) == -1) goto err;
#line 416 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &diff_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 417 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 419 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 419 "../gotwebd/pages.tmpl"
if (rc->refs_str) {
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 420 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"refs_str\">(", 24)) == -1) goto err;
#line 420 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->refs_str)) == -1)
goto err;
if ((tp_ret = tp_write(tp, ")</span>", 8)) == -1) goto err;
}
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 424 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"briefs_toggle\" aria-hidden=\"true\">", 47)) == -1) goto err;
#line 424 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ⋅⋅⋅ ")) == -1)
goto err;
#line 427 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></summary>", 17)) == -1) goto err;
#line 427 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<p>", 3)) == -1) goto err;
#line 428 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, body)) == -1)
goto err;
#line 430 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</p></details>", 14)) == -1) goto err;
#line 430 "../gotwebd/pages.tmpl"
} else {
#line 432 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<p class=\"briefs_log\"><a href=\"", 31)) == -1) goto err;
#line 432 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &diff_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 433 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 435 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 435 "../gotwebd/pages.tmpl"
if (rc->refs_str) {
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 436 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"refs_str\">(", 24)) == -1) goto err;
#line 436 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->refs_str)) == -1)
goto err;
if ((tp_ret = tp_write(tp, ")</span>", 8)) == -1) goto err;
}
#line 439 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</p>", 4)) == -1) goto err;
}
#line 443 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 59)) == -1) goto err;
#line 443 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &diff_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">diff</a>", 10)) == -1) goto err;
#line 444 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 445 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &patch_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">patch</a>", 11)) == -1) goto err;
#line 446 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 447 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tree_url)) == -1) goto err;
#line 451 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">tree</a></div></div><hr />", 28)) == -1) goto err;
}
if ((tp_ret = gotweb_render_more(tp, BRIEFS)) == -1) goto err;
#line 454 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 456 "../gotwebd/pages.tmpl"
int
gotweb_render_more(struct template *tp, int action)
{
int tp_ret = 0;
#line 458 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct gotweb_url more = {
.action = action,
.index_page = -1,
.path = qs->path,
.commit = t->more_id,
.headref = qs->headref,
.file = qs->file,
};
#line 470 "../gotwebd/pages.tmpl"
if (action == TAGS)
more.commit = t->tags_more_id;
#line 473 "../gotwebd/pages.tmpl"
if (more.commit) {
#line 476 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"np_wrapper\"><div id=\"nav_more\"><a href=\"", 49)) == -1) goto err;
#line 476 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &more)) == -1) goto err;
#line 481 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">More&nbsp;&darr;</a></div></div>", 34)) == -1) goto err;
}
err:
return tp_ret;
}
#line 484 "../gotwebd/pages.tmpl"
int
gotweb_render_navs(struct template *tp)
{
int tp_ret = 0;
#line 486 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct gotweb_url prev, next;
int have_prev, have_next;
#line 490 "../gotwebd/pages.tmpl"
gotweb_index_navs(c, &prev, &have_prev, &next, &have_next);
#line 494 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"np_wrapper\"><div id=\"nav_prev\">", 40)) == -1) goto err;
#line 494 "../gotwebd/pages.tmpl"
if (have_prev) {
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 495 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &prev)) == -1) goto err;
#line 498 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Previous</a>", 14)) == -1) goto err;
}
#line 501 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div id=\"nav_next\">", 25)) == -1) goto err;
#line 501 "../gotwebd/pages.tmpl"
if (have_next) {
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 502 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &next)) == -1) goto err;
#line 505 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Next</a>", 10)) == -1) goto err;
}
#line 508 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></div>", 12)) == -1) goto err;
err:
return tp_ret;
}
#line 510 "../gotwebd/pages.tmpl"
int
gotweb_render_commits(struct template *tp)
{
int tp_ret = 0;
#line 512 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct repo_commit *rc;
struct gotweb_url diff, patch, tree;
#line 518 "../gotwebd/pages.tmpl"
diff = (struct gotweb_url){
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
patch = (struct gotweb_url){
.action = PATCH,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
tree = (struct gotweb_url){
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 541 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Commits</h2></header><div class=\"commits_content\">", 79)) == -1) goto err;
TAILQ_FOREACH(rc, &t->repo_commits, entry) {
#line 543 "../gotwebd/pages.tmpl"
diff.commit = rc->commit_id;
patch.commit = rc->commit_id;
tree.commit = rc->commit_id;
#line 550 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"page_header_wrapper\"><dl><dt>Commit:</dt><dd><code class=\"commit-id\">", 81)) == -1) goto err;
#line 550 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_id)) == -1)
goto err;
#line 552 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>From:</dt><dd>", 30)) == -1) goto err;
#line 552 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->author)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
#line 553 "../gotwebd/pages.tmpl"
if (strcmp(rc->committer, rc->author) != 0) {
#line 555 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Via:</dt><dd>", 17)) == -1) goto err;
#line 555 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
#line 559 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Date:</dt><dd>", 18)) == -1) goto err;
#line 559 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 565 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><div class=\"commit\">", 42)) == -1) goto err;
#line 565 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 570 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 59)) == -1) goto err;
#line 570 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &diff)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">diff</a>", 10)) == -1) goto err;
#line 571 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 572 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &patch)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">patch</a>", 11)) == -1) goto err;
#line 573 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 574 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &tree)) == -1) goto err;
#line 578 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">tree</a></div></div><hr />", 28)) == -1) goto err;
}
if ((tp_ret = gotweb_render_more(tp, COMMITS)) == -1) goto err;
#line 581 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 583 "../gotwebd/pages.tmpl"
int
gotweb_render_blob(struct template *tp)
{
int tp_ret = 0;
#line 585 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct got_blob_object *blob = t->blob;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
struct gotweb_url briefs_url, blame_url, raw_url;
#line 592 "../gotwebd/pages.tmpl"
memset(&briefs_url, 0, sizeof(briefs_url));
briefs_url.index_page = -1,
briefs_url.page = -1,
briefs_url.action = BRIEFS,
briefs_url.path = qs->path,
briefs_url.commit = qs->commit,
briefs_url.folder = qs->folder,
briefs_url.file = qs->file,
#line 601 "../gotwebd/pages.tmpl"
memcpy(&blame_url, &briefs_url, sizeof(blame_url));
blame_url.action = BLAME;
#line 604 "../gotwebd/pages.tmpl"
memcpy(&raw_url, &briefs_url, sizeof(raw_url));
raw_url.action = BLOBRAW;
#line 615 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Blob</h2></header><div id=\"blob_content\"><div class=\"page_header_wrapper\"><dl><dt>Date:</dt><dd>", 125)) == -1) goto err;
#line 615 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 618 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 618 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 621 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Actions:</dt><dd><a href=\"", 35)) == -1) goto err;
#line 621 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &briefs_url)) == -1) goto err;
#line 624 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">History</a>", 13)) == -1) goto err;
#line 624 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 625 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &blame_url)) == -1) goto err;
#line 628 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Blame</a>", 11)) == -1) goto err;
#line 628 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 629 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &raw_url)) == -1) goto err;
#line 638 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Raw File</a></dd></dl></div><hr /><div id=\"blob\"><pre>", 56)) == -1) goto err;
#line 638 "../gotwebd/pages.tmpl"
if ((tp_ret = got_output_blob_by_lines(tp, blob, gotweb_render_blob_line)) == -1) goto err;
#line 642 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div></div>", 18)) == -1) goto err;
err:
return tp_ret;
}
#line 645 "../gotwebd/pages.tmpl"
int
gotweb_render_blob_line(struct template *tp, const char *line, size_t no)
{
int tp_ret = 0;
#line 647 "../gotwebd/pages.tmpl"
char lineno[16];
int r;
#line 650 "../gotwebd/pages.tmpl"
r = snprintf(lineno, sizeof(lineno), "%zu", no);
if (r < 0 || (size_t)r >= sizeof(lineno))
return -1;
#line 654 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"blob_line\" id=\"line", 31)) == -1) goto err;
#line 654 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\"><a href=\"#line", 16)) == -1) goto err;
#line 655 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
#line 655 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 655 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 656 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<span class=\"blob_code\">", 24)) == -1) goto err;
#line 657 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 659 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></div>", 13)) == -1) goto err;
err:
return tp_ret;
}
#line 661 "../gotwebd/pages.tmpl"
int
tree_listing(struct template *tp)
{
int tp_ret = 0;
#line 663 "../gotwebd/pages.tmpl"
const struct got_error *error;
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = c->t->qs;
struct gotweb_url url;
char *readme = NULL;
int binary;
const uint8_t *buf;
size_t len;
#line 674 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<table id=\"tree\">", 17)) == -1) goto err;
#line 674 "../gotwebd/pages.tmpl"
if ((tp_ret = got_output_repo_tree(c, &readme, gotweb_render_tree_item)) == -1) goto err;
#line 676 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</table>", 8)) == -1) goto err;
#line 676 "../gotwebd/pages.tmpl"
if (readme) {
#line 678 "../gotwebd/pages.tmpl"
error = got_open_blob_for_output(&t->blob, &t->fd, &binary, c,
qs->folder, readme, qs->commit);
if (error) {
free(readme);
return (-1);
}
#line 685 "../gotwebd/pages.tmpl"
memset(&url, 0, sizeof(url));
url.index_page = -1;
url.page = -1;
url.action = BLOB;
url.path = t->qs->path;
url.file = readme;
url.folder = t->qs->folder;
url.commit = t->qs->commit;
#line 694 "../gotwebd/pages.tmpl"
if (!binary) {
#line 696 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<h2><a href=\"", 13)) == -1) goto err;
#line 696 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 697 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, readme)) == -1)
goto err;
#line 701 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></h2><pre>", 14)) == -1) goto err;
for (;;) {
error = got_object_blob_read_block(&len, t->blob);
if (error) {
free(readme);
return (-1);
}
if (len == 0)
break;
buf = got_object_blob_get_read_buf(t->blob);
if (tp_write_htmlescape(tp, buf, len) == -1) {
free(readme);
return (-1);
}
}
#line 718 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre>", 6)) == -1) goto err;
}
}
#line 720 "../gotwebd/pages.tmpl"
err:
free(readme); 
return tp_ret;
}
#line 724 "../gotwebd/pages.tmpl"
int
gotweb_render_tree(struct template *tp)
{
int tp_ret = 0;
#line 726 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
#line 737 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Tree</h2></header><div id=\"tree_content\"><div class=\"page_header_wrapper\"><dl><dt>Tree:</dt><dd><code class=\"commit-id\">", 149)) == -1) goto err;
#line 737 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->tree_id)) == -1)
goto err;
#line 740 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>Date:</dt><dd>", 30)) == -1) goto err;
#line 740 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 743 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 743 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 747 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr />", 22)) == -1) goto err;
#line 747 "../gotwebd/pages.tmpl"
if ((tp_ret = tree_listing(tp)) == -1) goto err;
#line 749 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 752 "../gotwebd/pages.tmpl"
int
gotweb_render_tree_item(struct template *tp, struct got_tree_entry *te)
{
int tp_ret = 0;
#line 754 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
const char *modestr = "";
const char *name;
const char *folder;
char *dir = NULL;
mode_t mode;
struct gotweb_url url = {
.index_page = -1,
.page = -1,
.commit = rc->commit_id,
.path = qs->path,
};
#line 770 "../gotwebd/pages.tmpl"
name = got_tree_entry_get_name(te);
mode = got_tree_entry_get_mode(te);
#line 773 "../gotwebd/pages.tmpl"
folder = qs->folder ? qs->folder : "";
if (S_ISDIR(mode)) {
if (asprintf(&dir, "%s/%s", folder, name) == -1)
return (-1);
#line 778 "../gotwebd/pages.tmpl"
url.action = TREE;
url.folder = dir;
} else {
url.action = BLOB;
url.folder = folder;
url.file = name;
}
#line 786 "../gotwebd/pages.tmpl"
if (got_object_tree_entry_is_submodule(te))
modestr = "$";
else if (S_ISLNK(mode))
modestr = "@";
else if (S_ISDIR(mode))
modestr = "/";
else if (mode & S_IXUSR)
modestr = "*";
#line 796 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<tr class=\"tree_wrapper\">", 25)) == -1) goto err;
#line 796 "../gotwebd/pages.tmpl"
if (S_ISDIR(mode)) {
#line 798 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<td class=\"tree_line\" colspan=2><a href=\"", 41)) == -1) goto err;
#line 798 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 799 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, name)) == -1)
goto err;
#line 799 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, modestr)) == -1)
goto err;
#line 802 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></td>", 9)) == -1) goto err;
#line 802 "../gotwebd/pages.tmpl"
} else {
#line 804 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<td class=\"tree_line\"><a href=\"", 31)) == -1) goto err;
#line 804 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 805 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, name)) == -1)
goto err;
#line 805 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, modestr)) == -1)
goto err;
#line 809 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></td><td class=\"tree_line_blank\">", 37)) == -1) goto err;
#line 809 "../gotwebd/pages.tmpl"
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 810 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 813 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a>", 13)) == -1) goto err;
#line 813 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BLAME; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 815 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 819 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">blame</a></td>", 16)) == -1) goto err;
}
#line 821 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</tr>", 5)) == -1) goto err;
#line 821 "../gotwebd/pages.tmpl"
err:
#line 823 "../gotwebd/pages.tmpl"
free(dir);
return tp_ret;
}
#line 827 "../gotwebd/pages.tmpl"
int
gotweb_render_tags(struct template *tp)
{
int tp_ret = 0;
#line 829 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct repo_tag *rt;
int commit_found;
#line 835 "../gotwebd/pages.tmpl"
commit_found = qs->commit == NULL;
#line 841 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Tags</h2></header><div id=\"tags_content\">", 70)) == -1) goto err;
#line 841 "../gotwebd/pages.tmpl"
if (t->tag_count == 0) {
#line 845 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"err_content\">This repository contains no tags</div>", 60)) == -1) goto err;
#line 845 "../gotwebd/pages.tmpl"
} else {
TAILQ_FOREACH(rt, &t->repo_tags, entry) {
#line 847 "../gotwebd/pages.tmpl"
if (commit_found ||!strcmp(qs->commit, rt->commit_id)) {
commit_found = 1; 
if ((tp_ret = tag_item(tp, rt)) == -1) goto err;
}
}
#line 852 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_more(tp, TAGS)) == -1) goto err;
}
#line 855 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 857 "../gotwebd/pages.tmpl"
int
tag_item(struct template *tp, struct repo_tag *rt)
{
int tp_ret = 0;
#line 859 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
char *tag_name = rt->tag_name;
char *msg = rt->tag_commit;
char *nl;
struct gotweb_url url = {
.action = TAG,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = rt->commit_id,
};
#line 873 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/tags/", 10) == 0)
tag_name += 10;
#line 876 "../gotwebd/pages.tmpl"
if (msg) {
nl = strchr(msg, '\n');
if (nl)
*nl = '\0';
}
#line 883 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"tag_age\">", 21)) == -1) goto err;
#line 883 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rt->tagger_time, TM_DIFF)) == -1) goto err;
#line 885 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"tag_name\">", 28)) == -1) goto err;
#line 885 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 887 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"tag_log\"><a href=\"", 36)) == -1) goto err;
#line 887 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 888 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, msg)) == -1)
goto err;
#line 893 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 63)) == -1) goto err;
#line 893 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tag</a>", 9)) == -1) goto err;
#line 894 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BRIEFS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 896 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commit briefs</a>", 19)) == -1) goto err;
#line 897 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 899 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 903 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a></div></div><hr />", 31)) == -1) goto err;
err:
return tp_ret;
}
#line 905 "../gotwebd/pages.tmpl"
int
gotweb_render_tag(struct template *tp)
{
int tp_ret = 0;
#line 907 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_tag *rt;
const char *tag_name;
#line 912 "../gotwebd/pages.tmpl"
rt = TAILQ_LAST(&t->repo_tags, repo_tags_head);
tag_name = rt->tag_name;
#line 915 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/", 5) == 0)
tag_name += 5;
#line 926 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Tag</h2></header><div id=\"tags_content\"><div class=\"page_header_wrapper\"><dl><dt>Commit:</dt><dd><code class=\"commit-id\">", 150)) == -1) goto err;
#line 926 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_id)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</code>", 7)) == -1) goto err;
#line 927 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<span class=\"refs_str\">(", 24)) == -1) goto err;
#line 928 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 931 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, ")</span></dd><dt>Tagger:</dt><dd>", 33)) == -1) goto err;
#line 931 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tagger)) == -1)
goto err;
#line 934 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Date:</dt><dd>", 23)) == -1) goto err;
#line 934 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rt->tagger_time, TM_LONG)) == -1) goto err;
#line 937 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 937 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_msg)) == -1)
goto err;
#line 941 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl><hr /><pre id=\"tag_commit\">", 37)) == -1) goto err;
#line 941 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tag_commit)) == -1)
goto err;
#line 945 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div></div>", 18)) == -1) goto err;
err:
return tp_ret;
}
#line 947 "../gotwebd/pages.tmpl"
int
gotweb_render_diff(struct template *tp)
{
int tp_ret = 0;
#line 949 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
FILE *fp = t->fp;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
char *line = NULL;
size_t linesize = 0;
ssize_t linelen;
struct gotweb_url patch_url, tree_url = {
.action = TREE,
.index_page = -1,
.page = -1,
.path = qs->path,
.commit = rc->commit_id,
};
#line 965 "../gotwebd/pages.tmpl"
memcpy(&patch_url, &tree_url, sizeof(patch_url));
patch_url.action = PATCH;
#line 975 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Commit Diff</h2></header><div id=\"diff_content\"><div class=\"page_header_wrapper\"><dl><dt>Commit:</dt><dd><code class=\"commit-id\">", 158)) == -1) goto err;
#line 975 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_id)) == -1)
goto err;
#line 977 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>From:</dt><dd>", 30)) == -1) goto err;
#line 977 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->author)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
#line 978 "../gotwebd/pages.tmpl"
if (strcmp(rc->committer, rc->author) != 0) {
#line 980 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Via:</dt><dd>", 17)) == -1) goto err;
#line 980 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
#line 984 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Date:</dt><dd>", 18)) == -1) goto err;
#line 984 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 987 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 987 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 990 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Actions:</dt><dd><a href=\"", 35)) == -1) goto err;
#line 990 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &patch_url)) == -1) goto err;
#line 993 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Patch</a>", 11)) == -1) goto err;
#line 993 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 994 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &tree_url)) == -1) goto err;
#line 1002 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Tree</a></dd></dl></div><hr /><pre id=\"diff\">", 47)) == -1) goto err;
while ((linelen = getline(&line, &linesize, fp)) != -1) {
if ((tp_ret = diff_line(tp, line)) == -1) goto err;
}
#line 1007 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div>", 12)) == -1) goto err;
#line 1007 "../gotwebd/pages.tmpl"
err:
free(line); 
return tp_ret;
}
#line 1011 "../gotwebd/pages.tmpl"
int
diff_line(struct template *tp, char *line )
{
int tp_ret = 0;
#line 1013 "../gotwebd/pages.tmpl"
const char *color = NULL;
char *nl;
#line 1016 "../gotwebd/pages.tmpl"
if (!strncmp(line, "-", 1))
color = "diff_minus";
else if (!strncmp(line, "+", 1))
color = "diff_plus";
else if (!strncmp(line, "@@", 2))
color = "diff_chunk_header";
else if (!strncmp(line, "commit +", 8) ||
!strncmp(line, "commit -", 8) ||
!strncmp(line, "blob +", 6) ||
!strncmp(line, "blob -", 6) ||
!strncmp(line, "file +", 6) ||
!strncmp(line, "file -", 6))
color = "diff_meta";
else if (!strncmp(line, "from:", 5) || !strncmp(line, "via:", 4))
color = "diff_author";
else if (!strncmp(line, "date:", 5))
color = "diff_date";
#line 1034 "../gotwebd/pages.tmpl"
nl = strchr(line, '\n');
if (nl)
*nl = '\0';
#line 1038 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"diff_line ", 23)) == -1) goto err;
#line 1038 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, color)) == -1)
goto err;
#line 1038 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 1038 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 1038 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 1038 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
err:
return tp_ret;
}
#line 1042 "../gotwebd/pages.tmpl"
int
gotweb_render_branches(struct template *tp, struct got_reflist_head *refs)
{
int tp_ret = 0;
#line 1044 "../gotwebd/pages.tmpl"
struct got_reflist_entry *re;
#line 1050 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Branches</h2></header><div id=\"branches_content\">", 78)) == -1) goto err;
TAILQ_FOREACH(re, refs, entry) {
if (!got_ref_is_symbolic(re->ref)) {
if ((tp_ret = branch(tp, re)) == -1) goto err;
}
}
#line 1056 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 1058 "../gotwebd/pages.tmpl"
int
branch(struct template *tp, struct got_reflist_entry *re)
{
int tp_ret = 0;
#line 1060 "../gotwebd/pages.tmpl"
const struct got_error *err;
struct request *c = tp->tp_arg;
struct querystring *qs = c->t->qs;
const char *refname;
time_t age;
struct gotweb_url url = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = qs->path,
};
#line 1072 "../gotwebd/pages.tmpl"
refname = got_ref_get_name(re->ref);
#line 1074 "../gotwebd/pages.tmpl"
err = got_get_repo_age(&age, c, refname);
if (err) {
log_warnx("%s: %s", __func__, err->msg);
return -1;
}
#line 1080 "../gotwebd/pages.tmpl"
if (strncmp(refname, "refs/heads/", 11) == 0)
refname += 11;
#line 1083 "../gotwebd/pages.tmpl"
url.headref = refname;
#line 1087 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<section class=\"branches_wrapper\"><div class=\"branches_age\">", 60)) == -1) goto err;
#line 1087 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, age, TM_DIFF)) == -1) goto err;
#line 1090 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"branch\"><a href=\"", 35)) == -1) goto err;
#line 1090 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 1090 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 1090 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, refname)) == -1)
goto err;
#line 1094 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 63)) == -1) goto err;
#line 1094 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">summary</a>", 13)) == -1) goto err;
#line 1095 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BRIEFS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 1097 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commit briefs</a>", 19)) == -1) goto err;
#line 1098 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 1100 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 1105 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a></div></div><hr /></section>", 41)) == -1) goto err;
err:
return tp_ret;
}
#line 1107 "../gotwebd/pages.tmpl"
int
gotweb_render_summary(struct template *tp)
{
int tp_ret = 0;
#line 1109 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct transport *t = c->t;
struct got_reflist_head *refs = &t->refs;
#line 1115 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dl id=\"summary_wrapper\" class=\"page_header_wrapper\">", 53)) == -1) goto err;
#line 1115 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 1117 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Description:</dt><dd>", 25)) == -1) goto err;
#line 1117 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->description)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 1121 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Owner:</dt><dd>", 19)) == -1) goto err;
#line 1121 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->owner)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 1126 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Last Change:</dt><dd>", 25)) == -1) goto err;
#line 1126 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, t->repo_dir->age, TM_DIFF)) == -1) goto err;
#line 1128 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_cloneurl) {
#line 1131 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Clone URL:</dt><dd><pre class=\"clone-url\">", 46)) == -1) goto err;
#line 1131 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->url)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</pre></dd>", 11)) == -1) goto err;
}
#line 1134 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dl>", 5)) == -1) goto err;
#line 1134 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_briefs(tp)) == -1) goto err;
if ((tp_ret = gotweb_render_branches(tp, refs)) == -1) goto err;
if ((tp_ret = gotweb_render_tags(tp)) == -1) goto err;
#line 1141 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Tree</h2></header><div id=\"tree_content\">", 70)) == -1) goto err;
#line 1141 "../gotwebd/pages.tmpl"
if ((tp_ret = tree_listing(tp)) == -1) goto err;
#line 1143 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 1145 "../gotwebd/pages.tmpl"
int
gotweb_render_blame(struct template *tp)
{
int tp_ret = 0;
#line 1147 "../gotwebd/pages.tmpl"
const struct got_error *err;
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
struct gotweb_url briefs_url, blob_url, raw_url;
#line 1154 "../gotwebd/pages.tmpl"
memset(&briefs_url, 0, sizeof(briefs_url));
briefs_url.index_page = -1,
briefs_url.page = -1,
briefs_url.action = BRIEFS,
briefs_url.path = qs->path,
briefs_url.commit = qs->commit,
briefs_url.folder = qs->folder,
briefs_url.file = qs->file,
#line 1163 "../gotwebd/pages.tmpl"
memcpy(&blob_url, &briefs_url, sizeof(blob_url));
blob_url.action = BLOB;
#line 1166 "../gotwebd/pages.tmpl"
memcpy(&raw_url, &briefs_url, sizeof(raw_url));
raw_url.action = BLOBRAW;
#line 1177 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Blame</h2></header><div id=\"blame_content\"><div class=\"page_header_wrapper\"><dl><dt>Date:</dt><dd>", 127)) == -1) goto err;
#line 1177 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 1180 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 1180 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 1183 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Actions:</dt><dd><a href=\"", 35)) == -1) goto err;
#line 1183 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &briefs_url)) == -1) goto err;
#line 1186 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">History</a>", 13)) == -1) goto err;
#line 1186 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 1187 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &blob_url)) == -1) goto err;
#line 1190 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Blob</a>", 10)) == -1) goto err;
#line 1190 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 1191 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &raw_url)) == -1) goto err;
#line 1199 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Raw File</a></dd></dl></div><hr /><pre id=\"blame\">", 52)) == -1) goto err;
err = got_output_file_blame(c, &blame_line);
if (err && err->code != GOT_ERR_CANCELLED)
log_warnx("%s: got_output_file_blame: %s", __func__,
err->msg);
if (err)
return (-1);
#line 1209 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div>", 12)) == -1) goto err;
err:
return tp_ret;
}
#line 1212 "../gotwebd/pages.tmpl"
int
blame_line(struct template *tp, const char *line, struct blame_line *bline, int lprec, int lcur)
{
int tp_ret = 0;
#line 1214 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
char *committer, *s;
struct gotweb_url url = {
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = bline->id_str,
};
#line 1226 "../gotwebd/pages.tmpl"
s = strchr(bline->committer, '<');
committer = s ? s + 1 : bline->committer;
#line 1229 "../gotwebd/pages.tmpl"
s = strchr(committer, '@');
if (s)
*s = '\0';
#line 1234 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"blame_line\"><span class=\"blame_number\">", 51)) == -1) goto err;
#line 1234 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%*d ", lprec, lcur) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
#line 1236 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span><span class=\"blame_hash\"><a href=\"", 41)) == -1) goto err;
#line 1236 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 1237 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.8s", bline->id_str) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
#line 1240 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></span>", 11)) == -1) goto err;
#line 1240 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<span class=\"blame_date\">", 25)) == -1) goto err;
#line 1241 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, bline->datebuf)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 1242 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<span class=\"blame_author\">", 27)) == -1) goto err;
#line 1243 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.9s", committer) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 1244 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<span class=\"blame_code\">", 25)) == -1) goto err;
#line 1245 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 1247 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></div>", 13)) == -1) goto err;
err:
return tp_ret;
}
#line 1249 "../gotwebd/pages.tmpl"
int
gotweb_render_patch(struct template *tp)
{
int tp_ret = 0;
#line 1251 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
struct tm tm;
char buf[BUFSIZ], datebuf[64];
size_t r;
#line 1258 "../gotwebd/pages.tmpl"
if (gmtime_r(&rc->committer_time, &tm) == NULL ||
strftime(datebuf, sizeof(datebuf), "%a %b %d %T %Y UTC", &tm) == 0)
return (-1);
#line 1262 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "commit ", 7)) == -1) goto err;
#line 1262 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_id)) == -1)
goto err;
#line 1262 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "from: ", 6)) == -1) goto err;
#line 1263 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_writes(tp, rc->author)) == -1)
goto err;
#line 1263 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if (strcmp(rc->committer, rc->author) != 0) {
if ((tp_ret = tp_write(tp, "via: ", 5)) == -1) goto err;
#line 1265 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_writes(tp, rc->committer)) == -1)
goto err;
#line 1265 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
}
#line 1267 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "date: ", 6)) == -1) goto err;
#line 1267 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, datebuf)) == -1)
goto err;
#line 1267 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if ((tp_ret = tp_writes(tp, rc->commit_msg)) == -1)
goto err;
#line 1269 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
#line 1271 "../gotwebd/pages.tmpl"
if (template_flush(tp) == -1)
return (-1);
for (;;) {
r = fread(buf, 1, sizeof(buf), t->fp);
if (fcgi_write(c, buf, r) == -1 ||
r != sizeof(buf))
break;
}
err:
return tp_ret;
}
#line 1282 "../gotwebd/pages.tmpl"
int
gotweb_render_rss(struct template *tp)
{
int tp_ret = 0;
#line 1284 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct repo_tag *rt;
struct gotweb_url summary = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 1299 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rss version=\"2.0\" xmlns:content=\"http://purl.org/rss/1.0/modules/content/\"><channel><title>Tags of ", 138)) == -1) goto err;
#line 1299 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 1302 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><link><![CDATA[", 23)) == -1) goto err;
#line 1302 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_absolute_url(c, &summary)) == -1) goto err;
#line 1305 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "]]></link>", 10)) == -1) goto err;
#line 1305 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
if ((tp_ret = tp_write(tp, "<description>", 13)) == -1) goto err;
#line 1306 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->description)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</description>", 14)) == -1) goto err;
}
TAILQ_FOREACH(rt, &t->repo_tags, entry) {
#line 1309 "../gotwebd/pages.tmpl"
if ((tp_ret = rss_tag_item(tp, rt)) == -1) goto err;
}
#line 1313 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</channel></rss>", 16)) == -1) goto err;
err:
return tp_ret;
}
#line 1315 "../gotwebd/pages.tmpl"
int
rss_tag_item(struct template *tp, struct repo_tag *rt)
{
int tp_ret = 0;
#line 1317 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct tm tm;
char rfc822[128];
int r;
char *tag_name = rt->tag_name;
struct gotweb_url tag = {
.action = TAG,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = rt->commit_id,
};
#line 1332 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/tags/", 10) == 0)
tag_name += 10;
#line 1335 "../gotwebd/pages.tmpl"
if (gmtime_r(&rt->tagger_time, &tm) == NULL)
return -1;
r = strftime(rfc822, sizeof(rfc822), "%a, %d %b %Y %H:%M:%S GMT", &tm);
if (r == 0)
return 0;
#line 1342 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<item><title>", 13)) == -1) goto err;
#line 1342 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 1342 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 1342 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 1345 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><link><![CDATA[", 23)) == -1) goto err;
#line 1345 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_absolute_url(c, &tag)) == -1) goto err;
#line 1349 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "]]></link><description><![CDATA[<pre>", 37)) == -1) goto err;
#line 1349 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tag_commit)) == -1)
goto err;
#line 1351 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre>]]></description>", 23)) == -1) goto err;
#line 1351 "../gotwebd/pages.tmpl"
if ((tp_ret = rss_author(tp, rt->tagger)) == -1) goto err;
if ((tp_ret = tp_write(tp, "<guid isPermaLink=\"false\">", 26)) == -1) goto err;
#line 1352 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_id)) == -1)
goto err;
#line 1354 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</guid><pubDate>", 16)) == -1) goto err;
#line 1354 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rfc822)) == -1)
goto err;
#line 1357 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pubDate></item>", 17)) == -1) goto err;
err:
return tp_ret;
}
#line 1359 "../gotwebd/pages.tmpl"
int
rss_author(struct template *tp, char *author)
{
int tp_ret = 0;
#line 1361 "../gotwebd/pages.tmpl"
char *t, *mail;
#line 1363 "../gotwebd/pages.tmpl"
/* what to do if the author name contains a paren? */
if (strchr(author, '(') != NULL || strchr(author, ')') != NULL)
return 0;
#line 1367 "../gotwebd/pages.tmpl"
t = strchr(author, '<');
if (t == NULL)
return 0;
*t = '\0';
mail = t+1;
#line 1373 "../gotwebd/pages.tmpl"
while (isspace((unsigned char)*--t))
*t = '\0';
#line 1376 "../gotwebd/pages.tmpl"
t = strchr(mail, '>');
if (t == NULL)
return 0;
*t = '\0';
#line 1382 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<author>", 8)) == -1) goto err;
#line 1382 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, mail)) == -1)
goto err;
#line 1382 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 1382 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "(", 1)) == -1) goto err;
#line 1382 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, author)) == -1)
goto err;
#line 1384 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, ")</author>", 10)) == -1) goto err;
err:
return tp_ret;
}
