# Awesome Swift
 
<!-- 

PLEASE DO NOT UPDATE THIS FILE, UPDATE CONTENTS.JSON INSTEAD. THANK YOU :-)

 -->



| iOS App | Awesome | Linux | Projects | Updated
| :-: | :-: | :-: | :-: | :-:
| [![Download on the App Store](https://img.shields.io/badge/download-app%20store-ff69b4.svg)](https://itunes.apple.com/us/app/awesome-for-swift-cheatsheet/id1078115427) | [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) |  :penguin: | ![](https://img.shields.io/badge/swift%20projects-985-orange.svg) | February 04, 2018

### Contributing

Please take a quick look at the [contribution guidelines](.github/CONTRIBUTING.md) first. If you see a package or project here that is no longer maintained or is not a good fit, please submit a pull request to improve this file. Thank you to all [contributors](https://github.com/matteocrippa/awesome-swift/graphs/contributors); you rock!!

### Contents

- [Guides](#guides)
  - [Newsletter](#newsletter)
  - [Official Guides](#official-guides)
  - [Style Guides](#style-guides)
  - [Third party Guides](#third-party-guides)
- [Boilerplates](#boilerplates)
- [REPL](#repl)
- [Editor Support](#editor-support)
  - [Emacs](#emacs)
  - [Vim](#vim)
- [Benchmark](#benchmark)
- [Converters](#converters)
- [Demo Apps](#demo-apps)
- [Dependency Managers](#dependency-managers)
- [Patterns](#patterns)
- [Misc](#misc)
- [Libs](#libs)
  - [AI](#ai)
  - [Algorithm](#algorithm)
  - [Analytics](#analytics)
  - [Animation](#animation)
  - [API](#api)
  - [App Routing](#app-routing)
  - [App Store](#app-store)
  - [Audio](#audio)
  - [Augmented Reality](#augmented-reality)
  - [Authentication](#authentication)
  - [Bots](#bots)
  - [Cache](#cache)
  - [Chart](#chart)
  - [Chat](#chat)
  - [Colors](#colors)
  - [Command Line](#command-line)
  - [Concurrency](#concurrency)
  - [Currency](#currency)
  - [Data Management](#data-management)
    - [Core Data](#core-data)
    - [JSON](#json)
    - [Key Value Store](#key-value-store)
    - [MongoDB](#mongodb)
    - [Multi Database](#multi-database)
    - [ORM](#orm)
    - [Other Data](#other-data)
    - [Realm](#realm)
    - [SQL drivers](#sql-drivers)
    - [SQLite](#sqlite)
    - [XML](#xml)
    - [YAML](#yaml)
    - [ZIP](#zip)
  - [Date](#date)
  - [Dependency Injection](#dependency-injection)
  - [Device](#device)
  - [Documentation](#documentation)
  - [Email](#email)
  - [Embedded Systems](#embedded-systems)
    - [Peripherals](#peripherals)
  - [Events](#events)
  - [Files](#files)
  - [Fonts](#fonts)
  - [Game Engine](#game-engine)
    - [2D](#game-engine-2d)
  - [Games](#games)
  - [Gesture](#gesture)
  - [Hardware](#hardware)
    - [3D Touch](#3d-touch)
    - [Bluetooth](#bluetooth)
    - [Camera](#camera)
      - [Barcode](#barcode)
    - [Haptic Feedback](#haptic-feedback)
    - [iBeacon](#ibeacon)
    - [Sensors](#sensors)
  - [Images](#images)
  - [Key Value Coding](#key-value-coding)
  - [Keyboard](#keyboard)
  - [Kit](#kit)
  - [Layout](#layout)
    - [Auto Layout](#auto-layout)
  - [Localization](#localization)
  - [Location](#location)
  - [Logging](#logging)
  - [Maps](#maps)
  - [Math](#math)
  - [Natural Language Processing](#natural-language-processing)
  - [Network](#network)
    - [HTML](#html)
    - [Messaging Protocol](#messaging-protocol)
    - [Socket](#socket)
    - [Webserver](#webserver)
  - [OCR](#ocr)
  - [Optimization](#optimization)
  - [PDF](#pdf)
  - [Quality](#quality)
  - [Scripting](#scripting)
  - [SDK](#sdk)
  - [Security](#security)
    - [Cryptography](#cryptography)
    - [Keychain](#keychain)
  - [Streaming](#streaming)
  - [Styling](#styling)
  - [System](#system)
  - [Testing](#testing)
    - [Mock](#mock)
  - [Text](#text)
  - [Thread](#thread)
  - [UI](#ui)
    - [Alert](#alert)
    - [ApplicationDelegate](#applicationdelegate)
    - [Blur](#blur)
    - [Button](#button)
    - [Calendar](#calendar)
    - [Form](#form)
    - [HUD](#hud)
    - [Label](#label)
    - [Menu](#menu)
    - [Pagination](#pagination)
    - [Payment](#payment)
    - [Permissions](#permissions)
    - [StackView](#stackview)
    - [Switch](#switch)
    - [Tab](#tab)
    - [Template](#template)
    - [TextField](#textfield)
    - [Transition](#transition)
    - [UICollectionView](#uicollectionview)
    - [UITableView](#uitableview)
    - [Walkthrough](#walkthrough)
  - [Utility](#utility)
  - [Validation](#validation)
    - [Phone Numbers](#phone-numbers)
  - [Version Manager](#version-manager)
  - [Video](#video)

## Guides
*An awesome list of Swift related guides.* 

### Newsletter
[back to top](#readme) 

* [Swift Developments](https://andybargh.com/swiftdevelopments/) - A weekly curated newsletter containing for people interested in designing and developing their own iOS, watchOS and Apple TV apps.
* [Swift Newsletter by Natasha the Robot](https://www.natashatherobot.com) - Curated newsletter.
* [Swift Weekly Brief](https://swiftweekly.github.io) - A multi author curated newsletter.
* [WeeklyCocoa.News](https://weeklycocoa.news) - Weekly updated newsletter about iOS, Swift, Objective-C, CocoaTouch, and other Apple connected development technologies.

### Official Guides
[back to top](#readme) 

* [API Design Guidelines](https://swift.org/documentation/api-design-guidelines/) - Official Swift API design guidelines.
* [Apple eBook](https://itunes.apple.com/us/book/swift-programming-language/id881256329?mt=11) - Official Apple eBook for Swift beginners.
* [Getting Started](https://swift.org/getting-started/) - Find information about the how to use the Swift programming language.

### Style Guides
[back to top](#readme) 

* [GitHub](https://github.com/github/swift-style-guide) - Style guide & coding conventions.
* [LinkedIn](https://github.com/linkedin/swift-style-guide) - LinkedIn's Official Style Guide.
* [Raywenderlich](https://github.com/raywenderlich/swift-style-guide) - Raywenderlich guide, a must read.

### Third party Guides
[back to top](#readme) 

* [30 Days of Swift](https://github.com/allenwong/30DaysofSwift) - A cool 30 days tutorial.
* [About Swift](https://github.com/NicolaLancellotti-About/About-Swift) - A playground about the Swift language.
* [Awesome Swift Education](https://github.com/hsavit1/Awesome-Swift-Education) - An organized list of essential Swift Language Topics.
* [Developing iOS Apps with Swift](https://itunes.apple.com/us/course/developing-ios-9-apps-swift/id1104579961) - Stanford course by Paul Hegarty.
* [Hacking With Swift](https://www.hackingwithswift.com) - Complete training course that teaches app development through 30 hands-on projects, for free.
* [Learn Swift](https://github.com/nettlep/learn-swift) - Collection of tuts that will help you learn Swift via playground.
* [Practice Swift](https://github.com/domenicosolazzo/practice-swift) - An interesting guide to learn Swift.
* [Swift Education](https://github.com/swifteducation) - A community of educators sharing materials for teaching Swift and app development.
* [Swift Web Weekly](http://swiftwebweekly.com) - A free, hand-picked list of the best links for Swift Web Developers, every Monday in your inbox.
* [SwiftDoc](http://swiftdoc.org/) - Auto-generated documentation.
* [SwiftGuide CN](https://github.com/ipader/SwiftGuide) - A Chinese written guide.
* [SwiftIntro](https://github.com/Sajjon/SwiftIntro) - Memory game implementation that also teaches Swift.
* [SwiftTips](https://github.com/JohnSundell/SwiftTips) - A collection of useful tips share on Twitter by @JohnSundell.
* [The Swift Web Developer](https://theswiftwebdeveloper.com) - A publication for Swift Web Developers.
* [whats-new-in-swift-4](https://github.com/ole/whats-new-in-swift-4) - An Xcode playground showcasing the new features in Swift 4.0.

## Boilerplates

* [Swift 3 VIPER Module Template](https://github.com/Juanpe/Swift-VIPER-Module) - Xcode template for VIPER Architecture.
* [Swift 4 Module Template](https://github.com/fulldecent/swift4-module-template) - An opinionated starting point for awesome, reusable modules.
* [Webview Boilerplate](https://github.com/nabilfreeman/ios-universal-webview-boilerplate) - Starting point for webview app.

## REPL

* [Online Swift Playground](http://online.swiftplayground.run) - Online Swift Playground.

## Editor Support
*Support for your favorite editors.* 

### Emacs
[back to top](#readme) 

* [swift-mode](https://github.com/swift-emacs/swift-mode) - Emacs support, including partial flycheck error support.

### Vim
[back to top](#readme) 

* [swift-vim](https://github.com/keith/swift.vim) - Vim runtime files.
* [vim-polyglot](https://github.com/sheerun/vim-polyglot) - Language pack for vim that includes vim-swift.

## Benchmark

* [Benchmark](https://github.com/WorldDownTown/Benchmark) - Provides methods to measure and report the time used to execute code.
* [xcprofiler](https://github.com/giginet/xcprofiler) - Command line utility to profile compilation time.

## Converters

* [Swiftify](https://objectivec2swift.com) - Objective-C to Swift online code converter and Xcode extension.

## Demo Apps
*Check out apps on these projects:* 
* [awesome-macOS](https://github.com/iCHAIT/awesome-macOS) - A curated list of awesome applications, softwares, tools and shiny things for macOS.
* [open-source-ios-apps](https://github.com/dkhamsing/open-source-ios-apps) - A collaborative list of open-source iOS Apps.

## Dependency Managers
*Dependency manager software for Swift.* 
* [Carthage](https://github.com/Carthage/Carthage) - A new dependency manager.
* [CocoaPods](https://github.com/CocoaPods/CocoaPods) - The most used dependency manager.
* [Mint](https://github.com/yonaskolb/Mint) - A package manager that installs and runs Swift command line tools.
* [swift-package-manager](https://github.com/apple/swift-package-manager) - SPM is the Package Manager for the Swift Programming Language.

## Patterns

* [Design-Patterns-In-Swift](https://github.com/ochococo/Design-Patterns-In-Swift) - Design Patterns.

## Misc
*Miscellaneous Swift related projects* 
* [Beak](https://github.com/yonaskolb/Beak) - A command line interface for your Swift scripts.
* [generator-swift-framework](https://github.com/cybertk/generator-swift-framework) - Scaffolds out a Xcode framework project.
* [InteractivePlayground](https://github.com/dasdom/InteractivePlayground) - A playground exploring the interactivity of Xcode 7.3 playgrounds.
* [MAIKit](https://github.com/MichaelBuckley/MAIKit) - A framework for sharing code between iOS and OS X.
* [sbconstants](https://github.com/paulsamuels/SBConstants) - A nifty tool to generate constants file by grabbing identifiers from storyboards in a project.
* [SwagGen](https://github.com/yonaskolb/SwagGen) :penguin: - A command line tool for generating a REST API from a Swagger spec based off Stencil templates.
* [swift-compiler-crashes](https://github.com/practicalswift/swift-compiler-crashes) - A collection of test cases crashing the compiler.
* [SwiftGen](https://github.com/SwiftGen/SwiftGen) - A suite of tools to auto-generate code for various assets of your project.
* [SwiftPlate](https://github.com/JohnSundell/SwiftPlate) - Easily generate cross platform framework projects from the command line.
* [Toybox](https://github.com/giginet/Toybox) - Xcode Playground management made easy.
* [XcodeGen](https://github.com/yonaskolb/XcodeGen) - Tool for generating Xcode projects from a YAML file and your project directory.

## Libs
*Here you can find a list of snippets and libs for your Swift projects.* 

### AI
*Libs for AI based projects (Machine Learning, Neural Networks etc).* [back to top](#readme) 

* [BrainCore](https://github.com/aleph7/BrainCore) - The iOS and OS X neural network framework.
* [CoreML-Models](https://github.com/likedan/Awesome-CoreML-Models) - A collection of unique Core ML Models.
* [MLKit](https://github.com/Somnibyte/MLKit) - A simple machine learning framework.
* [Swift-AI](https://github.com/Swift-AI/Swift-AI) - The machine learning library.

### Algorithm
[back to top](#readme) 

* [Algorithm](https://github.com/CosmicMind/Algorithm) - A toolset for writing algorithms and probability models.
* [swift-algorithm-club](https://github.com/raywenderlich/swift-algorithm-club) - Algorithms and data structures, with explanations.
* [SwiftLCS](https://github.com/Frugghi/SwiftLCS) :penguin: - implementation of the longest common subsequence (LCS) algorithm.

### Analytics
*Analytics related libraries to easily track your app usage* [back to top](#readme) 

* [Umbrella](https://github.com/devxoul/Umbrella) - Analytics abstraction layer.

### Animation
*Libs to help with animation* [back to top](#readme) 

* [Advance](https://github.com/timdonnelly/Advance) - A powerful animation framework for iOS, tvOS, and OS X.
* [AnimatedCollectionViewLayout](https://github.com/KelvinJin/AnimatedCollectionViewLayout) :penguin: - A UICollectionViewLayout subclass that adds custom transitions/animations to the UICollectionView without affecting your existing code.
* [Animo](https://github.com/eure/Animo) - SpriteKit-like animation builders for CALayers.
* [ChainPageCollectionView](https://github.com/jindulys/ChainPageCollectionView) - Fancy two-level collection view layout and animation.
* [Cheetah](https://github.com/suguru/Cheetah) - An animation library on iOS.
* [Dance](https://github.com/saoudrizwan/Dance) - A radical & elegant animation library built for iOS.
* [DKChainableAnimationKit](https://github.com/Draveness/DKChainableAnimationKit) - Easy to read and write chainable animations.
* [DSGradientProgressView](https://github.com/DholStudio/DSGradientProgressView) - DSGradientProgressView is a simple and customizable animated progress bar.
* [Ease](https://github.com/roberthein/Ease) - Animate everything with Ease.
* [EasyAnimation](https://github.com/icanzilb/EasyAnimation) - A library to take the power of UIView.animateWithDuration(_:, animations:...) to a whole new level.
* [FlightAnimator](https://github.com/AntonTheDev/FlightAnimator) - Natural Blocks Based Core Animation Framework.
* [Gemini](https://github.com/shoheiyokoyama/Gemini) - Gemini is rich scroll based animation framework.
* [IBAnimatable](https://github.com/IBAnimatable/IBAnimatable) - Design and prototype UI, interaction, navigation, transition and animation for App Store ready Apps in Interface Builder with IBAnimatable.
* [Interpolate](https://github.com/marmelroy/Interpolate) - Interpolation framework for creating interactive gesture-driven animations.
* [JDAnimationKit](https://github.com/JellyDevelopment/JDAnimationKit) - Animate easy and with less code.
* [Kinieta](https://github.com/mmick66/kinieta) - An simple Animation Engine for iOS with an Intuitive API and Readable Code
* [Morgan](https://github.com/RamonGilabert/Morgan) - An always growing animation set.
* [Pastel](https://github.com/cruisediary/Pastel) - Gradient animation effect like Instagram.
* [Presentation](https://github.com/hyperoslo/Presentation) - A library to help you to make tutorials, release notes and animated pages.
* [Pulsator](https://github.com/shu223/pulsator) - Pulse animation for iOS.
* [Spring](https://github.com/MengTo/Spring) - A library to simplify iOS animations.
* [spruce-ios](https://github.com/willowtreeapps/spruce-ios) - Choreograph animations on the screen.
* [Stellar](https://github.com/AugustRush/Stellar) - A Physical animation library.
* [SwiftyAnimate](https://github.com/rchatham/SwiftyAnimate) - Composable animations.
* [ViewAnimator](https://github.com/marcosgriselli/ViewAnimator) - Brings your UI to life with just one line.
* [Walker](https://github.com/RamonGilabert/Walker) - An animation engine to make your animations easy and more readable.
* [YapAnimator](https://github.com/yapstudios/YapAnimator) - Your fast and friendly physics-based animation system.
* [ZoomTransitioning](https://github.com/WorldDownTown/ZoomTransitioning) - A custom transition with image zooming animation.

### API
*Quick libs to get access to third party API services* [back to top](#readme) 

* [Federal Data SDK](https://github.com/USDepartmentofLabor/Swift-Federal-Data-SDK) - Eases access to multiple federal government OpenGov APIs.
* [GithubPilot](https://github.com/jindulys/GithubPilot) - Github API V3 wrapper.
* [GooglePlacesAutocomplete](https://github.com/watsonbox/ios_google_places_autocomplete) - Simple Google Places address entry for iOS.
* [PXGoogleDirections](https://github.com/poulpix/PXGoogleDirections) - Google Directions API helper.
* [RandomUserSwift](https://github.com/dingwilson/RandomUserSwift) - Framework to Generate Random Users - An Unofficial SDK for randomuser.me
* [reddift](https://github.com/sonsongithub/reddift) - reddit API wrapper.
* [Swifter Twitter](https://github.com/mattdonnelly/Swifter) - Twitter framework.
* [SwiftInstagram](https://github.com/AnderGoig/SwiftInstagram) - Instagram API wrapper.
* [SwiftlySalesforce](https://github.com/mike4aday/SwiftlySalesforce) - Framework for rapid development of native iOS apps that integrate with Salesforce.

### App Routing
*Internal app routing systems.* [back to top](#readme) 

* [Appz](https://github.com/SwiftKitz/Appz) - Launch external apps and deeplink with ease.
* [Compass](https://github.com/hyperoslo/Compass) - Compass helps you setup a central navigation system for your application.
* [RxFlow](https://github.com/RxSwiftCommunity/RxFlow) - RxFlow is a navigation framework for iOS applications based on a Reactive Flow Coordinator pattern.
* [SwiftRouter](https://github.com/skyline75489/SwiftRouter) - A URL Router for iOS.
* [URLNavigator](https://github.com/devxoul/URLNavigator) - Elegant URL Routing.

### App Store
*Libs to help with apple app store, in app purchases and receipt validation.* [back to top](#readme) 

* [InAppFw](https://github.com/sandorgyulai/InAppFramework) - In App Purchase Manager framework.
* [InAppPurchase](https://github.com/jinSasaki/InAppPurchase) - A Simple, Lightweight and Safe framework for In App Purchase.
* [SwiftyStoreKit](https://github.com/bizz84/SwiftyStoreKit) - Lightweight In App Purchases framework.

### Audio
*Libs to work with audio* [back to top](#readme) 

* [AudioKit](https://github.com/audiokit/AudioKit) - Powerful audio synthesis, processing and analysis, without the steep learning curve.
* [AudioPlayer](https://github.com/delannoyk/AudioPlayer) - A wrapper around AVPlayer with some cool features.
* [AudioPlayerSwift](https://github.com/tbaranes/AudioPlayerSwift) - AudioPlayer is a simple class for playing audio (basic and advanced usage) in iOS, OS X and tvOS apps.
* [Beethoven](https://github.com/vadymmarkov/Beethoven) - An audio processing library for pitch detection of musical signals.
* [MusicKit](https://github.com/benzguo/MusicKit) - A framework for composing and transforming music.
* [SwiftySound](https://github.com/adamcichy/SwiftySound) - Simple library that lets you play sounds with a single line of code.
* [TuningFork](https://github.com/comyar/TuningFork) - A Simple Tuner for iOS.

### Augmented Reality
[back to top](#readme) 

* [ARCharts](https://github.com/Boris-Em/ARCharts) - Lovely Augmented Reality Charts for iOS - Built with ARKit
* [ARKit-CoreLocation](https://github.com/ProjectDent/ARKit-CoreLocation) - Combines the high accuracy of AR with the scale of GPS data.
* [ARKit-Navigation](https://github.com/chriswebb09/ARKitNavigationDemo) - Navigation in augmented reality with MapKit.
* [ARVoxelKit](https://github.com/VoxxxelAR/ARVoxelKit) - Voxel graphic framework using ARKit

### Authentication
*Easy way to manage auth in your apps.* [back to top](#readme) 

* [Cely](https://github.com/chaione/Cely) - A Plug-n-Play login framework.
* [InstagramLogin](https://github.com/AnderGoig/InstagramLogin) - Simple way to authenticate Instagram accounts.
* [LoginKit](https://github.com/IcaliaLabs/LoginKit) - LoginKit is a quick and easy way to add a Login/Signup UX to your iOS app.
* [ReCaptcha](https://github.com/fjcaetano/ReCaptcha) - [In]visible ReCaptcha for iOS.
* [Simplicity](https://github.com/SimplicityMobile/Simplicity) - A simple way to implement Facebook and Google login in your iOS and OS X apps.
* [SpotifyLogin](https://github.com/spotify/SpotifyLogin) - Authenticate with the Spotify API.
* [Voucher](https://github.com/rsattar/Voucher) - A simple library to make authenticating tvOS apps easy via their iOS counterparts.

### Bots
*Libs to build bot* [back to top](#readme) 

* [Telegram Bot SDK](https://github.com/zmeyc/telegram-bot-swift) :penguin: - Unofficial SDK.

### Cache
[back to top](#readme) 

* [AwesomeCache](https://github.com/aschuch/AwesomeCache) - Manage cache easy.
* [Cache](https://github.com/hyperoslo/Cache) - Nothing but Cache.
* [Cachyr](https://github.com/YR/Cachyr) - A small key-value data cache for iOS, macOS and tvOS.
* [Carlos](https://github.com/WeltN24/Carlos) - A simple but flexible cache.
* [EVURLCache](https://github.com/evermeer/EVURLCache) - If you want to make your app still works when it's offline.
* [SwiftMemCache](https://github.com/ctews/SwiftMemCache) - Memory Cache with namespace & TTL support.

### Chart
[back to top](#readme) 

* [Charts](https://github.com/danielgindi/Charts) - Beautiful charts for iOS/tvOS/OSX (port of MPAndroidChart).
* [PNChart-Swift](https://github.com/kevinzhow/PNChart-Swift) - A simple and beautiful chart lib with animation.
* [ScrollableGraphView](https://github.com/philackm/ScrollableGraphView) - Adaptive scrollable graph view for iOS to visualise simple discrete datasets.
* [SwiftChart](https://github.com/gpbl/SwiftChart) - A simple line and area charting library for iOS. Supports multiple series, partially filled series and touch events.
* [SwiftCharts](https://github.com/i-schuetz/SwiftCharts) - Highly customizable charts for iOS.
* [TKRadarChart](https://github.com/TBXark/TKRadarChart) - A customizable radar chart.

### Chat
*Libs to get access to build chat app* [back to top](#readme) 

* [Chatto](https://github.com/badoo/Chatto) - A lightweight framework to build chat applications.
* [MessageKit](https://github.com/MessageKit/MessageKit) - A community-driven replacement for JSQMessagesViewController.

### Colors
*Interesting snippets related to color management and utility.* [back to top](#readme) 

* [Chameleon](https://github.com/ViccAlexander/Chameleon) - Chameleon is a lightweight, yet powerful, color framework for iOS.
* [ChromaColorPicker](https://github.com/joncardasis/ChromaColorPicker) - An intuitive and fun iOS color picker.
* [Colorify](https://github.com/czater/Colorify) - Colorify - simple, yet powerful color library.
* [Colors](https://github.com/icodeforlove/Colors) - Library for using ANSI codes.
* [CSS3ColorsSwift](https://github.com/WorldDownTown/CSS3ColorsSwift) - A UIColor extension with CSS3 Colors name.
* [DynamicColor](https://github.com/yannickl/DynamicColor) - An extension to manipulate colors easily.
* [FlatUIColors](https://github.com/brynbellomy/FlatUIColors) - Flat UI color palette.
* [Google Material Color](https://github.com/katopz/google-material-color-swift) - Google Material Color Palette.
* [HexColor](https://github.com/artman/HexColor) - Define UIColors as Hex integers.
* [Hue](https://github.com/hyperoslo/Hue) - Hue is the all-in-one coloring utility that you'll ever need.
* [PrettyColors](https://github.com/jdhealy/PrettyColors) - Styles and colors text in the Terminal with ANSI escape codes. Conforms to ECMA Standard 48.
* [RandomColorSwift](https://github.com/onevcat/RandomColorSwift) - An attractive color generator (ported from randomColor.js).
* [SwiftGen-Colors](https://github.com/SwiftGen/SwiftGen#uicolor) - A tool to auto-generate Swift `enums` for your `UIColor` constants.
* [SwiftHEXColors](https://github.com/thii/SwiftHEXColors) - HEX color handling as an extension for UIColor.
* [UIColor-Hex-Swift](https://github.com/yeahdongcn/UIColor-Hex-Swift) - Hex to UIColor converter.
* [UIColor-WikiColors](https://github.com/nahive/UIColor-WikiColors) - All wikipedia colors implemented as easy to use UIColor extension.
* [UIGradient](https://github.com/dqhieu/UIGradient) - A simple and powerful library for using gradient layer, image, color

### Command Line
*Create command line applications.* [back to top](#readme) 

* [Commander](https://github.com/kylef/Commander) :penguin: - Compose beautiful command line interfaces.
* [CommandLine](https://github.com/jatoben/CommandLine) :penguin: - Library for creating command-line interfaces.
* [Progress.swift](https://github.com/jkandzi/Progress.swift) :penguin: - Add beautiful progress bars to your command line.
* [SwiftCLI](https://github.com/jakeheis/SwiftCLI) :penguin: - A powerful framework that can be used to develop a CLI.
* [Swiftline](https://github.com/nsomar/Swiftline) - A set of tools to help you create command line applications.
* [SwiftyTextTable](https://github.com/scottrhoyt/SwiftyTextTable) :penguin: - A lightweight library to generate text tables.
* [TextTable](https://github.com/cfilipov/TextTable) - Easily print textual tables. Inspired by the Python tabulate library.

### Concurrency
*Easier ways to work with concurrency.* [back to top](#readme) 

* [AsyncNinja](https://github.com/AsyncNinja/AsyncNinja) - A complete set of concurrency and reactive programming primitives.
* [GroupWork](https://github.com/quanvo87/GroupWork) :penguin: - Easy concurrent, asynchronous tasks.
* [Hydra](https://github.com/malcommac/Hydra) - Promises & Await - Write better async code.
* [Kommander](https://github.com/intelygenz/Kommander-iOS) - Manage the task execution in different threads through Kommands.
* [Overdrive](https://github.com/arikis/Overdrive) - Fast async task based API with focus on type safety, concurrency and multi threading.
* [Queuer](https://github.com/FabrizioBrancati/Queuer) :penguin: - A queue manager, built on top of OperationQueue and Dispatch (aka GCD).
* [Safe](https://github.com/tidwall/Safe) - Modern Concurrency and Synchronization.
* [Threadly](https://github.com/nvzqz/Threadly) :penguin: - Type-safe thread-local storage.
* [Venice](https://github.com/Zewo/Venice) :penguin: - Communicating sequential processes (CSP), Linux ready.

### Currency
[back to top](#readme) 

* [Money](https://github.com/danthorpe/Money) - Currency formatter.

### Data Management
[back to top](#readme) 


#### Core Data
*No more pain with Core Data, here are some interesting libs to handle data management.* [back to top](#readme) 

* [AERecord](https://github.com/tadija/AERecord) - Super awesome Core Data wrapper library for iOS.
* [AlecrimCoreData](https://github.com/Alecrim/AlecrimCoreData) - Simple Core Data wrapper library.
* [Cadmium](https://github.com/jmfieldman/cadmium) - Framework that hides the complexity of managed object contexts.
* [CoreStore](https://github.com/JohnEstropia/CoreStore) - simple and elegant way to handle Core Data.
* [CoreValue](https://github.com/terhechte/CoreValue) - Lightweight Framework for using Core Data with Value Types.
* [DataKernel](https://github.com/mrdekk/DataKernel) - DataKernel is a minimalistic wrapper around Core Data stack to ease persistence operations. No external dependencies.
* [Graph](https://github.com/CosmicMind/Graph) - An elegant data-driven framework for Core Data.
* [JSQCoreDataKit](https://github.com/jessesquires/JSQCoreDataKit) - A swifter Core Data stack.
* [JustPersist](https://github.com/justeat/JustPersist) - Easiest and safest way to do persistence on iOS with Core Data support out of the box.
* [QueryKit](https://github.com/QueryKit/QueryKit) - An easy way to play with Core Data filtering.
* [Skopelos](https://github.com/albertodebortoli/Skopelos) - A minimalistic, thread safe, non-boilerplate and super easy to use version of Active Record on Core Data.
* [SugarRecord](https://github.com/carambalabs/SugarRecord) - Helps with Core Data and Realm.
* [SuperRecord](https://github.com/michaelarmstrong/SuperRecord) - A small set of utilities to make working with Core Data a bit easier.

#### JSON
*Struggling using json data? Here are some interesting ways to handle it.* [back to top](#readme) 

* [AlamofireJsonToObjects](https://github.com/evermeer/AlamofireJsonToObjects) - An Alamofire extension which converts JSON response data into objects using Reflection.
* [AlamofireObjectMapper](https://github.com/tristanhimmelman/AlamofireObjectMapper) - An Alamofire extension which converts JSON response data into objects using ObjectMapper.
* [Alembic](https://github.com/ra1028/Alembic) - Functional JSON parsing, mapping to objects, and serialize to JSON.
* [Alexander](https://github.com/hodinkee/alexander) - An extremely simple JSON helper.
* [Argo](https://github.com/thoughtbot/Argo) - JSON parsing library.
* [Arrow](https://github.com/freshOS/Arrow) - Elegant JSON Parsing.
* [Brick](https://github.com/hyperoslo/Brick) - A generic view model for both basic and complex scenarios.
* [Decodable](https://github.com/Anviking/Decodable) :penguin: - JSON parsing.
* [Elevate](https://github.com/Nike-Inc/Elevate) - JSON parsing framework that makes parsing simple, reliable and composable.
* [EVReflection](https://github.com/evermeer/EVReflection) - Reflection based JSON encoding and decoding. Including support for NSDictionary, NSCoding, Printable, Hashable and Equatable
* [Freddy](https://github.com/bignerdranch/Freddy) - A reusable framework for parsing JSON.
* [Genome](https://github.com/LoganWright/Genome) - A simple, type safe, failure driven mapping library for serializing JSON to models.
* [Gloss](https://github.com/hkellaway/Gloss) :penguin: - Shiny JSON parsing library.
* [HandyJSON](https://github.com/alibaba/handyjson) - A handy swift JSON-object serialization/deserialization library.
* [Himotoki](https://github.com/ikesyo/Himotoki) - A type-safe JSON decoding library.
* [JASON](https://github.com/delba/JASON) - JSON parsing with outstanding performances and convenient operators.
* [json-swift](https://github.com/owensd/json-swift) - A basic library for working with JSON.
* [JSONCodable](https://github.com/matthewcheok/JSONCodable) - Hassle-free JSON encoding and decoding.
* [JSONFeed](https://github.com/wesbillman/JSONFeed) - JSONFeed parser with built in reader for jsonfeed.org.
* [JSONHelper](https://github.com/isair/JSONHelper) - Lightning fast JSON deserialization and value conversion library for iOS & OS X.
* [JSONNeverDie](https://github.com/johnlui/JSONNeverDie) - Auto reflection tool from JSON to Model, user friendly JSON encoder / decoder, aims to never die.
* [ModelRocket](https://github.com/ovenbits/ModelRocket) - An iOS framework for creating JSON-based models.
* [ObjectMapper](https://github.com/Hearst-DD/ObjectMapper) - JSON object mapper.
* [Pistachio](https://github.com/felixjendrusch/Pistachio) - Generic model framework.
* [SwiftyJSON](https://github.com/SwiftyJSON/SwiftyJSON) - A lib for JSON with error handling.
* [SwiftyJSONAccelerator](https://github.com/insanoid/SwiftyJSONAccelerator) - OSX app to generate models for JSON.
* [Tailor](https://github.com/zenangst/Tailor) - A super fast & convenient object mapper tailored for your needs.
* [Unbox](https://github.com/JohnSundell/Unbox) - The easy to use JSON decoder.

#### Key Value Store
[back to top](#readme) 

* [Default](https://github.com/Nirma/Default) - Modern interface to UserDefaults + Codable support
* [DefaultsKit](https://github.com/nmdias/DefaultsKit) - Simple, Strongly Typed UserDefaults for iOS, macOS and tvOS.
* [Palau](https://github.com/symentis/Palau) - Typesafe NSUserDefaults with custom rules.
* [Prephirences](https://github.com/phimage/Prephirences) - Manage application preferences, NSUserDefaults, iCloud, Keychain and more.
* [Storez](https://github.com/SwiftKitz/Storez) - Safe, statically-typed, store-agnostic key-value storage.
* [SwiftStore](https://github.com/hemantasapkota/SwiftStore) - A Key-Value store backed by LevelDB.
* [SwiftyUserDefaults](https://github.com/radex/SwiftyUserDefaults) - Cleaner, nicer syntax for NSUserDefaults.
* [Zephyr](https://github.com/ArtSabintsev/Zephyr) - Effortlessly synchronize NSUserDefaults over iCloud.

#### MongoDB
[back to top](#readme) 

* [MongoKitten](https://github.com/OpenKitten/MongoKitten) :penguin: - MongoDB Connector.
* [Perfect-MongoDB](https://github.com/PerfectlySoft/Perfect-MongoDB) :penguin: - A stand-alone wrapper around the mongo-c client library, enabling access to MongoDB servers.
* [SwiftMongoDB](https://github.com/Danappelxx/SwiftMongoDB) - MongoDB connector.

#### Multi Database
*Data management layers that involve multiple sources.* [back to top](#readme) 

* [StorageKit](https://github.com/StorageKit/StorageKit) - Your Data Storage Troubleshooter 🛠

#### ORM
[back to top](#readme) 

* [fluent](https://github.com/vapor/fluent) :penguin: - Simple ActiveRecord implementation.

#### Other Data
*Other ways to persist data* [back to top](#readme) 

* [CSVParser](https://github.com/Nero5023/CSVParser) :penguin: - Fast parser for CSV.
* [EVCloudKitDao](https://github.com/evermeer/EVCloudKitDao) - Simplified access to CloudKit with support for subscriptions and local caching.
* [LeetCode-Swift](https://github.com/soapyigu/LeetCode-Swift) - Solutions to LeetCode interview questions.
* [Pencil](https://github.com/naru-jpn/pencil) - Write any value to file.

#### Realm
[back to top](#readme) 

* [Realm](https://github.com/realm/realm-cocoa) - Realm is a mobile database: a replacement for Core Data & SQLite.
* [Realm+JSON](https://github.com/matthewcheok/Realm-JSON) - A concise Mantle-like way of working with Realm and JSON.

#### SQL drivers
[back to top](#readme) 

* [MySQL Swift](https://github.com/novi/mysql-swift) :penguin: - MySQL client library.
* [Perfect-MySQL](https://github.com/PerfectlySoft/Perfect-MySQL) :penguin: - A stand-alone wrapper around the MySQL client library, enabling access to MySQL servers.
* [Perfect-PostgreSQL](https://github.com/PerfectlySoft/Perfect-PostgreSQL) :penguin: - A stand-alone wrapper around the libpq client library, enabling access to PostgreSQL servers.

#### SQLite
*Are you interested in storing your app data using SQLite? Here are some interesting resources.* [back to top](#readme) 

* [GRDB.swift](https://github.com/groue/GRDB.swift) - A versatile SQLite toolkit.
* [SQLite.swift](https://github.com/stephencelis/SQLite.swift) - Framework wrapping SQLite3. Small. Simple. Safe.
* [SQLiteDB](https://github.com/FahimF/SQLiteDB) - SQLite wrapper.
* [SwiftData](https://github.com/ryanfowler/SwiftData) - Simple and Effective SQLite Handling.

#### XML
*If you prefer to manage XML data formatted entries, here are some helpful libs* [back to top](#readme) 

* [AEXML](https://github.com/tadija/AEXML) - xml wrapper.
* [AlamofireXmlToObjects](https://github.com/evermeer/AlamofireXmlToObjects) - An Alamofire extension for fetching an XML feed and parsing it into objects.
* [CheatyXML](https://github.com/lobodart/CheatyXML) - A powerful framework designed to manage XML easily.
* [SwiftyXML](https://github.com/chenyunguiMilook/SwiftyXML) - The most swifty way to deal with XML.
* [SWXMLHash](https://github.com/drmohundro/SWXMLHash) - Simple XML parsing.
* [XMLParser](https://github.com/Mozharovsky/XMLParser) - A lightweight XMLParser for assembling and parsing XML values written for iOS 8+.

#### YAML
[back to top](#readme) 

* [YamlSwift](https://github.com/behrang/YamlSwift) - Load YAML and JSON documents.
* [Yams](https://github.com/jpsim/Yams) :penguin: - Sweet YAML parser.

#### ZIP
[back to top](#readme) 

* [Zip](https://github.com/marmelroy/Zip) - Framework for zipping and unzipping files.
* [Zip Foundation](https://github.com/weichsel/ZIPFoundation) - A library to create, read and modify ZIP archive files.

### Date
*Handle data formatting easily.* [back to top](#readme) 

* [AnyDate](https://github.com/Kawoou/AnyDate) - Date & Time API inspired from Java 8 DateTime API.
* [Chronology](https://github.com/davedelong/Chronology) - Building a better date/time library.
* [DateHelper](https://github.com/melvitax/DateHelper) - Simple date helper.
* [Datez](https://github.com/SwiftKitz/Datez) - Library for dealing with `NSDate`, `NSCalendar`, `NSDateComponents`, and `NSTimeInterval`.
* [Datify](https://github.com/hemangshah/Datify) - Easypeasy date functions.
* [NSDate-Extensions](https://github.com/erica/NSDate-Extensions) - Practical real-world dates.
* [Punctual.swift](https://github.com/harlanhaskins/Punctual.swift) :penguin: - Date handler.
* [SwiftDate](https://github.com/malcommac/SwiftDate) - Easy NSDate Management.
* [SwiftMoment](https://github.com/akosma/SwiftMoment) - A time and calendar manipulation library.
* [Time](https://github.com/dreymonde/Time) - Type-safe time calculations, powered by generics.
* [Timepiece](https://github.com/naoty/Timepiece) - Intuitive NSDate extensions.
* [TrueTime.swift](https://github.com/instacart/TrueTime.swift) - Get the true current time impervious to device clock time changes (NTP library).

### Dependency Injection
*Dependency injection libs* [back to top](#readme) 

* [Cleanse](https://github.com/square/Cleanse) - A Lightweight Dependency Injection Framework by Square.
* [Corridor](https://github.com/symentis/Corridor) - A Coreader-like Dependency Injection μFramework.
* [Dip](https://github.com/AliSoftware/Dip) - A simple Dependency Injection Container.
* [Swinject](https://github.com/Swinject/Swinject) - A dependency injection framework.
* [Typhoon](https://github.com/appsquickly/Typhoon) - Dependency injection toolkit.

### Device
*A collection of libs to recognize your device.* [back to top](#readme) 

* [Device](https://github.com/Ekhoo/Device) - Light weight tool for detecting the current device and screen size.
* [Device.swift](https://github.com/schickling/Device.swift) - Super-lightweight library to detect used device.
* [DeviceKit](https://github.com/dennisweissmann/DeviceKit) - DeviceKit is a value-type replacement of UIDevice.
* [Luminous](https://github.com/andrealufino/Luminous) - Get everything you need to know about the device.
* [Thingy](https://github.com/bojan/Thingy) - A modern device detection and querying library.
* [UIDeviceComplete](https://github.com/Nirma/UIDeviceComplete) - UIDevice extensions that fill in the missing pieces.

### Documentation
*Generate documentation for Swift code* [back to top](#readme) 

* [jazzy](https://github.com/realm/jazzy/) - Soulful docs.
* [SourceDocs](https://github.com/eneko/SourceDocs/) - Generate Markdown reference documentation that lives with your code.
* [swiftdoc-parser](https://github.com/SwiftDocOrg/swiftdoc-parser) - SwiftDoc.org header parsing and HTML generating utilities.

### Email
[back to top](#readme) 

* [Hedwig](https://github.com/onevcat/Hedwig) :penguin: - Send email to any SMTP server like a boss.

### Embedded Systems
*Build your embedded Linux projects on a RaspberryPi, BeagleBone, C.H.I.P. and other boards.* [back to top](#readme) 

* [SMBus-swift](https://github.com/Sephiroth87/SMBus-swift) :penguin: - Communicate with SMBus/I2C devices.
* [SwiftyGPIO](https://github.com/uraimo/SwiftyGPIO) :penguin: - Interact with Linux GPIO/SPI/PWM on ARM.

#### Peripherals
*Interact with specific external peripherals.* [back to top](#readme) 

* [5110LCD_PCD8544.swift](https://github.com/uraimo/5110LCD_PCD8544.swift) :penguin: - Nokia3310/5110 PCD8544 Monochrome LCD display library.

### Events
*Alternatives to NSNotificationCenter, Key-Value-Observation, or delegation.* [back to top](#readme) 

* [Aftermath](https://github.com/hyperoslo/Aftermath) - Stateless message-driven micro-framework.
* [Bond](https://github.com/ReactiveKit/Bond) - Binding framework.
* [BrightFutures](https://github.com/Thomvis/BrightFutures) - Promise and future lib.
* [Caravel](https://github.com/coshx/caravel) - Event bus for UIWebView and JS.
* [EmitterKit](https://github.com/aleclarson/emitter-kit) - Implementation of event emitters and listeners.
* [Forbind](https://github.com/ulrikdamm/Forbind) - Functional chaining and Promises.
* [Future](https://github.com/nghialv/Future) - A micro framework providing Future<T, Error>.
* [FutureKit](https://github.com/FutureKit/FutureKit) - Future/Promises Library.
* [Katana](https://github.com/BendingSpoons/katana-swift) - Write apps a la React and Redux.
* [NoticeObserveKit](https://github.com/marty-suzuki/NoticeObserveKit) - NoticeObserveKit is type-safe NotificationCenter wrapper that associates notice type with info type.
* [Notificationz](https://github.com/SwiftKitz/Notificationz) - Helping you own `NSNotificationCenter` by providing a simple, customizable adapter.
* [Observable](https://github.com/roberthein/Observable) - The easiest way to observe values.
* [PromiseKit](https://github.com/mxcl/PromiseKit) - Async promise programming lib.
* [ReactiveCocoa](https://github.com/ReactiveCocoa/ReactiveCocoa) - ReactiveCocoa (RAC) is a Cocoa framework inspired by Functional Reactive Programming. It provides APIs for composing and transforming streams of values over time.
* [Reactor](https://github.com/MailOnline/Reactor) - Powering your RAC architecture.
* [ReactorKit](https://github.com/ReactorKit/ReactorKit) - A framework for reactive and unidirectional application architecture.
* [ReduxSwift](https://github.com/lsunsi/ReduxSwift) - Predictable state container.
* [ReSwift](https://github.com/ReSwift/ReSwift) - Unidirectional Data Flow.
* [RxSwift](https://github.com/ReactiveX/RxSwift) - Microsoft Reactive Extensions (Rx) for Swift and iOS/OSX platform.
* [SignalKit](https://github.com/yankodimitrov/SignalKit) - Event and binding framework.
* [Signals](https://github.com/artman/Signals) - Replaces delegates and notifications.
* [Snail](https://github.com/UrbanCompass/Snail) - An Observables framework.
* [SwiftEventBus](https://github.com/cesarferreira/SwiftEventBus) - A publish/subscribe event bus optimized for iOS.
* [VueFlux](https://github.com/ra1028/VueFlux) - Unidirectional Data Flow State Management Architecture - Inspired by Vuex and Flux.
* [When](https://github.com/vadymmarkov/When) - A lightweight implementation of Promises.

### Files
[back to top](#readme) 

* [FileBrowser](https://github.com/marmelroy/FileBrowser) - Powerful file browser for iOS.
* [FileKit](https://github.com/nvzqz/FileKit) - Simple and expressive file management.
* [FileProvider](https://github.com/amosavian/FileProvider) - FileManager replacement for Local, iCloud and Remote (WebDAV/FTP/Dropbox/OneDrive/SMB2) files for iOS/tvOS and macOS.
* [KZFileWatchers](https://github.com/krzysztofzablocki/KZFileWatchers) - A micro-framework for observing file changes, both local and remote.
* [PathKit](https://github.com/kylef/PathKit) :penguin: - Effortless path operations.
* [SKQueue](https://github.com/daniel-pedersen/SKQueue) - Monitor changes to files and directories using kernel event notifications (kqueue).

### Fonts
*A collection of font related snippets.* [back to top](#readme) 

* [FontAwesome.swift](https://github.com/thii/FontAwesome.swift) - Use FontAwesome in your projects.
* [FontBlaster](https://github.com/ArtSabintsev/FontBlaster) - Programmatically load custom fonts into your iOS app.
* [GoogleMaterialDesignIcons](https://github.com/dekatotoro/GoogleMaterialDesignIcons) - Google Material Design Icons Font for iOS.
* [GoogleMaterialIconFont](https://github.com/kitasuke/GoogleMaterialIconFont) - Google Material Icon Font.
* [Inkwell](https://github.com/ninjaprox/Inkwell) - An inkwell to use custom fonts on the fly.
* [IoniconsKit](https://github.com/keitaoouchi/IoniconsKit) - Use ionicons as UIImage / UIFont in your projects.
* [OcticonsKit](https://github.com/keitaoouchi/OcticonsKit) - Use Octicons as UIImage / UIFont in your projects.
* [OpenSansSwift](https://github.com/hemantasapkota/OpenSansSwift) - OpenSans.
* [Swicon](https://github.com/UglyTroLL/Swicon) - Use 1600+ icons from FontAwesome and Google Material Icons (and even your own customized icons) in your project.
* [SwiftFontName](https://github.com/morizotter/SwiftFontName) - OS font complements library. Localized font supported.
* [SwiftIconFont](https://github.com/0x73/SwiftIconFont) - Fontawesome, Iconic, Ionicons, Octicon ports.
* [SwiftIcons](https://github.com/ranesr/SwiftIcons) - Library for Font Icons: dripicons, emoji, font awesome, icofont, ionicons, linear icons, map icons, material icons, open iconic, state, weather.
* [UIFontComplete](https://github.com/Nirma/UIFontComplete) - Font management (System & Custom) for iOS and tvOS.

### Game Engine
[back to top](#readme) 


#### 2D
[back to top](#readme) 

* [ImagineEngine](https://github.com/JohnSundell/ImagineEngine) - Blazing fasst 2D gaming engine.

### Games
[back to top](#readme) 

* [Sage](https://github.com/nvzqz/Sage) :penguin: - A cross-platform chess library.

### Gesture
[back to top](#readme) 

* [DBPathRecognizer](https://github.com/didierbrun/DBPathRecognizer) - db path recognizer for letters.
* [NiceGesture](https://github.com/lacklock/NiceGesture) - Using UIGestureRecognizers in a intuitive way.
* [PeekPop](https://github.com/marmelroy/PeekPop) - Framework for backwards-compatible Peek and Pop.
* [SBShortcutMenuSimulator](https://github.com/DeskConnect/SBShortcutMenuSimulator) - Allow the iPhone Simulator to test 3D Touch.
* [ShowTime](https://github.com/KaneCheshire/ShowTime) - Show off your iOS taps and gestures for demos and videos with just one line of code.
* [SwiftyGestureRecognition](https://github.com/b3ll/SwiftyGestureRecognition) - UIGestureRecognizers in Xcode Playgrounds.
* [SwipyCell](https://github.com/moritzsternemann/SwipyCell) - UITableViewCell implementing swiping to trigger actions (known from the Mailbox App).
* [Tactile](https://github.com/delba/Tactile) - Attach function handlers to gesture and control events in a more expressive and safer way.

### Hardware
*A category dedicated to hardware related libs* [back to top](#readme) 


#### 3D Touch
*Easy handle new 3D Touch / Force Touch feature thanks to these libs.* [back to top](#readme) 

* [QuickActions](https://github.com/ricardopereira/QuickActions) - Wrapper for iOS Home Screen Quick Actions.

#### Bluetooth
*Wrappers around CoreBluetooth* [back to top](#readme) 

* [Bleu](https://github.com/1amageek/Bleu) - BLE (Bluetooth LE) for U.
* [BlueCap](https://github.com/troystribling/BlueCap) - Wrapper around CoreBluetooth and much more.
* [Bluejay](https://github.com/steamclock/bluejay) - A simple framework for building reliable Bluetooth LE apps.
* [Bluetonium](https://github.com/e-sites/Bluetonium) - Library that makes it easy to communicate with Bluetooth devices.
* [BluetoothKit](https://github.com/rhummelmose/BluetoothKit) - Easily communicate between iOS/OSX devices using BLE.
* [RxBluetoothKit](https://github.com/polidea/RxBluetoothKit) - iOS & OSX Bluetooth library for RxSwift.
* [SwiftyBluetooth](https://github.com/jordanebelanger/SwiftyBluetooth) - Simple and reliable closure based wrapper around CoreBluetooth.

#### Camera
*Awesome camera libs* [back to top](#readme) 

* [ALCameraViewController](https://github.com/AlexLittlejohn/ALCameraViewController) - Camera view controller with custom image picker and image cropping.
* [Fusuma](https://github.com/ytakzk/Fusuma) - Instagram-like photo browser and a camera feature.
* [NextLevel](https://github.com/NextLevel/NextLevel) - Rad Media Capture.

##### Barcode
*Barcode, QR-code, other code readers* [back to top](#readme) 

* [BarcodeScanner](https://github.com/hyperoslo/BarcodeScanner) - A simple and beautiful barcode scanner view controller.
* [EFQRCode](https://github.com/EyreFree/EFQRCode) - A better way to operate quick response code.
* [QRCodeReader.swift](https://github.com/yannickl/QRCodeReader.swift) - Simple QRCode reader.

#### Haptic Feedback
*Libraries that involve the use of Haptic Feedback* [back to top](#readme) 

* [Haptica](https://github.com/efremidze/Haptica) - Easy Haptic Feedback Generator.
* [TapticEngine](https://github.com/WorldDownTown/TapticEngine) - Generates haptic feedback vibrations on iOS device.

#### iBeacon
*Interested in using iBeacon in your Swift project? Here some interesting resources.* [back to top](#readme) 

* [iBeacon](https://github.com/gemtot/iBeacon) - iBeacon implementation.
* [JMCBeaconManager](https://github.com/izotx/JMCBeaconManager) - iBeacon Manager.
* [SwiftLocation](https://github.com/malcommac/SwiftLocation) - Location & Beacon Monitoring.

#### Sensors
*Manage your device sensors in a faster and easier way* [back to top](#readme) 

* [MotionKit](https://github.com/MHaroonBaig/MotionKit) - iOS device sensors wrapper.

### Images
*An interesting list of image related libs..* [back to top](#readme) 

* [Agrume](https://github.com/JanGorman/Agrume) - A lemony fresh iOS image viewer.
* [AlamofireImage](https://github.com/Alamofire/AlamofireImage) - AlamofireImage is an image component library for Alamofire.
* [APNGKit](https://github.com/onevcat/APNGKit) - High performance and delightful way to play with APNG format in iOS.
* [AXPhotoViewer](https://github.com/alexhillc/AXPhotoViewer) - An iPhone/iPad photo gallery viewer, useful for viewing a large (or small!) number of photos.
* [CTPanoramaView](https://github.com/scihant/CTPanoramaView) - A library that displays spherical or cylindrical panoramas with touch or motion based controls.
* [DTPhotoViewerController](https://github.com/tungvoduc/DTPhotoViewerController) - A fully customizable photo viewer ViewController to display single photo or collection of photos, inspired by Facebook photo viewer.
* [FacebookImagePicker](https://github.com/floriangbh/FacebookImagePicker) - Facebook album photo picker.
* [Filterpedia](https://github.com/FlexMonkey/Filterpedia) - Core image filter.
* [FlexibleImage](https://github.com/kawoou/FlexibleImage) - A simple way to play with images.
* [gifu](https://github.com/kaishin/gifu) - Highly performant animated GIF support for iOS.
* [GPUImage 2](https://github.com/BradLarson/GPUImage2) - GPUImage 2 is a BSD-licensed Swift framework for GPU-accelerated video and image processing.
* [HanekeSwift](https://github.com/Haneke/HanekeSwift) - A lightweight generic cache for iOS with extra love for images.
* [ImageLoader](https://github.com/hirohisa/ImageLoaderSwift) - A lightweight and fast image loader for iOS.
* [ImageScout](https://github.com/kaishin/ImageScout) - Implementation of [fastimage](https://pypi.python.org/pypi/fastimage/0.2.1) - supports PNG, GIF, and JPEG.
* [ImageViewer](https://github.com/MailOnline/ImageViewer) - An image viewer à la Twitter
* [JLStickerTextView](https://github.com/luiyezheng/JLStickerTextView) - A UIImageView allow you to add multiple Label (multiple line text support) on it, you can edit, rotate, resize the Label as you want with one finger ,then render the text on Image.
* [KFSwiftImageLoader](https://github.com/kiavashfaisali/KFSwiftImageLoader) - An extremely high-performance, lightweight, and energy-efficient async web image loader with memory and disk caching for iOS and  Watch.
* [Kingfisher](https://github.com/onevcat/Kingfisher) - Image download and caching.
* [LetterAvatarKit](https://github.com/vpeschenkov/LetterAvatarKit) - A UIImage extension that generates letter-based avatars.
* [Lightbox](https://github.com/hyperoslo/Lightbox) - A convenient and easy to use image viewer for your iOS app.
* [MapleBacon](https://github.com/JanGorman/MapleBacon) - Image download and caching library.
* [MCScratchImageView](https://github.com/Minecodecraft/MCScratchImageView) - A custom ImageView that is used to cover the surface of other view like a scratch card, user can swipe the mulch to see the view below.
* [Misen](https://github.com/tasanobu/Misen) - A script to support using Xcode Asset Catalog.
* [Moa](https://github.com/evgenyneu/moa) - An image download extension of the image view for iOS, tvOS and macOS.
* [Nuke](https://github.com/kean/Nuke) - Advanced framework for loading, caching, processing, displaying and preheating images.
* [PASImageView](https://github.com/abiaad/PASImageView) - Async remote download your image and round them, automatically.
* [PassportScanner](https://github.com/evermeer/PassportScanner) - Scan the MRZ code of a passport and extract the first name, last name, passport number, nationality, date of birth, expiration date and personal number.
* [Sharaku](https://github.com/makomori/Sharaku) - Image filtering UI library like Instagram.
* [Snowflake](https://github.com/onmyway133/Snowflake) - Work with SVG.
* [SwiftGen-Assets](https://github.com/SwiftGen/SwiftGen#assets-catalogs) - A tool to auto-generate `enums` for all your `UIImages` from your Assets Catalogs.
* [SwiftGif](https://github.com/bahlo/SwiftGif) - A small UIImage extension with GIF support.
* [SwiftSVG](https://github.com/mchoe/SwiftSVG) - A single pass SVG parser with multiple interface options (String, NS/UIBezierPath, CAShapeLayer, and NS/UIView).
* [SwiftyGif](https://github.com/kirualex/SwiftyGif) - High performance GIF engine.
* [TextDrawer](https://github.com/remirobert/TextDrawer) - A UIView allows you to add text with gesture on UIView or UIImage, support resize, rotate, move and edit.
* [TinyCrayon](https://github.com/TinyCrayon/TinyCrayon-iOS-SDK) - A smart and easy-to-use image masking and cutout SDK for mobile apps.
* [Toucan](https://github.com/gavinbunney/Toucan) - Image processing api.
* [UIImageColors](https://github.com/jathu/UIImageColors) - iTunes style color fetcher for UIImage.
* [Viewer](https://github.com/bakkenbaeck/Viewer) - Image viewer (or Lightbox) with support for local and remote videos and images.
* [Vulcan](https://github.com/jinSasaki/Vulcan) - Multi image downloader with priority.
* [WDImagePicker](https://github.com/justwudi/WDImagePicker) - Image picker with customizable crop rectangle (getting update).
* [XAnimatedImage](https://github.com/khaledmtaha/XAnimatedImage) - XAnimatedImage is a performant animated GIF engine for iOS based on FLAnimatedImage.
* [YapImageManager](https://github.com/yapstudios/YapImageManager) - A high-performance image downloader — powered by YapDatabase.
* [ZImageCropper](https://github.com/ZaidPathan/ZImageCropper) - Crop image in any shape.

### Key Value Coding
*Libraries for key-value coding* [back to top](#readme) 


### Keyboard
*Do you want to create your own customized keyboard? Here are some interesting resources* [back to top](#readme) 

* [IHKeyboardAvoiding](https://github.com/IdleHandsApps/IHKeyboardAvoiding) - An elegant solution for keeping any UIView visible when the keyboard is being shown. No UIScrollView required.
* [IQKeyboardManager](https://github.com/hackiftekhar/IQKeyboardManager) - Codeless drop-in universal library allows to prevent issues of keyboard sliding up and cover UITextField/UITextView.
* [KeyboardHideManager](https://github.com/bonyadmitr/KeyboardHideManager) - Codeless manager to hide keyboard by tapping on views for iOS.
* [Typist](https://github.com/totocaster/Typist) - Small, drop-in UIKit keyboard manager for iOS apps-helps manage keyboard's screen presence and behavior without notification center.

### Kit
*Libraries for coding with a simplified API* [back to top](#readme) 

* [BFKit-Swift](https://github.com/FabrizioBrancati/BFKit-Swift) :penguin: - A collection of useful classes, structs and extensions to develop Apps faster.
* [C4iOS](https://github.com/C4Labs/C4iOS) - Harnesses the power of native iOS programming with a simplified API.

### Layout
*Libs to help you with layout.* [back to top](#readme) 

* [BrickKit](https://github.com/wayfair/brickkit-ios) - Create complex and responsive layouts in a simple way.
* [FlexLayout](https://github.com/layoutBox/FlexLayout) - Nice and clean interface to the highly optimized Facebook yoga Flexbox implementation.
* [JustUiKit](https://github.com/lfkdsk/JustUiKit) - iOS UI Kit With Android-Style. It is designed to make Android developers build iOS UI easily.
* [LayoutKit](https://github.com/linkedin/LayoutKit) - LayoutKit is a fast view layout library for iOS, macOS, and tvOS.
* [ManualLayout](https://github.com/isair/ManualLayout) - Easy to use and flexible AutoLayout alternative for iOS 8+. Supports AsyncDisplayKit.
* [Neon](https://github.com/mamaral/Neon) - A powerful programmatic UI layout framework.
* [PinLayout](https://github.com/mirego/PinLayout) - Fast views layouting without auto layout. No magic, pure code, full control and blazing fast. Concise, intuitive, readable & chainable syntax. Works nicely with FlexLayout.
* [Static](https://github.com/venmo/Static) - A simple static table views for iOS.
* [Stevia](https://github.com/freshOS/Stevia) - Elegant view layout for iOS.
* [SwiftBox](https://github.com/joshaber/SwiftBox) - Inspired by Flexbox, uses Facebook's css-layout.
* [ViewMonitor](https://github.com/daisuke0131/ViewMonitor) - Confirm view positions with executing app.

#### Auto Layout
*Bored of using storyboard? Give a try to declarative auto layout libs.* [back to top](#readme) 

* [AutoLayoutPlus](https://github.com/ruipfcosta/AutoLayoutPlus) - A bit of steroids for AutoLayout.
* [Bamboo](https://github.com/wordlessj/Bamboo) - Auto Layout (and manual layout) in one line.
* [Cartography](https://github.com/robb/Cartography) - Declarative auto layout lib for your project.
* [Cassowary](https://github.com/tribalworldwidelondon/CassowarySwift) - A linear constraint solving library using the same algorithm as AutoLayout.
* [Cupcake](https://github.com/nerdycat/Cupcake) - An easy way to create and layout UI components for iOS.
* [EasyPeasy](https://github.com/nakiostudio/EasyPeasy) - Auto Layout made easy.
* [FormationLayout](https://github.com/evan-liu/FormationLayout) - Auto Layout lib supports group layout and size classes.
* [KVConstraintKit](https://github.com/keshavvishwkarma/KVConstraintKit) - An Impressive Autolayout DSL for iOS, tvOS & OSX.
* [MisterFusion](https://github.com/marty-suzuki/MisterFusion) - DSL for AutoLayout, supports Size Class.
* [Mortar](https://github.com/jmfieldman/Mortar) - A concise but flexible DSL for creating Auto Layout constraints and adding subviews.
* [PureLayout](https://github.com/PureLayout/PureLayout) - The ultimate API for iOS & OS X Auto Layout.
* [Restraint](https://github.com/puffinsupply/Restraint) - Minimal Auto Layout.
* [SnapKit](https://github.com/SnapKit/SnapKit) - Autolayout DSL for iOS & OS X.
* [SwiftAutoLayout](https://github.com/indragiek/SwiftAutoLayout) - Small DSL for autolayout.
* [Swiftstraints](https://github.com/Skyvive/Swiftstraints) - Powerful auto-layout framework that lets you write constraints in one line of code.
* [TinyConstraints](https://github.com/roberthein/TinyConstraints) - TinyConstraints is the syntactic sugar that makes Auto Layout sweeter for human use.

### Localization
*Frameworks that helps with localizing your app* [back to top](#readme) 

* [BartyCrouch](https://github.com/Flinesoft/BartyCrouch) - Incrementally update/translate your Strings files from Code and Storyboards/XIBs.
* [IBLocalizable](https://github.com/PiXeL16/IBLocalizable) - Localize your views directly in Interface Builder with IBLocalizable.
* [L10n-swift](https://github.com/Decybel07/L10n-swift) - Localization of an application with ability to change language "on the fly" and support for plural forms in any language.
* [LocalizationKit](https://github.com/willpowell8/LocalizationKit_iOS) - Realtime dynamic localization of your app with remote management so you can manage maintain and deploy translations without resubmitting app.
* [Localize-Swift](https://github.com/marmelroy/Localize-Swift) - Localize apps using e.g. regular expressions in Localizable.strings.
* [NoOptionalInterpolation](https://github.com/T-Pham/NoOptionalInterpolation) - Get rid of "Optional(...)" and "nil" in string interpolation. Easy pluralization.
* [Swifternalization](https://github.com/tomkowz/Swifternalization) - Localize apps using e.g. regular expressions in Localizable.strings.
* [SwiftGen-L10n](https://github.com/SwiftGen/SwiftGen#localizablestrings) - A tool to auto-generate `enums` for all your Localizable.strings keys (with appropriate associated values if those strings contains printf-format placeholders like `%@`).

### Location
[back to top](#readme) 

* [STLocationRequest](https://github.com/SvenTiigi/STLocationRequest) - An elegant and simple 3D Flyover Location Request Screen.

### Logging
*Utilities for writing to and reading from the device log* [back to top](#readme) 

* [AEConsole](https://github.com/tadija/AEConsole) - Customizable Console UI overlay with debug log on top of your iOS App.
* [CleanroomASL](https://github.com/gilt/CleanroomASL) - API for reading from & writing to the Apple System Log.
* [CleanroomLogger](https://github.com/emaloney/CleanroomLogger) - Configurable and extensible high-level logging API that is simple, lightweight and performant.
* [Dotzu](https://github.com/remirobert/Dotzu) - Debbuger tool for iOS developer. Display logs, network request, device informations, crash logs while using the app.
* [Duration](https://github.com/SwiftStudies/Duration) :penguin: - Lightweight logging library focused on reporting timings for operations.
* [Evergreen](https://github.com/nilsleiffischer/Evergreen) - Most natural logging.
* [HeliumLogger](https://github.com/IBM-Swift/HeliumLogger) :penguin: - IBM's lightweight logging framework.
* [Log](https://github.com/delba/Log) - A logging tool with built-in themes, formatters, and a nice API to define your owns.
* [Printer](https://github.com/hemangshah/printer) - A fancy logger for your next app.
* [Puree](https://github.com/cookpad/puree-ios) - A log collector for iOS.
* [QorumLogs](https://github.com/goktugyil/QorumLogs) - Logging Utility for Xcode & Google Docs.
* [Rainbow](https://github.com/onevcat/Rainbow) :penguin: - Delightful console output.
* [SwiftyBeaver](https://github.com/SwiftyBeaver/SwiftyBeaver) :penguin: - Multi-platform logging during development & release.
* [TinyConsole](https://github.com/Cosmo/TinyConsole) - A tiny log console to display information while using your iOS app.
* [Watchdog](https://github.com/wojteklu/Watchdog) - Utility for logging excessive blocking on the main thread.
* [WatchdogInspector](https://github.com/tapwork/WatchdogInspector) - A logging tool to show the current framerate (fps) in the status bar of your iOS app.
* [Willow](https://github.com/Nike-Inc/Willow) - Willow is a powerful, yet lightweight logging library.
* [XCGLogger](https://github.com/DaveWoodCom/XCGLogger) - Full featured & Configurable logging utility with log levels, timestamps, and line numbers.

### Maps
[back to top](#readme) 

* [ArcKit](https://github.com/sobri909/ArcKit) - A location and activity recording framework for iOS.
* [Cluster](https://github.com/efremidze/Cluster) - Easy Map Annotation Clustering.
* [GEOSwift](https://github.com/GEOSwift/GEOSwift) - Make it easier to work with geographic models and calculate intersections, overlapping, projections etc.

### Math
[back to top](#readme) 

* [Arithmosophi](https://github.com/phimage/Arithmosophi) - Set of protocols for Arithmetic and Logical operations.
* [BigInt](https://github.com/attaswift/BigInt) - Arbitrary-precision arithmetic.
* [DDMathParser](https://github.com/davedelong/DDMathParser) - DDMathParser makes it easy to parse a String and evaluate it as a mathematical expression.
* [PlotKit](https://github.com/aleph7/PlotKit) - Plots made easy.
* [SigmaSwiftStatistics](https://github.com/evgenyneu/SigmaSwiftStatistics) - A collection of functions for statistical calculation.
* [swix](https://github.com/stsievert/swix) - A general matrix language.
* [Upsurge](https://github.com/aleph7/Upsurge) - Simple and fast matrix and vector math.

### Natural Language Processing
[back to top](#readme) 

* [CoreLinguistics](https://github.com/rxwei/CoreLinguistics) - Natural Language Processing (NLP) toolkit.

### Network
*A list of libs that allow you to decrease the amount of time spent dealing with http requests.* [back to top](#readme) 

* [agent](https://github.com/hallas/agent) - HTTP request agent.
* [Alamofire](https://github.com/Alamofire/Alamofire) :penguin: - Elegant networking.
* [APIKit](https://github.com/ishkawa/APIKit) - Library for building type-safe web API client.
* [BigBrother](https://github.com/marcelofabri/BigBrother) - Automatically sets the network activity indicator for any performed request.
* [Ciao](https://github.com/AlTavares/Ciao) - Publish and discover services using mDNS (Bonjour, Zeroconf).
* [Conduit](https://github.com/mindbody/Conduit) - Robust networking for web APIs.
* [Dratini](https://github.com/kevin0571/Dratini) - A neat network layer.
* [Heimdallr.swift](https://github.com/trivago/Heimdallr.swift) - Easy to use OAuth 2 library for iOS.
* [Just](https://github.com/JustHTTP/Just) :penguin: - HTTP for Humans (a python-requests style HTTP library).
* [Malibu](https://github.com/hyperoslo/Malibu) - A networking library built on promises.
* [Moya](https://github.com/Moya/Moya) - Network abstraction layer.
* [NEKit](https://github.com/zhuhaow/NEKit) - A toolkit for Network Extension Framework.
* [NetClient](https://github.com/intelygenz/NetClient-iOS) - Versatile HTTP networking library.
* [Netfox](https://github.com/kasketis/netfox) - A lightweight, one line setup, network debugging library.
* [OAuth2](https://github.com/p2/OAuth2) - oauth2 auth lib.
* [OAuthSwift](https://github.com/OAuthSwift/OAuthSwift) - OAuth library for iOS.
* [PeerKit](https://github.com/jpsim/PeerKit) - Framework for building event-driven, zero-config Multipeer Connectivity apps.
* [Pitaya](https://github.com/johnlui/Pitaya) :penguin: - HTTP / HTTPS networking library just incidentally execute on machines.
* [Postal](https://github.com/snipsco/Postal) - Framework providing simple access to common email providers.
* [Reach](https://github.com/Isuru-Nanayakkara/Reach) - A simple class to check for internet connection availability.
* [Reachability.swift](https://github.com/ashleymills/Reachability.swift) - A replacement for Apple's Reachability with closures.
* [ResponseDetective](https://github.com/netguru/ResponseDetective) - A non-intrusive framework for intercepting any outgoing requests and incoming responses between your app and server for debugging purposes.
* [ShadowsocksX-NG](https://github.com/shadowsocks/ShadowsocksX-NG) - A fast tunnel proxy that helps you bypass firewalls.
* [Siesta](https://bustoutsolutions.github.io/siesta/) - Elegant abstraction for REST APIs that untangles stateful messes. An alternative to callback- and delegate-based networking.
* [SwiftHTTP](https://github.com/daltoniam/SwiftHTTP) - NSURLSession wrapper.
* [SwiftyOAuth](https://github.com/delba/SwiftyOAuth) - A small OAuth library with a built-in set of providers.
* [Transporter](https://github.com/nghialv/Transporter) - A tiny library makes uploading and downloading easier.
* [TRON](https://github.com/MLSDev/TRON) - Lightweight network abstraction layer, written on top of Alamofire.

#### HTML
*Need to manipulate contents from html easily?* [back to top](#readme) 

* [Fuzi](https://github.com/cezheng/Fuzi) - A fast & lightweight XML/HTML parser with XPath & CSS support.
* [Ji](https://github.com/honghaoz/Ji) - XML/HTML parser.
* [Kanna](https://github.com/tid-kijyun/Kanna) - Another XML/HTML parser.
* [SwiftSoup](https://github.com/scinfu/SwiftSoup) :penguin: - HTML Parser, with best of DOM, CSS, and jquery.
* [WKZombie](https://github.com/mkoehnke/WKZombie) - Headless browser.

#### Messaging Protocol
[back to top](#readme) 

* [CocoaMQTT](https://github.com/emqtt/CocoaMQTT) - MQTT for iOS and OS X.
* [Perfect-Notifications](https://github.com/PerfectlySoft/Perfect-Notifications) - iOS Notifications for Linux and OS X.

#### Socket
[back to top](#readme) 

* [BlueSocket](https://github.com/IBM-Swift/BlueSocket) :penguin: - IBM's low level socket framework.
* [RxWebSocket](https://github.com/fjcaetano/RxWebSocket) - Reactive WebSockets.
* [Socket.IO](https://github.com/socketio/socket.io-client-swift) :penguin: - Socket.IO client for iOS/OS X.
* [SocketIO-Kit](https://github.com/ricardopereira/SocketIO-Kit) - Socket.io iOS and OSX Client.
* [sockets](https://github.com/vapor/sockets) :penguin: - TCP, UDP; Client, Server; Linux, OS X.
* [Starscream](https://github.com/daltoniam/Starscream) - Websockets for iOS and OSX.
* [SwiftDSSocket](https://github.com/csujedihy/SwiftDSSocket) - Asynchronous socket framework built atop DispatchSource.
* [SwiftSocket](https://github.com/swiftsocket/SwiftSocket) - Simple TCP socket library.
* [SwiftWebSocket](https://github.com/tidwall/SwiftWebSocket) - A high performance WebSocket client library .

#### Webserver
*Would you like host a webserver in your device? Here you can find how to do it.* [back to top](#readme) 

* [Ambassador](https://github.com/envoy/Ambassador) - Super lightweight web framework based on SWSGI.
* [Blackfire](https://github.com/elliottminns/blackfire) :penguin: - A minimal, fast and unopinionated web framework.
* [Curassow](https://github.com/kylef/Curassow) :penguin: - HTTP server using the pre-fork worker model.
* [Dynamo](https://github.com/johnno1962/Dynamo) :penguin: - High performance web server supporting dynamic content.
* [Embassy](https://github.com/envoy/Embassy) :penguin: - Super lightweight async HTTP server library.
* [Express](https://github.com/crossroadlabs/Express) :penguin: - Web Application framework, supporting both Synchronous and Asynchronous (Futures based) styles. Inspired by Play framework and Express.js.
* [Frank](https://github.com/kylef/Frank) :penguin: - Frank is a DSL for quickly writing web applications.
* [http4swift](https://github.com/takebayashi/http4swift) :penguin: - A simple HTTP server.
* [Kitura](https://github.com/IBM-Swift/Kitura) :penguin: - IBM's web framework and server for web services.
* [Kunugi](https://github.com/novi/Kunugi) :penguin: - Minimal web framework and middleware.
* [Lightning](https://github.com/skylab-inc/Lightning) :penguin: - Multiplatform Single-threaded Non-blocking Web and Networking Framework.
* [Noze.io](https://github.com/NozeIO/Noze.io) :penguin: - Evented I/O streams like Node.js.
* [Perfect](https://github.com/PerfectlySoft/Perfect) :penguin: - Server-side Swift. The Perfect library, application server, connectors and example apps.
* [swifter](https://github.com/httpswift/swifter) :penguin: - Http server with routing handler.
* [Swifton](https://github.com/necolt/Swifton) :penguin: - A Ruby on Rails inspired Web Framework that runs on Linux and OS X.
* [SwiftyHTTP](https://github.com/AlwaysRightInstitute/SwiftyHTTP) - A simple GCD based HTTP client and server.
* [Taylor](https://github.com/izqui/Taylor) - A lightweight library for writing HTTP web servers.
* [Trevi](https://github.com/Yoseob/Trevi) - A powerful Web Application Server Framework Project.
* [Vapor](https://github.com/vapor/vapor) :penguin: - Elegant web framework that works on iOS, OS X, and Ubuntu.
* [XcodeServerSDK](https://github.com/buildasaurs/XcodeServerSDK) - Access Xcode Server API.
* [Zewo](https://github.com/Zewo/Zewo) :penguin: - Server-Side Swift.

### OCR
[back to top](#readme) 

* [SwiftOCR](https://github.com/garnele007/SwiftOCR) - Neural Network based OCR lib.

### Optimization
[back to top](#readme) 

* [Unreachable](https://github.com/nvzqz/Unreachable) :penguin: - Unreachable code path optimization hint.

### PDF
[back to top](#readme) 

* [PDFGenerator](https://github.com/sgr-ksmt/PDFGenerator) - A simple Generator of PDF. Generate PDF from view(s) or image(s).
* [SimplePDF](https://github.com/nRewik/SimplePDF) - Create a simple PDF effortlessly.
* [UXMPDFKit](https://github.com/uxmstudio/UXMPDFKit) - A PDF viewer and annotator that can be embedded in iOS applications.

### Quality
[back to top](#readme) 

* [IBLinter](https://github.com/kateinoigakukun/IBLinter) - A linter tool for Interface Builder.
* [SwiftLint](https://github.com/realm/SwiftLint) - A tool to enforce coding conventions.
* [Swimat](https://github.com/Jintin/Swimat) - Xcode plugin to format code.
* [Tailor](https://github.com/sleekbyte/tailor) :penguin: - Cross-platform static analyzer that helps you to write cleaner code and avoid bugs.

### Scripting
[back to top](#readme) 

* [Marathon](https://github.com/JohnSundell/Marathon) - Easy way to create and manage scripts.

### SDK
[back to top](#readme) 


### Security
[back to top](#readme) 


#### Cryptography
*Deal with cryptography method easily* [back to top](#readme) 

* [CryptoSwift](https://github.com/krzyzanowskim/CryptoSwift) :penguin: - Crypto related functions and helpers.
* [IDZSwiftCommonCrypto](https://github.com/iosdevzone/IDZSwiftCommonCrypto) - A wrapper for Apple's Common Crypto library.
* [RNCryptor](https://github.com/RNCryptor/RNCryptor) - CCCryptor (Apple's AES encryption) wrappers for iOS and Mac.
* [SCrypto](https://github.com/sgl0v/scrypto) - Elegant Swift interface to access the CommonCrypto routines.
* [Siphash](https://github.com/attaswift/SipHash) - Simple and secure hashing with the SipHash algorithm.
* [SweetHMAC](https://github.com/jancassio/SweetHMAC) - A tiny and easy to use class to encrypt strings using HMAC algorithms.
* [Swift-Sodium](https://github.com/jedisct1/swift-sodium) - Interface to the Sodium library for common crypto operations for iOS and OS X.
* [SwiftSSL](https://github.com/SwiftP2P/SwiftSSL) - Crypto toolkit.

#### Keychain
[back to top](#readme) 

* [keychain-swift](https://github.com/evgenyneu/keychain-swift) - Helper functions for saving text in Keychain securely for iOS, OS X, tvOS and watchOS.
* [KeychainAccess](https://github.com/kishikawakatsumi/KeychainAccess) - Simple wrapper for Keychain that works on iOS and OS X.
* [KeyClip](https://github.com/s-aska/KeyClip) - Keychain framework for iOS.
* [Latch](https://github.com/DanToml/Latch) - A simple Keychain Wrapper for iOS.
* [Locksmith](https://github.com/matthewpalmer/Locksmith) - A powerful, protocol-oriented library for working with the iOS Keychain.
* [SwiftKeychainWrapper](https://github.com/jrendel/SwiftKeychainWrapper) - Simple static wrapper for the iOS Keychain to allow you to use it in a similar fashion to user defaults.

### Streaming
[back to top](#readme) 

* [Live](https://github.com/ltebean/Live) - Demonstrate how to build a live broadcast app.

### Styling
[back to top](#readme) 

* [Ambience](https://github.com/tmergulhao/Ambience) - Brightness aware accessibility theme switching without coding.
* [Stylist](https://github.com/yonaskolb/Stylist) - Define UI styles in a hot-loadable external yaml or json file.
* [SwiftTheme](https://github.com/jiecao-fm/SwiftTheme) - Powerful theme/skin manager for iOS 8+.
* [Themes](https://github.com/onmyway133/Themes) - Theme management.

### System
[back to top](#readme) 

* [SMCKit](https://github.com/beltex/SMCKit) - Apple SMC library.
* [SystemKit](https://github.com/beltex/SystemKit/) - OS X system library.

### Testing
*A collection of testing frameworks.* [back to top](#readme) 

* [Buildasaur](https://github.com/buildasaurs/Buildasaur) - Automatic testing of your Pull Requests on GitHub and BitBucket using Xcode Server.
* [CatchingFire](https://github.com/mrackwitz/CatchingFire) - Error handling test library.
* [DVR](https://github.com/venmo/DVR) - A simple network testing framework.
* [Erik](https://github.com/phimage/Erik) - An headless browser to access and manipulate webpages using javascript allowing to run functional tests.
* [Fakery](https://github.com/vadymmarkov/Fakery) - Fake data generator.
* [Nimble](https://github.com/Quick/Nimble) - A matcher framework.
* [OHHTTPStubs](https://github.com/AliSoftware/OHHTTPStubs) - A testing library designed to stub your network requests easily.
* [PinpointKit](https://github.com/Lickability/PinpointKit) - Lets your testers and users send feedback with annotated screenshots and logs using a simple gesture.
* [Quick](https://github.com/Quick/Quick) :penguin: - Quick is a behavior-driven development framework.
* [Sleipnir](https://github.com/railsware/Sleipnir) - BDD-style framework.
* [Spectre](https://github.com/kylef/Spectre) :penguin: - BDD Framework.
* [SwiftCheck](https://github.com/typelift/SwiftCheck) - A testing library that automatically generates random data for testing program properties.
* [UI Testing Cheat Sheet](https://github.com/joemasilotti/UI-Testing-Cheat-Sheet) - Answers to common "How do I test this with UI Testing?" questions with a working example app.

#### Mock
[back to top](#readme) 

* [Cuckoo](https://github.com/Brightify/Cuckoo) - First boilerplate-free mocking framework.
* [Kakapo](https://github.com/devlucky/Kakapo) - Dynamically Mock server behaviors and responses. 
* [Mockingjay](https://github.com/kylef/Mockingjay) - An elegant library for stubbing HTTP requests with ease.
* [Mockit](https://github.com/sabirvirtuoso/Mockit) - A simple mocking framework, inspired by the famous Mockito for Java.
* [SwiftMock](https://github.com/mflint/SwiftMock) - A mocking framework.

### Text
*A collection of text projects.* [back to top](#readme) 

* [Apodimark](https://github.com/loiclec/Apodimark) - Fast, flexible markdown parser.
* [Atributika](https://github.com/psharanda/Atributika) - Easily build NSAttributedString by detecting and styling HTML-like tags, hashtags, mentions, RegExp or NSDataDetector patterns.
* [Attributed](https://github.com/Nirma/Attributed) - Modern µframework for attributed strings.
* [AttributedTextView](https://github.com/evermeer/AttributedTextView) - Easiest way to create an attributed UITextView with support for multiple links, hashtags and mentions.
* [BonMot](https://github.com/Raizlabs/BonMot) - Beautiful, easy attributed strings for iOS.
* [edhita](https://github.com/tnantoka/edhita) - Fully open source text editor for iOS.
* [Format](https://github.com/marmelroy/Format) - Formatting kit for numbers, addresses and colors.
* [Markdown](https://github.com/crossroadlabs/Markdown) :penguin: - Markdown templates for Swift. Based on Discount library (a library used deep down by GitHub markdown).
* [MarkdownKit](https://github.com/ivanbruel/MarkdownKit) - A simple and customizable Markdown Parser.
* [MarkdownView](https://github.com/keitaoouchi/MarkdownView) - iOS Markdown view.
* [MarkyMark](https://github.com/M2Mobi/Marky-Mark) - Converts Markdown into native views or attributed strings.
* [Mustard](https://github.com/mathewsanders/Mustard) - Library for tokenizing strings when splitting by whitespace doesn't cut it.
* [Notepad](https://github.com/ruddfawcett/Notepad) - A fully themeable markdown editor with live syntax highlighting.
* [Parsey](https://github.com/rxwei/Parsey) - Parser combinator framework that supports source location tracking, backtracking prevention, and rich error messages.
* [Pluralize.swift](https://github.com/joshualat/Pluralize.swift) - Great String Pluralize Extension.
* [PrediKit](https://github.com/KrakenDev/PrediKit) - An NSPredicate DSL for iOS & OS X inspired by SnapKit.
* [PySwiftyRegex](https://github.com/cezheng/PySwiftyRegex) - Easily deal with Regex in a Pythonic way.
* [Reductio](https://github.com/fdzsergio/Reductio) - Automatic summarizer text.
* [Regex by brynbellomy](https://github.com/brynbellomy/Regex) - Wrapper class for `NSRegularExpression`.
* [Regex by crossroadlabs](https://github.com/crossroadlabs/Regex) :penguin: - Very easy to use Regular Expressions library with rich functionality. Features both operator `=~` and method based APIs. Unit tests covered.
* [RichEditorView](https://github.com/cjwirth/RichEditorView) -  RichEditorView is a simple, modular, drop-in UIView subclass for Rich Text Editing.
* [Roman](https://github.com/nvzqz/Roman) :penguin: - Seamless Roman numeral conversion.
* [SmarkDown](https://github.com/SwiftStudies/SmarkDown) :penguin: - Markdown processing conforming to Gruber's standards.
* [Sprinter](https://github.com/nicklockwood/Sprinter) - A library for formatting strings.
* [SwiftRichString](https://github.com/malcommac/SwiftRichString) - Elegant & Painless Attributed Strings Management Library.
* [SwiftString](https://github.com/amayne/SwiftString) - A lightweight string extension.
* [SwiftVerbalExpressions](https://github.com/VerbalExpressions/SwiftVerbalExpressions) - VerbalExpressions porting.
* [SwiftyAttributes](https://github.com/eddiekaiger/SwiftyAttributes) - Extensions that make it a breeze to work with attributed strings.
* [SyntaxKit](https://github.com/soffes/SyntaxKit) - TextMate-style syntax highlighting.
* [TextAttributes](https://github.com/delba/TextAttributes) - An easier way to compose attributed strings.

### Thread
*Threading, task-based or asynchronous programming, Grand Central Dispatch (GCD) wrapper* [back to top](#readme) 

* [Async](https://github.com/duemunk/Async) - Syntactic sugar for Grand Central Dispatch.
* [AwaitKit](https://github.com/yannickl/AwaitKit) - The ES7 Async/Await control flow.
* [Chronos](https://github.com/comyar/Chronos-Swift) - Grand Central Dispatch Utilities.
* [Dispatcher](https://github.com/aleclarson/dispatcher) - Queues, timers, and task groups.
* [Each](https://github.com/dalu93/Each) - Each is a NSTimer bridge library.
* [EKI](https://github.com/kodlian/Eki) - Make Grand Central Dispatch easy and fun to use (queue, task, group, timer and semaphore).
* [GCDKit](https://github.com/JohnEstropia/GCDKit) - Grand Central Dispatch simplified.
* [GCDTimer](https://github.com/hemantasapkota/GCDTimer) - A well-tested GCD timer.
* [SwiftyTimer](https://github.com/radex/SwiftyTimer) - API for NSTimer.

### UI
*A collection of pre-packaged transitions & cool ui stuffs.* [back to top](#readme) 

* [AECoreDataUI](https://github.com/tadija/AERecord) - Core Data driven UI.
* [AGCircularPicker](https://github.com/agilie/AGCircularPicker) - Helpful component for creating a controller aimed to manage any calculated parameter.
* [AmazingBubbles](https://github.com/GlebRadchenko/AmazingBubbles) - Apple Music like Bubble Picker using Dynamic Animation (faster / more lightweight than SpriteKit).
* [AMScrollingNavbar](https://github.com/andreamazz/AMScrollingNavbar) - Scrollable UINavigationBar that follows the scrolling of a UIScrollView.
* [AZTransitions](https://github.com/azimin/AZTransitions) - API to make great custom transitions in one method.
* [BreakOutToRefresh](https://github.com/dasdom/BreakOutToRefresh) - A playable pull to refresh view using SpriteKit.
* [BulletinBoard](https://github.com/alexaubry/BulletinBoard) - Generates and manages contextual cards displayed at the bottom of the screen.
* [BusyNavigationBar](https://github.com/gmertk/BusyNavigationBar) - A UINavigationBar extension to show loading effects.
* [CostumeKit](https://github.com/jakemarsh/CostumeKit) - Base types for theming an app.
* [CountryPickerView](https://github.com/kizitonwose/CountryPickerView) - A simple, customizable view for efficiently collecting country information in iOS apps.
* [CustomSegue](https://github.com/phimage/CustomSegue) - Custom segue for OSX Storyboards with slide and cross fade effects.
* [DeckTransition](https://github.com/HarshilShah/DeckTransition) - A library to recreate the iOS 10 Apple Music now playing transition.
* [Dodo](https://github.com/evgenyneu/Dodo) - A message bar for iOS.
* [DropDown](https://github.com/AssistoLab/DropDown) - A Material Design drop down for iOS.
* [Element](https://github.com/eonist/Element) - Programmatic UI framework for macOS.
* [Elissa](https://github.com/KitchenStories/Elissa) - Displays a notification on top of a UITabBarItem or any UIView anchor view to reveal additional information.
* [EPShapes](https://github.com/ipraba/EPShapes) - Create shapes(Polygons, Stars, Hearts, Arrows) in Interface builder.
* [EstMusicIndicator](https://github.com/Aufree/ESTMusicIndicator) - Music play indicator like iTunes.
* [EZSwipeController](https://github.com/goktugyil/EZSwipeController) - UIPageViewController like Snapchat/Tinder/iOS Main Pages.
* [FAQView](https://github.com/mukeshthawani/faqview) - An easy to use FAQ view for iOS.
* [Fashion](https://github.com/vadymmarkov/Fashion) - Fashion accessories and beauty tools to share and reuse UI styles.
* [FillableLoaders](https://github.com/polqf/FillableLoaders) - Fillable loaders progress.
* [FlagKit](https://github.com/madebybowtie/FlagKit) - Beautiful flag icons for usage in apps and on the web.
* [FloatRatingView](https://github.com/glenyi/FloatRatingView) - Floating rating system.
* [Fluid Slider](https://github.com/Ramotion/fluid-slider) - A slider widget with a popup bubble displaying the precise value selected.
* [GaugeKit](https://github.com/skywinder/GaugeKit) - Customizable gauges. Easy reproduce Apple's style gauges.
* [Geometry](https://github.com/artman/Geometry) - extensions for UIView.
* [GIFRefreshControl](https://github.com/delannoyk/GIFRefreshControl) - A pull to refresh that supports GIF images as track animations.
* [GMStepper](https://github.com/gmertk/GMStepper) - A stepper with a sliding label in the middle.
* [GradientProgressBar](https://github.com/fxm90/GradientProgressBar) - A customizable gradient progress bar (UIProgressView)
* [GRMustache](https://github.com/groue/GRMustache.swift) - Flexible Mustache templates.
* [GrowingTextView](https://github.com/KennethTsang/GrowingTextView) - UITextView that supports auto growing, placeholder and length limit.
* [Hexacon](https://github.com/gautier-gdx/Hexacon) - A new way to display content in your app like the Apple Watch SpringBoard.
* [HGCircularSlider](https://github.com/HamzaGhazouani/HGCircularSlider) - A custom reusable circular slider control for iOS application.
* [HoneycombView](https://github.com/suzuki-0000/HoneycombView) - HoneycombView is the iOS UIView for displaying like Honyecomb layout.
* [HorizontalDial](https://github.com/kciter/HorizontalDial) - A horizontal scroll dial like Instagram.
* [IGColorPicker](https://github.com/iGenius-Srl/IGColorPicker) - A customizable color picker for iOS.
* [ImagePicker](https://github.com/hyperoslo/ImagePicker) - A nicely designed and super easy to use ImagePicker.
* [ImagePickerSheetController](https://github.com/lbrndnr/ImagePickerSheetController) - A component that replicates the custom photo action sheet in iMessage.
* [InfoView](https://github.com/anatoliyv/InfoView) - Simple information view with pointed arrow.
* [InstantSearch iOS](https://github.com/algolia/instantsearch-ios) - A library of widgets and helpers to build instant-search features on iOS.
* [KALoader](https://github.com/Kirillzzy/KALoader) - Beautiful animated placeholders for showing loading of data.
* [KDInteractiveNavigationController](https://github.com/kingiol/KDInteractiveNavigationController) - A UINavigationController subclass that support pop interactive UINavigationBar with hidden or show.
* [KMNavigationBarTransition](https://github.com/MoZhouqi/KMNavigationBarTransition) - A drop-in universal library helps you to manage the navigation bar styles and makes transition animations smooth between different navigation bar styles while pushing or popping a view controller for all orientations.
* [KMPlaceholderTextView](https://github.com/MoZhouqi/KMPlaceholderTextView) - A UITextView subclass that adds support for multiline placeholder.
* [LeeGo](https://github.com/wangshengjia/LeeGo) - Declarative, configurable & highly reusable UI development as making Lego bricks.
* [LicensePlist](https://github.com/mono0926/LicensePlist) - A command-line tool that automatically generates a Plist of all your dependencies.
* [LiquidLoader](https://github.com/yoavlt/LiquidLoader) - Spinner loader components with liquid animation.
* [Macaw](https://github.com/exyte/macaw) - Powerful and easy-to-use vector graphics library with SVG support.
* [Magnetic](https://github.com/efremidze/Magnetic) - SpriteKit Floating Bubble Picker (inspired by Apple Music).
* [Mandoline](https://github.com/blueapron/Mandoline) - An iOS picker view to serve all your 'picking' needs.
* [MantleModal](https://github.com/canalesb93/MantleModal) - A simple modal resource that uses a UIScrollView to allow the user to close the modal by dragging it down.
* [Material](https://github.com/CosmicMind/Material) - Express your creativity with Material, an animation and graphics framework for Google's Material Design and Apple's Flat UI.
* [MaterialKit](https://github.com/nghialv/MaterialKit) - Material design components.
* [MediaBrowser](https://github.com/younatics/MediaBrowser) - Simple iOS photo and video browser with optional grid view, captions and selections.
* [MediumScrollFullScreen](https://github.com/pixyzehn/MediumScrollFullScreen) - Medium scroll style menubar.
* [MICountryPicker](https://github.com/mustafaibrahim989/MICountryPicker) - Country picker with search option.
* [MPParallaxView](https://github.com/DroidsOnRoids/MPParallaxView) - Apple TV Parallax effect.
* [MXParallaxHeader](https://github.com/maxep/MXParallaxHeader) - Simple parallax header for UIScrollView.
* [MZFormSheetPresentationController](https://github.com/m1entus/MZFormSheetPresentationController) - Provides an alternative to the native iOS UIModalPresentationFormSheet, adding support for iPhone and additional opportunities to setup controller size and feel form sheet.
* [NextGrowingTextView](https://github.com/muukii/NextGrowingTextView) - The next in the generations of 'growing textviews' optimized for iOS 7 and above.
* [NVActivityIndicatorView](https://github.com/ninjaprox/NVActivityIndicatorView) - Collection of nice loading animations.
* [Otafuku](https://github.com/tasanobu/Otafuku) - Some utility classes to use WKWebView.
* [PanelKit](https://github.com/louisdh/panelkit) - A UI framework that enables panels on iOS.
* [Panoramic](https://github.com/iSame7/Panoramic) - Panoramic facebook story clone.
* [ParallaxView](https://github.com/PGSSoft/ParallaxView) - Controls and extensions for tvOS that add parallax effect to your application.
* [PPAssetsActionController](https://github.com/pantuspavel/PPAssetsActionController) - Highly customizable Action Sheet Controller with assets preview.
* [PPSwiftGifs](https://github.com/peterprokop/PPSwiftGifs) - Convenient way to show animated GIF images as a part of iOS GUI.
* [PullToDismiss](https://github.com/sgr-ksmt/PullToDismiss) - You can dismiss modal viewcontroller by pulling scrollview or navigationbar.
* [RangeSeekSlider](https://github.com/WorldDownTown/RangeSeekSlider) - A customizable range slider like a UISlider for iOS.
* [Reel search](https://github.com/Ramotion/reel-search) - Option list managed as a reel.
* [SAConfettiView](https://github.com/sudeepag/SAConfettiView) - Easily add fun, multi-colored confetti to your app.
* [SAHistoryNavigationViewController](https://github.com/marty-suzuki/SAHistoryNavigationViewController) - iOS task manager like UI in UINavigationContoller.
* [SectionedSlider](https://github.com/LeonardoCardoso/SectionedSlider) - Control Center Slider.
* [SelectionDialog](https://github.com/kciter/SelectionDialog) - Simple selection dialog.
* [ShadowView](https://github.com/PierrePerrin/ShadowView) - Make shadows management easy on UIView.
* [Shiny](https://github.com/efremidze/Shiny) - Iridescent Effect View (inspired by Apple Pay Cash).
* [SkeletonView](https://github.com/Juanpe/SkeletonView) - An elegant way to show users that something is happening and also prepare them to which contents he is waiting.
* [SKPhotoBrowser](https://github.com/suzuki-0000/SKPhotoBrowser) - Simple PhotoBrowser/Viewer inspired by facebook, twitter photo browsers.
* [SMSwipeableTabView](https://github.com/smahajan28/SMSwipeableTabView) - Fully customizable control which is mixture of UIPageViewController and Scrollable Tab Bar.
* [Sonar](https://github.com/thefuntasty/Sonar) - Cool radar-style view.
* [Spots](https://github.com/hyperoslo) - Spots is a view controller framework that makes your setup and future development blazingly fast.
* [SpreadsheetView](https://github.com/kishikawakatsumi/SpreadsheetView) - Full configurable spreadsheet view user interfaces for iOS applications.
* [StarryStars](https://github.com/peterprokop/StarryStars) - Display & edit ratings, fully customizable from interface builder.
* [StatefulViewController](https://github.com/aschuch/StatefulViewController) - Placeholder views based on content, loading, error or empty states.
* [StepProgressView](https://github.com/yonat/StepProgressView) - Step-by-step progress view with labels and shapes. A good replacement for UIActivityIndicatorView and UIProgressView.
* [SurfingRefreshControl](https://github.com/peiweichen/SurfingRefreshControl) - Customizable pull-to-refresh control.
* [SwiftyUI](https://github.com/haoking/SwiftyUI) - High performance and lightweight UIView, UIImage, UIImageView, UIlabel, UIButton and more.
* [SYBlinkAnimationKit](https://github.com/shoheiyokoyama/SYBlinkAnimationKit) - A blink effect animation framework.
* [TagListView](https://github.com/ElaWorkshop/TagListView) - Simple but highly customizable iOS tag list view.
* [Toaster](https://github.com/devxoul/Toaster) - Notification toasts.
* [TouchVisualizer](https://github.com/morizotter/TouchVisualizer) - Lightweight touch visualization library with a single line of code.
* [Twinkle](https://github.com/piemonte/Twinkle) - Easy way to make elements in your iOS app twinkle.
* [UIDropDown](https://github.com/igongora/UIDropDown) - An elegant dropdown for iOS.
* [UIPheonix](https://github.com/MKGitHub/UIPheonix) - Easy, flexible, dynamic and highly scalable UI framework + concept for reusable component/control-driven apps.
* [URLEmbeddedView](https://github.com/marty-suzuki/URLEmbeddedView) - Automatically caches the object that is confirmed the Open Graph Protocol, and displays it as URL embedded card.
* [URWeatherView](https://github.com/jegumhon/URWeatherView) - Show weather effects onto a view.
* [Wallet](https://github.com/rshevchuk/Wallet) - A replica of the Apple's Wallet interface. Add, delete or present your cards and passes.
* [Windless](https://github.com/Interactive-Studio/Windless) - Windless makes it easy to implement invisible layout loading view.
* [WSTagsField](https://github.com/whitesmith/WSTagsField) - An iOS text field that represents different Tags.
* [YNSearch](https://github.com/younatics/YNSearch) - Awesome fully customizable search view like Pinterest.

#### Alert
*Libs to display alert, action sheet, notification, popup.* [back to top](#readme) 

* [Alertift](https://github.com/sgr-ksmt/Alertift) - Modern, easy UIAlertController wrapper.
* [AlertKit](https://github.com/thii/AlertKit) - Alert with a single line of code.
* [Alerts Pickers](https://github.com/dillidon/alerts-and-pickers) - Advanced usage of UIAlertController with TextField, DatePicker, PickerView, TableView and CollectionView.
* [CDAlertView](https://github.com/candostdagdeviren/CDAlertView) - Highly customizable alert/notification/success/error/alarm popup.
* [CFNotify](https://github.com/hallelujahbaby/CFNotify) - A customizable framework to create draggable alert views.
* [EZAlertController](https://github.com/thellimist/EZAlertController) - Easy UIAlertController.
* [GoogleWearAlert](https://github.com/AshRobinson/GoogleWearAlert) - Google Wear Alert style.
* [GSMessage](https://github.com/wxxsw/GSMessages) - A simple style messages/notifications for iOS 7+.
* [Hokusai](https://github.com/ytakzk/Hokusai) - A library for a cool bouncy action sheet.
* [HYAlertController](https://github.com/castial/HYAlertController) - A simple and minimalist iOS AlertController.
* [Jelly](https://github.com/SebastianBoldt/Jelly) - Jelly provides custom view controller transitions with just a few lines of code.
* [Kamagari](https://github.com/tasanobu/Kamagari) - Simple UIAlertController builder class.
* [KRAlertController](https://github.com/krimpedance/KRAlertController) - A beautiful alert controller for your iOS.
* [MaterialActionSheetController](https://github.com/ntnhon/MaterialActionSheetController) - A Google like action sheet, easy to use and customizable.
* [Notie](https://github.com/thii/Notie) - In-app notification, with customizable buttons and input text field.
* [NotificationBanner](https://github.com/Daltron/NotificationBanner) - The easiest way to display highly customizable in app notification banners in iOS.
* [PMAlertController](https://github.com/Codeido/PMAlertController) - PMAlertController is a great and customizable substitute to UIAlertController.
* [SCLAlertView](https://github.com/vikmeup/SCLAlertView-Swift) - Animated Alert view.
* [StatusAlert](https://github.com/LowKostKustomz/StatusAlert) - Display Apple system-like self-hiding status alerts without interrupting user flow.
* [SweetAlert](https://github.com/codestergit/SweetAlert-iOS) - Alert system.
* [Swift-Prompts](https://github.com/GabrielAlva/Swift-Prompts) - Design custom prompts with a great scope of options to choose from.
* [SwiftMessages](https://github.com/SwiftKickMobile/SwiftMessages) - A very flexible message bar for iOS.
* [SwiftOverlays](https://github.com/peterprokop/SwiftOverlays) - various popups and notifications.
* [SwiftyDrop](https://github.com/morizotter/SwiftyDrop) - Lightweight dropdown message bar.
* [Whisper](https://github.com/hyperoslo/Whisper) - Messages and in-app notification made easy.
* [XLActionController](https://github.com/xmartlabs/XLActionController) - Fully customizable and extensible action sheet controller.
* [Zingle](https://github.com/hemangshah/Zingle) - An alert will display underneath your UINavigationBar.

#### ApplicationDelegate
[back to top](#readme) 

* [SuperDelegate](https://github.com/Square/SuperDelegate) - SuperDelegate provides a clean application delegate interface and protects you from bugs in the application lifecycle.

#### Blur
[back to top](#readme) 

* [Blurable](https://github.com/FlexMonkey/Blurable) - Apply a Gaussian Blur to any UIView with Protocol Extensions.
* [PCLBlurEffectAlert](https://github.com/hryk224/PCLBlurEffectAlert) - AlertController with UIVisualeffectview.
* [VisualEffectView](https://github.com/efremidze/VisualEffectView) - UIVisualEffectView subclass with tint color.

#### Button
[back to top](#readme) 

* [AnimatablePlayButton](https://github.com/suzuki-0000/AnimatablePlayButton) - Animated Play and Pause Button using CALayer, CAKeyframeAnimation.
* [CRNetworkButton](https://github.com/Cleveroad/CRNetworkButton) - Send Button for iOS.
* [DOFavoriteButton](https://github.com/okmr-d/DOFavoriteButton) - Cute Animated Button.
* [Floaty](https://github.com/kciter/Floaty) - Floating Action Button for iOS.
* [Hamburger button transition](https://github.com/robb/hamburger-button) - Hamburger button transition.
* [HamburgerButton](https://github.com/fastred/HamburgerButton) - Hamburger button with a slick animation.
* [LGButton](https://github.com/loregr/LGButton) - A fully customisable subclass of the native UIControl which allows you to create beautiful buttons without writing any line of code.
* [LTHRadioButton](https://github.com/rolandleth/LTHRadioButton) - A radio button with a pretty animation.
* [MIBadgeButton](https://github.com/mustafaibrahim989/MIBadgeButton-Swift) - Notification badge for UIButtons.
* [MultiToggleButton](https://github.com/yonat/MultiToggleButton) - A UIButton subclass that implements tap-to-toggle button text (like the camera flash and timer buttons).
* [NFDownloadButton](https://github.com/LeonardoCardoso/NFDownloadButton) - Revamped Download Button. It's kinda a reverse engineering of Netflix's app download button.
* [PMSuperButton](https://github.com/Codeido/PMSuperButton) - A powerful UIButton with super powers, customizable from Storyboard.
* [SwiftShareBubbles](https://github.com/takecian/SwiftShareBubbles) - Animated social share buttons control for iOS.
* [TransitionButton](https://github.com/AladinWay/TransitionButton) - UIButton subclass for loading and transition animation.
* [TVButton](https://github.com/marmelroy/TVButton) - Recreating the cool parallax icons from Apple TV as iOS UIButtons.
* [ZFRippleButton](https://github.com/zoonooz/ZFRippleButton) - A ripple button animation.

#### Calendar
[back to top](#readme) 

* [CalendarKit](https://github.com/richardtop/CalendarKit) - Fully customizable calendar day view.
* [DateTimePicker](https://github.com/itsmeichigo/DateTimePicker) - A nicer iOS UI component for picking date and time.
* [JTAppleCalendar](https://github.com/patchthecode/JTAppleCalendar) - UI calendar handler.
* [Karmadust](https://github.com/mmick66/CalendarView) - Unidirectional Calendar Component with Native Events Support.
* [Koyomi](https://github.com/shoheiyokoyama/Koyomi) - Simple customizable calendar component.
* [Workaholic](https://github.com/hemangshah/Workaholic) - A GitHub-like work contribution timeline.

#### Form
[back to top](#readme) 

* [Eureka](https://github.com/xmartlabs/Eureka) - Elegant iOS form builder.
* [Former](https://github.com/ra1028/Former) - A fully customizable library for easy creating UITableView based form.
* [SwiftForms](https://github.com/ortuman/SwiftForms) - Forms are now easy as 1-2-3.
* [SwiftyFORM](https://github.com/neoneye/SwiftyFORM) - Forms that can be validated.

#### HUD
[back to top](#readme) 

* [EZLoadingActivity](https://github.com/goktugyil/EZLoadingActivity) - Lightweight loading activity HUD.
* [GradientLoadingBar](https://github.com/fxm90/GradientLoadingBar) - An animated gradient loading bar.
* [HUDKit](https://github.com/cockscomb/HUDKit) - HUD interface as UIPresentationController.
* [KRProgressHUD](https://github.com/krimpedance/KRProgressHUD) - A beautiful and customizable progress HUD.
* [PKHUD](https://github.com/pkluz/PKHUD) - Reimplementation of the Apple HUD.

#### Label
[back to top](#readme) 

* [ActiveLabel](https://github.com/optonaut/ActiveLabel.swift) - UILabel drop-in replacement supporting Hashtags (#), Mentions (@) and URLs (http://).
* [CharacterText](https://github.com/hulsizer/CharacterText) - Perform fx on UILabel.
* [CountdownLabel](https://github.com/suzuki-0000/CountdownLabel) - Simple countdown UILabel with morphing animation, and some useful function.
* [FloatLabelFields](https://github.com/FahimF/FloatLabelFields) - Text entry controls which contain a built-in title/label so that you don't have to add a separate title for each field.
* [GlitchLabel](https://github.com/kciter/GlitchLabel) - Glitching UILabel for iOS.
* [IncrementableLabel](https://github.com/tbaranes/IncrementableLabel) - An UILabel subclass to (de)increment numbers in an UILabel.
* [KDEDateLabel](https://github.com/delannoyk/KDEDateLabel) - An UILabel subclass that updates itself to make time ago's format easier.
* [LTMorphingLabel](https://github.com/lexrus/LTMorphingLabel) - Graceful morphing effects for UILabel.
* [NumberMorphView](https://github.com/me-abhinav/NumberMorphView) - A label view for displaying numbers which can transition or animate using a technique called number tweening or number morphing.
* [SlidingText](https://github.com/dnKaratzas/SlidingText) - UIView for sliding text with page indicator.
* [SMIconLabel](https://github.com/anatoliyv/SMIconLabel) - UILabel with image placed from left or right.
* [Translucid](https://github.com/Ekhoo/Translucid) - Lightweight library to set an Image as text background.
* [TriLabelView](https://github.com/mukeshthawani/TriLabelView) - A triangle shaped corner label view for iOS.

#### Menu
[back to top](#readme) 

* [AKSwiftSlideMenu](https://github.com/ashishkakkad8/AKSwiftSlideMenu) - Slide Menu (Drawer).
* [ENSwiftSideMenu](https://github.com/evnaz/ENSwiftSideMenu) - Sliding side menu.
* [FanMenu](https://github.com/exyte/fan-menu) - Menu with a circular layout based on Macaw.
* [FlowingMenu](https://github.com/yannickl/FlowingMenu) - Interactive view transition to display menus with flowing and bouncing effects.
* [FrostedSidebar](https://github.com/edekhayser/FrostedSidebar) - Hamburger Menu and iOS 8 API's.
* [GuillotineMenu](https://github.com/Yalantis/GuillotineMenu) - Guillotine style menu.
* [HHFloatingView](https://github.com/hemangshah/HHFloatingView) - An easy to use and setup floating view for your app.
* [InteractiveSideMenu](https://github.com/handsomecode/InteractiveSideMenu) - Customizable iOS Interactive Side Menu.
* [KWDrawerController](https://github.com/Kawoou/KWDrawerController) - Drawer view controller that easy to use.
* [MediumMenu](https://github.com/pixyzehn/MediumMenu) - A menu based on Medium iOS app.
* [MenuItemKit](https://github.com/cxa/MenuItemKit) - `UIMenuItem` with image and block (closure) support.
* [Pagemenu](https://github.com/PageMenu/PageMenu) - Pagination enabled view controller.
* [PagingKit](https://github.com/kazuhiro4949/PagingKit) - PagingKit provides customizable menu UI
* [PagingMenuController](https://github.com/kitasuke/PagingMenuController) - Paging view controller with customizable menu.
* [SideMenu](https://github.com/jonkykong/SideMenu) - Simple side menu control for iOS inspired by Facebook. Right and Left sides. No coding required.
* [SlideMenuControllerSwift](https://github.com/dekatotoro/SlideMenuControllerSwift) - iOS Slide Menu View based on Google+, iQON, Feedly, Ameba iOS app.
* [Swift-CircleMenu](https://github.com/Sufi-Al-Hussaini/Swift-CircleMenu) - Rotating circle menu.
* [SwipeMenuViewController](https://github.com/yysskk/SwipeMenuViewController) - Swipable tab and menu View and ViewController.
* [XLPagerTabStrip](https://github.com/xmartlabs/XLPagerTabStrip) - Android PagerTabStrip for iOS.
* [YNDropDownMenu](https://github.com/younatics/YNDropDownMenu) - Adorable iOS drop down menu.

#### Pagination
[back to top](#readme) 

* [CHIPageControl](https://github.com/ChiliLabs/CHIPageControl) - A set of cool animated page controls to replace boring UIPageControl.
* [Pageboy](https://github.com/uias/Pageboy) - A simple, highly informative page view controller.
* [PageController](https://github.com/hirohisa/PageController) - Infinite paging controller.
* [PageControls](https://github.com/popwarsweet/PageControls) - Custom UIPageControl.

#### Payment
[back to top](#readme) 

* [Caishen](https://github.com/prolificinteractive/Caishen) - A Payment Card UI & Validator for iOS.
* [iCard](https://github.com/eliakorkmaz/iCard) - Bank Card Generator using SnapKit DSL.
* [MFCard](https://github.com/MobileFirstInc/MFCard) - Easily integrate Credit Card payments in iOS App.

#### Permissions
[back to top](#readme) 

* [AREK](https://github.com/ennioma/arek) - AREK is a clean and easy to use wrapper over any kind of iOS permission.
* [Permission](https://github.com/delba/Permission) - A unified API to ask for permissions on iOS.
* [PermissionScope](https://github.com/nickoneill/PermissionScope) - A Periscope-inspired way to ask for iOS permissions.

#### StackView
[back to top](#readme) 

* [StackViewController](https://github.com/seedco/StackViewController) - Simplify the use of UIStackView.
* [TZStackView](https://github.com/tomvanzummeren/TZStackView) - An iOS9 UIStackView layout component re-implemented for iOS 7 and 8.

#### Switch
[back to top](#readme) 

* [AIFlatSwitch](https://github.com/cocoatoucher/AIFlatSwitch) - Flat animated switch.
* [LTJelloSwitch](https://github.com/lexrus/LTJelloSwitch) - UISwitch prototype.
* [Switch](https://github.com/T-Pham/Switch) - A switch control with full Interface Builder support.

#### Tab
[back to top](#readme) 

* [Adaptive Tab Bar](https://github.com/Ramotion/adaptive-tab-bar) - Adaptive tab bar.
* [Animated Tab Bar](https://github.com/Ramotion/animated-tab-bar) - RAMAnimatedTabBarController is a Swift module for adding animation to tab bar items.
* [ColorMatchTabs](https://github.com/Yalantis/ColorMatchTabs) - Interesting way to display tabs.
* [DTPagerController](https://github.com/tungvoduc/DTPagerController) - Container view controller to display a set of ViewControllers in a horizontal scroll view
* [HHTabBarView](https://github.com/hemangshah/HHTabBarView) - A lightweight customized tab bar view.
* [Tabman](https://github.com/uias/Tabman) - A powerful paging view controller with indicator bar.
* [TabPageViewController](https://github.com/EndouMari/TabPageViewController) - Paging view controller and scroll tab view.

#### Template
[back to top](#readme) 

* [Stencil](https://github.com/kylef/Stencil) - Simple and powerful template language.
* [SwiftCssParser](https://github.com/100mango/SwiftCssParser) - Extensible CSS parser.
* [TemplateKit](https://github.com/mcudich/TemplateKit) - React-inspired framework for building component-based user interfaces.

#### TextField
[back to top](#readme) 

* [CBPinEntryView](https://github.com/Fawxy/CBPinEntryView) - Easy to use, very customisable pin entry.
* [DTTextField](https://github.com/iDhaval/DTTextField) - DTTextField is a custom textfield with floating placeholder and error label.
* [HTYTextField](https://github.com/hanton/HTYTextField) - A UITextField with bouncy placeholder.
* [PasswordTextField](https://github.com/PiXeL16/PasswordTextField) - A custom TextField with a switchable icon which shows or hides the password and enforces good password policies.
* [SkyFloatingLabelTextField](https://github.com/Skyscanner/SkyFloatingLabelTextField) - A beautiful and flexible text field control implementation of "Float Label Pattern".
* [TaniwhaTextField](https://github.com/iceman201/TaniwhaTextField) - Lightweight and beautiful textfield framework, highly customisable, includes float label pattern.
* [TextFieldCounter](https://github.com/serralvo/TextFieldCounter) - UITextField character counter with lovable UX.
* [TextFieldEffects](https://github.com/raulriera/TextFieldEffects) - Several ready to use effects for UITextFields.
* [UITextField-Navigation](https://github.com/T-Pham/UITextField-Navigation) - UITextField-Navigation adds next, previous and done buttons to the keyboard for your UITextFields. Highly customizable.

#### Transition
[back to top](#readme) 

* [AudioIndicatorBars](https://github.com/LeonardoCardoso/AudioIndicatorBars) - AIB indicates for your app users which audio is playing. Just like the Podcasts app.
* [BubbleTransition](https://github.com/andreamazz/BubbleTransition) - Bubble transition in an easy way.
* [Cards XI](https://github.com/PaoloCuscela/Cards) - Awesome iOS 11 AppStore's Card Views.
* [ElasticTransition](https://github.com/lkzhao/ElasticTransition) - An interactive transition that simulates an elastic drag.
* [Hero](https://github.com/lkzhao/Hero) - Elegant transition library for iOS.
* [ImageOpenTransition](https://github.com/mcmatan/ImageOpenTransition) - Beautiful and precise transitions between ViewControllers images.
* [MusicPlayerTransition](https://github.com/xxxAIRINxxx/MusicPlayerTransition) - Custom interactive transition like Apple Music iOS App.
* [PinterestSwift](https://github.com/demonnico/PinterestSwift) - Pinterest style transition.
* [RevealingSplashView](https://github.com/PiXeL16/RevealingSplashView) - A Splash view that animates and reveals its content, inspired by the Twitter splash.
* [SendIndicator](https://github.com/LeonardoCardoso/SendIndicator) - Yet another task indicator.
* [StarWars.iOS](https://github.com/Yalantis/StarWars.iOS) - Transition animation to crumble view-controller into tiny pieces.
* [Transition](https://github.com/Touchwonders/Transition) - Easy interactive interruptible custom ViewController transitions.
* [TransitionManager](https://github.com/cemolcay/TransitionManager) - Painless custom transitioning. Easy extend, easy setup, just focus on animations.

#### UICollectionView
[back to top](#readme) 

* [AZCollectionViewController](https://github.com/AfrozZaheer/AZCollectionViewController) - Easy way to integrate pagination with dummy views in CollectionView, make Instagram Discover withing minutes.
* [BouncyLayout](https://github.com/roberthein/BouncyLayout) - Collection view layout that makes your cells bounce.
* [CardsLayout](https://github.com/filletofish/CardsLayout) - Nice card-designed custom CollectionView layout.
* [CenteredCollectionView](https://github.com/BenEmdon/CenteredCollectionView) - A lightweight UICollectionViewLayout that pages and centers it's cells.
* [CollectionViewShelfLayout](https://github.com/pitiphong-p/CollectionViewShelfLayout) - A UICollectionViewLayout subclass displays its items as rows of items similar to the App Store Feature tab without a nested UITableView/UICollectionView hack.
* [CollectionViewSlantedLayout](https://github.com/yacir/CollectionViewSlantedLayout) - UICollectionViewLayout to show slanted content.
* [Drag and Drop UICollectionView](https://github.com/mmick66/KDDragAndDropCollectionView) - Dragging and Dropping data across multiple UICollectionViews.
* [FSPagerView](https://github.com/WenchaoD/FSPagerView) - Elegant Screen Slide Library. It is extremely helpful for making Banner View、Product Show、Welcome/Guide Pages、Screen/ViewController Sliders.
* [GravitySlider](https://github.com/ApplikeySolutions/GravitySlider) - Beautiful alternative to the standard UICollectionView flow layout.
* [RAReorderableLayout](https://github.com/ra1028/RAReorderableLayout) - A UICollectionView layout which can move an item with drag and drop.
* [ReplaceAnimation](https://github.com/fruitcoder/ReplaceAnimation) - Pull-to-refresh animation in UICollectionView with a sticky header flow layout.
* [Sapporo](https://github.com/nghialv/Sapporo) - A cellmodel-driven CollectionView manager.
* [ShelfView-iOS](https://github.com/tdscientist/ShelfView-iOS) - iOS custom view to display books on shelf.
* [SwiftSpreadsheet](https://github.com/stuffrabbit/SwiftSpreadsheet) - Fully customizable spreadsheet CollectionViewLayout.
* [TagCellLayout](https://github.com/riteshhgupta/TagCellLayout) - UICollectionView layout for Tags with Left, Center & Right alignments.
* [VegaScroll](https://github.com/AppliKeySolutions/VegaScroll) - Lightweight animation flowlayout for UICollectionView completely written in Swift 4.

#### UITableView
[back to top](#readme) 

* [AZTableViewController](https://github.com/AfrozZaheer/AZTableViewController) - Elegant and easy way to integrate pagination with placeholder views.
* [DTTableViewManager](https://github.com/DenHeadless/DTTableViewManager) - Protocol-oriented UITableView management, powered by generics and associated types.
* [ExpandableCell](https://github.com/younatics/ExpandableCell) - Fully refactored YNExapnadableCell with more concise, bug free. Easiest usage of expandable & collapsible cell for iOS. You can customize expandable UITableViewCell whatever you like. ExpandableCell is made because insertRows and deleteRows is hard to use. Just inheirt ExpandableDelegate
* [ExpyTableView](https://github.com/okhanokbay/ExpyTableView) - Make your table view expandable just by implementing one method.
* [folding-cell](https://github.com/Ramotion/folding-cell) - Folding cell transition.
* [GridView](https://github.com/KyoheiG3/GridView) - Can be customized as a time table, spreadsheet, paging and more.
* [Hakuba](https://github.com/nghialv/Hakuba) - A new way to manage UITableView without the code of UITableViewDelegate and UITableViewDataSource.
* [HGPlaceholders](https://github.com/HamzaGhazouani/HGPlaceholders) - Nice library to show placeholders and Empty States for any UITableView/UICollectionView in your project.
* [ParallaxHeader](https://github.com/romansorochak/ParallaxHeader) - Simple way to add parallax header to UIScrollView/UITableView.
* [Persei](https://github.com/Yalantis/Persei) - Animated top menu for UITableView / UICollectionView / UIScrollView.
* [PullToRefreshSwift](https://github.com/dekatotoro/PullToRefreshSwift) - PullToRefresh library.
* [ReverseExtension](https://github.com/marty-suzuki/ReverseExtension) - UITableView extension that enables the insertion of cells the from bottom of a table view.
* [SectionScrubber](https://github.com/bakkenbaeck/SectionScrubber) - A component to quickly scroll between collection view sections.
* [Shoyu](https://github.com/yukiasai/Shoyu) - Easier way to represent the structure of UITableView.
* [SwipeCellKit](https://github.com/SwipeCellKit/SwipeCellKit) - Swipeable UITableViewCell based on the stock Mail.app.
* [YNExpandableCell](https://github.com/younatics/YNExpandableCell) - Awesome expandable, collapsible tableview cell for iOS.

#### Walkthrough
[back to top](#readme) 

* [AwesomeSpotlightView](https://github.com/aleksandrshoshiashvili/AwesomeSpotlightView) - Create tutorial or coach tour.
* [BWWalkthrough](https://github.com/ariok/BWWalkthrough) - A class to build custom walkthroughs for your iOS App.
* [Gecco](https://github.com/yukiasai/Gecco) - Spotlight view for iOS.
* [Instructions](https://github.com/ephread/Instructions) - A library to create app walkthroughs and guided tours.
* [RazzleDazzle](https://github.com/IFTTT/RazzleDazzle) - A simple keyframe-based animation framework for iOS. Perfect for scrolling app intros.
* [SwiftyOnboard](https://github.com/juanpablofernandez/SwiftyOnboard) - An iOS framework that allows developers to create beautiful onboarding experiences.
* [SwiftyWalkthrough](https://github.com/ruipfcosta/SwiftyWalkthrough) - The easiest way to create a great walkthrough experience in your apps.

### Utility
*Some interesting utilities to help you in your projects* [back to top](#readme) 

* [Alexandria](https://github.com/ovenbits/Alexandria) - A large set of convenience extensions for UIKit and Foundation.
* [AlexaSkillsKit](https://github.com/choefele/AlexaSkillsKit) - Develop custom Alexa Skills.
* [ArrayDiff](https://github.com/Adlai-Holler/ArrayDiff) - A fast, UITableView/UICollectionView-compatible array diffing microframework.
* [Basis](https://github.com/typelift/Basis) - Pure Declarative Programming.
* [Butterfly](https://github.com/wongzigii/Butterfly) - A lightweight library for integrating bug-report and feedback features with shake-motion event.
* [CallbackURLKit](https://github.com/phimage/CallbackURLKit) - Implementation of x-callback-url (Inter app communication).
* [Closures](https://github.com/vhesener/Closures) - Swifty closures for UIKit and Foundation.
* [Cormorant](https://github.com/austinzheng/Cormorant) - Clojure(ish) interpreter.
* [Curry](https://github.com/thoughtbot/Curry) - Function currying.
* [DeepDiff](https://github.com/onmyway133/DeepDiff) - Fast diff library.
* [Dollar](https://github.com/ankurp/Dollar) - Similar to Lo-Dash or Underscore in Javascript.
* [ExSwift](https://github.com/pNre/ExSwift) - Extensions for standard types and classes.
* [EZSwiftExtensions](https://github.com/goktugyil/EZSwiftExtensions) - How standard types and classes were supposed to work.
* [FluxCapacitor](https://github.com/marty-suzuki/FluxCapacitor) - FluxCapacitor makes implementing Flux design pattern easily with protocols and typealias.
* [Focus](https://github.com/typelift/Focus) - Optics library (includes Lens, Prisms, and Isos) that is inspired by Haskell's Lens library.
* [Highlighter](https://github.com/younatics/Highlighter) - Highlight whatever you want! Highlighter will magically find UI objects such as UILabel, UITextView, UITexTfield, UIButton in your UITableViewCell or other Class.
* [Hookah](https://github.com/HookahSwift/Hookah) - Functional library.
* [LifetimeTracker](https://github.com/krzysztofzablocki/LifetimeTracker) - Surface retain cycle / memory issues right as you develop your application.
* [ObjectiveKit](https://github.com/marmelroy/ObjectiveKit) - API for Objective C runtime functions.
* [OpenSourceController](https://github.com/floriangbh/OpenSourceController) - The simplest way to display the librarie's licences used in your application.
* [Popsicle](https://github.com/DavdRoman/Popsicle) - Delightful, extensible value interpolation framework.
* [Prelude](https://github.com/robrix/Prelude) - Framework of simple functional programming tools.
* [protobuf-swift](https://github.com/alexeyxo/protobuf-swift) - ProtocolBuffers.
* [Prototope](http://khan.github.io/Prototope/) - Library of lightweight interfaces for prototyping, bridged to JS.
* [Pythonic.swift](https://github.com/practicalswift/Pythonic.swift) - Selected parts of Python standard library.
* [R.swift](https://github.com/mac-cain13/R.swift) - Tool to get strong typed, autocompleted resources like images, cells and segues.
* [RandomKit](https://github.com/nvzqz/RandomKit/) :penguin: - Random data generation.
* [ReactiveArray](https://github.com/Wolox/ReactiveArray) - An array class that can be observed using ReactiveCocoa's Signals.
* [ReadabilityKit](https://github.com/exyte/ReadabilityKit) - Preview extractor for news, articles and full-texts.
* [ResourceKit](https://github.com/bannzai/ResourceKit) - Enable autocomplete use resources.
* [Result](https://github.com/antitypical/Result) - Type modelling the success/failure of arbitrary operations.
* [Runes](https://github.com/thoughtbot/Runes) - Functional operators: flatMap, map, apply.
* [seguecode](https://github.com/Adorkable/seguecode) - Support tool that provides compile-time safeties around building with UIStoryboards by exporting code regarding Scenes, Segues, Table and Collection Views and more.
* [Solar](https://github.com/ceeK/Solar) - Calculate sunrise and sunset times given a location.
* [SpriteKit+Spring](https://github.com/ataugeron/SpriteKit-Spring) - SpriteKit API reproducing UIView's spring animations with SKAction.
* [Sugar](https://github.com/hyperoslo/Sugar) - Something sweet that goes great with your Cocoa.
* [Swift Sugar](https://github.com/RuiAAPeres/Swift-Sugar) - Port of objsugar.
* [SwiftBitmask](https://github.com/brynbellomy/SwiftBitmask) - `Bitmask<T>` type intended as a replacement for `RawOptionSet`.
* [SwifterSwift](https://github.com/SwifterSwift/SwifterSwift) - A handy collection of more than 500 native Swift 3 extensions to boost your productivity. 
* [SwiftGen-Storyboard](https://github.com/SwiftGen/SwiftGen#uistoryboard) - A tool to auto-generate `enums` for all your Storyboards, Scenes and Segues constants + appropriate convenience accessors.
* [SwiftLinkPreview](https://github.com/LeonardoCardoso/SwiftLinkPreview) - It makes a preview from an url, grabbing all information such as title, relevant texts and images.
* [SwiftRandom](https://github.com/thellimist/SwiftRandom) - A tiny generator of random data.
* [SwiftRater](https://github.com/takecian/SwiftRater) - A utility that reminds your iPhone app's users to review the app.
* [SwiftSequence](https://github.com/oisdk/SwiftSequence) - A framework of extensions for SequenceType, inspired by Python's itertools.
* [SwiftSortUtils](https://github.com/dsmatter/SwiftSortUtils) - Useful functions and extensions for sorting.
* [SwiftTweaks](https://github.com/khan/swifttweaks) - Tweak your iOS app without recompiling.
* [Swiftx](https://github.com/typelift/Swiftx) - Functional data types and functions for any project.
* [SwiftyStateMachine](https://github.com/macoscope/SwiftyStateMachine) - Framework for creating state machines.
* [SwiftyUtils](https://github.com/tbaranes/SwiftyUtils) - All the reusable code that we need in each project.
* [Swiftz](https://github.com/typelift/Swiftz) - Functional programming.
* [Then](https://github.com/devxoul/Then) - Super sweet syntactic sugar for initializers.
* [undefined](https://github.com/weissi/swift-undefined) - Nano framework which defines Haskell's undefined.
* [URLQueryItemEncoder](https://github.com/pitiphong-p/URLQueryItemEncoder) - An Encoder for encoding any Encodable value into an array of URLQueryItem.
* [UTIKit](https://github.com/cockscomb/UTIKit) - an UTI (Uniform Type Identifier) wrapper.
* [WhatsNew](https://github.com/BalestraPatrick/WhatsNew) - Showcase new features after an app update similar to Pages, Numbers and Keynote.
* [XestiMonitors](https://github.com/eBardX/XestiMonitors) - An extensible monitoring framework.

### Validation
*A collection of validation libs.* [back to top](#readme) 

* [FormValidatorSwift](https://github.com/ustwo/formvalidator-swift) - Allows you to validate inputs of text fields and text views in a convenient way.
* [Honour](https://github.com/jeanpimentel/Honour) - Simple and powerful Validation Library.
* [Input Mask](https://github.com/RedMadRobot/input-mask-ios) - Pattern-based user input formatter, parser and validator for iOS.
* [SwiftValidator](https://github.com/SwiftValidatorCommunity/SwiftValidator) - A rule-based validation library.
* [SwiftValidators](https://github.com/gkaimakas/SwiftValidators) - String validation for iOS (inspired by validator.js).
* [Validator](https://github.com/adamwaite/Validator) - Drop in user input validation for your iOS apps.

#### Phone Numbers
[back to top](#readme) 

* [PhoneNumberKit](https://github.com/marmelroy/PhoneNumberKit) - Framework for parsing, formatting and validating international phone numbers. Inspired by Google's libphonenumber.

### Version Manager
[back to top](#readme) 

* [AppVersionMonitor](https://github.com/eure/AppVersionMonitor) - Monitor iOS app version easily.
* [Siren](https://github.com/ArtSabintsev/Siren) - Notify users when a new version of your app is available and prompt them to upgrade.
* [Version](https://github.com/mrackwitz/Version) - Version represents and compares semantic versions.
* [Version Tracker Swift](https://github.com/tbaranes/VersionTrackerSwift) - Versions tracker for your iOS, OS X, and tvOS app.
* [Version Update](https://github.com/tenric/VersionUpdate) - Check and update app's version for both AppStore & Fir.
* [Versions](https://github.com/zenangst/Versions) - Helping you find inner peace when comparing version numbers.
* [VersionsTracker](https://github.com/martnst/VersionsTracker) - Versions tracker keeping track of os and app version installation history including dates.

### Video
[back to top](#readme) 

* [BMPlayer](https://github.com/BrikerMan/BMPlayer) - A video player for iOS, based on AVPlayer, support the horizontal, vertical screen. support adjust volume, brigtness and seek by slide.
* [MMPlayerView](https://github.com/MillmanY/MMPlayerView) - Custom AVPlayerLayer on view and transition player with good effect like YouTube and Facebook.
* [MobilePlayer](https://github.com/mobileplayer/mobileplayer-ios) - A powerful and completely customizable media player for iOS.
* [NextLevelSessionExporter](https://github.com/NextLevel/NextLevelSessionExporter) - Export and transcode media.
* [Player](https://github.com/piemonte/Player) - iOS video player, simple drop in component for playing and streaming media.
* [PlayerView](https://github.com/davidlondono/PlayerView) - Easy to use video player using a UIView, manage rate of reproduction, screenshots and callbacks-delegate for player state.
* [PryntTrimmerView](https://github.com/prynt/PryntTrimmerView) - Trim and crop videos.
* [SwiftVideoBackground](https://github.com/dingwilson/SwiftVideoBackground) - Easy to Use UIView subclass for implementating a video background.
* [VGPlayer](https://github.com/VeinGuo/VGPlayer) - A simple iOS video player, support play local and network, background playback mode, automatic caching while playing.
