package webauthn

import (
	"testing"

	"github.com/duo-labs/webauthn/protocol"
)


func TestRegistration_FinishRegistrationFailure(t *testing.T) {
	user := &defaultUser{
		id: []byte("123"),
	}
	session := SessionData{
		UserID: []byte("ABC"),
	}

	webauthn := &WebAuthn{}
	credential, err := webauthn.FinishRegistration(user, session, nil)
	if err == nil {
		t.Errorf("FinishRegistration() error = nil, want %v", protocol.ErrBadRequest.Type)
	}
	if credential != nil {
		t.Errorf("FinishRegistration() credential = %v, want nil", credential)
	}
}
