// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package cognitoidentityprovider_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/cognitoidentityprovider"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleCognitoIdentityProvider_AddCustomAttributes() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AddCustomAttributesInput{
		CustomAttributes: []*cognitoidentityprovider.SchemaAttributeType{ // Required
			{ // Required
				AttributeDataType:      aws.String("AttributeDataType"),
				DeveloperOnlyAttribute: aws.Bool(true),
				Mutable:                aws.Bool(true),
				Name:                   aws.String("CustomAttributeNameType"),
				NumberAttributeConstraints: &cognitoidentityprovider.NumberAttributeConstraintsType{
					MaxValue: aws.String("StringType"),
					MinValue: aws.String("StringType"),
				},
				Required: aws.Bool(true),
				StringAttributeConstraints: &cognitoidentityprovider.StringAttributeConstraintsType{
					MaxLength: aws.String("StringType"),
					MinLength: aws.String("StringType"),
				},
			},
			// More values...
		},
		UserPoolId: aws.String("UserPoolIdType"), // Required
	}
	resp, err := svc.AddCustomAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminConfirmSignUp() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminConfirmSignUpInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminConfirmSignUp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminCreateUser() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminCreateUserInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
		DesiredDeliveryMediums: []*string{
			aws.String("DeliveryMediumType"), // Required
			// More values...
		},
		ForceAliasCreation: aws.Bool(true),
		MessageAction:      aws.String("MessageActionType"),
		TemporaryPassword:  aws.String("PasswordType"),
		UserAttributes: []*cognitoidentityprovider.AttributeType{
			{ // Required
				Name:  aws.String("AttributeNameType"), // Required
				Value: aws.String("AttributeValueType"),
			},
			// More values...
		},
		ValidationData: []*cognitoidentityprovider.AttributeType{
			{ // Required
				Name:  aws.String("AttributeNameType"), // Required
				Value: aws.String("AttributeValueType"),
			},
			// More values...
		},
	}
	resp, err := svc.AdminCreateUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminDeleteUser() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminDeleteUserInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminDeleteUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminDeleteUserAttributes() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminDeleteUserAttributesInput{
		UserAttributeNames: []*string{ // Required
			aws.String("AttributeNameType"), // Required
			// More values...
		},
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminDeleteUserAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminDisableUser() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminDisableUserInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminDisableUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminEnableUser() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminEnableUserInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminEnableUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminForgetDevice() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminForgetDeviceInput{
		DeviceKey:  aws.String("DeviceKeyType"),  // Required
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminForgetDevice(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminGetDevice() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminGetDeviceInput{
		DeviceKey:  aws.String("DeviceKeyType"),  // Required
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminGetDevice(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminGetUser() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminGetUserInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminGetUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminInitiateAuth() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminInitiateAuthInput{
		AuthFlow:   aws.String("AuthFlowType"),   // Required
		ClientId:   aws.String("ClientIdType"),   // Required
		UserPoolId: aws.String("UserPoolIdType"), // Required
		AuthParameters: map[string]*string{
			"Key": aws.String("StringType"), // Required
			// More values...
		},
		ClientMetadata: map[string]*string{
			"Key": aws.String("StringType"), // Required
			// More values...
		},
	}
	resp, err := svc.AdminInitiateAuth(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminListDevices() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminListDevicesInput{
		UserPoolId:      aws.String("UserPoolIdType"), // Required
		Username:        aws.String("UsernameType"),   // Required
		Limit:           aws.Int64(1),
		PaginationToken: aws.String("SearchPaginationTokenType"),
	}
	resp, err := svc.AdminListDevices(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminResetUserPassword() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminResetUserPasswordInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminResetUserPassword(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminRespondToAuthChallenge() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminRespondToAuthChallengeInput{
		ChallengeName: aws.String("ChallengeNameType"), // Required
		ClientId:      aws.String("ClientIdType"),      // Required
		UserPoolId:    aws.String("UserPoolIdType"),    // Required
		ChallengeResponses: map[string]*string{
			"Key": aws.String("StringType"), // Required
			// More values...
		},
		Session: aws.String("SessionType"),
	}
	resp, err := svc.AdminRespondToAuthChallenge(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminSetUserSettings() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminSetUserSettingsInput{
		MFAOptions: []*cognitoidentityprovider.MFAOptionType{ // Required
			{ // Required
				AttributeName:  aws.String("AttributeNameType"),
				DeliveryMedium: aws.String("DeliveryMediumType"),
			},
			// More values...
		},
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminSetUserSettings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminUpdateDeviceStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminUpdateDeviceStatusInput{
		DeviceKey:              aws.String("DeviceKeyType"),  // Required
		UserPoolId:             aws.String("UserPoolIdType"), // Required
		Username:               aws.String("UsernameType"),   // Required
		DeviceRememberedStatus: aws.String("DeviceRememberedStatusType"),
	}
	resp, err := svc.AdminUpdateDeviceStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminUpdateUserAttributes() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminUpdateUserAttributesInput{
		UserAttributes: []*cognitoidentityprovider.AttributeType{ // Required
			{ // Required
				Name:  aws.String("AttributeNameType"), // Required
				Value: aws.String("AttributeValueType"),
			},
			// More values...
		},
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminUpdateUserAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_AdminUserGlobalSignOut() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.AdminUserGlobalSignOutInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		Username:   aws.String("UsernameType"),   // Required
	}
	resp, err := svc.AdminUserGlobalSignOut(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ChangePassword() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ChangePasswordInput{
		PreviousPassword: aws.String("PasswordType"), // Required
		ProposedPassword: aws.String("PasswordType"), // Required
		AccessToken:      aws.String("TokenModelType"),
	}
	resp, err := svc.ChangePassword(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ConfirmDevice() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ConfirmDeviceInput{
		AccessToken: aws.String("TokenModelType"), // Required
		DeviceKey:   aws.String("DeviceKeyType"),  // Required
		DeviceName:  aws.String("DeviceNameType"),
		DeviceSecretVerifierConfig: &cognitoidentityprovider.DeviceSecretVerifierConfigType{
			PasswordVerifier: aws.String("StringType"),
			Salt:             aws.String("StringType"),
		},
	}
	resp, err := svc.ConfirmDevice(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ConfirmForgotPassword() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ConfirmForgotPasswordInput{
		ClientId:         aws.String("ClientIdType"),         // Required
		ConfirmationCode: aws.String("ConfirmationCodeType"), // Required
		Password:         aws.String("PasswordType"),         // Required
		Username:         aws.String("UsernameType"),         // Required
		SecretHash:       aws.String("SecretHashType"),
	}
	resp, err := svc.ConfirmForgotPassword(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ConfirmSignUp() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ConfirmSignUpInput{
		ClientId:           aws.String("ClientIdType"),         // Required
		ConfirmationCode:   aws.String("ConfirmationCodeType"), // Required
		Username:           aws.String("UsernameType"),         // Required
		ForceAliasCreation: aws.Bool(true),
		SecretHash:         aws.String("SecretHashType"),
	}
	resp, err := svc.ConfirmSignUp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_CreateUserImportJob() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.CreateUserImportJobInput{
		CloudWatchLogsRoleArn: aws.String("ArnType"),               // Required
		JobName:               aws.String("UserImportJobNameType"), // Required
		UserPoolId:            aws.String("UserPoolIdType"),        // Required
	}
	resp, err := svc.CreateUserImportJob(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_CreateUserPool() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.CreateUserPoolInput{
		PoolName: aws.String("UserPoolNameType"), // Required
		AdminCreateUserConfig: &cognitoidentityprovider.AdminCreateUserConfigType{
			AllowAdminCreateUserOnly: aws.Bool(true),
			InviteMessageTemplate: &cognitoidentityprovider.MessageTemplateType{
				EmailMessage: aws.String("EmailVerificationMessageType"),
				EmailSubject: aws.String("EmailVerificationSubjectType"),
				SMSMessage:   aws.String("SmsVerificationMessageType"),
			},
			UnusedAccountValidityDays: aws.Int64(1),
		},
		AliasAttributes: []*string{
			aws.String("AliasAttributeType"), // Required
			// More values...
		},
		AutoVerifiedAttributes: []*string{
			aws.String("VerifiedAttributeType"), // Required
			// More values...
		},
		DeviceConfiguration: &cognitoidentityprovider.DeviceConfigurationType{
			ChallengeRequiredOnNewDevice:     aws.Bool(true),
			DeviceOnlyRememberedOnUserPrompt: aws.Bool(true),
		},
		EmailConfiguration: &cognitoidentityprovider.EmailConfigurationType{
			ReplyToEmailAddress: aws.String("EmailAddressType"),
			SourceArn:           aws.String("ArnType"),
		},
		EmailVerificationMessage: aws.String("EmailVerificationMessageType"),
		EmailVerificationSubject: aws.String("EmailVerificationSubjectType"),
		LambdaConfig: &cognitoidentityprovider.LambdaConfigType{
			CreateAuthChallenge:         aws.String("ArnType"),
			CustomMessage:               aws.String("ArnType"),
			DefineAuthChallenge:         aws.String("ArnType"),
			PostAuthentication:          aws.String("ArnType"),
			PostConfirmation:            aws.String("ArnType"),
			PreAuthentication:           aws.String("ArnType"),
			PreSignUp:                   aws.String("ArnType"),
			VerifyAuthChallengeResponse: aws.String("ArnType"),
		},
		MfaConfiguration: aws.String("UserPoolMfaType"),
		Policies: &cognitoidentityprovider.UserPoolPolicyType{
			PasswordPolicy: &cognitoidentityprovider.PasswordPolicyType{
				MinimumLength:    aws.Int64(1),
				RequireLowercase: aws.Bool(true),
				RequireNumbers:   aws.Bool(true),
				RequireSymbols:   aws.Bool(true),
				RequireUppercase: aws.Bool(true),
			},
		},
		SmsAuthenticationMessage: aws.String("SmsVerificationMessageType"),
		SmsConfiguration: &cognitoidentityprovider.SmsConfigurationType{
			ExternalId:   aws.String("StringType"),
			SnsCallerArn: aws.String("ArnType"),
		},
		SmsVerificationMessage: aws.String("SmsVerificationMessageType"),
	}
	resp, err := svc.CreateUserPool(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_CreateUserPoolClient() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.CreateUserPoolClientInput{
		ClientName: aws.String("ClientNameType"), // Required
		UserPoolId: aws.String("UserPoolIdType"), // Required
		ExplicitAuthFlows: []*string{
			aws.String("ExplicitAuthFlowsType"), // Required
			// More values...
		},
		GenerateSecret: aws.Bool(true),
		ReadAttributes: []*string{
			aws.String("ClientPermissionType"), // Required
			// More values...
		},
		RefreshTokenValidity: aws.Int64(1),
		WriteAttributes: []*string{
			aws.String("ClientPermissionType"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateUserPoolClient(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_DeleteUser() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.DeleteUserInput{
		AccessToken: aws.String("TokenModelType"),
	}
	resp, err := svc.DeleteUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_DeleteUserAttributes() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.DeleteUserAttributesInput{
		UserAttributeNames: []*string{ // Required
			aws.String("AttributeNameType"), // Required
			// More values...
		},
		AccessToken: aws.String("TokenModelType"),
	}
	resp, err := svc.DeleteUserAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_DeleteUserPool() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.DeleteUserPoolInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
	}
	resp, err := svc.DeleteUserPool(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_DeleteUserPoolClient() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.DeleteUserPoolClientInput{
		ClientId:   aws.String("ClientIdType"),   // Required
		UserPoolId: aws.String("UserPoolIdType"), // Required
	}
	resp, err := svc.DeleteUserPoolClient(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_DescribeUserImportJob() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.DescribeUserImportJobInput{
		JobId:      aws.String("UserImportJobIdType"), // Required
		UserPoolId: aws.String("UserPoolIdType"),      // Required
	}
	resp, err := svc.DescribeUserImportJob(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_DescribeUserPool() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.DescribeUserPoolInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
	}
	resp, err := svc.DescribeUserPool(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_DescribeUserPoolClient() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.DescribeUserPoolClientInput{
		ClientId:   aws.String("ClientIdType"),   // Required
		UserPoolId: aws.String("UserPoolIdType"), // Required
	}
	resp, err := svc.DescribeUserPoolClient(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ForgetDevice() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ForgetDeviceInput{
		DeviceKey:   aws.String("DeviceKeyType"), // Required
		AccessToken: aws.String("TokenModelType"),
	}
	resp, err := svc.ForgetDevice(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ForgotPassword() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ForgotPasswordInput{
		ClientId:   aws.String("ClientIdType"), // Required
		Username:   aws.String("UsernameType"), // Required
		SecretHash: aws.String("SecretHashType"),
	}
	resp, err := svc.ForgotPassword(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_GetCSVHeader() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.GetCSVHeaderInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
	}
	resp, err := svc.GetCSVHeader(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_GetDevice() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.GetDeviceInput{
		DeviceKey:   aws.String("DeviceKeyType"), // Required
		AccessToken: aws.String("TokenModelType"),
	}
	resp, err := svc.GetDevice(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_GetUser() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.GetUserInput{
		AccessToken: aws.String("TokenModelType"),
	}
	resp, err := svc.GetUser(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_GetUserAttributeVerificationCode() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.GetUserAttributeVerificationCodeInput{
		AttributeName: aws.String("AttributeNameType"), // Required
		AccessToken:   aws.String("TokenModelType"),
	}
	resp, err := svc.GetUserAttributeVerificationCode(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_GlobalSignOut() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.GlobalSignOutInput{
		AccessToken: aws.String("TokenModelType"),
	}
	resp, err := svc.GlobalSignOut(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_InitiateAuth() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.InitiateAuthInput{
		AuthFlow: aws.String("AuthFlowType"), // Required
		ClientId: aws.String("ClientIdType"), // Required
		AuthParameters: map[string]*string{
			"Key": aws.String("StringType"), // Required
			// More values...
		},
		ClientMetadata: map[string]*string{
			"Key": aws.String("StringType"), // Required
			// More values...
		},
	}
	resp, err := svc.InitiateAuth(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ListDevices() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ListDevicesInput{
		AccessToken:     aws.String("TokenModelType"), // Required
		Limit:           aws.Int64(1),
		PaginationToken: aws.String("SearchPaginationTokenType"),
	}
	resp, err := svc.ListDevices(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ListUserImportJobs() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ListUserImportJobsInput{
		MaxResults:      aws.Int64(1),                 // Required
		UserPoolId:      aws.String("UserPoolIdType"), // Required
		PaginationToken: aws.String("PaginationKeyType"),
	}
	resp, err := svc.ListUserImportJobs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ListUserPoolClients() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ListUserPoolClientsInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationKey"),
	}
	resp, err := svc.ListUserPoolClients(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ListUserPools() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ListUserPoolsInput{
		MaxResults: aws.Int64(1), // Required
		NextToken:  aws.String("PaginationKeyType"),
	}
	resp, err := svc.ListUserPools(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ListUsers() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ListUsersInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		AttributesToGet: []*string{
			aws.String("AttributeNameType"), // Required
			// More values...
		},
		Filter:          aws.String("UserFilterType"),
		Limit:           aws.Int64(1),
		PaginationToken: aws.String("SearchPaginationTokenType"),
	}
	resp, err := svc.ListUsers(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_ResendConfirmationCode() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.ResendConfirmationCodeInput{
		ClientId:   aws.String("ClientIdType"), // Required
		Username:   aws.String("UsernameType"), // Required
		SecretHash: aws.String("SecretHashType"),
	}
	resp, err := svc.ResendConfirmationCode(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_RespondToAuthChallenge() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.RespondToAuthChallengeInput{
		ChallengeName: aws.String("ChallengeNameType"), // Required
		ClientId:      aws.String("ClientIdType"),      // Required
		ChallengeResponses: map[string]*string{
			"Key": aws.String("StringType"), // Required
			// More values...
		},
		Session: aws.String("SessionType"),
	}
	resp, err := svc.RespondToAuthChallenge(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_SetUserSettings() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.SetUserSettingsInput{
		AccessToken: aws.String("TokenModelType"), // Required
		MFAOptions: []*cognitoidentityprovider.MFAOptionType{ // Required
			{ // Required
				AttributeName:  aws.String("AttributeNameType"),
				DeliveryMedium: aws.String("DeliveryMediumType"),
			},
			// More values...
		},
	}
	resp, err := svc.SetUserSettings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_SignUp() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.SignUpInput{
		ClientId:   aws.String("ClientIdType"), // Required
		Password:   aws.String("PasswordType"), // Required
		Username:   aws.String("UsernameType"), // Required
		SecretHash: aws.String("SecretHashType"),
		UserAttributes: []*cognitoidentityprovider.AttributeType{
			{ // Required
				Name:  aws.String("AttributeNameType"), // Required
				Value: aws.String("AttributeValueType"),
			},
			// More values...
		},
		ValidationData: []*cognitoidentityprovider.AttributeType{
			{ // Required
				Name:  aws.String("AttributeNameType"), // Required
				Value: aws.String("AttributeValueType"),
			},
			// More values...
		},
	}
	resp, err := svc.SignUp(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_StartUserImportJob() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.StartUserImportJobInput{
		JobId:      aws.String("UserImportJobIdType"), // Required
		UserPoolId: aws.String("UserPoolIdType"),      // Required
	}
	resp, err := svc.StartUserImportJob(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_StopUserImportJob() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.StopUserImportJobInput{
		JobId:      aws.String("UserImportJobIdType"), // Required
		UserPoolId: aws.String("UserPoolIdType"),      // Required
	}
	resp, err := svc.StopUserImportJob(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_UpdateDeviceStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.UpdateDeviceStatusInput{
		AccessToken:            aws.String("TokenModelType"), // Required
		DeviceKey:              aws.String("DeviceKeyType"),  // Required
		DeviceRememberedStatus: aws.String("DeviceRememberedStatusType"),
	}
	resp, err := svc.UpdateDeviceStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_UpdateUserAttributes() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.UpdateUserAttributesInput{
		UserAttributes: []*cognitoidentityprovider.AttributeType{ // Required
			{ // Required
				Name:  aws.String("AttributeNameType"), // Required
				Value: aws.String("AttributeValueType"),
			},
			// More values...
		},
		AccessToken: aws.String("TokenModelType"),
	}
	resp, err := svc.UpdateUserAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_UpdateUserPool() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.UpdateUserPoolInput{
		UserPoolId: aws.String("UserPoolIdType"), // Required
		AdminCreateUserConfig: &cognitoidentityprovider.AdminCreateUserConfigType{
			AllowAdminCreateUserOnly: aws.Bool(true),
			InviteMessageTemplate: &cognitoidentityprovider.MessageTemplateType{
				EmailMessage: aws.String("EmailVerificationMessageType"),
				EmailSubject: aws.String("EmailVerificationSubjectType"),
				SMSMessage:   aws.String("SmsVerificationMessageType"),
			},
			UnusedAccountValidityDays: aws.Int64(1),
		},
		AutoVerifiedAttributes: []*string{
			aws.String("VerifiedAttributeType"), // Required
			// More values...
		},
		DeviceConfiguration: &cognitoidentityprovider.DeviceConfigurationType{
			ChallengeRequiredOnNewDevice:     aws.Bool(true),
			DeviceOnlyRememberedOnUserPrompt: aws.Bool(true),
		},
		EmailConfiguration: &cognitoidentityprovider.EmailConfigurationType{
			ReplyToEmailAddress: aws.String("EmailAddressType"),
			SourceArn:           aws.String("ArnType"),
		},
		EmailVerificationMessage: aws.String("EmailVerificationMessageType"),
		EmailVerificationSubject: aws.String("EmailVerificationSubjectType"),
		LambdaConfig: &cognitoidentityprovider.LambdaConfigType{
			CreateAuthChallenge:         aws.String("ArnType"),
			CustomMessage:               aws.String("ArnType"),
			DefineAuthChallenge:         aws.String("ArnType"),
			PostAuthentication:          aws.String("ArnType"),
			PostConfirmation:            aws.String("ArnType"),
			PreAuthentication:           aws.String("ArnType"),
			PreSignUp:                   aws.String("ArnType"),
			VerifyAuthChallengeResponse: aws.String("ArnType"),
		},
		MfaConfiguration: aws.String("UserPoolMfaType"),
		Policies: &cognitoidentityprovider.UserPoolPolicyType{
			PasswordPolicy: &cognitoidentityprovider.PasswordPolicyType{
				MinimumLength:    aws.Int64(1),
				RequireLowercase: aws.Bool(true),
				RequireNumbers:   aws.Bool(true),
				RequireSymbols:   aws.Bool(true),
				RequireUppercase: aws.Bool(true),
			},
		},
		SmsAuthenticationMessage: aws.String("SmsVerificationMessageType"),
		SmsConfiguration: &cognitoidentityprovider.SmsConfigurationType{
			ExternalId:   aws.String("StringType"),
			SnsCallerArn: aws.String("ArnType"),
		},
		SmsVerificationMessage: aws.String("SmsVerificationMessageType"),
	}
	resp, err := svc.UpdateUserPool(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_UpdateUserPoolClient() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.UpdateUserPoolClientInput{
		ClientId:   aws.String("ClientIdType"),   // Required
		UserPoolId: aws.String("UserPoolIdType"), // Required
		ClientName: aws.String("ClientNameType"),
		ExplicitAuthFlows: []*string{
			aws.String("ExplicitAuthFlowsType"), // Required
			// More values...
		},
		ReadAttributes: []*string{
			aws.String("ClientPermissionType"), // Required
			// More values...
		},
		RefreshTokenValidity: aws.Int64(1),
		WriteAttributes: []*string{
			aws.String("ClientPermissionType"), // Required
			// More values...
		},
	}
	resp, err := svc.UpdateUserPoolClient(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleCognitoIdentityProvider_VerifyUserAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := cognitoidentityprovider.New(sess)

	params := &cognitoidentityprovider.VerifyUserAttributeInput{
		AttributeName: aws.String("AttributeNameType"),    // Required
		Code:          aws.String("ConfirmationCodeType"), // Required
		AccessToken:   aws.String("TokenModelType"),
	}
	resp, err := svc.VerifyUserAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
