// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"math"
	"strings"
)

type awsRestjson1_deserializeOpAcceptAdministratorInvitation struct {
}

func (*awsRestjson1_deserializeOpAcceptAdministratorInvitation) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpAcceptAdministratorInvitation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorAcceptAdministratorInvitation(response, &metadata)
	}
	output := &AcceptAdministratorInvitationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorAcceptAdministratorInvitation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpAcceptInvitation struct {
}

func (*awsRestjson1_deserializeOpAcceptInvitation) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpAcceptInvitation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorAcceptInvitation(response, &metadata)
	}
	output := &AcceptInvitationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorAcceptInvitation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpBatchDeleteAutomationRules struct {
}

func (*awsRestjson1_deserializeOpBatchDeleteAutomationRules) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchDeleteAutomationRules) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchDeleteAutomationRules(response, &metadata)
	}
	output := &BatchDeleteAutomationRulesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchDeleteAutomationRulesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchDeleteAutomationRules(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchDeleteAutomationRulesOutput(v **BatchDeleteAutomationRulesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchDeleteAutomationRulesOutput
	if *v == nil {
		sv = &BatchDeleteAutomationRulesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ProcessedAutomationRules":
			if err := awsRestjson1_deserializeDocumentAutomationRulesArnsList(&sv.ProcessedAutomationRules, value); err != nil {
				return err
			}

		case "UnprocessedAutomationRules":
			if err := awsRestjson1_deserializeDocumentUnprocessedAutomationRulesList(&sv.UnprocessedAutomationRules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchDisableStandards struct {
}

func (*awsRestjson1_deserializeOpBatchDisableStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchDisableStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchDisableStandards(response, &metadata)
	}
	output := &BatchDisableStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchDisableStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchDisableStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchDisableStandardsOutput(v **BatchDisableStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchDisableStandardsOutput
	if *v == nil {
		sv = &BatchDisableStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StandardsSubscriptions":
			if err := awsRestjson1_deserializeDocumentStandardsSubscriptions(&sv.StandardsSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchEnableStandards struct {
}

func (*awsRestjson1_deserializeOpBatchEnableStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchEnableStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchEnableStandards(response, &metadata)
	}
	output := &BatchEnableStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchEnableStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchEnableStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchEnableStandardsOutput(v **BatchEnableStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchEnableStandardsOutput
	if *v == nil {
		sv = &BatchEnableStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StandardsSubscriptions":
			if err := awsRestjson1_deserializeDocumentStandardsSubscriptions(&sv.StandardsSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchGetAutomationRules struct {
}

func (*awsRestjson1_deserializeOpBatchGetAutomationRules) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchGetAutomationRules) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchGetAutomationRules(response, &metadata)
	}
	output := &BatchGetAutomationRulesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchGetAutomationRulesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchGetAutomationRules(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchGetAutomationRulesOutput(v **BatchGetAutomationRulesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchGetAutomationRulesOutput
	if *v == nil {
		sv = &BatchGetAutomationRulesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Rules":
			if err := awsRestjson1_deserializeDocumentAutomationRulesConfigList(&sv.Rules, value); err != nil {
				return err
			}

		case "UnprocessedAutomationRules":
			if err := awsRestjson1_deserializeDocumentUnprocessedAutomationRulesList(&sv.UnprocessedAutomationRules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchGetConfigurationPolicyAssociations struct {
}

func (*awsRestjson1_deserializeOpBatchGetConfigurationPolicyAssociations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchGetConfigurationPolicyAssociations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchGetConfigurationPolicyAssociations(response, &metadata)
	}
	output := &BatchGetConfigurationPolicyAssociationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchGetConfigurationPolicyAssociationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchGetConfigurationPolicyAssociations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchGetConfigurationPolicyAssociationsOutput(v **BatchGetConfigurationPolicyAssociationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchGetConfigurationPolicyAssociationsOutput
	if *v == nil {
		sv = &BatchGetConfigurationPolicyAssociationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ConfigurationPolicyAssociations":
			if err := awsRestjson1_deserializeDocumentConfigurationPolicyAssociationList(&sv.ConfigurationPolicyAssociations, value); err != nil {
				return err
			}

		case "UnprocessedConfigurationPolicyAssociations":
			if err := awsRestjson1_deserializeDocumentUnprocessedConfigurationPolicyAssociationList(&sv.UnprocessedConfigurationPolicyAssociations, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchGetSecurityControls struct {
}

func (*awsRestjson1_deserializeOpBatchGetSecurityControls) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchGetSecurityControls) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchGetSecurityControls(response, &metadata)
	}
	output := &BatchGetSecurityControlsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchGetSecurityControlsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchGetSecurityControls(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchGetSecurityControlsOutput(v **BatchGetSecurityControlsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchGetSecurityControlsOutput
	if *v == nil {
		sv = &BatchGetSecurityControlsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SecurityControls":
			if err := awsRestjson1_deserializeDocumentSecurityControls(&sv.SecurityControls, value); err != nil {
				return err
			}

		case "UnprocessedIds":
			if err := awsRestjson1_deserializeDocumentUnprocessedSecurityControls(&sv.UnprocessedIds, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchGetStandardsControlAssociations struct {
}

func (*awsRestjson1_deserializeOpBatchGetStandardsControlAssociations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchGetStandardsControlAssociations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchGetStandardsControlAssociations(response, &metadata)
	}
	output := &BatchGetStandardsControlAssociationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchGetStandardsControlAssociationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchGetStandardsControlAssociations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchGetStandardsControlAssociationsOutput(v **BatchGetStandardsControlAssociationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchGetStandardsControlAssociationsOutput
	if *v == nil {
		sv = &BatchGetStandardsControlAssociationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StandardsControlAssociationDetails":
			if err := awsRestjson1_deserializeDocumentStandardsControlAssociationDetails(&sv.StandardsControlAssociationDetails, value); err != nil {
				return err
			}

		case "UnprocessedAssociations":
			if err := awsRestjson1_deserializeDocumentUnprocessedStandardsControlAssociations(&sv.UnprocessedAssociations, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchImportFindings struct {
}

func (*awsRestjson1_deserializeOpBatchImportFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchImportFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchImportFindings(response, &metadata)
	}
	output := &BatchImportFindingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchImportFindingsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchImportFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchImportFindingsOutput(v **BatchImportFindingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchImportFindingsOutput
	if *v == nil {
		sv = &BatchImportFindingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FailedCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FailedCount = ptr.Int32(int32(i64))
			}

		case "FailedFindings":
			if err := awsRestjson1_deserializeDocumentImportFindingsErrorList(&sv.FailedFindings, value); err != nil {
				return err
			}

		case "SuccessCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SuccessCount = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchUpdateAutomationRules struct {
}

func (*awsRestjson1_deserializeOpBatchUpdateAutomationRules) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchUpdateAutomationRules) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchUpdateAutomationRules(response, &metadata)
	}
	output := &BatchUpdateAutomationRulesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchUpdateAutomationRulesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchUpdateAutomationRules(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchUpdateAutomationRulesOutput(v **BatchUpdateAutomationRulesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchUpdateAutomationRulesOutput
	if *v == nil {
		sv = &BatchUpdateAutomationRulesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ProcessedAutomationRules":
			if err := awsRestjson1_deserializeDocumentAutomationRulesArnsList(&sv.ProcessedAutomationRules, value); err != nil {
				return err
			}

		case "UnprocessedAutomationRules":
			if err := awsRestjson1_deserializeDocumentUnprocessedAutomationRulesList(&sv.UnprocessedAutomationRules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchUpdateFindings struct {
}

func (*awsRestjson1_deserializeOpBatchUpdateFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchUpdateFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchUpdateFindings(response, &metadata)
	}
	output := &BatchUpdateFindingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchUpdateFindingsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchUpdateFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchUpdateFindingsOutput(v **BatchUpdateFindingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchUpdateFindingsOutput
	if *v == nil {
		sv = &BatchUpdateFindingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ProcessedFindings":
			if err := awsRestjson1_deserializeDocumentAwsSecurityFindingIdentifierList(&sv.ProcessedFindings, value); err != nil {
				return err
			}

		case "UnprocessedFindings":
			if err := awsRestjson1_deserializeDocumentBatchUpdateFindingsUnprocessedFindingsList(&sv.UnprocessedFindings, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchUpdateStandardsControlAssociations struct {
}

func (*awsRestjson1_deserializeOpBatchUpdateStandardsControlAssociations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchUpdateStandardsControlAssociations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchUpdateStandardsControlAssociations(response, &metadata)
	}
	output := &BatchUpdateStandardsControlAssociationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchUpdateStandardsControlAssociationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchUpdateStandardsControlAssociations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchUpdateStandardsControlAssociationsOutput(v **BatchUpdateStandardsControlAssociationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchUpdateStandardsControlAssociationsOutput
	if *v == nil {
		sv = &BatchUpdateStandardsControlAssociationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAssociationUpdates":
			if err := awsRestjson1_deserializeDocumentUnprocessedStandardsControlAssociationUpdates(&sv.UnprocessedAssociationUpdates, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateActionTarget struct {
}

func (*awsRestjson1_deserializeOpCreateActionTarget) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateActionTarget) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateActionTarget(response, &metadata)
	}
	output := &CreateActionTargetOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateActionTargetOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateActionTarget(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateActionTargetOutput(v **CreateActionTargetOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateActionTargetOutput
	if *v == nil {
		sv = &CreateActionTargetOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionTargetArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateAutomationRule struct {
}

func (*awsRestjson1_deserializeOpCreateAutomationRule) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateAutomationRule) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateAutomationRule(response, &metadata)
	}
	output := &CreateAutomationRuleOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateAutomationRuleOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateAutomationRule(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateAutomationRuleOutput(v **CreateAutomationRuleOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateAutomationRuleOutput
	if *v == nil {
		sv = &CreateAutomationRuleOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RuleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateConfigurationPolicy struct {
}

func (*awsRestjson1_deserializeOpCreateConfigurationPolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateConfigurationPolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateConfigurationPolicy(response, &metadata)
	}
	output := &CreateConfigurationPolicyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateConfigurationPolicyOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateConfigurationPolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateConfigurationPolicyOutput(v **CreateConfigurationPolicyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateConfigurationPolicyOutput
	if *v == nil {
		sv = &CreateConfigurationPolicyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "ConfigurationPolicy":
			if err := awsRestjson1_deserializeDocumentPolicy(&sv.ConfigurationPolicy, value); err != nil {
				return err
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.CreatedAt = ptr.Time(t)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateFindingAggregator struct {
}

func (*awsRestjson1_deserializeOpCreateFindingAggregator) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateFindingAggregator) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateFindingAggregator(response, &metadata)
	}
	output := &CreateFindingAggregatorOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateFindingAggregatorOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateFindingAggregator(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateFindingAggregatorOutput(v **CreateFindingAggregatorOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateFindingAggregatorOutput
	if *v == nil {
		sv = &CreateFindingAggregatorOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FindingAggregationRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FindingAggregationRegion = ptr.String(jtv)
			}

		case "FindingAggregatorArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FindingAggregatorArn = ptr.String(jtv)
			}

		case "RegionLinkingMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegionLinkingMode = ptr.String(jtv)
			}

		case "Regions":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.Regions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateInsight struct {
}

func (*awsRestjson1_deserializeOpCreateInsight) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateInsight) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateInsight(response, &metadata)
	}
	output := &CreateInsightOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateInsightOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateInsight(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateInsightOutput(v **CreateInsightOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateInsightOutput
	if *v == nil {
		sv = &CreateInsightOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InsightArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InsightArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateMembers struct {
}

func (*awsRestjson1_deserializeOpCreateMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateMembers(response, &metadata)
	}
	output := &CreateMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateMembersOutput(v **CreateMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateMembersOutput
	if *v == nil {
		sv = &CreateMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeclineInvitations struct {
}

func (*awsRestjson1_deserializeOpDeclineInvitations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeclineInvitations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeclineInvitations(response, &metadata)
	}
	output := &DeclineInvitationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeclineInvitationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeclineInvitations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeclineInvitationsOutput(v **DeclineInvitationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeclineInvitationsOutput
	if *v == nil {
		sv = &DeclineInvitationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteActionTarget struct {
}

func (*awsRestjson1_deserializeOpDeleteActionTarget) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteActionTarget) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteActionTarget(response, &metadata)
	}
	output := &DeleteActionTargetOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteActionTargetOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteActionTarget(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteActionTargetOutput(v **DeleteActionTargetOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteActionTargetOutput
	if *v == nil {
		sv = &DeleteActionTargetOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionTargetArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteConfigurationPolicy struct {
}

func (*awsRestjson1_deserializeOpDeleteConfigurationPolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteConfigurationPolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteConfigurationPolicy(response, &metadata)
	}
	output := &DeleteConfigurationPolicyOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteConfigurationPolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDeleteFindingAggregator struct {
}

func (*awsRestjson1_deserializeOpDeleteFindingAggregator) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteFindingAggregator) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteFindingAggregator(response, &metadata)
	}
	output := &DeleteFindingAggregatorOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteFindingAggregator(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDeleteInsight struct {
}

func (*awsRestjson1_deserializeOpDeleteInsight) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteInsight) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteInsight(response, &metadata)
	}
	output := &DeleteInsightOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteInsightOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteInsight(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteInsightOutput(v **DeleteInsightOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteInsightOutput
	if *v == nil {
		sv = &DeleteInsightOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InsightArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InsightArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteInvitations struct {
}

func (*awsRestjson1_deserializeOpDeleteInvitations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteInvitations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteInvitations(response, &metadata)
	}
	output := &DeleteInvitationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteInvitationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteInvitations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteInvitationsOutput(v **DeleteInvitationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteInvitationsOutput
	if *v == nil {
		sv = &DeleteInvitationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteMembers struct {
}

func (*awsRestjson1_deserializeOpDeleteMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteMembers(response, &metadata)
	}
	output := &DeleteMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteMembersOutput(v **DeleteMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteMembersOutput
	if *v == nil {
		sv = &DeleteMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeActionTargets struct {
}

func (*awsRestjson1_deserializeOpDescribeActionTargets) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeActionTargets) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeActionTargets(response, &metadata)
	}
	output := &DescribeActionTargetsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeActionTargetsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeActionTargets(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeActionTargetsOutput(v **DescribeActionTargetsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeActionTargetsOutput
	if *v == nil {
		sv = &DescribeActionTargetsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargets":
			if err := awsRestjson1_deserializeDocumentActionTargetList(&sv.ActionTargets, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeHub struct {
}

func (*awsRestjson1_deserializeOpDescribeHub) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeHub) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeHub(response, &metadata)
	}
	output := &DescribeHubOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeHubOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeHub(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeHubOutput(v **DescribeHubOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeHubOutput
	if *v == nil {
		sv = &DescribeHubOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutoEnableControls":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoEnableControls = ptr.Bool(jtv)
			}

		case "ControlFindingGenerator":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ControlFindingGenerator to be of type string, got %T instead", value)
				}
				sv.ControlFindingGenerator = types.ControlFindingGenerator(jtv)
			}

		case "HubArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HubArn = ptr.String(jtv)
			}

		case "SubscribedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubscribedAt = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeOrganizationConfiguration struct {
}

func (*awsRestjson1_deserializeOpDescribeOrganizationConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeOrganizationConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeOrganizationConfiguration(response, &metadata)
	}
	output := &DescribeOrganizationConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeOrganizationConfigurationOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeOrganizationConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeOrganizationConfigurationOutput(v **DescribeOrganizationConfigurationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeOrganizationConfigurationOutput
	if *v == nil {
		sv = &DescribeOrganizationConfigurationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutoEnable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoEnable = ptr.Bool(jtv)
			}

		case "AutoEnableStandards":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AutoEnableStandards to be of type string, got %T instead", value)
				}
				sv.AutoEnableStandards = types.AutoEnableStandards(jtv)
			}

		case "MemberAccountLimitReached":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MemberAccountLimitReached = ptr.Bool(jtv)
			}

		case "OrganizationConfiguration":
			if err := awsRestjson1_deserializeDocumentOrganizationConfiguration(&sv.OrganizationConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeProducts struct {
}

func (*awsRestjson1_deserializeOpDescribeProducts) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeProducts) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeProducts(response, &metadata)
	}
	output := &DescribeProductsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeProductsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeProducts(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeProductsOutput(v **DescribeProductsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeProductsOutput
	if *v == nil {
		sv = &DescribeProductsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "Products":
			if err := awsRestjson1_deserializeDocumentProductsList(&sv.Products, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeStandards struct {
}

func (*awsRestjson1_deserializeOpDescribeStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeStandards(response, &metadata)
	}
	output := &DescribeStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeStandardsOutput(v **DescribeStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeStandardsOutput
	if *v == nil {
		sv = &DescribeStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "Standards":
			if err := awsRestjson1_deserializeDocumentStandards(&sv.Standards, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeStandardsControls struct {
}

func (*awsRestjson1_deserializeOpDescribeStandardsControls) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeStandardsControls) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeStandardsControls(response, &metadata)
	}
	output := &DescribeStandardsControlsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeStandardsControlsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeStandardsControls(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeStandardsControlsOutput(v **DescribeStandardsControlsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeStandardsControlsOutput
	if *v == nil {
		sv = &DescribeStandardsControlsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Controls":
			if err := awsRestjson1_deserializeDocumentStandardsControls(&sv.Controls, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDisableImportFindingsForProduct struct {
}

func (*awsRestjson1_deserializeOpDisableImportFindingsForProduct) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisableImportFindingsForProduct) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisableImportFindingsForProduct(response, &metadata)
	}
	output := &DisableImportFindingsForProductOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisableImportFindingsForProduct(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisableOrganizationAdminAccount struct {
}

func (*awsRestjson1_deserializeOpDisableOrganizationAdminAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisableOrganizationAdminAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisableOrganizationAdminAccount(response, &metadata)
	}
	output := &DisableOrganizationAdminAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisableOrganizationAdminAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisableSecurityHub struct {
}

func (*awsRestjson1_deserializeOpDisableSecurityHub) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisableSecurityHub) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisableSecurityHub(response, &metadata)
	}
	output := &DisableSecurityHubOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisableSecurityHub(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisassociateFromAdministratorAccount struct {
}

func (*awsRestjson1_deserializeOpDisassociateFromAdministratorAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisassociateFromAdministratorAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisassociateFromAdministratorAccount(response, &metadata)
	}
	output := &DisassociateFromAdministratorAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisassociateFromAdministratorAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisassociateFromMasterAccount struct {
}

func (*awsRestjson1_deserializeOpDisassociateFromMasterAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisassociateFromMasterAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisassociateFromMasterAccount(response, &metadata)
	}
	output := &DisassociateFromMasterAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisassociateFromMasterAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisassociateMembers struct {
}

func (*awsRestjson1_deserializeOpDisassociateMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisassociateMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisassociateMembers(response, &metadata)
	}
	output := &DisassociateMembersOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisassociateMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpEnableImportFindingsForProduct struct {
}

func (*awsRestjson1_deserializeOpEnableImportFindingsForProduct) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpEnableImportFindingsForProduct) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorEnableImportFindingsForProduct(response, &metadata)
	}
	output := &EnableImportFindingsForProductOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentEnableImportFindingsForProductOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorEnableImportFindingsForProduct(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentEnableImportFindingsForProductOutput(v **EnableImportFindingsForProductOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *EnableImportFindingsForProductOutput
	if *v == nil {
		sv = &EnableImportFindingsForProductOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ProductSubscriptionArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductSubscriptionArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpEnableOrganizationAdminAccount struct {
}

func (*awsRestjson1_deserializeOpEnableOrganizationAdminAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpEnableOrganizationAdminAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorEnableOrganizationAdminAccount(response, &metadata)
	}
	output := &EnableOrganizationAdminAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorEnableOrganizationAdminAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpEnableSecurityHub struct {
}

func (*awsRestjson1_deserializeOpEnableSecurityHub) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpEnableSecurityHub) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorEnableSecurityHub(response, &metadata)
	}
	output := &EnableSecurityHubOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorEnableSecurityHub(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpGetAdministratorAccount struct {
}

func (*awsRestjson1_deserializeOpGetAdministratorAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetAdministratorAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetAdministratorAccount(response, &metadata)
	}
	output := &GetAdministratorAccountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetAdministratorAccountOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetAdministratorAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetAdministratorAccountOutput(v **GetAdministratorAccountOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetAdministratorAccountOutput
	if *v == nil {
		sv = &GetAdministratorAccountOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Administrator":
			if err := awsRestjson1_deserializeDocumentInvitation(&sv.Administrator, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetConfigurationPolicy struct {
}

func (*awsRestjson1_deserializeOpGetConfigurationPolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetConfigurationPolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetConfigurationPolicy(response, &metadata)
	}
	output := &GetConfigurationPolicyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetConfigurationPolicyOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetConfigurationPolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetConfigurationPolicyOutput(v **GetConfigurationPolicyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetConfigurationPolicyOutput
	if *v == nil {
		sv = &GetConfigurationPolicyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "ConfigurationPolicy":
			if err := awsRestjson1_deserializeDocumentPolicy(&sv.ConfigurationPolicy, value); err != nil {
				return err
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.CreatedAt = ptr.Time(t)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetConfigurationPolicyAssociation struct {
}

func (*awsRestjson1_deserializeOpGetConfigurationPolicyAssociation) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetConfigurationPolicyAssociation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetConfigurationPolicyAssociation(response, &metadata)
	}
	output := &GetConfigurationPolicyAssociationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetConfigurationPolicyAssociationOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetConfigurationPolicyAssociation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetConfigurationPolicyAssociationOutput(v **GetConfigurationPolicyAssociationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetConfigurationPolicyAssociationOutput
	if *v == nil {
		sv = &GetConfigurationPolicyAssociationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociationStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ConfigurationPolicyAssociationStatus to be of type string, got %T instead", value)
				}
				sv.AssociationStatus = types.ConfigurationPolicyAssociationStatus(jtv)
			}

		case "AssociationStatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssociationStatusMessage = ptr.String(jtv)
			}

		case "AssociationType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AssociationType to be of type string, got %T instead", value)
				}
				sv.AssociationType = types.AssociationType(jtv)
			}

		case "ConfigurationPolicyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ConfigurationPolicyId = ptr.String(jtv)
			}

		case "TargetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TargetId = ptr.String(jtv)
			}

		case "TargetType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TargetType to be of type string, got %T instead", value)
				}
				sv.TargetType = types.TargetType(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetEnabledStandards struct {
}

func (*awsRestjson1_deserializeOpGetEnabledStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetEnabledStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetEnabledStandards(response, &metadata)
	}
	output := &GetEnabledStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetEnabledStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetEnabledStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetEnabledStandardsOutput(v **GetEnabledStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEnabledStandardsOutput
	if *v == nil {
		sv = &GetEnabledStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "StandardsSubscriptions":
			if err := awsRestjson1_deserializeDocumentStandardsSubscriptions(&sv.StandardsSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetFindingAggregator struct {
}

func (*awsRestjson1_deserializeOpGetFindingAggregator) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetFindingAggregator) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetFindingAggregator(response, &metadata)
	}
	output := &GetFindingAggregatorOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetFindingAggregatorOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetFindingAggregator(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetFindingAggregatorOutput(v **GetFindingAggregatorOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetFindingAggregatorOutput
	if *v == nil {
		sv = &GetFindingAggregatorOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FindingAggregationRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FindingAggregationRegion = ptr.String(jtv)
			}

		case "FindingAggregatorArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FindingAggregatorArn = ptr.String(jtv)
			}

		case "RegionLinkingMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegionLinkingMode = ptr.String(jtv)
			}

		case "Regions":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.Regions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetFindingHistory struct {
}

func (*awsRestjson1_deserializeOpGetFindingHistory) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetFindingHistory) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetFindingHistory(response, &metadata)
	}
	output := &GetFindingHistoryOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetFindingHistoryOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetFindingHistory(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetFindingHistoryOutput(v **GetFindingHistoryOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetFindingHistoryOutput
	if *v == nil {
		sv = &GetFindingHistoryOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "Records":
			if err := awsRestjson1_deserializeDocumentFindingHistoryRecordList(&sv.Records, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetFindings struct {
}

func (*awsRestjson1_deserializeOpGetFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetFindings(response, &metadata)
	}
	output := &GetFindingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetFindingsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetFindingsOutput(v **GetFindingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetFindingsOutput
	if *v == nil {
		sv = &GetFindingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Findings":
			if err := awsRestjson1_deserializeDocumentAwsSecurityFindingList(&sv.Findings, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInsightResults struct {
}

func (*awsRestjson1_deserializeOpGetInsightResults) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInsightResults) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInsightResults(response, &metadata)
	}
	output := &GetInsightResultsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetInsightResultsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInsightResults(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInsightResultsOutput(v **GetInsightResultsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInsightResultsOutput
	if *v == nil {
		sv = &GetInsightResultsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InsightResults":
			if err := awsRestjson1_deserializeDocumentInsightResults(&sv.InsightResults, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInsights struct {
}

func (*awsRestjson1_deserializeOpGetInsights) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInsights) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInsights(response, &metadata)
	}
	output := &GetInsightsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetInsightsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInsights(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInsightsOutput(v **GetInsightsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInsightsOutput
	if *v == nil {
		sv = &GetInsightsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Insights":
			if err := awsRestjson1_deserializeDocumentInsightList(&sv.Insights, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInvitationsCount struct {
}

func (*awsRestjson1_deserializeOpGetInvitationsCount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInvitationsCount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInvitationsCount(response, &metadata)
	}
	output := &GetInvitationsCountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetInvitationsCountOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInvitationsCount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInvitationsCountOutput(v **GetInvitationsCountOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInvitationsCountOutput
	if *v == nil {
		sv = &GetInvitationsCountOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InvitationsCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InvitationsCount = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetMasterAccount struct {
}

func (*awsRestjson1_deserializeOpGetMasterAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetMasterAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetMasterAccount(response, &metadata)
	}
	output := &GetMasterAccountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetMasterAccountOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetMasterAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetMasterAccountOutput(v **GetMasterAccountOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetMasterAccountOutput
	if *v == nil {
		sv = &GetMasterAccountOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Master":
			if err := awsRestjson1_deserializeDocumentInvitation(&sv.Master, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetMembers struct {
}

func (*awsRestjson1_deserializeOpGetMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetMembers(response, &metadata)
	}
	output := &GetMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetMembersOutput(v **GetMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetMembersOutput
	if *v == nil {
		sv = &GetMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Members":
			if err := awsRestjson1_deserializeDocumentMemberList(&sv.Members, value); err != nil {
				return err
			}

		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetSecurityControlDefinition struct {
}

func (*awsRestjson1_deserializeOpGetSecurityControlDefinition) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetSecurityControlDefinition) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetSecurityControlDefinition(response, &metadata)
	}
	output := &GetSecurityControlDefinitionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetSecurityControlDefinitionOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetSecurityControlDefinition(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetSecurityControlDefinitionOutput(v **GetSecurityControlDefinitionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetSecurityControlDefinitionOutput
	if *v == nil {
		sv = &GetSecurityControlDefinitionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SecurityControlDefinition":
			if err := awsRestjson1_deserializeDocumentSecurityControlDefinition(&sv.SecurityControlDefinition, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpInviteMembers struct {
}

func (*awsRestjson1_deserializeOpInviteMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpInviteMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorInviteMembers(response, &metadata)
	}
	output := &InviteMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentInviteMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorInviteMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentInviteMembersOutput(v **InviteMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *InviteMembersOutput
	if *v == nil {
		sv = &InviteMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListAutomationRules struct {
}

func (*awsRestjson1_deserializeOpListAutomationRules) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListAutomationRules) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListAutomationRules(response, &metadata)
	}
	output := &ListAutomationRulesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListAutomationRulesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListAutomationRules(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListAutomationRulesOutput(v **ListAutomationRulesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListAutomationRulesOutput
	if *v == nil {
		sv = &ListAutomationRulesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutomationRulesMetadata":
			if err := awsRestjson1_deserializeDocumentAutomationRulesMetadataList(&sv.AutomationRulesMetadata, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListConfigurationPolicies struct {
}

func (*awsRestjson1_deserializeOpListConfigurationPolicies) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListConfigurationPolicies) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListConfigurationPolicies(response, &metadata)
	}
	output := &ListConfigurationPoliciesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListConfigurationPoliciesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListConfigurationPolicies(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListConfigurationPoliciesOutput(v **ListConfigurationPoliciesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListConfigurationPoliciesOutput
	if *v == nil {
		sv = &ListConfigurationPoliciesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ConfigurationPolicySummaries":
			if err := awsRestjson1_deserializeDocumentConfigurationPolicySummaryList(&sv.ConfigurationPolicySummaries, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListConfigurationPolicyAssociations struct {
}

func (*awsRestjson1_deserializeOpListConfigurationPolicyAssociations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListConfigurationPolicyAssociations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListConfigurationPolicyAssociations(response, &metadata)
	}
	output := &ListConfigurationPolicyAssociationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListConfigurationPolicyAssociationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListConfigurationPolicyAssociations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListConfigurationPolicyAssociationsOutput(v **ListConfigurationPolicyAssociationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListConfigurationPolicyAssociationsOutput
	if *v == nil {
		sv = &ListConfigurationPolicyAssociationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ConfigurationPolicyAssociationSummaries":
			if err := awsRestjson1_deserializeDocumentConfigurationPolicyAssociationSummaryList(&sv.ConfigurationPolicyAssociationSummaries, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListEnabledProductsForImport struct {
}

func (*awsRestjson1_deserializeOpListEnabledProductsForImport) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListEnabledProductsForImport) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListEnabledProductsForImport(response, &metadata)
	}
	output := &ListEnabledProductsForImportOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListEnabledProductsForImportOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListEnabledProductsForImport(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListEnabledProductsForImportOutput(v **ListEnabledProductsForImportOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListEnabledProductsForImportOutput
	if *v == nil {
		sv = &ListEnabledProductsForImportOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "ProductSubscriptions":
			if err := awsRestjson1_deserializeDocumentProductSubscriptionArnList(&sv.ProductSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListFindingAggregators struct {
}

func (*awsRestjson1_deserializeOpListFindingAggregators) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListFindingAggregators) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListFindingAggregators(response, &metadata)
	}
	output := &ListFindingAggregatorsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListFindingAggregatorsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListFindingAggregators(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListFindingAggregatorsOutput(v **ListFindingAggregatorsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListFindingAggregatorsOutput
	if *v == nil {
		sv = &ListFindingAggregatorsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FindingAggregators":
			if err := awsRestjson1_deserializeDocumentFindingAggregatorList(&sv.FindingAggregators, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListInvitations struct {
}

func (*awsRestjson1_deserializeOpListInvitations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListInvitations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListInvitations(response, &metadata)
	}
	output := &ListInvitationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListInvitationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListInvitations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListInvitationsOutput(v **ListInvitationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListInvitationsOutput
	if *v == nil {
		sv = &ListInvitationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Invitations":
			if err := awsRestjson1_deserializeDocumentInvitationList(&sv.Invitations, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListMembers struct {
}

func (*awsRestjson1_deserializeOpListMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListMembers(response, &metadata)
	}
	output := &ListMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListMembersOutput(v **ListMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListMembersOutput
	if *v == nil {
		sv = &ListMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Members":
			if err := awsRestjson1_deserializeDocumentMemberList(&sv.Members, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListOrganizationAdminAccounts struct {
}

func (*awsRestjson1_deserializeOpListOrganizationAdminAccounts) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListOrganizationAdminAccounts) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListOrganizationAdminAccounts(response, &metadata)
	}
	output := &ListOrganizationAdminAccountsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListOrganizationAdminAccountsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListOrganizationAdminAccounts(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListOrganizationAdminAccountsOutput(v **ListOrganizationAdminAccountsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListOrganizationAdminAccountsOutput
	if *v == nil {
		sv = &ListOrganizationAdminAccountsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AdminAccounts":
			if err := awsRestjson1_deserializeDocumentAdminAccounts(&sv.AdminAccounts, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListSecurityControlDefinitions struct {
}

func (*awsRestjson1_deserializeOpListSecurityControlDefinitions) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListSecurityControlDefinitions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListSecurityControlDefinitions(response, &metadata)
	}
	output := &ListSecurityControlDefinitionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListSecurityControlDefinitionsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListSecurityControlDefinitions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListSecurityControlDefinitionsOutput(v **ListSecurityControlDefinitionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListSecurityControlDefinitionsOutput
	if *v == nil {
		sv = &ListSecurityControlDefinitionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "SecurityControlDefinitions":
			if err := awsRestjson1_deserializeDocumentSecurityControlDefinitions(&sv.SecurityControlDefinitions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListStandardsControlAssociations struct {
}

func (*awsRestjson1_deserializeOpListStandardsControlAssociations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListStandardsControlAssociations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListStandardsControlAssociations(response, &metadata)
	}
	output := &ListStandardsControlAssociationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListStandardsControlAssociationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListStandardsControlAssociations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListStandardsControlAssociationsOutput(v **ListStandardsControlAssociationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListStandardsControlAssociationsOutput
	if *v == nil {
		sv = &ListStandardsControlAssociationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "StandardsControlAssociationSummaries":
			if err := awsRestjson1_deserializeDocumentStandardsControlAssociationSummaries(&sv.StandardsControlAssociationSummaries, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListTagsForResource struct {
}

func (*awsRestjson1_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListTagsForResource(response, &metadata)
	}
	output := &ListTagsForResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListTagsForResourceOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListTagsForResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListTagsForResourceOutput(v **ListTagsForResourceOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListTagsForResourceOutput
	if *v == nil {
		sv = &ListTagsForResourceOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Tags":
			if err := awsRestjson1_deserializeDocumentTagMap(&sv.Tags, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpStartConfigurationPolicyAssociation struct {
}

func (*awsRestjson1_deserializeOpStartConfigurationPolicyAssociation) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpStartConfigurationPolicyAssociation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorStartConfigurationPolicyAssociation(response, &metadata)
	}
	output := &StartConfigurationPolicyAssociationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentStartConfigurationPolicyAssociationOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorStartConfigurationPolicyAssociation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentStartConfigurationPolicyAssociationOutput(v **StartConfigurationPolicyAssociationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *StartConfigurationPolicyAssociationOutput
	if *v == nil {
		sv = &StartConfigurationPolicyAssociationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociationStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ConfigurationPolicyAssociationStatus to be of type string, got %T instead", value)
				}
				sv.AssociationStatus = types.ConfigurationPolicyAssociationStatus(jtv)
			}

		case "AssociationStatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssociationStatusMessage = ptr.String(jtv)
			}

		case "AssociationType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AssociationType to be of type string, got %T instead", value)
				}
				sv.AssociationType = types.AssociationType(jtv)
			}

		case "ConfigurationPolicyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ConfigurationPolicyId = ptr.String(jtv)
			}

		case "TargetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TargetId = ptr.String(jtv)
			}

		case "TargetType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TargetType to be of type string, got %T instead", value)
				}
				sv.TargetType = types.TargetType(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpStartConfigurationPolicyDisassociation struct {
}

func (*awsRestjson1_deserializeOpStartConfigurationPolicyDisassociation) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpStartConfigurationPolicyDisassociation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorStartConfigurationPolicyDisassociation(response, &metadata)
	}
	output := &StartConfigurationPolicyDisassociationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorStartConfigurationPolicyDisassociation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpTagResource struct {
}

func (*awsRestjson1_deserializeOpTagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpTagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorTagResource(response, &metadata)
	}
	output := &TagResourceOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorTagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUntagResource struct {
}

func (*awsRestjson1_deserializeOpUntagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUntagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUntagResource(response, &metadata)
	}
	output := &UntagResourceOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUntagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateActionTarget struct {
}

func (*awsRestjson1_deserializeOpUpdateActionTarget) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateActionTarget) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateActionTarget(response, &metadata)
	}
	output := &UpdateActionTargetOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateActionTarget(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateConfigurationPolicy struct {
}

func (*awsRestjson1_deserializeOpUpdateConfigurationPolicy) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateConfigurationPolicy) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateConfigurationPolicy(response, &metadata)
	}
	output := &UpdateConfigurationPolicyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentUpdateConfigurationPolicyOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateConfigurationPolicy(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateConfigurationPolicyOutput(v **UpdateConfigurationPolicyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateConfigurationPolicyOutput
	if *v == nil {
		sv = &UpdateConfigurationPolicyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "ConfigurationPolicy":
			if err := awsRestjson1_deserializeDocumentPolicy(&sv.ConfigurationPolicy, value); err != nil {
				return err
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.CreatedAt = ptr.Time(t)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateFindingAggregator struct {
}

func (*awsRestjson1_deserializeOpUpdateFindingAggregator) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateFindingAggregator) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateFindingAggregator(response, &metadata)
	}
	output := &UpdateFindingAggregatorOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentUpdateFindingAggregatorOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateFindingAggregator(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentUpdateFindingAggregatorOutput(v **UpdateFindingAggregatorOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateFindingAggregatorOutput
	if *v == nil {
		sv = &UpdateFindingAggregatorOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FindingAggregationRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FindingAggregationRegion = ptr.String(jtv)
			}

		case "FindingAggregatorArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FindingAggregatorArn = ptr.String(jtv)
			}

		case "RegionLinkingMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegionLinkingMode = ptr.String(jtv)
			}

		case "Regions":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.Regions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpUpdateFindings struct {
}

func (*awsRestjson1_deserializeOpUpdateFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateFindings(response, &metadata)
	}
	output := &UpdateFindingsOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateInsight struct {
}

func (*awsRestjson1_deserializeOpUpdateInsight) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateInsight) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateInsight(response, &metadata)
	}
	output := &UpdateInsightOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateInsight(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateOrganizationConfiguration struct {
}

func (*awsRestjson1_deserializeOpUpdateOrganizationConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateOrganizationConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateOrganizationConfiguration(response, &metadata)
	}
	output := &UpdateOrganizationConfigurationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateOrganizationConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateSecurityControl struct {
}

func (*awsRestjson1_deserializeOpUpdateSecurityControl) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateSecurityControl) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateSecurityControl(response, &metadata)
	}
	output := &UpdateSecurityControlOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateSecurityControl(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceInUseException", errorCode):
		return awsRestjson1_deserializeErrorResourceInUseException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateSecurityHubConfiguration struct {
}

func (*awsRestjson1_deserializeOpUpdateSecurityHubConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateSecurityHubConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateSecurityHubConfiguration(response, &metadata)
	}
	output := &UpdateSecurityHubConfigurationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateSecurityHubConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateStandardsControl struct {
}

func (*awsRestjson1_deserializeOpUpdateStandardsControl) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateStandardsControl) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateStandardsControl(response, &metadata)
	}
	output := &UpdateStandardsControlOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateStandardsControl(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")
	if len(headerCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(headerCode)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	jsonCode, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(headerCode) == 0 && len(jsonCode) != 0 {
		errorCode = restjson.SanitizeErrorCode(jsonCode)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeErrorAccessDeniedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AccessDeniedException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentAccessDeniedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInternalException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InternalException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInternalException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInvalidAccessException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidAccessException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInvalidAccessException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInvalidInputException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidInputException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInvalidInputException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.LimitExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorResourceConflictException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceConflictException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentResourceConflictException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorResourceInUseException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceInUseException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentResourceInUseException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorResourceNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceNotFoundException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentResourceNotFoundException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeDocumentAccessDeniedException(v **types.AccessDeniedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AccessDeniedException
	if *v == nil {
		sv = &types.AccessDeniedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAction(v **types.Action, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Action
	if *v == nil {
		sv = &types.Action{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionType = ptr.String(jtv)
			}

		case "AwsApiCallAction":
			if err := awsRestjson1_deserializeDocumentAwsApiCallAction(&sv.AwsApiCallAction, value); err != nil {
				return err
			}

		case "DnsRequestAction":
			if err := awsRestjson1_deserializeDocumentDnsRequestAction(&sv.DnsRequestAction, value); err != nil {
				return err
			}

		case "NetworkConnectionAction":
			if err := awsRestjson1_deserializeDocumentNetworkConnectionAction(&sv.NetworkConnectionAction, value); err != nil {
				return err
			}

		case "PortProbeAction":
			if err := awsRestjson1_deserializeDocumentPortProbeAction(&sv.PortProbeAction, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionList(v *[]types.AutomationRulesAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AutomationRulesAction
	if *v == nil {
		cv = []types.AutomationRulesAction{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AutomationRulesAction
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAutomationRulesAction(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentActionLocalIpDetails(v **types.ActionLocalIpDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionLocalIpDetails
	if *v == nil {
		sv = &types.ActionLocalIpDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IpAddressV4":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddressV4 = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionLocalPortDetails(v **types.ActionLocalPortDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionLocalPortDetails
	if *v == nil {
		sv = &types.ActionLocalPortDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case "PortName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PortName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionRemoteIpDetails(v **types.ActionRemoteIpDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionRemoteIpDetails
	if *v == nil {
		sv = &types.ActionRemoteIpDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "City":
			if err := awsRestjson1_deserializeDocumentCity(&sv.City, value); err != nil {
				return err
			}

		case "Country":
			if err := awsRestjson1_deserializeDocumentCountry(&sv.Country, value); err != nil {
				return err
			}

		case "GeoLocation":
			if err := awsRestjson1_deserializeDocumentGeoLocation(&sv.GeoLocation, value); err != nil {
				return err
			}

		case "IpAddressV4":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddressV4 = ptr.String(jtv)
			}

		case "Organization":
			if err := awsRestjson1_deserializeDocumentIpOrganizationDetails(&sv.Organization, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionRemotePortDetails(v **types.ActionRemotePortDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionRemotePortDetails
	if *v == nil {
		sv = &types.ActionRemotePortDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case "PortName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PortName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionTarget(v **types.ActionTarget, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionTarget
	if *v == nil {
		sv = &types.ActionTarget{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionTargetArn = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionTargetList(v *[]types.ActionTarget, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ActionTarget
	if *v == nil {
		cv = []types.ActionTarget{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ActionTarget
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentActionTarget(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAdjustment(v **types.Adjustment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Adjustment
	if *v == nil {
		sv = &types.Adjustment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Metric":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Metric = ptr.String(jtv)
			}

		case "Reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAdjustmentList(v *[]types.Adjustment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Adjustment
	if *v == nil {
		cv = []types.Adjustment{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Adjustment
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAdjustment(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAdminAccount(v **types.AdminAccount, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AdminAccount
	if *v == nil {
		sv = &types.AdminAccount{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AdminStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.AdminStatus(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAdminAccounts(v *[]types.AdminAccount, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AdminAccount
	if *v == nil {
		cv = []types.AdminAccount{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AdminAccount
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAdminAccount(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAssociatedStandard(v **types.AssociatedStandard, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AssociatedStandard
	if *v == nil {
		sv = &types.AssociatedStandard{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StandardsId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StandardsId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAssociatedStandardsList(v *[]types.AssociatedStandard, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AssociatedStandard
	if *v == nil {
		cv = []types.AssociatedStandard{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AssociatedStandard
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAssociatedStandard(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAssociationSetDetails(v **types.AssociationSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AssociationSetDetails
	if *v == nil {
		sv = &types.AssociationSetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociationState":
			if err := awsRestjson1_deserializeDocumentAssociationStateDetails(&sv.AssociationState, value); err != nil {
				return err
			}

		case "GatewayId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GatewayId = ptr.String(jtv)
			}

		case "Main":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Main = ptr.Bool(jtv)
			}

		case "RouteTableAssociationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RouteTableAssociationId = ptr.String(jtv)
			}

		case "RouteTableId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RouteTableId = ptr.String(jtv)
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAssociationSetList(v *[]types.AssociationSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AssociationSetDetails
	if *v == nil {
		cv = []types.AssociationSetDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AssociationSetDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAssociationSetDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAssociationStateDetails(v **types.AssociationStateDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AssociationStateDetails
	if *v == nil {
		sv = &types.AssociationStateDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		case "StatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StatusMessage = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesAction(v **types.AutomationRulesAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutomationRulesAction
	if *v == nil {
		sv = &types.AutomationRulesAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FindingFieldsUpdate":
			if err := awsRestjson1_deserializeDocumentAutomationRulesFindingFieldsUpdate(&sv.FindingFieldsUpdate, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AutomationRulesActionType to be of type string, got %T instead", value)
				}
				sv.Type = types.AutomationRulesActionType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesArnsList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesConfig(v **types.AutomationRulesConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutomationRulesConfig
	if *v == nil {
		sv = &types.AutomationRulesConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Actions":
			if err := awsRestjson1_deserializeDocumentActionList(&sv.Actions, value); err != nil {
				return err
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.CreatedAt = ptr.Time(t)
			}

		case "CreatedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedBy = ptr.String(jtv)
			}

		case "Criteria":
			if err := awsRestjson1_deserializeDocumentAutomationRulesFindingFilters(&sv.Criteria, value); err != nil {
				return err
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "IsTerminal":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsTerminal = ptr.Bool(jtv)
			}

		case "RuleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleArn = ptr.String(jtv)
			}

		case "RuleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleName = ptr.String(jtv)
			}

		case "RuleOrder":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected RuleOrderValue to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RuleOrder = ptr.Int32(int32(i64))
			}

		case "RuleStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RuleStatus to be of type string, got %T instead", value)
				}
				sv.RuleStatus = types.RuleStatus(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesConfigList(v *[]types.AutomationRulesConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AutomationRulesConfig
	if *v == nil {
		cv = []types.AutomationRulesConfig{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AutomationRulesConfig
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAutomationRulesConfig(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesFindingFieldsUpdate(v **types.AutomationRulesFindingFieldsUpdate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutomationRulesFindingFieldsUpdate
	if *v == nil {
		sv = &types.AutomationRulesFindingFieldsUpdate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Confidence":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected RatioScale to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Confidence = ptr.Int32(int32(i64))
			}

		case "Criticality":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected RatioScale to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Criticality = ptr.Int32(int32(i64))
			}

		case "Note":
			if err := awsRestjson1_deserializeDocumentNoteUpdate(&sv.Note, value); err != nil {
				return err
			}

		case "RelatedFindings":
			if err := awsRestjson1_deserializeDocumentRelatedFindingList(&sv.RelatedFindings, value); err != nil {
				return err
			}

		case "Severity":
			if err := awsRestjson1_deserializeDocumentSeverityUpdate(&sv.Severity, value); err != nil {
				return err
			}

		case "Types":
			if err := awsRestjson1_deserializeDocumentTypeList(&sv.Types, value); err != nil {
				return err
			}

		case "UserDefinedFields":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.UserDefinedFields, value); err != nil {
				return err
			}

		case "VerificationState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected VerificationState to be of type string, got %T instead", value)
				}
				sv.VerificationState = types.VerificationState(jtv)
			}

		case "Workflow":
			if err := awsRestjson1_deserializeDocumentWorkflowUpdate(&sv.Workflow, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesFindingFilters(v **types.AutomationRulesFindingFilters, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutomationRulesFindingFilters
	if *v == nil {
		sv = &types.AutomationRulesFindingFilters{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AwsAccountId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.AwsAccountId, value); err != nil {
				return err
			}

		case "AwsAccountName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.AwsAccountName, value); err != nil {
				return err
			}

		case "CompanyName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.CompanyName, value); err != nil {
				return err
			}

		case "ComplianceAssociatedStandardsId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ComplianceAssociatedStandardsId, value); err != nil {
				return err
			}

		case "ComplianceSecurityControlId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ComplianceSecurityControlId, value); err != nil {
				return err
			}

		case "ComplianceStatus":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ComplianceStatus, value); err != nil {
				return err
			}

		case "Confidence":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.Confidence, value); err != nil {
				return err
			}

		case "CreatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.CreatedAt, value); err != nil {
				return err
			}

		case "Criticality":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.Criticality, value); err != nil {
				return err
			}

		case "Description":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Description, value); err != nil {
				return err
			}

		case "FirstObservedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.FirstObservedAt, value); err != nil {
				return err
			}

		case "GeneratorId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.GeneratorId, value); err != nil {
				return err
			}

		case "Id":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Id, value); err != nil {
				return err
			}

		case "LastObservedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.LastObservedAt, value); err != nil {
				return err
			}

		case "NoteText":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NoteText, value); err != nil {
				return err
			}

		case "NoteUpdatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.NoteUpdatedAt, value); err != nil {
				return err
			}

		case "NoteUpdatedBy":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NoteUpdatedBy, value); err != nil {
				return err
			}

		case "ProductArn":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ProductArn, value); err != nil {
				return err
			}

		case "ProductName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ProductName, value); err != nil {
				return err
			}

		case "RecordState":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.RecordState, value); err != nil {
				return err
			}

		case "RelatedFindingsId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.RelatedFindingsId, value); err != nil {
				return err
			}

		case "RelatedFindingsProductArn":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.RelatedFindingsProductArn, value); err != nil {
				return err
			}

		case "ResourceApplicationArn":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceApplicationArn, value); err != nil {
				return err
			}

		case "ResourceApplicationName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceApplicationName, value); err != nil {
				return err
			}

		case "ResourceDetailsOther":
			if err := awsRestjson1_deserializeDocumentMapFilterList(&sv.ResourceDetailsOther, value); err != nil {
				return err
			}

		case "ResourceId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceId, value); err != nil {
				return err
			}

		case "ResourcePartition":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourcePartition, value); err != nil {
				return err
			}

		case "ResourceRegion":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceRegion, value); err != nil {
				return err
			}

		case "ResourceTags":
			if err := awsRestjson1_deserializeDocumentMapFilterList(&sv.ResourceTags, value); err != nil {
				return err
			}

		case "ResourceType":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceType, value); err != nil {
				return err
			}

		case "SeverityLabel":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.SeverityLabel, value); err != nil {
				return err
			}

		case "SourceUrl":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.SourceUrl, value); err != nil {
				return err
			}

		case "Title":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Title, value); err != nil {
				return err
			}

		case "Type":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Type, value); err != nil {
				return err
			}

		case "UpdatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.UpdatedAt, value); err != nil {
				return err
			}

		case "UserDefinedFields":
			if err := awsRestjson1_deserializeDocumentMapFilterList(&sv.UserDefinedFields, value); err != nil {
				return err
			}

		case "VerificationState":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.VerificationState, value); err != nil {
				return err
			}

		case "WorkflowStatus":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.WorkflowStatus, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesMetadata(v **types.AutomationRulesMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AutomationRulesMetadata
	if *v == nil {
		sv = &types.AutomationRulesMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.CreatedAt = ptr.Time(t)
			}

		case "CreatedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedBy = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "IsTerminal":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsTerminal = ptr.Bool(jtv)
			}

		case "RuleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleArn = ptr.String(jtv)
			}

		case "RuleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleName = ptr.String(jtv)
			}

		case "RuleOrder":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected RuleOrderValue to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RuleOrder = ptr.Int32(int32(i64))
			}

		case "RuleStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RuleStatus to be of type string, got %T instead", value)
				}
				sv.RuleStatus = types.RuleStatus(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAutomationRulesMetadataList(v *[]types.AutomationRulesMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AutomationRulesMetadata
	if *v == nil {
		cv = []types.AutomationRulesMetadata{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AutomationRulesMetadata
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAutomationRulesMetadata(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAvailabilityZone(v **types.AvailabilityZone, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AvailabilityZone
	if *v == nil {
		sv = &types.AvailabilityZone{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		case "ZoneName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ZoneName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAvailabilityZones(v *[]types.AvailabilityZone, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AvailabilityZone
	if *v == nil {
		cv = []types.AvailabilityZone{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AvailabilityZone
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAvailabilityZone(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerDetails(v **types.AwsAmazonMqBrokerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAmazonMqBrokerDetails
	if *v == nil {
		sv = &types.AwsAmazonMqBrokerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuthenticationStrategy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AuthenticationStrategy = ptr.String(jtv)
			}

		case "AutoMinorVersionUpgrade":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoMinorVersionUpgrade = ptr.Bool(jtv)
			}

		case "BrokerArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BrokerArn = ptr.String(jtv)
			}

		case "BrokerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BrokerId = ptr.String(jtv)
			}

		case "BrokerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BrokerName = ptr.String(jtv)
			}

		case "DeploymentMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeploymentMode = ptr.String(jtv)
			}

		case "EncryptionOptions":
			if err := awsRestjson1_deserializeDocumentAwsAmazonMqBrokerEncryptionOptionsDetails(&sv.EncryptionOptions, value); err != nil {
				return err
			}

		case "EngineType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineType = ptr.String(jtv)
			}

		case "EngineVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineVersion = ptr.String(jtv)
			}

		case "HostInstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostInstanceType = ptr.String(jtv)
			}

		case "LdapServerMetadata":
			if err := awsRestjson1_deserializeDocumentAwsAmazonMqBrokerLdapServerMetadataDetails(&sv.LdapServerMetadata, value); err != nil {
				return err
			}

		case "Logs":
			if err := awsRestjson1_deserializeDocumentAwsAmazonMqBrokerLogsDetails(&sv.Logs, value); err != nil {
				return err
			}

		case "MaintenanceWindowStartTime":
			if err := awsRestjson1_deserializeDocumentAwsAmazonMqBrokerMaintenanceWindowStartTimeDetails(&sv.MaintenanceWindowStartTime, value); err != nil {
				return err
			}

		case "PubliclyAccessible":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PubliclyAccessible = ptr.Bool(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "StorageType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StorageType = ptr.String(jtv)
			}

		case "SubnetIds":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.SubnetIds, value); err != nil {
				return err
			}

		case "Users":
			if err := awsRestjson1_deserializeDocumentAwsAmazonMqBrokerUsersList(&sv.Users, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerEncryptionOptionsDetails(v **types.AwsAmazonMqBrokerEncryptionOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAmazonMqBrokerEncryptionOptionsDetails
	if *v == nil {
		sv = &types.AwsAmazonMqBrokerEncryptionOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "UseAwsOwnedKey":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.UseAwsOwnedKey = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerLdapServerMetadataDetails(v **types.AwsAmazonMqBrokerLdapServerMetadataDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAmazonMqBrokerLdapServerMetadataDetails
	if *v == nil {
		sv = &types.AwsAmazonMqBrokerLdapServerMetadataDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Hosts":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.Hosts, value); err != nil {
				return err
			}

		case "RoleBase":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleBase = ptr.String(jtv)
			}

		case "RoleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleName = ptr.String(jtv)
			}

		case "RoleSearchMatching":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleSearchMatching = ptr.String(jtv)
			}

		case "RoleSearchSubtree":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RoleSearchSubtree = ptr.Bool(jtv)
			}

		case "ServiceAccountUsername":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceAccountUsername = ptr.String(jtv)
			}

		case "UserBase":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserBase = ptr.String(jtv)
			}

		case "UserRoleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserRoleName = ptr.String(jtv)
			}

		case "UserSearchMatching":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserSearchMatching = ptr.String(jtv)
			}

		case "UserSearchSubtree":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.UserSearchSubtree = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerLogsDetails(v **types.AwsAmazonMqBrokerLogsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAmazonMqBrokerLogsDetails
	if *v == nil {
		sv = &types.AwsAmazonMqBrokerLogsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Audit":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Audit = ptr.Bool(jtv)
			}

		case "AuditLogGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AuditLogGroup = ptr.String(jtv)
			}

		case "General":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.General = ptr.Bool(jtv)
			}

		case "GeneralLogGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GeneralLogGroup = ptr.String(jtv)
			}

		case "Pending":
			if err := awsRestjson1_deserializeDocumentAwsAmazonMqBrokerLogsPendingDetails(&sv.Pending, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerLogsPendingDetails(v **types.AwsAmazonMqBrokerLogsPendingDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAmazonMqBrokerLogsPendingDetails
	if *v == nil {
		sv = &types.AwsAmazonMqBrokerLogsPendingDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Audit":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Audit = ptr.Bool(jtv)
			}

		case "General":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.General = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerMaintenanceWindowStartTimeDetails(v **types.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails
	if *v == nil {
		sv = &types.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DayOfWeek":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DayOfWeek = ptr.String(jtv)
			}

		case "TimeOfDay":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TimeOfDay = ptr.String(jtv)
			}

		case "TimeZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TimeZone = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerUsersDetails(v **types.AwsAmazonMqBrokerUsersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAmazonMqBrokerUsersDetails
	if *v == nil {
		sv = &types.AwsAmazonMqBrokerUsersDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PendingChange":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PendingChange = ptr.String(jtv)
			}

		case "Username":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Username = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAmazonMqBrokerUsersList(v *[]types.AwsAmazonMqBrokerUsersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsAmazonMqBrokerUsersDetails
	if *v == nil {
		cv = []types.AwsAmazonMqBrokerUsersDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsAmazonMqBrokerUsersDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsAmazonMqBrokerUsersDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiCallAction(v **types.AwsApiCallAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiCallAction
	if *v == nil {
		sv = &types.AwsApiCallAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AffectedResources":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.AffectedResources, value); err != nil {
				return err
			}

		case "Api":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Api = ptr.String(jtv)
			}

		case "CallerType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CallerType = ptr.String(jtv)
			}

		case "DomainDetails":
			if err := awsRestjson1_deserializeDocumentAwsApiCallActionDomainDetails(&sv.DomainDetails, value); err != nil {
				return err
			}

		case "FirstSeen":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FirstSeen = ptr.String(jtv)
			}

		case "LastSeen":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastSeen = ptr.String(jtv)
			}

		case "RemoteIpDetails":
			if err := awsRestjson1_deserializeDocumentActionRemoteIpDetails(&sv.RemoteIpDetails, value); err != nil {
				return err
			}

		case "ServiceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiCallActionDomainDetails(v **types.AwsApiCallActionDomainDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiCallActionDomainDetails
	if *v == nil {
		sv = &types.AwsApiCallActionDomainDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Domain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Domain = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayAccessLogSettings(v **types.AwsApiGatewayAccessLogSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayAccessLogSettings
	if *v == nil {
		sv = &types.AwsApiGatewayAccessLogSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationArn = ptr.String(jtv)
			}

		case "Format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Format = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayCanarySettings(v **types.AwsApiGatewayCanarySettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayCanarySettings
	if *v == nil {
		sv = &types.AwsApiGatewayCanarySettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeploymentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeploymentId = ptr.String(jtv)
			}

		case "PercentTraffic":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.PercentTraffic = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.PercentTraffic = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "StageVariableOverrides":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.StageVariableOverrides, value); err != nil {
				return err
			}

		case "UseStageCache":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.UseStageCache = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayEndpointConfiguration(v **types.AwsApiGatewayEndpointConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayEndpointConfiguration
	if *v == nil {
		sv = &types.AwsApiGatewayEndpointConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Types":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Types, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettings(v **types.AwsApiGatewayMethodSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayMethodSettings
	if *v == nil {
		sv = &types.AwsApiGatewayMethodSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CacheDataEncrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CacheDataEncrypted = ptr.Bool(jtv)
			}

		case "CacheTtlInSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CacheTtlInSeconds = ptr.Int32(int32(i64))
			}

		case "CachingEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CachingEnabled = ptr.Bool(jtv)
			}

		case "DataTraceEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DataTraceEnabled = ptr.Bool(jtv)
			}

		case "HttpMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpMethod = ptr.String(jtv)
			}

		case "LoggingLevel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoggingLevel = ptr.String(jtv)
			}

		case "MetricsEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MetricsEnabled = ptr.Bool(jtv)
			}

		case "RequireAuthorizationForCacheControl":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RequireAuthorizationForCacheControl = ptr.Bool(jtv)
			}

		case "ResourcePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourcePath = ptr.String(jtv)
			}

		case "ThrottlingBurstLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ThrottlingBurstLimit = ptr.Int32(int32(i64))
			}

		case "ThrottlingRateLimit":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.ThrottlingRateLimit = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.ThrottlingRateLimit = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "UnauthorizedCacheControlHeaderStrategy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UnauthorizedCacheControlHeaderStrategy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettingsList(v *[]types.AwsApiGatewayMethodSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsApiGatewayMethodSettings
	if *v == nil {
		cv = []types.AwsApiGatewayMethodSettings{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsApiGatewayMethodSettings
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettings(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayRestApiDetails(v **types.AwsApiGatewayRestApiDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayRestApiDetails
	if *v == nil {
		sv = &types.AwsApiGatewayRestApiDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApiKeySource":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiKeySource = ptr.String(jtv)
			}

		case "BinaryMediaTypes":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.BinaryMediaTypes, value); err != nil {
				return err
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EndpointConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayEndpointConfiguration(&sv.EndpointConfiguration, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "MinimumCompressionSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MinimumCompressionSize = ptr.Int32(int32(i64))
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayStageDetails(v **types.AwsApiGatewayStageDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayStageDetails
	if *v == nil {
		sv = &types.AwsApiGatewayStageDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessLogSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayAccessLogSettings(&sv.AccessLogSettings, value); err != nil {
				return err
			}

		case "CacheClusterEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CacheClusterEnabled = ptr.Bool(jtv)
			}

		case "CacheClusterSize":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CacheClusterSize = ptr.String(jtv)
			}

		case "CacheClusterStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CacheClusterStatus = ptr.String(jtv)
			}

		case "CanarySettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayCanarySettings(&sv.CanarySettings, value); err != nil {
				return err
			}

		case "ClientCertificateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientCertificateId = ptr.String(jtv)
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "DeploymentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeploymentId = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "DocumentationVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DocumentationVersion = ptr.String(jtv)
			}

		case "LastUpdatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastUpdatedDate = ptr.String(jtv)
			}

		case "MethodSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettingsList(&sv.MethodSettings, value); err != nil {
				return err
			}

		case "StageName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StageName = ptr.String(jtv)
			}

		case "TracingEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.TracingEnabled = ptr.Bool(jtv)
			}

		case "Variables":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Variables, value); err != nil {
				return err
			}

		case "WebAclArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WebAclArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayV2ApiDetails(v **types.AwsApiGatewayV2ApiDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayV2ApiDetails
	if *v == nil {
		sv = &types.AwsApiGatewayV2ApiDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApiEndpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiEndpoint = ptr.String(jtv)
			}

		case "ApiId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiId = ptr.String(jtv)
			}

		case "ApiKeySelectionExpression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiKeySelectionExpression = ptr.String(jtv)
			}

		case "CorsConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsCorsConfiguration(&sv.CorsConfiguration, value); err != nil {
				return err
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ProtocolType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProtocolType = ptr.String(jtv)
			}

		case "RouteSelectionExpression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RouteSelectionExpression = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayV2RouteSettings(v **types.AwsApiGatewayV2RouteSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayV2RouteSettings
	if *v == nil {
		sv = &types.AwsApiGatewayV2RouteSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DataTraceEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DataTraceEnabled = ptr.Bool(jtv)
			}

		case "DetailedMetricsEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DetailedMetricsEnabled = ptr.Bool(jtv)
			}

		case "LoggingLevel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoggingLevel = ptr.String(jtv)
			}

		case "ThrottlingBurstLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ThrottlingBurstLimit = ptr.Int32(int32(i64))
			}

		case "ThrottlingRateLimit":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.ThrottlingRateLimit = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.ThrottlingRateLimit = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayV2StageDetails(v **types.AwsApiGatewayV2StageDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayV2StageDetails
	if *v == nil {
		sv = &types.AwsApiGatewayV2StageDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessLogSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayAccessLogSettings(&sv.AccessLogSettings, value); err != nil {
				return err
			}

		case "ApiGatewayManaged":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ApiGatewayManaged = ptr.Bool(jtv)
			}

		case "AutoDeploy":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoDeploy = ptr.Bool(jtv)
			}

		case "ClientCertificateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientCertificateId = ptr.String(jtv)
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "DefaultRouteSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayV2RouteSettings(&sv.DefaultRouteSettings, value); err != nil {
				return err
			}

		case "DeploymentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeploymentId = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "LastDeploymentStatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastDeploymentStatusMessage = ptr.String(jtv)
			}

		case "LastUpdatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastUpdatedDate = ptr.String(jtv)
			}

		case "RouteSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayV2RouteSettings(&sv.RouteSettings, value); err != nil {
				return err
			}

		case "StageName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StageName = ptr.String(jtv)
			}

		case "StageVariables":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.StageVariables, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails(v **types.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
	if *v == nil {
		sv = &types.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuthenticationType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AuthenticationType = ptr.String(jtv)
			}

		case "LambdaAuthorizerConfig":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails(&sv.LambdaAuthorizerConfig, value); err != nil {
				return err
			}

		case "OpenIdConnectConfig":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiOpenIdConnectConfigDetails(&sv.OpenIdConnectConfig, value); err != nil {
				return err
			}

		case "UserPoolConfig":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiUserPoolConfigDetails(&sv.UserPoolConfig, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiAdditionalAuthenticationProvidersList(v *[]types.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
	if *v == nil {
		cv = []types.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiDetails(v **types.AwsAppSyncGraphQlApiDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAppSyncGraphQlApiDetails
	if *v == nil {
		sv = &types.AwsAppSyncGraphQlApiDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AdditionalAuthenticationProviders":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiAdditionalAuthenticationProvidersList(&sv.AdditionalAuthenticationProviders, value); err != nil {
				return err
			}

		case "ApiId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiId = ptr.String(jtv)
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "AuthenticationType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AuthenticationType = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "LambdaAuthorizerConfig":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails(&sv.LambdaAuthorizerConfig, value); err != nil {
				return err
			}

		case "LogConfig":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiLogConfigDetails(&sv.LogConfig, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "OpenIdConnectConfig":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiOpenIdConnectConfigDetails(&sv.OpenIdConnectConfig, value); err != nil {
				return err
			}

		case "UserPoolConfig":
			if err := awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiUserPoolConfigDetails(&sv.UserPoolConfig, value); err != nil {
				return err
			}

		case "WafWebAclArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WafWebAclArn = ptr.String(jtv)
			}

		case "XrayEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.XrayEnabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails(v **types.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
	if *v == nil {
		sv = &types.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuthorizerResultTtlInSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AuthorizerResultTtlInSeconds = ptr.Int32(int32(i64))
			}

		case "AuthorizerUri":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AuthorizerUri = ptr.String(jtv)
			}

		case "IdentityValidationExpression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IdentityValidationExpression = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiLogConfigDetails(v **types.AwsAppSyncGraphQlApiLogConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAppSyncGraphQlApiLogConfigDetails
	if *v == nil {
		sv = &types.AwsAppSyncGraphQlApiLogConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchLogsRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogsRoleArn = ptr.String(jtv)
			}

		case "ExcludeVerboseContent":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ExcludeVerboseContent = ptr.Bool(jtv)
			}

		case "FieldLogLevel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FieldLogLevel = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiOpenIdConnectConfigDetails(v **types.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
	if *v == nil {
		sv = &types.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuthTtL":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AuthTtL = ptr.Int64(i64)
			}

		case "ClientId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientId = ptr.String(jtv)
			}

		case "IatTtL":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.IatTtL = ptr.Int64(i64)
			}

		case "Issuer":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Issuer = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAppSyncGraphQlApiUserPoolConfigDetails(v **types.AwsAppSyncGraphQlApiUserPoolConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAppSyncGraphQlApiUserPoolConfigDetails
	if *v == nil {
		sv = &types.AwsAppSyncGraphQlApiUserPoolConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AppIdClientRegex":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AppIdClientRegex = ptr.String(jtv)
			}

		case "AwsRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AwsRegion = ptr.String(jtv)
			}

		case "DefaultAction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DefaultAction = ptr.String(jtv)
			}

		case "UserPoolId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserPoolId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAthenaWorkGroupConfigurationDetails(v **types.AwsAthenaWorkGroupConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAthenaWorkGroupConfigurationDetails
	if *v == nil {
		sv = &types.AwsAthenaWorkGroupConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ResultConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsAthenaWorkGroupConfigurationResultConfigurationDetails(&sv.ResultConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAthenaWorkGroupConfigurationResultConfigurationDetails(v **types.AwsAthenaWorkGroupConfigurationResultConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAthenaWorkGroupConfigurationResultConfigurationDetails
	if *v == nil {
		sv = &types.AwsAthenaWorkGroupConfigurationResultConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EncryptionConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails(&sv.EncryptionConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails(v **types.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
	if *v == nil {
		sv = &types.AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EncryptionOption":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EncryptionOption = ptr.String(jtv)
			}

		case "KmsKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKey = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAthenaWorkGroupDetails(v **types.AwsAthenaWorkGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAthenaWorkGroupDetails
	if *v == nil {
		sv = &types.AwsAthenaWorkGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Configuration":
			if err := awsRestjson1_deserializeDocumentAwsAthenaWorkGroupConfigurationDetails(&sv.Configuration, value); err != nil {
				return err
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupAvailabilityZonesList(v *[]types.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
	if *v == nil {
		cv = []types.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails(v **types.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupDetails(v **types.AwsAutoScalingAutoScalingGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupDetails
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupAvailabilityZonesList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "CapacityRebalance":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CapacityRebalance = ptr.Bool(jtv)
			}

		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "HealthCheckGracePeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HealthCheckGracePeriod = ptr.Int32(int32(i64))
			}

		case "HealthCheckType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HealthCheckType = ptr.String(jtv)
			}

		case "LaunchConfigurationName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchConfigurationName = ptr.String(jtv)
			}

		case "LaunchTemplate":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification(&sv.LaunchTemplate, value); err != nil {
				return err
			}

		case "LoadBalancerNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.LoadBalancerNames, value); err != nil {
				return err
			}

		case "MixedInstancesPolicy":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails(&sv.MixedInstancesPolicy, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification(v **types.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LaunchTemplateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchTemplateId = ptr.String(jtv)
			}

		case "LaunchTemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchTemplateName = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails(v **types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstancesDistribution":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(&sv.InstancesDistribution, value); err != nil {
				return err
			}

		case "LaunchTemplate":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(&sv.LaunchTemplate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(v **types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "OnDemandAllocationStrategy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OnDemandAllocationStrategy = ptr.String(jtv)
			}

		case "OnDemandBaseCapacity":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OnDemandBaseCapacity = ptr.Int32(int32(i64))
			}

		case "OnDemandPercentageAboveBaseCapacity":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OnDemandPercentageAboveBaseCapacity = ptr.Int32(int32(i64))
			}

		case "SpotAllocationStrategy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SpotAllocationStrategy = ptr.String(jtv)
			}

		case "SpotInstancePools":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SpotInstancePools = ptr.Int32(int32(i64))
			}

		case "SpotMaxPrice":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SpotMaxPrice = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(v **types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LaunchTemplateSpecification":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification(&sv.LaunchTemplateSpecification, value); err != nil {
				return err
			}

		case "Overrides":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesList(&sv.Overrides, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification(v **types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LaunchTemplateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchTemplateId = ptr.String(jtv)
			}

		case "LaunchTemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchTemplateName = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesList(v *[]types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
	if *v == nil {
		cv = []types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails(v **types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "WeightedCapacity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WeightedCapacity = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(v **types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeviceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceName = ptr.String(jtv)
			}

		case "Ebs":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(&sv.Ebs, value); err != nil {
				return err
			}

		case "NoDevice":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.NoDevice = ptr.Bool(jtv)
			}

		case "VirtualName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VirtualName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(v **types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = ptr.Bool(jtv)
			}

		case "Encrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Encrypted = ptr.Bool(jtv)
			}

		case "Iops":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Iops = ptr.Int32(int32(i64))
			}

		case "SnapshotId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotId = ptr.String(jtv)
			}

		case "VolumeSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeSize = ptr.Int32(int32(i64))
			}

		case "VolumeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VolumeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsList(v *[]types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
	if *v == nil {
		cv = []types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationDetails(v **types.AwsAutoScalingLaunchConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociatePublicIpAddress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AssociatePublicIpAddress = ptr.Bool(jtv)
			}

		case "BlockDeviceMappings":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsList(&sv.BlockDeviceMappings, value); err != nil {
				return err
			}

		case "ClassicLinkVpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClassicLinkVpcId = ptr.String(jtv)
			}

		case "ClassicLinkVpcSecurityGroups":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.ClassicLinkVpcSecurityGroups, value); err != nil {
				return err
			}

		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "EbsOptimized":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EbsOptimized = ptr.Bool(jtv)
			}

		case "IamInstanceProfile":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamInstanceProfile = ptr.String(jtv)
			}

		case "ImageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageId = ptr.String(jtv)
			}

		case "InstanceMonitoring":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(&sv.InstanceMonitoring, value); err != nil {
				return err
			}

		case "InstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "KernelId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KernelId = ptr.String(jtv)
			}

		case "KeyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyName = ptr.String(jtv)
			}

		case "LaunchConfigurationName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchConfigurationName = ptr.String(jtv)
			}

		case "MetadataOptions":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationMetadataOptions(&sv.MetadataOptions, value); err != nil {
				return err
			}

		case "PlacementTenancy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PlacementTenancy = ptr.String(jtv)
			}

		case "RamdiskId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RamdiskId = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "SpotPrice":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SpotPrice = ptr.String(jtv)
			}

		case "UserData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserData = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(v **types.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationMetadataOptions(v **types.AwsAutoScalingLaunchConfigurationMetadataOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationMetadataOptions
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationMetadataOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HttpEndpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpEndpoint = ptr.String(jtv)
			}

		case "HttpPutResponseHopLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HttpPutResponseHopLimit = ptr.Int32(int32(i64))
			}

		case "HttpTokens":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpTokens = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanAdvancedBackupSettingsDetails(v **types.AwsBackupBackupPlanAdvancedBackupSettingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupPlanAdvancedBackupSettingsDetails
	if *v == nil {
		sv = &types.AwsBackupBackupPlanAdvancedBackupSettingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BackupOptions":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.BackupOptions, value); err != nil {
				return err
			}

		case "ResourceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourceType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanAdvancedBackupSettingsList(v *[]types.AwsBackupBackupPlanAdvancedBackupSettingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsBackupBackupPlanAdvancedBackupSettingsDetails
	if *v == nil {
		cv = []types.AwsBackupBackupPlanAdvancedBackupSettingsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsBackupBackupPlanAdvancedBackupSettingsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanAdvancedBackupSettingsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanBackupPlanDetails(v **types.AwsBackupBackupPlanBackupPlanDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupPlanBackupPlanDetails
	if *v == nil {
		sv = &types.AwsBackupBackupPlanBackupPlanDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AdvancedBackupSettings":
			if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanAdvancedBackupSettingsList(&sv.AdvancedBackupSettings, value); err != nil {
				return err
			}

		case "BackupPlanName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupPlanName = ptr.String(jtv)
			}

		case "BackupPlanRule":
			if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleList(&sv.BackupPlanRule, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanDetails(v **types.AwsBackupBackupPlanDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupPlanDetails
	if *v == nil {
		sv = &types.AwsBackupBackupPlanDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BackupPlan":
			if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanBackupPlanDetails(&sv.BackupPlan, value); err != nil {
				return err
			}

		case "BackupPlanArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupPlanArn = ptr.String(jtv)
			}

		case "BackupPlanId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupPlanId = ptr.String(jtv)
			}

		case "VersionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VersionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanLifecycleDetails(v **types.AwsBackupBackupPlanLifecycleDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupPlanLifecycleDetails
	if *v == nil {
		sv = &types.AwsBackupBackupPlanLifecycleDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeleteAfterDays":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DeleteAfterDays = ptr.Int64(i64)
			}

		case "MoveToColdStorageAfterDays":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MoveToColdStorageAfterDays = ptr.Int64(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleCopyActionsDetails(v **types.AwsBackupBackupPlanRuleCopyActionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupPlanRuleCopyActionsDetails
	if *v == nil {
		sv = &types.AwsBackupBackupPlanRuleCopyActionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationBackupVaultArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationBackupVaultArn = ptr.String(jtv)
			}

		case "Lifecycle":
			if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanLifecycleDetails(&sv.Lifecycle, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleCopyActionsList(v *[]types.AwsBackupBackupPlanRuleCopyActionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsBackupBackupPlanRuleCopyActionsDetails
	if *v == nil {
		cv = []types.AwsBackupBackupPlanRuleCopyActionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsBackupBackupPlanRuleCopyActionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleCopyActionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleDetails(v **types.AwsBackupBackupPlanRuleDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupPlanRuleDetails
	if *v == nil {
		sv = &types.AwsBackupBackupPlanRuleDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CompletionWindowMinutes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompletionWindowMinutes = ptr.Int64(i64)
			}

		case "CopyActions":
			if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleCopyActionsList(&sv.CopyActions, value); err != nil {
				return err
			}

		case "EnableContinuousBackup":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableContinuousBackup = ptr.Bool(jtv)
			}

		case "Lifecycle":
			if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanLifecycleDetails(&sv.Lifecycle, value); err != nil {
				return err
			}

		case "RuleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleId = ptr.String(jtv)
			}

		case "RuleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleName = ptr.String(jtv)
			}

		case "ScheduleExpression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ScheduleExpression = ptr.String(jtv)
			}

		case "StartWindowMinutes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartWindowMinutes = ptr.Int64(i64)
			}

		case "TargetBackupVault":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TargetBackupVault = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleList(v *[]types.AwsBackupBackupPlanRuleDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsBackupBackupPlanRuleDetails
	if *v == nil {
		cv = []types.AwsBackupBackupPlanRuleDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsBackupBackupPlanRuleDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsBackupBackupPlanRuleDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupVaultDetails(v **types.AwsBackupBackupVaultDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupVaultDetails
	if *v == nil {
		sv = &types.AwsBackupBackupVaultDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessPolicy = ptr.String(jtv)
			}

		case "BackupVaultArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupVaultArn = ptr.String(jtv)
			}

		case "BackupVaultName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupVaultName = ptr.String(jtv)
			}

		case "EncryptionKeyArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EncryptionKeyArn = ptr.String(jtv)
			}

		case "Notifications":
			if err := awsRestjson1_deserializeDocumentAwsBackupBackupVaultNotificationsDetails(&sv.Notifications, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupBackupVaultNotificationsDetails(v **types.AwsBackupBackupVaultNotificationsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupBackupVaultNotificationsDetails
	if *v == nil {
		sv = &types.AwsBackupBackupVaultNotificationsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BackupVaultEvents":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.BackupVaultEvents, value); err != nil {
				return err
			}

		case "SnsTopicArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnsTopicArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupRecoveryPointCalculatedLifecycleDetails(v **types.AwsBackupRecoveryPointCalculatedLifecycleDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupRecoveryPointCalculatedLifecycleDetails
	if *v == nil {
		sv = &types.AwsBackupRecoveryPointCalculatedLifecycleDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeleteAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeleteAt = ptr.String(jtv)
			}

		case "MoveToColdStorageAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MoveToColdStorageAt = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupRecoveryPointCreatedByDetails(v **types.AwsBackupRecoveryPointCreatedByDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupRecoveryPointCreatedByDetails
	if *v == nil {
		sv = &types.AwsBackupRecoveryPointCreatedByDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BackupPlanArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupPlanArn = ptr.String(jtv)
			}

		case "BackupPlanId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupPlanId = ptr.String(jtv)
			}

		case "BackupPlanVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupPlanVersion = ptr.String(jtv)
			}

		case "BackupRuleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupRuleId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupRecoveryPointDetails(v **types.AwsBackupRecoveryPointDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupRecoveryPointDetails
	if *v == nil {
		sv = &types.AwsBackupRecoveryPointDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BackupSizeInBytes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BackupSizeInBytes = ptr.Int64(i64)
			}

		case "BackupVaultArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupVaultArn = ptr.String(jtv)
			}

		case "BackupVaultName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BackupVaultName = ptr.String(jtv)
			}

		case "CalculatedLifecycle":
			if err := awsRestjson1_deserializeDocumentAwsBackupRecoveryPointCalculatedLifecycleDetails(&sv.CalculatedLifecycle, value); err != nil {
				return err
			}

		case "CompletionDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CompletionDate = ptr.String(jtv)
			}

		case "CreatedBy":
			if err := awsRestjson1_deserializeDocumentAwsBackupRecoveryPointCreatedByDetails(&sv.CreatedBy, value); err != nil {
				return err
			}

		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "EncryptionKeyArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EncryptionKeyArn = ptr.String(jtv)
			}

		case "IamRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamRoleArn = ptr.String(jtv)
			}

		case "IsEncrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsEncrypted = ptr.Bool(jtv)
			}

		case "LastRestoreTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastRestoreTime = ptr.String(jtv)
			}

		case "Lifecycle":
			if err := awsRestjson1_deserializeDocumentAwsBackupRecoveryPointLifecycleDetails(&sv.Lifecycle, value); err != nil {
				return err
			}

		case "RecoveryPointArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RecoveryPointArn = ptr.String(jtv)
			}

		case "ResourceArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourceArn = ptr.String(jtv)
			}

		case "ResourceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourceType = ptr.String(jtv)
			}

		case "SourceBackupVaultArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceBackupVaultArn = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StatusMessage = ptr.String(jtv)
			}

		case "StorageClass":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StorageClass = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsBackupRecoveryPointLifecycleDetails(v **types.AwsBackupRecoveryPointLifecycleDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsBackupRecoveryPointLifecycleDetails
	if *v == nil {
		sv = &types.AwsBackupRecoveryPointLifecycleDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeleteAfterDays":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DeleteAfterDays = ptr.Int64(i64)
			}

		case "MoveToColdStorageAfterDays":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MoveToColdStorageAfterDays = ptr.Int64(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDetails(v **types.AwsCertificateManagerCertificateDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateDetails
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CertificateAuthorityArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateAuthorityArn = ptr.String(jtv)
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedAt = ptr.String(jtv)
			}

		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "DomainValidationOptions":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(&sv.DomainValidationOptions, value); err != nil {
				return err
			}

		case "ExtendedKeyUsages":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsages(&sv.ExtendedKeyUsages, value); err != nil {
				return err
			}

		case "FailureReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FailureReason = ptr.String(jtv)
			}

		case "ImportedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImportedAt = ptr.String(jtv)
			}

		case "InUseBy":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.InUseBy, value); err != nil {
				return err
			}

		case "IssuedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IssuedAt = ptr.String(jtv)
			}

		case "Issuer":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Issuer = ptr.String(jtv)
			}

		case "KeyAlgorithm":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyAlgorithm = ptr.String(jtv)
			}

		case "KeyUsages":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsages(&sv.KeyUsages, value); err != nil {
				return err
			}

		case "NotAfter":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NotAfter = ptr.String(jtv)
			}

		case "NotBefore":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NotBefore = ptr.String(jtv)
			}

		case "Options":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateOptions(&sv.Options, value); err != nil {
				return err
			}

		case "RenewalEligibility":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RenewalEligibility = ptr.String(jtv)
			}

		case "RenewalSummary":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateRenewalSummary(&sv.RenewalSummary, value); err != nil {
				return err
			}

		case "Serial":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Serial = ptr.String(jtv)
			}

		case "SignatureAlgorithm":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SignatureAlgorithm = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "Subject":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Subject = ptr.String(jtv)
			}

		case "SubjectAlternativeNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.SubjectAlternativeNames, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOption(v **types.AwsCertificateManagerCertificateDomainValidationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateDomainValidationOption
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateDomainValidationOption{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "ResourceRecord":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateResourceRecord(&sv.ResourceRecord, value); err != nil {
				return err
			}

		case "ValidationDomain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValidationDomain = ptr.String(jtv)
			}

		case "ValidationEmails":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.ValidationEmails, value); err != nil {
				return err
			}

		case "ValidationMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValidationMethod = ptr.String(jtv)
			}

		case "ValidationStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValidationStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(v *[]types.AwsCertificateManagerCertificateDomainValidationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCertificateManagerCertificateDomainValidationOption
	if *v == nil {
		cv = []types.AwsCertificateManagerCertificateDomainValidationOption{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCertificateManagerCertificateDomainValidationOption
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOption(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsage(v **types.AwsCertificateManagerCertificateExtendedKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateExtendedKeyUsage
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateExtendedKeyUsage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "OId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsages(v *[]types.AwsCertificateManagerCertificateExtendedKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCertificateManagerCertificateExtendedKeyUsage
	if *v == nil {
		cv = []types.AwsCertificateManagerCertificateExtendedKeyUsage{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCertificateManagerCertificateExtendedKeyUsage
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsage(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsage(v **types.AwsCertificateManagerCertificateKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateKeyUsage
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateKeyUsage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsages(v *[]types.AwsCertificateManagerCertificateKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCertificateManagerCertificateKeyUsage
	if *v == nil {
		cv = []types.AwsCertificateManagerCertificateKeyUsage{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCertificateManagerCertificateKeyUsage
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsage(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateOptions(v **types.AwsCertificateManagerCertificateOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateOptions
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CertificateTransparencyLoggingPreference":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateTransparencyLoggingPreference = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateRenewalSummary(v **types.AwsCertificateManagerCertificateRenewalSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateRenewalSummary
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateRenewalSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DomainValidationOptions":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(&sv.DomainValidationOptions, value); err != nil {
				return err
			}

		case "RenewalStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RenewalStatus = ptr.String(jtv)
			}

		case "RenewalStatusReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RenewalStatusReason = ptr.String(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdatedAt = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateResourceRecord(v **types.AwsCertificateManagerCertificateResourceRecord, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateResourceRecord
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateResourceRecord{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFormationStackDetails(v **types.AwsCloudFormationStackDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFormationStackDetails
	if *v == nil {
		sv = &types.AwsCloudFormationStackDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Capabilities":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Capabilities, value); err != nil {
				return err
			}

		case "CreationTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreationTime = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "DisableRollback":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DisableRollback = ptr.Bool(jtv)
			}

		case "DriftInformation":
			if err := awsRestjson1_deserializeDocumentAwsCloudFormationStackDriftInformationDetails(&sv.DriftInformation, value); err != nil {
				return err
			}

		case "EnableTerminationProtection":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableTerminationProtection = ptr.Bool(jtv)
			}

		case "LastUpdatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastUpdatedTime = ptr.String(jtv)
			}

		case "NotificationArns":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.NotificationArns, value); err != nil {
				return err
			}

		case "Outputs":
			if err := awsRestjson1_deserializeDocumentAwsCloudFormationStackOutputsList(&sv.Outputs, value); err != nil {
				return err
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "StackId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StackId = ptr.String(jtv)
			}

		case "StackName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StackName = ptr.String(jtv)
			}

		case "StackStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StackStatus = ptr.String(jtv)
			}

		case "StackStatusReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StackStatusReason = ptr.String(jtv)
			}

		case "TimeoutInMinutes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TimeoutInMinutes = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFormationStackDriftInformationDetails(v **types.AwsCloudFormationStackDriftInformationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFormationStackDriftInformationDetails
	if *v == nil {
		sv = &types.AwsCloudFormationStackDriftInformationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StackDriftStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StackDriftStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFormationStackOutputsDetails(v **types.AwsCloudFormationStackOutputsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFormationStackOutputsDetails
	if *v == nil {
		sv = &types.AwsCloudFormationStackOutputsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "OutputKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OutputKey = ptr.String(jtv)
			}

		case "OutputValue":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OutputValue = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFormationStackOutputsList(v *[]types.AwsCloudFormationStackOutputsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudFormationStackOutputsDetails
	if *v == nil {
		cv = []types.AwsCloudFormationStackOutputsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudFormationStackOutputsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudFormationStackOutputsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehavior(v **types.AwsCloudFrontDistributionCacheBehavior, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionCacheBehavior
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionCacheBehavior{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ViewerProtocolPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ViewerProtocolPolicy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviors(v **types.AwsCloudFrontDistributionCacheBehaviors, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionCacheBehaviors
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionCacheBehaviors{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviorsItemList(&sv.Items, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviorsItemList(v *[]types.AwsCloudFrontDistributionCacheBehavior, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudFrontDistributionCacheBehavior
	if *v == nil {
		cv = []types.AwsCloudFrontDistributionCacheBehavior{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudFrontDistributionCacheBehavior
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehavior(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionDefaultCacheBehavior(v **types.AwsCloudFrontDistributionDefaultCacheBehavior, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionDefaultCacheBehavior
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionDefaultCacheBehavior{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ViewerProtocolPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ViewerProtocolPolicy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionDetails(v **types.AwsCloudFrontDistributionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionDetails
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CacheBehaviors":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviors(&sv.CacheBehaviors, value); err != nil {
				return err
			}

		case "DefaultCacheBehavior":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionDefaultCacheBehavior(&sv.DefaultCacheBehavior, value); err != nil {
				return err
			}

		case "DefaultRootObject":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DefaultRootObject = ptr.String(jtv)
			}

		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "ETag":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ETag = ptr.String(jtv)
			}

		case "LastModifiedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastModifiedTime = ptr.String(jtv)
			}

		case "Logging":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionLogging(&sv.Logging, value); err != nil {
				return err
			}

		case "OriginGroups":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroups(&sv.OriginGroups, value); err != nil {
				return err
			}

		case "Origins":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOrigins(&sv.Origins, value); err != nil {
				return err
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "ViewerCertificate":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionViewerCertificate(&sv.ViewerCertificate, value); err != nil {
				return err
			}

		case "WebAclId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WebAclId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionLogging(v **types.AwsCloudFrontDistributionLogging, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionLogging
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionLogging{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Bucket":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Bucket = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		case "IncludeCookies":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IncludeCookies = ptr.Bool(jtv)
			}

		case "Prefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Prefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginCustomOriginConfig(v **types.AwsCloudFrontDistributionOriginCustomOriginConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginCustomOriginConfig
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginCustomOriginConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HttpPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HttpPort = ptr.Int32(int32(i64))
			}

		case "HttpsPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HttpsPort = ptr.Int32(int32(i64))
			}

		case "OriginKeepaliveTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OriginKeepaliveTimeout = ptr.Int32(int32(i64))
			}

		case "OriginProtocolPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OriginProtocolPolicy = ptr.String(jtv)
			}

		case "OriginReadTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OriginReadTimeout = ptr.Int32(int32(i64))
			}

		case "OriginSslProtocols":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginSslProtocols(&sv.OriginSslProtocols, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroup(v **types.AwsCloudFrontDistributionOriginGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroup
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FailoverCriteria":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailover(&sv.FailoverCriteria, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailover(v **types.AwsCloudFrontDistributionOriginGroupFailover, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroupFailover
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroupFailover{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StatusCodes":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodes(&sv.StatusCodes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodes(v **types.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList(&sv.Items, value); err != nil {
				return err
			}

		case "Quantity":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Quantity = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList(v *[]int32, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []int32
	if *v == nil {
		cv = []int32{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col int32
		if value != nil {
			jtv, ok := value.(json.Number)
			if !ok {
				return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
			}
			i64, err := jtv.Int64()
			if err != nil {
				return err
			}
			col = int32(i64)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroups(v **types.AwsCloudFrontDistributionOriginGroups, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroups
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroups{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupsItemList(&sv.Items, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupsItemList(v *[]types.AwsCloudFrontDistributionOriginGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudFrontDistributionOriginGroup
	if *v == nil {
		cv = []types.AwsCloudFrontDistributionOriginGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudFrontDistributionOriginGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItem(v **types.AwsCloudFrontDistributionOriginItem, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginItem
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginItem{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CustomOriginConfig":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginCustomOriginConfig(&sv.CustomOriginConfig, value); err != nil {
				return err
			}

		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "OriginPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OriginPath = ptr.String(jtv)
			}

		case "S3OriginConfig":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginS3OriginConfig(&sv.S3OriginConfig, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItemList(v *[]types.AwsCloudFrontDistributionOriginItem, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudFrontDistributionOriginItem
	if *v == nil {
		cv = []types.AwsCloudFrontDistributionOriginItem{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudFrontDistributionOriginItem
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItem(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOrigins(v **types.AwsCloudFrontDistributionOrigins, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOrigins
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOrigins{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItemList(&sv.Items, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginS3OriginConfig(v **types.AwsCloudFrontDistributionOriginS3OriginConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginS3OriginConfig
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginS3OriginConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "OriginAccessIdentity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OriginAccessIdentity = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginSslProtocols(v **types.AwsCloudFrontDistributionOriginSslProtocols, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginSslProtocols
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginSslProtocols{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Items, value); err != nil {
				return err
			}

		case "Quantity":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Quantity = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionViewerCertificate(v **types.AwsCloudFrontDistributionViewerCertificate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionViewerCertificate
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionViewerCertificate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AcmCertificateArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AcmCertificateArn = ptr.String(jtv)
			}

		case "Certificate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Certificate = ptr.String(jtv)
			}

		case "CertificateSource":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateSource = ptr.String(jtv)
			}

		case "CloudFrontDefaultCertificate":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CloudFrontDefaultCertificate = ptr.Bool(jtv)
			}

		case "IamCertificateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamCertificateId = ptr.String(jtv)
			}

		case "MinimumProtocolVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MinimumProtocolVersion = ptr.String(jtv)
			}

		case "SslSupportMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SslSupportMethod = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudTrailTrailDetails(v **types.AwsCloudTrailTrailDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudTrailTrailDetails
	if *v == nil {
		sv = &types.AwsCloudTrailTrailDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchLogsLogGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogsLogGroupArn = ptr.String(jtv)
			}

		case "CloudWatchLogsRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogsRoleArn = ptr.String(jtv)
			}

		case "HasCustomEventSelectors":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCustomEventSelectors = ptr.Bool(jtv)
			}

		case "HomeRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HomeRegion = ptr.String(jtv)
			}

		case "IncludeGlobalServiceEvents":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IncludeGlobalServiceEvents = ptr.Bool(jtv)
			}

		case "IsMultiRegionTrail":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsMultiRegionTrail = ptr.Bool(jtv)
			}

		case "IsOrganizationTrail":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsOrganizationTrail = ptr.Bool(jtv)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "LogFileValidationEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.LogFileValidationEnabled = ptr.Bool(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "S3BucketName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketName = ptr.String(jtv)
			}

		case "S3KeyPrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3KeyPrefix = ptr.String(jtv)
			}

		case "SnsTopicArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnsTopicArn = ptr.String(jtv)
			}

		case "SnsTopicName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnsTopicName = ptr.String(jtv)
			}

		case "TrailArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TrailArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudWatchAlarmDetails(v **types.AwsCloudWatchAlarmDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudWatchAlarmDetails
	if *v == nil {
		sv = &types.AwsCloudWatchAlarmDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionsEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ActionsEnabled = ptr.Bool(jtv)
			}

		case "AlarmActions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AlarmActions, value); err != nil {
				return err
			}

		case "AlarmArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AlarmArn = ptr.String(jtv)
			}

		case "AlarmConfigurationUpdatedTimestamp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AlarmConfigurationUpdatedTimestamp = ptr.String(jtv)
			}

		case "AlarmDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AlarmDescription = ptr.String(jtv)
			}

		case "AlarmName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AlarmName = ptr.String(jtv)
			}

		case "ComparisonOperator":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ComparisonOperator = ptr.String(jtv)
			}

		case "DatapointsToAlarm":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DatapointsToAlarm = ptr.Int32(int32(i64))
			}

		case "Dimensions":
			if err := awsRestjson1_deserializeDocumentAwsCloudWatchAlarmDimensionsList(&sv.Dimensions, value); err != nil {
				return err
			}

		case "EvaluateLowSampleCountPercentile":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EvaluateLowSampleCountPercentile = ptr.String(jtv)
			}

		case "EvaluationPeriods":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.EvaluationPeriods = ptr.Int32(int32(i64))
			}

		case "ExtendedStatistic":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExtendedStatistic = ptr.String(jtv)
			}

		case "InsufficientDataActions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.InsufficientDataActions, value); err != nil {
				return err
			}

		case "MetricName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MetricName = ptr.String(jtv)
			}

		case "Namespace":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Namespace = ptr.String(jtv)
			}

		case "OkActions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.OkActions, value); err != nil {
				return err
			}

		case "Period":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Period = ptr.Int32(int32(i64))
			}

		case "Statistic":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Statistic = ptr.String(jtv)
			}

		case "Threshold":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Threshold = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Threshold = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "ThresholdMetricId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ThresholdMetricId = ptr.String(jtv)
			}

		case "TreatMissingData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TreatMissingData = ptr.String(jtv)
			}

		case "Unit":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Unit = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudWatchAlarmDimensionsDetails(v **types.AwsCloudWatchAlarmDimensionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudWatchAlarmDimensionsDetails
	if *v == nil {
		sv = &types.AwsCloudWatchAlarmDimensionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudWatchAlarmDimensionsList(v *[]types.AwsCloudWatchAlarmDimensionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudWatchAlarmDimensionsDetails
	if *v == nil {
		cv = []types.AwsCloudWatchAlarmDimensionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudWatchAlarmDimensionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudWatchAlarmDimensionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectArtifactsDetails(v **types.AwsCodeBuildProjectArtifactsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectArtifactsDetails
	if *v == nil {
		sv = &types.AwsCodeBuildProjectArtifactsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ArtifactIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ArtifactIdentifier = ptr.String(jtv)
			}

		case "EncryptionDisabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EncryptionDisabled = ptr.Bool(jtv)
			}

		case "Location":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Location = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "NamespaceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NamespaceType = ptr.String(jtv)
			}

		case "OverrideArtifactName":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.OverrideArtifactName = ptr.Bool(jtv)
			}

		case "Packaging":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Packaging = ptr.String(jtv)
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectArtifactsList(v *[]types.AwsCodeBuildProjectArtifactsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCodeBuildProjectArtifactsDetails
	if *v == nil {
		cv = []types.AwsCodeBuildProjectArtifactsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCodeBuildProjectArtifactsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectArtifactsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectDetails(v **types.AwsCodeBuildProjectDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectDetails
	if *v == nil {
		sv = &types.AwsCodeBuildProjectDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Artifacts":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectArtifactsList(&sv.Artifacts, value); err != nil {
				return err
			}

		case "EncryptionKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EncryptionKey = ptr.String(jtv)
			}

		case "Environment":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironment(&sv.Environment, value); err != nil {
				return err
			}

		case "LogsConfig":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectLogsConfigDetails(&sv.LogsConfig, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "SecondaryArtifacts":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectArtifactsList(&sv.SecondaryArtifacts, value); err != nil {
				return err
			}

		case "ServiceRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceRole = ptr.String(jtv)
			}

		case "Source":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectSource(&sv.Source, value); err != nil {
				return err
			}

		case "VpcConfig":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectVpcConfig(&sv.VpcConfig, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironment(v **types.AwsCodeBuildProjectEnvironment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectEnvironment
	if *v == nil {
		sv = &types.AwsCodeBuildProjectEnvironment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Certificate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Certificate = ptr.String(jtv)
			}

		case "EnvironmentVariables":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentEnvironmentVariablesList(&sv.EnvironmentVariables, value); err != nil {
				return err
			}

		case "ImagePullCredentialsType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImagePullCredentialsType = ptr.String(jtv)
			}

		case "PrivilegedMode":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PrivilegedMode = ptr.Bool(jtv)
			}

		case "RegistryCredential":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentRegistryCredential(&sv.RegistryCredential, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails(v **types.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
	if *v == nil {
		sv = &types.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentEnvironmentVariablesList(v *[]types.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
	if *v == nil {
		cv = []types.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentRegistryCredential(v **types.AwsCodeBuildProjectEnvironmentRegistryCredential, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectEnvironmentRegistryCredential
	if *v == nil {
		sv = &types.AwsCodeBuildProjectEnvironmentRegistryCredential{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Credential":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Credential = ptr.String(jtv)
			}

		case "CredentialProvider":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CredentialProvider = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(v **types.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
	if *v == nil {
		sv = &types.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StreamName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StreamName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectLogsConfigDetails(v **types.AwsCodeBuildProjectLogsConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectLogsConfigDetails
	if *v == nil {
		sv = &types.AwsCodeBuildProjectLogsConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchLogs":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(&sv.CloudWatchLogs, value); err != nil {
				return err
			}

		case "S3Logs":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectLogsConfigS3LogsDetails(&sv.S3Logs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectLogsConfigS3LogsDetails(v **types.AwsCodeBuildProjectLogsConfigS3LogsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectLogsConfigS3LogsDetails
	if *v == nil {
		sv = &types.AwsCodeBuildProjectLogsConfigS3LogsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EncryptionDisabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EncryptionDisabled = ptr.Bool(jtv)
			}

		case "Location":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Location = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectSource(v **types.AwsCodeBuildProjectSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectSource
	if *v == nil {
		sv = &types.AwsCodeBuildProjectSource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GitCloneDepth":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GitCloneDepth = ptr.Int32(int32(i64))
			}

		case "InsecureSsl":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.InsecureSsl = ptr.Bool(jtv)
			}

		case "Location":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Location = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectVpcConfig(v **types.AwsCodeBuildProjectVpcConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectVpcConfig
	if *v == nil {
		sv = &types.AwsCodeBuildProjectVpcConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SecurityGroupIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupIds, value); err != nil {
				return err
			}

		case "Subnets":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Subnets, value); err != nil {
				return err
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCorsConfiguration(v **types.AwsCorsConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCorsConfiguration
	if *v == nil {
		sv = &types.AwsCorsConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllowCredentials":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AllowCredentials = ptr.Bool(jtv)
			}

		case "AllowHeaders":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AllowHeaders, value); err != nil {
				return err
			}

		case "AllowMethods":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AllowMethods, value); err != nil {
				return err
			}

		case "AllowOrigins":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AllowOrigins, value); err != nil {
				return err
			}

		case "ExposeHeaders":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.ExposeHeaders, value); err != nil {
				return err
			}

		case "MaxAge":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxAge = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDmsEndpointDetails(v **types.AwsDmsEndpointDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDmsEndpointDetails
	if *v == nil {
		sv = &types.AwsDmsEndpointDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CertificateArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateArn = ptr.String(jtv)
			}

		case "DatabaseName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DatabaseName = ptr.String(jtv)
			}

		case "EndpointArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EndpointArn = ptr.String(jtv)
			}

		case "EndpointIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EndpointIdentifier = ptr.String(jtv)
			}

		case "EndpointType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EndpointType = ptr.String(jtv)
			}

		case "EngineName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineName = ptr.String(jtv)
			}

		case "ExternalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExternalId = ptr.String(jtv)
			}

		case "ExtraConnectionAttributes":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExtraConnectionAttributes = ptr.String(jtv)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case "ServerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServerName = ptr.String(jtv)
			}

		case "SslMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SslMode = ptr.String(jtv)
			}

		case "Username":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Username = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDmsReplicationInstanceDetails(v **types.AwsDmsReplicationInstanceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDmsReplicationInstanceDetails
	if *v == nil {
		sv = &types.AwsDmsReplicationInstanceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllocatedStorage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AllocatedStorage = ptr.Int32(int32(i64))
			}

		case "AutoMinorVersionUpgrade":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoMinorVersionUpgrade = ptr.Bool(jtv)
			}

		case "AvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZone = ptr.String(jtv)
			}

		case "EngineVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineVersion = ptr.String(jtv)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "MultiAZ":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MultiAZ = ptr.Bool(jtv)
			}

		case "PreferredMaintenanceWindow":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreferredMaintenanceWindow = ptr.String(jtv)
			}

		case "PubliclyAccessible":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PubliclyAccessible = ptr.Bool(jtv)
			}

		case "ReplicationInstanceClass":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicationInstanceClass = ptr.String(jtv)
			}

		case "ReplicationInstanceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicationInstanceIdentifier = ptr.String(jtv)
			}

		case "ReplicationSubnetGroup":
			if err := awsRestjson1_deserializeDocumentAwsDmsReplicationInstanceReplicationSubnetGroupDetails(&sv.ReplicationSubnetGroup, value); err != nil {
				return err
			}

		case "VpcSecurityGroups":
			if err := awsRestjson1_deserializeDocumentAwsDmsReplicationInstanceVpcSecurityGroupsList(&sv.VpcSecurityGroups, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDmsReplicationInstanceReplicationSubnetGroupDetails(v **types.AwsDmsReplicationInstanceReplicationSubnetGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDmsReplicationInstanceReplicationSubnetGroupDetails
	if *v == nil {
		sv = &types.AwsDmsReplicationInstanceReplicationSubnetGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ReplicationSubnetGroupIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicationSubnetGroupIdentifier = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDmsReplicationInstanceVpcSecurityGroupsDetails(v **types.AwsDmsReplicationInstanceVpcSecurityGroupsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
	if *v == nil {
		sv = &types.AwsDmsReplicationInstanceVpcSecurityGroupsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "VpcSecurityGroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcSecurityGroupId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDmsReplicationInstanceVpcSecurityGroupsList(v *[]types.AwsDmsReplicationInstanceVpcSecurityGroupsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
	if *v == nil {
		cv = []types.AwsDmsReplicationInstanceVpcSecurityGroupsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDmsReplicationInstanceVpcSecurityGroupsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDmsReplicationInstanceVpcSecurityGroupsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDmsReplicationTaskDetails(v **types.AwsDmsReplicationTaskDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDmsReplicationTaskDetails
	if *v == nil {
		sv = &types.AwsDmsReplicationTaskDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CdcStartPosition":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CdcStartPosition = ptr.String(jtv)
			}

		case "CdcStartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CdcStartTime = ptr.String(jtv)
			}

		case "CdcStopPosition":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CdcStopPosition = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "MigrationType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MigrationType = ptr.String(jtv)
			}

		case "ReplicationInstanceArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicationInstanceArn = ptr.String(jtv)
			}

		case "ReplicationTaskIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicationTaskIdentifier = ptr.String(jtv)
			}

		case "ReplicationTaskSettings":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicationTaskSettings = ptr.String(jtv)
			}

		case "ResourceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourceIdentifier = ptr.String(jtv)
			}

		case "SourceEndpointArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceEndpointArn = ptr.String(jtv)
			}

		case "TableMappings":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TableMappings = ptr.String(jtv)
			}

		case "TargetEndpointArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TargetEndpointArn = ptr.String(jtv)
			}

		case "TaskData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TaskData = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinition(v **types.AwsDynamoDbTableAttributeDefinition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableAttributeDefinition
	if *v == nil {
		sv = &types.AwsDynamoDbTableAttributeDefinition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributeName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttributeName = ptr.String(jtv)
			}

		case "AttributeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttributeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinitionList(v *[]types.AwsDynamoDbTableAttributeDefinition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableAttributeDefinition
	if *v == nil {
		cv = []types.AwsDynamoDbTableAttributeDefinition{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableAttributeDefinition
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinition(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableBillingModeSummary(v **types.AwsDynamoDbTableBillingModeSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableBillingModeSummary
	if *v == nil {
		sv = &types.AwsDynamoDbTableBillingModeSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BillingMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BillingMode = ptr.String(jtv)
			}

		case "LastUpdateToPayPerRequestDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastUpdateToPayPerRequestDateTime = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableDetails(v **types.AwsDynamoDbTableDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableDetails
	if *v == nil {
		sv = &types.AwsDynamoDbTableDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributeDefinitions":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinitionList(&sv.AttributeDefinitions, value); err != nil {
				return err
			}

		case "BillingModeSummary":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableBillingModeSummary(&sv.BillingModeSummary, value); err != nil {
				return err
			}

		case "CreationDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreationDateTime = ptr.String(jtv)
			}

		case "DeletionProtectionEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeletionProtectionEnabled = ptr.Bool(jtv)
			}

		case "GlobalSecondaryIndexes":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndexList(&sv.GlobalSecondaryIndexes, value); err != nil {
				return err
			}

		case "GlobalTableVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GlobalTableVersion = ptr.String(jtv)
			}

		case "ItemCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ItemCount = ptr.Int32(int32(i64))
			}

		case "KeySchema":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(&sv.KeySchema, value); err != nil {
				return err
			}

		case "LatestStreamArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LatestStreamArn = ptr.String(jtv)
			}

		case "LatestStreamLabel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LatestStreamLabel = ptr.String(jtv)
			}

		case "LocalSecondaryIndexes":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndexList(&sv.LocalSecondaryIndexes, value); err != nil {
				return err
			}

		case "ProvisionedThroughput":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughput(&sv.ProvisionedThroughput, value); err != nil {
				return err
			}

		case "Replicas":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaList(&sv.Replicas, value); err != nil {
				return err
			}

		case "RestoreSummary":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableRestoreSummary(&sv.RestoreSummary, value); err != nil {
				return err
			}

		case "SseDescription":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableSseDescription(&sv.SseDescription, value); err != nil {
				return err
			}

		case "StreamSpecification":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableStreamSpecification(&sv.StreamSpecification, value); err != nil {
				return err
			}

		case "TableId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TableId = ptr.String(jtv)
			}

		case "TableName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TableName = ptr.String(jtv)
			}

		case "TableSizeBytes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected SizeBytes to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TableSizeBytes = ptr.Int64(i64)
			}

		case "TableStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TableStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndex(v **types.AwsDynamoDbTableGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableGlobalSecondaryIndex
	if *v == nil {
		sv = &types.AwsDynamoDbTableGlobalSecondaryIndex{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Backfilling":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Backfilling = ptr.Bool(jtv)
			}

		case "IndexArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexArn = ptr.String(jtv)
			}

		case "IndexName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexName = ptr.String(jtv)
			}

		case "IndexSizeBytes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected SizeBytes to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.IndexSizeBytes = ptr.Int64(i64)
			}

		case "IndexStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexStatus = ptr.String(jtv)
			}

		case "ItemCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ItemCount = ptr.Int32(int32(i64))
			}

		case "KeySchema":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(&sv.KeySchema, value); err != nil {
				return err
			}

		case "Projection":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProjection(&sv.Projection, value); err != nil {
				return err
			}

		case "ProvisionedThroughput":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughput(&sv.ProvisionedThroughput, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndexList(v *[]types.AwsDynamoDbTableGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableGlobalSecondaryIndex
	if *v == nil {
		cv = []types.AwsDynamoDbTableGlobalSecondaryIndex{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableGlobalSecondaryIndex
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndex(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchema(v **types.AwsDynamoDbTableKeySchema, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableKeySchema
	if *v == nil {
		sv = &types.AwsDynamoDbTableKeySchema{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributeName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttributeName = ptr.String(jtv)
			}

		case "KeyType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(v *[]types.AwsDynamoDbTableKeySchema, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableKeySchema
	if *v == nil {
		cv = []types.AwsDynamoDbTableKeySchema{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableKeySchema
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchema(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndex(v **types.AwsDynamoDbTableLocalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableLocalSecondaryIndex
	if *v == nil {
		sv = &types.AwsDynamoDbTableLocalSecondaryIndex{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IndexArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexArn = ptr.String(jtv)
			}

		case "IndexName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexName = ptr.String(jtv)
			}

		case "KeySchema":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(&sv.KeySchema, value); err != nil {
				return err
			}

		case "Projection":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProjection(&sv.Projection, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndexList(v *[]types.AwsDynamoDbTableLocalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableLocalSecondaryIndex
	if *v == nil {
		cv = []types.AwsDynamoDbTableLocalSecondaryIndex{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableLocalSecondaryIndex
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndex(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableProjection(v **types.AwsDynamoDbTableProjection, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableProjection
	if *v == nil {
		sv = &types.AwsDynamoDbTableProjection{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NonKeyAttributes":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.NonKeyAttributes, value); err != nil {
				return err
			}

		case "ProjectionType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProjectionType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughput(v **types.AwsDynamoDbTableProvisionedThroughput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableProvisionedThroughput
	if *v == nil {
		sv = &types.AwsDynamoDbTableProvisionedThroughput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LastDecreaseDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastDecreaseDateTime = ptr.String(jtv)
			}

		case "LastIncreaseDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastIncreaseDateTime = ptr.String(jtv)
			}

		case "NumberOfDecreasesToday":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NumberOfDecreasesToday = ptr.Int32(int32(i64))
			}

		case "ReadCapacityUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ReadCapacityUnits = ptr.Int32(int32(i64))
			}

		case "WriteCapacityUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WriteCapacityUnits = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(v **types.AwsDynamoDbTableProvisionedThroughputOverride, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableProvisionedThroughputOverride
	if *v == nil {
		sv = &types.AwsDynamoDbTableProvisionedThroughputOverride{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ReadCapacityUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ReadCapacityUnits = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplica(v **types.AwsDynamoDbTableReplica, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableReplica
	if *v == nil {
		sv = &types.AwsDynamoDbTableReplica{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GlobalSecondaryIndexes":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndexList(&sv.GlobalSecondaryIndexes, value); err != nil {
				return err
			}

		case "KmsMasterKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsMasterKeyId = ptr.String(jtv)
			}

		case "ProvisionedThroughputOverride":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(&sv.ProvisionedThroughputOverride, value); err != nil {
				return err
			}

		case "RegionName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegionName = ptr.String(jtv)
			}

		case "ReplicaStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicaStatus = ptr.String(jtv)
			}

		case "ReplicaStatusDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicaStatusDescription = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndex(v **types.AwsDynamoDbTableReplicaGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableReplicaGlobalSecondaryIndex
	if *v == nil {
		sv = &types.AwsDynamoDbTableReplicaGlobalSecondaryIndex{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IndexName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexName = ptr.String(jtv)
			}

		case "ProvisionedThroughputOverride":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(&sv.ProvisionedThroughputOverride, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndexList(v *[]types.AwsDynamoDbTableReplicaGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableReplicaGlobalSecondaryIndex
	if *v == nil {
		cv = []types.AwsDynamoDbTableReplicaGlobalSecondaryIndex{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableReplicaGlobalSecondaryIndex
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndex(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaList(v *[]types.AwsDynamoDbTableReplica, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableReplica
	if *v == nil {
		cv = []types.AwsDynamoDbTableReplica{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableReplica
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplica(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableRestoreSummary(v **types.AwsDynamoDbTableRestoreSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableRestoreSummary
	if *v == nil {
		sv = &types.AwsDynamoDbTableRestoreSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RestoreDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RestoreDateTime = ptr.String(jtv)
			}

		case "RestoreInProgress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RestoreInProgress = ptr.Bool(jtv)
			}

		case "SourceBackupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceBackupArn = ptr.String(jtv)
			}

		case "SourceTableArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceTableArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableSseDescription(v **types.AwsDynamoDbTableSseDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableSseDescription
	if *v == nil {
		sv = &types.AwsDynamoDbTableSseDescription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InaccessibleEncryptionDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InaccessibleEncryptionDateTime = ptr.String(jtv)
			}

		case "KmsMasterKeyArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsMasterKeyArn = ptr.String(jtv)
			}

		case "SseType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SseType = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableStreamSpecification(v **types.AwsDynamoDbTableStreamSpecification, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableStreamSpecification
	if *v == nil {
		sv = &types.AwsDynamoDbTableStreamSpecification{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StreamEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.StreamEnabled = ptr.Bool(jtv)
			}

		case "StreamViewType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StreamViewType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails(v **types.AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DirectoryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DirectoryId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsDetails(v **types.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActiveDirectory":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails(&sv.ActiveDirectory, value); err != nil {
				return err
			}

		case "FederatedAuthentication":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails(&sv.FederatedAuthentication, value); err != nil {
				return err
			}

		case "MutualAuthentication":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails(&sv.MutualAuthentication, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails(v **types.AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SamlProviderArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SamlProviderArn = ptr.String(jtv)
			}

		case "SelfServiceSamlProviderArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SelfServiceSamlProviderArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsList(v *[]types.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails
	if *v == nil {
		cv = []types.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails(v **types.AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ClientRootCertificateChain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientRootCertificateChain = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointClientConnectOptionsDetails(v **types.AwsEc2ClientVpnEndpointClientConnectOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointClientConnectOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointClientConnectOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		case "LambdaFunctionArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LambdaFunctionArn = ptr.String(jtv)
			}

		case "Status":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails(&sv.Status, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails(v **types.AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointClientConnectOptionsStatusDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails(v **types.AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BannerText":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BannerText = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointConnectionLogOptionsDetails(v **types.AwsEc2ClientVpnEndpointConnectionLogOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointConnectionLogOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointConnectionLogOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudwatchLogGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudwatchLogGroup = ptr.String(jtv)
			}

		case "CloudwatchLogStream":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudwatchLogStream = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointDetails(v **types.AwsEc2ClientVpnEndpointDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2ClientVpnEndpointDetails
	if *v == nil {
		sv = &types.AwsEc2ClientVpnEndpointDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuthenticationOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointAuthenticationOptionsList(&sv.AuthenticationOptions, value); err != nil {
				return err
			}

		case "ClientCidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientCidrBlock = ptr.String(jtv)
			}

		case "ClientConnectOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointClientConnectOptionsDetails(&sv.ClientConnectOptions, value); err != nil {
				return err
			}

		case "ClientLoginBannerOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails(&sv.ClientLoginBannerOptions, value); err != nil {
				return err
			}

		case "ClientVpnEndpointId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientVpnEndpointId = ptr.String(jtv)
			}

		case "ConnectionLogOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2ClientVpnEndpointConnectionLogOptionsDetails(&sv.ConnectionLogOptions, value); err != nil {
				return err
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "DnsServer":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.DnsServer, value); err != nil {
				return err
			}

		case "SecurityGroupIdSet":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.SecurityGroupIdSet, value); err != nil {
				return err
			}

		case "SelfServicePortalUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SelfServicePortalUrl = ptr.String(jtv)
			}

		case "ServerCertificateArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServerCertificateArn = ptr.String(jtv)
			}

		case "SessionTimeoutHours":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SessionTimeoutHours = ptr.Int32(int32(i64))
			}

		case "SplitTunnel":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.SplitTunnel = ptr.Bool(jtv)
			}

		case "TransportProtocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TransportProtocol = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		case "VpnPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VpnPort = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2EipDetails(v **types.AwsEc2EipDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2EipDetails
	if *v == nil {
		sv = &types.AwsEc2EipDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllocationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AllocationId = ptr.String(jtv)
			}

		case "AssociationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssociationId = ptr.String(jtv)
			}

		case "Domain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Domain = ptr.String(jtv)
			}

		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		case "NetworkBorderGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkBorderGroup = ptr.String(jtv)
			}

		case "NetworkInterfaceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceId = ptr.String(jtv)
			}

		case "NetworkInterfaceOwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceOwnerId = ptr.String(jtv)
			}

		case "PrivateIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateIpAddress = ptr.String(jtv)
			}

		case "PublicIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicIp = ptr.String(jtv)
			}

		case "PublicIpv4Pool":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicIpv4Pool = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceDetails(v **types.AwsEc2InstanceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2InstanceDetails
	if *v == nil {
		sv = &types.AwsEc2InstanceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IamInstanceProfileArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamInstanceProfileArn = ptr.String(jtv)
			}

		case "ImageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageId = ptr.String(jtv)
			}

		case "IpV4Addresses":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.IpV4Addresses, value); err != nil {
				return err
			}

		case "IpV6Addresses":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.IpV6Addresses, value); err != nil {
				return err
			}

		case "KeyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyName = ptr.String(jtv)
			}

		case "LaunchedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchedAt = ptr.String(jtv)
			}

		case "MetadataOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2InstanceMetadataOptions(&sv.MetadataOptions, value); err != nil {
				return err
			}

		case "Monitoring":
			if err := awsRestjson1_deserializeDocumentAwsEc2InstanceMonitoringDetails(&sv.Monitoring, value); err != nil {
				return err
			}

		case "NetworkInterfaces":
			if err := awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesList(&sv.NetworkInterfaces, value); err != nil {
				return err
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "VirtualizationType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VirtualizationType = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceMetadataOptions(v **types.AwsEc2InstanceMetadataOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2InstanceMetadataOptions
	if *v == nil {
		sv = &types.AwsEc2InstanceMetadataOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HttpEndpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpEndpoint = ptr.String(jtv)
			}

		case "HttpProtocolIpv6":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpProtocolIpv6 = ptr.String(jtv)
			}

		case "HttpPutResponseHopLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HttpPutResponseHopLimit = ptr.Int32(int32(i64))
			}

		case "HttpTokens":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpTokens = ptr.String(jtv)
			}

		case "InstanceMetadataTags":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceMetadataTags = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceMonitoringDetails(v **types.AwsEc2InstanceMonitoringDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2InstanceMonitoringDetails
	if *v == nil {
		sv = &types.AwsEc2InstanceMonitoringDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesDetails(v **types.AwsEc2InstanceNetworkInterfacesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2InstanceNetworkInterfacesDetails
	if *v == nil {
		sv = &types.AwsEc2InstanceNetworkInterfacesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NetworkInterfaceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesList(v *[]types.AwsEc2InstanceNetworkInterfacesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2InstanceNetworkInterfacesDetails
	if *v == nil {
		cv = []types.AwsEc2InstanceNetworkInterfacesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2InstanceNetworkInterfacesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails(v **types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeviceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceName = ptr.String(jtv)
			}

		case "Ebs":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails(&sv.Ebs, value); err != nil {
				return err
			}

		case "NoDevice":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NoDevice = ptr.String(jtv)
			}

		case "VirtualName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VirtualName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails(v **types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = ptr.Bool(jtv)
			}

		case "Encrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Encrypted = ptr.Bool(jtv)
			}

		case "Iops":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Iops = ptr.Int32(int32(i64))
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "SnapshotId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotId = ptr.String(jtv)
			}

		case "Throughput":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Throughput = ptr.Int32(int32(i64))
			}

		case "VolumeSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeSize = ptr.Int32(int32(i64))
			}

		case "VolumeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VolumeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataBlockDeviceMappingSetList(v *[]types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails(v **types.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CapacityReservationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CapacityReservationId = ptr.String(jtv)
			}

		case "CapacityReservationResourceGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CapacityReservationResourceGroupArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails(v **types.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CapacityReservationPreference":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CapacityReservationPreference = ptr.String(jtv)
			}

		case "CapacityReservationTarget":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails(&sv.CapacityReservationTarget, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCpuOptionsDetails(v **types.AwsEc2LaunchTemplateDataCpuOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataCpuOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataCpuOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CoreCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CoreCount = ptr.Int32(int32(i64))
			}

		case "ThreadsPerCore":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ThreadsPerCore = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCreditSpecificationDetails(v **types.AwsEc2LaunchTemplateDataCreditSpecificationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataCreditSpecificationDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataCreditSpecificationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CpuCredits":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CpuCredits = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataDetails(v **types.AwsEc2LaunchTemplateDataDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BlockDeviceMappingSet":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataBlockDeviceMappingSetList(&sv.BlockDeviceMappingSet, value); err != nil {
				return err
			}

		case "CapacityReservationSpecification":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails(&sv.CapacityReservationSpecification, value); err != nil {
				return err
			}

		case "CpuOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCpuOptionsDetails(&sv.CpuOptions, value); err != nil {
				return err
			}

		case "CreditSpecification":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataCreditSpecificationDetails(&sv.CreditSpecification, value); err != nil {
				return err
			}

		case "DisableApiStop":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DisableApiStop = ptr.Bool(jtv)
			}

		case "DisableApiTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DisableApiTermination = ptr.Bool(jtv)
			}

		case "EbsOptimized":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EbsOptimized = ptr.Bool(jtv)
			}

		case "ElasticGpuSpecificationSet":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticGpuSpecificationSetList(&sv.ElasticGpuSpecificationSet, value); err != nil {
				return err
			}

		case "ElasticInferenceAcceleratorSet":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetList(&sv.ElasticInferenceAcceleratorSet, value); err != nil {
				return err
			}

		case "EnclaveOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataEnclaveOptionsDetails(&sv.EnclaveOptions, value); err != nil {
				return err
			}

		case "HibernationOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataHibernationOptionsDetails(&sv.HibernationOptions, value); err != nil {
				return err
			}

		case "IamInstanceProfile":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataIamInstanceProfileDetails(&sv.IamInstanceProfile, value); err != nil {
				return err
			}

		case "ImageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageId = ptr.String(jtv)
			}

		case "InstanceInitiatedShutdownBehavior":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceInitiatedShutdownBehavior = ptr.String(jtv)
			}

		case "InstanceMarketOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(&sv.InstanceMarketOptions, value); err != nil {
				return err
			}

		case "InstanceRequirements":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsDetails(&sv.InstanceRequirements, value); err != nil {
				return err
			}

		case "InstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "KernelId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KernelId = ptr.String(jtv)
			}

		case "KeyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyName = ptr.String(jtv)
			}

		case "LicenseSet":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataLicenseSetList(&sv.LicenseSet, value); err != nil {
				return err
			}

		case "MaintenanceOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataMaintenanceOptionsDetails(&sv.MaintenanceOptions, value); err != nil {
				return err
			}

		case "MetadataOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataMetadataOptionsDetails(&sv.MetadataOptions, value); err != nil {
				return err
			}

		case "Monitoring":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataMonitoringDetails(&sv.Monitoring, value); err != nil {
				return err
			}

		case "NetworkInterfaceSet":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetList(&sv.NetworkInterfaceSet, value); err != nil {
				return err
			}

		case "Placement":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataPlacementDetails(&sv.Placement, value); err != nil {
				return err
			}

		case "PrivateDnsNameOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails(&sv.PrivateDnsNameOptions, value); err != nil {
				return err
			}

		case "RamDiskId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RamDiskId = ptr.String(jtv)
			}

		case "SecurityGroupIdSet":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupIdSet, value); err != nil {
				return err
			}

		case "SecurityGroupSet":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupSet, value); err != nil {
				return err
			}

		case "UserData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserData = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails(v **types.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticGpuSpecificationSetList(v *[]types.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails(v **types.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = ptr.Int32(int32(i64))
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetList(v *[]types.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataEnclaveOptionsDetails(v **types.AwsEc2LaunchTemplateDataEnclaveOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataEnclaveOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataEnclaveOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataHibernationOptionsDetails(v **types.AwsEc2LaunchTemplateDataHibernationOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataHibernationOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataHibernationOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Configured":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Configured = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataIamInstanceProfileDetails(v **types.AwsEc2LaunchTemplateDataIamInstanceProfileDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataIamInstanceProfileDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataIamInstanceProfileDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(v **types.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "MarketType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MarketType = ptr.String(jtv)
			}

		case "SpotOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails(&sv.SpotOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails(v **types.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BlockDurationMinutes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BlockDurationMinutes = ptr.Int32(int32(i64))
			}

		case "InstanceInterruptionBehavior":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceInterruptionBehavior = ptr.String(jtv)
			}

		case "MaxPrice":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MaxPrice = ptr.String(jtv)
			}

		case "SpotInstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SpotInstanceType = ptr.String(jtv)
			}

		case "ValidUntil":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValidUntil = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Max = ptr.Int32(int32(i64))
			}

		case "Min":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Min = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Max = ptr.Int32(int32(i64))
			}

		case "Min":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Min = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Max = ptr.Int32(int32(i64))
			}

		case "Min":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Min = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AcceleratorCount":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails(&sv.AcceleratorCount, value); err != nil {
				return err
			}

		case "AcceleratorManufacturers":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AcceleratorManufacturers, value); err != nil {
				return err
			}

		case "AcceleratorNames":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AcceleratorNames, value); err != nil {
				return err
			}

		case "AcceleratorTotalMemoryMiB":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails(&sv.AcceleratorTotalMemoryMiB, value); err != nil {
				return err
			}

		case "AcceleratorTypes":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AcceleratorTypes, value); err != nil {
				return err
			}

		case "BareMetal":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BareMetal = ptr.String(jtv)
			}

		case "BaselineEbsBandwidthMbps":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails(&sv.BaselineEbsBandwidthMbps, value); err != nil {
				return err
			}

		case "BurstablePerformance":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BurstablePerformance = ptr.String(jtv)
			}

		case "CpuManufacturers":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.CpuManufacturers, value); err != nil {
				return err
			}

		case "ExcludedInstanceTypes":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.ExcludedInstanceTypes, value); err != nil {
				return err
			}

		case "InstanceGenerations":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.InstanceGenerations, value); err != nil {
				return err
			}

		case "LocalStorage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LocalStorage = ptr.String(jtv)
			}

		case "LocalStorageTypes":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.LocalStorageTypes, value); err != nil {
				return err
			}

		case "MemoryGiBPerVCpu":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails(&sv.MemoryGiBPerVCpu, value); err != nil {
				return err
			}

		case "MemoryMiB":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails(&sv.MemoryMiB, value); err != nil {
				return err
			}

		case "NetworkInterfaceCount":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails(&sv.NetworkInterfaceCount, value); err != nil {
				return err
			}

		case "OnDemandMaxPricePercentageOverLowestPrice":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OnDemandMaxPricePercentageOverLowestPrice = ptr.Int32(int32(i64))
			}

		case "RequireHibernateSupport":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RequireHibernateSupport = ptr.Bool(jtv)
			}

		case "SpotMaxPricePercentageOverLowestPrice":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SpotMaxPricePercentageOverLowestPrice = ptr.Int32(int32(i64))
			}

		case "TotalLocalStorageGB":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails(&sv.TotalLocalStorageGB, value); err != nil {
				return err
			}

		case "VCpuCount":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails(&sv.VCpuCount, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Max = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Max = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "Min":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Min = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Min = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Max = ptr.Int32(int32(i64))
			}

		case "Min":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Min = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Max = ptr.Int32(int32(i64))
			}

		case "Min":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Min = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Max = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Max = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "Min":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Min = ptr.Float64(f64)

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Min = ptr.Float64(f64)

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails(v **types.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Max":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Max = ptr.Int32(int32(i64))
			}

		case "Min":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Min = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataLicenseSetDetails(v **types.AwsEc2LaunchTemplateDataLicenseSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataLicenseSetDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataLicenseSetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LicenseConfigurationArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LicenseConfigurationArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataLicenseSetList(v *[]types.AwsEc2LaunchTemplateDataLicenseSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataLicenseSetDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataLicenseSetDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataLicenseSetDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataLicenseSetDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataMaintenanceOptionsDetails(v **types.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataMaintenanceOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutoRecovery":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AutoRecovery = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataMetadataOptionsDetails(v **types.AwsEc2LaunchTemplateDataMetadataOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataMetadataOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataMetadataOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HttpEndpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpEndpoint = ptr.String(jtv)
			}

		case "HttpProtocolIpv6":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpProtocolIpv6 = ptr.String(jtv)
			}

		case "HttpPutResponseHopLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HttpPutResponseHopLimit = ptr.Int32(int32(i64))
			}

		case "HttpTokens":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpTokens = ptr.String(jtv)
			}

		case "InstanceMetadataTags":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceMetadataTags = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataMonitoringDetails(v **types.AwsEc2LaunchTemplateDataMonitoringDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataMonitoringDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataMonitoringDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(v **types.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociateCarrierIpAddress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AssociateCarrierIpAddress = ptr.Bool(jtv)
			}

		case "AssociatePublicIpAddress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AssociatePublicIpAddress = ptr.Bool(jtv)
			}

		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = ptr.Bool(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "DeviceIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DeviceIndex = ptr.Int32(int32(i64))
			}

		case "Groups":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Groups, value); err != nil {
				return err
			}

		case "InterfaceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InterfaceType = ptr.String(jtv)
			}

		case "Ipv4PrefixCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Ipv4PrefixCount = ptr.Int32(int32(i64))
			}

		case "Ipv4Prefixes":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesList(&sv.Ipv4Prefixes, value); err != nil {
				return err
			}

		case "Ipv6AddressCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Ipv6AddressCount = ptr.Int32(int32(i64))
			}

		case "Ipv6Addresses":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesList(&sv.Ipv6Addresses, value); err != nil {
				return err
			}

		case "Ipv6PrefixCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Ipv6PrefixCount = ptr.Int32(int32(i64))
			}

		case "Ipv6Prefixes":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesList(&sv.Ipv6Prefixes, value); err != nil {
				return err
			}

		case "NetworkCardIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NetworkCardIndex = ptr.Int32(int32(i64))
			}

		case "NetworkInterfaceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceId = ptr.String(jtv)
			}

		case "PrivateIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateIpAddress = ptr.String(jtv)
			}

		case "PrivateIpAddresses":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesList(&sv.PrivateIpAddresses, value); err != nil {
				return err
			}

		case "SecondaryPrivateIpAddressCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SecondaryPrivateIpAddressCount = ptr.Int32(int32(i64))
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails(v **types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Ipv4Prefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Ipv4Prefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesList(v *[]types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails(v **types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Ipv6Address":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Ipv6Address = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesList(v *[]types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails(v **types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Ipv6Prefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Ipv6Prefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesList(v *[]types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetList(v *[]types.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails(v **types.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Primary":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Primary = ptr.Bool(jtv)
			}

		case "PrivateIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateIpAddress = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesList(v *[]types.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
	if *v == nil {
		cv = []types.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataPlacementDetails(v **types.AwsEc2LaunchTemplateDataPlacementDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataPlacementDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataPlacementDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Affinity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Affinity = ptr.String(jtv)
			}

		case "AvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZone = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "HostId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostId = ptr.String(jtv)
			}

		case "HostResourceGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostResourceGroupArn = ptr.String(jtv)
			}

		case "PartitionNumber":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PartitionNumber = ptr.Int32(int32(i64))
			}

		case "SpreadDomain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SpreadDomain = ptr.String(jtv)
			}

		case "Tenancy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Tenancy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails(v **types.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EnableResourceNameDnsAAAARecord":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableResourceNameDnsAAAARecord = ptr.Bool(jtv)
			}

		case "EnableResourceNameDnsARecord":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableResourceNameDnsARecord = ptr.Bool(jtv)
			}

		case "HostnameType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostnameType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDetails(v **types.AwsEc2LaunchTemplateDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2LaunchTemplateDetails
	if *v == nil {
		sv = &types.AwsEc2LaunchTemplateDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DefaultVersionNumber":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DefaultVersionNumber = ptr.Int64(i64)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "LatestVersionNumber":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.LatestVersionNumber = ptr.Int64(i64)
			}

		case "LaunchTemplateData":
			if err := awsRestjson1_deserializeDocumentAwsEc2LaunchTemplateDataDetails(&sv.LaunchTemplateData, value); err != nil {
				return err
			}

		case "LaunchTemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchTemplateName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociation(v **types.AwsEc2NetworkAclAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkAclAssociation
	if *v == nil {
		sv = &types.AwsEc2NetworkAclAssociation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NetworkAclAssociationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkAclAssociationId = ptr.String(jtv)
			}

		case "NetworkAclId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkAclId = ptr.String(jtv)
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociationList(v *[]types.AwsEc2NetworkAclAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkAclAssociation
	if *v == nil {
		cv = []types.AwsEc2NetworkAclAssociation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkAclAssociation
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclDetails(v **types.AwsEc2NetworkAclDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkAclDetails
	if *v == nil {
		sv = &types.AwsEc2NetworkAclDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Associations":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociationList(&sv.Associations, value); err != nil {
				return err
			}

		case "Entries":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntryList(&sv.Entries, value); err != nil {
				return err
			}

		case "IsDefault":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsDefault = ptr.Bool(jtv)
			}

		case "NetworkAclId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkAclId = ptr.String(jtv)
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntry(v **types.AwsEc2NetworkAclEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkAclEntry
	if *v == nil {
		sv = &types.AwsEc2NetworkAclEntry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlock = ptr.String(jtv)
			}

		case "Egress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Egress = ptr.Bool(jtv)
			}

		case "IcmpTypeCode":
			if err := awsRestjson1_deserializeDocumentIcmpTypeCode(&sv.IcmpTypeCode, value); err != nil {
				return err
			}

		case "Ipv6CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Ipv6CidrBlock = ptr.String(jtv)
			}

		case "PortRange":
			if err := awsRestjson1_deserializeDocumentPortRangeFromTo(&sv.PortRange, value); err != nil {
				return err
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "RuleAction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleAction = ptr.String(jtv)
			}

		case "RuleNumber":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RuleNumber = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntryList(v *[]types.AwsEc2NetworkAclEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkAclEntry
	if *v == nil {
		cv = []types.AwsEc2NetworkAclEntry{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkAclEntry
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntry(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceAttachment(v **types.AwsEc2NetworkInterfaceAttachment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceAttachment
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceAttachment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttachmentId = ptr.String(jtv)
			}

		case "AttachTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttachTime = ptr.String(jtv)
			}

		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = ptr.Bool(jtv)
			}

		case "DeviceIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DeviceIndex = ptr.Int32(int32(i64))
			}

		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		case "InstanceOwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceOwnerId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceDetails(v **types.AwsEc2NetworkInterfaceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceDetails
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attachment":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceAttachment(&sv.Attachment, value); err != nil {
				return err
			}

		case "IpV6Addresses":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressList(&sv.IpV6Addresses, value); err != nil {
				return err
			}

		case "NetworkInterfaceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceId = ptr.String(jtv)
			}

		case "PrivateIpAddresses":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressList(&sv.PrivateIpAddresses, value); err != nil {
				return err
			}

		case "PublicDnsName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicDnsName = ptr.String(jtv)
			}

		case "PublicIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicIp = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroupList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "SourceDestCheck":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.SourceDestCheck = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressDetail(v **types.AwsEc2NetworkInterfaceIpV6AddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceIpV6AddressDetail
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceIpV6AddressDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IpV6Address":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpV6Address = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressList(v *[]types.AwsEc2NetworkInterfaceIpV6AddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkInterfaceIpV6AddressDetail
	if *v == nil {
		cv = []types.AwsEc2NetworkInterfaceIpV6AddressDetail{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkInterfaceIpV6AddressDetail
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressDetail(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressDetail(v **types.AwsEc2NetworkInterfacePrivateIpAddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfacePrivateIpAddressDetail
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfacePrivateIpAddressDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PrivateDnsName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateDnsName = ptr.String(jtv)
			}

		case "PrivateIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateIpAddress = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressList(v *[]types.AwsEc2NetworkInterfacePrivateIpAddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkInterfacePrivateIpAddressDetail
	if *v == nil {
		cv = []types.AwsEc2NetworkInterfacePrivateIpAddressDetail{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkInterfacePrivateIpAddressDetail
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressDetail(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroup(v **types.AwsEc2NetworkInterfaceSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceSecurityGroup
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceSecurityGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroupList(v *[]types.AwsEc2NetworkInterfaceSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkInterfaceSecurityGroup
	if *v == nil {
		cv = []types.AwsEc2NetworkInterfaceSecurityGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkInterfaceSecurityGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2RouteTableDetails(v **types.AwsEc2RouteTableDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2RouteTableDetails
	if *v == nil {
		sv = &types.AwsEc2RouteTableDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociationSet":
			if err := awsRestjson1_deserializeDocumentAssociationSetList(&sv.AssociationSet, value); err != nil {
				return err
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "PropagatingVgwSet":
			if err := awsRestjson1_deserializeDocumentPropagatingVgwSetList(&sv.PropagatingVgwSet, value); err != nil {
				return err
			}

		case "RouteSet":
			if err := awsRestjson1_deserializeDocumentRouteSetList(&sv.RouteSet, value); err != nil {
				return err
			}

		case "RouteTableId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RouteTableId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupDetails(v **types.AwsEc2SecurityGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupDetails
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "IpPermissions":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermissionList(&sv.IpPermissions, value); err != nil {
				return err
			}

		case "IpPermissionsEgress":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermissionList(&sv.IpPermissionsEgress, value); err != nil {
				return err
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermission(v **types.AwsEc2SecurityGroupIpPermission, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupIpPermission
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupIpPermission{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FromPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FromPort = ptr.Int32(int32(i64))
			}

		case "IpProtocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpProtocol = ptr.String(jtv)
			}

		case "IpRanges":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRangeList(&sv.IpRanges, value); err != nil {
				return err
			}

		case "Ipv6Ranges":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6RangeList(&sv.Ipv6Ranges, value); err != nil {
				return err
			}

		case "PrefixListIds":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListIdList(&sv.PrefixListIds, value); err != nil {
				return err
			}

		case "ToPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ToPort = ptr.Int32(int32(i64))
			}

		case "UserIdGroupPairs":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPairList(&sv.UserIdGroupPairs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermissionList(v *[]types.AwsEc2SecurityGroupIpPermission, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupIpPermission
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupIpPermission{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupIpPermission
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermission(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRange(v **types.AwsEc2SecurityGroupIpRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupIpRange
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupIpRange{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrIp = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRangeList(v *[]types.AwsEc2SecurityGroupIpRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupIpRange
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupIpRange{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupIpRange
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRange(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6Range(v **types.AwsEc2SecurityGroupIpv6Range, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupIpv6Range
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupIpv6Range{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrIpv6":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrIpv6 = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6RangeList(v *[]types.AwsEc2SecurityGroupIpv6Range, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupIpv6Range
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupIpv6Range{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupIpv6Range
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6Range(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListId(v **types.AwsEc2SecurityGroupPrefixListId, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupPrefixListId
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupPrefixListId{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PrefixListId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrefixListId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListIdList(v *[]types.AwsEc2SecurityGroupPrefixListId, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupPrefixListId
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupPrefixListId{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupPrefixListId
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListId(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPair(v **types.AwsEc2SecurityGroupUserIdGroupPair, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupUserIdGroupPair
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupUserIdGroupPair{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "PeeringStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PeeringStatus = ptr.String(jtv)
			}

		case "UserId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		case "VpcPeeringConnectionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcPeeringConnectionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPairList(v *[]types.AwsEc2SecurityGroupUserIdGroupPair, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupUserIdGroupPair
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupUserIdGroupPair{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupUserIdGroupPair
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPair(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SubnetDetails(v **types.AwsEc2SubnetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SubnetDetails
	if *v == nil {
		sv = &types.AwsEc2SubnetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssignIpv6AddressOnCreation":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AssignIpv6AddressOnCreation = ptr.Bool(jtv)
			}

		case "AvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZone = ptr.String(jtv)
			}

		case "AvailabilityZoneId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZoneId = ptr.String(jtv)
			}

		case "AvailableIpAddressCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AvailableIpAddressCount = ptr.Int32(int32(i64))
			}

		case "CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlock = ptr.String(jtv)
			}

		case "DefaultForAz":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DefaultForAz = ptr.Bool(jtv)
			}

		case "Ipv6CidrBlockAssociationSet":
			if err := awsRestjson1_deserializeDocumentIpv6CidrBlockAssociationList(&sv.Ipv6CidrBlockAssociationSet, value); err != nil {
				return err
			}

		case "MapPublicIpOnLaunch":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MapPublicIpOnLaunch = ptr.Bool(jtv)
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		case "SubnetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetArn = ptr.String(jtv)
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2TransitGatewayDetails(v **types.AwsEc2TransitGatewayDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2TransitGatewayDetails
	if *v == nil {
		sv = &types.AwsEc2TransitGatewayDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AmazonSideAsn":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AmazonSideAsn = ptr.Int32(int32(i64))
			}

		case "AssociationDefaultRouteTableId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssociationDefaultRouteTableId = ptr.String(jtv)
			}

		case "AutoAcceptSharedAttachments":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AutoAcceptSharedAttachments = ptr.String(jtv)
			}

		case "DefaultRouteTableAssociation":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DefaultRouteTableAssociation = ptr.String(jtv)
			}

		case "DefaultRouteTablePropagation":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DefaultRouteTablePropagation = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "DnsSupport":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DnsSupport = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "MulticastSupport":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MulticastSupport = ptr.String(jtv)
			}

		case "PropagationDefaultRouteTableId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PropagationDefaultRouteTableId = ptr.String(jtv)
			}

		case "TransitGatewayCidrBlocks":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.TransitGatewayCidrBlocks, value); err != nil {
				return err
			}

		case "VpnEcmpSupport":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpnEcmpSupport = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VolumeAttachment(v **types.AwsEc2VolumeAttachment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VolumeAttachment
	if *v == nil {
		sv = &types.AwsEc2VolumeAttachment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttachTime = ptr.String(jtv)
			}

		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = ptr.Bool(jtv)
			}

		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VolumeAttachmentList(v *[]types.AwsEc2VolumeAttachment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VolumeAttachment
	if *v == nil {
		cv = []types.AwsEc2VolumeAttachment{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VolumeAttachment
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VolumeAttachment(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VolumeDetails(v **types.AwsEc2VolumeDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VolumeDetails
	if *v == nil {
		sv = &types.AwsEc2VolumeDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attachments":
			if err := awsRestjson1_deserializeDocumentAwsEc2VolumeAttachmentList(&sv.Attachments, value); err != nil {
				return err
			}

		case "CreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateTime = ptr.String(jtv)
			}

		case "DeviceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceName = ptr.String(jtv)
			}

		case "Encrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Encrypted = ptr.Bool(jtv)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "Size":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Size = ptr.Int32(int32(i64))
			}

		case "SnapshotId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "VolumeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VolumeId = ptr.String(jtv)
			}

		case "VolumeScanStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VolumeScanStatus = ptr.String(jtv)
			}

		case "VolumeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VolumeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcDetails(v **types.AwsEc2VpcDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpcDetails
	if *v == nil {
		sv = &types.AwsEc2VpcDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrBlockAssociationSet":
			if err := awsRestjson1_deserializeDocumentCidrBlockAssociationList(&sv.CidrBlockAssociationSet, value); err != nil {
				return err
			}

		case "DhcpOptionsId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DhcpOptionsId = ptr.String(jtv)
			}

		case "Ipv6CidrBlockAssociationSet":
			if err := awsRestjson1_deserializeDocumentIpv6CidrBlockAssociationList(&sv.Ipv6CidrBlockAssociationSet, value); err != nil {
				return err
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcEndpointServiceDetails(v **types.AwsEc2VpcEndpointServiceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpcEndpointServiceDetails
	if *v == nil {
		sv = &types.AwsEc2VpcEndpointServiceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AcceptanceRequired":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AcceptanceRequired = ptr.Bool(jtv)
			}

		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "BaseEndpointDnsNames":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.BaseEndpointDnsNames, value); err != nil {
				return err
			}

		case "GatewayLoadBalancerArns":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.GatewayLoadBalancerArns, value); err != nil {
				return err
			}

		case "ManagesVpcEndpoints":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ManagesVpcEndpoints = ptr.Bool(jtv)
			}

		case "NetworkLoadBalancerArns":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.NetworkLoadBalancerArns, value); err != nil {
				return err
			}

		case "PrivateDnsName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateDnsName = ptr.String(jtv)
			}

		case "ServiceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceId = ptr.String(jtv)
			}

		case "ServiceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceName = ptr.String(jtv)
			}

		case "ServiceState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceState = ptr.String(jtv)
			}

		case "ServiceType":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpcEndpointServiceServiceTypeList(&sv.ServiceType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcEndpointServiceServiceTypeDetails(v **types.AwsEc2VpcEndpointServiceServiceTypeDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpcEndpointServiceServiceTypeDetails
	if *v == nil {
		sv = &types.AwsEc2VpcEndpointServiceServiceTypeDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ServiceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcEndpointServiceServiceTypeList(v *[]types.AwsEc2VpcEndpointServiceServiceTypeDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VpcEndpointServiceServiceTypeDetails
	if *v == nil {
		cv = []types.AwsEc2VpcEndpointServiceServiceTypeDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VpcEndpointServiceServiceTypeDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VpcEndpointServiceServiceTypeDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcPeeringConnectionDetails(v **types.AwsEc2VpcPeeringConnectionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpcPeeringConnectionDetails
	if *v == nil {
		sv = &types.AwsEc2VpcPeeringConnectionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccepterVpcInfo":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpcPeeringConnectionVpcInfoDetails(&sv.AccepterVpcInfo, value); err != nil {
				return err
			}

		case "ExpirationTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExpirationTime = ptr.String(jtv)
			}

		case "RequesterVpcInfo":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpcPeeringConnectionVpcInfoDetails(&sv.RequesterVpcInfo, value); err != nil {
				return err
			}

		case "Status":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpcPeeringConnectionStatusDetails(&sv.Status, value); err != nil {
				return err
			}

		case "VpcPeeringConnectionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcPeeringConnectionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcPeeringConnectionStatusDetails(v **types.AwsEc2VpcPeeringConnectionStatusDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpcPeeringConnectionStatusDetails
	if *v == nil {
		sv = &types.AwsEc2VpcPeeringConnectionStatusDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcPeeringConnectionVpcInfoDetails(v **types.AwsEc2VpcPeeringConnectionVpcInfoDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpcPeeringConnectionVpcInfoDetails
	if *v == nil {
		sv = &types.AwsEc2VpcPeeringConnectionVpcInfoDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlock = ptr.String(jtv)
			}

		case "CidrBlockSet":
			if err := awsRestjson1_deserializeDocumentVpcInfoCidrBlockSetList(&sv.CidrBlockSet, value); err != nil {
				return err
			}

		case "Ipv6CidrBlockSet":
			if err := awsRestjson1_deserializeDocumentVpcInfoIpv6CidrBlockSetList(&sv.Ipv6CidrBlockSet, value); err != nil {
				return err
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "PeeringOptions":
			if err := awsRestjson1_deserializeDocumentVpcInfoPeeringOptionsDetails(&sv.PeeringOptions, value); err != nil {
				return err
			}

		case "Region":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Region = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionDetails(v **types.AwsEc2VpnConnectionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Category":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Category = ptr.String(jtv)
			}

		case "CustomerGatewayConfiguration":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CustomerGatewayConfiguration = ptr.String(jtv)
			}

		case "CustomerGatewayId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CustomerGatewayId = ptr.String(jtv)
			}

		case "Options":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsDetails(&sv.Options, value); err != nil {
				return err
			}

		case "Routes":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesList(&sv.Routes, value); err != nil {
				return err
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		case "TransitGatewayId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TransitGatewayId = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "VgwTelemetry":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryList(&sv.VgwTelemetry, value); err != nil {
				return err
			}

		case "VpnConnectionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpnConnectionId = ptr.String(jtv)
			}

		case "VpnGatewayId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpnGatewayId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsDetails(v **types.AwsEc2VpnConnectionOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StaticRoutesOnly":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.StaticRoutesOnly = ptr.Bool(jtv)
			}

		case "TunnelOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsList(&sv.TunnelOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsDetails(v **types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DpdTimeoutSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DpdTimeoutSeconds = ptr.Int32(int32(i64))
			}

		case "IkeVersions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.IkeVersions, value); err != nil {
				return err
			}

		case "OutsideIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OutsideIpAddress = ptr.String(jtv)
			}

		case "Phase1DhGroupNumbers":
			if err := awsRestjson1_deserializeDocumentIntegerList(&sv.Phase1DhGroupNumbers, value); err != nil {
				return err
			}

		case "Phase1EncryptionAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase1EncryptionAlgorithms, value); err != nil {
				return err
			}

		case "Phase1IntegrityAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase1IntegrityAlgorithms, value); err != nil {
				return err
			}

		case "Phase1LifetimeSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Phase1LifetimeSeconds = ptr.Int32(int32(i64))
			}

		case "Phase2DhGroupNumbers":
			if err := awsRestjson1_deserializeDocumentIntegerList(&sv.Phase2DhGroupNumbers, value); err != nil {
				return err
			}

		case "Phase2EncryptionAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase2EncryptionAlgorithms, value); err != nil {
				return err
			}

		case "Phase2IntegrityAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase2IntegrityAlgorithms, value); err != nil {
				return err
			}

		case "Phase2LifetimeSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Phase2LifetimeSeconds = ptr.Int32(int32(i64))
			}

		case "PreSharedKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreSharedKey = ptr.String(jtv)
			}

		case "RekeyFuzzPercentage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RekeyFuzzPercentage = ptr.Int32(int32(i64))
			}

		case "RekeyMarginTimeSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RekeyMarginTimeSeconds = ptr.Int32(int32(i64))
			}

		case "ReplayWindowSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ReplayWindowSize = ptr.Int32(int32(i64))
			}

		case "TunnelInsideCidr":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TunnelInsideCidr = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsList(v *[]types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
	if *v == nil {
		cv = []types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesDetails(v **types.AwsEc2VpnConnectionRoutesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionRoutesDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionRoutesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationCidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationCidrBlock = ptr.String(jtv)
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesList(v *[]types.AwsEc2VpnConnectionRoutesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VpnConnectionRoutesDetails
	if *v == nil {
		cv = []types.AwsEc2VpnConnectionRoutesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VpnConnectionRoutesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryDetails(v **types.AwsEc2VpnConnectionVgwTelemetryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionVgwTelemetryDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionVgwTelemetryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AcceptedRouteCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AcceptedRouteCount = ptr.Int32(int32(i64))
			}

		case "CertificateArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateArn = ptr.String(jtv)
			}

		case "LastStatusChange":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastStatusChange = ptr.String(jtv)
			}

		case "OutsideIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OutsideIpAddress = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StatusMessage = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryList(v *[]types.AwsEc2VpnConnectionVgwTelemetryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VpnConnectionVgwTelemetryDetails
	if *v == nil {
		cv = []types.AwsEc2VpnConnectionVgwTelemetryDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VpnConnectionVgwTelemetryDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcrContainerImageDetails(v **types.AwsEcrContainerImageDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcrContainerImageDetails
	if *v == nil {
		sv = &types.AwsEcrContainerImageDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Architecture":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Architecture = ptr.String(jtv)
			}

		case "ImageDigest":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageDigest = ptr.String(jtv)
			}

		case "ImagePublishedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImagePublishedAt = ptr.String(jtv)
			}

		case "ImageTags":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.ImageTags, value); err != nil {
				return err
			}

		case "RegistryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegistryId = ptr.String(jtv)
			}

		case "RepositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcrRepositoryDetails(v **types.AwsEcrRepositoryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcrRepositoryDetails
	if *v == nil {
		sv = &types.AwsEcrRepositoryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "ImageScanningConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcrRepositoryImageScanningConfigurationDetails(&sv.ImageScanningConfiguration, value); err != nil {
				return err
			}

		case "ImageTagMutability":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageTagMutability = ptr.String(jtv)
			}

		case "LifecyclePolicy":
			if err := awsRestjson1_deserializeDocumentAwsEcrRepositoryLifecyclePolicyDetails(&sv.LifecyclePolicy, value); err != nil {
				return err
			}

		case "RepositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		case "RepositoryPolicyText":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RepositoryPolicyText = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcrRepositoryImageScanningConfigurationDetails(v **types.AwsEcrRepositoryImageScanningConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcrRepositoryImageScanningConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcrRepositoryImageScanningConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ScanOnPush":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ScanOnPush = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcrRepositoryLifecyclePolicyDetails(v **types.AwsEcrRepositoryLifecyclePolicyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcrRepositoryLifecyclePolicyDetails
	if *v == nil {
		sv = &types.AwsEcrRepositoryLifecyclePolicyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LifecyclePolicyText":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LifecyclePolicyText = ptr.String(jtv)
			}

		case "RegistryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegistryId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsDetails(v **types.AwsEcsClusterClusterSettingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterClusterSettingsDetails
	if *v == nil {
		sv = &types.AwsEcsClusterClusterSettingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsList(v *[]types.AwsEcsClusterClusterSettingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsClusterClusterSettingsDetails
	if *v == nil {
		cv = []types.AwsEcsClusterClusterSettingsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsClusterClusterSettingsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationDetails(v **types.AwsEcsClusterConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsClusterConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ExecuteCommandConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationDetails(&sv.ExecuteCommandConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationDetails(v **types.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "LogConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(&sv.LogConfiguration, value); err != nil {
				return err
			}

		case "Logging":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Logging = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(v **types.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchEncryptionEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CloudWatchEncryptionEnabled = ptr.Bool(jtv)
			}

		case "CloudWatchLogGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogGroupName = ptr.String(jtv)
			}

		case "S3BucketName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketName = ptr.String(jtv)
			}

		case "S3EncryptionEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.S3EncryptionEnabled = ptr.Bool(jtv)
			}

		case "S3KeyPrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3KeyPrefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyDetails(v **types.AwsEcsClusterDefaultCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterDefaultCapacityProviderStrategyDetails
	if *v == nil {
		sv = &types.AwsEcsClusterDefaultCapacityProviderStrategyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Base":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Base = ptr.Int32(int32(i64))
			}

		case "CapacityProvider":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CapacityProvider = ptr.String(jtv)
			}

		case "Weight":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Weight = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyList(v *[]types.AwsEcsClusterDefaultCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsClusterDefaultCapacityProviderStrategyDetails
	if *v == nil {
		cv = []types.AwsEcsClusterDefaultCapacityProviderStrategyDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsClusterDefaultCapacityProviderStrategyDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterDetails(v **types.AwsEcsClusterDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterDetails
	if *v == nil {
		sv = &types.AwsEcsClusterDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActiveServicesCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ActiveServicesCount = ptr.Int32(int32(i64))
			}

		case "CapacityProviders":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.CapacityProviders, value); err != nil {
				return err
			}

		case "ClusterArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterArn = ptr.String(jtv)
			}

		case "ClusterName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterName = ptr.String(jtv)
			}

		case "ClusterSettings":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsList(&sv.ClusterSettings, value); err != nil {
				return err
			}

		case "Configuration":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationDetails(&sv.Configuration, value); err != nil {
				return err
			}

		case "DefaultCapacityProviderStrategy":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyList(&sv.DefaultCapacityProviderStrategy, value); err != nil {
				return err
			}

		case "RegisteredContainerInstancesCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RegisteredContainerInstancesCount = ptr.Int32(int32(i64))
			}

		case "RunningTasksCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RunningTasksCount = ptr.Int32(int32(i64))
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsContainerDetails(v **types.AwsEcsContainerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsContainerDetails
	if *v == nil {
		sv = &types.AwsEcsContainerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Image":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Image = ptr.String(jtv)
			}

		case "MountPoints":
			if err := awsRestjson1_deserializeDocumentAwsMountPointList(&sv.MountPoints, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Privileged":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Privileged = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsContainerDetailsList(v *[]types.AwsEcsContainerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsContainerDetails
	if *v == nil {
		cv = []types.AwsEcsContainerDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsContainerDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsContainerDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyDetails(v **types.AwsEcsServiceCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceCapacityProviderStrategyDetails
	if *v == nil {
		sv = &types.AwsEcsServiceCapacityProviderStrategyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Base":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Base = ptr.Int32(int32(i64))
			}

		case "CapacityProvider":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CapacityProvider = ptr.String(jtv)
			}

		case "Weight":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Weight = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyList(v *[]types.AwsEcsServiceCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServiceCapacityProviderStrategyDetails
	if *v == nil {
		cv = []types.AwsEcsServiceCapacityProviderStrategyDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServiceCapacityProviderStrategyDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(v **types.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enable = ptr.Bool(jtv)
			}

		case "Rollback":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Rollback = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDetails(v **types.AwsEcsServiceDeploymentConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDeploymentConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDeploymentConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeploymentCircuitBreaker":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(&sv.DeploymentCircuitBreaker, value); err != nil {
				return err
			}

		case "MaximumPercent":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaximumPercent = ptr.Int32(int32(i64))
			}

		case "MinimumHealthyPercent":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MinimumHealthyPercent = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentControllerDetails(v **types.AwsEcsServiceDeploymentControllerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDeploymentControllerDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDeploymentControllerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDetails(v **types.AwsEcsServiceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CapacityProviderStrategy":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyList(&sv.CapacityProviderStrategy, value); err != nil {
				return err
			}

		case "Cluster":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Cluster = ptr.String(jtv)
			}

		case "DeploymentConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDetails(&sv.DeploymentConfiguration, value); err != nil {
				return err
			}

		case "DeploymentController":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentControllerDetails(&sv.DeploymentController, value); err != nil {
				return err
			}

		case "DesiredCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DesiredCount = ptr.Int32(int32(i64))
			}

		case "EnableEcsManagedTags":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableEcsManagedTags = ptr.Bool(jtv)
			}

		case "EnableExecuteCommand":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableExecuteCommand = ptr.Bool(jtv)
			}

		case "HealthCheckGracePeriodSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HealthCheckGracePeriodSeconds = ptr.Int32(int32(i64))
			}

		case "LaunchType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchType = ptr.String(jtv)
			}

		case "LoadBalancers":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersList(&sv.LoadBalancers, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "NetworkConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationDetails(&sv.NetworkConfiguration, value); err != nil {
				return err
			}

		case "PlacementConstraints":
			if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsList(&sv.PlacementConstraints, value); err != nil {
				return err
			}

		case "PlacementStrategies":
			if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesList(&sv.PlacementStrategies, value); err != nil {
				return err
			}

		case "PlatformVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PlatformVersion = ptr.String(jtv)
			}

		case "PropagateTags":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PropagateTags = ptr.String(jtv)
			}

		case "Role":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Role = ptr.String(jtv)
			}

		case "SchedulingStrategy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SchedulingStrategy = ptr.String(jtv)
			}

		case "ServiceArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceArn = ptr.String(jtv)
			}

		case "ServiceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceName = ptr.String(jtv)
			}

		case "ServiceRegistries":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesList(&sv.ServiceRegistries, value); err != nil {
				return err
			}

		case "TaskDefinition":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TaskDefinition = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersDetails(v **types.AwsEcsServiceLoadBalancersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceLoadBalancersDetails
	if *v == nil {
		sv = &types.AwsEcsServiceLoadBalancersDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		case "ContainerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContainerPort = ptr.Int32(int32(i64))
			}

		case "LoadBalancerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoadBalancerName = ptr.String(jtv)
			}

		case "TargetGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TargetGroupArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersList(v *[]types.AwsEcsServiceLoadBalancersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServiceLoadBalancersDetails
	if *v == nil {
		cv = []types.AwsEcsServiceLoadBalancersDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServiceLoadBalancersDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(v **types.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssignPublicIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssignPublicIp = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "Subnets":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Subnets, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationDetails(v **types.AwsEcsServiceNetworkConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceNetworkConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsServiceNetworkConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AwsVpcConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(&sv.AwsVpcConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsDetails(v **types.AwsEcsServicePlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServicePlacementConstraintsDetails
	if *v == nil {
		sv = &types.AwsEcsServicePlacementConstraintsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Expression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Expression = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsList(v *[]types.AwsEcsServicePlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServicePlacementConstraintsDetails
	if *v == nil {
		cv = []types.AwsEcsServicePlacementConstraintsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServicePlacementConstraintsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesDetails(v **types.AwsEcsServicePlacementStrategiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServicePlacementStrategiesDetails
	if *v == nil {
		sv = &types.AwsEcsServicePlacementStrategiesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Field":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Field = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesList(v *[]types.AwsEcsServicePlacementStrategiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServicePlacementStrategiesDetails
	if *v == nil {
		cv = []types.AwsEcsServicePlacementStrategiesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServicePlacementStrategiesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesDetails(v **types.AwsEcsServiceServiceRegistriesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceServiceRegistriesDetails
	if *v == nil {
		sv = &types.AwsEcsServiceServiceRegistriesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		case "ContainerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContainerPort = ptr.Int32(int32(i64))
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case "RegistryArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegistryArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesList(v *[]types.AwsEcsServiceServiceRegistriesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServiceServiceRegistriesDetails
	if *v == nil {
		cv = []types.AwsEcsServiceServiceRegistriesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServiceServiceRegistriesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Condition":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Condition = ptr.String(jtv)
			}

		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Command":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Command, value); err != nil {
				return err
			}

		case "Cpu":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Cpu = ptr.Int32(int32(i64))
			}

		case "DependsOn":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnList(&sv.DependsOn, value); err != nil {
				return err
			}

		case "DisableNetworking":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DisableNetworking = ptr.Bool(jtv)
			}

		case "DnsSearchDomains":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.DnsSearchDomains, value); err != nil {
				return err
			}

		case "DnsServers":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.DnsServers, value); err != nil {
				return err
			}

		case "DockerLabels":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.DockerLabels, value); err != nil {
				return err
			}

		case "DockerSecurityOptions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.DockerSecurityOptions, value); err != nil {
				return err
			}

		case "EntryPoint":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.EntryPoint, value); err != nil {
				return err
			}

		case "Environment":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentList(&sv.Environment, value); err != nil {
				return err
			}

		case "EnvironmentFiles":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList(&sv.EnvironmentFiles, value); err != nil {
				return err
			}

		case "Essential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Essential = ptr.Bool(jtv)
			}

		case "ExtraHosts":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsList(&sv.ExtraHosts, value); err != nil {
				return err
			}

		case "FirelensConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(&sv.FirelensConfiguration, value); err != nil {
				return err
			}

		case "HealthCheck":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(&sv.HealthCheck, value); err != nil {
				return err
			}

		case "Hostname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Hostname = ptr.String(jtv)
			}

		case "Image":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Image = ptr.String(jtv)
			}

		case "Interactive":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Interactive = ptr.Bool(jtv)
			}

		case "Links":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Links, value); err != nil {
				return err
			}

		case "LinuxParameters":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(&sv.LinuxParameters, value); err != nil {
				return err
			}

		case "LogConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(&sv.LogConfiguration, value); err != nil {
				return err
			}

		case "Memory":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Memory = ptr.Int32(int32(i64))
			}

		case "MemoryReservation":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MemoryReservation = ptr.Int32(int32(i64))
			}

		case "MountPoints":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsList(&sv.MountPoints, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "PortMappings":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsList(&sv.PortMappings, value); err != nil {
				return err
			}

		case "Privileged":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Privileged = ptr.Bool(jtv)
			}

		case "PseudoTerminal":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PseudoTerminal = ptr.Bool(jtv)
			}

		case "ReadonlyRootFilesystem":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ReadonlyRootFilesystem = ptr.Bool(jtv)
			}

		case "RepositoryCredentials":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(&sv.RepositoryCredentials, value); err != nil {
				return err
			}

		case "ResourceRequirements":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList(&sv.ResourceRequirements, value); err != nil {
				return err
			}

		case "Secrets":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsList(&sv.Secrets, value); err != nil {
				return err
			}

		case "StartTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartTimeout = ptr.Int32(int32(i64))
			}

		case "StopTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StopTimeout = ptr.Int32(int32(i64))
			}

		case "SystemControls":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsList(&sv.SystemControls, value); err != nil {
				return err
			}

		case "Ulimits":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsList(&sv.Ulimits, value); err != nil {
				return err
			}

		case "User":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.User = ptr.String(jtv)
			}

		case "VolumesFrom":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromList(&sv.VolumesFrom, value); err != nil {
				return err
			}

		case "WorkingDirectory":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WorkingDirectory = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Hostname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Hostname = ptr.String(jtv)
			}

		case "IpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddress = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Options":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Options, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Command":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Command, value); err != nil {
				return err
			}

		case "Interval":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Interval = ptr.Int32(int32(i64))
			}

		case "Retries":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Retries = ptr.Int32(int32(i64))
			}

		case "StartPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartPeriod = ptr.Int32(int32(i64))
			}

		case "Timeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Timeout = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Add":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Add, value); err != nil {
				return err
			}

		case "Drop":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Drop, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Capabilities":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(&sv.Capabilities, value); err != nil {
				return err
			}

		case "Devices":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList(&sv.Devices, value); err != nil {
				return err
			}

		case "InitProcessEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.InitProcessEnabled = ptr.Bool(jtv)
			}

		case "MaxSwap":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxSwap = ptr.Int32(int32(i64))
			}

		case "SharedMemorySize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SharedMemorySize = ptr.Int32(int32(i64))
			}

		case "Swappiness":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Swappiness = ptr.Int32(int32(i64))
			}

		case "Tmpfs":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList(&sv.Tmpfs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerPath = ptr.String(jtv)
			}

		case "HostPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostPath = ptr.String(jtv)
			}

		case "Permissions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Permissions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerPath = ptr.String(jtv)
			}

		case "MountOptions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.MountOptions, value); err != nil {
				return err
			}

		case "Size":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Size = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LogDriver":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LogDriver = ptr.String(jtv)
			}

		case "Options":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Options, value); err != nil {
				return err
			}

		case "SecretOptions":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList(&sv.SecretOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ValueFrom":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValueFrom = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerPath = ptr.String(jtv)
			}

		case "ReadOnly":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ReadOnly = ptr.Bool(jtv)
			}

		case "SourceVolume":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceVolume = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContainerPort = ptr.Int32(int32(i64))
			}

		case "HostPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HostPort = ptr.Int32(int32(i64))
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CredentialsParameter":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CredentialsParameter = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ValueFrom":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValueFrom = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Namespace":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Namespace = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HardLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HardLimit = ptr.Int32(int32(i64))
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "SoftLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SoftLimit = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ReadOnly":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ReadOnly = ptr.Bool(jtv)
			}

		case "SourceContainer":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceContainer = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionDetails(v **types.AwsEcsTaskDefinitionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerDefinitions":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsList(&sv.ContainerDefinitions, value); err != nil {
				return err
			}

		case "Cpu":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Cpu = ptr.String(jtv)
			}

		case "ExecutionRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExecutionRoleArn = ptr.String(jtv)
			}

		case "Family":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Family = ptr.String(jtv)
			}

		case "InferenceAccelerators":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsList(&sv.InferenceAccelerators, value); err != nil {
				return err
			}

		case "IpcMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpcMode = ptr.String(jtv)
			}

		case "Memory":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Memory = ptr.String(jtv)
			}

		case "NetworkMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkMode = ptr.String(jtv)
			}

		case "PidMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PidMode = ptr.String(jtv)
			}

		case "PlacementConstraints":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsList(&sv.PlacementConstraints, value); err != nil {
				return err
			}

		case "ProxyConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationDetails(&sv.ProxyConfiguration, value); err != nil {
				return err
			}

		case "RequiresCompatibilities":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.RequiresCompatibilities, value); err != nil {
				return err
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "TaskRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TaskRoleArn = ptr.String(jtv)
			}

		case "Volumes":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesList(&sv.Volumes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsDetails(v **types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeviceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceName = ptr.String(jtv)
			}

		case "DeviceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsList(v *[]types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsDetails(v **types.AwsEcsTaskDefinitionPlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionPlacementConstraintsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionPlacementConstraintsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Expression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Expression = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsList(v *[]types.AwsEcsTaskDefinitionPlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionPlacementConstraintsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionPlacementConstraintsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionPlacementConstraintsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationDetails(v **types.AwsEcsTaskDefinitionProxyConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionProxyConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionProxyConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		case "ProxyConfigurationProperties":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList(&sv.ProxyConfigurationProperties, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(v **types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList(v *[]types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDetails(v **types.AwsEcsTaskDefinitionVolumesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DockerVolumeConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(&sv.DockerVolumeConfiguration, value); err != nil {
				return err
			}

		case "EfsVolumeConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(&sv.EfsVolumeConfiguration, value); err != nil {
				return err
			}

		case "Host":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesHostDetails(&sv.Host, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(v **types.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Autoprovision":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Autoprovision = ptr.Bool(jtv)
			}

		case "Driver":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Driver = ptr.String(jtv)
			}

		case "DriverOpts":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.DriverOpts, value); err != nil {
				return err
			}

		case "Labels":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Labels, value); err != nil {
				return err
			}

		case "Scope":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Scope = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(v **types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessPointId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessPointId = ptr.String(jtv)
			}

		case "Iam":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Iam = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(v **types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuthorizationConfig":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(&sv.AuthorizationConfig, value); err != nil {
				return err
			}

		case "FilesystemId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FilesystemId = ptr.String(jtv)
			}

		case "RootDirectory":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RootDirectory = ptr.String(jtv)
			}

		case "TransitEncryption":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TransitEncryption = ptr.String(jtv)
			}

		case "TransitEncryptionPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TransitEncryptionPort = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesHostDetails(v **types.AwsEcsTaskDefinitionVolumesHostDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesHostDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesHostDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SourcePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourcePath = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesList(v *[]types.AwsEcsTaskDefinitionVolumesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionVolumesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionVolumesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionVolumesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDetails(v **types.AwsEcsTaskDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ClusterArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterArn = ptr.String(jtv)
			}

		case "Containers":
			if err := awsRestjson1_deserializeDocumentAwsEcsContainerDetailsList(&sv.Containers, value); err != nil {
				return err
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedAt = ptr.String(jtv)
			}

		case "Group":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Group = ptr.String(jtv)
			}

		case "StartedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StartedAt = ptr.String(jtv)
			}

		case "StartedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StartedBy = ptr.String(jtv)
			}

		case "TaskDefinitionArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TaskDefinitionArn = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		case "Volumes":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskVolumeDetailsList(&sv.Volumes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskVolumeDetails(v **types.AwsEcsTaskVolumeDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskVolumeDetails
	if *v == nil {
		sv = &types.AwsEcsTaskVolumeDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Host":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskVolumeHostDetails(&sv.Host, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskVolumeDetailsList(v *[]types.AwsEcsTaskVolumeDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskVolumeDetails
	if *v == nil {
		cv = []types.AwsEcsTaskVolumeDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskVolumeDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskVolumeDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskVolumeHostDetails(v **types.AwsEcsTaskVolumeHostDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskVolumeHostDetails
	if *v == nil {
		sv = &types.AwsEcsTaskVolumeHostDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SourcePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourcePath = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEfsAccessPointDetails(v **types.AwsEfsAccessPointDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEfsAccessPointDetails
	if *v == nil {
		sv = &types.AwsEfsAccessPointDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessPointId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessPointId = ptr.String(jtv)
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "ClientToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientToken = ptr.String(jtv)
			}

		case "FileSystemId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FileSystemId = ptr.String(jtv)
			}

		case "PosixUser":
			if err := awsRestjson1_deserializeDocumentAwsEfsAccessPointPosixUserDetails(&sv.PosixUser, value); err != nil {
				return err
			}

		case "RootDirectory":
			if err := awsRestjson1_deserializeDocumentAwsEfsAccessPointRootDirectoryDetails(&sv.RootDirectory, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEfsAccessPointPosixUserDetails(v **types.AwsEfsAccessPointPosixUserDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEfsAccessPointPosixUserDetails
	if *v == nil {
		sv = &types.AwsEfsAccessPointPosixUserDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Gid":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Gid = ptr.String(jtv)
			}

		case "SecondaryGids":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecondaryGids, value); err != nil {
				return err
			}

		case "Uid":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Uid = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEfsAccessPointRootDirectoryCreationInfoDetails(v **types.AwsEfsAccessPointRootDirectoryCreationInfoDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEfsAccessPointRootDirectoryCreationInfoDetails
	if *v == nil {
		sv = &types.AwsEfsAccessPointRootDirectoryCreationInfoDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "OwnerGid":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerGid = ptr.String(jtv)
			}

		case "OwnerUid":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerUid = ptr.String(jtv)
			}

		case "Permissions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Permissions = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEfsAccessPointRootDirectoryDetails(v **types.AwsEfsAccessPointRootDirectoryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEfsAccessPointRootDirectoryDetails
	if *v == nil {
		sv = &types.AwsEfsAccessPointRootDirectoryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreationInfo":
			if err := awsRestjson1_deserializeDocumentAwsEfsAccessPointRootDirectoryCreationInfoDetails(&sv.CreationInfo, value); err != nil {
				return err
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEksClusterDetails(v **types.AwsEksClusterDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEksClusterDetails
	if *v == nil {
		sv = &types.AwsEksClusterDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CertificateAuthorityData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateAuthorityData = ptr.String(jtv)
			}

		case "ClusterStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterStatus = ptr.String(jtv)
			}

		case "Endpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Endpoint = ptr.String(jtv)
			}

		case "Logging":
			if err := awsRestjson1_deserializeDocumentAwsEksClusterLoggingDetails(&sv.Logging, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ResourcesVpcConfig":
			if err := awsRestjson1_deserializeDocumentAwsEksClusterResourcesVpcConfigDetails(&sv.ResourcesVpcConfig, value); err != nil {
				return err
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEksClusterLoggingClusterLoggingDetails(v **types.AwsEksClusterLoggingClusterLoggingDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEksClusterLoggingClusterLoggingDetails
	if *v == nil {
		sv = &types.AwsEksClusterLoggingClusterLoggingDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		case "Types":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Types, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEksClusterLoggingClusterLoggingList(v *[]types.AwsEksClusterLoggingClusterLoggingDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEksClusterLoggingClusterLoggingDetails
	if *v == nil {
		cv = []types.AwsEksClusterLoggingClusterLoggingDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEksClusterLoggingClusterLoggingDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEksClusterLoggingClusterLoggingDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEksClusterLoggingDetails(v **types.AwsEksClusterLoggingDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEksClusterLoggingDetails
	if *v == nil {
		sv = &types.AwsEksClusterLoggingDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ClusterLogging":
			if err := awsRestjson1_deserializeDocumentAwsEksClusterLoggingClusterLoggingList(&sv.ClusterLogging, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEksClusterResourcesVpcConfigDetails(v **types.AwsEksClusterResourcesVpcConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEksClusterResourcesVpcConfigDetails
	if *v == nil {
		sv = &types.AwsEksClusterResourcesVpcConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EndpointPublicAccess":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EndpointPublicAccess = ptr.Bool(jtv)
			}

		case "SecurityGroupIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupIds, value); err != nil {
				return err
			}

		case "SubnetIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SubnetIds, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentDetails(v **types.AwsElasticBeanstalkEnvironmentDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentDetails
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApplicationName = ptr.String(jtv)
			}

		case "Cname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Cname = ptr.String(jtv)
			}

		case "DateCreated":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DateCreated = ptr.String(jtv)
			}

		case "DateUpdated":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DateUpdated = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EndpointUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EndpointUrl = ptr.String(jtv)
			}

		case "EnvironmentArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentArn = ptr.String(jtv)
			}

		case "EnvironmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentId = ptr.String(jtv)
			}

		case "EnvironmentLinks":
			if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLinks(&sv.EnvironmentLinks, value); err != nil {
				return err
			}

		case "EnvironmentName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentName = ptr.String(jtv)
			}

		case "OptionSettings":
			if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSettings(&sv.OptionSettings, value); err != nil {
				return err
			}

		case "PlatformArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PlatformArn = ptr.String(jtv)
			}

		case "SolutionStackName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SolutionStackName = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "Tier":
			if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentTier(&sv.Tier, value); err != nil {
				return err
			}

		case "VersionLabel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VersionLabel = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLink(v **types.AwsElasticBeanstalkEnvironmentEnvironmentLink, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentEnvironmentLink
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentEnvironmentLink{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EnvironmentName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentName = ptr.String(jtv)
			}

		case "LinkName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LinkName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLinks(v *[]types.AwsElasticBeanstalkEnvironmentEnvironmentLink, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElasticBeanstalkEnvironmentEnvironmentLink
	if *v == nil {
		cv = []types.AwsElasticBeanstalkEnvironmentEnvironmentLink{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElasticBeanstalkEnvironmentEnvironmentLink
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLink(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSetting(v **types.AwsElasticBeanstalkEnvironmentOptionSetting, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentOptionSetting
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentOptionSetting{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Namespace":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Namespace = ptr.String(jtv)
			}

		case "OptionName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OptionName = ptr.String(jtv)
			}

		case "ResourceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourceName = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSettings(v *[]types.AwsElasticBeanstalkEnvironmentOptionSetting, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElasticBeanstalkEnvironmentOptionSetting
	if *v == nil {
		cv = []types.AwsElasticBeanstalkEnvironmentOptionSetting{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElasticBeanstalkEnvironmentOptionSetting
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSetting(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentTier(v **types.AwsElasticBeanstalkEnvironmentTier, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentTier
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentTier{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainDetails(v **types.AwsElasticsearchDomainDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainDetails
	if *v == nil {
		sv = &types.AwsElasticsearchDomainDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessPolicies":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessPolicies = ptr.String(jtv)
			}

		case "DomainEndpointOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainDomainEndpointOptions(&sv.DomainEndpointOptions, value); err != nil {
				return err
			}

		case "DomainId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainId = ptr.String(jtv)
			}

		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "ElasticsearchClusterConfig":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigDetails(&sv.ElasticsearchClusterConfig, value); err != nil {
				return err
			}

		case "ElasticsearchVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ElasticsearchVersion = ptr.String(jtv)
			}

		case "EncryptionAtRestOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainEncryptionAtRestOptions(&sv.EncryptionAtRestOptions, value); err != nil {
				return err
			}

		case "Endpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Endpoint = ptr.String(jtv)
			}

		case "Endpoints":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Endpoints, value); err != nil {
				return err
			}

		case "LogPublishingOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptions(&sv.LogPublishingOptions, value); err != nil {
				return err
			}

		case "NodeToNodeEncryptionOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainNodeToNodeEncryptionOptions(&sv.NodeToNodeEncryptionOptions, value); err != nil {
				return err
			}

		case "ServiceSoftwareOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainServiceSoftwareOptions(&sv.ServiceSoftwareOptions, value); err != nil {
				return err
			}

		case "VPCOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainVPCOptions(&sv.VPCOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainDomainEndpointOptions(v **types.AwsElasticsearchDomainDomainEndpointOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainDomainEndpointOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainDomainEndpointOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EnforceHTTPS":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnforceHTTPS = ptr.Bool(jtv)
			}

		case "TLSSecurityPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TLSSecurityPolicy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigDetails(v **types.AwsElasticsearchDomainElasticsearchClusterConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainElasticsearchClusterConfigDetails
	if *v == nil {
		sv = &types.AwsElasticsearchDomainElasticsearchClusterConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DedicatedMasterCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DedicatedMasterCount = ptr.Int32(int32(i64))
			}

		case "DedicatedMasterEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DedicatedMasterEnabled = ptr.Bool(jtv)
			}

		case "DedicatedMasterType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DedicatedMasterType = ptr.String(jtv)
			}

		case "InstanceCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstanceCount = ptr.Int32(int32(i64))
			}

		case "InstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "ZoneAwarenessConfig":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails(&sv.ZoneAwarenessConfig, value); err != nil {
				return err
			}

		case "ZoneAwarenessEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ZoneAwarenessEnabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails(v **types.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails
	if *v == nil {
		sv = &types.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZoneCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AvailabilityZoneCount = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainEncryptionAtRestOptions(v **types.AwsElasticsearchDomainEncryptionAtRestOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainEncryptionAtRestOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainEncryptionAtRestOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptions(v **types.AwsElasticsearchDomainLogPublishingOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainLogPublishingOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainLogPublishingOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuditLogs":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(&sv.AuditLogs, value); err != nil {
				return err
			}

		case "IndexSlowLogs":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(&sv.IndexSlowLogs, value); err != nil {
				return err
			}

		case "SearchSlowLogs":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(&sv.SearchSlowLogs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(v **types.AwsElasticsearchDomainLogPublishingOptionsLogConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainLogPublishingOptionsLogConfig
	if *v == nil {
		sv = &types.AwsElasticsearchDomainLogPublishingOptionsLogConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchLogsLogGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogsLogGroupArn = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainNodeToNodeEncryptionOptions(v **types.AwsElasticsearchDomainNodeToNodeEncryptionOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainNodeToNodeEncryptionOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainNodeToNodeEncryptionOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainServiceSoftwareOptions(v **types.AwsElasticsearchDomainServiceSoftwareOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainServiceSoftwareOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainServiceSoftwareOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutomatedUpdateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AutomatedUpdateDate = ptr.String(jtv)
			}

		case "Cancellable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Cancellable = ptr.Bool(jtv)
			}

		case "CurrentVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CurrentVersion = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "NewVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NewVersion = ptr.String(jtv)
			}

		case "UpdateAvailable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.UpdateAvailable = ptr.Bool(jtv)
			}

		case "UpdateStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdateStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainVPCOptions(v **types.AwsElasticsearchDomainVPCOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainVPCOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainVPCOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "SecurityGroupIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupIds, value); err != nil {
				return err
			}

		case "SubnetIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SubnetIds, value); err != nil {
				return err
			}

		case "VPCId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VPCId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicies(v *[]types.AwsElbAppCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbAppCookieStickinessPolicy
	if *v == nil {
		cv = []types.AwsElbAppCookieStickinessPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbAppCookieStickinessPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicy(v **types.AwsElbAppCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbAppCookieStickinessPolicy
	if *v == nil {
		sv = &types.AwsElbAppCookieStickinessPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CookieName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CookieName = ptr.String(jtv)
			}

		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicies(v *[]types.AwsElbLbCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLbCookieStickinessPolicy
	if *v == nil {
		cv = []types.AwsElbLbCookieStickinessPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLbCookieStickinessPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicy(v **types.AwsElbLbCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLbCookieStickinessPolicy
	if *v == nil {
		sv = &types.AwsElbLbCookieStickinessPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CookieExpirationPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CookieExpirationPeriod = ptr.Int64(i64)
			}

		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerAccessLog(v **types.AwsElbLoadBalancerAccessLog, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerAccessLog
	if *v == nil {
		sv = &types.AwsElbLoadBalancerAccessLog{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EmitInterval":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.EmitInterval = ptr.Int32(int32(i64))
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		case "S3BucketName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketName = ptr.String(jtv)
			}

		case "S3BucketPrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketPrefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerAdditionalAttribute(v **types.AwsElbLoadBalancerAdditionalAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerAdditionalAttribute
	if *v == nil {
		sv = &types.AwsElbLoadBalancerAdditionalAttribute{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerAdditionalAttributeList(v *[]types.AwsElbLoadBalancerAdditionalAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLoadBalancerAdditionalAttribute
	if *v == nil {
		cv = []types.AwsElbLoadBalancerAdditionalAttribute{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLoadBalancerAdditionalAttribute
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerAdditionalAttribute(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerAttributes(v **types.AwsElbLoadBalancerAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerAttributes
	if *v == nil {
		sv = &types.AwsElbLoadBalancerAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessLog":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerAccessLog(&sv.AccessLog, value); err != nil {
				return err
			}

		case "AdditionalAttributes":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerAdditionalAttributeList(&sv.AdditionalAttributes, value); err != nil {
				return err
			}

		case "ConnectionDraining":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionDraining(&sv.ConnectionDraining, value); err != nil {
				return err
			}

		case "ConnectionSettings":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionSettings(&sv.ConnectionSettings, value); err != nil {
				return err
			}

		case "CrossZoneLoadBalancing":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerCrossZoneLoadBalancing(&sv.CrossZoneLoadBalancing, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescription(v **types.AwsElbLoadBalancerBackendServerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerBackendServerDescription
	if *v == nil {
		sv = &types.AwsElbLoadBalancerBackendServerDescription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstancePort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstancePort = ptr.Int32(int32(i64))
			}

		case "PolicyNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.PolicyNames, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescriptions(v *[]types.AwsElbLoadBalancerBackendServerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLoadBalancerBackendServerDescription
	if *v == nil {
		cv = []types.AwsElbLoadBalancerBackendServerDescription{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLoadBalancerBackendServerDescription
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescription(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionDraining(v **types.AwsElbLoadBalancerConnectionDraining, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerConnectionDraining
	if *v == nil {
		sv = &types.AwsElbLoadBalancerConnectionDraining{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		case "Timeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Timeout = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionSettings(v **types.AwsElbLoadBalancerConnectionSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerConnectionSettings
	if *v == nil {
		sv = &types.AwsElbLoadBalancerConnectionSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IdleTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.IdleTimeout = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerCrossZoneLoadBalancing(v **types.AwsElbLoadBalancerCrossZoneLoadBalancing, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerCrossZoneLoadBalancing
	if *v == nil {
		sv = &types.AwsElbLoadBalancerCrossZoneLoadBalancing{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerDetails(v **types.AwsElbLoadBalancerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerDetails
	if *v == nil {
		sv = &types.AwsElbLoadBalancerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "BackendServerDescriptions":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescriptions(&sv.BackendServerDescriptions, value); err != nil {
				return err
			}

		case "CanonicalHostedZoneName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CanonicalHostedZoneName = ptr.String(jtv)
			}

		case "CanonicalHostedZoneNameID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CanonicalHostedZoneNameID = ptr.String(jtv)
			}

		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "DnsName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DnsName = ptr.String(jtv)
			}

		case "HealthCheck":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerHealthCheck(&sv.HealthCheck, value); err != nil {
				return err
			}

		case "Instances":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstances(&sv.Instances, value); err != nil {
				return err
			}

		case "ListenerDescriptions":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescriptions(&sv.ListenerDescriptions, value); err != nil {
				return err
			}

		case "LoadBalancerAttributes":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerAttributes(&sv.LoadBalancerAttributes, value); err != nil {
				return err
			}

		case "LoadBalancerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoadBalancerName = ptr.String(jtv)
			}

		case "Policies":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerPolicies(&sv.Policies, value); err != nil {
				return err
			}

		case "Scheme":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Scheme = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "SourceSecurityGroup":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerSourceSecurityGroup(&sv.SourceSecurityGroup, value); err != nil {
				return err
			}

		case "Subnets":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.Subnets, value); err != nil {
				return err
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerHealthCheck(v **types.AwsElbLoadBalancerHealthCheck, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerHealthCheck
	if *v == nil {
		sv = &types.AwsElbLoadBalancerHealthCheck{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HealthyThreshold":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HealthyThreshold = ptr.Int32(int32(i64))
			}

		case "Interval":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Interval = ptr.Int32(int32(i64))
			}

		case "Target":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Target = ptr.String(jtv)
			}

		case "Timeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Timeout = ptr.Int32(int32(i64))
			}

		case "UnhealthyThreshold":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.UnhealthyThreshold = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstance(v **types.AwsElbLoadBalancerInstance, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerInstance
	if *v == nil {
		sv = &types.AwsElbLoadBalancerInstance{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstances(v *[]types.AwsElbLoadBalancerInstance, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLoadBalancerInstance
	if *v == nil {
		cv = []types.AwsElbLoadBalancerInstance{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLoadBalancerInstance
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstance(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerListener(v **types.AwsElbLoadBalancerListener, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerListener
	if *v == nil {
		sv = &types.AwsElbLoadBalancerListener{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstancePort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstancePort = ptr.Int32(int32(i64))
			}

		case "InstanceProtocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceProtocol = ptr.String(jtv)
			}

		case "LoadBalancerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.LoadBalancerPort = ptr.Int32(int32(i64))
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "SslCertificateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SslCertificateId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescription(v **types.AwsElbLoadBalancerListenerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerListenerDescription
	if *v == nil {
		sv = &types.AwsElbLoadBalancerListenerDescription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Listener":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerListener(&sv.Listener, value); err != nil {
				return err
			}

		case "PolicyNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.PolicyNames, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescriptions(v *[]types.AwsElbLoadBalancerListenerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLoadBalancerListenerDescription
	if *v == nil {
		cv = []types.AwsElbLoadBalancerListenerDescription{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLoadBalancerListenerDescription
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescription(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerPolicies(v **types.AwsElbLoadBalancerPolicies, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerPolicies
	if *v == nil {
		sv = &types.AwsElbLoadBalancerPolicies{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AppCookieStickinessPolicies":
			if err := awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicies(&sv.AppCookieStickinessPolicies, value); err != nil {
				return err
			}

		case "LbCookieStickinessPolicies":
			if err := awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicies(&sv.LbCookieStickinessPolicies, value); err != nil {
				return err
			}

		case "OtherPolicies":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.OtherPolicies, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerSourceSecurityGroup(v **types.AwsElbLoadBalancerSourceSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerSourceSecurityGroup
	if *v == nil {
		sv = &types.AwsElbLoadBalancerSourceSecurityGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "OwnerAlias":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerAlias = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbv2LoadBalancerAttribute(v **types.AwsElbv2LoadBalancerAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbv2LoadBalancerAttribute
	if *v == nil {
		sv = &types.AwsElbv2LoadBalancerAttribute{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbv2LoadBalancerAttributes(v *[]types.AwsElbv2LoadBalancerAttribute, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbv2LoadBalancerAttribute
	if *v == nil {
		cv = []types.AwsElbv2LoadBalancerAttribute{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbv2LoadBalancerAttribute
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbv2LoadBalancerAttribute(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbv2LoadBalancerDetails(v **types.AwsElbv2LoadBalancerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbv2LoadBalancerDetails
	if *v == nil {
		sv = &types.AwsElbv2LoadBalancerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentAvailabilityZones(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "CanonicalHostedZoneId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CanonicalHostedZoneId = ptr.String(jtv)
			}

		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "DNSName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DNSName = ptr.String(jtv)
			}

		case "IpAddressType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddressType = ptr.String(jtv)
			}

		case "LoadBalancerAttributes":
			if err := awsRestjson1_deserializeDocumentAwsElbv2LoadBalancerAttributes(&sv.LoadBalancerAttributes, value); err != nil {
				return err
			}

		case "Scheme":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Scheme = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentSecurityGroups(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "State":
			if err := awsRestjson1_deserializeDocumentLoadBalancerState(&sv.State, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventSchemasRegistryDetails(v **types.AwsEventSchemasRegistryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventSchemasRegistryDetails
	if *v == nil {
		sv = &types.AwsEventSchemasRegistryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "RegistryArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegistryArn = ptr.String(jtv)
			}

		case "RegistryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegistryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointDetails(v **types.AwsEventsEndpointDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEndpointDetails
	if *v == nil {
		sv = &types.AwsEventsEndpointDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EndpointId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EndpointId = ptr.String(jtv)
			}

		case "EndpointUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EndpointUrl = ptr.String(jtv)
			}

		case "EventBuses":
			if err := awsRestjson1_deserializeDocumentAwsEventsEndpointEventBusesList(&sv.EventBuses, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ReplicationConfig":
			if err := awsRestjson1_deserializeDocumentAwsEventsEndpointReplicationConfigDetails(&sv.ReplicationConfig, value); err != nil {
				return err
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "RoutingConfig":
			if err := awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigDetails(&sv.RoutingConfig, value); err != nil {
				return err
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		case "StateReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StateReason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointEventBusesDetails(v **types.AwsEventsEndpointEventBusesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEndpointEventBusesDetails
	if *v == nil {
		sv = &types.AwsEventsEndpointEventBusesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EventBusArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EventBusArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointEventBusesList(v *[]types.AwsEventsEndpointEventBusesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEventsEndpointEventBusesDetails
	if *v == nil {
		cv = []types.AwsEventsEndpointEventBusesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEventsEndpointEventBusesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEventsEndpointEventBusesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointReplicationConfigDetails(v **types.AwsEventsEndpointReplicationConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEndpointReplicationConfigDetails
	if *v == nil {
		sv = &types.AwsEventsEndpointReplicationConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigDetails(v **types.AwsEventsEndpointRoutingConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEndpointRoutingConfigDetails
	if *v == nil {
		sv = &types.AwsEventsEndpointRoutingConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FailoverConfig":
			if err := awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigFailoverConfigDetails(&sv.FailoverConfig, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigFailoverConfigDetails(v **types.AwsEventsEndpointRoutingConfigFailoverConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEndpointRoutingConfigFailoverConfigDetails
	if *v == nil {
		sv = &types.AwsEventsEndpointRoutingConfigFailoverConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Primary":
			if err := awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails(&sv.Primary, value); err != nil {
				return err
			}

		case "Secondary":
			if err := awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails(&sv.Secondary, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails(v **types.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails
	if *v == nil {
		sv = &types.AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HealthCheck":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HealthCheck = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails(v **types.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails
	if *v == nil {
		sv = &types.AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Route":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Route = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEventsEventbusDetails(v **types.AwsEventsEventbusDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEventsEventbusDetails
	if *v == nil {
		sv = &types.AwsEventsEventbusDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Policy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Policy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesCloudTrailDetails(v **types.AwsGuardDutyDetectorDataSourcesCloudTrailDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesCloudTrailDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesCloudTrailDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesDetails(v **types.AwsGuardDutyDetectorDataSourcesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudTrail":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesCloudTrailDetails(&sv.CloudTrail, value); err != nil {
				return err
			}

		case "DnsLogs":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesDnsLogsDetails(&sv.DnsLogs, value); err != nil {
				return err
			}

		case "FlowLogs":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesFlowLogsDetails(&sv.FlowLogs, value); err != nil {
				return err
			}

		case "Kubernetes":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesKubernetesDetails(&sv.Kubernetes, value); err != nil {
				return err
			}

		case "MalwareProtection":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesMalwareProtectionDetails(&sv.MalwareProtection, value); err != nil {
				return err
			}

		case "S3Logs":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesS3LogsDetails(&sv.S3Logs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesDnsLogsDetails(v **types.AwsGuardDutyDetectorDataSourcesDnsLogsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesDnsLogsDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesDnsLogsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesFlowLogsDetails(v **types.AwsGuardDutyDetectorDataSourcesFlowLogsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesFlowLogsDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesFlowLogsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails(v **types.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesKubernetesDetails(v **types.AwsGuardDutyDetectorDataSourcesKubernetesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesKubernetesDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesKubernetesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuditLogs":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails(&sv.AuditLogs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesMalwareProtectionDetails(v **types.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ScanEc2InstanceWithFindings":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails(&sv.ScanEc2InstanceWithFindings, value); err != nil {
				return err
			}

		case "ServiceRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceRole = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails(v **types.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EbsVolumes":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails(&sv.EbsVolumes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails(v **types.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesS3LogsDetails(v **types.AwsGuardDutyDetectorDataSourcesS3LogsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDataSourcesS3LogsDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDataSourcesS3LogsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDetails(v **types.AwsGuardDutyDetectorDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DataSources":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorDataSourcesDetails(&sv.DataSources, value); err != nil {
				return err
			}

		case "Features":
			if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorFeaturesList(&sv.Features, value); err != nil {
				return err
			}

		case "FindingPublishingFrequency":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FindingPublishingFrequency = ptr.String(jtv)
			}

		case "ServiceRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceRole = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorFeaturesDetails(v **types.AwsGuardDutyDetectorFeaturesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsGuardDutyDetectorFeaturesDetails
	if *v == nil {
		sv = &types.AwsGuardDutyDetectorFeaturesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsGuardDutyDetectorFeaturesList(v *[]types.AwsGuardDutyDetectorFeaturesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsGuardDutyDetectorFeaturesDetails
	if *v == nil {
		cv = []types.AwsGuardDutyDetectorFeaturesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsGuardDutyDetectorFeaturesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsGuardDutyDetectorFeaturesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeyDetails(v **types.AwsIamAccessKeyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeyDetails
	if *v == nil {
		sv = &types.AwsIamAccessKeyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessKeyId = ptr.String(jtv)
			}

		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedAt = ptr.String(jtv)
			}

		case "PrincipalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalId = ptr.String(jtv)
			}

		case "PrincipalName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalName = ptr.String(jtv)
			}

		case "PrincipalType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalType = ptr.String(jtv)
			}

		case "SessionContext":
			if err := awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContext(&sv.SessionContext, value); err != nil {
				return err
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AwsIamAccessKeyStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.AwsIamAccessKeyStatus(jtv)
			}

		case "UserName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContext(v **types.AwsIamAccessKeySessionContext, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeySessionContext
	if *v == nil {
		sv = &types.AwsIamAccessKeySessionContext{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attributes":
			if err := awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextAttributes(&sv.Attributes, value); err != nil {
				return err
			}

		case "SessionIssuer":
			if err := awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextSessionIssuer(&sv.SessionIssuer, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextAttributes(v **types.AwsIamAccessKeySessionContextAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeySessionContextAttributes
	if *v == nil {
		sv = &types.AwsIamAccessKeySessionContextAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "MfaAuthenticated":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MfaAuthenticated = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextSessionIssuer(v **types.AwsIamAccessKeySessionContextSessionIssuer, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeySessionContextSessionIssuer
	if *v == nil {
		sv = &types.AwsIamAccessKeySessionContextSessionIssuer{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "PrincipalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalId = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "UserName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicy(v **types.AwsIamAttachedManagedPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAttachedManagedPolicy
	if *v == nil {
		sv = &types.AwsIamAttachedManagedPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PolicyArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyArn = ptr.String(jtv)
			}

		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicyList(v *[]types.AwsIamAttachedManagedPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamAttachedManagedPolicy
	if *v == nil {
		cv = []types.AwsIamAttachedManagedPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamAttachedManagedPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamGroupDetails(v **types.AwsIamGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamGroupDetails
	if *v == nil {
		sv = &types.AwsIamGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachedManagedPolicies":
			if err := awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicyList(&sv.AttachedManagedPolicies, value); err != nil {
				return err
			}

		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "GroupPolicyList":
			if err := awsRestjson1_deserializeDocumentAwsIamGroupPolicyList(&sv.GroupPolicyList, value); err != nil {
				return err
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamGroupPolicy(v **types.AwsIamGroupPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamGroupPolicy
	if *v == nil {
		sv = &types.AwsIamGroupPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamGroupPolicyList(v *[]types.AwsIamGroupPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected J