#! /usr/bin/env python
# encoding: UTF-8
###############################################################################
# Gmount-iso.py : programme principal
###############################################################################
# Copyright (C) 2007 Vincent Thomas
# All rights reserved.
# (vincent.thomas@crans.org)
# English Translation : Bryan Quigley (gquigs@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
###############################################################################

# Import initial des librairies
import os,sys,commands
import re
import gtk, gobject
import gtk.glade
import mimetypes
import gettext
from gettext import gettext as _

#################################################
# Parametres et variables globales du programme #
#################################################
# Chemin d'accès
repertoire = os.path.split(os.path.realpath(sys.argv[0]))[0]

# Nom du fichier Glade
name_gladefile = "%s/gmount-iso.glade" % repertoire

# Pour la traduction dans une autre langue
application = 'Gmount-iso'
##gettext.install(application)

gettext.bindtextdomain(application, '/usr/share/locale')
gettext.textdomain(application)
#gui = gtk.glade.XML(fname="gmount.glade", domain=application)
##t = gettext.translation('gmount-iso', '/usr/share/locale')
##_ = t.ugettext

# Debugging information
debug = False
def print_debug(s):
	if debug:
		print s


####################################
# Fonctions et classes principales #
####################################
# Contrôleur de l'interface
class GmountController:

	def __init__(self):
		# Liste des éléments graphiques (widgets)
		widget_list = [
			'main_window',
			'combobox_list_iso',
			'button_umount',
			'button_mount',
			'entry_mount_file',
			'button_file_chooser',
			'entry_mount_folder',
			'button_folder_chooser',
			'button_erase',
			'button_refresh',
			'button_ouvrir'
			]
		handlers = [
			'gtk_main_quit',
			'on_button_mount_clicked',
			'on_button_umount_clicked',
			'on_button_file_chooser_clicked',
			'on_button_folder_chooser_clicked',
			'on_button_erase_clicked',
			'on_button_refresh_clicked',
			'on_combobox_list_iso_changed',
			'on_button_ouvrir_clicked'
			]

		top_window = 'main_window'
		wTree = gtk.glade.XML(name_gladefile, top_window, 'Gmount-iso')
		
		# On construit le dictionnaire des controlleurs
		dict = {}
		for h in handlers:
			dict[h] = eval("self.%s" % h)

		# On le connecte
		wTree.signal_autoconnect(dict)
		
		# On enregistre les widgets comme des variables
		for w in widget_list:
			setattr(self, w, wTree.get_widget(w))		
			
		# Initialisation
		#try:
		#	os.popen('modprobe loop') # on s'assure que le module est bien chargé"
		#except:
		#	pass
		self.rafraichir()

		# On regarde si on a lancé le programme depuis un fichier
		# si oui, on prend en compte son nom et son placement
		print_debug ("sys.argv : " + str(sys.argv))
		if len(sys.argv)>1:
			self.entry_mount_file.set_text(sys.argv[1])
			self.repertoire_defaut = os.path.dirname(sys.argv[1])
		else :
			self.repertoire_defaut = '/home/' + commands.getoutput('whoami')
			#self.repertoire_defaut = os.getcwd()

	# Fonction pour quitter
	def gtk_main_quit(self, *args):
		print_debug('Quitter')
		gtk.main_quit()

	# Action du bouton ouvrir iso
	def on_button_file_chooser_clicked(self, *args):
		print_debug('Sélection fichier')
	
		# on crée une boite de dialogue pour sélectionner un fichier *.iso
		dialog_title = _('Choose an image file')
		dialog = gtk.FileChooserDialog("%s" % dialog_title,
					   None,
					   gtk.FILE_CHOOSER_ACTION_OPEN,
					   (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
						gtk.STOCK_OPEN, gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		dialog.set_current_folder(self.repertoire_defaut)
		
		# On place des filtres pour le listing des fichiers
		filter = gtk.FileFilter()
		filter.set_name(_("Images (*.iso)"))
		filter.add_mime_type("fichier image")
		filter.add_pattern("*.iso")
		filter.add_pattern("*.nero")
		dialog.add_filter(filter)
		filter = gtk.FileFilter()
		filter.set_name(_("All files"))
		filter.add_pattern("*")
		dialog.add_filter(filter)
		
		response = dialog.run()
		# si on clique sur le bouton "Ouvrir", on vient lire le nom du fichier
		if response == gtk.RESPONSE_OK:
			self.entry_mount_file.set_text(str(dialog.get_filename()))
		dialog.destroy()
	
	# Action du bouton ouvrir dossier
	def on_button_folder_chooser_clicked(self, *args):
		print_debug('Selection Dossier')
	
		# On crée une boite de dialogue pour sélectionner un emplacement de montage du fichier *.iso
		dialog_title = _('Select a destination folder')
		dialog = gtk.FileChooserDialog("%s" % dialog_title,
					   None,
					   gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
					   (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
						gtk.STOCK_APPLY, gtk.RESPONSE_OK))
		dialog.set_default_response(gtk.RESPONSE_OK)
		dialog.set_current_folder('/media')
		
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			self.entry_mount_folder.set_text(str(dialog.get_filename()))
		dialog.destroy()
	
	# Action du bouton effacer
	def on_button_erase_clicked(self, *args):
		print_debug('Effacer')
		# On efface le nom du fichier *.iso et son emplacement de montage
		self.entry_mount_file.set_text('')
		self.entry_mount_folder.set_text('')
			
	# Action du bouton monter
	def on_button_mount_clicked(self, *args):
		print_debug('Monter')
		message_sortie = ''
		command_message = _("Enter the root's password\nto continue the operation")
		if self.verif():
			#os.popen('gksudo -p -m "Mot de passe"')
			command = ('gksudo -D "/usr/share/applications/gmount.desktop" '
								+ '-m "%s" ' 
								+ '-- mount -o loop -t iso9660 ' 
								+ commands.mkarg(self.entry_mount_file.get_text())
								+ ' '
								+ commands.mkarg(self.entry_mount_folder.get_text())) % command_message
			message_sortie = commands.getoutput(command)
			#message_sortie = os.system(command)
			print_debug ("message : "+message_sortie)

		if message_sortie != '':
			#erreur_survenue = "Une erreur est survenue"
			self.message_error(_("An error occured\n") 
						+ str(message_sortie).split(':')[-1]) #%erreur_survenue
		self.rafraichir(self, *args)

	# Définition de la fonction de vérification
	def verif(self, *args):
		# on lit le nom de fichier sélectionné
		mount_file = self.entry_mount_file.get_text()
		# On lit le nom de dossier sélectionné
		mount_folder = self.entry_mount_folder.get_text()

		if not os.path.isfile(os.path.normpath(mount_file)):
			self.message_error(_('The name of the file is incorrect. \nPlease choose a valid .iso file name'))

			return 0
		elif not os.path.isdir(os.path.normpath(mount_folder)):
			self.message_error(_('Folder name incorrect \nPlease choose a valid name folder'))
			return 0
		elif len(os.listdir(os.path.normpath(mount_folder)))!=0:
			self.message_error(_('The folder %s is not empty') % os.path.normpath(mount_folder))
			return 0
		else :
			print "mime type :",mimetypes.guess_type(mount_file)
			#sys.exit()
			return 1
	
	# Définition de la fonction pour afficher le message d'erreur
	def message_error(self, message):
		dialog = gtk.MessageDialog (self.main_window,
								  gtk.DIALOG_DESTROY_WITH_PARENT,
								  gtk.MESSAGE_ERROR,
								  gtk.BUTTONS_CLOSE,
								  message)
		response = dialog.run()
		if response == gtk.RESPONSE_CLOSE:
			dialog.destroy()

	# Action du bouton combobox fichiers montés
	def on_combobox_list_iso_changed(self, *args):
		print_debug('Liste_mounted')

		
	# Action du bouton rafraichir
	def on_button_refresh_clicked(self, *args):
		print_debug('Rafraichir')
		self.rafraichir()

	# Définition de la fonction de rafraichissement	
	def rafraichir(self, *args):
		liste_iso = commands.getoutput('cat /etc/mtab | grep loop')
		self.combobox_list_iso.set_model(gtk.ListStore(str))
		self.list_iso = []
		# S'il y a des fichiers *.iso montés, on en fait la liste
		if liste_iso !='':
			command = "LC_ALL=C mount | grep loop"
			liste_fichiers_iso = os.popen(command, "r")
			for t in liste_fichiers_iso.readlines():
				mo = re.match('^([^*]*) on ([^*]*) type',t)
				self.list_iso.append(mo.group(2).strip())
				self.combobox_list_iso.append_text((mo.group(1).strip()).split('/')[-1]
						+ _(' mounted on ')
						+ mo.group(2).strip())
			self.combobox_list_iso.set_active(len(self.list_iso)-1)
		# Sinon on affiche le message "Aucun"
		else:
			self.combobox_list_iso.prepend_text(_('-- None --'))
			self.combobox_list_iso.set_active(0)

		
	# Action du bouton demonter
	def on_button_umount_clicked(self, *args):
		print_debug('Demonter')
	
		# On lit les informations de la liste des fichiers montés (seulement la ligne active)
		if len(self.list_iso) != 0 :
			#repertoire = self.combobox_list_iso.get_active_text()
			#commande = re.match('^ *.* _("monte sur") ([^*]*)',repertoire ) # On ne sélectionne que le nom du répertoire
			#print_debug ("commande : sudo umount " + commands.mkarg(commande.group(1).strip()))
			# On fait un getoutput pour ne pas avoir a redemander le mdp si on a deja fait un montage
			command_message = _("Enter the root's password\nto continue the operation")
			command = ('gksudo -D "/usr/share/applications/gmount.desktop" '
						 + '-m "%s" -- umount '
						 + commands.mkarg(self.list_iso[self.combobox_list_iso.get_active()])) % command_message
			commands.getoutput(command)
			self.rafraichir()
			
	# Action du bouton ouvrir (dossier monté)	
	def on_button_ouvrir_clicked(self, *args):
		print_debug('Ouvrir dossier image')
		if len(self.list_iso) != 0 :
			os.popen('nautilus ' + commands.mkarg(self.list_iso[self.combobox_list_iso.get_active()]))



################
# Code principal


control = GmountController()

gtk.main()
