/* -----------------------------------------------------------------------------
 *
 * (c) The GHC Team, 1998-2011
 *
 * Registers used in STG code.  Might or might not correspond to
 * actual machine registers.
 *
 * Do not #include this file directly: #include "Rts.h" instead.
 *
 * To understand the structure of the RTS headers, see the wiki:
 *   http://ghc.haskell.org/trac/ghc/wiki/Commentary/SourceTree/Includes
 *
 * ---------------------------------------------------------------------------*/

#pragma once

/*
 * Defining NO_REGS causes no global registers to be used.  NO_REGS is
 * typically defined by GHC, via a command-line option passed to gcc,
 * when the -funregisterised flag is given.
 *
 * NB. When NO_REGS is on, calling & return conventions may be
 * different.  For example, all function arguments will be passed on
 * the stack, and components of an unboxed tuple will be returned on
 * the stack rather than in registers.
 */
#if defined(NO_REGS)

#define MACHREGS_NO_REGS 1

#else

#define MACHREGS_NO_REGS 0

#if defined(i386_TARGET_ARCH)
#define MACHREGS_i386     1
#endif

#if defined(x86_64_TARGET_ARCH)
#define MACHREGS_x86_64   1
#endif

#if defined(powerpc_TARGET_ARCH) || defined(powerpc64_TARGET_ARCH) \
            || defined(powerpc64le_TARGET_ARCH) || defined(rs6000_TARGET_ARCH)
#define MACHREGS_powerpc  1
#endif

#if defined(sparc_TARGET_ARCH)
#define MACHREGS_sparc    1
#endif

#if defined(arm_TARGET_ARCH)
#define MACHREGS_arm      1
#endif

#if defined(aarch64_TARGET_ARCH)
#define MACHREGS_aarch64  1
#endif

#if defined(darwin_TARGET_OS)
#define MACHREGS_darwin   1
#endif

#endif

#include "MachRegs.h"
