.\" @(#)$RCSfile: gfal_prestagestatus_python.man,v $ $Revision: 1.5 $ $Date: 2008/12/18 13:19:12 $ CERN Remi Mollon
.\" Copyright (C) 2007 by CERN
.\" All rights reserved
.\"
.TH GFAL_PRESTAGESTATUS 3 "$Date: 2008/12/18 13:19:12 $" GFAL "Library Functions"
.SH NAME
gfal_prestagestatus \- Asynchronous function to check status of a gfal_prestage request.
.SH SYNOPSIS
\fBimport gfal\fR
.sp
.BI "(int " returncode ,
.BI "gfal_internal " gfal ,
.BI "string " errmsg
.BI ") gfal_prestagestatus (gfal_internal " gfal
.B );

.SH DESCRIPTION
.B gfal_prestagestatus
is the asynchronous function which must be used to check the status of the 
.I gfal_prestage_python(3)
request and get the results.

See 
.I gfal_get_results_python(3)
to be able to access results.

.TP
.I gfal
.B gfal_internal
object generated from user parameters and used for the 
.B gfal_prestage_python(3)
call.
.TP
.I errbuf
allocated 
.B char *
pointer in which a detailed error message may be stored.
.TP
.I errbufsz
size allocated ofr the pointer 
.I errbuf

.SH RETURN VALUE
This routine returns 0 on a success, or -1 in case of error. In the latter case,
.B errno
is set appropriately. Moreover, you can get an error message from
.I errbuf
, if specified.

.SH ERRORS
.B errno
indicates the type of error, but for detailled error message, you have to look into
.IR errbuf .
.TP 1.3i
.B EINVAL
The 
.B gfal_internal
object is incorrect. It may be caused by freeing a user parameter which was in use in it, or by modifying this object by hand.
.TP
.B EPROTONOSUPPORT
You try to make an action with a protocol which is not supported by the system.
.TP
.B ENOMEM
Not enough free memory.

.SH SEE ALSO
.BR gfal_python (3) ,
.BR gfal_init_python (3) ,
.BR gfal_internal_free_python (3) ,
.BR gfal_deletesurls_python (3) ,
.BR gfal_removedir_python (3) ,
.BR gfal_get_python (3) ,
.BR gfal_getstatus_python (3) ,
.BR gfal_ls_python (3) ,
.BR gfal_pin_python (3) ,
.BR gfal_prestage_python (3) ,
.BR gfal_prestagestatus_python (3) ,
.BR gfal_release_python (3) ,
.BR gfal_abortrequest_python (3) ,
.BR gfal_abortfiles_python (3) ,
.BR gfal_set_xfer_done_python (3) ,
.BR gfal_set_xfer_running_python (3) ,
.BR gfal_turlsfromsurls_python (3) ,
.BR gfal_get_ids_python (3) ,
.BR gfal_set_ids_python (3) ,
.BR gfal_get_results_python (3) ,
.BR gfal_access_python (3) ,
.BR gfal_chmod_python (3) ,
.BR gfal_close_python (3) ,
.BR gfal_closedir_python (3) ,
.BR gfal_creat_python (3) ,
.BR gfal_get_timeout_connect_python (3) ,
.BR gfal_get_timeout_sendreceive_python (3) ,
.BR gfal_get_timeout_bdii_python (3) ,
.BR gfal_get_timeout_srm_python (3) ,
.BR gfal_set_timeout_connect_python (3) ,
.BR gfal_set_timeout_sendreceive_python (3) ,
.BR gfal_set_timeout_bdii_python (3) ,
.BR gfal_set_timeout_srm_python (3) ,
.BR gfal_lseek_python (3) ,
.BR gfal_mkdir_python (3) ,
.BR gfal_open_python (3) ,
.BR gfal_opendir_python (3) ,
.BR gfal_read_python (3) ,
.BR gfal_rename_python (3) ,
.BR gfal_rmdir_python (3) ,
.BR gfal_stat_python (3) ,
.BR gfal_unlink_python (3) ,
.BR gfal_write_python (3) ,
.BR gfal_set_verbose_python (3) ,
.BR gfal_get_errno_python (3) ,
