# Copyright (C) 2012 - Curtis Hovey <sinzui.is at verizon.net>
# This software is licensed under the MIT license (see the file COPYING).

import gdpbase
from gdpbase import (
    do_migrate_settings,
    migrate_settings,
    )
from gdp import Config
from testing import GeditTestCase


class DoMigrateSettingsTestCase(GeditTestCase):

    def test_config_with_current_version(self):
        self.make_config(gdpbase, Config)
        gdpbase.config._loaded_file_path = ['bogus/path']
        self.assertIs(False, do_migrate_settings())

    def test_no_config(self):
        test_config = self.make_config(gdpbase, Config)
        test_config.close()
        self.assertIs(True, do_migrate_settings())

    def test_config_with_old_version(self):
        self.make_config(gdpbase, Config)
        gdpbase.config._loaded_file_path = ['bogus/path']
        gdpbase.config.set('gdp', 'version', '0')
        self.assertIs(True, do_migrate_settings())


class MigrateSettingsTestCase(GeditTestCase):

    def test_migrate_settings_no_active(self):
        settings = self.make_gsettings()
        settings.set_strv('active-plugins', ['filebrowser', 'spell'])
        migrate_settings()
        self.assertEqual(
            ['filebrowser', 'spell'], settings.get_strv('active-plugins'))

    def test_migrate_settings_single_active(self):
        settings = self.make_gsettings()
        settings.set_strv(
            'active-plugins', ['filebrowser', 'gdpsyntaxcompleter', 'spell'])
        migrate_settings()
        self.assertEqual(
            ['filebrowser', 'gdpcomplete', 'spell'],
            settings.get_strv('active-plugins'))

    def test_migrate_settings_dual_active(self):
        settings = self.make_gsettings()
        settings.set_strv(
            'active-plugins',
            ['filebrowser', 'gdpcomplete', 'gdpsyntaxcompleter', 'spell'])
        migrate_settings()
        self.assertEqual(
            ['filebrowser', 'gdpcomplete', 'spell'],
            settings.get_strv('active-plugins'))
