from xml import sax



class ConfigFormatLoader(sax.handler.ContentHandler):

    def __init__(self):

        self.__format = {}
        self.__path = []



    def load(self, file):

        fd = open(file, "r")
        data = fd.read()
        fd.close()

        sax.parseString(data, self)
        return self.__format




    def startElement(self, name, attrs):

        if (name == "folder"):
            tag = attrs["name"]
            self.__path.append(tag)
            
        elif (name == "entry"):
            tag = attrs["name"]
            vtype = attrs["type"]
            default = attrs["default"]

            self.__path.append(tag)
            self.__format[tuple(self.__path)] = (vtype, default)



    def endElement(self, name):

        if (self.__path):
            self.__path.pop()
