"""
 * Copyright (C) 2008 Varun Hiremath.
 * Copyright (C) 2008 A Venkattraman.
 * Copyright (C) 2008 C Shyam Sundar.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * Authors: Varun Hiremath, Venkattraman A, Shyam Sundar C

"""

from gastables.RayleighFlow import RayleighFlow
from scipy import arange

def get_allValues_from_M(M,gamma) :
    rf = RayleighFlow(gamma)
    VALUES = {}
    VALUES["M"] = M
    try :
        VALUES["P/P*"] = rf.get_P_by_Pstar_from_M(M)
        VALUES["Po/Po*"] = rf.get_Po_by_Postar_from_M(M)
        VALUES["T/T*"] = rf.get_T_by_Tstar_from_M(M)
        VALUES["To/To*"] = rf.get_To_by_Tostar_from_M(M)
        VALUES["r/r*"] = rf.get_rho_by_rhostar_from_M(M)
        VALUES["Qmax/CpT"] = rf.get_Qmax_by_CpT_from_M(M)
        return VALUES
    except Exception, e:
        raise Exception(e)

def get_allValues_from_P_by_Pstar(P_by_Pstar,gamma):
    rf = RayleighFlow(gamma)
    try:
        return get_allValues_from_M(rf.get_M_from_P_by_Pstar(P_by_Pstar),gamma)
    except Exception,e:
        raise Exception(e)

def get_allValues_from_Po_by_Postar(Po_by_Postar,gamma):
    rf = RayleighFlow(gamma)
    VALUES = {}
    SECOND_VALUES = None
    Mach_Nos = rf.get_M_from_Po_by_Postar(Po_by_Postar)
    if(type(Mach_Nos) == tuple):
        M1 = Mach_Nos[0]
        M2 = Mach_Nos[1]
        VALUES = get_allValues_from_M(M1, gamma)
        SECOND_VALUES = get_allValues_from_M(M2, gamma)
    else:
        VALUES = get_allValues_from_M(Mach_Nos, gamma)

    return VALUES, SECOND_VALUES

def get_allValues_from_T_by_Tstar(T_by_Tstar,gamma):
    rf = RayleighFlow(gamma)
    VALUES = {}
    SECOND_VALUES = None
    Mach_Nos = rf.get_M_from_T_by_Tstar(T_by_Tstar)
    if(type(Mach_Nos) == tuple):
        M1 = Mach_Nos[0]
        M2 = Mach_Nos[1]
        VALUES = get_allValues_from_M(M1, gamma)
        SECOND_VALUES = get_allValues_from_M(M2, gamma)
	
    else:
        VALUES = get_allValues_from_M(Mach_Nos, gamma)

    return VALUES, SECOND_VALUES

def get_allValues_from_To_by_Tostar(To_by_Tostar,gamma):
    rf = RayleighFlow(gamma)
    rf = RayleighFlow(gamma)
    VALUES = {}
    SECOND_VALUES = None
    Mach_Nos = rf.get_M_from_To_by_Tostar(To_by_Tostar)
    if(type(Mach_Nos) == tuple):
        M1 = Mach_Nos[0]
        M2 = Mach_Nos[1]
        VALUES = get_allValues_from_M(M1, gamma)
        SECOND_VALUES = get_allValues_from_M(M2, gamma)
    else:
        VALUES = get_allValues_from_M(Mach_Nos, gamma)

    return VALUES, SECOND_VALUES

def get_allValues_from_rho_by_rhostar(rho_by_rhostar,gamma):
    rf = RayleighFlow(gamma)
    try:
        return get_allValues_from_M(rf.get_M_from_rho_by_rhostar(rho_by_rhostar),gamma)
    except Exception,e:
        raise Exception(e)

def get_allValues_from_Qmax_by_CpT(Qmax_by_CpT,gamma) :
    rf = RayleighFlow(gamma)
    try:
        return get_allValues_from_M(rf.get_M_from_Qmax_by_CpT(Qmax_by_CpT),gamma)
    except Exception,e:
        raise Exception(e)

def get_plotData_from_M(gamma):
    MRange = arange(0.01,10.01,0.1)
    VALUES = {"M" : MRange, "P/P*" :[], "Po/Po*" :[], "T/T*":[], "To/To*":[], "r/r*":[],"Qmax/CpT":[]}
    rf = RayleighFlow(gamma)

    for M in MRange :
        VALUES["P/P*"].append(rf.get_P_by_Pstar_from_M(M))
        VALUES["Po/Po*"].append(rf.get_Po_by_Postar_from_M(M))
        VALUES["T/T*"].append(rf.get_T_by_Tstar_from_M(M))
        VALUES["To/To*"].append(rf.get_To_by_Tostar_from_M(M))
        VALUES["r/r*"].append(rf.get_rho_by_rhostar_from_M(M))
        VALUES["Qmax/CpT"].append(rf.get_Qmax_by_CpT_from_M(M))
    return VALUES
