# FIAIF is an Intelligent firewall
#
# description: Automates a packet filtering firewall with iptables.
#
# Script Author:	Anders Fugmann <afu at fugmann dot net>
# 
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2011 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

## This file contains the patterns and rules used by 'syntax.awk'
## To test the syntax of a zone configuration file.

BEGIN { 
    PATTERN["empty"]             = ""
    PATTERN["any"]               = ".*"
    PATTERN["space"]             = "[ ]+"
    PATTERN["colon"]             = ":"
    PATTERN["slash"]             = "/"
    PATTERN["integer"]           = "[0-9]+"
    PATTERN["hex"]               = "[0-9A-F]+"
    PATTERN["string"]            = "[A-Za-z][a-zA-Z0-9_-]*"
    PATTERN["boolean"]           = "(0|1)"
    PATTERN["zone_name"]         = "#string#"
    PATTERN["filename"]          = "([/]*[A-Za-z0-9_.-]+)+"
    PATTERN["pathname"]          = "[A-Za-z0-9_/.-]*"
    PATTERN["ip"]                = "[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+"
    PATTERN["mask"]              = "(#ip#|#integer#)"
    PATTERN["limit_rate"]        = "(second|minute|hour|day)"
    PATTERN["limit"]             = "#integer#/(#limit_rate#)"
    PATTERN["burst"]             = "#integer#"
    PATTERN["path_list"]         = "#pathname#(:#pathname#)*"
    PATTERN["zone_list"]         = "#zone_name#([ ]+#zone_name#)*"
    PATTERN["module_list"]       = "#string#([ ]+#string#)*"

    # Rules:

    RULE["RESERVED_NETWORKS"]    = "filename"
    RULE["PRIVATE_NETWORKS"]    = "filename"
    RULE["LOOPBACK_NET"] = "ip slash mask"
    RULE["SERVICES"] = "filename"
    RULE["BIN_PATH"] = "(path_list | empty) "
    RULE["DONT_START"] = "(boolean | empty)"
    RULE["CONF_DIR"] = "pathname"
    RULE["ZONES"] = "(zone_list)"
    RULE["CONF"] = "filename"
    RULE["SAVE_STATE"] = "boolean"
    RULE["SET_PROC_ERRORS"] = "boolean"
    RULE["SET_PROC_WARNINGS"] = "boolean"
    RULE["ENABLE_TC"] = "boolean"
    RULE["TEST_FILE"] = "filename"
    RULE["DEBUG"] = "boolean"
    RULE["ENABLE_ULOG"] = "boolean"
    RULE["VERBOSE"] = "boolean"
    RULE["LOG_PREFIX"] = "string"
    RULE["LOG_LEVEL"] = "(integer | string)"
    RULE["LOG_LIMIT"] = "limit"
    RULE["LOG_BURST"] = "burst"
    RULE["MODULES"] = "(module_list | empty)"
    RULE["PRE_SCRIPT"] = "any"
    RULE["POST_SCRIPT"] = "any"
    RULE["PRE_START_SCRIPT"] = "any"
    RULE["POST_START_SCRIPT"] = "any"
    RULE["PRE_STOP_SCRIPT"] = "any"
    RULE["POST_STOP_SCRIPT"] = "any"
    RULE["TOS_FILE"] = "filename"
    RULE["ALIASES"] = "filename"
}
