/* Ergo, version 3.3, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2013 Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */
#define NUMBER 257
#define DOT 258
#define SYMBOL 259
#define EQUAL 260
#define STRING 261
#define EOFTAG 262
#define GETEXC 263
#define GETPOL 264
#define K_ALL 265
#define HELP 266
#define MOLTAG 267
#define GHOSTTAG 268
#define MOLDAL 269
#define QUIT 270
#define RUNTAG 271
#define SYSTEM 272
#define GHOST 273
#define ANGSTROM 274
#define PRECISION 275
#define RANGE 276
#define WARRANTY 277
#define SET_NTHREADS 278
#define PLUS 279
#define MINUS 280
#define TIMES 281
#define DIVIDE 282
#define POWER 283
#define LEFT_PARENTHESIS 284
#define RIGHT_PARENTHESIS 285
#define EOL 286
#define NEG 287
#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
typedef union {
  double num;     /* for returning numbers */
  char str[256];  /* for returning strings */
  struct variable *var; /* for returning lvalues */
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
extern YYSTYPE yylval;
