#! perl

package main;

use strict;
use utf8;

package EB::Wx::IniWiz::OpenDialog;

use base qw(Wx::Dialog);
use strict;
use EB qw(_T);

use Wx qw[wxID_OK wxID_CANCEL
	  wxID_NEW wxID_REMOVE
	  wxID_ANY wxBITMAP_TYPE_ANY
	  wxDefaultPosition wxDefaultSize
	  wxDEFAULT_DIALOG_STYLE
	  wxHORIZONTAL wxVERTICAL wxALIGN_CENTER_VERTICAL
	  wxLEFT wxRIGHT wxALL wxTOP wxBOTTOM
	  wxEXPAND
	  wxLB_SINGLE
	 ];

# Dummy as of Wx 2.8, but still generated by wxGlade.
{ no warnings 'redefine'; sub wxADJUST_MINSIZE() { 0 } }

sub new {
	my( $self, $parent, $id, $title, $pos, $size, $style, $name ) = @_;
	$parent = undef              unless defined $parent;
	$id     = -1                 unless defined $id;
	$title  = ""                 unless defined $title;
	$pos    = wxDefaultPosition  unless defined $pos;
	$size   = wxDefaultSize      unless defined $size;
	$name   = ""                 unless defined $name;

    # begin wxGlade: EB::Wx::IniWiz::OpenDialog::new

    $style = wxDEFAULT_DIALOG_STYLE 
        unless defined $style;

    $self = $self->SUPER::new( $parent, $id, $title, $pos, $size, $style, $name );
    $self->{sizer_6_staticbox} = Wx::StaticBox->new($self, wxID_ANY, _T("Beschikbare administraties") );
    $self->{bm_logo} = Wx::StaticBitmap->new($self, wxID_ANY, Wx::Bitmap->new("ebwiz.jpg", wxBITMAP_TYPE_ANY), wxDefaultPosition, wxDefaultSize, );
    $self->{lb_adm} = Wx::ListBox->new($self, wxID_ANY, wxDefaultPosition, wxDefaultSize, [], wxLB_SINGLE);
    $self->{static_line_1} = Wx::StaticLine->new($self, wxID_ANY, wxDefaultPosition, wxDefaultSize, );
    $self->{b_new} = Wx::Button->new($self, wxID_NEW, "");
    $self->{b_remove} = Wx::Button->new($self, wxID_REMOVE, "");
    $self->{b_cancel} = Wx::Button->new($self, wxID_CANCEL, "");
    $self->{b_accept} = Wx::Button->new($self, wxID_OK, "");

    $self->__set_properties();
    $self->__do_layout();

    Wx::Event::EVT_LISTBOX_DCLICK($self, $self->{lb_adm}->GetId, \&OnSelectAndGo);
    Wx::Event::EVT_BUTTON($self, $self->{b_new}->GetId, \&OnNew);
    Wx::Event::EVT_BUTTON($self, $self->{b_remove}->GetId, \&OnRemove);
    Wx::Event::EVT_BUTTON($self, $self->{b_cancel}->GetId, \&OnCancel);
    Wx::Event::EVT_BUTTON($self, $self->{b_accept}->GetId, \&OnOpen);

    # end wxGlade

	$self->SetSize(0, 0, $self->GetSizeWH);
	$self->Center;
	return $self;

}

sub init {
    my ( $self, $dirs ) = @_;

    $self->{lb_adm}->Append($dirs);
    $self->{lb_adm}->SetSelection(0);
    $self->{lb_adm}->SetFocus;
    $self->{b_accept}->SetFocus if @$dirs == 1;
    $self->{b_new}->SetFocus if @$dirs == 0;
}

sub GetSelection {
    my ( $self ) = @_;
    $self->{lb_adm}->GetSelection;
}

sub __set_properties {
    my $self = shift;

    # begin wxGlade: EB::Wx::IniWiz::OpenDialog::__set_properties

    $self->SetTitle(_T("Administratiekeuze"));
    $self->SetSize(Wx::Size->new(776, 376));
    $self->{lb_adm}->SetSelection(0);

    # end wxGlade
}

sub __do_layout {
	my $self = shift;

    # begin wxGlade: EB::Wx::IniWiz::OpenDialog::__do_layout

    $self->{sizer_1} = Wx::BoxSizer->new(wxHORIZONTAL);
    $self->{sizer_1a} = Wx::BoxSizer->new(wxVERTICAL);
    $self->{sizer_2} = Wx::BoxSizer->new(wxVERTICAL);
    $self->{sizer_3} = Wx::BoxSizer->new(wxHORIZONTAL);
    $self->{sizer_5} = Wx::BoxSizer->new(wxHORIZONTAL);
    $self->{sizer_6}= Wx::StaticBoxSizer->new($self->{sizer_6_staticbox}, wxVERTICAL);
    $self->{sizer_7} = Wx::BoxSizer->new(wxVERTICAL);
    $self->{sizer_7}->Add($self->{bm_logo}, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 0);
    $self->{sizer_5}->Add($self->{sizer_7}, 0, wxRIGHT|wxEXPAND, 15);
    $self->{sizer_6}->Add($self->{lb_adm}, 1, wxALL|wxEXPAND|wxADJUST_MINSIZE, 2);
    $self->{sizer_5}->Add($self->{sizer_6}, 1, wxEXPAND, 0);
    $self->{sizer_2}->Add($self->{sizer_5}, 1, wxEXPAND, 0);
    $self->{sizer_2}->Add($self->{static_line_1}, 0, wxTOP|wxBOTTOM|wxEXPAND, 10);
    $self->{sizer_3}->Add(5, 5, 1, wxEXPAND|wxADJUST_MINSIZE, 0);
    $self->{sizer_3}->Add($self->{b_new}, 0, wxADJUST_MINSIZE, 0);
    $self->{sizer_3}->Add($self->{b_remove}, 0, wxLEFT|wxADJUST_MINSIZE, 5);
    $self->{sizer_3}->Add($self->{b_cancel}, 0, wxLEFT|wxRIGHT|wxADJUST_MINSIZE, 5);
    $self->{sizer_3}->Add($self->{b_accept}, 0, wxADJUST_MINSIZE, 0);
    $self->{sizer_2}->Add($self->{sizer_3}, 0, wxEXPAND, 0);
    $self->{sizer_1a}->Add($self->{sizer_2}, 1, wxEXPAND, 5);
    $self->{sizer_1}->Add($self->{sizer_1a}, 1, wxALL|wxEXPAND, 10);
    $self->SetSizer($self->{sizer_1});
    $self->Layout();

    # end wxGlade
}

sub OnNew {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OpenDialog::OnNew <event_handler>

    $self->EndModal( wxID_NEW );

# end wxGlade
}

sub OnRemove {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OpenDialog::OnRemove <event_handler>

    $self->EndModal( wxID_REMOVE );

# end wxGlade
}

sub OnCancel {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OpenDialog::OnCancel <event_handler>

    $self->EndModal( wxID_CANCEL );

# end wxGlade
}

sub OnOpen {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OpenDialog::OnOpen <event_handler>

    $self->EndModal( wxID_OK );

# end wxGlade
}

sub OnSelectAndGo {
    my ($self, $event) = @_;
# wxGlade: EB::Wx::IniWiz::OpenDialog::OnSelectAndGo <event_handler>

    $self->EndModal( wxID_OK );

# end wxGlade
}


# end of class EB::Wx::IniWiz::OpenDialog

1;
