/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import dumphd.util.ByteArray;
import dumphd.util.TSParserException;

public class TSAlignedUnit {
    public static final int UNIT_LENGTH = 6144;
    public static final int PACKET_LENGTH = 192;
    private byte[] unit = null;
    private int unitOffset = 0;

    public void parse(byte[] unit, int offset) throws TSParserException {
        if (offset + 6144 > unit.length) {
            throw new TSParserException("Aligned Unit data too small");
        }
        this.unit = unit;
        this.unitOffset = offset;
    }

    public boolean isEncrypted() {
        return ByteArray.getUByte(this.unit, this.unitOffset) >>> 6 != 0;
    }

    public void setEncrypted(boolean encrypted) {
        int i = this.unitOffset;
        while (i < this.unitOffset + 6144) {
            this.unit[i] = (byte)(this.unit[i] & 0x3F);
            if (encrypted) {
                this.unit[i] = (byte)(this.unit[i] | 0xC0);
            }
            i += 192;
        }
    }
}

