/*
 * Copyright (C) 2016 ~ 2018 Deepin Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef BLUREFRAME_H
#define BLUREFRAME_H

#include <QFrame>
#include <DBlurEffectWidget>
#include <QMouseEvent>

DWIDGET_USE_NAMESPACE

class BlurFrame : public DBlurEffectWidget
{
    Q_OBJECT
    Q_PROPERTY(QPoint pos READ pos WRITE setPos)
public:
    explicit BlurFrame(QWidget *parent);
    void moveWithAnimation(int x, int y);

    QColor  getBorderColor() const;
    int     getBorderRadius() const;
    int     getBorderWidth() const;

    void setBorderColor(const QColor &borderColor);
    void setBorderRadius(int borderRadius);
    void setBorderWidth(int borderWidth);
    void setCoverBrush(const QBrush &brush);
    void setPos(const QPoint &pos);
    void setMoveEnable(bool move);

signals:
    void requestStopAnimation();

protected:
    void keyPressEvent(QKeyEvent *e) override;
    void paintEvent(QPaintEvent *e) override;
    void mousePressEvent(QMouseEvent *event) override;
    void mouseMoveEvent(QMouseEvent *event) override;
    void mouseReleaseEvent(QMouseEvent *event) override;

private:
    QColor  m_borderColor;
    int     m_borderRadius;
    int     m_borderWidth;
    QBrush  m_coverBrush;
    QPoint m_dragPos;
    bool m_moveEnable = false;
};

#endif // BLUREFRAME_H
