// Copyright 2017-2018 - Universite de Strasbourg/CNRS
// The CDS HEALPix library is developped by the Centre de Donnees
// astronomiques de Strasbourgs (CDS) from the following external papers:
//  - [Gorsky2005]     - "HEALPix: A Framework for High-Resolution Discretization and
//                       Fast Analysis of Data Distributed on the Sphere"
//                       http://adsabs.harvard.edu/abs/2005ApJ...622..759G
//  - [Calabretta2004] - "Mapping on the HEALPix grid"
//                       http://adsabs.harvard.edu/abs/2004astro.ph.12607C
//  - [Calabretta2007] - "Mapping on the HEALPix grid"
//                       http://adsabs.harvard.edu/abs/2007MNRAS.381..865C
//  - [Reinecke2015]   - "Efficient data structures for masks on 2D grids"
//                       http://adsabs.harvard.edu/abs/2015A&A...580A.132R
// It is distributed under the terms of the BSD License 2.0
//
// This file is part of the CDS HEALPix library.
//

/**
* Implementation of the HEALPix framework.<br>
* Reference papers are:
* <ul>
*   <li>[Gorsky2005] - "HEALPix: A Framework for High-Resolution Discretization and Fast Analysis of Data
*                 Distributed on the Sphere", G&oacute;rski, K. M. et al., 2005; 
*                 <a href="http://adsabs.harvard.edu/abs/2005ApJ...622..759G">2005ApJ...622..759G</a>.</li>
*   <li>[Calabretta2004] - "Mapping on the HEALPix grid", Calabretta, M. R., 2004;
*                <a href="http://adsabs.harvard.edu/abs/2004astro.ph.12607C">2004astro.ph.12607C</a>.</li>
*   <li>[Calabretta2007] - "Mapping on the HEALPix grid", Calabretta, M. R. et Roukema, B. F., 2007; 
*                <a href="http://adsabs.harvard.edu/abs/2007MNRAS.381..865C">2007MNRAS.381..865C</a>.</li>
*   <li>[Reinecke2015] - "Efficient data structures for masks on 2D grids",  Reinecke, M.; Hivon, E., 2015;
*      <a href="http://adsabs.harvard.edu/abs/2015A&A...580A.132R">2015A&amp;A...580A.132R</a>.</li>
* </ul>
* @author F.-X. Pineau
*/
package cds.healpix;
