{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetLoop: Boolean;
    procedure SetLoop(const Value: Boolean);
    function GetPauseTime: TFloatTime;
    procedure SetPauseTime(const Value: TFloatTime);
    function GetResumeTime: TFloatTime;
    procedure SetResumeTime(const Value: TFloatTime);
    function GetStartTime: TFloatTime;
    procedure SetStartTime(const Value: TFloatTime);
    function GetStopTime: TFloatTime;
    procedure SetStopTime(const Value: TFloatTime);
  public
    { X3D field "loop". } { }
    property Loop: Boolean read GetLoop write SetLoop;
    { X3D field "pauseTime". } { }
    property PauseTime: TFloatTime read GetPauseTime write SetPauseTime;
    { X3D field "resumeTime". } { }
    property ResumeTime: TFloatTime read GetResumeTime write SetResumeTime;
    { X3D field "startTime". } { }
    property StartTime: TFloatTime read GetStartTime write SetStartTime;
    { X3D field "stopTime". } { }
    property StopTime: TFloatTime read GetStopTime write SetStopTime;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractTimeDependentNode ----------------------------------------------- }

function TAbstractTimeDependentNode.GetLoop: Boolean;
begin
  Result := FdLoop.Value;
end;

procedure TAbstractTimeDependentNode.SetLoop(const Value: Boolean);
begin
  FdLoop.Send(Value);
end;

function TAbstractTimeDependentNode.GetPauseTime: TFloatTime;
begin
  Result := FdPauseTime.Value;
end;

procedure TAbstractTimeDependentNode.SetPauseTime(const Value: TFloatTime);
begin
  FdPauseTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetResumeTime: TFloatTime;
begin
  Result := FdResumeTime.Value;
end;

procedure TAbstractTimeDependentNode.SetResumeTime(const Value: TFloatTime);
begin
  FdResumeTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetStartTime: TFloatTime;
begin
  Result := FdStartTime.Value;
end;

procedure TAbstractTimeDependentNode.SetStartTime(const Value: TFloatTime);
begin
  FdStartTime.Send(Value);
end;

function TAbstractTimeDependentNode.GetStopTime: TFloatTime;
begin
  Result := FdStopTime.Value;
end;

procedure TAbstractTimeDependentNode.SetStopTime(const Value: TFloatTime);
begin
  FdStopTime.Send(Value);
end;

{$endif read_implementation}
