{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAmbientIntensity: Single;
    procedure SetAmbientIntensity(const Value: Single);
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
    function GetGlobal: Boolean;
    procedure SetGlobal(const Value: Boolean);
    function GetIntensity: Single;
    procedure SetIntensity(const Value: Single);
    function GetIsOn: Boolean;
    procedure SetIsOn(const Value: Boolean);
    function GetShadowVolumes: Boolean;
    procedure SetShadowVolumes(const Value: Boolean);
  public
    { X3D field "ambientIntensity". } { }
    property AmbientIntensity: Single read GetAmbientIntensity write SetAmbientIntensity;
    { X3D field "color". } { }
    property Color: TCastleColorRGB read GetColor write SetColor;
    { X3D field "global". } { }
    property Global: Boolean read GetGlobal write SetGlobal;
    { X3D field "intensity". } { }
    property Intensity: Single read GetIntensity write SetIntensity;
    { X3D field "on". } { }
    property IsOn: Boolean read GetIsOn write SetIsOn;
    { Set X3D field "effects". } { }
    procedure SetEffects(const Value: array of TEffectNode);
    { X3D field "shadowVolumes". } { }
    property ShadowVolumes: Boolean read GetShadowVolumes write SetShadowVolumes;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractLightNode ----------------------------------------------- }

function TAbstractLightNode.GetAmbientIntensity: Single;
begin
  Result := FdAmbientIntensity.Value;
end;

procedure TAbstractLightNode.SetAmbientIntensity(const Value: Single);
begin
  FdAmbientIntensity.Send(Value);
end;

function TAbstractLightNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TAbstractLightNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

function TAbstractLightNode.GetGlobal: Boolean;
begin
  Result := FdGlobal.Value;
end;

procedure TAbstractLightNode.SetGlobal(const Value: Boolean);
begin
  FdGlobal.Send(Value);
end;

function TAbstractLightNode.GetIntensity: Single;
begin
  Result := FdIntensity.Value;
end;

procedure TAbstractLightNode.SetIntensity(const Value: Single);
begin
  FdIntensity.Send(Value);
end;

function TAbstractLightNode.GetIsOn: Boolean;
begin
  Result := FdOn.Value;
end;

procedure TAbstractLightNode.SetIsOn(const Value: Boolean);
begin
  FdOn.Send(Value);
end;

procedure TAbstractLightNode.SetEffects(const Value: array of TEffectNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TEffectNode));
  FdEffects.Send(A);
end;

function TAbstractLightNode.GetShadowVolumes: Boolean;
begin
  Result := FdShadowVolumes.Value;
end;

procedure TAbstractLightNode.SetShadowVolumes(const Value: Boolean);
begin
  FdShadowVolumes.Send(Value);
end;

{$endif read_implementation}
