{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetNormal: TAbstractNormalNode;
    procedure SetNormal(const Value: TAbstractNormalNode);
    function GetTexCoord: TAbstractTextureCoordinateNode;
    procedure SetTexCoord(const Value: TAbstractTextureCoordinateNode);
    function GetYScale: Single;
    procedure SetYScale(const Value: Single);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
    function GetColorPerVertex: Boolean;
    procedure SetColorPerVertex(const Value: Boolean);
    function GetCreaseAngle: Double;
    procedure SetCreaseAngle(const Value: Double);
    function GetGeoGridOrigin: TVector3Double;
    procedure SetGeoGridOrigin(const Value: TVector3Double);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
    function GetNormalPerVertex: Boolean;
    procedure SetNormalPerVertex(const Value: Boolean);
    function GetXDimension: Integer;
    procedure SetXDimension(const Value: Integer);
    function GetXSpacing: Double;
    procedure SetXSpacing(const Value: Double);
    function GetZDimension: Integer;
    procedure SetZDimension(const Value: Integer);
    function GetZSpacing: Double;
    procedure SetZSpacing(const Value: Double);
  public
    { X3D field "color". } { }
    property Color: TAbstractColorNode read GetColor write SetColor;
    { X3D field "normal". } { }
    property Normal: TAbstractNormalNode read GetNormal write SetNormal;
    { X3D field "texCoord". } { }
    property TexCoord: TAbstractTextureCoordinateNode read GetTexCoord write SetTexCoord;
    { X3D field "yScale". } { }
    property YScale: Single read GetYScale write SetYScale;
    { X3D field "ccw". } { }
    property Ccw: Boolean read GetCcw write SetCcw;
    { X3D field "colorPerVertex". } { }
    property ColorPerVertex: Boolean read GetColorPerVertex write SetColorPerVertex;
    { X3D field "creaseAngle". } { }
    property CreaseAngle: Double read GetCreaseAngle write SetCreaseAngle;
    { X3D field "geoGridOrigin". } { }
    property GeoGridOrigin: TVector3Double read GetGeoGridOrigin write SetGeoGridOrigin;
    { X3D field "geoOrigin". } { }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: array of string);
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: TCastleStringList);
    { Set X3D field "height". } { }
    procedure SetHeight(const Value: array of Double);
    { Set X3D field "height". } { }
    procedure SetHeight(const Value: TDoubleList);
    { X3D field "normalPerVertex". } { }
    property NormalPerVertex: Boolean read GetNormalPerVertex write SetNormalPerVertex;
    { X3D field "xDimension". } { }
    property XDimension: Integer read GetXDimension write SetXDimension;
    { X3D field "xSpacing". } { }
    property XSpacing: Double read GetXSpacing write SetXSpacing;
    { X3D field "zDimension". } { }
    property ZDimension: Integer read GetZDimension write SetZDimension;
    { X3D field "zSpacing". } { }
    property ZSpacing: Double read GetZSpacing write SetZSpacing;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoElevationGridNode ----------------------------------------------- }

function TGeoElevationGridNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TGeoElevationGridNode.GetNormal: TAbstractNormalNode;
begin
  if FdNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdNormal.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetNormal(const Value: TAbstractNormalNode);
begin
  FdNormal.Send(Value);
end;

function TGeoElevationGridNode.GetTexCoord: TAbstractTextureCoordinateNode;
begin
  if FdTexCoord.Value is TAbstractTextureCoordinateNode then
    Result := TAbstractTextureCoordinateNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetTexCoord(const Value: TAbstractTextureCoordinateNode);
begin
  FdTexCoord.Send(Value);
end;

function TGeoElevationGridNode.GetYScale: Single;
begin
  Result := FdYScale.Value;
end;

procedure TGeoElevationGridNode.SetYScale(const Value: Single);
begin
  FdYScale.Send(Value);
end;

function TGeoElevationGridNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TGeoElevationGridNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

function TGeoElevationGridNode.GetColorPerVertex: Boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TGeoElevationGridNode.SetColorPerVertex(const Value: Boolean);
begin
  FdColorPerVertex.Send(Value);
end;

function TGeoElevationGridNode.GetCreaseAngle: Double;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TGeoElevationGridNode.SetCreaseAngle(const Value: Double);
begin
  FdCreaseAngle.Send(Value);
end;

function TGeoElevationGridNode.GetGeoGridOrigin: TVector3Double;
begin
  Result := FdGeoGridOrigin.Value;
end;

procedure TGeoElevationGridNode.SetGeoGridOrigin(const Value: TVector3Double);
begin
  FdGeoGridOrigin.Send(Value);
end;

function TGeoElevationGridNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoElevationGridNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoElevationGridNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoElevationGridNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoElevationGridNode.SetHeight(const Value: array of Double);
begin
  FdHeight.Send(Value);
end;

procedure TGeoElevationGridNode.SetHeight(const Value: TDoubleList);
begin
  FdHeight.Send(Value);
end;

function TGeoElevationGridNode.GetNormalPerVertex: Boolean;
begin
  Result := FdNormalPerVertex.Value;
end;

procedure TGeoElevationGridNode.SetNormalPerVertex(const Value: Boolean);
begin
  FdNormalPerVertex.Send(Value);
end;

function TGeoElevationGridNode.GetXDimension: Integer;
begin
  Result := FdXDimension.Value;
end;

procedure TGeoElevationGridNode.SetXDimension(const Value: Integer);
begin
  FdXDimension.Send(Value);
end;

function TGeoElevationGridNode.GetXSpacing: Double;
begin
  Result := FdXSpacing.Value;
end;

procedure TGeoElevationGridNode.SetXSpacing(const Value: Double);
begin
  FdXSpacing.Send(Value);
end;

function TGeoElevationGridNode.GetZDimension: Integer;
begin
  Result := FdZDimension.Value;
end;

procedure TGeoElevationGridNode.SetZDimension(const Value: Integer);
begin
  FdZDimension.Send(Value);
end;

function TGeoElevationGridNode.GetZSpacing: Double;
begin
  Result := FdZSpacing.Value;
end;

procedure TGeoElevationGridNode.SetZSpacing(const Value: Double);
begin
  FdZSpacing.Send(Value);
end;

{$endif read_implementation}
