{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetUseGeometry: Boolean;
    procedure SetUseGeometry(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdCollidables: TMFNode;
    { X3D field "collidables". } { }
    public property FdCollidables: TMFNode read FFdCollidables;

    strict private FFdUseGeometry: TSFBool;
    { X3D field "useGeometry". } { }
    public property FdUseGeometry: TSFBool read FFdUseGeometry;
    { X3D field "useGeometry". } { }
    property UseGeometry: Boolean read GetUseGeometry write SetUseGeometry;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollisionSpaceNode ----------------------------------------------- }

function TCollisionSpaceNode.GetUseGeometry: Boolean;
begin
  Result := FdUseGeometry.Value;
end;

procedure TCollisionSpaceNode.SetUseGeometry(const Value: Boolean);
begin
  FdUseGeometry.Send(Value);
end;

class function TCollisionSpaceNode.ClassX3DType: String;
begin
  Result := 'CollisionSpace';
end;

procedure TCollisionSpaceNode.CreateNode;
begin
  inherited;

  FFdCollidables := TMFNode.Create(Self, True, 'collidables', [TAbstractNBodyCollisionSpaceNode, TAbstractNBodyCollidableNode]);
   FdCollidables.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCollidables);

  FFdUseGeometry := TSFBool.Create(Self, True, 'useGeometry', false);
   FdUseGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUseGeometry);

  DefaultContainerField := 'children';
end;

{$endif read_implementation}
