/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.misc.PatternPaint;
import com.kreative.rsrc.pict.ColorTable;
import com.kreative.rsrc.pict.PICTUtilities;
import com.kreative.rsrc.pict.PixMap;
import com.kreative.rsrc.pict.RGBColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class PixelPatternResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1886413172;

    public static boolean isMyType(int type) {
        return type == 1886413172;
    }

    public PixelPatternResource(short id, byte[] data) {
        super(1886413172, id, data);
    }

    public PixelPatternResource(short id, String name, byte[] data) {
        super(1886413172, id, name, data);
    }

    public PixelPatternResource(short id, byte attr, byte[] data) {
        super(1886413172, id, attr, data);
    }

    public PixelPatternResource(short id, byte attr, String name, byte[] data) {
        super(1886413172, id, attr, name, data);
    }

    public PixelPatternResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public PixelPatternResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public PixelPatternResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public PixelPatternResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public Paint toPaint(Paint fg, Paint bg) {
        try {
            return PixelPattern.read(this.data).toPaint(fg, bg);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static class PixelPattern {
        public static final int DITHER_PAT = 2;
        public static final int PIXEL_PAT = 1;
        public int patType;
        public int pmHandle;
        public int pdHandle;
        public long pat1Data;
        public RGBColor rgb;
        public PixMap pixMap;
        public ColorTable colorTable;
        public byte[] pixData;

        private PixelPattern() {
        }

        public static PixelPattern read(byte[] data) throws IOException {
            PixelPattern pp = new PixelPattern();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            pp.patType = in.readShort();
            pp.pmHandle = in.readInt();
            pp.pdHandle = in.readInt();
            in.readInt();
            in.readShort();
            in.readInt();
            pp.pat1Data = in.readLong();
            switch (pp.patType) {
                case 2: {
                    pp.rgb = RGBColor.read(in);
                    pp.pixMap = null;
                    pp.colorTable = null;
                    pp.pixData = null;
                    break;
                }
                case 1: {
                    pp.rgb = null;
                    in = new DataInputStream(new ByteArrayInputStream(data));
                    in.skip(pp.pmHandle);
                    pp.pixMap = PixMap.read(in, true);
                    in = new DataInputStream(new ByteArrayInputStream(data));
                    in.skip(pp.pixMap.pmTable);
                    pp.colorTable = pp.pixMap.hasColorTable() ? ColorTable.read(in) : null;
                    in = new DataInputStream(new ByteArrayInputStream(data));
                    in.skip(pp.pdHandle);
                    pp.pixData = pp.pixMap.readPixData(in, false);
                    break;
                }
                default: {
                    pp.rgb = null;
                    pp.pixMap = null;
                    pp.colorTable = null;
                    pp.pixData = null;
                }
            }
            return pp;
        }

        public Paint toPaint(Paint fg, Paint bg) {
            if (this.pixMap != null) {
                BufferedImage bi = PICTUtilities.pixmapToImage(this.pixMap, this.colorTable, this.pixData, PixelPattern.paintToRGB(bg), PixelPattern.paintToRGB(fg), true, false);
                return new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
            }
            if (this.rgb != null) {
                return this.rgb.toColor();
            }
            return new PatternPaint(fg, bg, this.pat1Data);
        }

        private static int paintToRGB(Paint p) {
            if (p instanceof Color) {
                return ((Color)p).getRGB();
            }
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D g = img.createGraphics();
            g.setPaint(p);
            g.fillRect(0, 0, 1, 1);
            g.dispose();
            return img.getRGB(0, 0);
        }
    }
}

