/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-glade.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#include "ianjuta-glade.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_glade_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-glade-quark");
	}
	
	return quark;
}

/**
 * ianjuta_add_association:
 * @obj: Self
 * @master: ui file name.
 * @slave: source code file name.
 * @err: Error propagation and reporting.
 *
 * Adds an association of master ui file and slave source code file
 *
 */
void
ianjuta_glade_add_association (IAnjutaGlade *obj, gchar *master,   gchar *slave, GError **err)
{
	g_return_if_fail (IANJUTA_IS_GLADE(obj));
	IANJUTA_GLADE_GET_IFACE (obj)->add_association (obj, master, slave, err);
}

/* Default implementation */
static void
ianjuta_glade_add_association_default (IAnjutaGlade *obj, gchar *master,   gchar *slave, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_glade_base_init (IAnjutaGladeIface* klass)
{
	static gboolean initialized = FALSE;

	klass->add_association = ianjuta_glade_add_association_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_glade_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaGladeIface),
			(GBaseInitFunc) ianjuta_glade_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaGlade", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
