/*
 * Plasma XR Applet
 * Copyright 2018 Collabora Ltd.
 * Author: Christoph Haag <christoph.haag@collabora.com>
 * Author: Lubosz Sarnecki <lubosz.sarnecki@collabora.com>
 * SPDX-License-Identifier: MIT
 */


import QtQuick 2.5
import QtQuick.Layouts 1.1
import QtQuick.Controls 1.4
import QtQuick.Controls.Styles 1.4
import org.kde.plasma.plasmoid 2.0
import org.kde.plasma.core 2.0 as PlasmaCore
import QtQuick.Dialogs 1.1



CheckBox {
	id: checkbox
	text: "xrdesktop"
	Plasmoid.icon: plasmoid.file("images", "../images/vr-symbolic.svg")

	// after an error, when setting the checkbox to off, don't trigger the error message again
	property bool skip_processing: false

	MessageDialog {
		id: messageDialog
		title: "Error calling XR desktop dbus interface"
		// default text that should be replaced before showing the dialog
		text: "An error occured"
		onAccepted: {
			checkbox.skip_processing = true
			checkbox.checked = false
			//console.log("And of course you could only agree.")
		}
		Component.onCompleted: visible = false
	}

	function toggleAction(checked) {
		console.info("xrdesktop enabled: " + checked)
		execToggle.connectSource('qdbus org.kde.KWin /XR org.kde.kwin.XR.active ' + checked)
	}

	onCheckedChanged: toggleAction(checked)

	PlasmaCore.DataSource {
		id: execToggle
		engine: "executable"
		connectedSources: []
		onNewData: {
			//console.info("Toggle reply: " + data.stdout + "; " + data.stderr)
			if (data.stderr !== "") {

				// the checkbox is being set to false as a result of an error, don't do anything'
				if (checkbox.skip_processing) {
					checkbox.skip_processing = false
					disconnectSource(sourceName)
					return
				}

				messageDialog.text = "Error toggling xrdesktop mode in KWin:\n"
				messageDialog.text += data.stderr + "\n"
				if (data.stderr.toString().match("^Cannot find"))  {
					messageDialog.text += "Usually this means the xrdesktop plugin is not enabled in KWin or not working."
				}
				messageDialog.visible = true
			}
			if (data.stdout !== "") {
				// TODO: handle error
			}
			disconnectSource(sourceName)
		}
	}



	PlasmaCore.DataSource {
		id: execQuery
		engine: "executable"
		connectedSources: []
		onNewData: {
			//console.info("Timer query reply: " + data.stdout + "; " + data.stderr)
			if (data.stderr == "") {
				var val = false
				if (data.stdout.toString().match("^true")) {
					val = true
				}
				checkbox.skip_processing = true
				checkbox.checked = val
				checkbox.skip_processing = false
			}
			disconnectSource(sourceName)
		}
	}
	Timer {
		id: timer;
		interval: 2000;
		onTriggered: {
			execQuery.connectSource('qdbus org.kde.KWin /XR org.kde.kwin.XR.active');
		}
		repeat: true;
		running: true;
	}
}

