/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;

public class TLMMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int n) throws IOException {
        int n2 = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int n3 = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int n4 = (n3 & 0x30) >> 4;
        int n5 = (n3 & 0x40) >> 6;
        int n6 = n5 == 1 ? 4 : 2;
        switch (n4) {
            case 1: {
                ++n6;
                break;
            }
            case 2: {
                n6 += 2;
                break;
            }
            case 3: {
                this._repInfo.setMessage(new ErrorMessage("Invalid ST value in TLM marker segment"));
                return false;
            }
        }
        int n7 = (n - 2) / n6;
        if (n7 * n6 != n - 2) {
            return false;
        }
        if (this._ccs.getCurTile() != null) {
            return false;
        }
        for (int i = 0; i < n7; ++i) {
            int n8;
            ArrayList<Property> arrayList = new ArrayList<Property>(2);
            if (n4 != 0) {
                n8 = n4 == 1 ? ModuleBase.readUnsignedByte(this._dstream, this._module) : this._module.readUnsignedShort(this._dstream);
                arrayList.add(new Property("Index", PropertyType.INTEGER, new Integer(n8)));
            }
            n8 = n5 == 1 ? (int)this._module.readUnsignedInt(this._dstream) : this._module.readUnsignedShort(this._dstream);
            arrayList.add(new Property("Length", PropertyType.INTEGER, new Integer(n8)));
            this._cs.addTileLength(new Property("TilePartLength", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
        return true;
    }
}

