/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;

public class WDump
extends Dump {
    private static final int[] sigByte = new int[]{82, 73, 70, 70};
    private static final boolean ENDIAN = false;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("usage: java WDump file");
            System.exit(-1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            ADump aDump = new ADump();
            long l = 0L;
            for (int i = 0; i < 4; ++i) {
                int n = dataInputStream.readUnsignedByte();
                if (n != sigByte[i]) {
                    System.out.println("No AIFF FORM header");
                    System.exit(-2);
                }
                ++l;
            }
            long l2 = ModuleBase.readUnsignedInt(dataInputStream, false);
            l += 4L;
            String string = WDump.read4Chars(dataInputStream);
            l += 4L;
            System.out.println("00000000: RIFF " + l2 + ": " + string);
            boolean bl = false;
            while (!bl) {
                try {
                    String string2 = WDump.read4Chars(dataInputStream);
                    l2 = ModuleBase.readUnsignedInt(dataInputStream, false);
                    System.out.print(WDump.leading(l, 8) + l + ": " + string2 + " " + l2);
                    long l3 = 0L;
                    if (string2.equals("fact")) {
                        long l4 = ModuleBase.readUnsignedInt(dataInputStream, false);
                        System.out.print(": " + l4);
                        l3 = 4L;
                    } else if (string2.equals("fmt ")) {
                        int n = ModuleBase.readUnsignedShort(dataInputStream, false);
                        int n2 = ModuleBase.readUnsignedShort(dataInputStream, false);
                        long l5 = ModuleBase.readUnsignedInt(dataInputStream, false);
                        long l6 = ModuleBase.readUnsignedInt(dataInputStream, false);
                        int n3 = ModuleBase.readUnsignedShort(dataInputStream, false);
                        String string3 = Integer.toHexString(n);
                        System.out.print(": 0x" + WDump.leading(string3, 4) + string3 + " " + n2 + " " + l5 + " " + l6 + " " + n3);
                        l3 = 14L;
                        if (l2 > 14L) {
                            int n4 = ModuleBase.readUnsignedShort(dataInputStream, false);
                            System.out.print(" " + n4);
                            l3 = 16L;
                            if (l2 > 16L) {
                                int n5 = ModuleBase.readUnsignedShort(dataInputStream, false);
                                System.out.print(" " + n5);
                                l3 = 18L;
                                if (n5 == 22) {
                                    int n6 = ModuleBase.readUnsignedShort(dataInputStream, false);
                                    long l7 = ModuleBase.readUnsignedInt(dataInputStream, false);
                                    string3 = Long.toHexString(l7);
                                    System.out.print(" " + n6 + " 0x" + WDump.leading(string3, 8) + string3 + " 0x");
                                    for (int i = 0; i < 4; ++i) {
                                        long l8 = ModuleBase.readUnsignedInt(dataInputStream, false);
                                        string3 = Long.toHexString(l8);
                                        System.out.print(WDump.leading(string3, 8) + string3);
                                    }
                                    l3 = 40L;
                                }
                            }
                        }
                    }
                    System.out.println();
                    if (string2.equals("list") || string2.equals("LIST")) {
                        WDump.readNestedChunks(string2, dataInputStream, l2, l + 8L);
                    } else {
                        dataInputStream.skipBytes((int)(l2 - l3));
                    }
                    l += l2 + 8L;
                }
                catch (EOFException eOFException) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void readNestedChunks(String string, DataInputStream dataInputStream, long l, long l2) throws IOException {
        String string2 = WDump.read4Chars(dataInputStream);
        System.out.println("List type = " + string2);
        while (l > 0L) {
            String string3 = WDump.read4Chars(dataInputStream);
            long l3 = ModuleBase.readUnsignedInt(dataInputStream, false, null);
            System.out.println(WDump.leading(l2, 8) + l2 + ": " + string + "/" + string3 + " " + l3);
            dataInputStream.skipBytes((int)l3);
            l2 += l3 + 8L;
            l -= l3 + 8L;
        }
    }

    private static String read4Chars(DataInputStream dataInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int n = ModuleBase.readUnsignedByte(dataInputStream, null);
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

