// Editeur de playlist Freebox
// Copyright (C) 2005 Freebox S.A.
//
// vlcopt.h
// This file is part of fbx-playlist.
//
// fbx-playlist is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// fbx-playlist is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with fbx-playlist; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

#ifndef _VLCOPT_H_
#define _VLCOPT_H_

static const char *opt_jpg[] = {
    "sout=#transcode:std",
    "sout-transcode-width=720",
    "sout-transcode-height=576",
    "fake-aspect-ratio=4:3",
    "fake-keep-ar",
    "fake-deinterlace",
    "deinterlace-mode=blend",
    "sout-transcode-vb=9000",
    "sout-transcode-vcodec=mp2v",
    "sout-transcode-vt=1000000",
    "sout-ffmpeg-keyint=8",
    "sout-ffmpeg-interlace",
    "no-sout-ffmpeg-interlace-me",
};

static const char *opt_avi[] = {
    "sout=#transcode:std",
    "sout-transcode-ab=256",
    "sout-transcode-acodec=mpga",
    "sout-transcode-channels=2",
    "sout-transcode-vb=9000",
    "sout-transcode-vcodec=mp2v",
    "sout-transcode-vt=1000000",
    "sout-transcode-fps=25.0",
    "sout-transcode-soverlay",
    "sout-ffmpeg-keyint=24",
    "sout-ffmpeg-interlace",
    "no-sout-ffmpeg-interlace-me",
    "file-caching=1000",
};

static const char *opt_avi_dolby[] = {
    "sout=#transcode:std",
    "sout-transcode-vb=9000",
    "sout-transcode-vcodec=mp2v",
    "sout-transcode-vt=1000000",
    "sout-transcode-fps=25.0",
    "sout-transcode-soverlay",
    "sout-ffmpeg-keyint=24",
    "sout-ffmpeg-interlace",
    "no-sout-ffmpeg-interlace-me",
    "file-caching=1000",
};

static const char *opt_dvd[] = {
    "sout=#transcode:std",
    "sout-transcode-ab=256",
    "sout-transcode-acodec=mpga",
    "sout-transcode-channels=2",
    "dvd-caching=500",
};

static const struct {
    const char *ext;
    int opt;
} ext_to_opt[] = {
    { ".mpg",    0 },
    { ".ts",     0 },
    { ".mp2",    0 },
    { ".mpeg",   0 },

    { ".vob",    1 },

    { ".avi",    2 },
    { ".ogg",    2 },
    { ".mp3",    2 },
    { ".mkv",    2 },
    { ".mp4",    2 },
    { ".mov",    2 },
    { ".aac",    2 },
    { ".au",     2 },
    { ".aif",    2 },
    { ".aiff",   2 },
    { ".mjpeg",  2 },
    { ".wmv",    2 },
    { ".wma",    2 },
    { ".wav",    2 },
    { ".asf",    2 },
    { ".ogm",    2 },
    { ".divx",   2 },

    { ".jpeg",   3 },
    { ".jpg",    3 },
    { ".ljpg",   3 },
    { ".png",    3 },
    { ".pgm",    3 },
    { ".pgmyuv", 3 },
    { ".pbm",    3 },
    { ".pam",    3 },
    { ".tga",    3 },
    { ".bmp",    3 },
    { ".pnm",    3 },
    { ".xpm",    3 },
    { ".xcf",    3 },
    { ".gif",    3 },
    { ".tif",    3 },
    { ".tiff",   3 },
    { ".lbm",    3 },
};

#endif // _VLCOPT_H_
