/*
    LIB - a librarian for compatible OBJ/LIB files
    Copyright (C) 1995,1996  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: LIST.H 3.3 1999/02/17 05:18:08 ska Rel ska $
   $Locker: ska $	$Name: v3_2 $	$State: Rel $

	List hndling functions

*/

#ifndef __LIST_H
#define __LIST_H

struct cmdList {
	int fl_flags;
	char fl_name[1];	/* dynamicly grow */
};

extern word farBlkHead;		/* head of the far block list */

void appList(int flags, char *s, int upcase);
/* append a new item to the list; s is upper-cased after return if upcase != 0
*/

struct cmdList *inList(int flags, char *s, int upcase);
/* check, if the item s is in the list head; s is upper-cased after return
	if upcase != 0
   At least one of the bits of flags must be set.
   Return the name of the matched item or NULL, if none was found.
*/

void Fupdate(void);
/* update the last retreival of the inList() function call */

word Falloc(word paragraphes);
/* Far allocate of paragrahpes. */

void Fdealloc(word segment);
/* Far deallocate */

void Fappend(void *buf, unsigned len);
/* Append a new item to the end of the list */

void clrList(void);
/* clear the list, and free all entries. */

#ifdef _MICROC_
void forEachList(int fct);
#else
void forEachList(int (*fct)(struct cmdList *));
#endif
/* call function fct for each item in the list head.
	If the function returns != 0, the current entry is deleted.
*/

#endif
