/* Copyright (C) 2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// This file is generated by generate-gpup-webgl. Do not edit.

#include "config.h"
#include "RemoteGraphicsContextGLProxy.h"

#include <wtf/StdLibExtras.h>

#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)

namespace WebKit {

void RemoteGraphicsContextGLProxy::activeTexture(GCGLenum texture)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ActiveTexture(texture));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::attachShader(PlatformGLObject program, PlatformGLObject shader)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::AttachShader(program, shader));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindAttribLocation(PlatformGLObject arg0, GCGLuint index, const String& name)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindAttribLocation(arg0, index, name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindBuffer(GCGLenum target, PlatformGLObject arg1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindBuffer(target, arg1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindFramebuffer(GCGLenum target, PlatformGLObject arg1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindFramebuffer(target, arg1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindRenderbuffer(GCGLenum target, PlatformGLObject arg1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindRenderbuffer(target, arg1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindTexture(GCGLenum target, PlatformGLObject arg1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindTexture(target, arg1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendColor(GCGLclampf red, GCGLclampf green, GCGLclampf blue, GCGLclampf alpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendColor(red, green, blue, alpha));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendEquation(GCGLenum mode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendEquation(mode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendEquationSeparate(GCGLenum modeRGB, GCGLenum modeAlpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendEquationSeparate(modeRGB, modeAlpha));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendFunc(GCGLenum sfactor, GCGLenum dfactor)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendFunc(sfactor, dfactor));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendFuncSeparate(GCGLenum srcRGB, GCGLenum dstRGB, GCGLenum srcAlpha, GCGLenum dstAlpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLenum RemoteGraphicsContextGLProxy::checkFramebufferStatus(GCGLenum target)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::CheckFramebufferStatus(target));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::clear(GCGLbitfield mask)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Clear(mask));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clearColor(GCGLclampf red, GCGLclampf green, GCGLclampf blue, GCGLclampf alpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClearColor(red, green, blue, alpha));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clearDepth(GCGLclampf depth)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClearDepth(depth));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clearStencil(GCGLint s)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClearStencil(s));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::colorMask(GCGLboolean red, GCGLboolean green, GCGLboolean blue, GCGLboolean alpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ColorMask(static_cast<bool>(red), static_cast<bool>(green), static_cast<bool>(blue), static_cast<bool>(alpha)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compileShader(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompileShader(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::copyTexImage2D(GCGLenum target, GCGLint level, GCGLenum internalformat, GCGLint x, GCGLint y, GCGLsizei width, GCGLsizei height, GCGLint border)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CopyTexImage2D(target, level, internalformat, x, y, width, height, border));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::copyTexSubImage2D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLint x, GCGLint y, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

PlatformGLObject RemoteGraphicsContextGLProxy::createBuffer()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateBuffer(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

PlatformGLObject RemoteGraphicsContextGLProxy::createFramebuffer()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateFramebuffer(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

PlatformGLObject RemoteGraphicsContextGLProxy::createProgram()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateProgram(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

PlatformGLObject RemoteGraphicsContextGLProxy::createRenderbuffer()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateRenderbuffer(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

PlatformGLObject RemoteGraphicsContextGLProxy::createShader(GCGLenum arg0)
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateShader(name, arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

PlatformGLObject RemoteGraphicsContextGLProxy::createTexture()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateTexture(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

void RemoteGraphicsContextGLProxy::cullFace(GCGLenum mode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CullFace(mode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::deleteBuffer(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteBuffer(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::deleteFramebuffer(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteFramebuffer(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::deleteProgram(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteProgram(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::deleteRenderbuffer(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteRenderbuffer(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::deleteShader(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteShader(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::deleteTexture(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteTexture(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::depthFunc(GCGLenum func)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DepthFunc(func));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::depthMask(GCGLboolean flag)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DepthMask(static_cast<bool>(flag)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::depthRange(GCGLclampf zNear, GCGLclampf zFar)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DepthRange(zNear, zFar));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::detachShader(PlatformGLObject arg0, PlatformGLObject arg1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DetachShader(arg0, arg1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::disable(GCGLenum cap)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Disable(cap));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::disableVertexAttribArray(GCGLuint index)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DisableVertexAttribArray(index));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawArrays(GCGLenum mode, GCGLint first, GCGLsizei count)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawArrays(mode, first, count));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawElements(GCGLenum mode, GCGLsizei count, GCGLenum type, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawElements(mode, count, type, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::enable(GCGLenum cap)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Enable(cap));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::enableVertexAttribArray(GCGLuint index)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::EnableVertexAttribArray(index));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::finish()
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Finish());
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::flush()
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Flush());
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::framebufferRenderbuffer(GCGLenum target, GCGLenum attachment, GCGLenum renderbuffertarget, PlatformGLObject arg3)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::FramebufferRenderbuffer(target, attachment, renderbuffertarget, arg3));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::framebufferTexture2D(GCGLenum target, GCGLenum attachment, GCGLenum textarget, PlatformGLObject arg3, GCGLint level)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::FramebufferTexture2D(target, attachment, textarget, arg3, level));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::frontFace(GCGLenum mode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::FrontFace(mode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::generateMipmap(GCGLenum target)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::GenerateMipmap(target));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

bool RemoteGraphicsContextGLProxy::getActiveAttrib(PlatformGLObject program, GCGLuint index, struct WebCore::GraphicsContextGLActiveInfo& arg2)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetActiveAttrib(program, index));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue, arg2Reply] = sendResult.reply();
    arg2 = WTFMove(arg2Reply);
    return returnValue;
}

bool RemoteGraphicsContextGLProxy::getActiveUniform(PlatformGLObject program, GCGLuint index, struct WebCore::GraphicsContextGLActiveInfo& arg2)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetActiveUniform(program, index));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue, arg2Reply] = sendResult.reply();
    arg2 = WTFMove(arg2Reply);
    return returnValue;
}

GCGLint RemoteGraphicsContextGLProxy::getAttribLocation(PlatformGLObject arg0, const String& name)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetAttribLocation(arg0, name));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLint RemoteGraphicsContextGLProxy::getBufferParameteri(GCGLenum target, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetBufferParameteri(target, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

String RemoteGraphicsContextGLProxy::getString(GCGLenum name)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetString(name));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::getFloatv(GCGLenum pname, std::span<GCGLfloat> value)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetFloatv(pname, value.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [valueReply] = sendResult.reply();
    memcpySpan(value, valueReply);
}

void RemoteGraphicsContextGLProxy::getIntegerv(GCGLenum pname, std::span<GCGLint> value)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetIntegerv(pname, value.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [valueReply] = sendResult.reply();
    memcpySpan(value, valueReply);
}

void RemoteGraphicsContextGLProxy::getIntegeri_v(GCGLenum pname, GCGLuint index, std::span<GCGLint, 4> value) // NOLINT
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetIntegeri_v(pname, index));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [valueReply] = sendResult.reply();
    memcpySpan(value, valueReply);
}

GCGLint64 RemoteGraphicsContextGLProxy::getInteger64(GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetInteger64(pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLint64>(returnValue);
}

GCGLint64 RemoteGraphicsContextGLProxy::getInteger64i(GCGLenum pname, GCGLuint index)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetInteger64i(pname, index));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLint64>(returnValue);
}

GCGLint RemoteGraphicsContextGLProxy::getProgrami(PlatformGLObject program, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetProgrami(program, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::getBooleanv(GCGLenum pname, std::span<GCGLboolean> value)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetBooleanv(pname, value.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [valueReply] = sendResult.reply();
    memcpySpan(value, valueReply);
}

GCGLint RemoteGraphicsContextGLProxy::getFramebufferAttachmentParameteri(GCGLenum target, GCGLenum attachment, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetFramebufferAttachmentParameteri(target, attachment, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

String RemoteGraphicsContextGLProxy::getProgramInfoLog(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetProgramInfoLog(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLint RemoteGraphicsContextGLProxy::getRenderbufferParameteri(GCGLenum target, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetRenderbufferParameteri(target, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLint RemoteGraphicsContextGLProxy::getShaderi(PlatformGLObject arg0, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetShaderi(arg0, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

String RemoteGraphicsContextGLProxy::getShaderInfoLog(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetShaderInfoLog(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::getShaderPrecisionFormat(GCGLenum shaderType, GCGLenum precisionType, std::span<GCGLint, 2> range, GCGLint* precision)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetShaderPrecisionFormat(shaderType, precisionType));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [rangeReply, precisionReply] = sendResult.reply();
    memcpySpan(range, rangeReply);
    if (precision)
        *precision = precisionReply;
}

String RemoteGraphicsContextGLProxy::getShaderSource(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetShaderSource(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLfloat RemoteGraphicsContextGLProxy::getTexParameterf(GCGLenum target, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetTexParameterf(target, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLint RemoteGraphicsContextGLProxy::getTexParameteri(GCGLenum target, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetTexParameteri(target, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::getUniformfv(PlatformGLObject program, GCGLint location, std::span<GCGLfloat> value)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetUniformfv(program, location, value.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [valueReply] = sendResult.reply();
    memcpySpan(value, valueReply);
}

void RemoteGraphicsContextGLProxy::getUniformiv(PlatformGLObject program, GCGLint location, std::span<GCGLint> value)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetUniformiv(program, location, value.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [valueReply] = sendResult.reply();
    memcpySpan(value, valueReply);
}

void RemoteGraphicsContextGLProxy::getUniformuiv(PlatformGLObject program, GCGLint location, std::span<GCGLuint> value)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetUniformuiv(program, location, value.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [valueReply] = sendResult.reply();
    memcpySpan(value, valueReply);
}

GCGLint RemoteGraphicsContextGLProxy::getUniformLocation(PlatformGLObject arg0, const String& name)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetUniformLocation(arg0, name));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLsizeiptr RemoteGraphicsContextGLProxy::getVertexAttribOffset(GCGLuint index, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetVertexAttribOffset(index, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLsizeiptr>(returnValue);
}

void RemoteGraphicsContextGLProxy::hint(GCGLenum target, GCGLenum mode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Hint(target, mode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLboolean RemoteGraphicsContextGLProxy::isBuffer(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsBuffer(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

GCGLboolean RemoteGraphicsContextGLProxy::isEnabled(GCGLenum cap)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsEnabled(cap));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

GCGLboolean RemoteGraphicsContextGLProxy::isFramebuffer(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsFramebuffer(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

GCGLboolean RemoteGraphicsContextGLProxy::isProgram(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsProgram(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

GCGLboolean RemoteGraphicsContextGLProxy::isRenderbuffer(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsRenderbuffer(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

GCGLboolean RemoteGraphicsContextGLProxy::isShader(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsShader(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

GCGLboolean RemoteGraphicsContextGLProxy::isTexture(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsTexture(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

void RemoteGraphicsContextGLProxy::lineWidth(GCGLfloat arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::LineWidth(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::linkProgram(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::LinkProgram(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::pixelStorei(GCGLenum pname, GCGLint param)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::PixelStorei(pname, param));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::polygonOffset(GCGLfloat factor, GCGLfloat units)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::PolygonOffset(factor, units));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::renderbufferStorage(GCGLenum target, GCGLenum internalformat, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::RenderbufferStorage(target, internalformat, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::sampleCoverage(GCGLclampf value, GCGLboolean invert)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::SampleCoverage(value, static_cast<bool>(invert)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::scissor(GCGLint x, GCGLint y, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Scissor(x, y, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::shaderSource(PlatformGLObject arg0, const String& arg1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ShaderSource(arg0, arg1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::stencilFunc(GCGLenum func, GCGLint ref, GCGLuint mask)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::StencilFunc(func, ref, mask));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::stencilFuncSeparate(GCGLenum face, GCGLenum func, GCGLint ref, GCGLuint mask)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::StencilFuncSeparate(face, func, ref, mask));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::stencilMask(GCGLuint mask)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::StencilMask(mask));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::stencilMaskSeparate(GCGLenum face, GCGLuint mask)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::StencilMaskSeparate(face, mask));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::stencilOp(GCGLenum fail, GCGLenum zfail, GCGLenum zpass)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::StencilOp(fail, zfail, zpass));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::stencilOpSeparate(GCGLenum face, GCGLenum fail, GCGLenum zfail, GCGLenum zpass)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::StencilOpSeparate(face, fail, zfail, zpass));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texParameterf(GCGLenum target, GCGLenum pname, GCGLfloat param)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexParameterf(target, pname, param));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texParameteri(GCGLenum target, GCGLenum pname, GCGLint param)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexParameteri(target, pname, param));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform1f(GCGLint location, GCGLfloat x)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform1f(location, x));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform1fv(GCGLint location, std::span<const GCGLfloat> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform1fv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform1i(GCGLint location, GCGLint x)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform1i(location, x));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform1iv(GCGLint location, std::span<const GCGLint> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform1iv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform2f(GCGLint location, GCGLfloat x, GCGLfloat y)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform2f(location, x, y));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform2fv(GCGLint location, std::span<const GCGLfloat> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform2fv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform2i(GCGLint location, GCGLint x, GCGLint y)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform2i(location, x, y));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform2iv(GCGLint location, std::span<const GCGLint> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform2iv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform3f(GCGLint location, GCGLfloat x, GCGLfloat y, GCGLfloat z)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform3f(location, x, y, z));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform3fv(GCGLint location, std::span<const GCGLfloat> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform3fv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform3i(GCGLint location, GCGLint x, GCGLint y, GCGLint z)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform3i(location, x, y, z));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform3iv(GCGLint location, std::span<const GCGLint> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform3iv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform4f(GCGLint location, GCGLfloat x, GCGLfloat y, GCGLfloat z, GCGLfloat w)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform4f(location, x, y, z, w));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform4fv(GCGLint location, std::span<const GCGLfloat> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform4fv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform4i(GCGLint location, GCGLint x, GCGLint y, GCGLint z, GCGLint w)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform4i(location, x, y, z, w));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform4iv(GCGLint location, std::span<const GCGLint> v)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform4iv(location, v));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix2fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> value)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix2fv(location, static_cast<bool>(transpose), value));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix3fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> value)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix3fv(location, static_cast<bool>(transpose), value));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix4fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> value)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix4fv(location, static_cast<bool>(transpose), value));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::useProgram(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UseProgram(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::validateProgram(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ValidateProgram(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib1f(GCGLuint index, GCGLfloat x)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib1f(index, x));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib1fv(GCGLuint index, std::span<const GCGLfloat, 1> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib1fv(index, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib2f(GCGLuint index, GCGLfloat x, GCGLfloat y)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib2f(index, x, y));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib2fv(GCGLuint index, std::span<const GCGLfloat, 2> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib2fv(index, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib3f(GCGLuint index, GCGLfloat x, GCGLfloat y, GCGLfloat z)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib3f(index, x, y, z));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib3fv(GCGLuint index, std::span<const GCGLfloat, 3> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib3fv(index, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib4f(GCGLuint index, GCGLfloat x, GCGLfloat y, GCGLfloat z, GCGLfloat w)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib4f(index, x, y, z, w));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttrib4fv(GCGLuint index, std::span<const GCGLfloat, 4> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttrib4fv(index, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttribPointer(GCGLuint index, GCGLint size, GCGLenum type, GCGLboolean normalized, GCGLsizei stride, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttribPointer(index, size, type, static_cast<bool>(normalized), stride, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::viewport(GCGLint x, GCGLint y, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Viewport(x, y, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bufferData(GCGLenum target, GCGLsizeiptr arg1, GCGLenum usage)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BufferData0(target, static_cast<uint64_t>(arg1), usage));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bufferData(GCGLenum target, std::span<const uint8_t> data, GCGLenum usage)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BufferData1(target, data, usage));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bufferSubData(GCGLenum target, GCGLintptr offset, std::span<const uint8_t> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BufferSubData(target, static_cast<uint64_t>(offset), data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::readPixelsBufferObject(WebCore::IntRect arg0, GCGLenum format, GCGLenum type, GCGLintptr offset, GCGLint alignment, GCGLint rowLength)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ReadPixelsBufferObject(arg0, format, type, static_cast<uint64_t>(offset), alignment, rowLength));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texImage2D(GCGLenum target, GCGLint level, GCGLenum internalformat, GCGLsizei width, GCGLsizei height, GCGLint border, GCGLenum format, GCGLenum type, std::span<const uint8_t> pixels)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexImage2D0(target, level, internalformat, width, height, border, format, type, pixels));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texImage2D(GCGLenum target, GCGLint level, GCGLenum internalformat, GCGLsizei width, GCGLsizei height, GCGLint border, GCGLenum format, GCGLenum type, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexImage2D1(target, level, internalformat, width, height, border, format, type, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texSubImage2D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLsizei width, GCGLsizei height, GCGLenum format, GCGLenum type, std::span<const uint8_t> pixels)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexSubImage2D0(target, level, xoffset, yoffset, width, height, format, type, pixels));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texSubImage2D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLsizei width, GCGLsizei height, GCGLenum format, GCGLenum type, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexSubImage2D1(target, level, xoffset, yoffset, width, height, format, type, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexImage2D(GCGLenum target, GCGLint level, GCGLenum internalformat, GCGLsizei width, GCGLsizei height, GCGLint border, GCGLsizei imageSize, std::span<const uint8_t> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexImage2D0(target, level, internalformat, width, height, border, imageSize, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexImage2D(GCGLenum target, GCGLint level, GCGLenum internalformat, GCGLsizei width, GCGLsizei height, GCGLint border, GCGLsizei imageSize, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexImage2D1(target, level, internalformat, width, height, border, imageSize, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexSubImage2D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLsizei width, GCGLsizei height, GCGLenum format, GCGLsizei imageSize, std::span<const uint8_t> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexSubImage2D0(target, level, xoffset, yoffset, width, height, format, imageSize, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexSubImage2D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLsizei width, GCGLsizei height, GCGLenum format, GCGLsizei imageSize, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexSubImage2D1(target, level, xoffset, yoffset, width, height, format, imageSize, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawArraysInstanced(GCGLenum mode, GCGLint first, GCGLsizei count, GCGLsizei primcount)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawArraysInstanced(mode, first, count, primcount));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawElementsInstanced(GCGLenum mode, GCGLsizei count, GCGLenum type, GCGLintptr offset, GCGLsizei primcount)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawElementsInstanced(mode, count, type, static_cast<uint64_t>(offset), primcount));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttribDivisor(GCGLuint index, GCGLuint divisor)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttribDivisor(index, divisor));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

PlatformGLObject RemoteGraphicsContextGLProxy::createVertexArray()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateVertexArray(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

void RemoteGraphicsContextGLProxy::deleteVertexArray(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteVertexArray(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLboolean RemoteGraphicsContextGLProxy::isVertexArray(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsVertexArray(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

void RemoteGraphicsContextGLProxy::bindVertexArray(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindVertexArray(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::copyBufferSubData(GCGLenum readTarget, GCGLenum writeTarget, GCGLintptr readOffset, GCGLintptr writeOffset, GCGLsizeiptr arg4)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CopyBufferSubData(readTarget, writeTarget, static_cast<uint64_t>(readOffset), static_cast<uint64_t>(writeOffset), static_cast<uint64_t>(arg4)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blitFramebuffer(GCGLint srcX0, GCGLint srcY0, GCGLint srcX1, GCGLint srcY1, GCGLint dstX0, GCGLint dstY0, GCGLint dstX1, GCGLint dstY1, GCGLbitfield mask, GCGLenum filter)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::framebufferTextureLayer(GCGLenum target, GCGLenum attachment, PlatformGLObject texture, GCGLint level, GCGLint layer)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::FramebufferTextureLayer(target, attachment, texture, level, layer));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::invalidateFramebuffer(GCGLenum target, std::span<const GCGLenum> attachments)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::InvalidateFramebuffer(target, attachments));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::invalidateSubFramebuffer(GCGLenum target, std::span<const GCGLenum> attachments, GCGLint x, GCGLint y, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::InvalidateSubFramebuffer(target, attachments, x, y, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::readBuffer(GCGLenum src)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ReadBuffer(src));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::renderbufferStorageMultisample(GCGLenum target, GCGLsizei samples, GCGLenum internalformat, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::RenderbufferStorageMultisample(target, samples, internalformat, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texStorage2D(GCGLenum target, GCGLsizei levels, GCGLenum internalformat, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexStorage2D(target, levels, internalformat, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texStorage3D(GCGLenum target, GCGLsizei levels, GCGLenum internalformat, GCGLsizei width, GCGLsizei height, GCGLsizei depth)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexStorage3D(target, levels, internalformat, width, height, depth));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texImage3D(GCGLenum target, GCGLint level, GCGLint internalformat, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLint border, GCGLenum format, GCGLenum type, std::span<const uint8_t> pixels)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexImage3D0(target, level, internalformat, width, height, depth, border, format, type, pixels));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texImage3D(GCGLenum target, GCGLint level, GCGLint internalformat, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLint border, GCGLenum format, GCGLenum type, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexImage3D1(target, level, internalformat, width, height, depth, border, format, type, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texSubImage3D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLint zoffset, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLenum format, GCGLenum type, std::span<const uint8_t> pixels)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexSubImage3D0(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::texSubImage3D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLint zoffset, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLenum format, GCGLenum type, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TexSubImage3D1(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::copyTexSubImage3D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLint zoffset, GCGLint x, GCGLint y, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexImage3D(GCGLenum target, GCGLint level, GCGLenum internalformat, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLint border, GCGLsizei imageSize, std::span<const uint8_t> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexImage3D0(target, level, internalformat, width, height, depth, border, imageSize, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexImage3D(GCGLenum target, GCGLint level, GCGLenum internalformat, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLint border, GCGLsizei imageSize, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexImage3D1(target, level, internalformat, width, height, depth, border, imageSize, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexSubImage3D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLint zoffset, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLenum format, GCGLsizei imageSize, std::span<const uint8_t> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexSubImage3D0(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::compressedTexSubImage3D(GCGLenum target, GCGLint level, GCGLint xoffset, GCGLint yoffset, GCGLint zoffset, GCGLsizei width, GCGLsizei height, GCGLsizei depth, GCGLenum format, GCGLsizei imageSize, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CompressedTexSubImage3D1(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLint RemoteGraphicsContextGLProxy::getFragDataLocation(PlatformGLObject program, const String& name)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetFragDataLocation(program, name));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::uniform1ui(GCGLint location, GCGLuint v0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform1ui(location, v0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform2ui(GCGLint location, GCGLuint v0, GCGLuint v1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform2ui(location, v0, v1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform3ui(GCGLint location, GCGLuint v0, GCGLuint v1, GCGLuint v2)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform3ui(location, v0, v1, v2));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform4ui(GCGLint location, GCGLuint v0, GCGLuint v1, GCGLuint v2, GCGLuint v3)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform4ui(location, v0, v1, v2, v3));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform1uiv(GCGLint location, std::span<const GCGLuint> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform1uiv(location, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform2uiv(GCGLint location, std::span<const GCGLuint> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform2uiv(location, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform3uiv(GCGLint location, std::span<const GCGLuint> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform3uiv(location, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniform4uiv(GCGLint location, std::span<const GCGLuint> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::Uniform4uiv(location, data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix2x3fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix2x3fv(location, static_cast<bool>(transpose), data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix3x2fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix3x2fv(location, static_cast<bool>(transpose), data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix2x4fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix2x4fv(location, static_cast<bool>(transpose), data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix4x2fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix4x2fv(location, static_cast<bool>(transpose), data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix3x4fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix3x4fv(location, static_cast<bool>(transpose), data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::uniformMatrix4x3fv(GCGLint location, GCGLboolean transpose, std::span<const GCGLfloat> data)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformMatrix4x3fv(location, static_cast<bool>(transpose), data));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttribI4i(GCGLuint index, GCGLint x, GCGLint y, GCGLint z, GCGLint w)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttribI4i(index, x, y, z, w));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttribI4iv(GCGLuint index, std::span<const GCGLint, 4> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttribI4iv(index, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttribI4ui(GCGLuint index, GCGLuint x, GCGLuint y, GCGLuint z, GCGLuint w)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttribI4ui(index, x, y, z, w));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttribI4uiv(GCGLuint index, std::span<const GCGLuint, 4> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttribI4uiv(index, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::vertexAttribIPointer(GCGLuint index, GCGLint size, GCGLenum type, GCGLsizei stride, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::VertexAttribIPointer(index, size, type, stride, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawRangeElements(GCGLenum mode, GCGLuint start, GCGLuint end, GCGLsizei count, GCGLenum type, GCGLintptr offset)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawRangeElements(mode, start, end, count, type, static_cast<uint64_t>(offset)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawBuffers(std::span<const GCGLenum> bufs)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawBuffers(bufs));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clearBufferiv(GCGLenum buffer, GCGLint drawbuffer, std::span<const GCGLint> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClearBufferiv(buffer, drawbuffer, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clearBufferuiv(GCGLenum buffer, GCGLint drawbuffer, std::span<const GCGLuint> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClearBufferuiv(buffer, drawbuffer, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clearBufferfv(GCGLenum buffer, GCGLint drawbuffer, std::span<const GCGLfloat> values)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClearBufferfv(buffer, drawbuffer, values));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clearBufferfi(GCGLenum buffer, GCGLint drawbuffer, GCGLfloat depth, GCGLint stencil)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClearBufferfi(buffer, drawbuffer, depth, stencil));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

PlatformGLObject RemoteGraphicsContextGLProxy::createQuery()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateQuery(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

void RemoteGraphicsContextGLProxy::deleteQuery(PlatformGLObject query)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteQuery(query));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLboolean RemoteGraphicsContextGLProxy::isQuery(PlatformGLObject query)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsQuery(query));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

void RemoteGraphicsContextGLProxy::beginQuery(GCGLenum target, PlatformGLObject query)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BeginQuery(target, query));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::endQuery(GCGLenum target)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::EndQuery(target));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLint RemoteGraphicsContextGLProxy::getQuery(GCGLenum target, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetQuery(target, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLuint RemoteGraphicsContextGLProxy::getQueryObjectui(PlatformGLObject query, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetQueryObjectui(query, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

PlatformGLObject RemoteGraphicsContextGLProxy::createSampler()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateSampler(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

void RemoteGraphicsContextGLProxy::deleteSampler(PlatformGLObject sampler)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteSampler(sampler));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLboolean RemoteGraphicsContextGLProxy::isSampler(PlatformGLObject sampler)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsSampler(sampler));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

void RemoteGraphicsContextGLProxy::bindSampler(GCGLuint unit, PlatformGLObject sampler)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindSampler(unit, sampler));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::samplerParameteri(PlatformGLObject sampler, GCGLenum pname, GCGLint param)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::SamplerParameteri(sampler, pname, param));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::samplerParameterf(PlatformGLObject sampler, GCGLenum pname, GCGLfloat param)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::SamplerParameterf(sampler, pname, param));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLfloat RemoteGraphicsContextGLProxy::getSamplerParameterf(PlatformGLObject sampler, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetSamplerParameterf(sampler, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLint RemoteGraphicsContextGLProxy::getSamplerParameteri(PlatformGLObject sampler, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetSamplerParameteri(sampler, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLsync RemoteGraphicsContextGLProxy::fenceSync(GCGLenum condition, GCGLbitfield flags)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::FenceSync(condition, flags));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return reinterpret_cast<GCGLsync>(static_cast<intptr_t>(returnValue));
}

GCGLboolean RemoteGraphicsContextGLProxy::isSync(GCGLsync arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsSync(static_cast<uint64_t>(reinterpret_cast<intptr_t>(arg0))));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

void RemoteGraphicsContextGLProxy::deleteSync(GCGLsync arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteSync(static_cast<uint64_t>(reinterpret_cast<intptr_t>(arg0))));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLenum RemoteGraphicsContextGLProxy::clientWaitSync(GCGLsync arg0, GCGLbitfield flags, GCGLuint64 timeout)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::ClientWaitSync(static_cast<uint64_t>(reinterpret_cast<intptr_t>(arg0)), flags, static_cast<uint64_t>(timeout)));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::waitSync(GCGLsync arg0, GCGLbitfield flags, GCGLint64 timeout)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::WaitSync(static_cast<uint64_t>(reinterpret_cast<intptr_t>(arg0)), flags, static_cast<int64_t>(timeout)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLint RemoteGraphicsContextGLProxy::getSynci(GCGLsync arg0, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetSynci(static_cast<uint64_t>(reinterpret_cast<intptr_t>(arg0)), pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

PlatformGLObject RemoteGraphicsContextGLProxy::createTransformFeedback()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateTransformFeedback(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

void RemoteGraphicsContextGLProxy::deleteTransformFeedback(PlatformGLObject id)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteTransformFeedback(id));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLboolean RemoteGraphicsContextGLProxy::isTransformFeedback(PlatformGLObject id)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsTransformFeedback(id));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

void RemoteGraphicsContextGLProxy::bindTransformFeedback(GCGLenum target, PlatformGLObject id)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindTransformFeedback(target, id));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::beginTransformFeedback(GCGLenum primitiveMode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BeginTransformFeedback(primitiveMode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::endTransformFeedback()
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::EndTransformFeedback());
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::transformFeedbackVaryings(PlatformGLObject program, const Vector<String>& varyings, GCGLenum bufferMode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::TransformFeedbackVaryings(program, varyings, bufferMode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::getTransformFeedbackVarying(PlatformGLObject program, GCGLuint index, struct WebCore::GraphicsContextGLActiveInfo& arg2)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetTransformFeedbackVarying(program, index));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [arg2Reply] = sendResult.reply();
    arg2 = WTFMove(arg2Reply);
}

void RemoteGraphicsContextGLProxy::pauseTransformFeedback()
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::PauseTransformFeedback());
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::resumeTransformFeedback()
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ResumeTransformFeedback());
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindBufferBase(GCGLenum target, GCGLuint index, PlatformGLObject buffer)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindBufferBase(target, index, buffer));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindBufferRange(GCGLenum target, GCGLuint index, PlatformGLObject buffer, GCGLintptr offset, GCGLsizeiptr arg4)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindBufferRange(target, index, buffer, static_cast<uint64_t>(offset), static_cast<uint64_t>(arg4)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

Vector<GCGLuint> RemoteGraphicsContextGLProxy::getUniformIndices(PlatformGLObject program, const Vector<String>& uniformNames)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetUniformIndices(program, uniformNames));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

Vector<GCGLint> RemoteGraphicsContextGLProxy::getActiveUniforms(PlatformGLObject program, const Vector<GCGLuint>& uniformIndices, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetActiveUniforms(program, uniformIndices, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLuint RemoteGraphicsContextGLProxy::getUniformBlockIndex(PlatformGLObject program, const String& uniformBlockName)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetUniformBlockIndex(program, uniformBlockName));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

String RemoteGraphicsContextGLProxy::getActiveUniformBlockName(PlatformGLObject program, GCGLuint uniformBlockIndex)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetActiveUniformBlockName(program, uniformBlockIndex));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::uniformBlockBinding(PlatformGLObject program, GCGLuint uniformBlockIndex, GCGLuint uniformBlockBinding)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::UniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::getActiveUniformBlockiv(PlatformGLObject program, GCGLuint uniformBlockIndex, GCGLenum pname, std::span<GCGLint> params)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetActiveUniformBlockiv(program, uniformBlockIndex, pname, params.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [paramsReply] = sendResult.reply();
    memcpySpan(params, paramsReply);
}

String RemoteGraphicsContextGLProxy::getTranslatedShaderSourceANGLE(PlatformGLObject arg0)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetTranslatedShaderSourceANGLE(arg0));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::drawBuffersEXT(std::span<const GCGLenum> bufs)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawBuffersEXT(bufs));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

PlatformGLObject RemoteGraphicsContextGLProxy::createQueryEXT()
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateQueryEXT(name));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

void RemoteGraphicsContextGLProxy::deleteQueryEXT(PlatformGLObject query)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteQueryEXT(query));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLboolean RemoteGraphicsContextGLProxy::isQueryEXT(PlatformGLObject query)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::IsQueryEXT(query));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLboolean>(returnValue);
}

void RemoteGraphicsContextGLProxy::beginQueryEXT(GCGLenum target, PlatformGLObject query)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BeginQueryEXT(target, query));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::endQueryEXT(GCGLenum target)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::EndQueryEXT(target));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::queryCounterEXT(PlatformGLObject query, GCGLenum target)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::QueryCounterEXT(query, target));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLint RemoteGraphicsContextGLProxy::getQueryiEXT(GCGLenum target, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetQueryiEXT(target, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLint RemoteGraphicsContextGLProxy::getQueryObjectiEXT(PlatformGLObject query, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetQueryObjectiEXT(query, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

GCGLuint64 RemoteGraphicsContextGLProxy::getQueryObjectui64EXT(PlatformGLObject query, GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetQueryObjectui64EXT(query, pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLuint64>(returnValue);
}

GCGLint64 RemoteGraphicsContextGLProxy::getInteger64EXT(GCGLenum pname)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetInteger64EXT(pname));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return static_cast<GCGLint64>(returnValue);
}

void RemoteGraphicsContextGLProxy::enableiOES(GCGLenum target, GCGLuint index)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::EnableiOES(target, index));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::disableiOES(GCGLenum target, GCGLuint index)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DisableiOES(target, index));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendEquationiOES(GCGLuint buf, GCGLenum mode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendEquationiOES(buf, mode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendEquationSeparateiOES(GCGLuint buf, GCGLenum modeRGB, GCGLenum modeAlpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendEquationSeparateiOES(buf, modeRGB, modeAlpha));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendFunciOES(GCGLuint buf, GCGLenum src, GCGLenum dst)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendFunciOES(buf, src, dst));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::blendFuncSeparateiOES(GCGLuint buf, GCGLenum srcRGB, GCGLenum dstRGB, GCGLenum srcAlpha, GCGLenum dstAlpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BlendFuncSeparateiOES(buf, srcRGB, dstRGB, srcAlpha, dstAlpha));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::colorMaskiOES(GCGLuint buf, GCGLboolean red, GCGLboolean green, GCGLboolean blue, GCGLboolean alpha)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ColorMaskiOES(buf, static_cast<bool>(red), static_cast<bool>(green), static_cast<bool>(blue), static_cast<bool>(alpha)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawArraysInstancedBaseInstanceANGLE(GCGLenum mode, GCGLint first, GCGLsizei count, GCGLsizei instanceCount, GCGLuint baseInstance)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawArraysInstancedBaseInstanceANGLE(mode, first, count, instanceCount, baseInstance));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::drawElementsInstancedBaseVertexBaseInstanceANGLE(GCGLenum mode, GCGLsizei count, GCGLenum type, GCGLintptr offset, GCGLsizei instanceCount, GCGLint baseVertex, GCGLuint baseInstance)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DrawElementsInstancedBaseVertexBaseInstanceANGLE(mode, count, type, static_cast<uint64_t>(offset), instanceCount, baseVertex, baseInstance));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::clipControlEXT(GCGLenum origin, GCGLenum depth)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ClipControlEXT(origin, depth));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::provokingVertexANGLE(GCGLenum provokeMode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::ProvokingVertexANGLE(provokeMode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::polygonModeANGLE(GCGLenum face, GCGLenum mode)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::PolygonModeANGLE(face, mode));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::polygonOffsetClampEXT(GCGLfloat factor, GCGLfloat units, GCGLfloat clamp)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::PolygonOffsetClampEXT(factor, units, clamp));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::renderbufferStorageMultisampleANGLE(GCGLenum target, GCGLsizei samples, GCGLenum internalformat, GCGLsizei width, GCGLsizei height)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::RenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::getInternalformativ(GCGLenum target, GCGLenum internalformat, GCGLenum pname, std::span<GCGLint> params)
{
    if (isContextLost())
        return;
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::GetInternalformativ(target, internalformat, pname, params.size()));
    if (!sendResult.succeeded()) {
        markContextLost();
        return;
    }
    auto& [paramsReply] = sendResult.reply();
    memcpySpan(params, paramsReply);
}

void RemoteGraphicsContextGLProxy::setDrawingBufferColorSpace(const WebCore::DestinationColorSpace& arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::SetDrawingBufferColorSpace(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

#if ENABLE(WEBXR)
GCGLExternalImage RemoteGraphicsContextGLProxy::createExternalImage(WebCore::GraphicsContextGL::ExternalImageSource&& arg0, GCGLenum internalFormat, GCGLint layer)
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateExternalImage(name, WTFMove(arg0), internalFormat, layer));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}

void RemoteGraphicsContextGLProxy::deleteExternalImage(GCGLExternalImage handle)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteExternalImage(handle));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::bindExternalImage(GCGLenum target, GCGLExternalImage arg1)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::BindExternalImage(target, arg1));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

GCGLExternalSync RemoteGraphicsContextGLProxy::createExternalSync(WebCore::GraphicsContextGL::ExternalSyncSource&& arg0)
{
    if (isContextLost())
        return { };
    auto name = createObjectName();
    auto sendResult = send(Messages::RemoteGraphicsContextGL::CreateExternalSync(name, WTFMove(arg0)));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return { };
    }
    return name;
}
#endif

void RemoteGraphicsContextGLProxy::deleteExternalSync(GCGLExternalSync arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DeleteExternalSync(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

#if ENABLE(WEBXR)
bool RemoteGraphicsContextGLProxy::enableRequiredWebXRExtensions()
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::EnableRequiredWebXRExtensions());
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

bool RemoteGraphicsContextGLProxy::addFoveation(WebCore::IntSize physicalSizeLeft, WebCore::IntSize physicalSizeRight, WebCore::IntSize screenSize, std::span<const GCGLfloat> horizontalSamplesLeft, std::span<const GCGLfloat> verticalSamples, std::span<const GCGLfloat> horizontalSamplesRight)
{
    if (isContextLost())
        return { };
    auto sendResult = sendSync(Messages::RemoteGraphicsContextGL::AddFoveation(physicalSizeLeft, physicalSizeRight, screenSize, horizontalSamplesLeft, verticalSamples, horizontalSamplesRight));
    if (!sendResult.succeeded()) {
        markContextLost();
        return { };
    }
    auto& [returnValue] = sendResult.reply();
    return returnValue;
}

void RemoteGraphicsContextGLProxy::enableFoveation(PlatformGLObject arg0)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::EnableFoveation(arg0));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::disableFoveation()
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::DisableFoveation());
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::framebufferDiscard(GCGLenum target, std::span<const GCGLenum> attachments)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::FramebufferDiscard(target, attachments));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}

void RemoteGraphicsContextGLProxy::framebufferResolveRenderbuffer(GCGLenum target, GCGLenum attachment, GCGLenum renderbuffertarget, PlatformGLObject arg3)
{
    if (isContextLost())
        return;
    auto sendResult = send(Messages::RemoteGraphicsContextGL::FramebufferResolveRenderbuffer(target, attachment, renderbuffertarget, arg3));
    if (sendResult != IPC::Error::NoError) {
        markContextLost();
        return;
    }
}
#endif

}

#endif

