# PySNMP SMI module. Autogenerated from smidump -f python PTOPO-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:29 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( PhysicalIndex, ) = mibBuilder.importSymbols("ENTITY-MIB", "PhysicalIndex")
( AddressFamilyNumbers, ) = mibBuilder.importSymbols("IANA-ADDRESS-FAMILY-NUMBERS-MIB", "AddressFamilyNumbers")
( TimeFilter, ) = mibBuilder.importSymbols("RMON2-MIB", "TimeFilter")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( AutonomousType, RowStatus, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "RowStatus", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class PtopoAddrSeenState(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,1,3,4,)
    namedValues = NamedValues(("notUsed", 1), ("unknown", 2), ("oneAddr", 3), ("multiAddr", 4), )
    
class PtopoChassisId(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,32)
    
class PtopoChassisIdType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,1,3,4,5,)
    namedValues = NamedValues(("chasIdEntPhysicalAlias", 1), ("chasIdIfAlias", 2), ("chasIdPortEntPhysicalAlias", 3), ("chasIdMacAddress", 4), ("chasIdPtopoGenAddr", 5), )
    
class PtopoGenAddr(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,20)
    
class PtopoPortId(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,32)
    
class PtopoPortIdType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(4,1,3,2,)
    namedValues = NamedValues(("portIdIfAlias", 1), ("portIdEntPhysicalAlias", 2), ("portIdMacAddr", 3), ("portIdPtopoGenAddr", 4), )
    

# Objects

ptopoMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 79)).setRevisions(("2000-09-21 00:00",))
if mibBuilder.loadTexts: ptopoMIB.setOrganization("IETF; PTOPOMIB Working Group")
if mibBuilder.loadTexts: ptopoMIB.setContactInfo("PTOPOMIB WG Discussion:\nptopo@3com.com\nSubscription:\nmajordomo@3com.com\n  msg body: [un]subscribe ptopomib\n\nAndy Bierman\nCisco Systems Inc.\n170 West Tasman Drive\nSan Jose, CA 95134\n408-527-3711\nabierman@cisco.com\n\nKendall S. Jones\nNortel Networks\n4401 Great America Parkway\nSanta Clara, CA 95054\n408-495-7356\nkejones@nortelnetworks.com")
if mibBuilder.loadTexts: ptopoMIB.setDescription("The MIB module for physical topology information.")
ptopoMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 1))
ptopoData = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 1, 1))
ptopoConnTable = MibTable((1, 3, 6, 1, 2, 1, 79, 1, 1, 1))
if mibBuilder.loadTexts: ptopoConnTable.setDescription("This table contains one or more rows per physical network\nconnection known to this agent.  The agent may wish to\nensure that only one ptopoConnEntry is present for each\nlocal port, or it may choose to maintain multiple\nptopoConnEntries for the same local port.\n\nEntries based on lower numbered identifier types are\npreferred over higher numbered identifier types, i.e., lower\nvalues of the ptopoConnRemoteChassisType and\nptopoConnRemotePortType objects.")
ptopoConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1)).setIndexNames((0, "PTOPO-MIB", "ptopoConnTimeMark"), (0, "PTOPO-MIB", "ptopoConnLocalChassis"), (0, "PTOPO-MIB", "ptopoConnLocalPort"), (0, "PTOPO-MIB", "ptopoConnIndex"))
if mibBuilder.loadTexts: ptopoConnEntry.setDescription("Information about a particular physical network connection.\nEntries may be created and deleted in this table, either\nmanually or by the agent, if a physical topology discovery\nprocess is active.")
ptopoConnTimeMark = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 1), TimeFilter()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ptopoConnTimeMark.setDescription("A TimeFilter for this entry.  See the TimeFilter textual\nconvention in RFC 2021 to see how this works.")
ptopoConnLocalChassis = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 2), PhysicalIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ptopoConnLocalChassis.setDescription("The entPhysicalIndex value used to identify the chassis\ncomponent associated with the local connection endpoint.")
ptopoConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 3), PhysicalIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ptopoConnLocalPort.setDescription("The entPhysicalIndex value used to identify the port\ncomponent associated with the local connection endpoint.")
ptopoConnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ptopoConnIndex.setDescription("This object represents an arbitrary local integer value\nused by this agent to identify a particular connection\ninstance, unique only for the indicated local connection\nendpoint.\n\nA particular ptopoConnIndex value may be reused in the event\nan entry is aged out and later re-learned with the same (or\ndifferent) remote chassis and port identifiers.\n\nAn agent is encouraged to assign monotonically increasing\nindex values to new entries, starting with one, after each\n\n\nreboot.  It is considered unlikely that the ptopoConnIndex\nwill wrap between reboots.")
ptopoConnRemoteChassisType = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 5), PtopoChassisIdType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnRemoteChassisType.setDescription("The type of encoding used to identify the chassis\nassociated with the remote connection endpoint.\n\nThis object may not be modified if the associated\nptopoConnRowStatus object has a value of active(1).")
ptopoConnRemoteChassis = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 6), PtopoChassisId()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnRemoteChassis.setDescription("The string value used to identify the chassis component\nassociated with the remote connection endpoint.\n\nThis object may not be modified if the associated\nptopoConnRowStatus object has a value of active(1).")
ptopoConnRemotePortType = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 7), PtopoPortIdType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnRemotePortType.setDescription("The type of port identifier encoding used in the associated\n'ptopoConnRemotePort' object.\n\nThis object may not be modified if the associated\nptopoConnRowStatus object has a value of active(1).")
ptopoConnRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 8), PtopoPortId()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnRemotePort.setDescription("The string value used to identify the port component\nassociated with the remote connection endpoint.\n\n\n\nThis object may not be modified if the associated\nptopoConnRowStatus object has a value of active(1).")
ptopoConnDiscAlgorithm = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 9), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ptopoConnDiscAlgorithm.setDescription("An indication of the algorithm used to discover the\ninformation contained in this conceptual row.\n\nA value of ptopoDiscoveryLocal indicates this entry was\nconfigured by the local agent, without use of a discovery\nprotocol.\n\nA value of { 0 0 } indicates this entry was created manually\nby an NMS via the associated RowStatus object. ")
ptopoConnAgentNetAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 10), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnAgentNetAddrType.setDescription("This network address type of the associated\nptopoConnNetAddr object, unless that object contains a zero\nlength string.  In such a case, an NMS application should\nignore any returned value for this object.\n\nThis object may not be modified if the associated\nptopoConnRowStatus object has a value of active(1).")
ptopoConnAgentNetAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 11), PtopoGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnAgentNetAddr.setDescription("This object identifies a network address which may be used\nto reach an SNMP agent entity containing information for the\nchassis and port components represented by the associated\n'ptopoConnRemoteChassis' and 'ptopoConnRemotePort' objects.\nIf no such address is known, then this object shall contain\nan empty string.\n\nThis object may not be modified if the associated\nptopoConnRowStatus object has a value of active(1).")
ptopoConnMultiMacSASeen = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 12), PtopoAddrSeenState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ptopoConnMultiMacSASeen.setDescription("This object indicates if multiple unicast source MAC\naddresses have been detected by the agent from the remote\nconnection endpoint, since the creation of this entry.\n\nIf this entry has an associated ptopoConnRemoteChassisType\nand/or ptopoConnRemotePortType value other than\n'portIdMacAddr(3)', then the value 'notUsed(1)' is returned.\n\nOtherwise, one of the following conditions must be true:\n\nIf the agent has not yet detected any unicast source MAC\naddresses from the remote port, then the value 'unknown(2)'\nis returned.\n\nIf the agent has detected exactly one unicast source MAC\naddress from the remote port, then the value 'oneAddr(3)' is\nreturned.\n\nIf the agent has detected more than one unicast source MAC\naddress from the remote port, then the value 'multiAddr(4)'\nis returned.")
ptopoConnMultiNetSASeen = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 13), PtopoAddrSeenState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ptopoConnMultiNetSASeen.setDescription("This object indicates if multiple network layer source\naddresses have been detected by the agent from the remote\nconnection endpoint, since the creation of this entry.\n\nIf this entry has an associated ptopoConnRemoteChassisType\nor ptopoConnRemotePortType value other than\n'portIdGenAddr(4)' then the value 'notUsed(1)' is returned.\n\nOtherwise, one of the following conditions must be true:\n\nIf the agent has not yet detected any network source\naddresses of the appropriate type from the remote port, then\nthe value 'unknown(2)' is returned.\n\n\nIf the agent has detected exactly one network source address\nof the appropriate type from the remote port, then the value\n'oneAddr(3)' is returned.\n\nIf the agent has detected more than one network source\naddress (of the same appropriate type) from the remote port,\nthis the value 'multiAddr(4)' is returned.")
ptopoConnIsStatic = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 14), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnIsStatic.setDescription("This object identifies static ptopoConnEntries.  If this\nobject has the value 'true(1)', then this entry is not\nsubject to any age-out mechanisms implemented by the agent.\n\nIf this object has the value 'false(2)', then this entry is\nsubject to all age-out mechanisms implemented by the agent.\n\nThis object may not be modified if the associated\nptopoConnRowStatus object has a value of active(1).")
ptopoConnLastVerifyTime = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 15), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ptopoConnLastVerifyTime.setDescription("If the associated value of ptopoConnIsStatic is equal to\n'false(2)', then this object contains the value of sysUpTime\nat the time the conceptual row was last verified by the\nagent, e.g., via reception of a topology protocol message,\npertaining to the associated remote chassis and port.\n\nIf the associated value of ptopoConnIsStatic is equal to\n'true(1)', then this object shall contain the value of\nsysUpTime at the time this entry was last activated (i.e.,\nptopoConnRowStatus set to 'active(1)').")
ptopoConnRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 79, 1, 1, 1, 1, 16), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ptopoConnRowStatus.setDescription("The status of this conceptual row.")
ptopoGeneral = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 1, 2))
ptopoLastChangeTime = MibScalar((1, 3, 6, 1, 2, 1, 79, 1, 2, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ptopoLastChangeTime.setDescription("The value of sysUpTime at the time a conceptual row is\ncreated, modified, or deleted in the ptopoConnTable.\n\nAn NMS can use this object to reduce polling of the\nptopoData group objects.")
ptopoConnTabInserts = MibScalar((1, 3, 6, 1, 2, 1, 79, 1, 2, 2), Counter32()).setMaxAccess("readonly").setUnits("table entries")
if mibBuilder.loadTexts: ptopoConnTabInserts.setDescription("The number of times an entry has been inserted into the\nptopoConnTable.")
ptopoConnTabDeletes = MibScalar((1, 3, 6, 1, 2, 1, 79, 1, 2, 3), Counter32()).setMaxAccess("readonly").setUnits("table entries")
if mibBuilder.loadTexts: ptopoConnTabDeletes.setDescription("The number of times an entry has been deleted from the\nptopoConnTable.")
ptopoConnTabDrops = MibScalar((1, 3, 6, 1, 2, 1, 79, 1, 2, 4), Counter32()).setMaxAccess("readonly").setUnits("table entries")
if mibBuilder.loadTexts: ptopoConnTabDrops.setDescription("The number of times an entry would have been added to the\nptopoConnTable, (e.g., via information learned from a\ntopology protocol), but was not because of insufficient\nresources.")
ptopoConnTabAgeouts = MibScalar((1, 3, 6, 1, 2, 1, 79, 1, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ptopoConnTabAgeouts.setDescription("The number of times an entry has been deleted from the\nptopoConnTable because the information timeliness interval\nfor that entry has expired.")
ptopoConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 1, 3))
ptopoConfigTrapInterval = MibScalar((1, 3, 6, 1, 2, 1, 79, 1, 3, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(5,3600),)).clone(0)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: ptopoConfigTrapInterval.setDescription("This object controls the transmission of PTOPO\nnotifications.\n\nIf this object has a value of zero, then no\nptopoConfigChange notifications will be transmitted by the\nagent.\n\nIf this object has a non-zero value, then the agent must not\ngenerate more than one ptopoConfigChange trap-event in the\nindicated period, where a 'trap-event' is the transmission\nof a single notification PDU type to a list of notification\ndestinations.  If additional configuration changes occur\nwithin the indicated throttling period, then these trap-\nevents must be suppressed by the agent. An NMS should\nperiodically check the value of ptopoLastChangeTime to\ndetect any missed ptopoConfigChange trap-events, e.g. due to\nthrottling or transmission loss.\n\n\n\nIf notification transmission is enabled, the suggested\ndefault throttling period is 60 seconds, but transmission\nshould be disabled by default.\n\nIf the agent is capable of storing non-volatile\nconfiguration, then the value of this object must be\nrestored after a re-initialization of the management\nsystem.")
ptopoConfigMaxHoldTime = MibScalar((1, 3, 6, 1, 2, 1, 79, 1, 3, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647)).clone(300)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: ptopoConfigMaxHoldTime.setDescription("This object specifies the desired time interval for which\nan agent will maintain dynamic ptopoConnEntries.\n\nAfter the specified number of seconds since the last time an\nentry was verified, in the absence of new verification\n(e.g., receipt of a topology protocol message), the agent\nshall remove the entry.  Note that entries may not always be\nremoved immediately, but may possibly be removed at periodic\ngarbage collection intervals.\nThis object only affects dynamic ptopoConnEntries, i.e.  for\nwhich ptopoConnIsStatic equals 'false(2)'. Static entries\nare not aged out.\n\nNote that dynamic ptopoConnEntries may also be removed by\nthe agent due to the expired timeliness of learned topology\ninformation (e.g., timeliness interval for a remote port\nexpires).  The actual age-out interval for a given entry is\ndefined by the following formula:\n\n  age-out-time =\n    min(ptopoConfigMaxHoldTime, <entry-specific hold-time>)\n\nwhere <entry-specific hold-time> is determined by the\ndiscovery algorithm, and may be different for each entry.")
ptopoMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 2))
ptopoMIBTrapPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 2, 0))
ptopoRegistrationPoints = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 3))
ptopoDiscoveryMechanisms = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 3, 1))
ptopoDiscoveryLocal = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 3, 1, 1))
ptopoConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 4))
ptopoCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 4, 1))
ptopoGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 79, 4, 2))

# Augmentions

# Notifications

ptopoConfigChange = NotificationType((1, 3, 6, 1, 2, 1, 79, 2, 0, 1)).setObjects(*(("PTOPO-MIB", "ptopoConnTabAgeouts"), ("PTOPO-MIB", "ptopoConnTabDrops"), ("PTOPO-MIB", "ptopoConnTabInserts"), ("PTOPO-MIB", "ptopoConnTabDeletes"), ) )
if mibBuilder.loadTexts: ptopoConfigChange.setDescription("A ptopoConfigChange notification is sent when the value of\nptopoLastChangeTime changes. It can be utilized by an NMS to\ntrigger physical topology table maintenance polls.\n\nNote that transmission of ptopoConfigChange notifications\nare throttled by the agent, as specified by the\n'ptopoConfigTrapInterval' object.")

# Groups

ptopoDataGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 79, 4, 2, 1)).setObjects(*(("PTOPO-MIB", "ptopoConnRowStatus"), ("PTOPO-MIB", "ptopoConnRemoteChassisType"), ("PTOPO-MIB", "ptopoConnLastVerifyTime"), ("PTOPO-MIB", "ptopoConnRemotePortType"), ("PTOPO-MIB", "ptopoConnMultiMacSASeen"), ("PTOPO-MIB", "ptopoConnRemoteChassis"), ("PTOPO-MIB", "ptopoConnAgentNetAddrType"), ("PTOPO-MIB", "ptopoConnRemotePort"), ("PTOPO-MIB", "ptopoConnMultiNetSASeen"), ("PTOPO-MIB", "ptopoConnAgentNetAddr"), ("PTOPO-MIB", "ptopoConnDiscAlgorithm"), ("PTOPO-MIB", "ptopoConnIsStatic"), ) )
if mibBuilder.loadTexts: ptopoDataGroup.setDescription("The collection of objects which are used to represent\nphysical topology information for which a single agent\nprovides management information.\n\nThis group is mandatory for all implementations of the PTOPO\nMIB.")
ptopoGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 79, 4, 2, 2)).setObjects(*(("PTOPO-MIB", "ptopoConnTabInserts"), ("PTOPO-MIB", "ptopoConnTabDrops"), ("PTOPO-MIB", "ptopoConnTabAgeouts"), ("PTOPO-MIB", "ptopoLastChangeTime"), ("PTOPO-MIB", "ptopoConnTabDeletes"), ) )
if mibBuilder.loadTexts: ptopoGeneralGroup.setDescription("The collection of objects which are used to report the\ngeneral status of the PTOPO MIB implementation.\n\nThis group is mandatory for all agents which implement the\nPTOPO MIB.")
ptopoConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 79, 4, 2, 3)).setObjects(*(("PTOPO-MIB", "ptopoConfigTrapInterval"), ("PTOPO-MIB", "ptopoConfigMaxHoldTime"), ) )
if mibBuilder.loadTexts: ptopoConfigGroup.setDescription("The collection of objects which are used to configure the\nPTOPO MIB implementation behavior.\n\nThis group is mandatory for agents which implement the PTOPO\nMIB.")
ptopoNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 79, 4, 2, 4)).setObjects(*(("PTOPO-MIB", "ptopoConfigChange"), ) )
if mibBuilder.loadTexts: ptopoNotificationsGroup.setDescription("The collection of notifications used to indicate PTOPO MIB\ndata consistency and general status information.\n\nThis group is mandatory for agents which implement the PTOPO\nMIB.")

# Compliances

ptopoCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 79, 4, 1, 1)).setObjects(*(("PTOPO-MIB", "ptopoDataGroup"), ("PTOPO-MIB", "ptopoGeneralGroup"), ("PTOPO-MIB", "ptopoNotificationsGroup"), ("PTOPO-MIB", "ptopoConfigGroup"), ) )
if mibBuilder.loadTexts: ptopoCompliance.setDescription("The compliance statement for SNMP entities which implement\nthe PTOPO MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("PTOPO-MIB", PYSNMP_MODULE_ID=ptopoMIB)

# Types
mibBuilder.exportSymbols("PTOPO-MIB", PtopoAddrSeenState=PtopoAddrSeenState, PtopoChassisId=PtopoChassisId, PtopoChassisIdType=PtopoChassisIdType, PtopoGenAddr=PtopoGenAddr, PtopoPortId=PtopoPortId, PtopoPortIdType=PtopoPortIdType)

# Objects
mibBuilder.exportSymbols("PTOPO-MIB", ptopoMIB=ptopoMIB, ptopoMIBObjects=ptopoMIBObjects, ptopoData=ptopoData, ptopoConnTable=ptopoConnTable, ptopoConnEntry=ptopoConnEntry, ptopoConnTimeMark=ptopoConnTimeMark, ptopoConnLocalChassis=ptopoConnLocalChassis, ptopoConnLocalPort=ptopoConnLocalPort, ptopoConnIndex=ptopoConnIndex, ptopoConnRemoteChassisType=ptopoConnRemoteChassisType, ptopoConnRemoteChassis=ptopoConnRemoteChassis, ptopoConnRemotePortType=ptopoConnRemotePortType, ptopoConnRemotePort=ptopoConnRemotePort, ptopoConnDiscAlgorithm=ptopoConnDiscAlgorithm, ptopoConnAgentNetAddrType=ptopoConnAgentNetAddrType, ptopoConnAgentNetAddr=ptopoConnAgentNetAddr, ptopoConnMultiMacSASeen=ptopoConnMultiMacSASeen, ptopoConnMultiNetSASeen=ptopoConnMultiNetSASeen, ptopoConnIsStatic=ptopoConnIsStatic, ptopoConnLastVerifyTime=ptopoConnLastVerifyTime, ptopoConnRowStatus=ptopoConnRowStatus, ptopoGeneral=ptopoGeneral, ptopoLastChangeTime=ptopoLastChangeTime, ptopoConnTabInserts=ptopoConnTabInserts, ptopoConnTabDeletes=ptopoConnTabDeletes, ptopoConnTabDrops=ptopoConnTabDrops, ptopoConnTabAgeouts=ptopoConnTabAgeouts, ptopoConfig=ptopoConfig, ptopoConfigTrapInterval=ptopoConfigTrapInterval, ptopoConfigMaxHoldTime=ptopoConfigMaxHoldTime, ptopoMIBNotifications=ptopoMIBNotifications, ptopoMIBTrapPrefix=ptopoMIBTrapPrefix, ptopoRegistrationPoints=ptopoRegistrationPoints, ptopoDiscoveryMechanisms=ptopoDiscoveryMechanisms, ptopoDiscoveryLocal=ptopoDiscoveryLocal, ptopoConformance=ptopoConformance, ptopoCompliances=ptopoCompliances, ptopoGroups=ptopoGroups)

# Notifications
mibBuilder.exportSymbols("PTOPO-MIB", ptopoConfigChange=ptopoConfigChange)

# Groups
mibBuilder.exportSymbols("PTOPO-MIB", ptopoDataGroup=ptopoDataGroup, ptopoGeneralGroup=ptopoGeneralGroup, ptopoConfigGroup=ptopoConfigGroup, ptopoNotificationsGroup=ptopoNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("PTOPO-MIB", ptopoCompliance=ptopoCompliance)
