.\" $NCDId: @(#)auconvert.man,v 1.5 1994/06/01 17:43:49 greg Exp $
.TH AUCONVERT 1 "" ""
.SH NAME
auconvert \- perform various conversion operations on sound files
.SH SYNOPSIS
.B auconvert
[\-file \fI<format>\fP] [\-data \fI<format>\fP]
[\-rate \fI<sample\ rate>\fP] [\-comment \fI<comment>\fP]
[\-raw \fI<data\ format> <num\ tracks>\fP] [\-volume \fI<percent>|`max'\fP]
[\-?] [\fI<input\ file>\fP] [\fI<output\ file>\fP]
.SH DESCRIPTION
The \fIauconvert\fP program can be used to convert from one sound file format,
and/or data format to another.  It can also change the comment, sampling rate,
and volume of a sound file.  Finally, \fIauconvert\fP can be used to convert
raw audio data into a sound file.  If no input file name is given, standard
input will be used.  If no output file name is given, the
original file will be replaced by the converted file or standard out will be
used if the input is coming from standard input.
.SH OPTIONS
The following options may be used with \fIauconvert\fP:
.IP "\fB\-file\fP \fIformat\fP" 8
The output file format.  The \-? option will display a list of valid file
formats.
.IP "\fB\-data\fP \fIformat\fP" 8
The output data format.  The \-? option will
display a list of valid data formats.  Note that each file format may only
support selected data formats.
.IP "\fB\-rate\fP \fIsample rate\fP" 8
The output sampling rate (in hertz).
.IP "\fB\-comment\fP \fIcomment\fP" 8
The comment to be stored in the output file.
.IP "\fB\-volume\fP \fI<percent>|`max'\fP" 8
The volume option can be used in two ways.  If the argument is a percentage,
the output file volume will be converted to the specified percentage of the
input volume.  If the argument is the string `max', the output file volume
will be converted to its maximum level.
.IP "\fB\-raw\fP \fI<data format> <num tracks>\fP" 8
This option is used to convert raw audio data into a sound file.
\fI<data format>\fP is the data format of the raw data.
\fI<num tracks>\fP specifies the number of tracks in the raw data.
You must also use the \fB\-file\fP and \fB\-rate\fP options when converting
raw data.
.IP "\fB\-?\fP" 8
Displays a usage message and a list of supported file and data formats.
.SH "SEE ALSO"
nas(1), auedit(1)
.SH COPYRIGHT
Copyright 1993, 1994 Network Computing Devices, Inc.
.SH AUTHOR
Greg Renda, Network Computing Devices, Inc.
