/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import com.google.common.collect.testing.google.Platform;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;

@GwtCompatible
public class MultisetWritesTester<E>
extends AbstractMultisetTester<E> {
    public static Method getEntrySetIteratorMethod() {
        return Platform.getMethod(MultisetWritesTester.class, "testEntrySet_iterator");
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrencesZero() {
        int originalCount = this.getMultiset().count(this.samples.e0);
        MultisetWritesTester.assertEquals((String)"old count", (int)originalCount, (int)this.getMultiset().add(this.samples.e0, 0));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrences() {
        int originalCount = this.getMultiset().count(this.samples.e0);
        MultisetWritesTester.assertEquals((String)"old count", (int)originalCount, (int)this.getMultiset().add(this.samples.e0, 2));
        MultisetWritesTester.assertEquals((String)"old count", (int)(originalCount + 2), (int)this.getMultiset().count(this.samples.e0));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrences_unsupported() {
        try {
            this.getMultiset().add(this.samples.e0, 2);
            MultisetWritesTester.fail((String)"unsupported multiset.add(E, int) didn't throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAdd_occurrences_negative() {
        try {
            this.getMultiset().add(this.samples.e0, -1);
            MultisetWritesTester.fail((String)"multiset.add(E, -1) didn't throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveZeroNoOp() {
        int originalCount = this.getMultiset().count(this.samples.e0);
        MultisetWritesTester.assertEquals((String)"old count", (int)originalCount, (int)this.getMultiset().remove(this.samples.e0, 0));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_present() {
        MultisetWritesTester.assertEquals((String)"multiset.remove(present, 2) didn't return the old count", (int)1, (int)this.getMultiset().remove(this.samples.e0, 2));
        MultisetWritesTester.assertFalse((String)"multiset contains present after multiset.remove(present, 2)", (boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_absent() {
        MultisetWritesTester.assertEquals((String)"multiset.remove(absent, 0) didn't return 0", (int)0, (int)this.getMultiset().remove(this.samples.e3, 2));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_unsupported_absent() {
        try {
            MultisetWritesTester.assertEquals((String)"multiset.remove(absent, 2) didn't return 0 or throw an exception", (int)0, (int)this.getMultiset().remove(this.samples.e3, 2));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_0() {
        int oldCount = this.getMultiset().count(this.samples.e0);
        MultisetWritesTester.assertEquals((String)"multiset.remove(E, 0) didn't return the old count", (int)oldCount, (int)this.getMultiset().remove(this.samples.e0, 0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_negative() {
        try {
            this.getMultiset().remove(this.samples.e0, -1);
            MultisetWritesTester.fail((String)"multiset.remove(E, -1) didn't throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_wrongType() {
        MultisetWritesTester.assertEquals((String)"multiset.remove(wrongType, 1) didn't return 0", (int)0, (int)this.getMultiset().remove((Object)WrongType.VALUE, 1));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_clear() {
        this.getMultiset().entrySet().clear();
        MultisetWritesTester.assertTrue((String)"multiset not empty after entrySet().clear()", (boolean)this.getMultiset().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_iterator() {
        Iterator iterator = this.getMultiset().entrySet().iterator();
        MultisetWritesTester.assertTrue((String)"non-empty multiset.entrySet() iterator.hasNext() returned false", (boolean)iterator.hasNext());
        MultisetWritesTester.assertEquals((String)"multiset.entrySet() iterator.next() returned incorrect entry", (Object)Multisets.immutableEntry(this.samples.e0, (int)1), iterator.next());
        MultisetWritesTester.assertFalse((String)"size 1 multiset.entrySet() iterator.hasNext() returned true after next()", (boolean)iterator.hasNext());
        iterator.remove();
        MultisetWritesTester.assertTrue((String)"multiset isn't empty after multiset.entrySet() iterator.remove()", (boolean)this.getMultiset().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_iterator_remove_unsupported() {
        Iterator iterator = this.getMultiset().entrySet().iterator();
        MultisetWritesTester.assertTrue((String)"non-empty multiset.entrySet() iterator.hasNext() returned false", (boolean)iterator.hasNext());
        try {
            iterator.remove();
            MultisetWritesTester.fail((String)"multiset.entrySet() iterator.remove() didn't throw an exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_remove_present() {
        MultisetWritesTester.assertTrue((String)"multiset.entrySet.remove(presentEntry) returned false", (boolean)this.getMultiset().entrySet().remove(Multisets.immutableEntry(this.samples.e0, (int)1)));
        MultisetWritesTester.assertFalse((String)"multiset contains element after removing its entry", (boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_remove_missing() {
        MultisetWritesTester.assertFalse((String)"multiset.entrySet.remove(missingEntry) returned true", (boolean)this.getMultiset().entrySet().remove(Multisets.immutableEntry(this.samples.e0, (int)2)));
        MultisetWritesTester.assertTrue((String)"multiset didn't contain element after removing a missing entry", (boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAll_present() {
        MultisetWritesTester.assertTrue((String)"multiset.entrySet.removeAll(presentEntry) returned false", (boolean)this.getMultiset().entrySet().removeAll(Collections.singleton(Multisets.immutableEntry(this.samples.e0, (int)1))));
        MultisetWritesTester.assertFalse((String)"multiset contains element after removing its entry", (boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAll_missing() {
        MultisetWritesTester.assertFalse((String)"multiset.entrySet.remove(missingEntry) returned true", (boolean)this.getMultiset().entrySet().removeAll(Collections.singleton(Multisets.immutableEntry(this.samples.e0, (int)2))));
        MultisetWritesTester.assertTrue((String)"multiset didn't contain element after removing a missing entry", (boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAll_null() {
        try {
            this.getMultiset().entrySet().removeAll(null);
            MultisetWritesTester.fail((String)"multiset.entrySet.removeAll(null) didn't throw an exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_retainAll_present() {
        MultisetWritesTester.assertFalse((String)"multiset.entrySet.retainAll(presentEntry) returned false", (boolean)this.getMultiset().entrySet().retainAll(Collections.singleton(Multisets.immutableEntry(this.samples.e0, (int)1))));
        MultisetWritesTester.assertTrue((String)"multiset doesn't contains element after retaining its entry", (boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_retainAll_missing() {
        MultisetWritesTester.assertTrue((String)"multiset.entrySet.retainAll(missingEntry) returned true", (boolean)this.getMultiset().entrySet().retainAll(Collections.singleton(Multisets.immutableEntry(this.samples.e0, (int)2))));
        MultisetWritesTester.assertFalse((String)"multiset contains element after retaining a different entry", (boolean)this.getMultiset().contains(this.samples.e0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_retainAll_null() {
        try {
            this.getMultiset().entrySet().retainAll(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

