/*
 * Copyright (C) 2011 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.i18n.phonenumbers;

/**
 * Class containing string constants of region codes for easier testing.
 */
final class RegionCode {
  // Region code for global networks (e.g. +800 numbers).
  static final String UN001 = "001";
  static final String AD = "AD";
  static final String AE = "AE";
  static final String AM = "AM";
  static final String AO = "AO";
  static final String AQ = "AQ";
  static final String AR = "AR";
  static final String AU = "AU";
  static final String BB = "BB";
  static final String BR = "BR";
  static final String BS = "BS";
  static final String BY = "BY";
  static final String CA = "CA";
  static final String CH = "CH";
  static final String CL = "CL";
  static final String CN = "CN";
  static final String CO = "CO";
  static final String CS = "CS";
  static final String CX = "CX";
  static final String DE = "DE";
  static final String FR = "FR";
  static final String GB = "GB";
  static final String HU = "HU";
  static final String IT = "IT";
  static final String JP = "JP";
  static final String KR = "KR";
  static final String MX = "MX";
  static final String NZ = "NZ";
  static final String PG = "PG";
  static final String PL = "PL";
  static final String RE = "RE";
  static final String RU = "RU";
  static final String SE = "SE";
  static final String SG = "SG";
  static final String US = "US";
  static final String UZ = "UZ";
  static final String YT = "YT";
  static final String ZW = "ZW";
  // Official code for the unknown region.
  static final String ZZ = "ZZ";
}
