/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpClass;
import com.claritysys.jvm.classfile.CpEntry;
import com.claritysys.jvm.classfile.CpNameAndType;
import com.claritysys.jvm.classfile.Utils;
import java.io.DataOutput;
import java.io.IOException;

public final class CpRef
extends CpEntry {
    CpClass clas;
    CpNameAndType nameAndType;
    int stackSize = -1;
    int nonStaticStackSize = -1;

    public final CpClass getCpClass() {
        return this.clas;
    }

    public final CpNameAndType getNameAndType() {
        return this.nameAndType;
    }

    CpRef(ConstantPool cpool, int hash, byte tag, CpClass clas, CpNameAndType nameAndType) {
        super(cpool, tag, hash);
        this.tag = tag;
        this.clas = clas;
        this.nameAndType = nameAndType;
    }

    CpRef(ConstantPool cpool, byte tag) {
        super(cpool, tag, 0);
    }

    void write(DataOutput dstr) throws IOException {
        dstr.writeByte(this.tag);
        dstr.writeShort(this.clas.index);
        dstr.writeShort(this.nameAndType.index);
    }

    public int getStackSize() {
        int size = this.stackSize;
        if (size == -1) {
            size = this.tag == 9 ? Utils.getStackWords(this.nameAndType.getType().getString()) : Utils.getStackWords(Utils.getMethodReturnType(this.nameAndType.getType().getString()));
            this.stackSize = size;
        }
        return size;
    }

    public int getNonStaticStackSize() {
        int size = this.nonStaticStackSize;
        if (size == -1) {
            this.nonStaticStackSize = size = Utils.getMethodStackWords(this.nameAndType.getType().getString()) + 1;
        }
        return size;
    }

    public void computeHash() {
        if (this.clas.hash == 0) {
            this.clas.computeHash();
        }
        if (this.nameAndType.hash == 0) {
            this.nameAndType.computeHash();
        }
        this.hash = this.clas.hash ^ this.nameAndType.hash;
    }

    public String toString() {
        return "Ref:     [Class " + this.clas.getIndex() + " NameAndType " + this.nameAndType.getIndex() + "]";
    }

    void postClone() {
        super.postClone();
        this.nameAndType = (CpNameAndType)this.pool.getPoolEntry(this.nameAndType.index);
        this.clas = (CpClass)this.pool.getPoolEntry(this.clas.index);
    }
}

