/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import alt.jiapi.JiapiException;
import alt.jiapi.Rule;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.util.HotSpot;
import java.util.ArrayList;

public class HotSpotLocator {
    private InstructionList il;
    private byte[] opCodes;
    private Rule rule;

    public HotSpotLocator(InstructionList il, byte opCode) {
        this(il, new byte[]{opCode}, "*");
    }

    public HotSpotLocator(InstructionList il, byte[] opCodes) {
        this(il, opCodes, "*");
    }

    public HotSpotLocator(InstructionList il, byte[] opCodes, String resolution) {
        this.il = il;
        this.opCodes = opCodes;
        try {
            this.rule = new Rule(resolution);
        }
        catch (JiapiException je) {
            // empty catch block
        }
    }

    public HotSpot[] getHotSpots() {
        ArrayList<HotSpot> al = new ArrayList<HotSpot>();
        for (int i = 0; i < this.il.size(); ++i) {
            Instruction ins = this.il.get(i);
            short opCode = ins.getOpcode();
            for (int j = 0; j < this.opCodes.length; ++j) {
                if (opCode != this.opCodes[j]) continue;
                HotSpot hs = this.createHotSpot(this.il, i);
                al.add(hs);
            }
        }
        return al.toArray(new HotSpot[0]);
    }

    private HotSpot createHotSpot(InstructionList il, int idx) {
        Instruction end;
        Instruction start = end = il.get(idx);
        int stackConsumption = end.stackConsumption();
        while (stackConsumption > 0) {
            start = il.get(idx - 1);
            stackConsumption -= start.stackUsage();
            --idx;
        }
        return new HotSpot(il, start, end);
    }
}

