/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.MethodExistsException;
import alt.jiapi.reflect.Signature;
import java.lang.reflect.Modifier;
import org.apache.log4j.Category;

public class CreateMethodInstrumentor
extends AbstractInstrumentor {
    private static Category log = Runtime.getLogCategory(CreateMethodInstrumentor.class);
    public static int FORWARD_ORIGINAL = 1;
    public static int FORWARD_NEW = 2;
    public static int FORWARD_BOTH = 3;
    private static int DEFAULT = FORWARD_NEW;
    private int modifiers;
    private String returnType;
    private String methodName;
    private String[] parameterNames;
    private int forwardMode = DEFAULT;
    private boolean createReturn = true;

    public CreateMethodInstrumentor(int modifiers, String methodName) {
        this(modifiers, "void", methodName, new String[0]);
    }

    public CreateMethodInstrumentor(int modifiers, String returnType, String methodName) {
        this(modifiers, returnType, methodName, new String[0]);
    }

    public CreateMethodInstrumentor(int modifiers, String methodName, String[] parameterNames) {
        this(modifiers, "void", methodName, parameterNames);
    }

    public CreateMethodInstrumentor(JiapiMethod method) {
        this(method.getModifiers(), method.getReturnType(), method.getName(), method.getParameterTypeNames());
    }

    public CreateMethodInstrumentor(int modifiers, String returnType, String methodName, String[] parameterNames) {
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.parameterNames = parameterNames;
        this.returnType = returnType;
    }

    public void setForwardMode(int forwardMode) {
        this.forwardMode = forwardMode;
    }

    public void setCreateReturn(boolean b) {
        this.createReturn = b;
    }

    public void instrument(InstructionList il) {
        JiapiClass clazz = this.getCurrentClass();
        if (Modifier.isInterface(clazz.getModifiers()) && !Modifier.isPublic(this.modifiers)) {
            log.info((Object)("Cannot create non public method " + this.methodName + " to interface " + clazz.getName()));
            this.forward(il);
            return;
        }
        log.info((Object)("Creating method " + clazz.getName() + "." + this.methodName));
        JiapiMethod method = null;
        try {
            Signature signature = new Signature(this.returnType, this.parameterNames);
            method = clazz.addMethod((short)this.modifiers, this.methodName, signature);
        }
        catch (MethodExistsException mee) {
            log.info((Object)("method " + clazz.getName() + "." + this.methodName + " already exists"));
            method = mee.getMethod();
        }
        if (this.forwardMode == FORWARD_ORIGINAL) {
            this.forward(il);
        } else if (this.forwardMode == FORWARD_NEW) {
            this.forward(method.getInstructionList());
        } else {
            this.forward(il);
            this.forward(method.getInstructionList());
        }
        if (this.createReturn) {
            InstructionFactory factory = method.getInstructionFactory();
            method.getInstructionList().add(factory.returnMethod(method));
        }
    }
}

