; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-shuffle | FileCheck %s --check-prefixes=AVX,AVX512

declare <1 x i8> @llvm.ssub.sat.v1i8(<1 x i8>, <1 x i8>)
declare <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8>, <2 x i8>)
declare <4 x i8> @llvm.ssub.sat.v4i8(<4 x i8>, <4 x i8>)
declare <8 x i8> @llvm.ssub.sat.v8i8(<8 x i8>, <8 x i8>)
declare <12 x i8> @llvm.ssub.sat.v12i8(<12 x i8>, <12 x i8>)
declare <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8>, <64 x i8>)

declare <1 x i16> @llvm.ssub.sat.v1i16(<1 x i16>, <1 x i16>)
declare <2 x i16> @llvm.ssub.sat.v2i16(<2 x i16>, <2 x i16>)
declare <4 x i16> @llvm.ssub.sat.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16>, <8 x i16>)
declare <12 x i16> @llvm.ssub.sat.v12i16(<12 x i16>, <12 x i16>)
declare <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16>, <32 x i16>)

declare <16 x i1> @llvm.ssub.sat.v16i1(<16 x i1>, <16 x i1>)
declare <16 x i4> @llvm.ssub.sat.v16i4(<16 x i4>, <16 x i4>)

declare <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i32> @llvm.ssub.sat.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i24> @llvm.ssub.sat.v4i24(<4 x i24>, <4 x i24>)
declare <2 x i128> @llvm.ssub.sat.v2i128(<2 x i128>, <2 x i128>)

; Legal types, depending on architecture.

define <16 x i8> @v16i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE-LABEL: v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i8> %z
}

define <32 x i8> @v32i8(<32 x i8> %x, <32 x i8> %y) nounwind {
; SSE-LABEL: v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsb %xmm2, %xmm0
; SSE-NEXT:    psubsb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubsb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubsb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> %x, <32 x i8> %y)
  ret <32 x i8> %z
}

define <64 x i8> @v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; SSE-LABEL: v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsb %xmm4, %xmm0
; SSE-NEXT:    psubsb %xmm5, %xmm1
; SSE-NEXT:    psubsb %xmm6, %xmm2
; SSE-NEXT:    psubsb %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpsubsb %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpsubsb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpsubsb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsubsb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubsb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubsb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubsb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> %x, <64 x i8> %y)
  ret <64 x i8> %z
}

define <8 x i16> @v8i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE-LABEL: v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  ret <8 x i16> %z
}

define <16 x i16> @v16i16(<16 x i16> %x, <16 x i16> %y) nounwind {
; SSE-LABEL: v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsw %xmm2, %xmm0
; SSE-NEXT:    psubsw %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubsw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubsw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> %x, <16 x i16> %y)
  ret <16 x i16> %z
}

define <32 x i16> @v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; SSE-LABEL: v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsw %xmm4, %xmm0
; SSE-NEXT:    psubsw %xmm5, %xmm1
; SSE-NEXT:    psubsw %xmm6, %xmm2
; SSE-NEXT:    psubsw %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpsubsw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpsubsw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpsubsw %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsubsw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubsw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubsw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubsw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> %x, <32 x i16> %y)
  ret <32 x i16> %z
}

; Too narrow vectors, legalized by widening.

define void @v8i8(<8 x i8>* %px, <8 x i8>* %py, <8 x i8>* %pz) nounwind {
; SSE-LABEL: v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    psubsb %xmm1, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpmovwb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <8 x i8>, <8 x i8>* %px
  %y = load <8 x i8>, <8 x i8>* %py
  %z = call <8 x i8> @llvm.ssub.sat.v8i8(<8 x i8> %x, <8 x i8> %y)
  store <8 x i8> %z, <8 x i8>* %pz
  ret void
}

define void @v4i8(<4 x i8>* %px, <4 x i8>* %py, <4 x i8>* %pz) nounwind {
; SSE-LABEL: v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    psubsb %xmm1, %xmm0
; SSE-NEXT:    movd %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX512-NEXT:    vpmovdb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i8>, <4 x i8>* %px
  %y = load <4 x i8>, <4 x i8>* %py
  %z = call <4 x i8> @llvm.ssub.sat.v4i8(<4 x i8> %x, <4 x i8> %y)
  store <4 x i8> %z, <4 x i8>* %pz
  ret void
}

define void @v2i8(<2 x i8>* %px, <2 x i8>* %py, <2 x i8>* %pz) nounwind {
; SSE2-LABEL: v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    movzwl (%rsi), %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    psubsb %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdx)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    movzwl (%rsi), %eax
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    psubsb %xmm1, %xmm0
; SSSE3-NEXT:    movd %xmm0, %eax
; SSSE3-NEXT:    movw %ax, (%rdx)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movzwl (%rsi), %eax
; SSE41-NEXT:    movd %eax, %xmm1
; SSE41-NEXT:    psubsb %xmm1, %xmm0
; SSE41-NEXT:    pextrw $0, %xmm0, (%rdx)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    movzwl (%rsi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movzwl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    movzwl (%rsi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movzwl (%rdi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm0
; AVX512-NEXT:    movzwl (%rsi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm1
; AVX512-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpmovqb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i8>, <2 x i8>* %px
  %y = load <2 x i8>, <2 x i8>* %py
  %z = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> %x, <2 x i8> %y)
  store <2 x i8> %z, <2 x i8>* %pz
  ret void
}

define void @v4i16(<4 x i16>* %px, <4 x i16>* %py, <4 x i16>* %pz) nounwind {
; SSE-LABEL: v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    psubsw %xmm1, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512-NEXT:    vpmovdw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i16>, <4 x i16>* %px
  %y = load <4 x i16>, <4 x i16>* %py
  %z = call <4 x i16> @llvm.ssub.sat.v4i16(<4 x i16> %x, <4 x i16> %y)
  store <4 x i16> %z, <4 x i16>* %pz
  ret void
}

define void @v2i16(<2 x i16>* %px, <2 x i16>* %py, <2 x i16>* %pz) nounwind {
; SSE-LABEL: v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    psubsw %xmm1, %xmm0
; SSE-NEXT:    movd %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; AVX512-NEXT:    vpmovqw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i16>, <2 x i16>* %px
  %y = load <2 x i16>, <2 x i16>* %py
  %z = call <2 x i16> @llvm.ssub.sat.v2i16(<2 x i16> %x, <2 x i16> %y)
  store <2 x i16> %z, <2 x i16>* %pz
  ret void
}

define <12 x i8> @v12i8(<12 x i8> %x, <12 x i8> %y) nounwind {
; SSE-LABEL: v12i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubsb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v12i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <12 x i8> @llvm.ssub.sat.v12i8(<12 x i8> %x, <12 x i8> %y)
  ret <12 x i8> %z
}

define void @v12i16(<12 x i16>* %px, <12 x i16>* %py, <12 x i16>* %pz) nounwind {
; SSE-LABEL: v12i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    psubsw (%rsi), %xmm0
; SSE-NEXT:    psubsw 16(%rsi), %xmm1
; SSE-NEXT:    movq %xmm1, 16(%rdx)
; SSE-NEXT:    movdqa %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v12i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vpsubsw (%rsi), %xmm0, %xmm0
; AVX1-NEXT:    vpsubsw 16(%rsi), %xmm1, %xmm1
; AVX1-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX1-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v12i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpsubsw (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v12i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpsubsw (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %x = load <12 x i16>, <12 x i16>* %px
  %y = load <12 x i16>, <12 x i16>* %py
  %z = call <12 x i16> @llvm.ssub.sat.v12i16(<12 x i16> %x, <12 x i16> %y)
  store <12 x i16> %z, <12 x i16>* %pz
  ret void
}

; Scalarization

define void @v1i8(<1 x i8>* %px, <1 x i8>* %py, <1 x i8>* %pz) nounwind {
; SSE-LABEL: v1i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movb (%rdi), %cl
; SSE-NEXT:    movb (%rsi), %dil
; SSE-NEXT:    movl %ecx, %eax
; SSE-NEXT:    subb %dil, %al
; SSE-NEXT:    setns %sil
; SSE-NEXT:    subb %dil, %cl
; SSE-NEXT:    jno .LBB13_2
; SSE-NEXT:  # %bb.1:
; SSE-NEXT:    addb $127, %sil
; SSE-NEXT:    movl %esi, %ecx
; SSE-NEXT:  .LBB13_2:
; SSE-NEXT:    movb %cl, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i8:
; AVX:       # %bb.0:
; AVX-NEXT:    movb (%rdi), %cl
; AVX-NEXT:    movb (%rsi), %dil
; AVX-NEXT:    movl %ecx, %eax
; AVX-NEXT:    subb %dil, %al
; AVX-NEXT:    setns %sil
; AVX-NEXT:    subb %dil, %cl
; AVX-NEXT:    jno .LBB13_2
; AVX-NEXT:  # %bb.1:
; AVX-NEXT:    addb $127, %sil
; AVX-NEXT:    movl %esi, %ecx
; AVX-NEXT:  .LBB13_2:
; AVX-NEXT:    movb %cl, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i8>, <1 x i8>* %px
  %y = load <1 x i8>, <1 x i8>* %py
  %z = call <1 x i8> @llvm.ssub.sat.v1i8(<1 x i8> %x, <1 x i8> %y)
  store <1 x i8> %z, <1 x i8>* %pz
  ret void
}

define void @v1i16(<1 x i16>* %px, <1 x i16>* %py, <1 x i16>* %pz) nounwind {
; SSE-LABEL: v1i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    movzwl (%rsi), %ecx
; SSE-NEXT:    xorl %esi, %esi
; SSE-NEXT:    movl %eax, %edi
; SSE-NEXT:    subw %cx, %di
; SSE-NEXT:    setns %sil
; SSE-NEXT:    addl $32767, %esi # imm = 0x7FFF
; SSE-NEXT:    subw %cx, %ax
; SSE-NEXT:    cmovol %esi, %eax
; SSE-NEXT:    movw %ax, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i16:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    movzwl (%rsi), %ecx
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %eax, %edi
; AVX-NEXT:    subw %cx, %di
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $32767, %esi # imm = 0x7FFF
; AVX-NEXT:    subw %cx, %ax
; AVX-NEXT:    cmovol %esi, %eax
; AVX-NEXT:    movw %ax, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i16>, <1 x i16>* %px
  %y = load <1 x i16>, <1 x i16>* %py
  %z = call <1 x i16> @llvm.ssub.sat.v1i16(<1 x i16> %x, <1 x i16> %y)
  store <1 x i16> %z, <1 x i16>* %pz
  ret void
}

; Promotion

define <16 x i4> @v16i4(<16 x i4> %x, <16 x i4> %y) nounwind {
; SSE-LABEL: v16i4:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $4, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $4, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    psubsb %xmm1, %xmm0
; SSE-NEXT:    psrlw $4, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psubb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i4:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i4> @llvm.ssub.sat.v16i4(<16 x i4> %x, <16 x i4> %y)
  ret <16 x i4> %z
}

define <16 x i1> @v16i1(<16 x i1> %x, <16 x i1> %y) nounwind {
; SSE-LABEL: v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $7, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    psubsb %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512-NEXT:    vpmovb2m %xmm0, %k0
; AVX512-NEXT:    vpsllw $7, %xmm1, %xmm0
; AVX512-NEXT:    vpmovb2m %xmm0, %k1
; AVX512-NEXT:    kandnw %k0, %k1, %k0
; AVX512-NEXT:    vpmovm2b %k0, %xmm0
; AVX512-NEXT:    retq
  %z = call <16 x i1> @llvm.ssub.sat.v16i1(<16 x i1> %x, <16 x i1> %y)
  ret <16 x i1> %z
}

; Expanded

define <4 x i32> @v4i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; SSE2-LABEL: v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,2,3]
; SSE2-NEXT:    movd %xmm2, %r8d
; SSE2-NEXT:    xorl %edx, %edx
; SSE2-NEXT:    movl %r8d, %esi
; SSE2-NEXT:    subl %ecx, %esi
; SSE2-NEXT:    setns %dl
; SSE2-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %ecx, %r8d
; SSE2-NEXT:    cmovol %edx, %r8d
; SSE2-NEXT:    movd %xmm1, %edx
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    xorl %esi, %esi
; SSE2-NEXT:    movl %ecx, %edi
; SSE2-NEXT:    subl %edx, %edi
; SSE2-NEXT:    setns %sil
; SSE2-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %edx, %ecx
; SSE2-NEXT:    cmovol %esi, %ecx
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm2, %edx
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    xorl %edi, %edi
; SSE2-NEXT:    movl %eax, %esi
; SSE2-NEXT:    subl %edx, %esi
; SSE2-NEXT:    setns %dil
; SSE2-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %edx, %eax
; SSE2-NEXT:    cmovol %edi, %eax
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE2-NEXT:    movd %xmm1, %r9d
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, %edx
; SSE2-NEXT:    xorl %edi, %edi
; SSE2-NEXT:    movl %edx, %esi
; SSE2-NEXT:    subl %r9d, %esi
; SSE2-NEXT:    setns %dil
; SSE2-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %r9d, %edx
; SSE2-NEXT:    cmovol %edi, %edx
; SSE2-NEXT:    movd %edx, %xmm0
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movd %ecx, %xmm0
; SSE2-NEXT:    movd %r8d, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %ecx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %r8d
; SSSE3-NEXT:    xorl %edx, %edx
; SSSE3-NEXT:    movl %r8d, %esi
; SSSE3-NEXT:    subl %ecx, %esi
; SSSE3-NEXT:    setns %dl
; SSSE3-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %ecx, %r8d
; SSSE3-NEXT:    cmovol %edx, %r8d
; SSSE3-NEXT:    movd %xmm1, %edx
; SSSE3-NEXT:    movd %xmm0, %ecx
; SSSE3-NEXT:    xorl %esi, %esi
; SSSE3-NEXT:    movl %ecx, %edi
; SSSE3-NEXT:    subl %edx, %edi
; SSSE3-NEXT:    setns %sil
; SSSE3-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %edx, %ecx
; SSSE3-NEXT:    cmovol %esi, %ecx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSSE3-NEXT:    movd %xmm2, %edx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movd %xmm2, %eax
; SSSE3-NEXT:    xorl %edi, %edi
; SSSE3-NEXT:    movl %eax, %esi
; SSSE3-NEXT:    subl %edx, %esi
; SSSE3-NEXT:    setns %dil
; SSSE3-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %edx, %eax
; SSSE3-NEXT:    cmovol %edi, %eax
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSSE3-NEXT:    movd %xmm1, %r9d
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSSE3-NEXT:    movd %xmm0, %edx
; SSSE3-NEXT:    xorl %edi, %edi
; SSSE3-NEXT:    movl %edx, %esi
; SSSE3-NEXT:    subl %r9d, %esi
; SSSE3-NEXT:    setns %dil
; SSSE3-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %r9d, %edx
; SSSE3-NEXT:    cmovol %edi, %edx
; SSSE3-NEXT:    movd %edx, %xmm0
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSSE3-NEXT:    movd %ecx, %xmm0
; SSSE3-NEXT:    movd %r8d, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pextrd $3, %xmm1, %ecx
; SSE41-NEXT:    pextrd $3, %xmm0, %r8d
; SSE41-NEXT:    xorl %edx, %edx
; SSE41-NEXT:    movl %r8d, %esi
; SSE41-NEXT:    subl %ecx, %esi
; SSE41-NEXT:    setns %dl
; SSE41-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %ecx, %r8d
; SSE41-NEXT:    cmovol %edx, %r8d
; SSE41-NEXT:    pextrd $2, %xmm1, %edx
; SSE41-NEXT:    pextrd $2, %xmm0, %ecx
; SSE41-NEXT:    xorl %esi, %esi
; SSE41-NEXT:    movl %ecx, %edi
; SSE41-NEXT:    subl %edx, %edi
; SSE41-NEXT:    setns %sil
; SSE41-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %edx, %ecx
; SSE41-NEXT:    cmovol %esi, %ecx
; SSE41-NEXT:    movd %xmm1, %edx
; SSE41-NEXT:    movd %xmm0, %eax
; SSE41-NEXT:    xorl %edi, %edi
; SSE41-NEXT:    movl %eax, %esi
; SSE41-NEXT:    subl %edx, %esi
; SSE41-NEXT:    setns %dil
; SSE41-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %edx, %eax
; SSE41-NEXT:    cmovol %edi, %eax
; SSE41-NEXT:    pextrd $1, %xmm1, %r9d
; SSE41-NEXT:    pextrd $1, %xmm0, %edx
; SSE41-NEXT:    xorl %edi, %edi
; SSE41-NEXT:    movl %edx, %esi
; SSE41-NEXT:    subl %r9d, %esi
; SSE41-NEXT:    setns %dil
; SSE41-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %r9d, %edx
; SSE41-NEXT:    cmovol %edi, %edx
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pinsrd $1, %edx, %xmm0
; SSE41-NEXT:    pinsrd $2, %ecx, %xmm0
; SSE41-NEXT:    pinsrd $3, %r8d, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpextrd $3, %xmm1, %ecx
; AVX-NEXT:    vpextrd $3, %xmm0, %r9d
; AVX-NEXT:    xorl %edx, %edx
; AVX-NEXT:    movl %r9d, %esi
; AVX-NEXT:    subl %ecx, %esi
; AVX-NEXT:    setns %dl
; AVX-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %ecx, %r9d
; AVX-NEXT:    cmovol %edx, %r9d
; AVX-NEXT:    vpextrd $2, %xmm1, %edx
; AVX-NEXT:    vpextrd $2, %xmm0, %ecx
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %ecx, %edi
; AVX-NEXT:    subl %edx, %edi
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    cmovol %esi, %ecx
; AVX-NEXT:    vmovd %xmm1, %r8d
; AVX-NEXT:    vmovd %xmm0, %edx
; AVX-NEXT:    xorl %edi, %edi
; AVX-NEXT:    movl %edx, %esi
; AVX-NEXT:    subl %r8d, %esi
; AVX-NEXT:    setns %dil
; AVX-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %r8d, %edx
; AVX-NEXT:    cmovol %edi, %edx
; AVX-NEXT:    vpextrd $1, %xmm1, %r8d
; AVX-NEXT:    vpextrd $1, %xmm0, %eax
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %eax, %edi
; AVX-NEXT:    subl %r8d, %edi
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %r8d, %eax
; AVX-NEXT:    cmovol %esi, %eax
; AVX-NEXT:    vmovd %edx, %xmm0
; AVX-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; AVX-NEXT:    vpinsrd $2, %ecx, %xmm0, %xmm0
; AVX-NEXT:    vpinsrd $3, %r9d, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %z
}

define <2 x i32> @v2i32(<2 x i32> %x, <2 x i32> %y) nounwind {
; SSE2-LABEL: v2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllq $32, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    psllq $32, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSE2-NEXT:    movq %xmm2, %rcx
; SSE2-NEXT:    xorl %edx, %edx
; SSE2-NEXT:    movq %rcx, %rsi
; SSE2-NEXT:    subq %rax, %rsi
; SSE2-NEXT:    setns %dl
; SSE2-NEXT:    movabsq $9223372036854775807, %r8 # imm = 0x7FFFFFFFFFFFFFFF
; SSE2-NEXT:    addq %r8, %rdx
; SSE2-NEXT:    subq %rax, %rcx
; SSE2-NEXT:    cmovoq %rdx, %rcx
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    movq %xmm0, %rsi
; SSE2-NEXT:    xorl %edi, %edi
; SSE2-NEXT:    movq %rsi, %rdx
; SSE2-NEXT:    subq %rax, %rdx
; SSE2-NEXT:    setns %dil
; SSE2-NEXT:    addq %r8, %rdi
; SSE2-NEXT:    subq %rax, %rsi
; SSE2-NEXT:    cmovoq %rdi, %rsi
; SSE2-NEXT:    movq %rsi, %xmm1
; SSE2-NEXT:    movq %rcx, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,3,2,3]
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    psllq $32, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSSE3-NEXT:    movq %xmm2, %rax
; SSSE3-NEXT:    psllq $32, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movq %xmm2, %rcx
; SSSE3-NEXT:    xorl %edx, %edx
; SSSE3-NEXT:    movq %rcx, %rsi
; SSSE3-NEXT:    subq %rax, %rsi
; SSSE3-NEXT:    setns %dl
; SSSE3-NEXT:    movabsq $9223372036854775807, %r8 # imm = 0x7FFFFFFFFFFFFFFF
; SSSE3-NEXT:    addq %r8, %rdx
; SSSE3-NEXT:    subq %rax, %rcx
; SSSE3-NEXT:    cmovoq %rdx, %rcx
; SSSE3-NEXT:    movq %xmm1, %rax
; SSSE3-NEXT:    movq %xmm0, %rsi
; SSSE3-NEXT:    xorl %edi, %edi
; SSSE3-NEXT:    movq %rsi, %rdx
; SSSE3-NEXT:    subq %rax, %rdx
; SSSE3-NEXT:    setns %dil
; SSSE3-NEXT:    addq %r8, %rdi
; SSSE3-NEXT:    subq %rax, %rsi
; SSSE3-NEXT:    cmovoq %rdi, %rsi
; SSSE3-NEXT:    movq %rsi, %xmm1
; SSSE3-NEXT:    movq %rcx, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,3,2,3]
; SSSE3-NEXT:    psrad $31, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,3,2,3]
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    psllq $32, %xmm1
; SSE41-NEXT:    movq %xmm1, %rax
; SSE41-NEXT:    psllq $32, %xmm0
; SSE41-NEXT:    movq %xmm0, %rcx
; SSE41-NEXT:    xorl %edx, %edx
; SSE41-NEXT:    movq %rcx, %rsi
; SSE41-NEXT:    subq %rax, %rsi
; SSE41-NEXT:    setns %dl
; SSE41-NEXT:    movabsq $9223372036854775807, %r8 # imm = 0x7FFFFFFFFFFFFFFF
; SSE41-NEXT:    addq %r8, %rdx
; SSE41-NEXT:    subq %rax, %rcx
; SSE41-NEXT:    cmovoq %rdx, %rcx
; SSE41-NEXT:    pextrq $1, %xmm1, %rax
; SSE41-NEXT:    pextrq $1, %xmm0, %rsi
; SSE41-NEXT:    xorl %edi, %edi
; SSE41-NEXT:    movq %rsi, %rdx
; SSE41-NEXT:    subq %rax, %rdx
; SSE41-NEXT:    setns %dil
; SSE41-NEXT:    addq %r8, %rdi
; SSE41-NEXT:    subq %rax, %rsi
; SSE41-NEXT:    cmovoq %rdi, %rsi
; SSE41-NEXT:    movq %rsi, %xmm1
; SSE41-NEXT:    movq %rcx, %xmm0
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE41-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,3,3]
; SSE41-NEXT:    psrad $31, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3],xmm1[4,5],xmm0[6,7]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vmovq %xmm1, %rax
; AVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, %rcx
; AVX1-NEXT:    xorl %edx, %edx
; AVX1-NEXT:    movq %rcx, %rsi
; AVX1-NEXT:    subq %rax, %rsi
; AVX1-NEXT:    setns %dl
; AVX1-NEXT:    movabsq $9223372036854775807, %r8 # imm = 0x7FFFFFFFFFFFFFFF
; AVX1-NEXT:    addq %r8, %rdx
; AVX1-NEXT:    subq %rax, %rcx
; AVX1-NEXT:    cmovoq %rdx, %rcx
; AVX1-NEXT:    vpextrq $1, %xmm1, %rax
; AVX1-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX1-NEXT:    xorl %edi, %edi
; AVX1-NEXT:    movq %rsi, %rdx
; AVX1-NEXT:    subq %rax, %rdx
; AVX1-NEXT:    setns %dil
; AVX1-NEXT:    addq %r8, %rdi
; AVX1-NEXT:    subq %rax, %rsi
; AVX1-NEXT:    cmovoq %rdi, %rsi
; AVX1-NEXT:    vmovq %rsi, %xmm0
; AVX1-NEXT:    vmovq %rcx, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, %rcx
; AVX2-NEXT:    xorl %edx, %edx
; AVX2-NEXT:    movq %rcx, %rsi
; AVX2-NEXT:    subq %rax, %rsi
; AVX2-NEXT:    setns %dl
; AVX2-NEXT:    movabsq $9223372036854775807, %r8 # imm = 0x7FFFFFFFFFFFFFFF
; AVX2-NEXT:    addq %r8, %rdx
; AVX2-NEXT:    subq %rax, %rcx
; AVX2-NEXT:    cmovoq %rdx, %rcx
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX2-NEXT:    xorl %edi, %edi
; AVX2-NEXT:    movq %rsi, %rdx
; AVX2-NEXT:    subq %rax, %rdx
; AVX2-NEXT:    setns %dil
; AVX2-NEXT:    addq %r8, %rdi
; AVX2-NEXT:    subq %rax, %rsi
; AVX2-NEXT:    cmovoq %rdi, %rsi
; AVX2-NEXT:    vmovq %rsi, %xmm0
; AVX2-NEXT:    vmovq %rcx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX512-NEXT:    vmovq %xmm1, %rax
; AVX512-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX512-NEXT:    vmovq %xmm0, %rcx
; AVX512-NEXT:    xorl %edx, %edx
; AVX512-NEXT:    movq %rcx, %rsi
; AVX512-NEXT:    subq %rax, %rsi
; AVX512-NEXT:    setns %dl
; AVX512-NEXT:    movabsq $9223372036854775807, %r8 # imm = 0x7FFFFFFFFFFFFFFF
; AVX512-NEXT:    addq %r8, %rdx
; AVX512-NEXT:    subq %rax, %rcx
; AVX512-NEXT:    cmovoq %rdx, %rcx
; AVX512-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX512-NEXT:    xorl %edi, %edi
; AVX512-NEXT:    movq %rsi, %rdx
; AVX512-NEXT:    subq %rax, %rdx
; AVX512-NEXT:    setns %dil
; AVX512-NEXT:    addq %r8, %rdi
; AVX512-NEXT:    subq %rax, %rsi
; AVX512-NEXT:    cmovoq %rdi, %rsi
; AVX512-NEXT:    vmovq %rsi, %xmm0
; AVX512-NEXT:    vmovq %rcx, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vpsraq $32, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %z = call <2 x i32> @llvm.ssub.sat.v2i32(<2 x i32> %x, <2 x i32> %y)
  ret <2 x i32> %z
}

define <4 x i24> @v4i24(<4 x i24> %x, <4 x i24> %y) nounwind {
; SSE2-LABEL: v4i24:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $8, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    pslld $8, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,2,3]
; SSE2-NEXT:    movd %xmm2, %r8d
; SSE2-NEXT:    xorl %edx, %edx
; SSE2-NEXT:    movl %r8d, %esi
; SSE2-NEXT:    subl %ecx, %esi
; SSE2-NEXT:    setns %dl
; SSE2-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %ecx, %r8d
; SSE2-NEXT:    cmovol %edx, %r8d
; SSE2-NEXT:    movd %xmm1, %edx
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    xorl %esi, %esi
; SSE2-NEXT:    movl %ecx, %edi
; SSE2-NEXT:    subl %edx, %edi
; SSE2-NEXT:    setns %sil
; SSE2-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %edx, %ecx
; SSE2-NEXT:    cmovol %esi, %ecx
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm2, %edx
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    xorl %edi, %edi
; SSE2-NEXT:    movl %eax, %esi
; SSE2-NEXT:    subl %edx, %esi
; SSE2-NEXT:    setns %dil
; SSE2-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %edx, %eax
; SSE2-NEXT:    cmovol %edi, %eax
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE2-NEXT:    movd %xmm1, %r9d
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, %edx
; SSE2-NEXT:    xorl %edi, %edi
; SSE2-NEXT:    movl %edx, %esi
; SSE2-NEXT:    subl %r9d, %esi
; SSE2-NEXT:    setns %dil
; SSE2-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE2-NEXT:    subl %r9d, %edx
; SSE2-NEXT:    cmovol %edi, %edx
; SSE2-NEXT:    movd %edx, %xmm0
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    movd %ecx, %xmm0
; SSE2-NEXT:    movd %r8d, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    psrad $8, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i24:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pslld $8, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %ecx
; SSSE3-NEXT:    pslld $8, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %r8d
; SSSE3-NEXT:    xorl %edx, %edx
; SSSE3-NEXT:    movl %r8d, %esi
; SSSE3-NEXT:    subl %ecx, %esi
; SSSE3-NEXT:    setns %dl
; SSSE3-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %ecx, %r8d
; SSSE3-NEXT:    cmovol %edx, %r8d
; SSSE3-NEXT:    movd %xmm1, %edx
; SSSE3-NEXT:    movd %xmm0, %ecx
; SSSE3-NEXT:    xorl %esi, %esi
; SSSE3-NEXT:    movl %ecx, %edi
; SSSE3-NEXT:    subl %edx, %edi
; SSSE3-NEXT:    setns %sil
; SSSE3-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %edx, %ecx
; SSSE3-NEXT:    cmovol %esi, %ecx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,0,1]
; SSSE3-NEXT:    movd %xmm2, %edx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movd %xmm2, %eax
; SSSE3-NEXT:    xorl %edi, %edi
; SSSE3-NEXT:    movl %eax, %esi
; SSSE3-NEXT:    subl %edx, %esi
; SSSE3-NEXT:    setns %dil
; SSSE3-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %edx, %eax
; SSSE3-NEXT:    cmovol %edi, %eax
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSSE3-NEXT:    movd %xmm1, %r9d
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSSE3-NEXT:    movd %xmm0, %edx
; SSSE3-NEXT:    xorl %edi, %edi
; SSSE3-NEXT:    movl %edx, %esi
; SSSE3-NEXT:    subl %r9d, %esi
; SSSE3-NEXT:    setns %dil
; SSSE3-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSSE3-NEXT:    subl %r9d, %edx
; SSSE3-NEXT:    cmovol %edi, %edx
; SSSE3-NEXT:    movd %edx, %xmm0
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSSE3-NEXT:    movd %ecx, %xmm0
; SSSE3-NEXT:    movd %r8d, %xmm2
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSSE3-NEXT:    psrad $8, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i24:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pslld $8, %xmm1
; SSE41-NEXT:    pextrd $3, %xmm1, %ecx
; SSE41-NEXT:    pslld $8, %xmm0
; SSE41-NEXT:    pextrd $3, %xmm0, %r8d
; SSE41-NEXT:    xorl %edx, %edx
; SSE41-NEXT:    movl %r8d, %esi
; SSE41-NEXT:    subl %ecx, %esi
; SSE41-NEXT:    setns %dl
; SSE41-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %ecx, %r8d
; SSE41-NEXT:    cmovol %edx, %r8d
; SSE41-NEXT:    pextrd $2, %xmm1, %edx
; SSE41-NEXT:    pextrd $2, %xmm0, %ecx
; SSE41-NEXT:    xorl %esi, %esi
; SSE41-NEXT:    movl %ecx, %edi
; SSE41-NEXT:    subl %edx, %edi
; SSE41-NEXT:    setns %sil
; SSE41-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %edx, %ecx
; SSE41-NEXT:    cmovol %esi, %ecx
; SSE41-NEXT:    movd %xmm1, %edx
; SSE41-NEXT:    movd %xmm0, %eax
; SSE41-NEXT:    xorl %edi, %edi
; SSE41-NEXT:    movl %eax, %esi
; SSE41-NEXT:    subl %edx, %esi
; SSE41-NEXT:    setns %dil
; SSE41-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %edx, %eax
; SSE41-NEXT:    cmovol %edi, %eax
; SSE41-NEXT:    pextrd $1, %xmm1, %r9d
; SSE41-NEXT:    pextrd $1, %xmm0, %edx
; SSE41-NEXT:    xorl %edi, %edi
; SSE41-NEXT:    movl %edx, %esi
; SSE41-NEXT:    subl %r9d, %esi
; SSE41-NEXT:    setns %dil
; SSE41-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; SSE41-NEXT:    subl %r9d, %edx
; SSE41-NEXT:    cmovol %edi, %edx
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    pinsrd $1, %edx, %xmm0
; SSE41-NEXT:    pinsrd $2, %ecx, %xmm0
; SSE41-NEXT:    pinsrd $3, %r8d, %xmm0
; SSE41-NEXT:    psrad $8, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: v4i24:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslld $8, %xmm1, %xmm1
; AVX-NEXT:    vpextrd $3, %xmm1, %ecx
; AVX-NEXT:    vpslld $8, %xmm0, %xmm0
; AVX-NEXT:    vpextrd $3, %xmm0, %r9d
; AVX-NEXT:    xorl %edx, %edx
; AVX-NEXT:    movl %r9d, %esi
; AVX-NEXT:    subl %ecx, %esi
; AVX-NEXT:    setns %dl
; AVX-NEXT:    addl $2147483647, %edx # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %ecx, %r9d
; AVX-NEXT:    cmovol %edx, %r9d
; AVX-NEXT:    vpextrd $2, %xmm1, %edx
; AVX-NEXT:    vpextrd $2, %xmm0, %ecx
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %ecx, %edi
; AVX-NEXT:    subl %edx, %edi
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %edx, %ecx
; AVX-NEXT:    cmovol %esi, %ecx
; AVX-NEXT:    vmovd %xmm1, %r8d
; AVX-NEXT:    vmovd %xmm0, %edx
; AVX-NEXT:    xorl %edi, %edi
; AVX-NEXT:    movl %edx, %esi
; AVX-NEXT:    subl %r8d, %esi
; AVX-NEXT:    setns %dil
; AVX-NEXT:    addl $2147483647, %edi # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %r8d, %edx
; AVX-NEXT:    cmovol %edi, %edx
; AVX-NEXT:    vpextrd $1, %xmm1, %r8d
; AVX-NEXT:    vpextrd $1, %xmm0, %eax
; AVX-NEXT:    xorl %esi, %esi
; AVX-NEXT:    movl %eax, %edi
; AVX-NEXT:    subl %r8d, %edi
; AVX-NEXT:    setns %sil
; AVX-NEXT:    addl $2147483647, %esi # imm = 0x7FFFFFFF
; AVX-NEXT:    subl %r8d, %eax
; AVX-NEXT:    cmovol %esi, %eax
; AVX-NEXT:    vmovd %edx, %xmm0
; AVX-NEXT:    vpinsrd $1, %eax, %xmm0, %xmm0
; AVX-NEXT:    vpinsrd $2, %ecx, %xmm0, %xmm0
; AVX-NEXT:    vpinsrd $3, %r9d, %xmm0, %xmm0
; AVX-NEXT:    vpsrad $8, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <4 x i24> @llvm.ssub.sat.v4i24(<4 x i24> %x, <4 x i24> %y)
  ret <4 x i24> %z
}

define <2 x i128> @v2i128(<2 x i128> %x, <2 x i128> %y) nounwind {
; SSE-LABEL: v2i128:
; SSE:       # %bb.0:
; SSE-NEXT:    pushq %r15
; SSE-NEXT:    pushq %r14
; SSE-NEXT:    pushq %r13
; SSE-NEXT:    pushq %r12
; SSE-NEXT:    pushq %rbx
; SSE-NEXT:    movq %rdi, %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r14
; SSE-NEXT:    subq {{[0-9]+}}(%rsp), %rcx
; SSE-NEXT:    movq %r8, %r13
; SSE-NEXT:    sbbq %r14, %r13
; SSE-NEXT:    movq %r13, %r10
; SSE-NEXT:    sarq $63, %r10
; SSE-NEXT:    xorl %edi, %edi
; SSE-NEXT:    testq %r13, %r13
; SSE-NEXT:    setns %dil
; SSE-NEXT:    movabsq $9223372036854775807, %r12 # imm = 0x7FFFFFFFFFFFFFFF
; SSE-NEXT:    leaq (%rdi,%r12), %r15
; SSE-NEXT:    testq %r8, %r8
; SSE-NEXT:    setns %r8b
; SSE-NEXT:    cmpb %dil, %r8b
; SSE-NEXT:    setne %dil
; SSE-NEXT:    testq %r14, %r14
; SSE-NEXT:    setns %bl
; SSE-NEXT:    cmpb %bl, %r8b
; SSE-NEXT:    setne %bl
; SSE-NEXT:    testb %dil, %bl
; SSE-NEXT:    cmoveq %r13, %r15
; SSE-NEXT:    cmoveq %rcx, %r10
; SSE-NEXT:    subq %r9, %rsi
; SSE-NEXT:    movq %rdx, %rdi
; SSE-NEXT:    sbbq %r11, %rdi
; SSE-NEXT:    setns %bl
; SSE-NEXT:    movzbl %bl, %ebx
; SSE-NEXT:    addq %rbx, %r12
; SSE-NEXT:    movq %rdi, %rcx
; SSE-NEXT:    sarq $63, %rcx
; SSE-NEXT:    testq %r11, %r11
; SSE-NEXT:    setns %r8b
; SSE-NEXT:    testq %rdx, %rdx
; SSE-NEXT:    setns %dl
; SSE-NEXT:    cmpb %r8b, %dl
; SSE-NEXT:    setne %r8b
; SSE-NEXT:    cmpb %bl, %dl
; SSE-NEXT:    setne %dl
; SSE-NEXT:    testb %dl, %r8b
; SSE-NEXT:    cmoveq %rsi, %rcx
; SSE-NEXT:    cmoveq %rdi, %r12
; SSE-NEXT:    movq %r15, 24(%rax)
; SSE-NEXT:    movq %r10, 16(%rax)
; SSE-NEXT:    movq %r12, 8(%rax)
; SSE-NEXT:    movq %rcx, (%rax)
; SSE-NEXT:    popq %rbx
; SSE-NEXT:    popq %r12
; SSE-NEXT:    popq %r13
; SSE-NEXT:    popq %r14
; SSE-NEXT:    popq %r15
; SSE-NEXT:    retq
;
; AVX-LABEL: v2i128:
; AVX:       # %bb.0:
; AVX-NEXT:    pushq %r15
; AVX-NEXT:    pushq %r14
; AVX-NEXT:    pushq %r13
; AVX-NEXT:    pushq %r12
; AVX-NEXT:    pushq %rbx
; AVX-NEXT:    movq %rdi, %rax
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %r14
; AVX-NEXT:    subq {{[0-9]+}}(%rsp), %rcx
; AVX-NEXT:    movq %r8, %r13
; AVX-NEXT:    sbbq %r14, %r13
; AVX-NEXT:    movq %r13, %r10
; AVX-NEXT:    sarq $63, %r10
; AVX-NEXT:    xorl %edi, %edi
; AVX-NEXT:    testq %r13, %r13
; AVX-NEXT:    setns %dil
; AVX-NEXT:    movabsq $9223372036854775807, %r12 # imm = 0x7FFFFFFFFFFFFFFF
; AVX-NEXT:    leaq (%rdi,%r12), %r15
; AVX-NEXT:    testq %r8, %r8
; AVX-NEXT:    setns %r8b
; AVX-NEXT:    cmpb %dil, %r8b
; AVX-NEXT:    setne %dil
; AVX-NEXT:    testq %r14, %r14
; AVX-NEXT:    setns %bl
; AVX-NEXT:    cmpb %bl, %r8b
; AVX-NEXT:    setne %bl
; AVX-NEXT:    testb %dil, %bl
; AVX-NEXT:    cmoveq %r13, %r15
; AVX-NEXT:    cmoveq %rcx, %r10
; AVX-NEXT:    subq %r9, %rsi
; AVX-NEXT:    movq %rdx, %rdi
; AVX-NEXT:    sbbq %r11, %rdi
; AVX-NEXT:    setns %bl
; AVX-NEXT:    movzbl %bl, %ebx
; AVX-NEXT:    addq %rbx, %r12
; AVX-NEXT:    movq %rdi, %rcx
; AVX-NEXT:    sarq $63, %rcx
; AVX-NEXT:    testq %r11, %r11
; AVX-NEXT:    setns %r8b
; AVX-NEXT:    testq %rdx, %rdx
; AVX-NEXT:    setns %dl
; AVX-NEXT:    cmpb %r8b, %dl
; AVX-NEXT:    setne %r8b
; AVX-NEXT:    cmpb %bl, %dl
; AVX-NEXT:    setne %dl
; AVX-NEXT:    testb %dl, %r8b
; AVX-NEXT:    cmoveq %rsi, %rcx
; AVX-NEXT:    cmoveq %rdi, %r12
; AVX-NEXT:    movq %r15, 24(%rax)
; AVX-NEXT:    movq %r10, 16(%rax)
; AVX-NEXT:    movq %r12, 8(%rax)
; AVX-NEXT:    movq %rcx, (%rax)
; AVX-NEXT:    popq %rbx
; AVX-NEXT:    popq %r12
; AVX-NEXT:    popq %r13
; AVX-NEXT:    popq %r14
; AVX-NEXT:    popq %r15
; AVX-NEXT:    retq
  %z = call <2 x i128> @llvm.ssub.sat.v2i128(<2 x i128> %x, <2 x i128> %y)
  ret <2 x i128> %z
}
