; Test basic address sanitizer instrumentation.
; Generic code is covered by ../basic.ll, only the x86_64 specific code is
; tested here.
;
; RUN: opt < %s -hwasan -hwasan-recover=0 -S | FileCheck %s  --check-prefixes=CHECK,ABORT
; RUN: opt < %s -hwasan -hwasan-recover=1 -S | FileCheck %s  --check-prefixes=CHECK,RECOVER

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i8 @test_load8(i8* %a) sanitize_hwaddress {
; CHECK-LABEL: @test_load8(
; CHECK: %[[A:[^ ]*]] = ptrtoint i8* %a to i64

; ABORT: call void asm sideeffect "int3\0Anopl 64(%rax)", "{rdi}"(i64 %[[A]])
; ABORT: unreachable
; RECOVER: call void asm sideeffect "int3\0Anopl 96(%rax)", "{rdi}"(i64 %[[A]])
; RECOVER: br label

; CHECK: %[[A:[^ ]*]] = ptrtoint i8* %a to i64
; CHECK: %[[UNTAGGED:[^ ]*]] = and i64 %[[A]], 72057594037927935
; CHECK: %[[UNTAGGED_PTR:[^ ]*]] = inttoptr i64 %[[UNTAGGED]] to i8*
; CHECK: %[[G:[^ ]*]] = load i8, i8* %[[UNTAGGED_PTR]], align 4
; CHECK: ret i8 %[[G]]

entry:
  %b = load i8, i8* %a, align 4
  ret i8 %b
}

define i40 @test_load40(i40* %a) sanitize_hwaddress {
; CHECK-LABEL: @test_load40(
; CHECK: %[[A:[^ ]*]] = ptrtoint i40* %a to i64

; ABORT: call void @__hwasan_loadN(i64 %[[A]], i64 5)
; RECOVER: call void @__hwasan_loadN_noabort(i64 %[[A]], i64 5)

; CHECK: %[[A:[^ ]*]] = ptrtoint i40* %a to i64
; CHECK: %[[UNTAGGED:[^ ]*]] = and i64 %[[A]], 72057594037927935
; CHECK: %[[UNTAGGED_PTR:[^ ]*]] = inttoptr i64 %[[UNTAGGED]] to i40*
; CHECK: %[[B:[^ ]*]] = load i40, i40* %[[UNTAGGED_PTR]]
; CHECK: ret i40 %[[B]]

entry:
  %b = load i40, i40* %a, align 4
  ret i40 %b
}

define void @test_store8(i8* %a, i8 %b) sanitize_hwaddress {
; CHECK-LABEL: @test_store8(
; CHECK: %[[A:[^ ]*]] = ptrtoint i8* %a to i64

; ABORT: call void asm sideeffect "int3\0Anopl 80(%rax)", "{rdi}"(i64 %[[A]])
; ABORT: unreachable
; RECOVER: call void asm sideeffect "int3\0Anopl 112(%rax)", "{rdi}"(i64 %[[A]])
; RECOVER: br label

; CHECK: %[[A:[^ ]*]] = ptrtoint i8* %a to i64
; CHECK: %[[UNTAGGED:[^ ]*]] = and i64 %[[A]], 72057594037927935
; CHECK: %[[UNTAGGED_PTR:[^ ]*]] = inttoptr i64 %[[UNTAGGED]] to i8*
; CHECK: store i8 %b, i8* %[[UNTAGGED_PTR]], align 4
; CHECK: ret void

entry:
  store i8 %b, i8* %a, align 4
  ret void
}

define void @test_store40(i40* %a, i40 %b) sanitize_hwaddress {
; CHECK-LABEL: @test_store40(
; CHECK: %[[A:[^ ]*]] = ptrtoint i40* %a to i64

; ABORT: call void @__hwasan_storeN(i64 %[[A]], i64 5)
; RECOVER: call void @__hwasan_storeN_noabort(i64 %[[A]], i64 5)

; CHECK: %[[A:[^ ]*]] = ptrtoint i40* %a to i64
; CHECK: %[[UNTAGGED:[^ ]*]] = and i64 %[[A]], 72057594037927935
; CHECK: %[[UNTAGGED_PTR:[^ ]*]] = inttoptr i64 %[[UNTAGGED]] to i40*
; CHECK: store i40 %b, i40* %[[UNTAGGED_PTR]]
; CHECK: ret void

entry:
  store i40 %b, i40* %a, align 4
  ret void
}

define void @test_store_unaligned(i64* %a, i64 %b) sanitize_hwaddress {
; CHECK-LABEL: @test_store_unaligned(
; CHECK: %[[A:[^ ]*]] = ptrtoint i64* %a to i64

; ABORT: call void @__hwasan_storeN(i64 %[[A]], i64 8)
; RECOVER: call void @__hwasan_storeN_noabort(i64 %[[A]], i64 8)

; CHECK: %[[A:[^ ]*]] = ptrtoint i64* %a to i64
; CHECK: %[[UNTAGGED:[^ ]*]] = and i64 %[[A]], 72057594037927935
; CHECK: %[[UNTAGGED_PTR:[^ ]*]] = inttoptr i64 %[[UNTAGGED]] to i64*
; CHECK: store i64 %b, i64* %[[UNTAGGED_PTR]], align 4
; CHECK: ret void

entry:
  store i64 %b, i64* %a, align 4
  ret void
}
